/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#include "qdbtslidebar.h"

QdbtSlideBar::QdbtSlideBar(QWidget *parent,const char *name) 
  :  QWidget(0,name,WType_Popup)
{
  setBackgroundColor(black);
  controlWidget=parent;
  barWidth=6;
  setCursor(sizeHorCursor);
}

QdbtSlideBar::~QdbtSlideBar()
{
}

void QdbtSlideBar::mouseReleaseEvent(QMouseEvent *)
{
  hide();
  QPoint spos(sliderXPos,0);
  emit sliderPos(controlWidget->mapFromGlobal(spos).x());
}

void QdbtSlideBar::mouseMoveEvent(QMouseEvent *e)
{
  updateBar(mapToGlobal(e->pos())); 
}

void QdbtSlideBar::setBounds(const QRect &b)
{
  bounds=b;
  setGeometry(b.x(),b.y(),barWidth,b.height()); 
}

void QdbtSlideBar::updateBar(const QPoint &mp)
{
  QPoint globalMousePos(mp.x()-width()/2,mp.y());
  QPoint nullPoint(0,bounds.y());
  QPoint globalWidgetPos=controlWidget->mapToGlobal(nullPoint);
  int xp=globalMousePos.x();
  int yp=globalWidgetPos.y();
  int minX=globalWidgetPos.x()+bounds.x();
  int maxX=minX+bounds.width()-width();
  if (xp<minX) xp=minX;
  if (xp>maxX) xp=maxX; 
  sliderXPos=xp-bounds.x()-width()/2;
  move(xp,yp);
}
