/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QDBTSECTION_H
#define _QDBTSECTION_H

#include <qpushbt.h>

class QdbtSection : public QPushButton
{
  Q_OBJECT

  public:
    QdbtSection(QWidget *parent=0,const char *name=0);
    QdbtSection(const char *text,QWidget *parent=0,const char *name=0);
   ~QdbtSection();
    virtual int widthHint() const;
    virtual int heightHint() const;
    void setAlignment(int alignment) { align=alignment; }
    int  alignment() const { return align; }
    void setResizable(bool enable);
    bool isResizable() const { return resizable; }

  protected:
    virtual void resizeEvent(QResizeEvent *);
    virtual void drawButton(QPainter *p);
    virtual void drawButtonLabel(QPainter *p);
    virtual void mousePressEvent(QMouseEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    virtual void mouseMoveEvent(QMouseEvent *);
    virtual void keyPressEvent(QKeyEvent *);

  signals:
    void clicked(QdbtSection *);
    void setResizable(QdbtSection *,bool);

  private:
    const int colSpacing;
    int   align;
    bool  resizable;
};

#endif
