/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#include <qpainter.h>
#include "qdbtlined.h"
#include "qdbttable.h"

QdbtLineEdit::QdbtLineEdit(QWidget *parent,const char *name) :
  QLineEdit(parent,name)
{
  setFrame(FALSE);
}

QdbtLineEdit::~QdbtLineEdit()
{
}

void QdbtLineEdit::paintEvent(QPaintEvent *e)
{
  QLineEdit::paintEvent(e);
  QPainter p;
  p.begin(this);
  p.setPen(colorGroup().text());
  p.drawRect(rect());
  p.end();
}

void QdbtLineEdit::paletteChange(const QPalette &)
{
}

void QdbtLineEdit::setColor(const QColor &foreground,const QColor &background)
{
  fg=foreground;
  bg=background; 
  setSelected(FALSE,TRUE);
}

void QdbtLineEdit::setSelected(bool b,bool force)
{
  if (b==selected && !force) return;
  QColorGroup cg=colorGroup();
  if (b)
  {
    QColorGroup newcg(bg,fg,cg.light(),cg.dark(),cg.mid(),bg,fg);
    setPalette(QPalette(newcg,newcg,newcg));
    setBackgroundColor(bg);
  }
  else
  {
    QColorGroup newcg(fg,bg,cg.light(),cg.dark(),cg.mid(),fg,bg);
    setPalette(QPalette(newcg,newcg,newcg));
    setBackgroundColor(bg);
  }
  selected=b;
}

void QdbtLineEdit::focusInEvent(QFocusEvent *e)
{
  ((QdbtTable *)parentWidget())->focusInEvent(e);
}

void QdbtLineEdit::focusOutEvent(QFocusEvent *e)
{
  ((QdbtTable *)parentWidget())->focusOutEvent(e);
}

void QdbtLineEdit::keyPressEvent(QKeyEvent *e)
{
  QLineEdit::keyPressEvent(e);
  e->accept();
}
