/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QDBTTABULAR_H
#define _QDBTTABULAR_H

#include <qframe.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qlist.h>
#include <qsize.h>

// some internal classes used to implement this widget

class QdbtTableCell;
class QdbtSlideBar;
class QdbtHeader;
class QdbtTable;
class QdbtSection;

class QdbtTabular : public QFrame
{
  friend class QdbtHeader;
  friend class QdbtTable;
  friend class QdbtSection;

  Q_OBJECT

  public:
    QdbtTabular(QWidget *parent=0,const char *name=0,WFlags w=0);
   ~QdbtTabular(); 
    
    void setHeaderFont(const QFont &font);
    const QFont &headerFont() const;
    void setCellFont(const QFont &font);
    const QFont &cellFont() const;
    void setDimensions(int rows,int cols);
    void setColumnWidth(int col,int width); 
    void changeSection(QdbtSection *section,int col);
    QdbtSection *section(int col);
    void insertRow(int row=-1,bool selectable=TRUE);
    void removeRow(int row);
    void insertCol(int col=-1);
    void removeCol(int col);
    void clear() { setDimensions(0,0); }
    int  numRows() const;
    int  numCols() const;
    void changeCell(const QdbtTableCell *tc,int row,int col);
    void changeCell(const char *text,const QPixmap *p,int row,int col,
                    const QColor &color=black,
                    int align=AlignLeft,bool editable=FALSE);
    void changeCell(const char *text,int row,int col,
                    const QColor &color=black,
                    int align=AlignLeft,bool editable=FALSE);
    void changeCell(const QPixmap *pixmap,int row,int col,
                    int align=AlignLeft);
    void showHeader();
    void hideHeader();
    bool headerVisible() const;
    int  columnWidth(int col) const;
    int  rowHeight(int row) const;
    int  columnWidthHint(int col) const;
    const QdbtTableCell *cell(int row,int col);
    bool rowSelected(int row) const;
    void setRowSelected(int row,bool enable);
    void setAutoUpdate(bool state);
    bool autoUpdate() const;
    void update();
    QSize sizeHint() const;
    void enableTooltips();
    void disableTooltips();
    void selectByRow(bool enable);
    bool rowSelectable(int row) const;
    void setRowSelectable(int row,bool enable);
    void editCell(int row,int col);
    void exposeCell(int row,int col);
    void fitAll();

  signals:
    void sectionClicked(int col);
    void selected(int row,bool state);
    void activated(int row);
    void cellEdited(int row,int col);
    void cellSelected(int row,int col,bool state);
    void cellActivated(int row,int col);

  protected:
    virtual void resizeEvent(QResizeEvent *);
    virtual void drawContents(QPainter *);
    virtual void enterTableEvent(QEvent *);
    virtual void leaveTableEvent(QEvent *);
    virtual void setPalette(const QPalette &);
    QSize cellSize(int row,int col) const;
    QPoint cellOffset(int row,int col) const;
    int xOffset() const;
    int yOffset() const;
    int findRow(int yPos) const;
    int findCol(int xPos) const;
    int headerHeight() const;

  private:
    void           startSlideBar(int minx,int xpos);
    QdbtSlideBar  *slideBar;
    QdbtHeader    *header;
    QdbtTable     *table;
    bool           headerActive;
};

#endif // QTABULAR_H
