/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QDBTTABLECELL_H
#define _QDBTTABLECELL_H

#include <qpixmap.h>
#include <qstring.h>
#include <qlist.h>
#include <qpainter.h>
#include <qrect.h>

class QdbtLineEdit;

class QdbtTableCell
{
  friend class QdbtTable;
  enum BarType { NoBar, Bar };
  
  public:
    QdbtTableCell();
    QdbtTableCell(const char *text,const QPixmap *pixmap,
               const QColor &color=black,int align=AlignLeft,
               bool edit=FALSE);
    virtual ~QdbtTableCell();

    void setText(const char *text) 
        { if (text) txt = ((QString)text).stripWhiteSpace(); else txt=""; }
    const char *text() const { return txt; }

    void setPixmap(const QPixmap *pixmap) 
        { if (pixmap) pmap=*pixmap; else pmap=QPixmap(); } 
    const QPixmap &pixmap() const { return pmap; }

    void setColor(const QColor &color) { col = color; }
    const QColor &color() const { return col; }

    void setBackground(const QColor &color) { bg = color; }
    const QColor &background() const { return bg; }
    
    void setEditable(bool state) { editable = state; }
    bool isEditable() const { return editable; }
    
    void setSelectable(bool enable) { selectable = enable; }
    bool isSelectable() const { return selectable; }
    
    void setSelected(bool enable) { selected = enable; }
    bool isSelected() const { return selected; }
    
    void setAlignment(int alignment) { align = alignment; }
    int alignment() const { return align; }

    void setPixmapAlignment(int alignment) { pmapAlign = alignment; }
    int pixmapAlignment() const { return pmapAlign; }

    virtual int widthHint(const QFontMetrics &fm) const;
    virtual int heightHint(const QFontMetrics &fm) const;

  protected:
    virtual void paint(QPainter *p,int w,int h,
                       bool rowSelected,bool selectByRow,bool editing=FALSE,
                       int focusBar=NoBar);
    virtual QRect getTextArea() const;
    virtual QRect getEditArea(int width) const;

  private:
    QPixmap pmap;
    QString txt;
    QColor  col;
    QColor  bg;
    QRect   tr;
    int     align;
    bool    editable;
    bool    selectable;
    bool    selected;
    int     pmapAlign;
};

typedef QList<QdbtTableCell> CellList;

#endif
