/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#include <stdio.h>
#include <stdlib.h>

#include <qapp.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qmenudta.h>

#include <qdbt/qdbttabcell.h>
#include <qdbt/qdbtsection.h>
#include "example3.h"

const int tableRows = 20;
const int tableCols = 8; 

const int border=5;

MySection::MySection(QWidget *parent,const char *name) 
  : QdbtSection(parent,name)
{
}

MySection::~MySection()
{
}

int MySection::widthHint() const
{
  return fontMetrics().height()+2*border;
}

int MySection::heightHint() const
{
  return fontMetrics().width(text())+2*border;
}

void MySection::drawButtonLabel(QPainter *p)
{
  QColorGroup g = colorGroup();
  p->setPen(g.text());
  p->translate(width()/2+border,height()-border);
  p->rotate(-90);
  p->drawText(0,0,text());
  p->resetXForm();
}

// constructor
Example::Example(QWidget *parent,const char *name, WFlags f) 
      : QWidget(parent,name,f)
{
  // Set the caption of the window
  setCaption("Example3");

  // The Layout managers
  QGridLayout *layout  = new QGridLayout(this,2,1,5);
  QBoxLayout  *buttons = new QBoxLayout(QBoxLayout::LeftToRight);
  
  // create three tables
  QdbtTabular *tabular=new QdbtTabular(this);

  // set the number of row/columns
  tabular->setDimensions(tableRows,tableCols);
 
  // set the minimum size of the table
  tabular->setMinimumSize(200,200);

  // select cell instead of rows
  tabular->selectByRow(FALSE);

  // set the font of the heading
  tabular->setHeaderFont(QFont("helvetica",16,QFont::Bold));

  // set the font of the cells
  tabular->setCellFont(QFont("helvetica",12,QFont::Normal));

  int row,col;
  // for each column
  for (col=0;col<tableCols;col++)
  {
    QString head;
    head.sprintf("H%d",col);
    
    // set the heading of column `col'
    MySection *section=new MySection(tabular);
    section->setText(head);
    tabular->changeSection(section,col);
 
    // for each row
    for (row=0;row<tableRows;row++)
    {
      QdbtTableCell cell;
      QString cellName;
      cellName.sprintf("cell (%d,%d)",row,col);
      cell.setText(cellName);
      cell.setEditable(TRUE);
      // set the cell's text
      tabular->changeCell(&cell,row,col);
    }
  }

  // make sure all cells fit
  tabular->fitAll();

  // Create the close button
  QPushButton *close  = new QPushButton("Close",this);

  // Set its minimum sizes
  close ->setMinimumSize(close->sizeHint());

  // Add Widgets and layouts to the layout-manager
  layout->addWidget(tabular,0,0);
  layout->addLayout(buttons,1,0);
  layout->setColStretch(0,1); // make the table strechable
  layout->setRowStretch(0,1);

  // Add the Widget to the button layout
  buttons->addStretch(1);
  buttons->addWidget(close);

  // don't forget to activate the top layout manager
  layout->activate();

  // Let the close button quit the application
  connect(close,  SIGNAL(clicked()),qApp,SLOT(quit()));
  
  // Resize the widget to its minimal size
  resize(layout->mainWidget()->sizeHint());

}

// destructor
Example::~Example()
{
}

int main(int argc,char **argv)
{
  QApplication app(argc, argv);
  Example example;
  app.setMainWidget(&example);
  example.show();
  return app.exec();  
}
