/*----------------------------------------------------------------------------*/
/*                    additional stuff for OS/2                               */
/*                      Axel Rohde, June 1994                                 */
/*----------------------------------------------------------------------------*/

#define INCL_DOSSESMGR
#define INCL_DOSMISC
#define INCL_DOSPROCESS
#define INCL_WINWINDOWMGR
#define INCL_WINSYS

#include <os2emx.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define PATH "PATH"


char *SearchPath(char *Name)
{
  ULONG         rc;
  char          ResultBuffer[640];
  const UCHAR  *PathPointer;

        rc = DosScanEnv(PATH, &PathPointer);
        if (rc != 0)
                return NULL;

        rc = DosSearchPath(SEARCH_CUR_DIRECTORY + SEARCH_ENVIRONMENT, 
                           PATH,
                           Name,
                           ResultBuffer,
                           sizeof(ResultBuffer) );
        if (rc != 0)
                return NULL;
        else 
                return ResultBuffer;
}



ULONG startPMSession(void)
{
  extern char outputName[80];

  UCHAR         PgmName[256];
  UCHAR         PgmInputs[256];
  UCHAR         ObjBuf[100];

  STARTDATA     startDat;       /* Session start information                */
  ULONG         SessionID;      /*  Session and Process ID for new session, */
                                /*  ULONG for GCC */
  PID           ProcessID; 
  USHORT        rc;

  /* ---- init startDat struct defaults */
  startDat.Length       = sizeof (STARTDATA);
  startDat.Related      = SSF_RELATED_CHILD;
  startDat.FgBg         = SSF_FGBG_FORE;
  startDat.TraceOpt     = SSF_TRACEOPT_NONE;
  startDat.PgmTitle     = NULL;

  strcpy(PgmInputs, "SURFOS2.TMP /D -B /O ");
  strcat(PgmInputs, outputName);
  startDat.PgmInputs    = PgmInputs;

  startDat.TermQ        = NULL;
  startDat.Environment  = NULL;
  startDat.InheritOpt   = SSF_INHERTOPT_PARENT;
  startDat.SessionType  = SSF_TYPE_PM;
  startDat.PgmControl   = SSF_CONTROL_VISIBLE;
  startDat.InitXPos     = 0;
  startDat.InitYPos     = 0;
  startDat.InitXSize    = 0;
  startDat.InitYSize    = 0;
  startDat.IconFile     = 0;
  startDat.PgmHandle    = 0;
  startDat.Reserved     = 0;
  startDat.ObjectBuffer = ObjBuf;
  startDat.ObjectBuffLen = 100;
  startDat.PgmName      = SearchPath("SURF_PM.EXE");

  if (startDat.PgmName == NULL)
        return 0;

  rc = DosStartSession(&startDat, &SessionID, &ProcessID);
  if ( rc == 0)
        return SessionID;
  else return 0;
}

ULONG stopPMSession(ULONG SessID)
{
 DosStopSession(STOP_SESSION_SPECIFIED, SessID);
}


/* error file stuff for surf_pm */

FILE *openErrFile(char *fname)
{
        FILE *fptr;

        unlink(fname);
        fptr = fopen(fname,"w");
        if (fptr==NULL)
               {
                perror("Unable to open output file GLEOS2.ERR");
                return NULL;
               }
        else return fptr;
}

int closeErrFile(FILE *errfile)
{
        if (fclose(errfile)!=0) 
                perror("Unable to close output file GLEOS2.ERR");
}

int peekMsg(void)
{
        extern HAB hab;
        extern QMSG qmsg;

        if (WinPeekMsg(hab, &qmsg, 0, 0, 0, PM_NOREMOVE))
                {
                WinGetMsg(hab, &qmsg, 0, 0, 0);
                WinDispatchMsg(hab, &qmsg);
                }
}
