#
#  			config.i for Linux
#
#	 by Axel Rohde (rohde@physik.uni-kiel.d400.de)
#
#  	 see below for a description of compiler flags


CC = gcc -O2 -s -m486 -fomit-frame-pointer


# 	For NCURSES 1.8.1 or higher (recommended):
#
# If you use the Slackware distribution, the header files of the ncurses
# library are located in /usr/include/ncurses since Linux has another
# curses library installed as standard
#
LIBS   = -lm -lncurses -lc
XLIBS  = -lm -lX11 -lncurses -lc
CFLAGS = -Dunix -DLINUXFKEY -DGOTSTRDUP -DNOKEYPAD\
	 -I/usr/include/ncurses



# 	For simple curses (not recommended):
#
#LIBS =	 -lm -lcurses -lc 
#XLIBS = -lm -lX11 -lcurses -lc 
#CFLAGS= -Dunix -DNOKEYPAD -DNOATTRIB -DLINUXFKEY -DMANIPCURPOS


#ifdef windows
XGLE = gle_x
DXO = ../../d_x.o
XSURF = surf_x
#endif

GLE_PATH=/usr/local/gle

###########################################################################
#	The meaning of compiler flags:
###########################################################################
#
# -Dunix
#	The system is unix-like.
#
# -DBIGINDIAN
#	Descibes the byte-ordering of your hardware.
#
# -DINT32
#	Use this flag, if your machine is 64 bit
#
# -DNOKEYPAD
#	Use this flag, if function-keys don't work after compiling gle.
#	Recommended!
#
# -DNOATTRIB
#	Use this flag, if your curses library is dumb an some features
#	like switching attributes (bold, inverse, colours, etc.)
#	are missing. See -DMANIPCURPOS below.
#
#
# -DMANIPCURPOS
#	To let the status-line of MANIP show the currently manipulated
#	field. This is *very* useful, if you have to compile gle with
#	-DNOATTRIB. In this case, you have a dumb curses library, that
#	lacks a couple of features (and if you have time, try to get
#	the ncurses library).
#
# -DNOBACKINGSTORE
#	the usage of 'backingstore' is enabled as default setting to avoid,
#	that the X-Window System forgets the contents of gle_x' graphics
#	window, when it is hidden behind another window. Backingstore
#	needs RAM, therefore set -DNOBACKINGSTORE on systems with little
#	memory e.g. Linux with < 8MB. If the X Window server does not
#	support backingstore, gle_x does not use it.
#
# -DGOTSTRDUP
#	Set this flag, if your library already includes a strdup() call.
#	If you use gcc, this flag should work.
#
# -DLINUXFKEY
#	Usage of F1 - F4 instead of F11 .., in xterm with standard key
#	mapping.
#
# -DLINUX
#	Is obsolete. After compiling GLE under DOS and OS/2 using gcc
#	ports for these system, I replaced '#ifdef LINUX' statements with
#	'#ifdef __GNUC__'. __GNUC__ is automatically defined by GCC.
