

//***********************************************************************

#ifndef _WAVESIM_FUNC
#define _WAVESIM_FUNC

#include "membrasim.h"
#include "GL/gl.h"
#include "GL/glu.h"
#include "GL/glx.h"

#define v3f glVertex3f


//***********************************************************************


class simu_data 
{

public:
  
  int visu;                // POSITION_SIMU o VELOCITY_SIMU
  int zoom;                // 1 ... 8
  int skip;                // Frames que se saltan.  (1 ... 99)
  float scale_color;       // Factor de escala de color. (-999 ... 999)
  
  int thickness;           // Grosor del "Baston" deformador. (1 ...)
  float level;             // Nivel de la deformacion. (1 ...)

  int nx,ny;               // Dimension de la simulacion.
  int sx,sy;               // Tamao de la imagen.  
  int image_x,image_y;     // Posicion de la imagen.
  int mouse_x,mouse_y;     // Elemento del que se muestra la informacion.
  
  int steps;               // N de pasos transcurridos.
  
  rgb_str min_color,zero_color,max_color;
  
  rgb_str colors[2*SIMU_COLORS];
  XImage *image;  
  
  int *color_map;
    
  //*********************

  void crea();
  void destroy();

  void set_defaults();  
  void set_colors();

  void crea_color_map();
  void destroy_color_map() { if (color_map) free(color_map); }
  
  void crea_image();
  void destroy_image() { XDestroyImage(image); }
  void genera_image();
  void draw_image();

  void cambia_zoom(int a);
  
  void set_mouse(int x,int y) { mouse_x=x; mouse_y=y; }
  void show_info();
  
  void actualiza();
  
  void save(FILE *f);
  void load(FILE *f);
   
};


class main_data
{

public:

  int draw_tool;               // Herramienta de dibujo empleada.
  int fix_color,free_color;    // Colores empleados.
  
 //******************
  
  void set_defaults();
  
  void draw_point();
  void draw_line();
  void draw_rect();
  void draw_ellip();
  void fill();
  
  void save(FILE *f);
  void load(FILE *f);
  
};


class render_data
{

 public:
 
 int nx,ny;            // Dimension de la rejilla.
 int mode;             // Modo de Render. 
 GLenum primit;        // Primitiva utilizada en el Render.
 GLfloat lx,ly;        // Tamao Real de la rejilla en Coord. Universales.
 GLfloat zoom;         // Zoom.
 GLfloat hscale;       // Escalado del relieve.                  
 GLfloat dx,dy;        // Tamao de cada poligono.                                         
 
 GLfloat rx,ry,rz;     // Rotacion en los 3 ejes.

 GLfloat *malla;       // De dimension nx*ny
 
 //******************
 
 void set_defaults();
 void set_zoom(GLfloat z);
 void set_mode(int m);
 void set_hscale(GLfloat hs);
 
 void crea_malla();
 void destroy_malla();
 
 void init_render();
 void actualiza_render_mode();
 
 void genera_malla();
 void draw_malla();
 
 void actualiza() { genera_malla();draw_malla(); }
 
  
}; 



//**********************************************************************


extern const float scale_value[12];

extern int Noname_File;
extern int File_Modif;

extern int Param_Modif;
extern int Geom_Modif;

extern int Main_Show;
extern int Param_Show;
extern int Geom_Show;
extern int Simu_Show;
extern int Render_Show;
extern int Wave_Show;
extern int Help_Show;

extern int Simu_Play;
extern int Simu_Timeout_ID;

extern int drawing;
extern int mx1,my1,mx2,my2;


//***********************************************************************

extern char ruta_archivo[64];
extern char nombre_archivo[64];
extern char nombre_directory[64];

extern simu_data Simu_Data;
extern main_data Main_Data;
extern render_data Render_Data;
extern ecu_onda Simu_Onda;
extern cuadricula DBoard;


//***********************************************************************

void WSM_Set_Defaults();
int WSM_Warning_Destroy();
int WSM_Save();
int WSM_Load();

void Kick_Simu(int px,int py,int p);
int Add_Elem_Simu(int px,int py,float z);
void Play_Simu();
void Stop_Simu();

void Show_Main(int t);
void Show_Param(int t);
void Show_Geom(int t);
void Show_Simu(int t);
void Show_Render(int t);
void Show_Wave(int t);

void descomp_value(float *v,int *sc);
void Apply_Param();
void Set_Param();
void Set_Geom();
void Apply_Geom();
void Set_Simu();
void Set_Render();
void Set_Wave();

//***********************************************************************

#endif
