

//************************************************************************
//***************** Simulacion de Membranas planas. **********************
//************************************************************************
//***** By Txino. 1997 ***************************************************
//************************************************************************


#ifndef _MEBRA_SIM
#define _MEBRA_SIM

#include <stdlib.h>
#include "defs.h"



//************************************************************************
//****** CLASE CUADRICULA ==> ********************************************
//************************************************************************
//*** Es la base a partir de la cual se genera la matriz para la *********
//*** simulacion.                                                *********
//*** Contiene la informacion sobre los puntos fijos y libres de *********
//*** la membrana. Sobre ella se numeran los nodos de la malla.  *********
//************************************************************************

class cuadricula
{
 public:
  int nx,ny; 
  word *tabla;
  
  //*********************************************

  cuadricula() { tabla=NULL;nx=ny=0; }  
  cuadricula(int x,int y) { tabla=NULL;crea(x,y); }
  ~cuadricula() { destruye(); }
  
  crea(int x,int y);                    
  destruye() { delete tabla;nx=ny=0; }
  
  int get_nx() { return nx; }         // Devuelve el tamao X de la malla. 
  int get_ny() { return ny; }         // Devuelve el tamao Y de la malla.
  
  word get_elem(int x,int y);         // Devuelve el Num. de un nodo.
  
  void set_elem(int x,int y,word e);  // Asigna un valor a un nodo:  
                                      //                       = 0  nodo fijo
                                      //                      <> 0  nodo libre
  
  void clear();        // Libera todos los nodos, fijando el borde de la malla.
  
  int set_order();     // Numera los Nodos: Asigna Ns en orden creciente a los 
                       // elementos diferentes de cero y devuelve el ultimo.
  
  void load(FILE *f);    // Salva la malla en un fichero abierto.
  void save(FILE *f);    // Lee una malla desde un fichero abierto.

};



//***********************************************************************

class matriz_sparse;


//***********************************************************************
//******** CLASE VECTOR ==> *********************************************
//***********************************************************************
//***** Es la implementacion de un tipo de vectores Reales de Dim N. ****
//***** Se implemantan las operaciones necesarias para el uso poste- ****
//***** -rior en la simulacion (Con sobrecarga de operadores).       ****
//***********************************************************************                                      

class vector
{
 public:
  int N;
  float *dat;
  
  //*********************************************
  
  vector(int n,float v=0);
  ~vector() { delete dat; }
  
  int get_dim() { return N; }      // Devuelve la dimension del vector.                
 
  float  & operator [] (int i)     // Manipulacion de elementos del vector.
     { return dat[i]; }           
  
  vector & operator += (vector &v);          // Adicion.
  vector & operator -= (vector &v);          // Substraccion.
  vector & operator *= (float k);            // Producto por escalar.
  vector & operator *= (matriz_sparse &m);   // Producto por una matriz_sparse.
  vector & operator = (vector & v);          // Asignacion.
  vector & operator = (float v);             // Inicializacion a un escalar.
  
  float media();                             // Calcula la media de sus elementos.
  
};  


//***********************************************************************
//******** CLASE MATRIZ_SPARSE  ==> *************************************
//***********************************************************************
//***** Es la implementacion de matrices Reales Sparse de Dim NxN.   ****
//***** Cada fila tiene 5 elementos no nulos a lo sumo.              ****
//***** Se implemantan las operaciones necesarias para el uso poste- ****
//***** -rior en la simulacion (Con sobrecarga de operadores).       ****
//***********************************************************************                                      


class fila_sparse    // Se emplea en la clase matriz_sparse.
{
 public:
   float elem[4];
   word pos[4];
  
  fila_sparse(float v=0);
};  


class matriz_sparse
{ 
 public:
  int N;
  float *DP;
  fila_sparse *f;
    
  //*********************************************
  
  matriz_sparse(int n,float v=0);
  matriz_sparse(matriz_sparse &m) { matriz_sparse(m.N);*this=m; }
  ~matriz_sparse() { delete(DP);delete(f); }
  
  matriz_sparse & operator *= (vector &v);        
                         // Producto de los elementos por un escalar.
                  
  matriz_sparse & operator += (float k);          
                         // Suma a la DP de un escalar.
                  
  matriz_sparse & operator = (matriz_sparse &m); 
                         // Asignacion.
  
  int GaussSeidel(vector &B,vector&X,float MAX_ITE,float TOL);
                         // Algoritmo de Gauss-Seidel optimizado.  
                         // Devuelve el Num de iteraciones realizadas.
                         // Si no se alcanza la convergencia, devuelve -1.
    
};



//***********************************************************************
//******** CLASE ECU_ONDA ==> *******************************************
//***********************************************************************
//***** Es la implementacion de la simulacion de la membrana plana.  ****
//***** Las funciones fundamentales son las de generacion de la      ****
//****  del sistema a partir de una "cuadricula" y la posterior      ****
//****  preparacion para aplicar Gauss-Seidel.                       ****
//***********************************************************************                                      


enum _metodos_enum { NONE=0, IMPLICITO=1, EXPLICITO=2 };


class ecu_onda  
{
 public:
 
//****** Variables ******************* 

  int metodo;

  float k;             // Paso temporal.              
  float h;             // Paso espacial.  
  float mu;            // Coef. Rozamiento Dinamico. (Amortiguamiento)
  float tension;       // Tension uniforme.
  float ro;            // Densidad superficial ?    
  
  float landa,alfa;    // Coef. Precalculados. (Funcion de mu,ro,k,h)
  
  int  GS_MAX;         // Max. Num de iteraciones GAUSS-SEIDEL 
  float GS_TOL;        // Tolerancia Relativa de cada iteracion GAUSS-SEIDEL 
  float PASO_TOL;      // Tolerancia Relativa de cambio de Paso Temporal.
  
  int N;               // Numero de Nodos. (Num. de Variables en el sistema)
  float d_U;           // Norma Inf de la Diferencia entre 2 Iteraciones
  
  vector *U;           // Vectores Solucion (Actual y Anterior).
  vector *B;           // Vector de Terminos Independientes.
  vector *T;           // Vector de Tensiones Superficiales.
  matriz_sparse *matM; // Matriz del Sistema.


//****** Metodos de la clase *********    

  //***** Constructores y destructores.
  ecu_onda(int n=0);
  ~ecu_onda();

  //***** Asignacion y liberacion de memoria.
  void crea(int n);
  void destruye(); 
  
  
  //***** Ajuste y obtencion de parametros de la simulacion.
  
  
  void set_metodo(int m) { metodo=m; }
  void set_time_step(float a) { k=a; }
  void set_cuant_size(float a) { h=a; }
  void set_deaden(float a) { mu=a; }
  void set_density(float a) { ro=a; }
  void set_tension(float a);
  void set_GS_MAX(int a) { GS_MAX=a; }
  void set_GS_TOL(float a) { GS_TOL=a; }
  

  int get_metodo() { return metodo; }
  float get_time_step() { return k; }
  float get_cuant_size() { return h; }
  float get_deaden() { return mu; }
  float get_density() { return ro; }
  float get_tension() { return tension; }
  int get_GS_MAX() { return GS_MAX; }
  float get_GS_TOL() { return GS_TOL; }
  
  
  void set_toles(int gsm,float gst,float pasot=0) 
   { GS_MAX=gsm;GS_TOL=gst;PASO_TOL=pasot; }
  void set_param(float m,float tens,float r,float h0,float k0);
  
  
  //*********************************************
  
  void calcula_constants();         // Precalculo de algunas constantes
                                    // a partir de los parametros.
  
  void calcula_T(float v);          // Calculo del vector de tensiones.
  void calcula_M(cuadricula &cua);  // Calculo de la matriz del sistema.
  void prepara_sistema();           // Preparacion del sistema....

  void reset() { U[0]=0;U[1]=0; }   // Reset de la simulacion.
  
  int itera_U_exp();                // Itera usando un metodo explicito.  
  int itera_U_imp();                // Itera usando un metodo implicito.  
  int itera_U();                    // Dar un paso en la simulacion.   
    
  void load(FILE *f);               // Salvar parametros en un archivo.
  void save(FILE *f);               // Leer parametros de un archivo.
    
  //**** Sin implementar: 
  void calcula_d_U();               // Hallar estimacion del error local.
  void actualiza_k();               // Recalcular el paso de tiempo.

  
};  
  
  
//***********************************************************************  

#endif


//***********************************************************************
//***********************************************************************     
