/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk
    text converting <CR+LF> <-> <LF>

*/

#include <stdio.h>

int main(int argc, char **argv)
{
        FILE *in, *out;
        int n=2,c,mode,last;
	
	if (argc<=2) 
	{
                printf("Usage: textto [-c -l] file1, file2 ...\n\a");
		return 1;
	}        
        
	if (argv[1][1]=='l') mode = 0;
        else if (argv[1][1]=='c') mode = 1;
	else return;
	argc--;	
	if (argc<2) return;
	while (--argc)
        {
		if (!strcmp(argv[0], argv[n])) { continue; n++; }
                out = fopen("__ASD__", "wb");
                in  = fopen(argv[n], "rb");
		if (!in || !out) 
		{
                    perror(argv[n]);
		    exit(-1);
		}
                printf("Converting %s ... ", argv[n]);
		last = -1;
                while((c=fgetc(in))!=EOF)
                {
			if (mode==0 && c==13) continue;
			if (mode==1 && c==10 && last != 13) 
				if (fputc(13, out) == EOF) return -1;
                        if (fputc(c, out) == EOF) return -1;
			last = c;
                }
                fclose(in);
                fclose(out);
                rename("__ASD__", argv[n]);
                printf("done\n");
                n++;
        }
}
