/*
    FGLMESA:  An example of integrating FGL with Mesa for OpenGL programs
    Copyright (C) 1997  Sam Lantinga, 1999 Marian Krivos

    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com

    Marian Krivos
    nezmar@internet.alcatel.sk
*/

#ifndef _FGL_Mesa_h
#define _FGL_Mesa_h

/* This integrates with Mesa using the OSMesa extensions for GL output */

#include "base.h"
#ifndef WINGDIAPI
#define WINGDIAPI extern
#define APIENTRY
#endif    
#include "GL/osmesa.h"

#ifdef __cplusplus
extern "C" {
#endif

/* The context structure used by FGLMesa */
typedef struct FGLmesa_context {
	FGPixel *surface;
	OSMesaContext context;
	int w,h;
} *FGLMesaContext;

/* This function initializes the display with the given size and format,
   and then returns a GL context corresponding to the screen.  This is
   provided as a convenience only. :-)
 */
FGLMesaContext FGLMesaCreateDisplay(int width, int height, int bpp);

/* This function takes a FGL surface and returns a GL context.
   The surface must either be in 8-bit palette or 32-bit RGB format.
 */
extern FGLMesaContext FGLMesaCreateContext(FGPixel *buffer);

/* This function makes the given context the current GL context.
 */
extern GLboolean FGLMesaMakeCurrent(FGLMesaContext ctx);

/* This function destroys a previously created GL context.
 */
extern void FGLMesaDestroyContext(FGLMesaContext ctx);

#ifdef __cplusplus
}
#endif

#endif /* _FGL_Mesa_h */

