/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk

    base.h - base graphics support headers

*/

#ifndef __BASE_H
#define __BASE_H

// for WATCOM & DOS
#ifdef __DOS__
#define __MSDOS__
#endif

#ifndef FASTGL_BPP
#ifdef BPP8
	#define FASTGL_BPP		8
#endif

#ifdef BPP15
	#define FASTGL_BPP		15
#endif

#ifdef BPP16
	#define FASTGL_BPP		16
#endif

#ifdef BPP32
	#define FASTGL_BPP		32
#endif
#endif // FASTGL_BPP


#ifndef FASTGL_BPP
	#define FASTGL_BPP	8
#endif

#if (FASTGL_BPP==8)
	#define	INDEX_COLORS
#elif (FASTGL_BPP==15)
	#define	DIRECT_COLORS	15
	#define DirectColor(rgb) (((rgb&0xF80000)>>9) + ((rgb&0xF800)>>6) + ((rgb&0xF8)>>3))
	#define ExpandColor(rgb) (((rgb<<9)&0xF80000) + ((rgb&<<6)0xF800) + ((rgb<<3)&0xF8))
#elif (FASTGL_BPP==16)
	#define	DIRECT_COLORS	16
	#define DirectColor(rgb) (((rgb&0xF80000)>>8) + ((rgb&0xFc00)>>5) + ((rgb&0xF8)>>3))
	#define ExpandColor(rgb) (((rgb<<8)&0xF80000) + ((rgb&<<5)0xFc00) + ((rgb<<3)&0xF8))
#elif (FASTGL_BPP==32)
	#define	TRUE_COLORS
	#define DirectColor
	#define ExpandColor
#endif

#ifdef __MSDOS__
#define	BACKSP	0x08
#define	KLEFT	0x24b
#define	KUP		0x248
#define	KDOWN	0x250
#define	KRIGHT	0x24d

#define	INSERT	0x252
#define	DEL		0x253
#define	HOME	0x247
#define	END		0x24f
#define	PGUP	0x249
#define	PGDOWN	0x251

#define ALT_A	286
#define ALT_B	304
#define ALT_C	302
#define ALT_D	288
#define ALT_E	274
#define ALT_F	289
#define ALT_G	290
#define ALT_H	291
#define ALT_I	279
#define ALT_J	292
#define ALT_K	293
#define ALT_L	294
#define ALT_M	306
#define ALT_N	305
#define ALT_O	280
#define ALT_P	281
#define ALT_Q	272
#define ALT_R	275
#define ALT_S	287
#define ALT_T	276
#define ALT_U	278
#define ALT_V	303
#define ALT_W	273
#define ALT_X	301
#define ALT_Y	277
#define	ALT_Z	300

#define	F01		315
#define	F02		316
#define	F03		317
#define	F04		318
#define	F05		319
#define	F06		320
#define	F07		321
#define	F08		322
#define	F09		323
#define	F10		324
#define	F11		389
#define	F12		390

#define	ALT_F01		360
#define	ALT_F02		(ALT_F01+1)
#define	ALT_F03		(ALT_F01+2)
#define	ALT_F04		(ALT_F01+3)
#define	ALT_F05		(ALT_F01+4)
#define	ALT_F06		(ALT_F01+5)
#define	ALT_F07		(ALT_F01+6)
#define	ALT_F08		(ALT_F01+7)
#define	ALT_F09		(ALT_F01+8)
#define	ALT_F10		(ALT_F01+9)
#define	ALT_F11		395
#define	ALT_F12		396

#define	CTRL_F01		350
#define	CTRL_F02		(CTRL_F01+1)
#define	CTRL_F03		(CTRL_F01+2)
#define	CTRL_F04		(CTRL_F01+3)
#define	CTRL_F05		(CTRL_F01+4)
#define	CTRL_F06		(CTRL_F01+5)
#define	CTRL_F07		(CTRL_F01+6)
#define	CTRL_F08		(CTRL_F01+7)
#define	CTRL_F09		(CTRL_F01+8)
#define	CTRL_F10		(CTRL_F01+9)
#define	CTRL_F11		393
#define	CTRL_F12		394

#define	ALT_UP		408
#define	ALT_DOWN	416
#define	ALT_RIGHT 	413
#define	ALT_LEFT	411

#define	ALT_TAB			421
#define	ALT_INSERT		418
#define	ALT_DEL			419
#define	ALT_HOME		407
#define	ALT_END			415
#define ALT_PGUP		409
#define ALT_PGDOWN		417

#define	CTRL_UP		(KUP+0x100)
#define	CTRL_DOWN	(KDOWN+0x100)
#define	CTRL_RIGHT 	(KRIGHT+0x100)
#define	CTRL_LEFT	(KLEFT+0x100)

#define	CTRL_TAB	0x194
#define	CTRL_INSERT		658
#define	CTRL_DEL		659
#define	CTRL_HOME		631
#define	CTRL_END		629
#define CTRL_PGUP	644
#define CTRL_PGDOWN	630
#endif

#ifdef	__linux__
#define	BACKSP		0x8
#define	KUP		0x232
#define	KDOWN	0x233
#define	KRIGHT	0x235
#define	KLEFT	0x234

#define	INSERT	0x222
#define	DEL		0x7F
#define	HOME		0x238
#define	END		0x239
#define	PGUP	0x236
#define	PGDOWN	0x237

#define ALT_A	0x1061
#define ALT_B	(ALT_A+1)
#define ALT_C	(ALT_A+2)
#define ALT_D	(ALT_A+3)
#define ALT_E	(ALT_A+4)
#define ALT_F	(ALT_A+5)
#define ALT_G	(ALT_A+6)
#define ALT_H	(ALT_A+7)
#define ALT_I	(ALT_A+8)
#define ALT_J	(ALT_A+9)
#define ALT_K	(ALT_A+10)
#define ALT_L	(ALT_A+11)
#define ALT_M	(ALT_A+12)
#define ALT_N	(ALT_A+13)
#define ALT_O	(ALT_A+14)
#define ALT_P	(ALT_A+15)
#define ALT_Q	(ALT_A+16)
#define ALT_R	(ALT_A+17)
#define ALT_S	(ALT_A+18)
#define ALT_T	(ALT_A+19)
#define ALT_U	(ALT_A+20)
#define ALT_V	(ALT_A+21)
#define ALT_W	(ALT_A+22)
#define ALT_X	(ALT_A+23)
#define ALT_Y	(ALT_A+24)
#define	ALT_Z	(ALT_A+25)

#define	F01		0x301
#define	F02		(F01+1)
#define	F03		(F01+2)
#define	F04		(F01+3)
#define	F05		(F01+4)
#define	F06		(F01+5)
#define	F07		(F01+6)
#define	F08		(F01+7)
#define	F09		(F01+8)
#define	F10		(F01+9)
#define	F11		(F01+10)
#define	F12		(F01+11)

#define	ALT_F01		0x1201
#define	ALT_F02		0x1202
#define	ALT_F03		0x1203
#define	ALT_F04		0x1204
#define	ALT_F05		0x1205
#define	ALT_F06		0x1206
#define	ALT_F07		0x1207
#define	ALT_F08		0x1208
#define	ALT_F09		0x1209
#define	ALT_F10		0x120a
#define	ALT_F11		0x120b
#define	ALT_F12		0x120c

#define	CTRL_F01		0x401
#define	CTRL_F02		0x402
#define	CTRL_F03		0x403
#define	CTRL_F04		0x404
#define	CTRL_F05		0x405
#define	CTRL_F06		0x406
#define	CTRL_F07		0x407
#define	CTRL_F08		0x408
#define	CTRL_F09		0x409
#define	CTRL_F10		0x40a
#define	CTRL_F11		0x40b
#define	CTRL_F12		0x40c

#define	ALT_UP		(KUP+0x1000)
#define	ALT_DOWN	(KDOWN+0x1000)
#define	ALT_RIGHT 	(KRIGHT+0x1000)
#define	ALT_LEFT	(KLEFT+0x1000)

#define	ALT_TAB			4105
#define	ALT_INSERT		4642
#define	ALT_DEL			4223
#define	ALT_HOME		4664
#define	ALT_END			4665
#define ALT_PGUP		4662
#define ALT_PGDOWN		4663

#define	CTRL_UP		(KUP+0x100)
#define	CTRL_DOWN	(KDOWN+0x100)
#define	CTRL_RIGHT 	(KRIGHT+0x100)
#define	CTRL_LEFT	(KLEFT+0x100)

#define	CTRL_TAB		0xFFF
#define	CTRL_INSERT		802
#define	CTRL_DEL		0x7F
#define	CTRL_HOME		824
#define	CTRL_END		825
#define CTRL_PGUP	(PGUP+0x100)
#define CTRL_PGDOWN	(PGDOWN+0x100)
#endif // linux

#ifdef __QNX__
#define	BACKSP	0x7f
#define	KUP		417
#define	KDOWN	425
#define	KRIGHT	422
#define	KLEFT	420

#define	INSERT	427
#define	DEL		428
#define	HOME	416
#define	END		424
#define	PGUP	418
#define	PGDOWN	426

#define ALT_A	481
#define ALT_B	(ALT_A+1)
#define ALT_C	(ALT_A+2)
#define ALT_D	(ALT_A+3)
#define ALT_E	(ALT_A+4)
#define ALT_F	(ALT_A+5)
#define ALT_G	(ALT_A+6)
#define ALT_H	(ALT_A+7)
#define ALT_I	(ALT_A+8)
#define ALT_J	(ALT_A+9)
#define ALT_K	(ALT_A+10)
#define ALT_L	(ALT_A+11)
#define ALT_M	(ALT_A+12)
#define ALT_N	(ALT_A+13)
#define ALT_O	(ALT_A+14)
#define ALT_P	(ALT_A+15)
#define ALT_Q	(ALT_A+16)
#define ALT_R	(ALT_A+17)
#define ALT_S	(ALT_A+18)
#define ALT_T	(ALT_A+19)
#define ALT_U	(ALT_A+20)
#define ALT_V	(ALT_A+21)
#define ALT_W	(ALT_A+22)
#define ALT_X	(ALT_A+23)
#define ALT_Y	(ALT_A+24)
#define	ALT_Z	(ALT_A+25)

#define	F01		385
#define	F02		386	
#define	F03		387	
#define	F04		388	
#define	F05		389	
#define	F06		390	
#define	F07		391	
#define	F08		392	
#define	F09		393	
#define	F10		394	
#define	F11		430	
#define	F12		431

#define	ALT_F01		465
#define	ALT_F02		(ALT_F01+1)
#define	ALT_F03		(ALT_F01+2)
#define	ALT_F04		(ALT_F01+3)
#define	ALT_F05		(ALT_F01+4)
#define	ALT_F06		(ALT_F01+5)
#define	ALT_F07		(ALT_F01+6)
#define	ALT_F08		(ALT_F01+7)
#define	ALT_F09		(ALT_F01+8)
#define	ALT_F10		(ALT_F01+9)
#define	ALT_F11		462
#define	ALT_F12		463

#define	CTRL_F01		405
#define	CTRL_F02		(CTRL_F01+1)
#define	CTRL_F03		(CTRL_F01+2)
#define	CTRL_F04		(CTRL_F01+3)
#define	CTRL_F05		(CTRL_F01+4)
#define	CTRL_F06		(CTRL_F01+5)
#define	CTRL_F07		(CTRL_F01+6)
#define	CTRL_F08		(CTRL_F01+7)
#define	CTRL_F09		(CTRL_F01+8)
#define	CTRL_F10		(CTRL_F01+9)
#define	CTRL_F11		446
#define	CTRL_F12		447

#define	ALT_UP	449
#define	ALT_DOWN	457
#define	ALT_RIGHT 454
#define	ALT_LEFT	 452

//#define	ALT_TAB		// not defined
#define	ALT_INSERT		459
#define	ALT_DEL			460
#define	ALT_HOME		448
#define	ALT_END			456
#define ALT_PGUP		450
#define ALT_PGDOWN		458

#define	CTRL_UP		433
#define	CTRL_DOWN	441
#define	CTRL_RIGHT 	438
#define	CTRL_LEFT	436

#define	CTRL_TAB		415
#define	CTRL_INSERT		443
#define	CTRL_DEL		444
#define	CTRL_HOME		432
#define	CTRL_END		440
#define CTRL_PGUP		434
#define CTRL_PGDOWN		442
#endif

#define CTRL_A	1
#define CTRL_B	2
#define CTRL_C	3
#define CTRL_D	4
#define CTRL_E	5
#define CTRL_F	6
#define CTRL_G	7
#define CTRL_H	8
#define CTRL_I	9
#define CTRL_J	10
#define CTRL_K	11
#define CTRL_L	12
#define CTRL_M	13
#define CTRL_N	14
#define CTRL_O	15
#define CTRL_P	16
#define CTRL_Q	17
#define CTRL_R	18
#define CTRL_S	19
#define CTRL_T	20
#define CTRL_U	21
#define CTRL_V	22
#define CTRL_W	23
#define CTRL_X	24
#define CTRL_Y	25
#define	CTRL_Z	26

#define	CR		13
#define	ESC		27
#define	TAB		9
#define	LF		10

#include <string.h>
#include <math.h>
#include <unistd.h>

#ifndef __linux__
#include <conio.h>
#else
#include <sched.h>

#include <linux/version.h>
#if (LINUX_VERSION_CODE>=0x20200) && !defined(FRAMEBUFFER)
#define FRAMEBUFFER
#endif

#ifdef __cplusplus
extern "C" {
#endif
void outpb(unsigned, unsigned);
void outpw(unsigned, unsigned);
unsigned char  inpb(unsigned);
unsigned short inpw(unsigned);
#define outp outpb
#define inp  inpb
#ifdef __cplusplus
};
#endif
#define cprintf printf
#endif


#ifdef __DJGPP__
#include <pc.h>
#include <dpmi.h>
#endif

#ifdef __cplusplus
extern "C" {

struct Palette {
		char	b;
		char    g;
		char    r;
		char alfa;
	public:
		Palette(void)
		{
		 	r =	g =	b =	alfa = 0;
		}
		Palette(unsigned p)
		{
		 	*((unsigned *)this) = p;
		}
		Palette(char _r, char _g, char _b)
		{
		 	r = _r;
		 	g = _g;
		 	b = _b;
			alfa = 0;
		}
};
#endif

#ifdef __WATCOMC__
#include <i86.h>
#define pi 3.141592653589793238

#define NO_MMX		// disable MMX

#ifndef __SW_3S
#error "you must use stack call conventions! (-3s)"
#endif

// this line force linker to linking with fgl.lib implicitly
#pragma library (fgl)


typedef struct {
  unsigned long handle;			/* 0, 2 */
  unsigned long size; 	/* or count */	/* 4, 6 */
  unsigned long address;		/* 8, 10 */
} __dpmi_meminfo;

typedef union {
  struct {
    unsigned long edi;
    unsigned long esi;
    unsigned long ebp;
    unsigned long res;
    unsigned long ebx;
    unsigned long edx;
    unsigned long ecx;
    unsigned long eax;
  } d;
  struct {
    unsigned short di, di_hi;
    unsigned short si, si_hi;
    unsigned short bp, bp_hi;
    unsigned short res, res_hi;
    unsigned short bx, bx_hi;
    unsigned short dx, dx_hi;
    unsigned short cx, cx_hi;
    unsigned short ax, ax_hi;
    unsigned short flags;
    unsigned short es;
    unsigned short ds;
    unsigned short fs;
    unsigned short gs;
    unsigned short ip;
    unsigned short cs;
    unsigned short sp;
    unsigned short ss;
  } x;
  struct {
    unsigned char edi[4];
    unsigned char esi[4];
    unsigned char ebp[4];
    unsigned char res[4];
    unsigned char bl, bh, ebx_b2, ebx_b3;
    unsigned char dl, dh, edx_b2, edx_b3;
    unsigned char cl, ch, ecx_b2, ecx_b3;
    unsigned char al, ah, eax_b2, eax_b3;
  } h;
} __dpmi_regs;

int __dpmi_int(int _vector, __dpmi_regs *_regs);
int __dpmi_allocate_dos_memory(int _paragraphs, int *_ret_selector_or_max);

#endif

unsigned long inpl(unsigned);
void outpl(unsigned, unsigned);

#define  _GSET   0
#define  _GXOR   1
#define  _GAND   2
#define  _GOR    3
#define	 _GPLUS	 4
#define	 _GMINUS 5
#define	 _GNOT   6
#define	 _GREPLACE  7
#define	 _GTRANSP   8

#ifdef INDEX_COLORS
typedef unsigned char FGPixel; // type of color (must correspond with bpp)
#endif

#if (DIRECT_COLORS==15)
typedef unsigned short FGPixel; // type of color (must correspond with bpp)
#endif

#if (DIRECT_COLORS==16)
typedef unsigned short FGPixel; // type of color (must correspond with bpp)
#endif

#ifdef TRUE_COLORS
typedef unsigned int  FGPixel; // type of color (must correspond with bpp)
#endif

#define		GTEXT		0
#define		G320x200	1
#define		G640x480	2
#define		G800x600	3
#define		G1024x768	4
#define		G1280x1024	5
#define		G1600x1200	6

#ifdef INDEX_COLORS
#define  CBLACK		((FGPixel) 0)
#define  CDARK		((FGPixel) 1)
#define  CGRAYED	((FGPixel) 2)
#define  CGRAY1		((FGPixel) 3)
#define  CGRAY2		((FGPixel) 4)
#define  CGRAY3		((FGPixel) 5)
#define  CBLUE		((FGPixel) 6)
#define  CBLUELIGHT	((FGPixel) 7)
#define  CGREEN		((FGPixel) 8)
#define  CGREENLIGHT ((FGPixel) 9)
#define  CRED		((FGPixel) 10)
#define  CREDLIGHT	((FGPixel) 11)
#define  CBROWN		((FGPixel) 12)
#define  CYELLOW	((FGPixel) 13)
#define  CWHITED	((FGPixel) 14)
#define  CWHITE		((FGPixel) 15)
#else
#define  CBLACK		((FGPixel) 0)
#define  CDARK		((FGPixel) DirectColor(0x444444U))
#define  CGRAYED	((FGPixel) DirectColor(0x585858U))
#define  CGRAY1		((FGPixel) DirectColor(0x7c8074U))
#define  CGRAY2		((FGPixel) DirectColor(0x687884U))
#define  CGRAY3		((FGPixel) DirectColor(0xa8b8acU))
#define  CBLUE		((FGPixel) DirectColor(0x000078U))
#define  CBLUELIGHT	((FGPixel) DirectColor(0x0000f8U))
#define  CGREEN		((FGPixel) DirectColor(0x007800U))
#define  CGREENLIGHT ((FGPixel) DirectColor(0x00f800U))
#define  CRED		((FGPixel) DirectColor(0xd44448U))
#define  CREDLIGHT	((FGPixel) DirectColor(0xf80000U))
#define  CBROWN		((FGPixel) DirectColor(0x684028U))
#define  CYELLOW	((FGPixel) DirectColor(0xfce000U))
#define  CWHITED	((FGPixel) DirectColor(0xd8d0b8U))
#define  CWHITE		((FGPixel) DirectColor(0xfcfcfcU))
#endif // TRUE_COLORS

enum Fonts { FONT0406,  FONT0808, FONT0816, FONT1222, FONT1625, FONT2034, FONTLAST };

extern unsigned int areasize(int x, int y);

#ifdef __QNX__
unsigned int delay(unsigned int);
void sound(unsigned);
void nosound(void);
#else
void delay(unsigned int);
#ifdef __linux__
#define delay(a) usleep(a*1000)
#endif
#endif

#if (defined(__linux__) || (defined(__GNUC__) && defined(__QNX__)))
extern int	_rdtsc(void) asm("_rdtsc");
extern int	test_mmx(void) asm("_test_mmx");
extern void	set_mmx(void) asm("_set_mmx");
extern void	reset_mmx(void) asm("_reset_mmx");
void SetPalette256(void *) asm("_SetPalette256");
void GetPalette256(void *) asm("_GetPalette256");
int set_ppop(int mode) asm("_set_ppop");
void draw_box(int x, int y, int w, int h);
void fill_box(int x, int y, int w, int h);
void draw_point(int x, int y) asm("_draw_point");
int  get_point(int x, int y) asm("_get_point");
void draw_line(int x, int y, int x1, int y1)  asm("_draw_line");
void draw_hline(int x, int y, int w) asm("_draw_hline");
void drawto_line(int x, int y) asm("_drawto_line");
extern int X_width asm("_X_width"), Y_width asm("_Y_width");
void clear_frame_buffer(FGPixel c) asm("_clear_frame_buffer");
extern void Line(int x,int y,int w,int h) asm("_Line");
extern int X_max asm("_X_max"), Y_max asm("_Y_max"); /* maximalne rozlisenie */
extern int fonth asm("_fonth"), fontw asm("_fontw"), fontn asm("_fontn");
#else
extern int	test_mmx(void);
extern void	set_mmx(void);
extern void	reset_mmx(void);
void SetPalette256(void *);
void GetPalette256(void *);
int set_ppop(int mode);
void draw_box(int x, int y, int w, int h);
void fill_box(int x, int y, int w, int h);
void draw_point(int x, int y);
int get_point(int x, int y);
void draw_line(int x, int y, int x1, int y1);
void draw_hline(int x, int y, int w);
void drawto_line(int x, int y);
extern int X_width, Y_width;
void clear_frame_buffer(FGPixel c);
extern void Line(int x,int y,int w,int h);
extern int X_max, Y_max; /* maximalne rozlisenie */
extern int fonth, fontw, fontn;
#endif

void FGmemcpy(FGPixel *to, FGPixel *from, unsigned c);
void FGmemset(FGPixel *to, FGPixel data, unsigned c);
void FGmemcpy2(FGPixel *to, FGPixel *from, unsigned c);
void FGmemset2(FGPixel *to, FGPixel data, unsigned c);
void cleanup(void);
void _set_default_palette(void);
void _set_fgl_palette(void);
unsigned int get_palette(unsigned int i);
void __palette(unsigned col, unsigned rgb);
void _palette(unsigned , unsigned int);
#define set_palette _palette
int graph_set_mode(int mode);
void draw_spline(int points[8]);
void calc_spline(int points[8], int npts, int *x, int *y);
void set_fcolor(FGPixel c) ;
void set_bcolor(FGPixel c) ;
void set_colors(FGPixel f, FGPixel b);
int text_out(int x, int y, char *text);
void text_to_buffer(int x, int y, char *s, int xsize, int ysize, FGPixel *buf);
int get_area_size(int x, int y);
void fill_convex(int c, int a[][2]);
void draw_convex(int c, int a[][2]);
FGPixel  get_fcolor(void);
FGPixel  get_bcolor(void);
void get_block(int x,int y,int a,int b, FGPixel *p) ;
void put_block(int x,int y,int a,int b, FGPixel *p) ;
void set_clip_rect(int w, int h, int x, int y);

void fill_ellipse(int x, int y, int rx, int ry);
void draw_ellipse(int x, int y, int rx, int ry);
void draw_arc(int x, int y, double ang1, double ang2, int r);

void IErrorText(char *s, int flag);
extern void Pixel(int x,int y);
extern void Rect(int x,int y,int w,int h);
extern void Box(int x,int y,int w,int h);
extern void RamToVideo(int x,int y,int xm,int ym,int w,int h);
extern void RamToVideo2(int x,int y,int xm,int ym,int w,int h);
extern void VideoToRam(int x,int y,int xm,int ym,int w,int h);
extern void RamToRam(int x,int y,int xmax,int ymax,int xdst,int ydst,int xmaxdst,int ymaxdst,int w,int h,FGPixel *from, FGPixel *to);
extern void RamToRamd(int x,int y,int xmax,int ymax,int xdst,int ydst,int xmaxdst,int ymaxdst,int w,int h,FGPixel *from, FGPixel *to);
extern void Text(int x,int y,char *s);
extern void DrawEllipse(int x,int y, int rx, int ry);
extern void FillEllipse(int x,int y, int rx, int ry);
extern void DrawCircle(int x,int y, int r);
extern void FillCircle(int x,int y, int r);
extern void DrawArc(int x, int y, double ang1, double ang2, int r);
extern void draw_circle(int x,int y, int r);
extern void fill_circle(int xs, int ys, int r);
extern int set_font(int font);
int gprintf(int x, int y, const char *format,...);

int		GetFreeColors(void);
void	GetPaletteEntry(char *rc, char	*gc, char *bc, int i);
void	CreatePaletteEntry(int	rc,	int	gc,	int	bc,	int	idx);
void	SetColorFuzzy(int a);
extern	FGPixel CreateColor(int,int,int,int);
extern	FGPixel CreateColor8(int,int,int);
void	DeleteColor(int);
int		get_key(void);
int		get_colordepth(void);
void	bench(void);
void	set_transpcolor(FGPixel);

#ifdef __WATCOMC__
#pragma aux Line "_*"
#pragma aux set_ppop "_*"
#pragma aux _rdtsc "*"
#pragma aux draw_hline "_*"
#pragma aux X_width "_*"
#pragma aux Y_width "_*"
#pragma aux draw_line "_*"
#pragma aux SetPalette256 "_*"
#pragma aux GetPalette256 "_*"
#pragma aux set_mmx "_*"
#pragma aux reset_mmx "_*"
#pragma aux test_mmx "_*"
#pragma aux X_max "_*"
#pragma aux Y_max "_*"
#pragma aux clear_frame_buffer "_*"
#pragma aux fill_convex "_*"
#pragma aux draw_point "_*"
#pragma aux get_point "_*"
#pragma aux fontn "_*"
#pragma aux fontw "_*"
#pragma aux fonth "_*"
#endif

char * strupr(register char *s);
int stricmp(const char *s1, const char *s2);
int strnicmp(const char *s1, const char *s2, size_t cnt);
char *	strlwr(char *_s);

#define	 MAX_TEXT_LENGTH	256

typedef	long fixed;

typedef	struct
{
	int	x, xlast;
	int	y, ylast;
	int	dx,	dy;
	int	xmajor;
	int	xstep;
	int	error;
}
polyedge;

typedef	enum
{
	inactive,
	active,
	passed
}
edgestat;

typedef	struct
{
	edgestat status;
	polyedge e;
}
edge;

typedef	struct _scan
{
	struct _scan *next;
	int	x1,	x2;
}
scan;

void Snd(int a, int b);
void Puk(void);

typedef void (*PixelFillFunc) (int x, int y);
typedef void (*LineFillFunc) (int x, int y, int dx, int dy);
typedef void (*ScanFillFunc) (int x, int y, int w);

typedef struct
{
	LineFillFunc line;
	ScanFillFunc scan;
	int gc_xoffset;
	int gc_yoffset;
	int gc_ycliplo;
	int gc_xcliplo;
	int gc_ycliphi;
	int gc_xcliphi;
}
PolygonStruct;

void _DrawPolygon(int n, int pt[][2], PolygonStruct * current);
void _FillPolygon(int n, int pt[][2], PolygonStruct * current);

#ifdef __cplusplus
}
#endif
#endif
