/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk

    _fastgl.h - internal declarations
*/

#define VERZIA "2.14"

#ifdef __cplusplus
class WindowItem
{
	public:
		int	x,y,w,h;
		int icon_x, icon_y, flag;
		char *name;
		WindowItem *next;
		WindowItem();
		WindowItem(int xx, int yy, int ww, int hh, char	*s);
		~WindowItem();
};

class WindowDatabase {
		static int xyCounter;
		friend class WindowItem;
		WindowItem *first;
		WindowItem **endpointer;
		char   name[64], exe[64];
	public:
		WindowDatabase(char *);
		~WindowDatabase();
		void	Add(int	&, int &, int &, int &,	char *,int);
		void	DatabaseResize(int , int , char	*);
		void	DatabaseRelocate(int , int , char *);
		void	DatabaseSetIcon(int , int , char *);
		void	DatabaseGetIcon(int &, int &, char *);
		WindowItem *	findxy(char *s);
};

extern Palette ColorsArray[256];
#ifdef	__WINDOW_H
extern Window *oldidw, *idw;
extern Control *oldidm,*idm;
#endif

extern "C" {

#endif

#ifdef __linux__

#define TEXT 	     0		/* Compatible with VGAlib v1.2 */
#define G320x200x256 5
#define G640x480x256 10
#define G800x600x256 11
#define G1024x768x256 12
#define G1280x1024x256 13	/* Additional modes. */
#define G1600x1200x256 45

#define G320x200x16M32 33	/* 32-bit per pixel modes. */
#define G640x480x16M32 34
#define G800x600x16M32 35
#define G1024x768x16M32 36
#define G1280x1024x16M32 37
#define G1600x1200x16M32 49

#define G320x200x32K 14
#define G320x200x64K 15
#define G640x480x32K 17
#define G640x480x64K 18
#define G800x600x32K 20
#define G800x600x64K 21
#define G1024x768x32K 23
#define G1024x768x64K 24
#define G1280x1024x32K 26
#define G1280x1024x64K 27
#define G1600x1200x32K 46
#define G1600x1200x64K 47

#define MOUSE_LEFTBUTTON 4
#define MOUSE_RIGHTBUTTON 1
#define MOUSE_DEFAULTSAMPLERATE 150

typedef struct {
	int width;
	int height;
	int bytesperpixel;
	int colors;
	int linewidth;		/* scanline width in bytes */
	int maxlogicalwidth;	/* maximum logical scanline width */
	int startaddressrange;	/* changeable bits set */
	int maxpixels;		/* video memory / bytesperpixel */
	int haveblit;		/* mask of blit functions available */
	int flags;		/* other flags */

	/* Extended fields: */

	int chiptype;		/* Chiptype detected */
	int memory;		/* videomemory in KB */
	int linewidth_unit;	/* Use only a multiple of this as parameter for set_logicalwidth and
				   set_displaystart */
	char *linear_aperture;	/* points to mmap secondary mem aperture of card (NULL if unavailable) */
	int aperture_size;	/* size of aperture in KB if size>=videomemory. 0 if unavail */
	void (*set_aperture_page) (int page);
	/* if aperture_size<videomemory select a memory page */
	void *extensions;	/* points to copy of eeprom for mach32 */
	/* depends from actual driver/chiptype.. etc. */
} vga_modeinfo;

#endif

enum Drivers { FG_VESA, FG_CIRRUS, FG_TRIDENT, FG_S3, FG_S3V2,
	FG_MX, FG_TSENG3, FG_ATI, FG_TSENG4, FG_CHIPS,
	FG_WDIGITAL, FG_BANSHEE, FG_NVIDIA, FG_MATROX, FG_PERMEDIA,
	FG_INTEL740, FG_INTEL810, FG_RENDITION,

	FG_LAST};

void XWaitRetrace(void);
void XWaitPeriod(void);
extern const unsigned int _default_palette[256];
extern unsigned int _fgl_palette[256];

#if (defined(__linux__) || (defined(__GNUC__) && defined(__QNX__)))
extern int CRTC asm("_CRTC");
extern int granularity asm("_granularity");
extern FGPixel * videobase asm("_videobase");
extern unsigned videobasesegment asm("_videobasesegment");
extern unsigned VideoSelector asm("_VideoSelector");
void set_palet1(int cnt, int ind, int *pal) asm("_set_palet1");
extern int cx_work asm("_cx_work"),
	cy_work asm("_cy_work"),
    cx_maxwork asm("_cx_maxwork"),
    cy_maxwork asm("_cy_maxwork"),
    ppop asm("_ppop"),
    lfb asm("_lfb");
extern void	_degraduj(FGPixel *, FGPixel *,FGPixel *,int) asm("__degraduj");
extern int  mmx_state asm("_mmx_state"), mmx asm("_mmx");
extern int _CurrBkColor asm("__CurrBkColor"),_CurrColor asm("__CurrColor");
extern int clip_x_min asm("_clip_x_min"), clip_y_min asm("_clip_y_min"), clip_x_max asm("_clip_x_max"), clip_y_max asm("_clip_y_max");
extern FGPixel _internal_bitmap0[] asm ("__internal_bitmap0");
extern int driver asm("_driver");
extern int cx_max asm("_cx_max"), cy_max asm("_cy_max");
extern FGPixel * Image asm("_Image"), *font asm("_font");
void _paletter(unsigned , unsigned int) asm("__paletter");
extern short _setvideomode(short) asm("__setvideomode");
extern void _fill_rect(int x,int y,int w,int h) asm("__fill_rect");
extern int framebuffer,	memorysize, lfb;
extern int GraphMode; /* maximalne rozlisenie */
extern int bpp asm("_bpp") ;
extern FGPixel transp_color asm("_transp_color") ;

#else

extern int CRTC;
extern int granularity;
extern FGPixel * videobase;
extern unsigned videobasesegment;
extern unsigned VideoSelector;
void set_palet1(int cnt, int ind, int *pal);
extern int cx_work,
	cy_work,
    cx_maxwork,
    cy_maxwork,
    ppop;
extern void	_degraduj(FGPixel *,FGPixel *,FGPixel *, int);
extern int  mmx_state, mmx;
extern int _CurrBkColor,_CurrColor;
extern int clip_x_min, clip_y_min, clip_x_max, clip_y_max;
extern FGPixel _internal_bitmap0[];
extern int driver;
extern int cx_max, cy_max;
extern FGPixel * Image, *font;
void PaletteInit(void);
void _palette(unsigned , unsigned int);
void _paletter(unsigned, unsigned int);
extern short _setvideomode(short);
extern void _fill_rect(int x,int y,int w,int h);
extern int framebuffer,	memorysize, lfb;
extern int X_max, Y_max, GraphMode; /* maximalne rozlisenie */
extern int bpp;
extern FGPixel transp_color;
#endif
extern unsigned char miro0406[], miro0808[], miro0816[], miro1220[], miro1625[], miro2034[];

void CloseUserInput(void);
void GetModeSize(int mode, int *m);
void set_linear(int);
extern int detect_video(int v);
extern int peek(short seg, unsigned off);
extern void poke(short seg, unsigned off, unsigned int value);
extern int MOVEABLE,inGraph;
extern int verbose;
extern int	allBitmapCounter;
extern FGPixel m_save[256],
m_mask[256],
m_mask2[256],
m_mask3[256],
m_mask4[256],
l_mask[256],
l_bmap[256],
m_bmap[256],
m_mask4b[256],
m_mask2b[256],
m_mask3b[256],
c_mask[196],
d_mask[196],
e_mask[196],
f_mask[196];

void modify_point(FGPixel *ptr);
void WarningBeep(int which);
void Boxw(int x, int y, int w, int h);
void Textw(int x, int y, char *);
extern void Rectw(int x,int y,int w,int h);

extern void Hline(int x,int y,int c);
extern void Vline(int x,int y,int c);

const char *GetDriverName(void);
void FGLInitEvents(void);

#if (defined(__linux__) || (defined(__GNUC__) && defined(__QNX__)))
void L1VideoToRam8(FGPixel	*, FGPixel	*, int,	int, int, int) asm("_L1VideoToRam8");
void L1RamToVideo2(FGPixel	*, FGPixel	*, int,	int, int, int) asm("_L1RamToVideo2");
void L1RamToVideo8(FGPixel	*, FGPixel	*, int,	int, int, int) asm("_L1RamToVideo8");
void L1RamToRam(FGPixel *,	FGPixel *,	int, int, int, int)	asm("_L1RamToRam");
void L1RamToRamPpop(FGPixel *,	FGPixel *,	int, int, int, int)	asm("_L1RamToRamPpop");
void L1Box(FGPixel	*, int,	int, int) asm("_L1Box");
void L1BoxX(FGPixel *,	int, int, int) asm("_L1BoxX");
void CharOutClip(FGPixel *, FGPixel *, int offset) asm("_CharOutClip");
#else
void L1VideoToRam8(FGPixel	*, FGPixel	*, int,	int, int, int);
void L1RamToVideo2(FGPixel	*, FGPixel	*, int,	int, int, int);
void L1RamToVideo8(FGPixel	*, FGPixel	*, int,	int, int, int);
void L1RamToRam(FGPixel *,	FGPixel *,	int, int, int, int);
void L1RamToRamPpop(FGPixel *,	FGPixel *,	int, int, int, int);
void L1Box(FGPixel	*, int,	int, int);
void L1BoxX(FGPixel *,	int, int, int);
void CharOutClip(FGPixel *, FGPixel *, int offset);
#endif

#define PICTOSIZE		20
#define TITLEH			20
#define BASEBORDER		4
#define MENUH			20
#define STATUSBARH		19

#define BORD1    		CScheme->wnd_bord1
#define BORD2			CScheme->wnd_bord2
#define BORD3			CScheme->wnd_bord3

#define CTITLE   		CScheme->inactive_title 	// color of unactive title
#define CTITLEACTIVE 	CScheme->active_title	 	// color of active title
#define MENUBG	 		CScheme->menu_back

extern int fulldrag;

#ifdef __WATCOMC__
unsigned seg_overlay(void);
unsigned qnx_segment_overlay_flags(void);
#pragma aux CRTC "_*"
#pragma aux set_palet1 "_*"
#pragma aux font "_*"
#pragma aux _setvideomode "_*"
#pragma aux granularity "_*"
#pragma aux lfb "_*"
#pragma aux bpp "_*"
#pragma aux transp_color "_*"
#pragma aux videobase "_*"
#pragma aux videobasesegment "_*"
#pragma aux VideoSelector "_*"
#pragma aux peek "_*"
#pragma aux poke "_*"
#pragma aux driver "_*"
#pragma aux PaletteInit "_*"
#pragma aux mmx "_*"
#pragma aux ppop "_*"
#pragma aux mmx_state "_*"
#pragma aux _fill_rect "_*"
#pragma aux __dpmi_int "_*"
#pragma aux _CurrBkColor "_*"
#pragma aux _CurrColor "_*"
#pragma aux cx_max "_*"
#pragma aux cy_max "_*"
#pragma aux cx_maxwork "_*"
#pragma aux cy_maxwork "_*"
#pragma aux cx_work "_*"
#pragma aux cy_work "_*"
#pragma aux Image "_*"
#pragma aux CharOutClip "_*"
#pragma aux CharOutClip2 "_*"
#pragma aux clip_x_min "_*"
#pragma aux clip_y_min "_*"
#pragma aux clip_x_max "_*"
#pragma aux clip_y_max "_*"
#pragma aux L1Box "_*"
#pragma aux L1BoxX "_*"
#pragma aux L1RamToRam "_*"
#pragma aux L1RamToRamPpop "_*"
#pragma aux L1RamToVideo2 "_*"
#pragma aux L1RamToVideo8 "_*"
#pragma aux L1VideoToRam8 "_*"
#pragma aux _degraduj "_*"
#endif

#ifdef __cplusplus
}
#endif

#ifdef __linux__

#include "linkeyb.h"
extern int  (*ptr_vga_init)(void);
extern int  (*ptr_vga_setmode)(int);
extern int  (*ptr_vga_hasmode)(int);
extern void (*ptr_vga_setpage)(int);
extern unsigned char * (*ptr_vga_getgraphmem)(void);
extern int  (*ptr_vga_getmousetype)(void);
extern int  (*ptr_vga_setlinearaddressing)(void);
extern int  (*ptr_mouse_init)(char *dev, int type, int samplerate);
extern void (*ptr_mouse_close)(void);
extern int  (*ptr_mouse_update)(void);
extern void (*ptr_mouse_setposition)(int x, int y);
extern void (*ptr_mouse_setxrange)(int x1, int x2);
extern void (*ptr_mouse_setyrange)(int y1, int y2);
extern void (*ptr_mouse_setscale)(int s);
extern int  (*ptr_mouse_getx)(void);
extern int  (*ptr_mouse_gety)(void);
extern int  (*ptr_mouse_getbutton)(void);
extern int  *ptr_tty_fd;

int LinkSvgalib(void);
int LinuxStartup(int);
void UnlinkSvgalib(void);
int LinuxMemSize(int m);
int LinuxSetMode(int m, int mode, int& linear);
int LinuxInputOpen(void);
void LinuxInputClose(void);
int LinuxGetEvent(int& type, int& key, int& x, int& y, int& buttons, int ismouse);
void LinuxGraphClose(void);
extern "C" void LinuxInit(void);
extern int svgalib, nofb; // 0=ofbis; 1=svgalib
extern char fb_modename[32];
#endif
