#include <fastgl.h>
#include <widgets.h>

#include "rad_def.h"
#include "rad_type.h"
#include "rad_sym.h"

static FILE *fp;
static int nTab;
int verb=1;
static int accelPresent, config;
char symtab[MAX_SYM][SYMSIZE+1], gps2[256], symtype[MAX_SYM];
int symindex;
static int error, wgn;
static char grupy[MAX_GRP]; // 1 znamena ze je pouzita

static char *comments[]=
{
	// 0 - listbox procedures
	"/*\n"
	"  This procedure is called on draw all items in ListBox object\n"
	"  argument 'flag' is TRUE if items are highlighted\n"
	"  argument 'data' is optional, for your own use (you assign it in CTOR)\n",
	// 1 - normal procedures
	"/*\n"
	"  This procedure is called on activate of object\n"
	"  argument is pointer (of type Control *, alias CallBack) to the object\n"
	"  itself. You can ignore this value or use it to test who event generate\n",
	// 2 - bitmap stuff
	"/*\n"
	"  This procedures creates on startup all Bitmap objects for your\n"
	"  application, and destroy it when app terminate\n",
	// 3 - config stuff
	"/*\n"
	"  This procedures load on startup all used variables (which have\n"
	"  config property enable) in application, and save ones when app terminate\n",
	// 4 - wnd proc stuff
	"/*\n"
	"  This procedure handle all events generated by system and user input\n"
	"  for all posible events see OpenGUI docs. I you don't want parse any\n"
	"  events, you can remove this proc, and reference on it from Window CTOR\n"
};

static char *color_str[]=
{
	"CBLACK","CDARK","CGRAYED","CGRAY1","CGRAY2","CGRAY3","CBLUE","CBLUELIGHT",
	"CGREEN","CGREENLIGHT","CRED","CREDLIGHT","CBROWN","CYELLOW","CWHITED","CWHITE"
};

static FGPixel color_val[]=
{
	CBLACK,CDARK,CGRAYED,CGRAY1,CGRAY2,CGRAY3,CBLUE,CBLUELIGHT,
	CGREEN,CGREENLIGHT,CRED,CREDLIGHT,CBROWN,CYELLOW,CWHITED,CWHITE
};

static char *font_str[]=
{
	"FONT0406",  "FONT0808", "FONT0816", "FONT1222", "FONT1625", "FONT2034"
};

static char *mode_str[]=
{
	"GTEXT",  "G320x200", "G640x480", "G800x600", "G1024x768", "G1280x1024", "G1600x1200"
};

static WFLAG wflag[]=
{
{	"WFRAMED",		0x0001},
{	"WTITLED",		0x0002},
{	"WMODAL",		0x0004},
{	"WNOTIFY",		0x0008},
{	"WHIDEN",		0x0010},
{	"WUNMOVED",		0x0020},
{	"WMENU",		0x0040},
{	"WNOPICTO",		0x0080},
{	"WBITMAP",		0x0100},
{	"WCLICKABLE",	0x0200},
{	"WDIRTY",		0x0400},
{	"WTEMPHIDEN",	0x0800},
{	"WLOCKED",		0x1000},
{	"WTRIGGER",		0x2000},
{	"WLASTFOCUS",	0x4000},
{	"WSIZEABLE",	0x8000},
{	"WUSELAST",		0x00010000},
{	"WMINIMIZE",	0x00020000},
{	"WSTATUSBAR",	0x00040000},
{	"WEXIST",		0x00080000},
{	"WHORIZONTAL",	0x00100000},
{	"WVERTICAL",	0x00200000},
{	"WLINEMENU",	0x00400000},
{	"WCENTRED",		0x00800000},
{	"WESCAPE",		0x01000000},
{	"WALIGNED",		0x02000000},
{	"WFASTMOVE",	0x04000000},
};

static char * Color(FGPixel c, char *buf)
{
	int i;
	for(i=0; i<16; i++) if (c == color_val[i]) break;
	if (i<16) strcpy(buf, color_str[i]);
	else sprintf(buf,"0x%x", c);
	return buf;
}

//
// 0 OK, 3-no space, 4 redefine symbol, -1 already defined
// FIX symbols with space !!!!
//
int AddSymbol(char *s, char type)
{
	int i;
	if (symindex>=MAX_SYM)
	{
		IError("Too many symbols", 0);
		return error = 3;
	}
	for(i=0; i<symindex; i++) if (strncmp(s,symtab[i],SYMSIZE)==0 && symtype[i]!=type)
	{
		sprintf(gps, "Symbol %s redefine", s);
		IError(gps, 0);
		return error = 4;
	}
	else if (strncmp(s,symtab[i],SYMSIZE)==0 && symtype[i]==type)
		return -1;
	strncpy(symtab[symindex], s, SYMSIZE);
	symtype[symindex++] = type;
	// test for alnum & '_' chars in symbol
	while (*s)
	{
		if (!isalnum(*s) && *s!='_' && *s!=' ') return -1;
		s++;
	}
	return 0;
}

static char * MangleName(char *s, char *s2=0)
{
	static char name[64];
	char *pom=name;
	int c;

	if (s2) pom = s2;
	for(int i=0;i<=SYMSIZE;i++)
	{
		c = s[i];
		if (c==' ') c = '_';
		pom[i] = c;
		if (!c) break;
	}
	if (isdigit(*s)) *pom='_';
	name[SYMSIZE+1] = 0;
	return s2?s2:name;
}

void Write(char *s, int ntab=0)
{
	if (ntab<0)
	{
		ntab = 0;
	}
	while(ntab--) fputc('\t', fp);
	fputs(s,fp);
}

void Write2(char *s)
{
	fputs(s,fp);
}

static void Case(char *s)
{
	Write("case ",nTab++);
	Write(s);
	Write(":\n");
}

static void Break(void)
{
	Write("break;\n", nTab--);
}

static void Comments(int index, char *addend="")
{
	if (verb)
	{
		Write(comments[index],nTab);
		if (*addend)
		{
//			Write("\n",nTab);
			Write(addend,nTab);
		}
		Write("*/\n",nTab);
	}
}

static char *GetFnc(RadType t)
{
	char *__str[]={
	"Undefine",
	"WindowText",
	"WindowBox",
	"WindowRect",
	"WindowLine",
	"WindowDrawCircle",
	"AddPushButton",
	"AddPushButton",
	"AddCheckButton",
	"AddPointButton",
	"AddEditBox",
	"AddEditBox",
	"AddEditBox",
	"AddSlideBarH",
	"AddSlideBarV",
	"AddListBox",
	"AddBaseMenu",
	"WindowFillCircle",
	"WindowPutBitmap",
	"AddProgressBar",
	"AddLabel",
	"WindowDrawEllipse",
	"WindowFillEllipse",
	"WindowDrawArc",
	"RadLast",
	};

	return t<RAD_LAST ? __str[t] : (char *)"Ooops!";
}

// generate code for .RC file
static void ConfigStuff(Wind w[], int numwin, int aa)
{
	int i,j;
	
	Write(aa ? (char *)"void _load_config(void)\n{\n" : (char *)"void _save_config(void)\n{\n", nTab++);
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		for(i=0; i<w[j].items; i++)
		{
			if (a[i].flags&ACCF_ADDTORC) switch((int)a[i].type)
			{
			case RAD_LISTBOX:
			case RAD_PUSHBUTTON1:
			case RAD_PUSHBUTTON2:
				break;
			case RAD_EDITBOX1:
			case RAD_POINTBUTTON:
			case RAD_CHECKBUTTON:
			case RAD_SLIDEBARH:
			case RAD_SLIDEBARV:
				if (a[i].variable[0]>' ')
				{
					if (aa) sprintf(gps,"cCfg->ReadInt(\"%s\",%s);\n", MangleName(a[i].variable), MangleName(a[i].variable));
					else sprintf(gps,"cCfg->WriteInt(\"%s\",%s);\n", MangleName(a[i].variable), MangleName(a[i].variable));
					Write(gps,nTab);
				}
				break;
			case RAD_EDITBOX2:
				if (a[i].variable[0]>' ')
				{
					if (aa) sprintf(gps,"cCfg->ReadDouble(\"%s\",%s);\n", MangleName(a[i].variable),MangleName(a[i].variable));
					else sprintf(gps,"cCfg->WriteDouble(\"%s\",%s);\n", MangleName(a[i].variable), MangleName(a[i].variable));
					Write(gps,nTab);
				}
				break;
			case RAD_EDITBOX3:
				if (a[i].variable[0]>' ')
				{
					if (aa) sprintf(gps,"cCfg->ReadString(\"%s\",%s,%d);\n", MangleName(a[i].variable),MangleName(a[i].variable),a[i].flags&ACCF_VARSIZE?a[i].ww:a[i].h/8-2);
					else sprintf(gps,"cCfg->WriteString(\"%s\",%s);\n", MangleName(a[i].variable),MangleName(a[i].variable));
					Write(gps,nTab);
				}
				break;
			}
		}
	}
	Write("}\n\n",--nTab);
}

// generate button groups ptr
static void BGPtr(char *s)
{
	for(int i=0;i<MAX_GRP;i++)
		if (grupy[i])
		{
			sprintf(gps, s, i);
			Write(gps, nTab);
		}
}

// generate button groups ptr
static void BGInstance(char *s)
{
	for(int i=0;i<MAX_GRP;i++)
		if (grupy[i])
		{
			sprintf(gps, s, i, grupy[i]);
			Write(gps, nTab);
		}
}

static int FindSymbol(char *s, int typ)
{
	for(int i=0;i<prj->val_num;i++)
	{
		if (!strcmp(prj->values[i].name, s) && prj->values[i].type == typ) return i;
	}
	return -1;
}

// generate assign code if possible
static char *Assign(char *s, int typ)
{
	static char buf[64];
	int rc = FindSymbol(s,typ);
	if (rc<0 || prj->values[rc].value[0]<' ') return "";
	if (typ==V_STRING) sprintf(buf, " = \"%s\"", prj->values[rc].value);
	else sprintf(buf, " = %s", prj->values[rc].value);
	return buf;
}

// generate variable for all window
static void VariableGen(Wind w[], int numwin, Projekt *p)
{
	int i,j,rc,sz;
	wgn = 0;
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		sprintf(gps,"Window *%sPtr;\n", MangleName(w[j].name));
		Write(gps);
		if (p->app_root) Write("Window *rootPtr;\n");
		for(i=0; i<w[j].items; i++)
		{
			switch((int)a[i].type)
			{
			case RAD_LISTBOX:
				sprintf(gps,"static ListBox *listboxPtr%d;\n", wgn++);
				Write(gps);
				goto variabl;
			case RAD_PROGRESSBAR:
				sprintf(gps,"static ProgressBar *pbarPtr%d;\n", wgn++);
				Write(gps);
				break;
			case RAD_EDITBOX1:
			case RAD_POINTBUTTON:
			case RAD_CHECKBUTTON:
			case RAD_SLIDEBARH:
			case RAD_SLIDEBARV:
variabl:
				if (a[i].variable[0]>' ')
				{
					rc = AddSymbol(a[i].variable, V_INT);
					if (rc>0) return;
					else if (rc==0)
					{
						sprintf(gps,"static int %s%s;\n", MangleName(a[i].variable), Assign(a[i].variable, V_INT));
						Write(gps);
					}
				}
			case RAD_PUSHBUTTON1:
			case RAD_PUSHBUTTON2:
				accelPresent = 1;
				break;
			case RAD_EDITBOX2:
				if (a[i].variable[0]>' ')
				{
					if ((rc=AddSymbol(a[i].variable, V_DOUBLE)) > 0) return;
					else if (rc==0)
					{
						sprintf(gps,"static double %s%s;\n", MangleName(a[i].variable), Assign(a[i].variable, V_DOUBLE));
						Write(gps);
					}
				}
				break;
			case RAD_EDITBOX3:
				if (a[i].variable[0]>' ')
				{
					if ((rc=AddSymbol(a[i].variable, V_STRING)) > 0) return;
					else if (rc==0)
					{
						sz = a[i].flags&ACCF_VARSIZE?a[i].ww+1:a[i].h/8-1;
						char *ass = Assign(a[i].variable, V_STRING);
						if (sz<(int)strlen(ass)-4) sz = strlen(ass)-4;
						sz = (sz+3) & 0x7c;
						sprintf(gps,"static char %s[%d]%s;\n", MangleName(a[i].variable), sz, ass);
						Write(gps);
					}
				}
				break;
			}
			if (a[i].flags&ACCF_BGROUP)
			{
				grupy[a[i].bgrp&(MAX_GRP-1)]++;	// set as used
			}
			if (a[i].flags&ACCF_ADDTORC)
			{
				config = 1;	// set as config used
			}
		}
	}
	Write("\n");
}

static void BitmapGen(int num)
{
	int i;
	
	for(i=0; i<num; i++)
	{
		sprintf(gps,"Bitmap *bmp%03dPtr;\n", i);
		Write(gps);
	}
	Write("\n");

	Comments(2);
	Write("static void _load_bitmaps(void)\n{\n", nTab++);
	for(i=0; i<num; i++)
	{
		Bitmap *bb = *bmpindex[i];
		if (bb->GetType() != BMP_FILE) IError("IMAGE ERROR!",0);
		{
			sprintf(gps,"bmp%03dPtr = new Bitmap(\"%s\");\n", i, bb->GetOriginalName());
			Write(gps, nTab);
		}
	}
	Write("}\n\n", --nTab);

	Write("static void _unload_bitmaps(void)\n{\n", nTab++);
	for(i=0; i<num; i++)
	{
		sprintf(gps,"delete bmp%03dPtr;\n", i);
		Write(gps, nTab);
	}
	Write("}\n\n", --nTab);
}

int GetBmpIndex(char *s)
{
	for(int i=0;i<prj->bmp_num;i++)
		if (!strcmp(s,prj->bmp_names[i])) return i;
	return 0;
}

static void StubGen(Wind w[], int numwin)
{
	char *fnc;
	int i,j,rc=0;
	
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		nTab = 0;
		for(i=0;i<w[j].items;i++)
		{
			if (a[i].fnc[0]>' ') fnc =	a[i].fnc; else continue;
			sprintf(gps, "  REFERENCED FROM: '%s' WINDOW\n", w[j].name);
			switch((int)a[i].type)
			{
				case RAD_LISTBOX:
					Comments(0);
					if ((rc=AddSymbol(fnc, V_FNC_LB)) > 0) return;
					else if (rc==0)
					{
						sprintf(gps, "static void %s(int x, int y, int index, int flag, void *data)\n{\n}\n", MangleName(fnc));
					}
					break;
				case RAD_SLIDEBARH:
				case RAD_SLIDEBARV:
				case RAD_LABEL:
				case RAD_PUSHBUTTON1:
				case RAD_PUSHBUTTON2:
				case RAD_POINTBUTTON:
				case RAD_CHECKBUTTON:
				case RAD_EDITBOX1:
				case RAD_EDITBOX2:
				case RAD_EDITBOX3:
				case RAD_MENU:
					Comments(1, gps);
					if ((rc=AddSymbol(fnc, V_FNC_WIDGET)) > 0) return;
					else if (rc==0)
					{
						sprintf(gps, "static void %s(CallBack)\n{\n}\n", MangleName(fnc));
					}
					break;
			}
			if (rc==0)
			{
				Write(gps);
				Write("\n");
			}
		}
	}
}

static int CodeGen(Wind w[], int numwin)
{
	char *var, *fnc, name1[64], name2[64], key[16], buf1[16], buf2[16];
	int i,j,rc,first=0;

	wgn = 0;
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		first = 0;
		sprintf(gps2, "%sProc", MangleName(w[j].name));
		if ((rc=AddSymbol(gps2, V_FNC_HANDLER)) > 0) return error;
		else if (rc<=0)
		{
			Comments(4);
			sprintf(gps, "static void %sProc(GuiEvent *p)\n{\n", MangleName(w[j].name));
			Write(gps, nTab++);
		}
		if (w->flags & WCLICKABLE)
		{
			Write("int	xWnd = p->GetX();\n", nTab);
			Write("int	yWnd = p->GetY();\n", nTab);
		}
		if (w->flags & WSIZEABLE)
		{
			Write("int	wWnd = p->wnd->GetWW();\n", nTab);
			Write("int	hWnd = p->wnd->GetHW();\n", nTab);
		}
		Write("switch(p->Type()) {\n", nTab++);

		Case("INITEVENT");
		Write("set_ppop(_GSET);\n", nTab);

		for(i=0;i<w[j].items;i++)
		{
			if (a[i].variable[0]>' ') var =	MangleName(a[i].variable, name1); else var ="0";
			if (a[i].fnc[0]>' ') fnc =	MangleName(a[i].fnc, name2); else fnc ="0";
			if (a[i].flags&ACCF_PREDEF)
			{
				if (a[i].key<0) strcpy(key, acckey[-a[i].key].name);
			}
			else if (a[i].key>=' ' && a[i].key<=127) sprintf(key,"'%c'", a[i].key);
			else  sprintf(key,"%d", a[i].key);

			if (a[i].flags&ACCF_BGROUP && first==0)
			{
				first = 1;
				Write("Control *tmpCtrlPtr;\n", nTab);
			}

			Write("", nTab); // write tabs
			if (a[i].flags&ACCF_BGROUP)
			{
				Write2("tmpCtrlPtr = ");	//
			}

			switch(a[i].type)
			{
			default:
//				assert(0);
				break;
			case RAD_PROGRESSBAR:
				sprintf(gps, "pbarPtr%d = p->wnd->%s(%d, %d, %d, %d, %d);\n",
					wgn++, GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].ww);
				break;
			case RAD_LISTBOX:
				if (!strcmp(fnc, "0"))
				{
					sprintf(gps2, "Missing fnc: %s in ListBox %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				if (!strcmp(var, "0"))
				{
					sprintf(gps2, "Missing variable: in ListBox %s %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				sprintf(gps, "listboxPtr%d = p->wnd->%s(%d, %d, %d, %d, %d, %d, (int *)0, &%s, %s, (void *)0);\n",
					wgn++, GetFnc(a[i].type), a[i].x, a[i].y, a[i].ww, a[i].hh, a[i].w, a[i].h, var, fnc);
				break;
			case RAD_SLIDEBARH:
			case RAD_SLIDEBARV:
				if (!strcmp(var, "0"))
				{
					sprintf(gps2, "Missing variable: %s in Slidebar %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, %d, &%s, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].ww, var, fnc);
				break;
			case RAD_POINTBUTTON:
			case RAD_CHECKBUTTON:
				sprintf(gps, "p->wnd->%s(%d, %d, \"%s\", %s, %s%s, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].name, key, *var=='0'?"":"&", var, fnc);
				break;
			case RAD_MENU:
				sprintf(gps, "p->wnd->%s(\"%s\", %s, %s);\n",
					GetFnc(a[i].type), a[i].name, key, fnc);
				break;
			case RAD_STRING:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, \"%s\");\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].name);
				else sprintf(gps, "p->wnd->%s(%d, %d, \"%s\", %s, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].name, Color(a[i].ink, buf1), Color(a[i].paper, buf2));
				break;
			case RAD_RECT:
			case RAD_BOX:
			case RAD_LINE:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h);
				else sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, Color(a[i].ink, buf1));
				break;
			case RAD_BITMAP:
				sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, %d, %d, bmp%03dPtr);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, 0,0, a[i].w, a[i].h, GetBmpIndex(a[i].bmp));
				break;
			case RAD_EDITBOX1:
			case RAD_EDITBOX2:
				if (!strcmp(var, "0"))
				{
					sprintf(gps2, "Missing variable: %s in EditBox %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				if (!(a[i].flags&ACCF_CHECK)) sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, &%s, %s)",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc);
				else
				{
					if (a[i].type==RAD_EDITBOX1)
					{
						sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, &%s, %s, %d, %d)",
							GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc, a[i].min, a[i].max);
					}
					else
					{
						sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, &%s, %s, %f, %f)",
							GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc, a[i].mind, a[i].maxd);
					}
				}
				if (a[i].flags&ACCF_VARSIZE)
				{
					sprintf(gps2, "(%s)->SetSize(%d)", gps, a[i].w);
					sprintf(gps,"%s;\n", gps2);
				}
				else sprintf(gps,"%s;\n", gps);
				break;
			case RAD_EDITBOX3:
				if (!strcmp(var, "0"))
				{
					sprintf(gps2, "Missing variable: %s in EditBox %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				if (a[i].flags&ACCF_VARSIZE)
					sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, %s, %s);\n",
						GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc);
				else
					sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, %d, \"%s\", %s, %s, %s);\n",
						GetFnc(a[i].type), a[i].ww, a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc);
				break;
			case RAD_ARC:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, %f, %f, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].mind, a[i].maxd, a[i].w);
				else sprintf(gps, "p->wnd->%s(%d, %d, %f, %f, %d, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].mind, a[i].maxd, a[i].w, Color(a[i].ink, buf1));
				break;
			case RAD_CIRCLE:
			case RAD_FILLCIRCLE:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w);
				else sprintf(gps, "p->wnd->%s(%d, %d, %d, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, Color(a[i].ink, buf1));
				break;
			case RAD_ELLIPSE:
			case RAD_FILLELLIPSE:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h);
				else sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, Color(a[i].ink, buf1));
				break;
			case RAD_LABEL:
				sprintf(gps, "p->wnd->%s(%d, %d, \"%s\", %s, %s);\n",
				GetFnc(a[i].type), a[i].x, a[i].y, a[i].name, key, fnc);
				break;
			case RAD_PUSHBUTTON1:
				sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, %s);\n",
				GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, fnc);
				break;
			case RAD_PUSHBUTTON2:
				sprintf(gps, "p->wnd->%s(%d, %d, %s, bmp%03dPtr, %s);\n",
				GetFnc(a[i].type), a[i].x, a[i].y, key, GetBmpIndex(a[i].bmp), fnc);
				break;
			}
			Write2(gps);
			if (a[i].flags&ACCF_BGROUP)
			{
				sprintf(gps, "bgPtr%d->AddToGroup(tmpCtrlPtr%s);\n", a[i].bgrp, first==1?", 1":"");	//
				first++;
				Write(gps, nTab);	//
			}
		}
		Break();

		Case("KEYEVENT");
		Break();

		Case("REPAINTEVENT");
		Break();

		if (w->flags&WNOTIFY)
		{
			Case("NOTIFYEVENT");
			Break();
		}
		if (w->flags&WMINIMIZE)
		{
			Case("ICONIZEEVENT");
			Break();
		}
		if (w->flags&WCLICKABLE)
		{
			Case("CLICKLEFTEVENT");
			Break();
		}
		if (w->flags&WSIZEABLE)
		{
			Case("WINDOWRESIZEEVENT");
			Break();
		}
		if (accelPresent)
		{
			Case("ACCELEVENT");
			Break();
		}
		Case("TERMINATEEVENT");
		Break();

		Write("}\n", --nTab);
		Write("}\n\n", --nTab);
	}
	Write("\n");
	return 0;
}

static void ColorGen(Palette *paleta)
{
	char buf[16];
	for(int i=16; i<256; i++) if (paleta[i].alfa) // if color is used
	{
		sprintf(gps, "CreateColor(%d, %d, %d, %s);\n", paleta[i].r, paleta[i].g, paleta[i].b, Color(i, buf));
		Write(gps, nTab);
	}	
}

char *Flagy(unsigned f)
{
	static char s[256];
	int i,a=0;
	s[0]=0;
	for(i=0; i<27; i++)
	{
		if (f&wflag[i].value)
		{
			if (a) strcat(s,"|");
			a = 1;
			strcat(s, wflag[i].name);
		}
	}
	return s;
}

void GenerateCScheme(Projekt *p)
{
	char buf[16];
	Write("ColorScheme myownCScheme = { ");
	for(int i=0;i<(int)sizeof(ColorScheme)/4;i++)
	{
		sprintf(gps, "%s, ", Color(((int *)(&p->cscheme))[i],buf));
		Write(gps);
	}
	Write("};\n\n");
}

// return 0 if OK else err code
int Compile(Projekt *p)
{
	int retval,i;
	char flagy[256]=", ", name[64], *tmp=name, cs[16], cs2[16];
	symindex = 0;
	error = isCode = 0;

	prj->Save();
	Wind  *w  = p->Okno;
	config = accelPresent = 0;

	strncpy(name, p->prjname, 63);
	while(*tmp>=' ' && *tmp!='.') tmp++;
	*tmp = 0;
	sprintf(gps,"%s.cc",name);
	strcpy(srcname,gps);
	fp=fopen(gps,"w");
	memset(symtype, 0, sizeof(symtype));
	memset(grupy, 0, sizeof(grupy));
	if (fp==NULL) return error = 1; // EOPEN_FILE

	Write("//\n//	source generated by 'OpenGUI sourcer'\n//\n\n");
	Write("#include <fastgl.h>\n");
	Write("#include <widgets.h>\n\n");
	Write("\n");

	VariableGen(w, p->nwin, p);
	if (memcmp(&p->cscheme, old_scheme, sizeof(ColorScheme)))
		GenerateCScheme(p);
	BGPtr("static ButtonGroup *bgPtr%d;\n");
	Write("\n");
	
	if (error) goto final;

	if (p->bmp_num) BitmapGen(p->bmp_num);
	if (error) goto final;

	if (config)
	{
		Comments(3);
		ConfigStuff(w, p->nwin, 0);
		ConfigStuff(w, p->nwin, 1);
	}
	
	StubGen(w, p->nwin);
	if (error) goto final;

	retval = CodeGen(w, p->nwin);
	if (retval) goto final;

	Write("int main(int argc, char **argv)\n{\n");
	nTab++;
	if (p->app_altx) strcat(flagy, "+APP_ENABLEALTX");
	if (p->app_cfg) strcat(flagy, "+APP_CFG");
	if (p->app_magnify) strcat(flagy, "+APP_MAGNIFIER");
	if (p->app_root) strcat(flagy, "+APP_ROOTWINDOW");
	if (p->app_wnd) strcat(flagy, "+APP_WINDOWDATABASE");
	sprintf(gps, "App MyApp(%s, argc, argv, %s%s);\n", mode_str[p->video_mode+1], Color(p->back_color,cs), flagy);
	Write(gps, nTab);
	if (config)
		Write("_load_config();\n", nTab);
	ColorGen(p->paleta);
	if (memcmp(&p->cscheme, old_scheme, sizeof(ColorScheme)))
	{
		Write("memcpy(CScheme, &myownCScheme, sizeof(ColorScheme));\n", nTab);
	}
	if (p->bmp_num)	Write("_load_bitmaps();\n", nTab);
	BGInstance("bgPtr%d = new ButtonGroup(%d);\n");
	if (p->font)
	{
		sprintf(gps, "set_font(%s);\n", font_str[p->font-1]);
		Write(gps, nTab);
	}
	for(i=0; i<p->nwin; i++)
	{
		sprintf(gps, "%sPtr = new Window(&%sPtr, %d, %d, %d, %d, \"%s\", %sProc, %s, %s, %s);\n",
			MangleName(w[i].name), MangleName(w[i].name), w[i].x, w[i].y, w[i].w, w[i].h, w[i].name, MangleName(w[i].name, name), Color(w[i].ink,cs), Color(w[i].paper,cs2), Flagy(w[i].flags));
		Write(gps, nTab);
	}
	if (p->app_root) Write("rootPtr = cApp->GetRootWindow();\n", nTab);
	Write("MyApp.Run();\n", nTab);
	if (p->bmp_num)	Write("_unload_bitmaps();\n", nTab);
	if (config)
		Write("_save_config();\n", nTab);
	for(i=0; i<p->nwin; i++)
	{
		sprintf(gps, "if (%sPtr) delete %sPtr;\n", MangleName(w[i].name), MangleName(w[i].name));
		Write(gps, nTab);
	}
	BGPtr("delete bgPtr%d;\n");
	Write("return 0;\n", nTab);
	nTab--;
	Write("}\n");

final:
	fclose(fp);
	isCode = 1;
	return error;
}

// return no. of symbols
int GenTable(Projekt *p)
{
	int i,j;
	Wind *w=p->Okno;
	int numwin=p->nwin;

	wgn = 0;
	symindex = 0;
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		for(i=0; i<w[j].items; i++)
		{
			switch((int)a[i].type)
			{
			case RAD_EDITBOX1:
			case RAD_POINTBUTTON:
			case RAD_CHECKBUTTON:
			case RAD_SLIDEBARH:
			case RAD_SLIDEBARV:
			case RAD_LISTBOX:
				if (a[i].variable[0]>' ')
				{
					AddSymbol(a[i].variable, V_INT);
				}
				break;
			case RAD_EDITBOX2:
				if (a[i].variable[0]>' ')
				{
					AddSymbol(a[i].variable, V_DOUBLE);
				}
				break;
			case RAD_EDITBOX3:
				if (a[i].variable[0]>' ')
				{
					AddSymbol(a[i].variable, V_STRING);
				}
				break;
			}
		}
	}
	return symindex;
}

// remove all from current that is not in exported table
void CleanupTable(Projekt *p, int& sym)
{
	int i,j;
	for(i=0;i<MAX_VAL;i++)
	{
		if (*p->values[i].name == 0) break;
		for(j=0;j<symindex;j++)
		{
			if (strcmp(p->values[i].name, symtab[j])==0) break;
		}
		if (j==symindex && sym) // remove it
		{
			memmove(p->values+i, p->values+i+1, sizeof(Values)*sym);
			memset(p->values+sym-1, 0, sizeof(Values));
			sym--;
		}
	}
}

// insert to project all symbols that are still missing
void ImportTable(Projekt *p, int& sym)
{
	int i,j;
	for(j=0;j<symindex;j++)
	{
		for(i=0;i<MAX_VAL;i++)
		{
			if (*p->values[i].name == 0) { i=MAX_VAL; break; }
			if (strcmp(p->values[i].name, symtab[j])==0) break;
		}
		if (i==MAX_VAL && sym<MAX_VAL) // remove it
		{
			memset(&p->values[sym].name, 0, MAXVAR);
			memmove(&p->values[sym].name, symtab[j], sizeof(Values));
			p->values[sym].type = symtype[j];
			sym++;
		}
	}
}

