/*
 * Copyright (c) 1991, 1992 Brad Eacker,
 *              (Music, Intuition, Software, and Computers)
 * All Rights Reserved
 */

#include <stdio.h>
#include "dbf_sym.h"

char *strsave();

struct sym_def sym_tab[100];
int	sym_len = 0;

char *
s_lookup(yylex)
int	yylex;		/* Constant or Identifier */
{
	extern YYSTYPE yylval;
	extern char yytext[];
	extern char *strsave();
	register struct sym_def *low = sym_tab,
				*high = &sym_tab[sym_len],
				*mid;
	int c;

	if (sym_len > 0) {
		while (low <= high) {
			mid = low + (high - low)/2;
			if ((c = strcmp(mid->sig_name, yytext)) == 0)
				return mid->sig_name;
			else if (c < 0)
				low = mid + 1;
			else
				high = mid - 1;
		}
	} else {
		mid = sym_tab;
	}
	for (high = &sym_tab[sym_len]; high >= mid; high--) {
		high[1] = high[0];
	}
	mid->sig_name = strsave(yytext);
	yylval = mid->sig_name;
}

char *
strsave(cp)
char *cp;
{
	int len;
	char *np;

	len = strlen(cp);
	if (np = (char *)malloc(len+1))
		strcpy(np, cp);
	return np;
}
