/*
 * Copyright (c) 1991, 1992, 1993 Brad Eacker,
 *              (Music, Intuition, Software, and Computers)
 * All Rights Reserved
 */

#define	USAGE	"usage: dbftst <file>\n"

/*
 * test routine to check out the header and fields
 */
#include <stdio.h>
#include <fcntl.h>

#include "dbf.h"

main(argc, argv)
int	argc;
char	**argv;
{
	dbhead_t 	*dbh;
	dbfield_t	*dbf, *cur_f;
	int	fd, nfields;
	u_char	*cp;

	if (argc < 2) {
		printf(USAGE);
		exit(1);
	}
	argv++;
	if ((fd = open(*argv, O_RDONLY)) < 0) {
		cp = (u_char *)malloc(256);
		strcpy(cp, *argv); strcat(cp, ".dbf");
		if ((fd = open(cp, O_RDONLY)) < 0) {
			perror("open");
			exit(1);
		}
		free(cp);
	}

	/* go get the header */
	if ((dbh = get_dbf_head(fd)) == NULL) {
		fprintf(stderr, "Unable to get header\n");
		exit(1);
	}

	nfields = dbh->db_nfields;

	printf("# fields: %d, record len: %d\n", nfields, dbh->db_rlen);

	/* step thru the field info */
	dbf = dbh->db_fields;
	for (cur_f = dbf; cur_f < &dbf[nfields] ; cur_f++) {
		printf("  %s, %c, %d, %d\n", cur_f->db_fname, cur_f->db_type,
			cur_f->db_flen, cur_f->db_fdc);
	}
}
