/*
 * Copyright (c) 1993 Brad Eacker,
 *              (Music, Intuition, Software, and Computers)
 * All Rights Reserved
 */

#define	USAGE	"usage: dbfdel <file> [<record> <record> ...]\n"

/*
 * display the records of the database in question to the stdout
 */
#include <stdio.h>
#include <fcntl.h>

#include "dbf.h"

main(argc, argv)
int	argc;
char	**argv;
{
	dbhead_t 	*dbh;
	dbfield_t	*dbf, *cur_f;
	char	*fnp;
	u_char	*cp, *t_cp;
	int	fd, nfields;
	int	rec_num;

	if (argc < 2) {
		printf(USAGE);
		exit(1);
	}
	argv++;	argc--;
	if ((fd = open(*argv, O_RDWR)) < 0) {
		cp = (u_char *)malloc(256);
		strcpy(cp, *argv); strcat(cp, ".dbf");
		free(cp);
		if ((fd = open(cp, O_RDWR)) < 0) {
			perror("open");
			exit(1);
		}
	}
	argv++;	argc--;

	if ((dbh = get_dbf_head(fd)) ==	 0) {
		fprintf(stderr, "Unable to get header\n");
		exit(1);
	}

	while (argc-- > 0) {
		rec_num = strtol(*argv++, NULL, 0);
		if (del_dbf_record(dbh, rec_num) < 0) {
			if (rec_num > dbh->db_records) {
				fprintf(stderr, "record %d out of bounds\n",
						 rec_num);
				continue;
			} else {
				fprintf(stderr, "unable to delete record %d\n",
						 rec_num);
			}
		}
	}
	if (cp = db_cur_date(NULL)) {
		strncpy(dbh->db_date, cp, 8);
	}
	put_dbf_info(dbh);
}
