/*
 * Copyright (c) 1991, 1992, 1993 Brad Eacker,
 *              (Music, Intuition, Software, and Computers)
 * All Rights Reserved
 */

/*
 * routine to change little endian long to host long
 */
long
get_long(cp)
unsigned char *cp;
{
	int ret;

	ret = *cp++;
	ret += ((*cp++)<<8);
	ret += ((*cp++)<<16);
	ret += ((*cp++)<<24);

	return ret;
}

put_long(cp, lval)
unsigned char *cp;
long lval;
{
	*cp++ = lval & 0xff;
	*cp++ = (lval >> 8) & 0xff;
	*cp++ = (lval >> 16) & 0xff;
	*cp++ = (lval >> 24) & 0xff;
}

/*
 * routine to change little endian short to host short
 */
get_short(cp)
unsigned char *cp;
{
	int ret;

	ret = *cp++;
	ret += ((*cp++)<<8);

	return ret;
}

put_short(cp, sval)
unsigned char *cp;
{
	*cp++ = sval & 0xff;
	*cp++ = (sval >> 8) & 0xff;
}

copy_fill(dp, sp, len)
unsigned char	*dp, *sp;
int		len;
{
	while (*sp && len > 0) {
		*dp++ = *sp++;
		len--;
	}
	while (len-- > 0)
		*dp++ = ' ';
}

copy_crimp(dp, sp, len)
unsigned char	*dp, *sp;
int		len;
{
	while (len-- > 0) {
		*dp++ = *sp++;
	}
	*dp = 0;
	for (dp-- ; *dp == ' '; dp--) {
		*dp = 0;
	}

}

db_set_date(cp, year, month, day)
unsigned char *cp;
int year, month, day;
{
	if (month > 12)
		month = 0;
	if (day > 31)
		day = 0;
	sprintf(cp, "%d", year);
	cp[4] = month / 10 + '0';
	cp[5] = month % 10 + '0';
	cp[6] = day / 10 + '0';
	cp[7] = day % 10 + '0';
	cp[8] = 0;
}

db_date_year(cp)
unsigned char *cp;
{
	int	year, i;

	for (year = 0, i = 0; i < 4; i++)
		year = year * 10 + (cp[i] - '0');
	return year;
}

db_date_month(cp)
unsigned char *cp;
{
	int	month, i;

	for (month = 0, i = 4; i < 6; i++)
		month = month * 10 + (cp[i] - '0');
	return month;
}

db_date_day(cp)
unsigned char *cp;
{
	int	day, i;

	for (day = 0, i = 6; i < 8; i++)
		day = day * 10 + (cp[i] - '0');
	return day;
}

#include <time.h>

unsigned char *
db_cur_date(cp)
unsigned char *cp;
{
	struct tm *ctm;
	time_t	  c_time;

	c_time = time((time_t *)NULL);
	ctm = localtime(&c_time);
	if (cp == NULL)
		cp = (unsigned char *)malloc(9);

	if (ctm == NULL || cp == NULL)
		return NULL;

	db_set_date(cp, ctm->tm_year + 1900, ctm->tm_mon + 1, ctm->tm_mday);

	return cp;
}
