/*
 * Copyright (c) 1991, 1992, 1993 Brad Eacker,
 *              (Music, Intuition, Software, and Computers)
 * All Rights Reserved
 */

/*
 * dbf header structure on disk (pc dbase III)
 *
 *  Basic info taken from:
 *	"File Formats for Popular PC Software"
 *	Jeff Walden
 *	(c) 1986 John Wiley & Sons, Inc.
 */

#ifndef	_DBF_H_
#define	_DBF_H_

#if !defined(UCHAR)
typedef	unsigned char	u_char;
#endif

struct dbf_dhead {
	u_char	dbh_dbt;		/* memo (dbt) file present */
	u_char	dbh_date[3];		/* last update YY, MM, DD */
	u_char	dbh_records[4];		/* number of records LE */
	u_char	dbh_hlen[2];		/* header length LE */
	u_char	dbh_rlen[2];		/* record length LE */
	u_char	dbh_res[20];		/* padding */
};
#define	DBH_DATE_YEAR	0		/* byte offset for year in dbh_date */
#define	DBH_DATE_MONTH	1
#define	DBH_DATE_DAY	2

/*
 * field description on disk
 */

#define	DBF_NAMELEN	11

struct dbf_dfield {
	u_char	dbf_name[DBF_NAMELEN];	/* name of field */
	u_char	dbf_type;		/* type of field */
	u_char	dbf_fda[4];		/* something for dbase III */
	u_char	dbf_flen[2];		/* field length [and decimal if N] */
	u_char	dbf_res[14];		/* padding */
};

struct db_field {
	u_char	db_fname[DBF_NAMELEN+1];	/* 0 terminated */
	u_char	db_type;		/* type of field */
	int	db_flen;		/* length of field */
	int	db_fdc;			/* number of decimals in field */

	u_char	*db_format;		/* format for printing %s etc */
	int	db_foffset;		/* offset within record */
};
typedef struct db_field	dbfield_t;

struct db_head {
	int	db_fd;
	u_char	db_dbt;			/* dbt present */
	u_char	db_date[9];		/* date of last update in db format */
	long	db_records;		/* number of records */
	int	db_hlen;		/* header length */
	int	db_rlen;		/* record length */

	int	db_nfields;		/* number of fields */
	dbfield_t	*db_fields;	/* field info */
};
typedef struct db_head	dbhead_t;

#define	DBH_TYPE_NORMAL	0x03
#define	DBH_TYPE_MEMO	0x83

#define	VALID_RECORD	' '
#define	DELETED_RECORD	'*'

extern dbhead_t *get_dbf_head();
extern u_char *get_dbf_record();
extern u_char *get_dbf_f_fmt();
extern long get_long();
extern unsigned char *db_cur_date();

#if defined(MEMSET)
#define	bzero(_ptr, _len)	memset(_ptr, 0, _len)
#endif

#endif	/* _DBF_H_ */
