#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <linux/dn.h>
static  char	nodetag[80],nametag[80],nodeadr[80],nodename[80];
static  char	linetag[80],devname[80];
static	struct dn_naddr	binadr = {0x06,0xAA,0x00,0x04,0x00,0x00,0x00};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
struct	dn_naddr	*dnet_addr(char *addr)
{
	char	**endptr;
	long	area,node;
	endptr=&addr;
	area=strtol(addr,endptr,0);
	node=strtol(*endptr+1,endptr,0);
	if ((area < 0) || (area > 63) || (node < 0) || (node > 1023))
	{
		printf("dnet_addr: invalid decnet addres %d.%d\n",area,node);
		exit(-1);
	}
	binadr.a_addr[4] = node & 0xFF;
	binadr.a_addr[5] = (area << 2) | ((node & 0x300) >> 8); 
	return &binadr;
}
/*--------------------------------------------------------------------------*/
char *getexecdev(void)
{
	FILE		*dnhosts;
	char		nodeent[80];

	if ((dnhosts = fopen("/etc/decnet.conf","r")) == NULL)
	{
		printf("getnodebyname: Can not open /etc/decnet.conf\n");
		exit(-1);
	}
	while (fgets(nodeent,80,dnhosts) != NULL)
	{
		sscanf(nodeent,"%s%s%s%s%s%s\n",nodetag,nodeadr,nametag,
		       nodename,linetag,devname);
		if (strncmp(nodetag,"#",1) != 0)	
		{
		   if (((strcmp(nodetag,"executor") != 0) &&
	    	       (strcmp(nodetag,"node")     != 0)) ||
		       (strcmp(nametag,"name")     != 0))
		   {
		       printf("getnodebyname: Invalid decnet.conf syntax\n");
		       exit(-1);
		   }
		   if (strcmp(linetag,"line") == 0) return devname;
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
char *getnodeadd(void)
{
	FILE		*dnhosts;
	char		nodeent[80];

	if ((dnhosts = fopen("/etc/decnet.conf","r")) == NULL)
	{
		printf("getnodebyname: Can not open /etc/decnet.conf\n");
		exit(-1);
	}
	while (fgets(nodeent,80,dnhosts) != NULL)
	{
		sscanf(nodeent,"%s%s%s%s\n",nodetag,nodeadr,nametag,nodename);
		if (strncmp(nodetag,"#",1) != 0)	
		{
		   if (((strcmp(nodetag,"executor") != 0) &&
	    	       (strcmp(nodetag,"node")     != 0)) ||
		       (strcmp(nametag,"name")     != 0))
		   {
		       printf("getnodebyname: Invalid decnet.conf syntax\n");
		       exit(-1);
		   }
		   if (strcmp(nodetag,"executor") == 0) return nodeadr;
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
char *getnodebyname(char *name)
{
	FILE		*dnhosts;
	char		nodeent[80];

	if ((dnhosts = fopen("/etc/decnet.conf","r")) == NULL)
	{
		printf("getnodebyname: Can not open /etc/decnet.conf\n");
		exit(-1);
	}
	while (fgets(nodeent,80,dnhosts) != NULL)
	{
		sscanf(nodeent,"%s%s%s%s\n",nodetag,nodeadr,nametag,nodename);
		if (strncmp(nodetag,"#",1) != 0)	
		{
		   if (((strcmp(nodetag,"executor") != 0) &&
	    	       (strcmp(nodetag,"node")     != 0)) ||
		       (strcmp(nametag,"name")     != 0))
		   {
		       printf("getnodebyname: Invalid decnet.conf syntax\n");
		       exit(-1);
		   }
		   if (strcmp(nodename,name) == 0) return nodeadr;
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/

