/* Portions ripped out of insmod.c from the modutils package. Those portions 
   are copyright by their respective authors. (I'm not sure who wrote what)
   The rest of the code is:                                     
   Copyright 1998 Aaron Sethman <androsyn@n3ryb.dyn.ml.org> or 
   <asethman@nctm.org>  


   This could perhaps be integrated into modutils package. Wouldn't take a
   whole heck of a lot integrate in with the rest of modutils package.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   This could perhaps be integrated into modutils package. Wouldn't take a
   whole heck of a lot integrate in with the rest of modutils package.

Changes from 1.00 
	November 2, 1998
	Fixed memory leak...It really helps if you free memory you malloc 
	Thanks to Ian Wehrman <iwehrman@r77h19.res.gatech.edu> for noticing
	this one.
	Actually uses the -t option now for sleeping
	The -V option actually works now too....	
	
*/	


#define VERSION_NO "1.01"

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <syslog.h>
#include <unistd.h>
#include <getopt.h>
#include <fcntl.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <errno.h>
#include <linux/module.h>
#include <asm/unistd.h>


void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t size);
void start_sig(void);
void sig_handler(int sig);
void usage(void);
unsigned int xsleep(unsigned int seconds);
void log(char *format,...);
int verbose = 0, no_syslog = 0;
void version(void);
/* The syscalls we need */
_syscall5(int, query_module, const char *, name, int, which,
	  void *, buf, size_t, bufsize, size_t *, ret);
_syscall1(int, delete_module, const char *, name);


int main(int argc, char *argv[])
{
	int fd, opt, no_fork = 0, rm_never = 0;
	char *module_names, *m, *refs, *msg;
	unsigned long unload_sleep;
	size_t bufsize, ret, nmod, i;
	pid_t x;
	while ((opt = getopt(argc, argv, "t:fuhvVl")) != EOF) {
		switch (opt) {
		case 't':
			{
				unload_sleep = strtoul(optarg, NULL, 10);
				if (errno != 0 || unload_sleep == 0)
					usage();
				break;
			}
		case 'f':
			{
				no_fork = 1;
				break;
			}
		case 'h':
			{
				usage();
				break;
			}
		case 'v':
			{
				verbose = 1;
				break;
			}
		case 'V':
			{
				version();
				break;
			}
		case 'l':
			{
				no_syslog = 1;
				break;
			}
		case 'u':
			{
				rm_never = 1;
				break;
			}
		default:
			{
				break;
			}

		}
	}
	if (unload_sleep == 0) {
		unload_sleep = 60;
	}
	if (no_fork != 1) {
		if ((x = fork())) {
			log("Modremove started: pid %d", x);
			exit(0);
		} else if (x == -1) {
			perror("Error forking");
			exit(-1);
		}
	}
	openlog("Modremove", LOG_PID, LOG_INFO);
	start_sig();
	while (1) {
	      retry_mod:
		module_names = xmalloc(bufsize = 1024);
		if (query_module(NULL, QM_MODULES, module_names, bufsize, &ret)) {
			if (errno == ENOSPC) {
				module_names = xrealloc(module_names, bufsize = ret);
				goto retry_mod;
			}
		}
		nmod = ret;
		refs = xmalloc(bufsize = 1024);
		for (i = 0, m = module_names; i < nmod; ++i, m += strlen(m) + 1) {
			char msg1[30];
			struct module_info info;
			size_t j, val;
			query_module(m, QM_INFO, &info, sizeof(info), &ret);
			if (rm_never == 1) {
				if ((info.flags & MOD_AUTOCLEAN) && (info.usecount == 0)) {
					query_module(m, QM_REFS, NULL, 0, &val);

					if (val == 0) {
						log("Removing module %s", m);
						delete_module(m);
					}
				}
			} else {
				if ((info.flags & MOD_AUTOCLEAN) && (info.usecount == 0) && ((info.flags & MOD_USED_ONCE) != 0)) {
					query_module(m, QM_REFS, NULL, 0, &val);

					if (val == 0) {
						log("Removing module %s", m);
						delete_module(m);
					}
				}
			}
		}
		free(refs);
		free(module_names);
		xsleep(unload_sleep);
	}
}
void *
 xmalloc(size_t size)
{
	void *ptr = malloc(size);
	if (!ptr) {
		log("Out of memory\n");
		exit(-1);
	}
	return ptr;
}

void *
 xrealloc(void *ptr, size_t size)
{
	ptr = realloc(ptr, size);
	if (!ptr) {
		log("Out of memory\n");
		exit(-1);
	}
}


unsigned int xsleep(unsigned int seconds)
{
	/* I use this just because I don't really like the standard sleep 
	   function that uses SIGALRM...at least on libc5 I don't know as for
	   glibc2.  Maybe something like this should replace it...
	 */
	struct timespec nano;
	struct timespec n_nano;
	nano.tv_sec = seconds;
	nano.tv_nsec = 0;
	nanosleep(&nano, &n_nano);
	return ((unsigned int) nano.tv_sec - n_nano.tv_sec);
}

void start_sig(void)
{
	int x;
	for (x = 1; x <= 30; x++)
		signal(x, *sig_handler);

	return;
}

void sig_handler(int sig)
{
	log("Modremove quitting: %s", strsignal(sig));
	exit(-1);
}

void usage(void)
{
	fprintf(stderr, "");
	fprintf(stderr, "Modremove: usage\n");
	fprintf(stderr, "modremove [ -huflvV ] [ -t time ]\n\n");
	fprintf(stderr, "-t time                Time in seconds; How often to check for modules\n");
	fprintf(stderr, "                       that can be autocleaned\n");
	fprintf(stderr, "-u                     Allows modremove to unload modules that have never\n");
	fprintf(stderr, "                       been used\n");
	fprintf(stderr, "-f                     Don't fork; Causes modremove not to run in the backgroud\n");
	fprintf(stderr, "-v                     Verbose; Outputs all messages to stderr\n");
	fprintf(stderr, "-l                     Don't use syslog\n");
	fprintf(stderr, "-V                     Program version\n");
	fprintf(stderr, "-h                     This message\n");
	fprintf(stderr, "\n\n");
	fprintf(stderr, "Default options are: -t 60\n");
	fprintf(stderr, "By default modremove logs to syslog\n");
	exit(0);
}
void log(char *format,...)
{
	va_list ap;
	char *str;
	va_start(ap, format);

	str = malloc(1024);	/* Should be plenty...... */
	vsnprintf(str, 1024, format, ap);
	if (verbose == 1)
		fprintf(stderr, "%s", str);
	if (no_syslog == 0)
		syslog(LOG_INFO, "%s", str);
	return;
}

void version(void)
{
	fprintf(stderr, "Modremove %s\n", VERSION_NO);
	fprintf(stderr, "Copyright 1998 Aaron Sethman\n");
	fprintf(stderr, "                               <androsyn@n3ryb.dyn.ml.org>\n");
	fprintf(stderr, "                               <asethman@nctm.org>\n");
	fprintf(stderr, "Licensed under the GNU General Public License\n");
	fprintf(stderr, "See the file COPYING for details\n");
	exit(1);

}
