/*
   OK. First things first.
   This is a hack. It is a complete hack. Just 
   enough to get it working. & enough to call it
   Rev 0.1 (alpha).
   
   Second thing is that i'm a chemist, not an engineer
   or a computer scientist. I learned to program on pascal
   so if you don't like my style - tough. :-)
   I'm using this as an opportunity to learn to program C
   under Unix. (DOS/Windows/NT are just a waste of time. :-) )
   
   OK so what does it do? Well it's a command line / shell program that
   can be used to pull teletext pages from an OPT III external teletext adapter.
   It currently pulls the pages in binary form and converts to ascii but I'll make
   this optional later.
   
   The only arguments that are really supported so far is specifying the 
   TV channel frequency and the page number to pull.
   
   The frequency (-f)  must be in hex as in the little booklet you get with with the
   adapter. I'll maybe change it later to use human readable frequencies.
   
   The page number (-p) is just a 3 digit number
   
   ie. teletext -f 2d81 -p 100
   
   Sub pages & the other 3 acquisition channels will be supported later when I get time.
   
   What's it usefull for? Well maybe for spooling teletext pages for later processing
   by something like perl to extract usefull info.
   
   OK OK. A really usefull piece of info is your local transmission frequencies!!!!!
   Either get hold of them or spend hours with the sweepchannel script i've included.

   Other UNIX support? Only Linux. and maybe DGUX. If you can port it to other
   stuff then great. I don't have access to other Unices.

*/
#include <stdio.h>
#include <fcntl.h>			/* This has the open function in it */
#include <unistd.h>		/* This has the isatty function in it */
#include <termios.h>		/* Stuff for terminal control */
#include <string.h>		/*This header contains info on string functions*/
#include <getopt.h>		/*Standard header for getting options*/
#include <stdlib.h>		/* Header for the atoi function*/
/*****************************************************************************/
#define numbytes 1
#define FALSE 0
#define TRUE 1

#define ttxt_wakeup 0x00
#define ttxt_inithware 0x81
#define ttxt_selfreq 0x82
#define ttxt_reqpage 0x83
#define ttxt_pagereceived 0x84
#define ttxt_readrow 0x85
#define ttxt_readpage 0x86
#define ttxt_clrpgrec 0x87
#define ttxt_holdpage 0x88
#define ttxt_getcrc 0x89
#define ttxt_getsubcode 0x8a

#define pathlength 256
#define buffersize 962
#define spool_dir "/var/spool/teletext/"

/*****************************************************************************/
/* Set up the GLOBAL variables */
unsigned char  tempcount, 
        	gotpage,
                rawtoggle = FALSE,
                channel = 0x00,
                freqnumber[2],
                temporary[3] = {0x0, 0x0, 0x0},
                pagesubpage[7] = {0x0, 0x0, 0x0, 0x10, 0x10, 0x10, 0x10},
                freqsweep,
                currentpage[buffersize],
                outputfilename[256];
                
unsigned char *output_file,
        	*stringpointer,
        	*frequencypoint = freqnumber,
                *pagenumber = pagesubpage,
                *subpage,
                *ttydev;

int exitstatus = 0,
   option,
   filedesc, 
   counter, 
   intcount;
   
struct termios term;
/******************************************************************************/
/*****************************************************************************/
unsigned char opencoms(void);
unsigned char closecoms(void);
unsigned char senddata(unsigned char dataval);
unsigned char getdata(void);
unsigned char removeshit(unsigned char dataval);
unsigned char inithardware(void);
unsigned char selectfreq(unsigned char frequency[]);
unsigned char requestpage(unsigned char circuit ,unsigned char pagenumber[7]);
unsigned char pagereceived(unsigned char circuit);
void readrow(unsigned char circuit, unsigned char rownumber, unsigned char rowline[40]);
void readpage(unsigned char circuit, unsigned char page[]);
unsigned char clearreceiveflag(unsigned char circuit);
unsigned char holdcircuit(unsigned char circuit);
void getpagecrc(unsigned char circuit, unsigned char pagecrc[2]);
void getpagesubcode(unsigned char circuit, unsigned char subcode[2]);
void filter(unsigned char page[]);
void printascii(unsigned char page[]);
void writeascii(unsigned char page[], unsigned char filename[]);
/******************************************************************************/
/******************************************************************************/
void writeascii(unsigned char page[], unsigned char filename[])
{/*This is another copy of the example*/
    unsigned char row,
       		column;
    FILE *outputfile;


   outputfile = fopen(filename, "w");
   for(row = 0; row < 24; row = row + 1)
   {
      
      for(column = 0; column < 40; column = column + 1)
      {
      	fprintf(outputfile, "%c", page[(row * 40) + column]);
      }
      fprintf(outputfile, "\n");
   }
   fclose(outputfile);
}
/******************************************************************************/
void printascii(unsigned char page[])
{/*This is a copy of the example*/
 unsigned char row,
        	column;

   for(row = 0; row < 24; row = row + 1)
   {
  
      for(column = 0; column < 40; column = column + 1)
      {
      	printf("%c", page[(row * 40) + column]);
      }
      printf("\n");
   }
}
/******************************************************************************/
void getpagesubcode(unsigned char circuit, unsigned char subcode[2])
{
    unsigned char subpage;

    senddata(ttxt_getsubcode);
    senddata(circuit);
    for (subpage = 0 ; subpage <= 1 ; subpage = subpage + 1);
    {
	subcode[subpage] = getdata();
    }
}
/*****************************************************************************/
void getpagecrc(unsigned char circuit, unsigned char pagecrc[2])
{
    unsigned char crcval;

    senddata(ttxt_getcrc);
    senddata(circuit);
    for (crcval = 0 ; crcval <= 1 ; crcval = crcval + 1)
    {
	pagecrc[crcval] = getdata();
    }
}
/*****************************************************************************/
unsigned char holdcircuit(unsigned char circuit)
{
    senddata(ttxt_holdpage);
    senddata(circuit);
    return(getdata());
}
/*****************************************************************************/
unsigned char clearreceiveflag(unsigned char circuit)
{
    senddata(ttxt_clrpgrec);
    senddata(circuit);
    return(getdata());
}
/*****************************************************************************/
void readpage( unsigned char circuit, unsigned char page[])
{
    unsigned int pagechar;
/*    unsigned char crc[2];*/



    senddata(ttxt_readpage);
    senddata(circuit);
    
    for (pagechar = 0 ; pagechar < 961 ; pagechar = pagechar + 1)
    {
	page[pagechar] = getdata();
    }
/*    getpagecrc(circuit, crc);*/;

}
/*****************************************************************************/
void readrow( unsigned char circuit, unsigned char rownumber, unsigned char rowline[40])
{
    unsigned char column;

    senddata(ttxt_readrow);
    senddata(circuit);
    senddata(rownumber);
    for (column = 0 ; column <= 39 ; column = column + 1);
    {
	rowline[column] = getdata();
    }
}
/*****************************************************************************/
unsigned char pagereceived(unsigned char circuit)
{
    senddata(ttxt_pagereceived);
    senddata(circuit);
    return(getdata());
}
/*****************************************************************************/
unsigned char requestpage(unsigned char circuit, unsigned char pagenumber[])
{
    unsigned char page;

    senddata(ttxt_reqpage);
    senddata(circuit);
    for (page = 0 ; page <= 6; page = page + 1)
    {
	senddata(pagenumber[page]);
    }
    return(getdata());
}
/*****************************************************************************/
unsigned char selectfreq(unsigned char frequency[])
{
    unsigned char count;

    senddata(ttxt_selfreq);

    for (count = 0 ; count <= 1; count = count + 1)
    {
	senddata(frequency[count]);
	printf("selected frequency %x\n", frequency[count]);
    }
    return(getdata());
}
/*****************************************************************************/
unsigned char inithardware(void)
{
    /* Should return a 01 char. If it doesn't it hasn't worked. */
    senddata(ttxt_wakeup);
    senddata(ttxt_inithware);
    return(getdata());
}
/*****************************************************************************/
void filter(unsigned char page[])
{/*Pretty much copied from the example.*/
    unsigned char row, 
       column, 
       graphic, 
       doubleheight, 
       lastlinedouble;
       
    unsigned int count=0;

    lastlinedouble = FALSE;

    for (row = 0; row < 24; row = row + 1)
    {
	graphic = FALSE;
	doubleheight = FALSE;
	
	for (column = 0; column < 40; column = column + 1)
	{
           page[count] = page[count] & 0x7F;
	    if (page[count] <= 7)
	    {
		graphic = FALSE;
	    }

	    if (page[count] >= 16 && page[count] <=23)
	    {
		graphic = TRUE;
	    }

	    if (page[count] == 13)
	    {
		doubleheight = TRUE;
	    }

	    if (page[count] < 32 || graphic == TRUE || lastlinedouble == TRUE)
	    {
		if (page[count] < 64 || page[count] > 95)
		{
		    page[count] = ' ';
		}
	    }
	    count = count + 1;
	}
	lastlinedouble = doubleheight;
    }

}
/*****************************************************************************/
unsigned char getdata()
{
    unsigned char buffer[1];

    read(filedesc, buffer, numbytes);
    return(buffer[0]);
}
/*****************************************************************************/
unsigned char senddata(unsigned char sendval)
{
    unsigned char buffer[numbytes];

    buffer[0] = sendval;
    write(filedesc, buffer, numbytes);
    tcdrain(filedesc);
    return(0);
}
/*****************************************************************************/
unsigned char closecoms()
{
    return(close(filedesc));
}
/*****************************************************************************/
unsigned char   opencoms()
{
   /*Set up as blocking. I don't want to read & write at the same time */
    if ( (filedesc = open("/dev/teletext", O_RDWR)) < 0)
    {
	printf("Can't open /dev/teletext");
	return(-1);
    }

    if ( isatty(filedesc) == 0 )
    {
	printf("Sorry mate, the device specified is not a tty line\n");
	return(-1);
    }
    /* Set up the modem parameters*/
    term.c_cflag = CREAD | HUPCL | CLOCAL | CS8;
    /*Use local mode cos the adapter doesn't use modem control*/
    term.c_oflag = 0;						/* Turn off output processing */
    term.c_iflag = 0;						/* Turn off input processing */
    term.c_lflag = 0;						/* Turn off local processing */
    term.c_cc[VMIN] = 1;					/* 1 byte at a time */
    term.c_cc[VTIME] = 0;					/* Turn off timer */

    cfsetispeed(&term, B9600);				/* Set input & output baud rates */
    cfsetospeed(&term, B9600);

    if (tcsetattr(filedesc, TCSANOW, &term) < 0)
    {
	printf("Error setting attributes");
	return(-1);
    }
    return(0);
}
/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
int main( int argument_count, char *arguments[])
{
  
                 
  opterr = 0;		/*I believe this turns off stderr for the getopt routine */   
  while ( (option = getopt(argument_count, arguments, "f:o:p:rs:t:c:")) != EOF)
  {/*-f frequency, -o output file -p page no -s subpage -t terminal line -c channel -r raw */
     switch (option)
     {
      	case 'f': /* The frequency */
           
        stringpointer = optarg;

   	temporary[0] = *stringpointer++;
        temporary[1] = *stringpointer++;
        frequencypoint[0] = (char)strtol(temporary, (char**)NULL, 16);
   	temporary[0] = *stringpointer++;
        temporary[1] = *stringpointer++;
        frequencypoint[1] = (char)strtol(temporary, (char**)NULL, 16);


           if (frequencypoint == NULL)
           {
           	printf("Frequency not specified. Please specify the frequency with -f xxxx\n");
                exit(1);
           }
           break;
         
         case 'o': /* Output File  */
            output_file = optarg;
            strcpy(outputfilename, output_file);
            break;
         
         case 'p': /* Page number  */ 
            pagenumber = optarg;
            
            temporary[0] = *pagenumber++;
            temporary[1] = 0x00;
            pagesubpage[0] = (char)strtol(temporary, (char**)NULL, 16);

            temporary[0] = *pagenumber++;
            temporary[1] = 0x00;            
            pagesubpage[1] = (char)strtol(temporary, (char**)NULL, 16);

            temporary[0] = *pagenumber++;
            temporary[1] = 0x00;            
            pagesubpage[2] = (char)strtol(temporary, (char**)NULL, 16);

            break;
         
         case 'r': /* Output raw data */
            rawtoggle = TRUE;
            break;
         
         case 's': /* subpage number  */
            subpage = optarg;
            temporary[0] = *subpage++;
            temporary[1] = 0x00;
            pagesubpage[5] = (char)strtol(temporary, (char**)NULL, 16);

            temporary[0] = *subpage++;
            temporary[1] = 0x00;            
            pagesubpage[6] = (char)strtol(temporary, (char**)NULL, 16);
            /*OK. In order to make my life easier, I'm going to allow just 2 digits
            for the subpage code. want any more & i'll think about it*/
            break;
         
         case 't': /* The terminal line  */
            ttydev = optarg;
            /* Same here. just link /dev/teletext to the terminal for now.*/
            break;

         case 'c': /* The channel line  */
            channel = atoi(optarg);
            /*I reckon I'll have to implement multiple options on this one.*/
            break;

         case '?':
            printf("Terribly sorry but I have no idea what -%c means\n", optopt);
            printf("Why not try one of these? -f -o -p -r -s -t -c\n");
            break;

   	}
     } 

   opencoms();
   inithardware();
   if (frequencypoint == NULL)
   {
      printf("Frequency not specified. Please specify the frequency with -f xxxx\n");
      exit(1);
   }

   selectfreq(freqnumber);
   if (pagenumber == NULL)
   {
      printf("Page number not specified. Please specify the page number with -p xxx\n");
      exit(1);
   }



   requestpage(channel, pagesubpage);
   clearreceiveflag(channel);

   tempcount = 0;   
   do
   {
      sleep(1);
      gotpage = pagereceived(channel);
      tempcount = tempcount + 1;
   }
   while (gotpage == FALSE && tempcount < 256);


   holdcircuit(channel);

   if (gotpage != FALSE)
   {
      readpage(channel, currentpage);

      if (outputfilename[0] == 0x00)
      {
      	if (rawtoggle == FALSE)
        {
        	filter(currentpage);
                printascii(currentpage);
        }
        else
        {
        	printf("%s", currentpage);
        }
      }
      else
      {
         if (rawtoggle == FALSE)
         {
            filter(currentpage);
            writeascii(currentpage, outputfilename);
         }
         else
         {
         	filedesc = open(outputfilename, O_WRONLY | O_CREAT, 0655);
                write(filedesc, currentpage, buffersize);
                close(filedesc);
         }
      }
      gotpage = FALSE; 
   }
   else
   {
      printf("I think there has been a problem reading page %s at frequency %s. Tempcount = %x\n", pagenumber, frequencypoint, tempcount);
      exitstatus = 1;
   }
     
   closecoms();
   return(exitstatus);
}
/*****************************************************************************/
/*****************The End of Main!!!!!!!!!!!!!!!!*****************************/
/*****************************************************************************/
