/*File containing definitions for userdev driver*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# ifndef __USERDEV_H__
# define __USERDEV_H__

# define MODULE
# define __KERNEL__
# include <linux/module.h>
# include <linux/fs.h>
# include <linux/proc_fs.h>
# include <linux/sched.h>
# include <linux/mm.h>
# include <linux/poll.h>
# include <linux/devfs_fs_kernel.h>
# include <linux/spinlock.h>
# include <linux/hdreg.h>
# include <asm/uaccess.h>
# include <asm/dma.h>
# include "ioctls.h"
# include "errors.h"
# include "helpers.h"
# include "common.h"

# define USERDEV_CHR_NAME	"userdev_chr"	/*character driver name*/
# define USERDEV_BLK_NAME 	"userdev_blk"	/*block driver name*/
# define MAX_USERDEV_PROCESSES 	10		/*maximum number of user level device driver processes supported*/
# define MAX_USERDEV_MINORS 	256		/*maximum number of drivers*/

/*bit masks to check if a function is supported by user level driver process*/
# define IS_READ_SUPPORTED(mask) 		(mask & 0x8000)
# define IS_WRITE_SUPPORTED(mask) 		(mask & 0x4000)
# define IS_POLL_SUPPORTED(mask) 		(mask & 0x2000)
# define IS_IOCTL_SUPPORTED(mask) 		(mask & 0x1000)
//# define IS_MMAP_SUPPORTED(mask) 		(mask & 0x0800)
# define IS_OPEN_SUPPORTED(mask) 		(mask & 0x0400)
# define IS_FLUSH_SUPPORTED(mask) 		(mask & 0x0200)
# define IS_CLOSE_SUPPORTED(mask) 		(mask & 0x0100)
# define IS_FSYNC_SUPPORTED(mask) 		(mask & 0x0080)
# define IS_FASYNC_SUPPORTED(mask) 		(mask & 0x0040)
# define IS_READV_SUPPORTED(mask) 		(mask & 0x0020)
# define IS_WRITEV_SUPPORTED(mask) 		(mask & 0x0010)
# define IS_REQUEST_SUPPORTED(mask) 		(mask & 0x0008)
# define IS_CHECK_MEDIA_CHANGE_SUPPORTED(mask) 	(mask & 0x0004)
# define IS_REVALIDATE_SUPPORTED(mask) 		(mask & 0x0002)
# define IS_MEDIACTL_SUPPORTED(mask) 		(mask & 0x0001)

/*reason for waking up a process connection*/
# define NO_REASON 		0	/*woken up for no reason*/
# define RECEIVED_DATA		1	/*woken up as data received*/
# define END_CONNECTION		2	/*woken up as connection terminated*/
# define APPOINTED_READER	3	/*woken up to listen actively for packets*/

/*type of device*/
# define USERDEV_CHR	0
# define USERDEV_BLK	1

/*constants for block device arrays*/
# define USERDEV_BLKDEV_SIZE	2048	/*kilobytes*/
# define USERDEV_BLKSIZE_SIZE	1024	/*bytes*/
# define USERDEV_HARDSECT_SIZE	512	/*bytes*/
# define USERDEV_READ_AHEAD	8	/*sectors*/
# define USERDEV_MAX_READ_AHEAD	MAX_READAHEAD	/*31 pages, value in blkdev.h*/
# define USERDEV_MAX_SECTORS	MAX_SECTORS	/*255 sectors, value in blkdev.h*/

/*userdev file operations*/
/*we have separate open, close and ioctl functions for block and character devices as*/
/*there is no way of diffrentiating the two with the same major number*/
ssize_t userdev_read (struct file *, char *, size_t, loff_t *);
ssize_t userdev_write (struct file *, const char *, size_t, loff_t *);
unsigned int userdev_poll (struct file *, struct poll_table_struct *);
int userdev_ioctl_chr (struct inode *, struct file *, unsigned int, unsigned long);
int userdev_ioctl_blk (struct inode *, struct file *, unsigned int, unsigned long);
int userdev_open_chr(struct inode *, struct file *);
int userdev_open_blk(struct inode *, struct file *);
int userdev_flush (struct file *);
int userdev_close_chr(struct inode *, struct file *);
int userdev_close_blk(struct inode *, struct file *);
int userdev_fsync (struct file *, struct dentry *,int);
int userdev_fasync (int, struct file *, int);
ssize_t userdev_readv (struct file *, const struct iovec *, unsigned long, loff_t *);
ssize_t userdev_writev (struct file *, const struct iovec *, unsigned long, loff_t *);
int userdev_check_media_change (kdev_t);
int userdev_revalidate (kdev_t);
int userdev_mediactl (kdev_t, int, int);

/*structure for specifying ioctl number and the maximum data length
  handled(either of get/set cases)*/
struct ioctl_element {
	int num;		/*ioctl number*/
	int max_length;		/*max data size*/
}; 

/*structure used to keep record of a sleeping connection with a process*/
struct wait_entry {
	int reason;			/*reason why woken up*/
	int req_id;			/*id of packet received*/
	char *data;			/*data of packet received*/
	int size;			/*size of data*/
	wait_queue_head_t bed;		/*wait queue used for sleeping*/
	struct wait_entry* next;	/*pointer to next wait entry*/
};

/*structure to keep track of informantion about attached user level process*/
struct device_record {
	char *devicename;			/*device name*/
	int namelen;				/*length of name*/
	int type;				/*type of device (Character or Block)*/
	int minor;				/*minor number of device*/
	int pid;				/*process id of user process*/
	int num_ioctls;				/*number of ioctls supported*/
	struct ioctl_element *ioctls;		/*array of ioctl elements giving data for ioctls supported*/
	short func_mask;			/*bit mask for functions supported by user level driver*/

	struct file* readfp;			/*pointer to read pipe file structure*/
	struct dentry *read_dentry;		/*pointer to read descriptor's dentry*/
	struct file_operations *readops;	/*pointer to read descriptor's file operations*/

	struct file* writefp;			/*pointer to write pipe file structure*/
	struct dentry *write_dentry;		/*pointer to write descriptor's dentry*/
	struct file_operations *writeops;	/*pointer to write descriptor's file operations*/

	struct proc_dir_entry *proc_entry;	/*proc file system entry root*/

	struct wait_entry *pending_requests;	/*list of pending request to be serviced*/
	rwlock_t req_list_lock;			/*read-write lock for pending requests list*/

	wait_queue_head_t poll_inq;		/*wait queue for input polling*/
	spinlock_t poll_in_lock;		/*spin lock for input poll queue*/

	wait_queue_head_t poll_outq;		/*wait queue for output polling*/
	spinlock_t poll_out_lock;		/*spin lock for output poll queue*/

	struct fasync_struct *fasync_queue; 	/*wait queue for asynchronous notification*/
	spinlock_t fasync_lock;			/*spin lock for fasync queue*/

	atomic_t read_flag;			/*flag to check if active reader present or not(listener for packets on pipe)*/
	atomic_t refcount;			/*reference count*/
	atomic_t detach_called;			/*flag as to whethe detach was called*/
	atomic_t irq_no;			/*irq number for interrupts*/
	atomic_t sig_no;			/*signal number of signal to be delivered on interrupt*/
	atomic_t dma_no;			/*dma channel number*/
	char *dma_buffer;			/*dma buffer*/
	int dma_len;				/*length of dma buffer*/
	spinlock_t bh_list_lock;		/*spin lock for the buffer head list of a block device request*/
};

/*internal functions*/
static int attach_device(struct attach_record *, int, int);
static int detach_device(struct detach_record *);
static int send(char *, int, struct device_record*);
static int receive(struct header *, char **, struct device_record*, int);
static void userdev_wake_up_all(struct device_record*);
static struct proc_dir_entry *new_proc_entry(const char *, mode_t, struct proc_dir_entry *,
		int (*)(char *, char **, off_t, int, int *, void *), void*);
static void del_proc_entry(char *, struct proc_dir_entry *);
static int userdev_proc_init();
static void userdev_proc_cleanup();
static int device_read_proc(char *, char **, off_t, int, int *, void *);

# endif     /*__USERDEV_H__*/

