/*file containing some helper functions used by userdev*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# define __KERNEL__
# include <linux/stat.h>
# include <linux/fs.h>
# include <linux/sched.h>
# include "helpers.h"

/*function to get the file status information given the filename*/
int get_status(char *fname, struct stat *buf)	 /*!!!! KERNEL DEPENDANT !!!! */
{
	struct dentry *dentry;
	struct inode *inode;
	struct nameidata nd;
        int error;

	if(buf == NULL) return -1;

	error = 0;
	if(path_init(fname, LOOKUP_FOLLOW|LOOKUP_POSITIVE, &nd))
		error = path_walk(fname, &nd);
        if (!error)
	{
		inode = nd.dentry->d_inode;	/*revalidate inode*/
        	if (inode->i_op && inode->i_op->revalidate)
                	error = inode->i_op->revalidate(dentry);
		else 
			error = 0;
                if (!error)			/*fill stat buffer with info from inode*/
		{
    			buf->st_dev = kdev_t_to_nr(inode->i_dev);
    			buf->st_ino = inode->i_ino;
    			buf->st_mode = inode->i_mode;
    			buf->st_nlink = inode->i_nlink;
    			buf->st_uid = inode->i_uid;
    			buf->st_gid = inode->i_gid;
    			buf->st_rdev = kdev_t_to_nr(inode->i_rdev);
    			buf->st_size = inode->i_size;
    			buf->st_atime = inode->i_atime;
    			buf->st_mtime = inode->i_mtime;
    			buf->st_ctime = inode->i_ctime;
    		}
        }
        return error;
}

/*function to get minor number of a given filename*/
int get_minor(char *fname)
{
	struct stat status;
	int ret;
	
	ret = get_status(fname,&status);
	if (ret != 0) return -1;
	return status.st_rdev;
}

/*function to check if the given filename has write permissions for current
  process*/
int check_perm_w(char *fname)
{
	struct stat status;
	int ret;
	uid_t uid;
	gid_t gid;
		
	ret = get_status(fname,&status);
	if (ret != 0) return 0;
	uid = current->uid;
	gid = current->gid;

	if ((uid == status.st_uid) && (gid == status.st_gid) && (S_IWUSR & status.st_mode))	
		return 1;				/*user has permissions*/
	if ((gid == status.st_gid) && (S_IWGRP & status.st_mode))
		return 1;				/*user group has permissions*/
	if (S_IWOTH & status.st_mode) return 1;		/*permitted for others*/
	return 0;
}

/*function to check if the file has execute permissions for current process*/
int check_perm_x(char *fname)
{
	struct stat status;
	int ret;
	uid_t uid;
	gid_t gid;
	
	ret = get_status(fname,&status);
	if (ret != 0) return 0;
	uid = current->uid;
	gid = current->gid;

	if ((uid == status.st_uid) && (gid == status.st_gid) && (S_IXUSR & status.st_mode))	
		return 1;
	if ((gid == status.st_gid) && (S_IXGRP & status.st_mode))
		return 1;
	if (S_IXOTH & status.st_mode) return 1;
	return 0;
}

/*function to retreive file structure from file descriptor by searching the
  current process file table*/
struct file *fdtofp(int fd)		 /*!!!! KERNEL DEPENDANT !!!! */
{
	struct file *file;
				
	if (fd>=NR_OPEN) return NULL;
	file = current->files->fd[fd];
	return file;
}

/*function to generate a identification number for each packet sent by
 * userdev*/
int genID()
{
	 static int id=0;
	 return id++;
}    

