/*
//file containing values of error codes used by userdev
//the values have been mapped to standard numbers to allow reporting error
//messages
*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# ifndef __USERDEV_ERRORS_H__
# define __USERDEV_ERRORS_H__

# define ERR_INVALID_DEVICE		-19	/*ENODEV	//invalid device being referred to*/
# define ERR_ACCESS_DENIED 	        -1	/*EPERM		//access to device has been denied*/
# define ERR_MINOR_NOT_FREE 	        -98	/*EADDRINUSE	//the minor number requested is not free*/
# define ERR_INVALID_ID                 -22	/*EINVAL	//invalid userdev id*/
# define ERR_WRONG_PID                  -3	/*ESRCH		//wrong process id*/
# define ERR_TOO_MANY_PROCESSES         -31	/*EMLINK	//max number of allowed process reached*/
# define ERR_INVALID_FILE_DESCRIPTOR    -2	/*ENOENT	//the given file descriptor is invalid*/
# define ERR_DEVICE_NOT_ATTACHED	-6	/*ENXIO		//the device being referred to is not attached*/
# define ERR_PROCESS_DETACHED		-32	/*EPIPE		//the driver process being referred to has detached*/
# define ERR_COMM_FAILURE		-5	/*EIO		//failure in communication with driver process*/
# define ERR_MEMORY_FAULT		-14	/*EFAULT	//error occured while allocating memory or moving data to/from user*/
# define ERR_UNKNOWN_IOCTL_COMMAND	-56	/*EBADRQC	//unknown ioctl command given*/
# define ERR_FUNC_NOT_SUPPORTED		-38	/*ENOSYS	//the gven function is not supportted by the device*/
# define ERR_INVALID_HEADER		-84	/*EILSEQ	//invalid packet header obtained*/
# define ERR_INVALID_RECORD		-84	/*EILSEQ	//invalid attach record has been provided*/
# define ERR_SIGNAL_RECEIVED		-4	/*EINTR		//interrupted system call*/
# define ERR_INVALID_DMA		-9	/*EBADF		//dma channel has not been requested for*/

# endif 	/* __USERDEV_ERRORS_H__ */
