/*
//file contains data structures and function declarations for the user level
//driver library
*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# ifndef __USERDEV_USRDRV_H__
# define __USERDEV_USRDRV_H_

# include <fcntl.h>
# include <signal.h>
# include "blk_req.h"
# include "siglist.h"
# include "taskq.h"
# include "timerq.h"
# include "usrdelay.h"
# include "usrioreg.h"
# include "usrport.h"

/*re-definition of operation codes for use by driver code*/
# define READ_OP               	0
# define WRITE_OP              	1
# define POLL_OP               	2
# define IOCTL_OP              	3
# define OPEN_OP               	4
# define FLUSH_OP              	5
# define CLOSE_OP              	6
# define FSYNC_OP              	7
# define FASYNC_OP             	8
# define CHECK_MEDIA_CHANGE_OP 	9
# define REVALIDATE_OP         	10
# define MEDIACTL_OP		11
# define REQUEST_OP		13

/*userdev device types*/
# define USERDEV_CHAR	0
# define USERDEV_BLOCK	1

/*userdev device filenames*/
# define USERDEV_CHARDEV	"/dev/userdev_chr"
# define USERDEV_BLOCKDEV	"/dev/userdev_blk"

/*dma mode of operation - taken from <asm/dma.h>*/
# define DMA_READ	0x44
# define DMA_WRITE	0x48

/*block device request operations*/
# define READ_REQ	0
# define WRITE_REQ	1

/*
//userdev file operations structure
//This data structure contains pointers to functions to be implemented by a
//driver process. A pointer can be NULL incase no implementation exists
*/
struct userdev_operations
{
	int devtype;
	void (*read)(int id, unsigned int size, long long off, int flags, int reqid);
	void (*write)(int id, char *data, int len, long long off, int flags, int reqid);
	void (*poll)(int id, int reqid);
	void (*ioctl)(int id, int command, void* data, int size, int reqid);
	void (*open)(int id, unsigned int flags, mode_t mode, int reqid);
	void (*flush)(int id, int reqid);
	void (*close)(int id, int reqid);
	void (*fsync)(int id, int datasync, int reqid);
	void (*fasync)(int id, int reqid);
	void (*check_media_change)(int id, int reqid);
	void (*revalidate)(int id, int reqid);
	void (*mediactl)(int id, int op, int optarg, int reqid);
	void (*message)(int id, int type, int reqid, void *data, int size);
	void (*request)(int id, int command, long sector, int length, int clustersize, void* data, int datasize, int reqid);
};

/*
//structure for representing ioctl information passed while attaching the
//process to userdev
*/
struct userdev_ioctl_data
{
	int ioctl_num;		/*ioctl command */
	int max_length;		/*maximum size of data handled*/
};

/*structure for representing block device information passed while attaching the driver process*/
struct userdev_blk_data
{
	int devsize;		/*device size, in kilobytes*/
	int blksize;		/*block size, in bytes*/
	int sectsize;		/*sector size, in bytes*/
	int maxreadahead;	/*maximum read ahead for buffer cache, in memory pages*/
	int maxsectors;		/*maximum number of sectors in any request*/
};

/*functions available in the user level driver library*/
int userdev_attach_to_userdev(char *, struct userdev_ioctl_data *, int, struct userdev_operations*, void*);
int userdev_detach_from_userdev(int);
int userdev_inform_poll_in(int);
int userdev_inform_poll_out(int);
int userdev_inform_fasync_io(int);
int userdev_free_irq(int);
int userdev_request_irq(int, int, void (*)(int, siginfo_t *, void *), int);
int userdev_request_dma(int, int);
int userdev_free_dma(int);
int userdev_start_dma(int, int, char*, int);
int userdev_check_dma(int);
int userdev_copy_dma(char*, int);
int userdev_enable_dma(int);
int userdev_disable_dma(int);
int userdev_start();
void userdev_send_response(int id, int reqid, int opcode, int retval, int size, void *data);

/*message type codes*/
# define SIGNAL_PENDING		1

# endif	/*__USERDEV_USRDRV_H__*/
