/*file contains data structures and function declarations for task queue implementation*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# ifndef __USERDEV_TASKQ_H__
# define __USERDEV_TASKQ_H__

struct userdev_task {			/*data structure for each task*/
	struct userdev_task* next;	/*pointer to next task*/
	void (*routine)(void*);	/*task function*/
	void *data;		/*parameter for the task function*/
	int sync;		/*sync bit, set to 1 when task is on a task queue*/
};

struct userdev_task_queue {		/*task queue data structure*/
	struct userdev_task* first;	/*pointer to first task in task list*/
	pthread_mutex_t mutex;	/*mutex for access to task queue*/
	pthread_t thread;	/*thread on which task queue is run*/
	int stop;		/*flag set to stop taskq*/
	int run;		/*flag that denotes if the task queue is to run or not, set to 1 when first task arrives, to 0 when empty*/
	pthread_cond_t run_cond;/*condition variable to wait for run to be set*/
};

/*macro for declaring and initialising a task queue*/
# define DECLARE_TASK_QUEUE(name) struct userdev_task_queue name = { 	\
	first:NULL, 						\
	mutex:PTHREAD_MUTEX_INITIALIZER, 			\
	stop:0, 						\
	run:0, 						\
	run_cond:PTHREAD_COND_INITIALIZER, 			\
};

void userdev_queue_task(struct userdev_task *tsk, struct userdev_task_queue *task_list);
void userdev_run_task_queue(struct userdev_task_queue *q, void(*fn)());

# endif	/*__USERDEV_TASKQ_H__*/
