/* file contains data and function declarations for parport_pc module*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

#ifndef __USERDEV_PARPORT_PC_H__
#define __USERDEV_PARPORT_PC_H__

/* --- register definitions ------------------------------- */
#define ECONTROL 0x402
#define CONFIGB  0x401
#define CONFIGA  0x400
#define EPPDATA  0x4
#define EPPADDR  0x3
#define CONTROL  0x2
#define STATUS   0x1
#define DATA     0
/*--------------------------------------------------------- */

/* Private data for PC low-level driver. */
struct parport_pc_private {
	/* Contents of CTR. */
	unsigned char ctr;
};
extern volatile unsigned char parport_pc_ctr;

/*functions supported by parport_pc module*/
int parport_pc_epp_clear_timeout(struct parport *pb);
void parport_pc_write_epp(struct parport *p, unsigned char d);
unsigned char parport_pc_read_epp(struct parport *p);
void parport_pc_write_epp_addr(struct parport *p, unsigned char d);
unsigned char parport_pc_read_epp_addr(struct parport *p);
int parport_pc_check_epp_timeout(struct parport *p);
unsigned char parport_pc_read_configb(struct parport *p);
void parport_pc_write_data(struct parport *p, unsigned char d);
unsigned char parport_pc_read_data(struct parport *p);
void parport_pc_write_control(struct parport *p, unsigned char d);
unsigned char parport_pc_read_control(struct parport *p);
unsigned char parport_pc_frob_control(struct parport *p, unsigned char mask,  unsigned char val);
void parport_pc_write_status(struct parport *p, unsigned char d);
unsigned char parport_pc_read_status(struct parport *p);
void parport_pc_write_econtrol(struct parport *p, unsigned char d);
unsigned char parport_pc_read_econtrol(struct parport *p);
unsigned char parport_pc_frob_econtrol(struct parport *p, unsigned char mask,  unsigned char val);
void parport_pc_write_fifo(struct parport *p, unsigned char v);
unsigned char parport_pc_read_fifo(struct parport *p);
void parport_pc_disable_irq(struct parport *p);
void parport_pc_enable_irq(struct parport *p);
void parport_pc_release_resources(struct parport *p);
int parport_pc_claim_resources(struct parport *p);
void parport_pc_init_state(struct parport_state *s);
void parport_pc_save_state(struct parport *p, struct parport_state *s);
void parport_pc_restore_state(struct parport *p, struct parport_state *s);
size_t parport_pc_epp_read_block(struct parport *p, void *buf, size_t length);
size_t parport_pc_epp_write_block(struct parport *p, void *buf, size_t length);
int parport_pc_ecp_read_block(struct parport *p, void *buf, size_t length, void (*fn)(struct parport *, void *, size_t), void *handle);
int parport_pc_ecp_write_block(struct parport *p, void *buf, size_t length, void (*fn)(struct parport *, void *, size_t), void *handle);
int parport_pc_set_ioperms(int);
void parport_pc_reset_ioperms(int);

#endif 	/* __USERDEV_PARPORT_PC_H__ */
