.\"
.\" This document was generated by LoTeX 0.9
.\" (roff/mm macro package Version 0.1)
.\" from file net.tex
.\" 
.\" format with
.\"	groff -t -mgm nag.mm > nag.ascii
.\"
.\" Initial settings:
.nr Ej 1
.nr Cl 2
.nr Ls 6
.nr Fs 0
.nr Ps 2
.nr Hb 4
.nr Hs 3
.nr Ds 0
.FD 4 1
.\" Make the page wider.
.po 6m
.ll 72m
.\" Initialize cross-referencing. This requires GNU's mgm macros
.INITR net\"
.\"
.\"------------------------------------------------------------
.\" Macro support for LoTeX/mgm.
.\" Copyright (C) O.Kirch, 1993, 1994
.\"
.\" These try to simulate the \marginpar command.
.\" Warning: If a page break occurs while printing
.\" the marginpar, bad things will befall you.
.de MARGINPAR
.ev mp-ev
.mk
..
.de ENDMARGINPAR
.br
.ll
.po
.br
.rt
.ev
..
.\"------------------------------------------------------------
.\" Define verbatim commands.
.de VERBATIM
.nr Verbin \\n[.i]u
.VERBON 17
..
.de ENDVERBATIM
.VERBOFF
..
.\" Our private counter for bibliographic references
.nr Bi 0
.\"------------------------------------------------------------
.\" BEWARE: STILL BROKEN!!!!!
.\" Treatment of minipages. This is still very limited:
.\" We allow one minipage ``on the line'', that is
.\"
.\" bla bla bla bla bla bla bla bla bla bla bla
.\" bla bla bla mini  mini bla bla bla  bla bla 
.\"             mini  mini
.\"             mini  mini
.\" bla bla bla bla bla bla bla bla bla bla bla 
.\"
.\" We also check if the whole page would fit on one
.\" page, otherwise we put it on a separate page.
.\" The problem is, we leave this to groff, so we
.\" don't notice it. This may give strange results
.\" for minipages on the line.
.\" Beware: a page break within a minipage makes the
.\" Page heading shift to the right.
.\"
.nr mini*fl 0
.de MINIPAGE
.mk mini*top
.nr mini*pos \\n[.k]
.nr mini*off \\n[.o]
.br
.rt \\n[mini*top]u
.if \\n[mini*fl] .@error "No nested MINIPAGES allowed"
.nr mini*fl 1
.ie \\n[.$]=0 .@error MINIPAGE needs width argument
.el .nr mini*wd \\$1
.nr mini*break \\n[.k]+\\n[mini*wd]>\\n[.l] 
.if \\n[mini*break] .br
.ev mini*ev
.di mini*div
.ti 0
.ll \\n[mini*wd]u
..
.de ENDMINIPAGE
.br
.di
.br
.ne \\n[dn]u	\" make sure we have enough room
.po \\n[mini*pos]u
.mini*div
.br
.po \\n[mini*off]u
.ll
.nr mini*fl 0
.mk mini*bot
.ie \\n[mini*break] \{\
.	br
.\}
.el \{\
.	rt \\n[mini*top]u
.	ti |\\n[mini*pos]u+\\n[mini*wd]u+1m
.	wh \\n[mini*top]u+1v mini@trap
.\}
..
.\" For a minibox ``on the line'', this trap is invoked
.\" when the current line ends; this is necessary so that
.\" the following text is printed _below_ the minipage,
.\" not across it:-)
.de mini@trap
'	sp |\\n[mini*bot]u
..
.\" ------------------------------------------------------------
.\" End of LoTeX/mm support macros.
.\"
.\" makeindex support macros for mm; loosely based on the
.\" ms examples in the makeindex package, and the reference
.\" handling in GNU mm.
.de INITIDX
.if \\n[.$]<1 .@error "INITIDX:filename missing"
.ds idx*file \\$1.idxl
.open idx*stream \\*[idx*file]
.write idx*stream .\\\\" index information for \\*[idx*file]
.close idx*stream
..
.de INDEX
.ie '\\n[.z]'' \{\
.	opena idx*stream \\*[idx*file]
.	write idx*stream IX: \\$1 \\$2 \\$3 \\$4\\$5 \\$6 \\$7 \\$8 \\$9\t{\\n[%]}
.	close idx*stream
\}
.el \! .INDEX \\$1 \\$2 \\$3 \\$4\\$5 \\$6 \\$7 \\$8 \\$9
..
.de PRINTINDEX
.if \\n[.$]<1 .@error "PRINTINDEX:filename missing"
.ds idx*index \\$1.xmm
.sy test -r \\*[idx*index]
.if !\\n[systat] .so \\*[idx*index]
..
.INITIDX net\"
.P 1
.nr Cl 2
.P 1
.sp 5c
.br
.ti 0	\" get rid of any indentation
\fBThe Linux Network Administrators' Guide\fR
.br
\l'\n(.lu\&-'
.br
Copyright\ \(co\ 1992-1994 Olaf\ Kirch\p
.ad b
.bp
.P 1
.SK 1
.sp 0.45
\h''
\"
.br
\fIFor Britta
.br
\fR
.P 1
.SK 1
\"
.br
\fBLegal Notice\fR
.P 1
.SP 2
.br
.ti 0
UNIX is a trademark of Univel\&.
.br
Linux is not a trademark, and has no connection to
UNIX(tm) or Univel\&.
.br
.sp 
.P 1
.br
.ti 0
Copyright (C) 1994  Olaf Kirch
.br
Kattreinstr\&. 38, 64295 Darmstadt, Germany
.br
\fBokir@monad\&.swb\&.de\fR
.P 1
.sp .2i
.br
.ti 0
``The Linux Network Administrators' Guide'' may be reproduced and distributed in whole or in part, subject
to the following conditions:
.P 1
\"
.AL 10
.LI
The copyright notice above and this permission notice must be
preserved complete on all complete or partial copies\&.
.P 1
.LI
Any translation or derivative work of ``The Linux Network Administrators' Guide'' must be approved
by the author in writing before distribution\&.
.P 1
.LI
If you distribute ``The Linux Network Administrators' Guide'' in part, instructions for obtaining
the complete version of ``The Linux Network Administrators' Guide'' must be included, and a means for
obtaining a complete version provided\&.
.P 1
.LI
Small portions may be reproduced as illustrations for reviews
or \fBquotes\fR in other works without this permission notice if
proper citation is given\&.
.P 1
.LI
If you print and distribute ``The Linux Network Administrators' Guide'', you may not refer to it
as the ``Official Printed Version''\&.
.P 1
.LI
The GNU General Public License referenced below may be
reproduced under the conditions given within it\&.
.P 1
.LI
Several sections of this document are held under separate
copyright\&.  When these sections are covered by a different copyright,
the seperate copyright is noted\&.  \fBIf you distribute ``The Linux Network Administrators' Guide'' in
part, and that part is, in whole, covered under a seperate, noted
copyright, the conditions of that copyright apply\&.\fR
\"
.LE
.P 1
Exceptions to these rules may be granted for academic purposes: Write to
Olaf Kirch at the above address, or email \fBokir@monad\&.swb\&.de\fR, and
ask\&.  These restrictions are here to protect us as authors, not to
restrict you as educators and learners\&.
.P 1
.sp .2i
.br
.ti 0
All source code in ``The Linux Network Administrators' Guide'' is placed under the
GNU General Public License\&.  See appendix 
.GETHN "appendix.gpl"
\& for a copy
of the GNU ``GPL\&.''
.P 1
The author is not liable for any damages, direct or indirect,
resulting from the use of information provided in this
document\&.
.br
.P 1
.nr Hu 1
.HU "Preface"
.P 1
.sp 4c
.P 1
.SETR "foreword.intro"
With the Internet much of a buzzword recently, and otherwise
serious people joyriding along the ``Informational Superhighway,''
computer networking seems to be moving toward the status of TV sets
and microwave ovens\&. The Internet is recently getting an unusually
high media coverage, and social science majors are descending on
Usenet newsgroups to conduct researches on the ``Internet Culture\&.''
Carrier companies are working to introduce new transmission techniques
like ATM that offer many times the bandwidth the average network link
of today has\&.
.P 1
Of course, networking has been around for a long time\&.
Connecting computers to form local area networks has been common
practice even at small installations, and so have been long-haul links
using public telephone lines\&. A rapidly growing conglomerate of
world-wide networks has, however, made joining the global village a
viable option even for small non-profit organizations of private
computer users\&. Setting up an Internet host with mail and news
capabilities offering dial-up access has become affordable, and the
advent of ISDN will doubtlessly accelerate this trend\&.
.P 1
Talking of computer networks quite frequently means talking about
UNIX\&. Of course, UNIX is neither the only operating system with
network capabilities, nor will it remain a front-runner forever,
but it has been in the networking business for a long time, and
will surely continue to do so for some time to come\&.
.P 1
What makes it particularly interesting to private users is that there
has been much activity to bring free UNIXoid operating systems to the
PC, being 386BSD, FreeBSD --- and Linux\&.  However, Linux is
\fInot\fR UNIX\&. That is a registered trademark of whoever currently
holds the rights to it (Univel, while I'm typing this), while Linux
is an operating system that strives to offer all functionality the POSIX
standards require for UNIX-like operating systems, but is a complete
reimplementation\&.
.P 1
The Linux kernel was written largely by Linus Torvalds, who started
it as a project to get to know the Intel i386, and to ``make MINIX
better\&.'' MINIX was then another popular PC operating system offering
vital ingredients of Un*x functionality, and was written by Prof\&.
Andrew S\&. Tanenbaum\&.
.P 1
Linux is covered by the GNU General Public License (GPL), which
allows free distribution of the code (please read the GPL in
appendix 
.GETHN "appendix.gpl"
\& for a definition of what ``free software''
means)\&.  Outgrowing its child's diseases, and drawing from a large and
ever-growing base of free application programs, it is quickly becoming
the oprating system of choice for many PC owners\&.  The kernel and C
library have become that good that most standard software may be
compiled with no more effort than is required on any other mainstream
Un*xish system, and a broad assortment of packaged Linux
distributions allows you to almost drop it onto your hard disk and start
playing\&.
.P 1
.nr Hu 2
.HU "Documentation on Linux"
.INDEX {Linux Documentation Project@Linux Documentation Project}
.INDEX {LDP|see Linux Documentation Project}
.INDEX {Wirzenius, Lars}
.INDEX {Johnson, Michael K\&.}
.INDEX {Welsh, Matt}
.INDEX {Faith, Rik}
.P 1
One of the complaints that are frequently levelled at Linux (and
free software in general) is the sorry state or complete lack of
documentation\&. In the early days it was not unusual for a package to
come with a handful of \fIREADME\fRs and installation notes\&. They gave
the moderately experienced Un*x wizard enough information to
successfully install and run it, but left the average newbie
out in the cold\&.
.P 1
Back in late 1992, Lars Wirzenius and Michael K\&. Johnson suggested to
form the Linux Documentation Project, or LDP, which aims at providing
a coherent set of manuals\&.  Stopping short of answering questions like
``How?'', or ``Why?'', or ``What's the meaning of life, universe, and
all the rest?'', these manuals attempt to cover most aspects of running
and using a Linux system users without requiring a prior degree in
Un*x\&.
.P 1
Among the achievements of the LDP are the \fIInstallation and Getting
Started Guide\fR, written by Matt Welsh, the \fIKernel Hacker's Guide\fR
by Michael K\&. Johnson, and the manpage project coordinated by Rik Faith,
which so far supplied a set of roughly 450 manual pages for most system
and C library calls\&.  The \fISystem Administrators' Guide\fR, written
by Lars Wirzenius, is still at the Alpha stage\&.  A User's Guide is being
prepared\&.
.P 1
This book, the \fILinux Network Administrators' Guide\fR, is part of
the LDP series, too\&. As such, it may be copied and distributed freely
under the LDP copying license which is reproduced on the second page\&.
.P 1
.INDEX {HOWTO}
However, the LDP books are not the only source of information on
Linux\&. At the moment, there are more than a dozen HOWTOs that are
posted to \fBcomp\&.os\&.linux\&.announce\fR regularly and archived at
various FTP sites\&. HOWTOs are short documents of a few pages that give
you a brief introduction into topics such as Ethernet support under
Linux, or the configuration of Usenet news software, and answer
frequently asked questions\&. They usually provide the most accurate and
up-to-date information avaliable on the topic\&. A list of available
HOWTOs is produced in the ``Annotated Bibliography'' toward the end of
this book\&.
.P 1
.nr Hu 2
.HU "About This Book"
When I joined the Linux Documentation Project in 1992, I wrote two
small chapters on UUCP and \fIsmail\fR, which I meant to contribute to
the System Administrator's Guide\&. Development of TCP/IP networking was
just beginning, and when those ``small chapters'' started to grow, I
wondered aloud if it wouldn't be nice to have a Networking Guide\&.
``Great'', everyone said, ``I'd say, go for it!'' So I went for it,
and wrote a first version of the Networking Guide, which I released in
September 1993\&.
.P 1
The new Networking Guide you are reading right now is a complete
rewrite that features several new applications that have become
available to Linux users since the first release\&.
.P 1
The book is organized roughly in the sequence of steps you have to
take to configure your system for networking\&. It starts by discussing
basic concepts of networks, and TCP/IP-based networks in particular\&.
We then slowly work our way up from configuring TCP/IP at the device
level to the setup of common applications such as \fIrlogin\fR and
friends, the Network File System, and the Network Information System\&.
This is followed by a chapter on how to set up your machine as a UUCP
node\&. The remainder of the book is dedicated to two major applications
that run on top of both TCP/IP and UUCP: electronic mail and news\&.
.P 1
The email part features an introduction of the more intimate parts of
mail transport and routing, and the myriads of addressing schemes you
may be confronted with\&. It describes the configuration and management
of \fIsmail\fR, a mail transport agent commonly used on smaller mail
hubs, and \fIsendmail\fR, which is for people who have to do more
complicated routing, or have to handle a large volume of mail\&. The
\fIsendmail\fR chapter has been written and contributed by Vince
Skahan\&.
.P 1
The news part attempts to give you an overview of how Usenet news
works, covers C news, the most widely used news transport software at
the moment, and the use of NNTP to provide newsreading access to a
local network\&. The book closes with a short chapter on the care and
feeding of the most popular newsreaders on Linux\&.
.P 1
.nr Hu 2
.HU "The Official Printed Version"
In autumn 1993, Andy Oram, who has been around the LDP mailing list
from almost the very beginning, asked me about publishing my
book at O'Reilly and Associates\&.  I was excited about this; I
had never imagined my book being that successful\&. We finally
agreed that O'Reilly would produce an enhanced Official Printed
Version of the Networking Guide with me, while I retained the
original copyright so that the source of the book could be freely
distributed\&.(\*F)
.FS
The copyright notice is reproduced on the page immediately following
the title page\&.
.FE
This means that you can choose freely: you can get the
LaTeXsource distributed on the network (or the preformatted DVI or
PostScript versions, for that matter), and print it out\&. Or you can
purchase the official printed version from O'Reilly, which will be
available some time later this year\&.
.P 1
Then, why would you want to pay money for something you can get for
free? Is Tim O'Reilly out of his mind for publishing something
everyone can print and even sell herself?(\*F)
.FS
Note that while you are allowed to print out the online version, you
may \fInot\fR run the O'Reilly book through a photocopier, and much
less sell any of those (hypothetical) copies\&.
.FE
Or is there any difference between these versions?
.P 1
The answers are ``it depends,'' ``no, definitely not,'' and ``yes and
no\&.'' O'Reilly and Associates do take a risk in publishing the
Networking Guide, but I hope it will finally pay off for them\&. If it
does, I believe this project can serve as an example how the free
software world and companies can cooperate to produce something both
benefit from\&. In my view, the great service O'Reilly is doing to the
Linux community (apart from the book being readily available in your
local bookstore) is that it may help Linux being recognized as
something to be taken seriously: a viable and useful alternative to
commercial PC UNIX operating systems\&.
.P 1
So what about the differences between the printed version and the
online one?  Andy Oram has made great efforts at transforming my
early ramblings into something actually worth printing\&.  (He has
also been reviewing the other books put out by the Linux
Documentation Project, trying to contribute whatever professional
skills he can to the Linux community\&.)
.P 1
Since Andy started reviewing the Networking Guide and editing the
copies I sent him, the book has improved vastly over what it was
half a year ago\&. It would be nowhere close to where it is now
without his contributions\&.
All his edits have been fed back into online version, as will any
changes that will be made to the Networking Guide during the
copy-editing phase at O'Reilly\&.  So there will be no difference in
content\&.  Still, the O'Reilly version \fIwill\fR be different: On one
hand, people at O'Reilly are putting a lot of work into the look and
feel, producing a much more pleasant layout than you could ever get
out of standard LaTeX\&. On the other hand, it will feature a couple of
enhancements like an improved index, and better and more figures\&.
.P 1
.nr Hu 2
.HU "More Information"
If you follow the instructions in this book, and something does not
work nevertheless, please be patient\&. Some of your problems may be due
to stupid mistakes on my part, but may also be caused by changes in
the networking software\&.  Therefore, you should probably ask on
\fBcomp\&.os\&.linux\&.help\fR first\&. There's a good chance that you are
not alone with your problems, so that a fix or at least a proposed
workaround is likely to be known\&. If you have the opportunity, you
should also try to get the latest kernel and network release from one
of the Linux FTP sites, or a BBS near you\&.  Many problems are
caused by software from different stages of development, which fail to
work together properly\&. After all, Linux is ``work in progress''\&.
.P 1
.INDEX {HOWTO!Networking}
.INDEX {Dawson, Terry}
Another good place to inform yourself about current development
is the Networking HOWTO\&. It is maintained by Terry Dawson(\*F)
.FS
Terry Dawson can be reached at \fBterryd@extro\&.ucc\&.su\&.oz\&.au\fR\&.
.FE
\&. It is posted to \fBcomp\&.os\&.linux\&.announce\fR once a month, and
contains the most up-to-date information\&.  The current version can
also be obtained (among others) from \fBtsx-11\&.mit\&.edu\fR, in
\fI/pub/linux/doc\fR\&. For problems you can't solve in any other way,
you may also contact the author of this book at the address given in
the preface\&. However, please, refrain from asking developers for help\&.
They are already devoting a major part of their spare time to Linux
anyway, and occasionally even have a life beyond the net\fB:-)\fR
.P 1
.nr Hu 3
.HU "On the Authors"
Olaf has been a UNIX user and part-time administrator for a couple of
years while he was studying mathematics\&.  At the moment, he's working as
a UNIX programmer and is writing a book\&.  One of his favorite sports is
doing things with \fIsed\fR that other people would reach for their
\fIperl\fR interpreter for\&.  He has about as much fun with this as with
mountain hiking with a backpack and a tent\&.
.P 1
Vince Skahan has been administering large numbers of UNIX systems since
1987 and currently runs sendmail+IDA on approximately 300 UNIX
workstations for over 2000 users\&.  He admits to losing considerable
sleep from editing quite a few \fIsendmail\&.cf\fR files `the hard way'
before discovering sendmail+IDA in 1990\&.  He also admits to anxiously
awaiting the delivery of the first
perl-based version of sendmail for even more obscure fun(\*F)
.FS
Don't you think we could do it with \fIsed\fR, Vince?
.FE
\&.\&.\&.
.P 1
Olaf can be reached at the following address:
.P 1
.P 1
.DS I F 5
Olaf Kirch
.br
Kattreinstr\&. 38
.br
64295 Darmstadt
.br
Germany
.br
.br
\fBokir@monad\&.swb\&.de\fR
\"
.DE
.P 1
Vince can be reached at:
.P 1
.P 1
.DS I F 5
Vince Skahan
.br
\fBvince@victrola\&.wa\&.com\fR
\"
.DE
.P 1
We are open to your questions, comments, postcards, etc\&.  However, we
ask you \fInot\fR to telephone us unless it's really important\&.
.P 1
.nr Hu 2
.HU "Thanks"
\fIOlaf says:\fR
This book owes very much to the numerous people who took the time to
proofread it and helped iron out many mistakes, both technical and
grammatical (never knew that there's such a thing as a dangling
participle)\&.  The most vigorous among them was Andy Oram at O'Reilly
and Associates\&. 
.P 1
I am greatly indebted to Andres Sep\['u]lveda, Wolfgang Michaelis,
Michael K\&. Johnson, and all developers who spared the time to check
the information provided in the Networking Guide\&. I also wish to thank
all those who read the first version of the Networking Guide and sent
me corrections and suggestions\&. You can find hopefully complete list
of contributors in the file \fIThanks\fR in the online distribution\&.
Finally, this book would not have been possible without the support of
Holger Grothe, who provided me with the critical Internet
connectivity\&.
.P 1
I would also like to thank the following groups and companies who
printed the first edition of the Networking Guide and have donated
money either to me, or to the Linux Documentation Project as a whole\&.
.P 1
\"
.BL 10
.LI
Linux Support Team, Erlangen, Germany
.LI
S\&.u\&.S\&.E\&. GmbH, Fuerth, Germany
.LI
Linux System Labs, Inc\&., United States
\"
.LE
.P 1
\fIVince says:\fR
Thanks go to Neil Rickert and Paul Pomes for lots of help over the years
regarding the care and feeding of sendmail+IDA and to Rich Braun for
doing the initial port of sendmail+IDA to Linux\&.  The biggest thanks by
far go to my wife Susan for all the support on this and other projects\&.
.P 1
.bp
.P 1
.nr Hu 2
.HU "Typographical Conventions"
In writing this book, a number of typographical conventions were employed
to mark shell commands, variable arguments, etc\&. They are explained below\&.
.P 1
\"
.BL 10
.LI "\fBBold Font\fR"
Used to mark hostnames and mail addresses, as well as new
concepts and warnings\&.
.P 1
.LI "\fIItalics Font\fR"
Used to mark file names, UNIX commands, and keywords in
configuration files\&. Also used for \fIemphasis\fR in text\&.
.P 1
.LI "\fBTypewriter Font\fR"
Used to represent screen interaction, such as user interaction
when running a program\&.
.P 1
Also used for code examples, whether it is a configuration file,
a shell script, or something else\&.
.P 1
.LI "\fB\fITypewriter Slanted Font\fB\fR"
Used to mark meta-variables in the text, especially in
representations of the command line\&.  For example,
.P 1
.P 1
.DS I F 5
\fB$ ls -l \fB\fIfoo\fB\fB
\"
\fR
.DE
.P 1
where \fB\fIfoo\fB\fR would ``stand for'' a filename, such as
\fI/tmp\fR\&.
.P 1
.LI "`Key'"
Represents a key to press\&.  You will often see it in this form:
.P 1
.DS I F 5
Press `return' to continue\&.
\"
.DE
.P 1
.LI "<>"
A diamond in the margin, like a black diamond on a ski hill,
marks ``danger'' or ``caution\&.''  Read paragraphs marked this
way carefully\&.
.P 1
.LI "\fB$\fR and \fB#\fR"
When preceding a shell command to be typed, these denote the
shell prompt\&. The `\fB$\fR' symbol is used when the command
may be executed as a normal user; `\fB#\fR' means that the
command requires super user privilieges\&.
.P 1
\"
.LE
.P 1
.bp
.nr Hu 2
.HU "The Linux Documentation Project"
.SETR "foreword.blurb"
.INDEX {Linux Documentation Project@Linux Documentation Project}
.INDEX {Linux Activists@Linux Activists}
.P 1
The Linux Documentation Project, or LDP, is a loose team of writers,
proofreaders, and editors who are working together to provide complete
documentation for the Linux operating system\&.  The overall coordinator
of the project is Matt Welsh, who is heavily aided by Lars Wirzenius and
Michael K\&. Johnson\&.
.P 1
This manual is one in a set of several being distributed by the LDP,
including a Linux Users' Guide, System Administrators' Guide, Network
Administrators' Guide, and Kernel Hackers' Guide\&. These manuals are
all available in LaTeX source format, \fB\&.dvi\fR format, and postscript
output by anonymous FTP from \fBnic\&.funet\&.fi\fR, in the directory
\fB/pub/OS/Linux/doc/doc-project\fR, and from \fBtsx-11\&.mit\&.edu\fR, in the
directory \fB/pub/linux/docs/guides\fR\&.
.P 1
We encourage anyone with a penchant for writing or editing to join us in
improving Linux documentation\&. If you have Internet e-mail access, you can
join the \fBDOC\fR channel of the \fBLinux-Activists\fR mailing list by 
sending mail to 
.P 1
.P 1
.DS I F 5
\fBlinux-activists-request@niksula\&.hut\&.fi
\"
\fR
.DE
.P 1
.br
.ti 0
with the line
.P 1
.P 1
.DS I F 5
\fBX-Mn-Admin: join DOC
\"
\fR
.DE
.P 1
.br
.ti 0
in the header or as the first line of the message body\&. An empty mail
without the additional header line will make the mail-server return a
help message\&. To leave the channel, send a message to the same address,
including the line
.P 1
.P 1
.DS I F 5
\fBX-Mn-Admin: leave DOC
\"
\fR
.DE
.P 1
.bp
.nr Hu 2
.HU "Filesystem Standards"
.INDEX {File System Standard}
.INDEX {Quinlan, Dan}
.P 1
Throughout the past, one of the problems that afflicted Linux
distributions as well as separate packages was that there was no 
single accepted file system layout\&. This resulted in incompatibilities
between different packages, and confronted users and administrators
alike with the task to locate various files and programs\&.
.P 1
To improve this situation, in August 1993, several people formed the
Linux File System Standard Group, or FSSTND Group for short,
coordinated by Daniel Quinlan\&. After six months of discussion, the group
presented a draft that presents a coherent file sytem structure and
defines the location of most essential programs and configuration files\&.
.P 1
This standard is supposed to be implemented by most major Linux
distributions and packages\&. Throughout this book, we will therefore
assume that any files discussed reside in the location specified by
the standard; only where there is a long tradition that conflicts with
this specification will alternative locations be mentioned\&.
.P 1
The Linux File System Standard can be obtained from all major Linux
FTP sites and their mirrors; for instance, you can find it on 
\fBsunsite\&.unc\&.edu\fR below \fI/pub/linux/docs\fR\&. Daniel Quinlan,
the coordinator of the FSSTND group can be reached at
\fBquinlan@bucknell\&.edu\fR\&.
.P 1
1ex
.P 1
.H 1 "Introduction to Networking"
.SETR "intro"
.P 1
.H 2 "History"
.SETR "intro.history"
.INDEX {Flintstone, Fred}
.P 1
The idea of networking is probably as old as telecommunications itself\&.
Consider people living in the stone age, where drums may have been used
to transmit messages between individuals\&. Suppose caveman A wants to
invite caveman B for a game of hurling rocks at each other, but they
live too far apart for B to hear A banging his drum\&. So what are A's
options? He could 1) walk over to B's place, 2) get a bigger drum, or
3) ask C, who lives halfway between them, to forward the message\&. The
last is called networking\&.
.P 1
Of course, we have come a long way from the primitive pursuits and
devices of our forebears\&. Nowadays, we have computers talk to each other
over vast assemblages of wires, fiber optics, microwaves, and the like,
to make an appointment for saturday's soccer match\&.(\*F)
.FS
The original spirit of which (see above) still shows on some
occasions in Europe\&.
.FE
In the following, we will deal with the means and ways by which this
is accomplished, but leave out the wires, as well as the soccer part\&.
.P 1
We will describe two types of networks in this guide: those based on
UUCP, and those based on TCP/IP\&. These are protocol suites and software
packages that supply means to transport data between two computers\&.  In
this chapter, we will look at both types of networks, and discuss their
underlying principles\&.
.P 1
.INDEX {network}
.INDEX {site}
.INDEX {host}
.P 1
We define a network as a collection of \fIhosts\fR that are able to
communicate with each other, often by relying on the services of a
number of dedicated hosts that relay data between the participants\&.
Hosts are very often computers, but need not be; one can also think of
X-terminals or intelligent printers as hosts\&. Small agglomerations of
hosts are also called \fIsites\fR\&.
.P 1
.INDEX {network!protocols}
.INDEX {protocol}
Communication is impossible without some sort of language or code\&. In
computer networks, these languages are collectively referred to as
\fIprotocols\fR\&. However, you shouldn't think of written protocols
here, but rather of the highly formalized code of behavior observed
when heads of state meet, for instance\&.  In a very similar fashion,
the protocols used in computer networks are nothing but very strict
rules for the exchange of messages between two or more hosts\&.
.P 1
.H 2 "UUCP Networks"
.SETR "intro.uucp"
.INDEX {network!UUCP|see UUCP}
.INDEX {UUCP|(}
.P 1
UUCP is an abbreviation for Unix-to-Unix Copy\&. It started out as a
package of programs to transfer files over serial lines, schedule those
transfers, and initiate execution of programs on remote sites\&. It has
undergone major changes since its first implementation in the late
seventies, but is still rather spartan in the services it offers\&. Its
main application is still in wide-area networks based on dial-up
telephone links\&.
.P 1
UUCP was first developed by Bell Laboratories in 1977 for communication
between their Unix-development sites\&. In mid-1978, this network already
connected over 80 sites\&.  It was running email as an application, as
well as remote printing\&.  However, the system's central use was in
distributing new software and bugfixes\&.(\*F)
.FS
Not that the times had changed that much\&.\&.\&.
.FE
Today, UUCP is not confined to the Un*x environment anymore\&. There
are both free and commercial ports available for a variety of platforms,
including AmigaOS, DOS, Atari's TOS, etc\&.
.P 1
One of the main disadvantages of UUCP networks is their low bandwidth\&.
On one hand, telephone equipment places a tight limit on the maximum
transfer rate\&. On the other hand, UUCP links are rarely permanent
connections; instead, hosts rather dial up each other at regular
intervals\&. Hence, most of the time it takes a mail message to travel a
UUCP network it sits idly on some host's disk, awaiting the next time a
connection is established\&.
.P 1
Despite these limitations, there are still many UUCP networks operating
all over the world, run mainly by hobbyists, which offer private users
network access at reasonable prices\&.  The main reason for the popularity
of UUCP is that it is dirt cheap compared to having your computer
connected to The Big Internet Cable\&.  To make your computer a UUCP node,
all you need is a modem, a working UUCP implementation, and another UUCP
node that is willing to feed you mail and news\&.
.P 1
.H 3 "How to Use UUCP"
.SETR "intro.uucp.howto"
.P 1
The idea behind UUCP is rather simple: as its name indicates, it
basically copies files from one host to another, but it also allows
certain actions to be performed on the remote host\&.
.P 1
.INDEX {remote!execution}
Suppose your machine is allowed to access a hypothetical host named
\fBswim\fR, and have it execute the \fIlpr\fR print command for you\&.
Then you could type the following on your command line to have this
book printed on \fBswim\fR:(\*F)
.FS
When using \fIbash\fR, the GNU Bourne Again Shell, you might have to
escape the exclamation mark, because it uses it as its history
character\&.
.FE
.P 1
.P 1
.DS I F 5
\fB$ uux -r swim!lpr !netguide\&.dvi
\"
\fR
.DE
.P 1
This makes \fIuux\fR, a command from the UUCP suite, schedule a
\fIjob\fR for \fBswim\fR\&. This job consists of the input file,
\fInetguide\&.dvi\fR, and the request to feed this file to \fIlpr\fR\&.
The \fB-r\fR flag tells \fIuux\fR not to call the remote system
immediately, but to rather store the job away until a connection
is established at a later occasion\&. This is called \fIspooling\fR\&.
.P 1
.INDEX {remote!file access}
Another property of UUCP is that it allows to forward jobs and files
through several hosts, provided they cooperate\&. Assume that \fBswim\fR
from the above examples has a UUCP link with \fBgroucho\fR, which
maintains a large archive of Un*x applications\&.  To download the file
\fItripwire-1\&.0\&.tar\&.gz\fR to your site, you might issue
.P 1
.P 1
.DS I F 5
\fB$ uucp -mr swim!groucho!~/security/tripwire-1\&.0\&.tar\&.gz trip\&.tgz
\"
\fR
.DE
.P 1
.INDEX {UUCP!forwarding}
.INDEX {forwarding!UUCP}
The job created will request \fBswim\fR to fetch the file from
\fBgroucho\fR, and send it to your site, where UUCP will store it
in \fItrip\&.tgz\fR and notify you via mail of the file's arrival\&.
This will be done in three steps\&. First, your site sends the job to
\fBswim\fR\&. When \fBswim\fR establishes contact with \fBgroucho\fR the
next time, it downloads the file\&. The final step is the actual
transfer from \fBswim\fR to your host\&.
.P 1
The most important services provided by UUCP networks these days
are electronic mail and news\&. We will come back to these later,
so we will give only a brief introduction here\&.
.P 1
Electronic mail -- email for short -- allows you to exchange
messages with users on remote hosts without actually having to know
how to access these hosts\&. The task of directing a message from your
site to the destination site is performed entirely by the mail
handling system\&. In a UUCP environment, mail is usually transported
by executing the \fIrmail\fR command on a neighboring host, passing
it the recipient address and the mail message\&. \fIrmail\fR will
then forward the message to another host, and so on, until it reaches
the destination host\&. We will look at this in detail in
chapter 
.GETHN "mail"
\&\&.
.P 1
News may best be described as sort of a distributed bulletin board
system\&. Most often, this term refers to Usenet News, which is by far the
most widely known news exchange network with an estimated number of
120,000 participating sites\&.  The origins of Usenet date back to 1979,
when, after the release of UUCP with the new Unix V7, three graduate
students had the idea of a general information exchange within the Unix
community\&. They put together some scripts, which became the first netnews
system\&. In 1980, this network connected \fBduke\fR, \fBunc\fR, and
\fBphs\fR, at two Universities in North Carolina\&.  Out of this, Usenet
eventually grew\&. Although it originated as a UUCP-based network, it is no
longer confined to one single type of network\&.
.P 1
The basic unit of information is the article, which may be posted to
a hierarchy of newsgroups dedicated to specific topics\&. Most
sites receive only a selection of all newsgroups, which carry an
average of 60MB worth of articles a day\&.
.P 1
In the UUCP world, news is generally sent across a UUCP link by collecting
all articles from the groups requested, and packing them up in a number of
\fIbatches\fR\&. These are sent to the receiving site, where they are fed to
the \fIrnews\fR command for unpacking and further processing\&.
.P 1
Finally, UUCP is also the medium of choice for many dial-up archive sites
which offer public access\&.  You can usually access them by dialing them up
with UUCP, logging in as a guest user, and download files from a publicly
accessible archive area\&. These guest accounts often have a login name and
password of \fBuucp\fR/\fBnuucp\fR or something similar\&.
.P 1
.INDEX {UUCP|)}
.P 1
.H 2 "TCP/IP Networks"
.SETR "intro.tcpip"
.INDEX {network!TCP/IP|see TCP/IP}
.INDEX {TCP/IP|(}
.INDEX {Local Area Network|see LAN}
.INDEX {LAN}
.P 1
Although UUCP may be a reasonable choice for low-cost dial-up network
links, there are many situations in which its store-and-forward
technique proves too inflexible, for example in Local Area Networks
(LANs)\&.  These are usually made up of a small number of machines located
in the same building, or even on the same floor, that are interconnected
to provide a homogeneous working environment\&.  Typically, you would want
to share files between these hosts, or run distributed applications on
different machines\&.
.P 1
.INDEX {network!packet-switched}
These tasks require a completely different approach to networking\&.
Instead of forwarding entire files along with a job description, all
data is broken up in smaller chunks (packets), which are forwarded
immediately to the destination host, where they are reassembled\&.  This
type of network is called a \fIpacket-switched\fR network\&.  Among other
things, this allows to run interactive applications over the network\&.
The cost of this is, of course, a greatly increased complexity in
software\&.
.P 1
The solution that Un*x system --- and many non-Un*x sites --- have
adopted is known as TCP/IP\&.  In this section, we will have a look at its
underlying concepts\&.
.P 1
.H 3 "Introduction to TCP/IP-Networks"
.SETR "intro.tcpip.intro"
.INDEX {ARPANET}
.P 1
TCP/IP traces its origins to a research project funded by the United
States DARPA (Defense Advanced Research Projects Agency) in 1969\&. This
was an experimental network, the ARPANET, which was converted into an
operational one in 1975, after it had proven to be a success\&.
.P 1
.INDEX {network!Internet}
.INDEX {Internet}
In 1983, the new protocol suite TCP/IP was adopted as a standard, and
all hosts on the network were required to use it\&.  When ARPANET finally
grew into the Internet (with ARPANET itself passing out of existence in
1990), the use of TCP/IP had spread to networks beyond the Internet
itself\&. Most notable are Un*x local area networks, but in the advent
of fast digital telephone equipment, such as ISDN, it also has a
promising future as a transport for dial-up networks\&.
.P 1
.INDEX {Marx, Groucho}
.INDEX {Groucho Marx University}
.INDEX {Kempen, Fred van}
For something concrete to look at as we discuss TCP/IP throughout the
following sections, we will consider Groucho Marx University (GMU),
situated somewhere in Fredland, as an example\&.  Most departments run
their own local area networks, while some share one, and others run
several of them\&. They are all interconnected, and are hooked to the
Internet through a single high-speed link\&.
.P 1
.INDEX {remote!login}
Suppose your Linux box is connected to a LAN of Un*x hosts at the
Mathematics Department, and its name is \fBerdos\fR\&. To access a host at
the Physics Department, say \fBquark\fR, you enter the following
command:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ rlogin quark.physics
Welcome to the Physics Department at GMU
(ttyq2) login:
.ENDVERBATIM
\"
\fR
.DE
.P 1
At the prompt, you enter your login name, say \fBandres\fR, and
your password\&. You are then given a shell on \fBquark\fR, to which
you can type as if you were sitting at the system's console\&. After
you exit the shell, you are returned to your own machine's prompt\&.
You have just used one of the instantaneous, interactive applications
that TCP/IP provides: remote login\&.
.P 1
.INDEX {remote!X11 session}
While being logged into \fBquark\fR, you might also want to run an
X11-based application, like a function plotting program, or a PostScript
previewer\&. To tell this application that you want to have its windows
displayed on your host's screen, you have to set the \fIDISPLAY\fR
environment variable:
.P 1
.P 1
.DS I F 5
\fB$ export DISPLAY=erdos\&.maths:0\&.0
\"
\fR
.DE
.P 1
If you now start your application, it will contact your X server
instead of \fBquark\fR's, and display all its windows on your screen\&.
Of course, this requires that you have X11 runnning on \fBerdos\fR\&.
The point here is that TCP/IP allows \fBquark\fR and \fBerdos\fR
to send X11 packets back and forth to give you the illusion that
you're on a single system\&. The network is almost transparent here\&.
.P 1
Another very important application in TCP/IP networks is NFS, which
stands for \fINetwork File System\fR\&. It is another form of making the
network transparent, because it basically allows you to mount directory
hierarchies from other hosts, so that they appear like local file
systems\&. For example, all users' home directories can be on a central
server machine, from which all other hosts on the LAN mount the
directory\&. The effect of this is that users can log into any machine,
and find themselves in the same home directory\&.  Similarly, it is
possible to install applications that require large amounts of disk
space (such as TeX) on only one machine, and export these directories
to other machines\&.  We will come back to NFS in chapter 
.GETHN "nfs"
\&\&.
.P 1
Of course, these are only examples of what you can do over TCP/IP
networks\&. The possibilities are almost limitless\&.
.P 1
We will now have a closer look at the way TCP/IP works\&. You will need
this to understand how and why you have to configure your machine\&.  We
will start by examining the hardware, and slowly work our way up\&.
.P 1
.H 3 "Ethernets"
.SETR "intro.tcpip.history"
.INDEX {protocol!Ethernet}
.INDEX {Ethernet|(}
.P 1
The type of hardware most widely used throughout LANs is what is
commonly known as \fIEthernet\fR\&.  It consists of a single cable with
hosts being attached to it through connectors, taps or transceivers\&.
Simple Ethernets are quite inexpensive to install, which, together with
a net transfer rate of 10 Megabits per second accounts for much of its
popularity\&.
.P 1
.INDEX {Ethernet!thin}
.INDEX {thinnet}
.INDEX {BNC connector}
Ethernets come in three flavors, called \fIthick\fR and \fIthin\fR,
respectively, and \fItwisted pair\fR\&.  Thin and thick Ethernet each use
a coaxial cable, differing in width and the way you may attach a host to
this cable\&. Thin Ethernet uses a T-shaped ``BNC'' connector, which you
insert into the cable, and twist onto a plug on the back of your
computer\&.  Thick Ethernet requires that you drill a small hole into the
cable, and attach a transceiver using a ``vampire tap''\&. One or more
hosts can then be connected to the transceiver\&.  Thin and thick Ethernet
cable may run for a maximum of 200 and 500 meters, respectively, and are
therefore also called 10base-2 and 10base-5\&.  Twisted pair uses a cable
made of two copper wires which is also found in ordinary telephone
installations, but usually requires additional hardware\&. It is also
known as 10base-T\&.
.P 1
Although adding a host to a thick Ethernet is a little hairy, it does not
bring down the network\&. To add a host to a thinnet installation, you have
to disrupt network service for at least a few minutes because you have to
cut the cable to insert the connector\&.
.P 1
Most people prefer thin Ethernet, because it is very cheap: PC cards come
for as little as US$ 50, and cable is in the range of a few cent per
meter\&. However, for large-scale installations, thick Ethernet is more
appropriate\&. For example, the Ethernet at GMU's Mathematics Department uses
thick Ethernet, so traffic will not be disrupted each time a host is added
to the network\&.
.P 1
One of the drawbacks of Ethernet technology is its limited cable length,
which precludes any use of it other than for LANs\&. However, several
Ethernet segments may be linked to each other using repeaters, bridges or
routers\&. Repeaters simply copy the signals between two or more segments, so
that all segments together will act as if it was one Ethernet\&.  timing requirements, there may not be more than four repeaters any two hosts on the network\&.  Bridges and Routers are more sophisticated\&.
They analyze incoming data and forward it only when the recipient host is
not on the local Ethernet\&.
.P 1
.INDEX {Ethernet!address}
.INDEX {address!Ethernet}
Ethernet works like a bus system, where a host may send packets (or
\fIframes\fR) of up to 1500 bytes to another host on the same Ethernet\&.
A host is addressed by a six-byte address hardcoded into the firmware of
its Ethernet board\&. These addresses are usually written as a sequence of
two-digit hex numbers separated by colons, as in \fBaa:bb:cc:dd:ee:ff\fR\&.
.P 1
.INDEX {Ethernet!collision}
.INDEX {collision, Ethernet}
A frame sent by one station is seen by all attached stations, but only
the destination host actually picks it up and processes it\&.  If two
stations try to send at the same time, a \fIcollision\fR occurs, which
is resolved by the two stations aborting the send, and reattempting it a
few moments later\&.
.P 1
.INDEX {Ethernet|)}
.P 1
.H 3 "Other Types of Hardware"
.SETR "intro.tcpip.other-hardware"
.INDEX {FDDI}
.P 1
In larger installations, such as Groucho Marx University,
Ethernet is usually not the only type of equipment used\&.
At Groucho Marx University, each department's LAN is linked
to the campus backbone, which is a fiber optics cable running
FDDI (\fIFiber Distributed Data Interface\fR)\&. FDDI uses an
entirely different approach to transmitting data, which basically
involves sending around a number of \fItokens\fR, with a station only
being allowed to send a frame if it captures a token\&. The main advantage
of FDDI is a speed of up to 100 Mbps, and a maximum cable length of
up to 200 km\&.
.P 1
.INDEX {Packet Assembler/Disassembler}
.INDEX {protocol!X\&.25}
.INDEX {PAD}
.INDEX {X\&.25}
For long-distance network links, a different type of equipment is
frequently used, which is based on a standard named X\&.25\&. Many so-called
Public Data Networks, like Tymnet in the U\&.S\&., or Datex-P in Germany,
offer this service\&. X\&.25 requires special hardware, namely a Packet
Assembler/Disassembler or \fIPAD\fR\&.  X\&.25 defines a set of networking
protocols of its own right, but is nevertheless frequently used to
connect networks running TCP/IP and other protocols\&. Since IP packets
cannot simply be mapped onto X\&.25 (and vice versa), they are simply
encapsulated in X\&.25 packets and sent over the network\&.
.P 1
.INDEX {protocol!AX\&.25}
.INDEX {amateur radio}
.INDEX {ham radio}
.INDEX {AX\&.25}
Frequently, radio amateurs use their equipment to network their
computers; this is called \fIpacket radio\fR or \fIham radio\fR\&. The
protocol used by ham radios is called AX\&.25, which was derived from
X\&.25\&.
.P 1
Other techniques involve using slow but cheap serial lines for
dial-up access\&. These require yet another protocol for transmission
of packets, such as SLIP or PPP, which will be described below\&.
.P 1
.H 3 "The Internet Protocol"
.SETR "intro.tcpip.ip"
.INDEX {protocol!IP|see IP}
.INDEX {Internet Protocol|see IP}
.INDEX {IP|(}
.INDEX {routing!IP datagrams|see IP, routing}
.P 1
Of course, you wouldn't want your networking to be limited to one
Ethernet\&. Ideally, you would want to be able to use a network regardless
of what hardware it runs on and how many subunits it is made up of\&. For
example, in larger installations such as Groucho Marx University, you
usually have a number of separate Ethernets that have to be connected in
some way\&. At GMU, the maths department runs two Ethernets: one network
of fast machines for professors and graduates, and another one with slow
machines for students\&. Both are linked to the FDDI campus backbone\&.
.P 1
.INDEX {forwarding!IP}
.INDEX {IP!forwarding}
.INDEX {IP!gateway}
.INDEX {gateway}
This connection is handled by a dedicated host, a so-called \fIgateway\fR,
which handles incoming and outgoing packets by copying them between the two
Ethernets and the fiber optics cable\&.  For example, if you are at the Maths
Department, and want to access \fBquark\fR on the Physics Deparment's LAN
from your Linux box, the networking software cannot send packets to
\fBquark\fR directly, because it is not on the same Ethernet\&. Therefore,
it has to rely on the gateway to act as a forwarder\&. The gateway (name it
\fBsophus\fR) then forwards these packets to its peer gateway \fBniels\fR
at the Physics Department, using the backbone, with \fBniels\fR delivering
it to the destination machine\&. Data flow between \fBerdos\fR and
\fBquark\fR is shown in figure 
.GETHN "intro.fig.ip-flow"
\& (With apologies to
Guy L\&. Steele)\&.
.P 1
\"
.DF I F 5
\"
\"
.br
.FG " The three steps of sending a datagram from \fBerdos\fR to \fBquark\fR\&\&. " "" 0 "intro.fig.ip-flow"
.DE
.P 1
.INDEX {IP!routing}
This scheme of directing data to a remote host is called \fIrouting\fR,
and packets are often referred to as \fIdatagrams\fR in this context\&.
To facilitate things, datagram exchange is governed by a single protocol
that is independent of the hardware used: IP, or \fIInternet
Protocol\fR\&.  In chapter 
.GETHN "tcpip"
\&, we will cover IP and the issues of
routing in greater detail\&.
.P 1
.INDEX {internetworking}
.INDEX {network!interconnecting|see internetworking}
.INDEX {Internet!vs\&. internetworking}
The main benefit of IP is that it turns physically dissimilar
networks into one apparently homogeneous network\&. This is called
internetworking, and the resulting ``meta-network'' is called
an \fIinternet\fR\&. Note the subtle difference between \fIan\fR
internet and \fIthe\fR Internet here\&. The latter is the official
name of one particular global internet\&.
.P 1
.INDEX {address!IP}
.INDEX {IP!address}
.INDEX {dotted quad}
Of course, IP also requires a hardware-independent addressing scheme\&.  This
is achieved by assigning each host a unique 32-bit number, called the
\fIIP address\fR\&. An IP address is usually written as four decimal numbers,
one for each 8-bit portion, separated by dots\&. For example, \fBquark\fR
might have an IP address of \fB0x954C0C04\fR, which would be written as
\fB149\&.76\&.12\&.4\fR\&.  This format is also called \fIdotted quad\fR notation\&.
.P 1
.INDEX {IP!address vs\&. hostname}
.INDEX {Ethernet!address vs\&. IP address}
You will notice that we now have three different types of addresses: first
there is the host's name, like \fBquark\fR, then there are IP addresses,
and finally, there are hardware addresses, like the 6-byte Ethernet
address\&. All these somehow have to match, so that when you type
\fIrlogin quark\fR, the networking software can be given \fBquark\fR's
IP address; and when IP delivers any data to the Physics Department's
Ethernet, it somehow has to find out what Ethernet address corresponds to
the IP address\&.  Which is rather confusing\&.
.P 1
We will not go into this here, and deal with it in chapter 
.GETHN "tcpip"
\&
instead\&. For now, it's enough to remember that these steps of finding
addresses are called \fIhostname resolution\fR, for mapping host names onto
IP addresses, and \fIaddress resolution\fR, for mapping the latter to
hardware addresses\&.
.P 1
.H 3 "IP over Serial Lines"
.SETR "intro.tcpip.slip"
.INDEX {protocol!CSLIP}
.INDEX {protocol!SLIP}
.INDEX {protocol!PPP}
.INDEX {telephone, sending data over}
.INDEX {serial line IP|see SLIP}
.INDEX {Compressed Serial Line IP|see CSLIP}
.INDEX {serial line IP|see PPP}
.INDEX {Point-to-Point Protocol|see PPP}
.INDEX {SLIP}
.INDEX {CSLIP}
.INDEX {PPP}
.P 1
On serial lines, a ``de facto'' standard known as SLIP or 
\fISerial Line IP\fR is frequently used\&.
A modification of SLIP is known as CSLIP, or \fIcompressed SLIP\fR,
and performs compression of IP headers to make better use of the
relatively low bandwidth provided by serial links\&.(\*F)
.FS
SLIP is described in RFC 1055\&. The header compression CSLIP is based
in is described in RFC 1144\&.
.FE
A different serial protocol is PPP, or \fIPoint-to-Point Protocol\fR\&.
PPP has many more features than SLIP, including a link negotiation
phase\&. Its main advantage over SLIP is, however, that it isn't
limited to transporting IP datagrams, but that it was designed to
allow for any type of datagrams to be transmitted\&.
.P 1
.INDEX {IP|)}
.P 1
.H 3 "The Transmission Control Protocol"
.SETR "intro.tcpip.tcp"
.INDEX {Transmission Control Protocol|see TCP}
.INDEX {protocol!TCP}
.INDEX {TCP|(}
.P 1
Now, of course, sending datagrams from one host to another is not the
whole story\&. If you log into \fBquark\fR, you want to have a reliable
connection between your \fIrlogin\fR process on \fBerdos\fR and the
shell process on \fBquark\fR\&. Thus, the information sent to and fro must
be split up into packets by the sender, and reassembled into a character
stream by the receiver\&. Trivial as it seems, this involves a number of
hairy tasks\&.
.P 1
A very important thing to know about IP is that, by intent, it is not
reliable\&. Assume that ten people on your Ethernet started downloading the
latest release of XFree86 from GMU's FTP server\&. The amount of traffic
generated by this might be too much for the gateway to handle, because it's
too slow, and it's tight on memory\&. Now if you happen to send a packet to
\fBquark\fR, \fBsophus\fR might just be out of buffer space for a moment
and therefore unable to forward it\&.  IP solves this problem by simply
discarding it\&. The packet is irrevocably lost\&.  It is therefore the
responsibility of the communicating hosts to check the integrity and
completeness of the data, and retransmit it in case of an error\&.
.P 1
This is performed by yet another protocol, TCP, or \fITransmission
Control Protocol\fR, which builds a reliable service on top of IP\&.  The
essential property of TCP is that it uses IP to give you the illusion
of a simple connection between the two processes on your host and the
remote machine, so that you don't have to care about how and along
which route your data actually travels\&.  A TCP connection works
essentially like a two-way pipe that both processes may write to and
read from\&. Think of it as a telephone conversation\&.
.P 1
.INDEX {network!connections|see network, port}
.INDEX {port|see network, port}
.INDEX {network!port}
TCP identifies the end points of such a connection by the
IP addresses of the two hosts involved, and the number of a
so-called \fIport\fR on each host\&. Ports may be viewed as
attachment points for network connections\&. If we are to strain the
telephone example a little more, one might compare IP addresses
to area codes (numbers map to cities), and port numbers to local
codes (numbers map to individual people's telephones)\&.
.P 1
.INDEX {remote!login}
In the \fIrlogin\fR example, the client application (\fIrlogin\fR)
opens a port on \fBerdos\fR, and connects to port 513 on
\fBquark\fR, which the \fIrlogind\fR server is known to listen to\&.
This establishes a TCP connection\&. Using this connection,
\fIrlogind\fR performs the authorization procedure, and then spawns
the shell\&. The shell's standard input and output are redirected to
the TCP connection, so that anything you type to \fIrlogin\fR
on your machine will be passed through the TCP stream and be
given to the shell as standard input\&.
.P 1
.INDEX {TCP|)}
.P 1
.H 3 "The User Datagram Protocol"
.SETR "intro.tcpip.udp"
.INDEX {User Datagram Protocol|see UDP}
.INDEX {protocol!UDP}
.INDEX {UDP|(}
.P 1
Of course, TCP isn't the only user protocol in TCP/IP networking\&.
Although suitable for applications like \fIrlogin\fR, the overhead
involved is prohibitve for applications like NFS\&.  Instead, it uses a
sibling protocol of TCP called UDP, or \fIUser Datagram Protocol\fR\&.
Just like TCP, UDP also allows an application to contact a service on a
certain port on the remote machine, but it doesn't establish a
connection for this\&. Instead, you may use it to send single packets to
the destination service -- hence its name\&.
.P 1
Assume you have mounted the TeX directory hierarchy from the
department's central NFS server, \fIgalois\fR, and you want to view a
document describing how to use LaTeX\&. You start your editor, who
first reads in the entire file\&. However, it would take too long to
establish a TCP connection with \fIgalois\fR, send the file, and release
it again\&. Instead, a request is made to \fIgalois\fR, who sends the file
in a couple of UDP packets, which is much faster\&.  However, UDP was not
made to deal with packet loss or corruption\&.  It is up to the
application -- NFS in this case -- to take care of this\&.
.P 1
.INDEX {UDP|)}
.P 1
.H 3 "More on Ports"
.SETR "intro.tcpip.ports"
.INDEX {network!services|see port}
.INDEX {services}
.INDEX {network!port|(}
.P 1
Ports may be viewed as attachment points for network connections\&.  If an
application wants to offer a certain service, it attaches itself to a
port and waits for clients (this is also called \fIlistening\fR on the
port)\&.  A client that wants to use this service allocates a port on its
local host, and connects to the server's port on the remote host\&.
.P 1
.INDEX {port!numbers}
.INDEX {network!port numbers}
An important property of ports is that once a connection has been
established between the client and the server, another copy of the server
may attach to the server port and listen for more clients\&.  This permits,
for instance, several concurrent remote logins to the same host, all using
the same port 513\&. TCP is able to tell these connections from each other,
because they all come from different ports or hosts\&. For example, if you
twice log into \fBquark\fR from \fBerdos\fR, then the first \fIrlogin\fR
client will use the local port 1023, and the second one will use port 1022\&.
Both however, will connect to the same port 513 on \fBquark\fR\&.
.P 1
.INDEX {services!well-known}
.INDEX {services!and port numbers}
This example shows the use of ports as rendezvous points, where
a client contacts a specific port to obtain a specific service\&.
In order for a client to know the proper port number, an agreement has
to be reached between the administrators of both systems on the
assignment of these numbers\&. For services that are widely used,
such as \fIrlogin\fR, these numbers have to be administered
centrally\&. This is done by the IETF (or \fIInternet Engineering
Task Force\fR), which regularly releases an RFC titled \fIAssigned
Numbers\fR\&. It describes, among other things, the port numbers assigned
to \fIwell-known services\fR\&. Linux uses a file mapping service
names to numbers, called \fI/etc/services\fR\&. It is described in
section 
.GETHN "appl.services"
\&\&.
.P 1
It is worth noting that although both TCP and UDP connections rely on
ports, these numbers do not conflict\&. This means that TCP port 513, for
example, is different from UDP port 513\&. In fact, these ports serve as
access points for two different services, namely \fIrlogin\fR (TCP) and
\fIrwho\fR (UDP)\&.
.P 1
.INDEX {network!port|)}
.P 1
.H 3 "The Socket Library"
.SETR "intro.tcpip.sockets"
.INDEX {network!programming interface}
.INDEX {BSD socket library}
.INDEX {socket}
.P 1
In Un*x operating systems, the software performing all the tasks and
protocols described above is usually part of the kernel, and so it is in
Linux\&. The programming interface most common in the Un*x world is
the \fIBerkeley Socket Library\fR\&. Its name derives from a popular
analogy that views ports as sockets, and connecting to a port as
plugging in\&. It provides the (\fIbind(2)\fR) call to specifiy a remote
host, a transport protocol, and a service which a program can connect or
listen to (using \fIconnect(2)\fR, \fIlisten(2)\fR, and
\fIaccept(2)\fR)\&.  The socket library is however somewhat more general,
in that it provides not only a class of TCP/IP-based sockets (the
\fIAF_INET\fR sockets), but also a class that handles connections
local to the machine (the \fIAF_UNIX\fR class)\&. Some implementations
can also handle other classes as well, like the XNS (\fIXerox
Networking System\fR) protocol, or X\&.25\&.
.P 1
In Linux, the socket library is part of the standard \fIlibc\fR
C library\&. Currently, it only supports \fIAF_INET\fR and \fIAF_UNIX\fR
sockets, but efforts are made to incorporate support for Novell's
networking protocols, so that eventually one or more socket classes for
these would be added\&.
.P 1
.INDEX {TCP/IP|)}
.P 1
.H 2 "Linux Networking"
.INDEX {Net-1}
.INDEX {Net-2d}
.INDEX {Net-2Debugged}
.INDEX {Biro, Ross}
.INDEX {Cox, Alan}
.INDEX {Kempen, Fred van}
.P 1
Being the result of a concerted effort of programmers around the world,
Linux wouldn't have been possible without the global network\&. So
it's not surprising that already in early stages of development, several
people started to work on providing it with network capabilities\&. A UUCP
implementation was running on Linux almost from the very beginning,
and work on TCP/IP-based networking started around autumn 1992, when
Ross Biro and others created what now has become known as Net-1\&.
.P 1
After Ross quit active development in May 1993, Fred van Kempen began to
work on a new implementation, rewriting major parts of the code\&. This
ongoing effort is known as Net-2\&. A first public release, Net-2d, was
made in Summer 1992 (as part of the 0\&.99\&.10 kernel), and has since been
maintained and expanded by several people, most notably Alan Cox, as
Net-2Debugged\&.  After heavy debugging and numerous improvements to the
code, he changed its name to Net-3 after Linux 1\&.0 was released\&.
This is the version of the networking code currently included in the
official kernel releases\&.
.P 1
Net-3 offers device drivers for a wide variety of Ethernet boards, as
well as SLIP (for sending network traffic over serial lines), and PLIP
(for parallel lines)\&.  With Net-3, Linux has a TCP/IP
implementation that behaves very well in a local area network
environment, showing uptimes that beat some of the commercial PC
Un*ces\&. Development currently moves toward the necessary stability to
reliably run it on Internet hosts\&.
.P 1
Beside these facilities, there are several projects going on that will
enhance the versatility of Linux\&.  A driver for PPP (the
point-to-point protocol, another way to send network traffic over
serial lines), is at Beta stage currently, and an AX\&.25 driver for ham
radio is at Alpha stage\&. Alan Cox has also implemented a driver for
Novell's IPX protocol, but the effort for a complete networking suite
compatible with Novell's has been put on hold for the moment, because
of Novell's unwillingness to provide the necessary documentation\&.
Another very promising undertaking is \fIsamba\fR, a free
NetBIOS server for Un*ces, written by Andrew Tridgell\&.(\*F)
.FS
NetBIOS is the protocol on which applications like \fIlanmanager\fR
and Windows for Workgroups are based\&.
.FE
.P 1
.H 3 "Different Streaks of Development"
.INDEX {device driver interface|see DDI}
.INDEX {Net-2e}
.INDEX {Net-3}
.INDEX {DDI}
.P 1
In the meanwhile, Fred continued development, going on to Net-2e, which
features a much revised design of the networking layer\&.  At the time of
writing, Net-2e is still Beta software\&.  Most notable about Net-2e is
the incorporation of DDI, the \fIDevice Driver Interface\fR\&.  DDI offers
a uniform access and configuration method to all networking devices and
protocols\&.
.P 1
.INDEX {Urlichs, Matthias}
Yet another implemtation of TCP/IP networking comes from Matthias
Urlichs, who wrote an ISDN driver for Linux and FreeBSD\&. For this,
he integrated some of the BSD networking code in the Linux kernel\&.
.P 1
For the foreseeable future, however, Net-3 seems to be here to stay\&.
Alan currently works on an implementation of the AX\&.25 protocol used
by ham radio amateurs\&. Doubtlessly, the yet to be developed ``module''
code for the kernel will also bring new impulses to the networking
code\&. Modules allow you to add drivers to the kernel at run time\&.
.P 1
Although these different network implementations all strive to provide
the same service, there are major differences between them at the
kernel and device level\&.  Therefore, you will not be able to configure
a system running a Net-2e kernel with utilities from Net-2d or Net-3,
and vice versa\&. This only applies to commands that deal with kernel
internals rather closely; applications and common networking commands
such as \fIrlogin\fR or \fItelnet\fR run on either of them\&.
.P 1
Nevertheless, all these different network version should not worry you\&.
Unless you are participating in active development, you will not have to
worry about which version of the TCP/IP code you run\&. The official
kernel releases will always be accompanied by a set of networking tools
that are compatible with the networking code present in the kernel\&.
.P 1
.H 3 "Where to Get the Code"
.INDEX {obtaining the source code}
.INDEX {FTP, location of Linux code}
.INDEX {Net-2e}
.INDEX {Net-3}
.INDEX {Net-BSD}
.P 1
The latest version of the Linux network code can be obtained by
anonymous FTP from various sites\&. The official FTP site for Net-3 is
\fBsunacm\&.swan\&.ac\&.uk\fR, mirrored by \fBsunsite\&.unc\&.edu\fR below
\fIsystem/Network/sunacm\fR\&.  The latest Net-2e patch kit and
binaries are available from \fBftp\&.aris\&.com\fR\&.  Matthias Urlichs'
BSD-derived networking code can be gotten from \fBftp\&.ira\&.uka\&.de\fR
in \fI/pub/system/linux/netbsd\fR\&.
.P 1
The latest kernels can be found on \fBnic\&.funet\&.fi\fR in
\fI/pub/OS/Linux/PEOPLE/Linus\fR; \fBsunsite\fR and
\fBtsx-11\&.mit\&.edu\fR mirror this directory\&.
.P 1
.H 2 "Maintaining Your System"
.INDEX {maintenance, system}
.INDEX {system maintenance}
.P 1
Throughout this book, we will mainly deal with installation and
configuration issues\&. Administration is, however, much more than that ---
after setting up a service, you have to keep it running, too\&.  For most of
them, only little attendance will be necessary, while some, like mail and
news, require that you perform routine tasks to keep your system
up-to-date\&.  We will discuss these tasks in later chapters\&.
.P 1
The absolute minimum in maintenance is to check system and per-application
log files regularly for error conditions and unusual events\&. Commonly, you
will want to do this by writing a couple of administrative shell scripts
and run them from \fIcron\fR periodically\&.  The source distribution of
some major applications, like \fIsmail\fR or C News, contain such scripts\&.
You only have to tailor them to suit your needs and preferences\&.
.P 1
The output from any of your \fIcron\fR jobs should be mailed to an
administrative account\&. By default, many applications will send error
reports, usage statistics, or logfile summaries to the \fBroot\fR account\&.
This only makes sense if you log in as \fBroot\fR frequently; a much
better idea is to forward \fBroot\fR's mail to your personal account
setting up a mail alias as described in chapter 
.GETHN "smail"
\&\&.
.P 1
However carefully you have configured your site, Murphy's law guarantees
that some problem \fIwill\fR surface eventually\&. Therefore, maintaining a
system also means being available for complaints\&. Usually, people expect
that the system administrator can at least be reached via email as
\fBroot\fR, but there are also other addresses that are commonly used to
reach the person responsible for a specific aspect of maintenence\&. For
instance, complaints about a malfunctioning mail configuration will usually
be addressed \fBpostmaster\fR; and problems with the news system may be
reported to \fBnewsmaster\fR or \fBusenet\fR\&. Mail to
\fBhostmaster\fR should be redirected to the person in charge of the
host's basic network services, and the DNS name service if you run a name
server\&.
.P 1
.H 3 "System Security"
.INDEX {system security}
.INDEX {security!system}
.P 1
Another very important aspect of system administration in a network
environment is protecting your system and users from intruders\&.
Carelessly managed systems offer malicious people many targets:  attacks
range from password guessing to Ethernet snooping, and the damage caused
may range from faked mail messages to data loss or violation of your
users' privacy\&. We will mention some particular problems when discussing
the context they may occur in, and some common defenses against them\&.
.P 1
This section will discuss a few examples and basic techniques in dealing
with system security\&.  Of course, the topics covered can not treat all
security issues you may be faced with exhaustively; they merely serve to
illustrate the problems that may arise\&.  Therefore, reading a good book
on security is an absolute must, especially in a networked system\&.
Simon Garfinkel's ``Practical UNIX Security'' (see [
GETST "security"
]) is
highly recommendable\&.
.P 1
System security starts with good system administration\&. This includes
checking the ownership and permissions of all vital files and directories,
monitoring use of privileged accounts, etc\&. The COPS program, for instance,
will check your file system and common configuration files for unusual
permissions or other anomalies\&. It is also wise to use a password suite
that enforces certain rules on the users' passwords that make them hard to
guess\&. The shadow password suite, for instance, requires a password to have
at least five letters, and contain both upper and lower case numbers and
digits\&.
.P 1
.INDEX {services!restricting access}
When making a service accessible to the network, make sure to give it
``least privilege,'' meaning that you don't permit it to do things that
aren't required for it to work as designed\&. For example, you should make
programs setuid to \fBroot\fR or some other privileged account only
when they really need this\&. Also, if you want to use a service for only
a very limited application, don't hesitate to configure it as
restrictively as your special application allows\&. For instance, if you
want to allow diskless hosts to boot from your machine, you must provide
the TFTP (trivial file transfer service) so that they can download basic
configuration files from the \fI/boot\fR directory\&. However, when used
unrestricted, TFTP allows any user anywhere in the world to download any
world-readable file from your system\&. If this is not what you want,
why not restrict TFTP service to the \fI/boot\fR directory?(\*F)
.FS
We will come back to this in chapter 
.GETHN "appl"
\&\&.
.FE
.P 1
.INDEX {access!restricting}
Along the same line of thought, you might want to restrict certain
services to users from certain hosts, say from your local network\&. 
In chapter 
.GETHN "appl"
\&, we introduce \fItcpd\fR which does this for
a variety of network applications\&.
.P 1
Another important point is to avoid ``dangerous'' software\&. Of course,
any software you use can be dangerous, because software may have bugs
that clever people might exploit to gain access to your system\&. Things
like these happen, and there's no complete protection against this\&.
This problem affects free software and commercial products
alike\&.(\*F)
.FS
There have been commercial Un*ces you have to pay lots of money for
that came with a setuid-\fBroot\fR shell script which allowed users to
gain \fBroot\fR privilege using a simple standard trick\&.
.FE
However, programs that require special privilege are inherently more
dangerous than others, because any loophole can have drastic
consequences\&.(\*F)
.FS
In 1988, the RTM worm brought much of the Internet to a grinding halt,
partly by exploiting a gaping hole in some \fIsendmail\fR programs\&.
This hole has long been fixed since\&.
.FE
If you install a setuid program for network purposes be doubly careful
that you don't miss anything from the documentation, so that you don't
create a security breach by accident\&.
.P 1
.INDEX {tripwire@\fItripwire\fR}
You can never rule out that your precautions might fail, regardless how
careful you have been\&. You should therefore make sure you detect
intruders early\&. Checking the system log files is a good starting point,
but the intruder is probably as clever, and will delete any obvious
traces he or she left\&. However, there are tools like
\fItripwire\fR(\*F)
.FS
Written by Gene Kim and Gene Spafford\&.
.FE
that allow you to check vital system files to see if their contents or
permissions have been changed\&.  \fItripwire\fR computes various strong
checksums over these files and stores them in a database\&.  During
subsequent runs, the checksums are re-computed and compared to the stored
ones to detect any modifications\&.
.P 1
.H 2 "Outlook on the Following Chapters"
.SETR "intro.outlook"
.P 1
The next few chapters will deal with configuring Linux for
TCP/IP networking, and with running some major applications\&.
Before getting our hands dirty with file editing and the like,
we will examine IP a little closer in chapter 
.GETHN "tcpip"
\&\&. If you
already know about the way IP routing works, and how address resolution
is performed, you might want to skip this chapter\&.
.P 1
Chapter 
.GETHN "hardware"
\& deals with the very basic configuration issues,
such as building a kernel and setting up your Ethernet board\&.
The configuration of your serial ports is covered in a separate
chapter, because the discussion does not apply to TCP/IP networking
only, but is also relevant for UUCP\&.
.P 1
Chapter 
.GETHN "iface"
\& helps you to set up your machine for TCP/IP
networking\&.  It contains installation hints for standalone hosts with
only loopback enabled, and hosts connected to an Ethernet\&.  It will also
introduce you to a few useful tools you can use to test and debug your
setup\&. The next chapter discusses how to configure hostname
resolution, and explains how to set up a name server\&.
.P 1
This is followed by two chapters featuring the configuration and use of
SLIP and PPP, respectively\&. Chapter 
.GETHN "slip"
\& explains how to establish
SLIP connections, and gives a detailed reference of \fIdip\fR, a
tool that allows you to automate most of the necessary steps\&.
Chapter 
.GETHN "ppp"
\& covers PPP and \fIpppd\fR, the PPP daemon you
need for this\&.
.P 1
Chapter 
.GETHN "appl"
\& gives a short introduction to setting up some of the
most important network applications, such as \fIrlogin\fR, \fIrcp\fR,
etc, in chapter 
.GETHN "appl"
\&\&.  This also covers how services are managed
by the \fIinetd\fR super, and how you may restrict certain
security-relevant services to a set of trusted hosts\&.
.P 1
The next two chapters discuss NIS, the Network Information System, and
NFS, the Network File System\&.  NIS is a useful tool to distribute
administative information such as user passwords in a local area
network\&.  NFS allows you to share file systems between several hosts in
your network\&.
.P 1
Chapter 
.GETHN "uucp"
\& gives you an extensive introduction to the
administration of Taylor UUCP, a free implementation of the UUCP suite\&.
.P 1
The remainder of the book is taken up by a detailed tour of electronic
mail and Usenet News\&. Chapter 
.GETHN "mail"
\& introduces you to the central
concepts of electronic mail, like what a mail address looks like, and
how the mail handling system manages to get your message to the
recipient\&.
.P 1
Chapters 
.GETHN "smail"
\& and 
.GETHN "sendmail"
\& each cover the setup of
\fIsmail\fR and \fIsendmail\fR, two mail transport agents you can use
for Linux\&.  This book explains both of them, because \fIsmail\fR is
easier to install for the beginner, while \fIsendmail\fR is more
flexible\&.
.P 1
Chapters 
.GETHN "news"
\& and 
.GETHN "cnews"
\& explain the way news are managed in
Usenet, and how you install and use C news, a popular software package
for managing Usenet news\&. Chapter 
.GETHN "nntp"
\& briefly covers how to set
up an NNTP daemon to provide news reading access for your local network\&.
Chapter 
.GETHN "newsreaders"
\& finally shows you how to configure and
maintain various newsreaders\&.
.P 1
.H 1 "Issues of TCP/IP Networking"
.SETR "tcpip"
.INDEX {TCP/IP|(}
.P 1
We will now turn to the details you'll come in touch with when
connecting your Linux machine to a TCP/IP network including dealing
with IP addresses, host names, and sometimes routing issues\&.  This
chapter gives you the background you need in order to understand what
your setup requires, while the next chapters will cover the tools to
deal with these\&.
.P 1
.H 2 "Networking Interfaces"
.SETR "tcpip.interfaces"
.INDEX {access network hardware|see interface}
.INDEX {network!interface|see interface}
.INDEX {interface}
.P 1
To hide the diversity of equipment that may be used in a networking
environment, TCP/IP defines an abstract \fIinterface\fR through which
the hardware is accessed\&. This interface offers a set of operations
which is the same for all types of hardware and basically deals with
sending and receiving packets\&.
.P 1
For each periphereal device you want to use for networking, a
corresponding interface has to be present in the kernel\&. For example,
Ethernet interfaces in Linux are called \fIeth0\fR and \fIeth1\fR,
and SLIP interfaces come as \fIsl0\fR, \fIsl1\fR, etc\&.  These
interface names are used for configuration purposes when you want to
name a particular physical device to the kernel\&. They have no meaning
beyond that\&.
.P 1
To be useable for TCP/IP networking, an interface must be assigned an
IP address which serves as its identifcation when communicating with the
rest of the world\&. This address is different from the interface name
mentioned above; if you compare an interface to door, then the address
is like the name-plate pinned on it\&.
.P 1
Of course, there are other device parameters that may be set; one of
these is the maximum size of datagrams that can be processed by that
particular piece of hardware, also called \fIMaximum Transfer Unit\fR,
or MTU\&. Other attributes will be introduced later\&.
.P 1
.H 2 "IP Addresses"
.SETR "tcpip.ip-addresses"
.INDEX {IP!networks}
.INDEX {IP!address|(}
.P 1
As mentioned in the previous chapter, the addresses understood by the
IP networking protocol are 32-bit numbers\&. Every machine must be assigned a
number unique to the networking environment\&. If you are running
a local network that does not have TCP/IP traffic with other 
networks, you may assign these numbers according to your personal
preferences\&. However, for sites on the Internet, numbers are
assigned by a central authority, the Network Information Center,
or NIC\&.(\*F)
.FS
Frequently, IP addresses will be assigned to you by the provider you
buy your IP connectivity from\&. However, you may also apply to
NIC directly for an IP address for your network by sending a mail to
\fBhostmaster@internic\&.net\fR\&.
.FE
.P 1
.INDEX {dotted quad}
For easier reading, IP addresses are split up into four 8 bit numbers
called \fIoctets\fR\&.  For example, \fBquark\&.physics\&.groucho\&.edu\fR has an
IP address of \fB0x954C0C04\fR, which is written as \fB149\&.76\&.12\&.4\fR\&.
This format is often referred to as the \fIdotted quad notation\fR\&.
.P 1
Another reason for this notation is that IP addresses are split into a
\fInetwork\fR number, which is contained in the leading octets, and a
\fIhost\fR number, which is the remainder\&.  When applying to the NIC
for IP addresses, you are not assigned an address for each single host
you plan to use\&. Instead, you are given a network number, and are
allowed to assign all valid IP addresses within this range to hosts on
your network according to your preferences\&.
.P 1
Depending on the size of the network, the host part may need to be
smaller or larger\&. To accomodate different needs, there are several
classes of networks, defining different splits of IP addresses\&.
.P 1
\"
.BL 10
.LI "Class A"
Class A comprises networks \fB1\&.0\&.0\&.0\fR through
\fB127\&.0\&.0\&.0\fR\&.  The network number is contained in the first
octet\&.  This provides for a 24 bit host part, allowing roughly
1\&.6 million hosts\&.
.P 1
.LI "Class B"
Class B contains networks \fB128\&.0\&.0\&.0\fR through
\fB191\&.255\&.0\&.0\fR; the network number is in the first two
octets\&.  This allows for 16320 nets with 65024 hosts each\&.
.P 1
.LI "Class C"
Class C networks range from \fB192\&.0\&.0\&.0\fR through
\fB223\&.255\&.255\&.0\fR, with the network number being contained in
the first three octets\&. This allows for nearly 2 million
networks with up to 254 hosts\&.
.P 1
.LI "Classes D, E, and F"
Addresses falling into the range of \fB224\&.0\&.0\&.0\fR through
\fB254\&.0\&.0\&.0\fR are either experimental, or are reserved for
future use and don't specify any network\&.
.P 1
\"
.LE
.P 1
If we go back to the example in the previous chapter, we find that
\fB149\&.76\&.12\&.4\fR, the address of \fBquark\fR, refers to host
\fB12\&.4\fR on the class B network \fB149\&.76\&.0\&.0\fR\&.
.P 1
.INDEX {address!broadcast}
You may have noticed that in the above list not all possible values were
allowed for each octet in the host part\&. This is because host numbers
with octets all \fB0\fR or all \fB255\fR are reserved for special purposes\&.
An address where all host part bits are zero refers to the network, and
one where all bits of the host part are 1 is called a broadcast address\&.
This refers to all hosts on the specified network simultaneously\&.
Thus, \fB149\&.76\&.255\&.255\fR is not a valid host address, but refers
to all hosts on network \fB149\&.76\&.0\&.0\fR\&.
.P 1
.INDEX {IP!default route}
.INDEX {default IP route|see route, default}
.INDEX {route, default}
.INDEX {loopback!address}
There are also two network addresses that are reserved, \fB0\&.0\&.0\&.0\fR and
\fB127\&.0\&.0\&.0\fR\&. The first is called the \fIdefault route\fR, the latter
the \fIloopback address\fR\&. The default route has something to do with the
way IP routes datagrams, which will be dealt with below\&.
.P 1
Network \fB127\&.0\&.0\&.0\fR is reserved for IP traffic local to your
host\&.  Usually, address \fB127\&.0\&.0\&.1\fR will be assigned to a special
interface on your host, the so-called \fIloopback interface\fR, which
acts like a closed circuit\&. Any IP packet handed to it from TCP or UDP
will be returned to them as if it had just arrived from some network\&.
This allows you to develop and test networking software without ever
using a ``real'' network\&. Another useful application is when you want
to use networking software on a standalone host\&. This may not be as
uncommon as it sounds; for instance, many UUCP sites don't have IP
connectivity at all, but still want to run the INN news system
nevertheless\&. For proper operation on Linux, INN requires the
loopback interface\&.
.P 1
.INDEX {IP!address|)}
.P 1
.H 2 "Address Resolution"
.SETR "tcpip.arp"
.INDEX {Address Resolution Protocol|see ARP}
.INDEX {Reverse Address Resolution Protocol|see RARP}
.INDEX {ARP|(}
.INDEX {Ethernet!address}
.P 1
Now that you've seen how IP addresses are made up, you may be wondering
how they are used on an Ethernet to address different hosts\&. After all,
the Ethernet protocol identifies hosts by a six-octet number that has
absolutely nothing in common with an IP address, doesn't it?
.P 1
.INDEX {ham radio}
Right\&. That's why a mechanism is needed to map IP addresses onto
Ethernet addresses\&. This is the so-called \fIAddress Resolution
Protocol\fR, or ARP\&. In fact, ARP is not confined to Ethernets at all,
but is used on other types networks such as ham radio as well\&.  The
idea underlying ARP is exactly what most people do when they have to
find Mr\&. X\&. Ample in a throng of 150 people: they go round, calling
out his name, confident that he will respond if he's there\&.
.P 1
When ARP wants to find out the Ethernet address corresponding to a
given IP address, it uses a feature of Ethernet known as
``broadcasting,'' where a datagram is addressed to all stations on the
network simultaneously\&. The broadcast datagram sent by ARP contains a
query for the IP address\&. Each receiving host compares this to its own
IP address, and if it matches, returns an ARP reply to the inquiring
host\&. The inquiring host can now extract the sender's Ethernet address
from the reply\&.
.P 1
Of course you might wonder how a host may know on which of the
zillions of Ethernets throughout the world it is to find the desired
host, and why this should even be an Ethernet\&. These questions all
involve what is called routing, namely finding out the physical
location of a host in a network\&.  This will be the topic of the
following section\&.
.P 1
For a moment, let's talk about ARP a little longer\&. Once a host has
discovered an Ethernet address, it stores it in its ARP cache,
so that it doesn't have to query for it the next time it wants to
send a datagram to the host in question\&. However, it is unwise to
keep this information forever; for instance, the remote host's
Ethernet card may be replaced because of technical problems, so the 
ARP entry becomes invalid\&. To force another query for the IP address,
entries in the ARP cache are therefore discarded after some time\&.
.P 1
.INDEX {diskless clients}
.INDEX {BOOTP}
.INDEX {RARP}
Sometimes, it is also necessary to find out the IP address associated
with a given Ethernet address\&. This happens when a diskless machine
wants to boot from a server on the network, which is quite a common
situation on local area networks\&. A diskless client, however, has
virtually no information about itself -- except for its Ethernet
address! So what it basically does is broadcast a message containing a
plea for boot servers to tell it its IP address\&. There's another
protocol for this, named \fIReverse Address Resolution Protocol\fR, or
RARP\&. Along with the BOOTP protocol, it serves to define a procedure
for bootstrapping diskless clients over the network\&.
.P 1
.INDEX {ARP|)}
.P 1
.H 2 "IP Routing"
.SETR "tcpip.routing"
.INDEX {IP!routing|(}
.P 1
.H 3 "IP Networks"
.SETR "tcpip.routing.networks"
.INDEX {IP!networks}
.P 1
.MARGINPAR
<>
.ENDMARGINPAR
When you write a letter to someone, you usually put a complete address
on the envelope, specifying the country, state, zip code, etc\&. After
you put it into the letter box, the postal service will deliver it to
its destination: it will be sent to the country indicated, whose national
service will dispatch it to the proper state and region, etc\&.  The
advantage of this hierarchical scheme is rather obvious: Wherever you
post the letter, the local postmaster will know roughly the direction to
forward the letter to, but doesn't have to care which way the letter
will travel by within the destination country\&.
.P 1
IP networks are structured in a similar way\&. The whole Internet
consists of a number of proper networks, called \fIautonomous systems\fR\&.
Each such system performs any routing between its member hosts
internally, so that the task of delivering a datagram is reduced to finding
a path to the destination host's network\&. This means, as soon as the datagram 
is handed to \fIany\fR host that is on that particular network, further 
processing is done exclusively by the network itself\&.
.P 1
.H 3 "Subnetworks"
.SETR "tcpip.routing.subnets"
.INDEX {IP!sub-networks|see IP, subnet}
.INDEX {IP!subnet|(}
.P 1
This structure is reflected by splitting IP addresses into a host and
network part, as explained above\&. By default, the destination network is
derived from the network part of the IP address\&. Thus, hosts with
identical IP network numbers should be found within the same network,
and vice versa\&.(\*F)
.FS
Autonomous systems are slightly more general, however\&. They may comprise
more than one IP network\&.
.FE
.P 1
It makes sense to offer a similar scheme \fIinside\fR the network,
too, since it may consist of a collection of hundreds of smaller
networks itself, with the smallest units being physical networks like
Ethernets\&. Therefore, IP allows you to subdivide an IP network into
several \fIsubnets\fR\&.
.P 1
.INDEX {interface!netmask}
.INDEX {IP!netmask}
A subnet takes over responsibility for delivering datagrams to a certain
range of IP addresses from the IP network it is part of\&.  As with
classes A, B, or C, it is identified by the network part of the
IP addresses\&. However, the network part is now extended to include
some bits from the host part\&.  The number of bits that are interpreted
as the subnet number is given by the so-called \fIsubnet mask\fR, or
\fInetmask\fR\&.  This is a 32 bit number, too, which specifies the bit
mask for the network part of the IP address\&.
.P 1
\"
.DF I F 5
\"
\"
.br
.FG " Subnetting a class B network " "" 0 "tcpip.fig.subnet"
.DE
.P 1
.INDEX {Groucho Marx University}
The campus network of Groucho Marx University is an example of such a
network\&. It has a class B network number of \fB149\&.76\&.0\&.0\fR, and its
netmask is therefore \fB255\&.255\&.0\&.0\fR\&.
.P 1
Internally, GMU's campus network consists of several smaller networks,
such as the LANs of various departments\&. So the range of IP addresses
is broken up into 254 subnets, \fB149\&.76\&.1\&.0\fR through
\fB149\&.76\&.254\&.0\fR\&.  For example, the Department of Theoretical
Physics has been assigned \fB149\&.76\&.12\&.0\fR\&.  The campus backbone is
a network by its own right, and is given \fB149\&.76\&.1\&.0\fR\&.  These
subnets share the same IP network number, while the third octet is
used to distinguish between them\&.  Thus they will use a subnet mask of
\fB255\&.255\&.255\&.0\fR\&.
.P 1
Figure 
.GETHN "tcpip.fig.subnet"
\& shows how \fB149\&.76\&.12\&.4\fR, the
address of \fBquark\fR, is interpreted differently when the address
is taken as an ordinary class B network, and when used with
subnetting\&.
.P 1
.INDEX {delegating!IP subnets}
.INDEX {subnet (IP)}
It is worth noting that subnetting (as the technique of generating
subnets is called) is only an \fIinternal division\fR of the network\&.
Subnets are generated by the network owner (or the administrators)\&.
Frequently, subnets are created to reflect existing boundaries, be they
physical (between two Ethernets), administrative (between two
departments), or geographical, and authority over these subnets is
delegated to some contact person\&. However, this structure affects only
the network's internal behavior, and is completely invisible to the
outside world\&.
.P 1
.INDEX {IP!subnet|)}
.P 1
.H 3 "Gateways"
.SETR "tcpip.routing.gateway"
.INDEX {internetworking}
.INDEX {gateway|(}
.P 1
Subnetting is not only an organizational benefit, it is frequently a
natural consequence of hardware boundaries\&.  The viewpoint of a host on
a given physical network, such as an Ethernet, is a very limited one:
the only hosts it is able to talk to directly are those of the network
it is on\&.  All other hosts can be accessed only through so-called
\fIgateways\fR\&.  A gateway is a host that is connected to two or more
physical networks simultaneously and is configured to switch packets
between them\&.
.P 1
For IP to be able to easily recognize if a host is on a local physical
network, different physical networks have to belong to different
IP networks\&. For example the network number \fB149\&.76\&.4\&.0\fR is
reserved for hosts on the mathematics LAN\&. When sending a datagram to
\fBquark\fR, the network software on \fBerdos\fR immediately sees from
the IP address, \fB149\&.76\&.12\&.4\fR, that the destination host is on a
different physical network, and therefore can be reached only through
a gateway (\fBsophus\fR by default)\&.
.P 1
\fBsophus\fR itself is connected to two distinct subnets: the
Mathematics Department, and the campus backbone\&. It accesses each
through a different interface, \fIeth0\fR and \fIfddi0\fR,
respectively\&.  Now, what IP address do we assign it? Should we give it
one on subnet \fB149\&.76\&.1\&.0\fR, or on \fB149\&.76\&.4\&.0\fR?
.P 1
The answer is: both\&. When talking to a host on the Maths LAN,
\fBsophus\fR should use an IP address of \fB149\&.76\&.4\&.1\fR, and when
talking to a host on the backbone, it should use \fB149\&.76\&.1\&.4\fR\&.
.P 1
Thus, a gateway is assigned one IP address per network it is on\&.  These
addresses --- along with the corresponding netmask --- are tied to the
interface the subnet is accessed through\&. Thus, the mapping of
interfaces and addresses for \fBsophus\fR would look like this:
.P 1
.br
.ad c
.ti 0		
.TS
box tab(&);
| l | r | r |.
_
iface &address &netmask 
_
_
\fIeth0\fR &\fB149\h'0'.76\h'0'.4\h'0'.1\fR &\fB255\h'0'.255\h'0'.255\h'0'.0\fR 
\fIfddi0\fR &\fB149\h'0'.76\h'0'.1\h'0'.4\fR &\fB255\h'0'.255\h'0'.255\h'0'.0\fR 
\fIlo\fR &\fB127\h'0'.0\h'0'.0\h'0'.1\fR &\fB255\h'0'.0\h'0'.0\h'0'.0\fR 
_
.TE
.P 1
.ad b
.P 1
The last entry describes the loopback interface \fIlo\fR, which was
introduced above\&.
.P 1
Figure 
.GETHN "intro.fig.ip"
\& shows a part of the network topology at
Groucho Marx University (GMU)\&.  Hosts that are on two subnets at the
same time are shown with both addresses\&.
.P 1
\"
.DF I F 5
.so groucho.ascii
\"
\"
.br
.FG " A part of the net topology at Groucho Marx Univ\&\&. " "" 0 "intro.fig.ip"
.DE
.P 1
Generally, you can ignore the subtle difference between attaching an
address to a host or its interface\&. For hosts that are on one network
only, like \fBerdos\fR, you would generally refer of the host as
having this-and-that IP address although strictly speaking, it's the Ethernet
interface that has this IP address\&. However, this distinction is only
really important when you refer to a gateway\&.
.P 1
.INDEX {gateway|)}
.P 1
.H 3 "The Routing Table"
.SETR "tcpip.routing.table"
.INDEX {IP!routing}
.INDEX {IP!routing table}
.INDEX {routing!table}
.P 1
We are now focusing our attention on how IP chooses a gateway to use
when delivering a datagram to a remote network\&.
.P 1
We have seen before that \fBerdos\fR, when given a datagram for
\fBquark\fR, checks the destination address and finds it is not on the
local network\&. It therefore sends it to the default gateway,
\fBsophus\fR, which is now basically faced with the same task\&.
\fBsophus\fR recognizes that \fBquark\fR is not on any of the networks
it is connected to directly, so it has to find yet another gateway to
forward it through\&. The correct choice would be \fIniels\fR, the
gateway to the Physics Department\&. \fBsophus\fR therefore needs some
information to associate a destination network with a suitable gateway\&.
.P 1
The routing information IP uses for this is basically a table linking
networks to gateways that reach them\&. A catch-all entry (the \fIdefault
route\fR) must generally be supplied, too; this is the gateway associated
with network \fB0\&.0\&.0\&.0\fR\&. All packets to an unknown network are sent
through the default route\&.  On \fBsophus\fR, this table might look like
this:
.P 1
.br
.ad c
.ti 0		
.TS
box tab(&);
| l | l | l |.
_
Network &Gateway &Interface 
_
_
\fB149\h'0'.76\h'0'.1\h'0'.0\fR &- &\fBfddi0\fR 
\fB149\h'0'.76\h'0'.2\h'0'.0\fR &\fB149\h'0'.76\h'0'.1\h'0'.2\fR &\fBfddi0\fR 
\fB149\h'0'.76\h'0'.3\h'0'.0\fR &\fB149\h'0'.76\h'0'.1\h'0'.3\fR &\fBfddi0\fR 
\fB149\h'0'.76\h'0'.4\h'0'.0\fR &- &\fBeth0\fR 
\fB149\h'0'.76\h'0'.5\h'0'.0\fR &\fB149\h'0'.76\h'0'.1\h'0'.5\fR &\fBfddi0\fR 
\h'0'.\h'0'.\h'0'.&\h'0'.\h'0'.\h'0'.&\h'0'.\h'0'.\h'0'.
\fB0\h'0'.0\h'0'.0\h'0'.0\fR &\fB149\h'0'.76\h'0'.1\h'0'.2\fR &\fBfddi0\fR 
_
.TE
.P 1
.ad b
.P 1
Routes to a network that \fBsophus\fR is directly connected to don't
require a gateway; therefore they show a gateway entry of ``-''\&.
.P 1
.INDEX {IP!dynamic routing}
.INDEX {dynamic routing}
.INDEX {routing!daemon}
.INDEX {routing!dynamic}
Routing tables may be built by various means\&. For small LANs, it is
usually most efficient to construct them by hand and feed them to IP
using the \fIroute\fR command at boot time (see chapter 
.GETHN "iface"
\&)\&.
For larger networks, they are built and adjusted at run-time by
\fIrouting daemons\fR; these run on central hosts of the network and
exchange routing information to compute ``optimal'' routes between the
member networks\&.
.P 1
.INDEX {IP!routing protocols}
.INDEX {routing!protocols}
.INDEX {Routing Information Protocol}
.INDEX {RIP|see Routing Information Protocol}
.INDEX {routed@\fIrouted\fR}
.INDEX {gated@\fIgated\fR}
Depending on the size of the network, different routing protocols will
be used\&.  For routing inside autonomous systems (such as Groucho Marx
campus), the \fIinternal routing protocols\fR are used\&.  The most
prominent one is RIP, the Routing Information Protocol, which is
implemented by the BSD \fIrouted\fR daemon\&.  For routing between
autonomous systems, \fIexternal routing protocols\fR like EGP
(External Gateway Protocol), or BGP (Border Gateway Protocol) have to be
used; these (as well as RIP) have been implemented in the University of
Cornell's \fIgated\fR daemon\&.(\*F)
.FS
\fIrouted\fR is considered broken by many people\&.  Since \fIgated\fR
supports RIP  as well, it is better to use that instead\&.
.FE
.P 1
.H 3 "Metric Values"
.SETR "tcpip.routing.metric"
.INDEX {Routing Information Protocol}
.INDEX {IP!metric}
.INDEX {routing!metric}
.INDEX {metric, routing|see routing, metric}
.P 1
Dynamic routing based on RIP chooses the best route to some destination
host or network based on the number of ``hops'', that is, the gateways a
datagram has to pass before reaching it\&. The shorter a route is, the
better RIP rates it\&. Very long routes with 16 or more hops are regarded
as unusable, and are discarded\&.
.P 1
To use RIP to manage routing information internal to your local
network, you have to run \fIgated\fR on all hosts\&. At boot time,
\fIgated\fR checks for all active network interfaces\&.  If there is
more than one active interface (not counting the loopback interface),
it assumes the host is switching packets between several networks, and
will actively exchange and broadcast routing information\&. Otherwise,
it will only passively receive any RIP updates and update the local
routing table\&.
.P 1
When broadcasting the information from the local routing table,
\fIgated\fR computes the length of the route from the so-called
\fImetric value\fR associated with the routing table entry\&. This
metric value is set by the system administrator when configuring the
route and should reflect the actual cost of using this route\&. Therefore,
the metric of a route to a subnet the host is directly connected to
should always be zero, while a route going through two gateways should
have a metric of two\&. However, note that you don't have to bother about
metrics when you don't use \fIRIP\fR or \fIgated\fR\&.
.P 1
.INDEX {IP!routing|)}
.P 1
.H 2 "The Internet Control Message Protocol"
.SETR "tcpip.icmp"
.INDEX {Internet Control Message Protocol}
.INDEX {ICMP}
.P 1
.INDEX {ICMP!Port Unreachable}
IP has a companion protocol that we haven't talked about yet\&. This is
the \fIInternet Control Message Protocol\fR (ICMP) and is used by the
kernel networking code to communicate error messages and the like to
other hosts\&. For instance, assume that you are on \fBerdos\fR again and
want to \fItelnet\fR to port 12345 on \fBquark\fR, but there's no
process listening on that port\&. When the first TCP packet for this port
arrives on \fBquark\fR, the networking layer will recognize this and
immediately return an ICMP message to \fBerdos\fR stating ``Port
Unreachable''\&.
.P 1
.INDEX {ICMP!Redirect}
.INDEX {routing!ICMP Redirect}
.INDEX {routing!dynamic}
.INDEX {IP!routing}
There are quite a number of messages ICMP understands, many of which
deal with error conditions\&. However, there is one very interesting
message called the Redirect message\&. It is generated by the routing
module when it detects that another host is using it as a gateway,
although there is a much shorter route\&. For example, after booting the
routing table of \fBsophus\fR may be incomplete, containing the routes
to the Mathematics network, to the FDDI backbone, and the default route
pointing at the Groucho Computing Center's gateway (\fBgcc1\fR)\&.
Therefore, any packets for \fBquark\fR would be sent to \fBgcc1\fR
rather than to \fBniels\fR, the gateway to the Physics Department\&. When
receiving such a datagram, \fBgcc1\fR will notice that this is a poor
choice of route, and will forward the packet to \fBniels\fR, at the
same time returning an ICMP Redirect message to \fBsophus\fR telling it
of the superior route\&.
.P 1
Now, this seems a very clever way to avoid having to set up any but
the most basic routes manually\&. However be warned that relying on
dynamic routing schemes, be it RIP or ICMP Redirect messages, is not
always a good idea\&. ICMP Redirect and RIP offer you little or no
choice in verifying that some routing information is indeed authentic\&.
This allows malicious good-for-nothings to disrupt your entire network
traffic, or do even worse things\&.  For this reason, there are some
versions of the Linux networking code that treat Redirect messages
that affect network routes, as if they were only Redirects for host
routes\&.
.P 1
.INDEX {TCP/IP|)}
.P 1
.H 2 "The Domain Name System"
.SETR "tcpip.dns"
.INDEX {DNS|(}
.INDEX {Domain Name System|see DNS}
.P 1
.H 3 "Hostname Resolution"
.SETR "tcpip.dns.resolv"
.INDEX {hostname!resolution}
.INDEX {hostname!mapping to addresses}
.INDEX {IP!address!and hostname}
.P 1
.MARGINPAR
<>
.ENDMARGINPAR
As described above, addressing in TCP/IP networking revolves around
32 bit numbers\&. However, you will have a hard time remembering more than
a few of these\&. Therefore, hosts are generally known by ``ordinary''
names such as \fBgauss\fR or \fBstrange\fR\&. It is then the
application's duty to find the IP address corresponding to this name\&.
This process is called \fIhost name resolution\fR\&.
.P 1
An application that wants to find the IP address of a given host name
does not have to provide its own routines for looking up a hosts and
IP adresses\&. Instead, it relies on number of library functions that do
this transparently, called \fIgethostbyname(3)\fR and
\fIgethostbyaddr(3)\fR\&. Traditionally, these and a number of related
procedures were grouped in a separate library called the resolver
library; on Linux, these are part of the standard \fIlibc\fR\&.
Colloquially, this collection of functions are therefore referred to as
``the resolver''\&.
.P 1
Now, on a small network like an Ethernet, or even a cluster of them, it
is not very difficult to maintain tables mapping host names to
addresses\&.  This information is usually kept in a file named
\fI/etc/hosts\fR\&.  When adding or removing hosts, or reassigning
addresses, all you have to do is update the \fIhosts\fR on all hosts\&.
Quite obviously, this will become burdensome with networks than comprise
more than a handful of machines\&.
.P 1
One solution to this problem is NIS, the \fINetwork Information
System\fR developed by Sun Microsystems, colloquially called YP, or
\fIYellow Pages\fR\&. NIS stores the \fIhosts\fR file (and other
information) in a database on a master host, from which clients may
retrieve it as needed\&. Still, this approach is only suitable for
medium-sized networks such as LANs, because it involves maintaining
the entire \fIhosts\fR database centrally, and distributing it to all
servers\&.
.P 1
On the Internet, address information was initially stored in a single
\fIHOSTS\&.TXT\fR database, too\&. This file was maintained at the Network
Information Center, or NIC, and had to be downloaded and installed by
all participating sites\&. When the network grew, several problems with
this scheme arose\&. Beside the administrative overhead involved in
installing \fIHOSTS\&.TXT\fR regularly, the load on the servers that
distributed it became too high\&. Even more severe was the problem that
all names had to be registered with the NIC, which had to make sure that
no name was issued twice\&.
.P 1
This is why, in 1984, a new name resolution scheme has been adopted, 
the \fIDomain Name System\fR\&. DNS was designed by Paul Mockapetris,
and addresses both problems simultaneously\&.
.P 1
.H 3 "Enter DNS"
.SETR "tcpip.dns.bind"
.INDEX {name space (DNS)}
.INDEX {hostname!fully qualified}
.INDEX {hostname!and domain name}
.INDEX {domain name|(}
.P 1
DNS organizes host names in a hierarchy of domains\&.  A domain is a
collection of sites that are related in some sense --- be it because
they form a proper network (e\&.g\&. all machines on a campus, or all hosts
on BITNET), because they all belong to a certain organization (like the
U\&.S\&. government), or because they're simply geographically close\&. For
instance, universities are grouped in the \fBedu\fR domain, with each
University or College using a separate \fIsubdomain\fR below which
their hosts are subsumed\&. Groucho Marx University might be given the
\fBgroucho\&.edu\fR domain, with the LAN of the Mathematics Department
being assigned \fBmaths\&.groucho\&.edu\fR\&.  Hosts on the departmental
network would have this domain name tacked onto their host name; so
\fBerdos\fR would be known as \fBerdos\&.maths\&.groucho\&.edu\fR\&.  This is
called the \fIfully qualified domain name\fR, or FQDN, which uniquely
identifies this host world-wide\&.
.P 1
\"
.DF I F 5
.so dns.ascii
\"
\"
.br
.FG " A part of the domain name space " "" 0 "intro.fig.dns"
.DE
.P 1
Figure 
.GETHN "intro.fig.dns"
\& shows a section of the name space\&.  The entry
at the root of this tree, which is denoted by a single dot, is quite
appropriately called the \fIroot domain\fR, and encompasses all other
domains\&. To indicate that a host name is a fully qualified domain name,
rather than a name relative to some (implicit) local domain, it is
sometimes written with a trailing dot\&. This signifies that the name's
last component is the root domain\&.
.P 1
.INDEX {domains!top-level}
Depending on its location in the name hierarchy, a domain may be
called top-level, second-level, or third-level\&. More levels of
subdivision occur, but are rare\&. These are a couple of top-level
domains you may see frequently:
.P 1
.SP 2
\"
.BL 10
.LI "\fBedu\fR"
(Mostly US) educational institutions like universities, etc\&.
.P 1
.LI "\fBcom\fR"
Commercial organizations, companies\&.
.P 1
.LI "\fBorg\fR"
Non-commercial organizations\&. Often private UUCP networks
are in this domain\&.
.P 1
.LI "\fBnet\fR"
Gateways and other administrative host on a network\&.
.P 1
.LI "\fBmil\fR"
US military institutions\&.
.P 1
.LI "\fBgov\fR"
US government institutions\&.
.P 1
.LI "\fBuucp\fR"
Officially, all site names formerly used as UUCP names
without domain, have been moved to this domain\&.
.P 1
\"
.LE
.P 1
Technically, the first four of these belong to the US part of the
Internet, but you may also see non-US sites in these domains\&. This is
especially true of the \fBnet\fR domain\&.  However, \fBmil\fR
and \fBgov\fR are used exclusively in the US\&.
.P 1
Outside the US, each country generally uses a top-level domain of its
own named after the two-letter country code defined in ISO-3166\&.
Finland, for instance, uses the \fBfi\fR domain, \fBfr\fR is used by
France, \fBde\fR by Germany, or \fBau\fR by Australia etc\&.  Below
this top-level domain, each country's NIC is free to organize host
names in whatever way they want\&. Australia, for example, has
second-level domain similar to the international top-level domains,
named \fBcom\&.au\fR, \fBedu\&.au\fR, and so on\&.  Others, like Germany,
don't use this extra level, but rather have slightly longish names that
refer directly to the organizations running a particular domain\&. For
example, it's not uncommon to see host names like
\fBftp\&.informatik\&.uni-erlangen\&.de\fR\&. Chalk that up to German
efficiency\&.
.P 1
Of course, these national domains do not imply that a host below that
domain is actually located in that country; it only signals that the
host has been registered with that country's NIC\&. A Swedish manufacturer
might have a branch in Australia, and still have all its hosts
registered with the \fBse\fR top-level domain\&.
.P 1
Now, organizing the name space in a hierarchy of domain names nicely
solves the problem of name uniqueness; with DNS, a host name has to be
unique only within its domain to give it a name different from all
other hosts world-wide\&. Furthermore, fully qualified names are quite
easy to remember\&.  Taken by themselves, these are already very good
resaons to split up a large domain into several subdomains\&.
.P 1
.INDEX {delegating!DNS subdomains}
.INDEX {creating!subdomains}
.INDEX {subdomain (DNS)}
But DNS does even more for you than than this: it allows you to delegate
authority over a subdomain to its administrators\&.  For example, the
maintainers at the Groucho Computing Center might create a subdomain for
each department; we already encountered the \fBmaths\fR and
\fBphysics\fR subdomains above\&.  When they find the network at the
Physics Department too large and chaotic to manage from outside (after
all, physicists are known to be an unruly bunch of people), they may
simply pass control over the \fBphysics\&.groucho\&.edu\fR domain to the
administrators of this network\&.  These are then free to use whatever
host names they like, and assign them IP addresses from their network in
whatever fashion the like, without outside interference\&.
.P 1
.INDEX {DNS!zone}
.INDEX {zone, DNS|see DNS, zone}
To this end, the name space is split up into \fIzones\fR, each rooted
at a domain\&. Note the subtle difference between a zone and a domain:
the \fIdomain\fR \fBgroucho\&.edu\fR encompasses all hosts at the
Groucho Marx University, while the \fIzone\fR \fBgroucho\&.edu\fR
includes only the hosts that are managed by the Computing Center
directly, for example those at the Mathematics Department\&.  The hosts
at the Physics Department belong to a different zone, namely
\fBphysics\&.groucho\&.edu\fR\&.  In figure 
.GETHN "intro.fig.dns"
\&, the start
of a zone is marked by a small circle to the right of the domain name\&.
.P 1
.INDEX {domain name|)}
.P 1
.H 3 "Name Lookups with DNS"
.SETR "tcpip.dns.lookups"
.INDEX {hostname!lookup}
.INDEX {DNS!lookup}
.P 1
At first glance, all this domain and zone fuss seems to make name
resolution an awfully complicated business\&. After all, if no central
authority controls what names are assigned to which hosts, then how is a
humble application supposed to know?!
.P 1
Now comes the really ingenuous part about DNS\&. If you want to find
out the IP address of \fBerdos\fR, then, DNS says, go ask the people
that manage it, and they will tell you\&.
.P 1
.INDEX {name server|(}
In fact, DNS is a giant distributed database\&. It is implemented by means
of so-called name servers that supply information on a given domain or
set of domains\&. For each zone, there are at least two, at most a few,
name servers that hold all authoritative information on hosts in that
zone\&. To obtain the IP address of \fBerdos\fR, all you have to do is
contact the name server for the \fBgroucho\&.edu\fR zone, which will then
return the desired data\&.
.P 1
.INDEX {DNS!query}
.INDEX {DNS!zone}
Easier said than done, you might think\&. So how do I know how to reach
the name server at Groucho Marx University? In case your computer isn't
equipped with an address-resolving oracle, DNS provides for this, too\&.
When your application wants to look up information on \fBerdos\fR, it
contacts a local name server, which conducts a so-called iterative query
for it\&.  It starts off by sending a query to a name server for the root
domain, asking for the address of \fBerdos\&.maths\&.groucho\&.edu\fR\&. The root
name server recognizes that this name does not belong to its zone of
authority, but rather to one below the \fBedu\fR domain\&. Thus, it tells
you to contact an \fBedu\fR zone name server for more information, and
encloses a list of all \fBedu\fR name servers along with their addresses\&.
Your local name server will then go on and query one of those, for instance
\fBa\&.isi\&.edu\fR\&.  In a manner similar to the root name server,
\fBa\&.isi\&.edu\fR knows that the \fBgroucho\&.edu\fR people run a zone of
their own, and point you to their servers\&. The local name server will then
present its query for \fBerdos\fR to one of these, which will finally
recognize the name as belonging to its zone, and return the corresponding
IP address\&.
.P 1
Now, this looks like a lot of traffic being generated for looking up a
measly IP address, but it's really only miniscule compared to the amount
of data that would have to be transferred if we were still stuck with
\fIHOSTS\&.TXT\fR\&. But there's still room for improvement with this
scheme\&.
.P 1
To improve response time during future queries, the name server will
store the information obtained in its local \fIcache\fR\&.  So the next
time anyone on your local network wants to look up the address of a
host in the \fBgroucho\&.edu\fR domain, your name server will not have
to go through the whole process again, but will rather go to the
\fBgroucho\&.edu\fR name server directly\&.(\*F)
.FS
If it didn't, then DNS would be about as bad as any other method,
because each query would involve the root name servers\&.
.FE
.P 1
.INDEX {DNS!time to live}
.INDEX {DNS!ttl|see DNS, time to live}
Of course, the name server will not keep this information forever, but
rather discard it after some period\&. This expiry interval is called the
\fItime to live\fR, or TTL\&. Each datum in the DNS database is assigned
such a TTL by administrators of the responsible zone\&.
.P 1
.H 3 "Domain Name Servers"
.SETR "tcpip.dns.servers"
.INDEX {authoritative name server}
.INDEX {name server!authoritative}
.INDEX {DNS!zone}
.P 1
Name servers that hold all information on hosts within a zone are
called \fIauthoritative\fR for this zone, and are sometimes referred
to as \fImaster name servers\fR\&. Any query for a host within this
zone will finally wind down at one of these master name servers\&.
.P 1
.INDEX {synchronizing name servers}
.INDEX {name server!synchronizing}
.INDEX {name server!secondary}
.INDEX {name server!primary}
To provide a coherent picture of a zone, its master servers must be
fairly well synchronized\&. This is achieved by making one of them the
\fIprimary\fR server, which loads its zone information from data
files, and making the others \fIsecondary\fR servers who transfer the
zone data from the primary server at regular intervals\&.
.P 1
One reason to have several name servers is to distribute work load,
another is redundance\&. When one name server machine fails in a benign
way, like crashing or losing its network connection, all queries will
fall back to the other servers\&. Of course, this scheme doesn't protect
you from server malfunctions that produce wrong replies to all DNS
requests, e\&.g\&. from software bugs in the server program itself\&.
.P 1
.INDEX {name server!caching-only}
Of course, you can also think of running a name server that is not
authoritative for any domain\&.(\*F)
.FS
Well, almost\&. A name server at least has to provide name service
for \fBlocalhost\fR and reverse lookups of \fB127\&.0\&.0\&.1\fR\&.
.FE
This type of server is useful nevertheless, as it is still able to
conduct DNS queries for the applications running on the local network,
and cache the information\&. It is therefore called a \fIcaching-only\fR
server\&.
.P 1
.INDEX {name server|)}
.P 1
.H 3 "The DNS Database"
.SETR "tcpip.dns.records"
.INDEX {DNS!database}
.P 1
We have seen above that DNS does not only deal with IP addresses of
hosts, but also exchanges information on name servers\&.  There are in
fact a whole bunch of different types of entries the DNS database may
have\&.
.P 1
.INDEX {DNS!resource record}
.INDEX {DNS!RR|see DNS, resource record}
.INDEX {resource record|see DNS, resource record}
.INDEX {RR|see DNS, resource record}
A single piece of information from the DNS database is called a
\fIresource record\fR, or RR for short\&. Each record has a type
associated with it, describing the sort of data it represents, and a
class specifying the type of network it applies to\&. The latter
accomodates the needs of different addressing schemes, like
IP addresses (the IN class), or addresses of Hesiod networks (used at
MIT), and a few more\&.  The prototypical resource record type is the A
record which associates a fully qualified domain name with an
IP address\&.
.P 1
.INDEX {canonical hostname}
.INDEX {hostname!canonical}
.INDEX {alias!hostname}
Of course, a host may have more than one name\&. However, one of these
names must be identified as the official, or \fIcanonical host name\fR,
while the others are simply aliases referring to the former\&. The
difference is that the canocical host name is the one with an A record
associated, while the others only have a record of type CNAME which
points to the canonical host name\&.
.P 1
We will not go through all record types here, but save them for a later
chapter, but rather give you a brief example here\&.
Figure 
.GETHN "intro.fig.hosts"
\& shows a part of the domain database that is
loaded into the name servers for the \fBphysics\&.groucho\&.edu\fR zone\&.
.P 1
\"
.DF I F 5
\"
.VERBATIM
 ;
 ; Authoritative Information on physics.groucho.edu
 @                     IN    SOA          {
                      niels.physics.groucho.edu.
                      hostmaster.niels.physics.groucho.edu.
                      1034             ; serial no
                      360000           ; refresh
                      3600             ; retry
                      3600000          ; expire
                      3600             ; default ttl
                    }
 ;
 ; Name servers
                       IN    NS       niels
                       IN    NS       gauss.maths.groucho.edu.
 gauss.maths.groucho.edu. IN A        149.76.4.23
 ;
 ; Theoretical Physics (subnet 12)
 niels                 IN    A        149.76.12.1
                       IN    A        149.76.1.12
 nameserver            IN    CNAME    niels
 otto                  IN    A        149.76.12.2
 quark                 IN    A        149.76.12.4
 down                  IN    A        149.76.12.5
 strange               IN    A        149.76.12.6
 ...
 ; Collider Lab. (subnet 14)
 boson                 IN    A        149.76.14.1
 muon                  IN    A        149.76.14.7
 bogon                 IN    A        149.76.14.12
 ...
.ENDVERBATIM
\"
\"
.br
.FG " An excerpt from the \fInamed\&\&.hosts\fR file for the Physics Department\&\&. " "" 0 "intro.fig.hosts"
.DE
.P 1
.INDEX {SOA (DNS record)}
.INDEX {DNS!zone}
.INDEX {authoritative name server}
.INDEX {name server!authoritative}
.INDEX {Start of Authority}
Apart from A and CNAME records, you can see a special record at the top
of the file, stretching several lines\&. This is the SOA resource record,
signalling the \fIStart of Authority\fR, which holds general information
on the zone the server is authoritative for\&. This comprises, for
instance, the default time-to-live for all records\&.
.P 1
Note that all names in the sample file that do not end with a dot should
be interpreted relative to the \fBgroucho\&.edu\fR domain\&.  The special
name ``\fB@\fR'' used in the SOA record refers to the domain name by
itself\&.
.P 1
We have seen above that the name servers for the \fBgroucho\&.edu\fR
domain somehow have to know about the \fBphysics\fR zone so that they
can point queries to their name servers\&. This is usually achieved by a
pair of records: the NS record that gives the server's FQDN, and
an A record associating an address with that name\&. Since these records
are what holds the name space together, they are frequently called the
\fIglue records\fR\&.  They are the only instances of records where a
parent zone actually holds information on hosts in the subordinate zone\&.
The glue records pointing to the name servers for
\fBphysics\&.groucho\&.edu\fR are shown in figure 
.GETHN "intro.fig.nsptr"
\&\&.
.P 1
\"
.DF I F 5
\"
.VERBATIM
 ;
 ; Zone data for the groucho.edu zone.
 @                   IN       SOA          {
                      vax12.gcc.groucho.edu.
                      hostmaster.vax12.gcc.groucho.edu.
                      233              ; serial no
                      360000           ; refresh
                      3600             ; retry
                      3600000          ; expire
                      3600             ; default ttl
                    }
 ....
 ;
 ; Glue records for the physics.groucho.edu zone
 physics             IN     NS        niels.physics.groucho.edu.
                     IN     NS        gauss.maths.groucho.edu.
 niels.physics       IN     A         149.76.12.1
 gauss.maths         IN     A         149.76.4.23
 ...
.ENDVERBATIM
\"
\"
.br
.FG " An excerpt from the \fInamed\&\&.hosts\fR file for GMU\&\&. " "" 0 "intro.fig.nsptr"
.DE
.P 1
.H 3 "Reverse Lookups"
.SETR "tcpip.dns.in-addr"
.INDEX {DNS!reverse mapping|(}
.INDEX {reverse mapping|(}
.INDEX {looking up addresses}
.INDEX {address!mapping to hostnames}
.INDEX {hostname!obtaining from address}
.INDEX {IP!address!and hostname}
.INDEX {in-addr\&.arpa domain@\fBin-addr\&.arpa\fR domain}
.INDEX {IP!network}
.P 1
Beside looking up the IP address belonging to a host, it is sometimes
desirable to find out the canonical host name corresponding to an
address\&.  This is called \fIreverse mapping\fR and is used by several
network services to verify a client's identity\&. When using a single
\fIhosts\fR file, reverse lookups simply involve searching the file for
a host that owns the IP address in question\&. With DNS, an exhaustive
search of the name space is out of the question, of course\&.  Instead, a
special domain, \fBin-addr\&.arpa\fR, has been created which contains the
IP addresses of all hosts in a reverted dotted-quad notation\&. For
instance, an IP address of \fB149\&.76\&.12\&.4\fR corresponds to the name
\fB4\&.12\&.76\&.149\&.in-addr\&.arpa\fR\&. The resource record type linking these
names to their canonical host names is PTR\&.
.P 1
.INDEX {DNS!zone}
.INDEX {authoritative name server}
.INDEX {name server!authoritative}
.INDEX {delegating!DNS subdomains}
.INDEX {creating!subnets}
.INDEX {IP!subnet}
.INDEX {subdomain (DNS)}
Creating a zone of authority usually means that its administrators are
given full control over how they assign addresses to names\&.  Since they
usually have one or more IP networks or subnets at their hands, there's
a one-to-many mapping between DNS zones and IP networks\&. The Physics
Department, for instance, comprises the subnets \fB149\&.76\&.8\&.0\fR,
\fB149\&.76\&.12\&.0\fR, and \fB149\&.76\&.14\&.0\fR\&.
.P 1
As a consequence, new zones in the \fBin-addr\&.arpa\fR domain have to be
created along with the \fBphysics\fR zone and delegated to the network
administrators at the department: \fB8\&.76\&.149\&.in-addr\&.arpa\fR,
\fB12\&.76\&.149\&.in-addr\&.arpa\fR,  and \fB14\&.76\&.149\&.in-addr\&.arpa\fR\&.
Otherwise, installing a new host at the Collider Lab would require them
to contact their parent domain to have the new address entered into
their \fBin-addr\&.arpa\fR zone file\&.
.P 1
The zone database for subnet 12 is shown in figure 
.GETHN "intro.fig.subnet12"
\&\&.
The corresponding glue records in the database of their parent zone is
shown in figure 
.GETHN "intro.fig.groucho-rev"
\&\&.
.P 1
\"
.DF I F 5
\"
.VERBATIM
 ;
 ; the 12.76.149.in-addr.arpa domain.
 @                IN     SOA   {
                      niels.physics.groucho.edu.
                      hostmaster.niels.physics.groucho.edu.
                      233 360000 3600 3600000 3600
                    }
 2                IN     PTR       otto.physics.groucho.edu.
 4                IN     PTR       quark.physics.groucho.edu.
 5                IN     PTR       down.physics.groucho.edu.
 6                IN     PTR       strange.physics.groucho.edu.
.ENDVERBATIM
\"
\"
.br
.FG " An excerpt from the \fInamed\&\&.rev\fR file for subnet 12\&\&. " "" 0 "intro.fig.subnet12"
.DE
.P 1
\"
.DF I F 5
\"
.VERBATIM
 ;
 ; the 76.149.in-addr.arpa domain.
 @                   IN       SOA          {
                      vax12.gcc.groucho.edu.
                      hostmaster.vax12.gcc.groucho.edu.
                      233 360000 3600 3600000 3600
                    }
 ...
 ; subnet 4: Mathematics Dept.
 1.4              IN     PTR      sophus.maths.groucho.edu.
 17.4             IN     PTR      erdos.maths.groucho.edu.
 23.4             IN     PTR      gauss.maths.groucho.edu.
 ...
 ; subnet 12: Physics Dept, separate zone
 12               IN     NS       niels.physics.groucho.edu.
                  IN     NS       gauss.maths.groucho.edu.
 niels.physics.groucho.edu. IN  A 149.76.12.1
 gauss.maths.groucho.edu. IN  A   149.76.4.23
 ...
.ENDVERBATIM
\"
\"
.br
.FG " An excerpt from the \fInamed\&\&.rev\fR file for network \fB149\&\&.76\fR\&\&. " "" 0 "intro.fig.groucho-rev"
.DE
.P 1
.INDEX {creating!DNS zones}
.INDEX {DNS!creating zones}
One important consequence of this is that zones can only be created as
supersets of IP networks, and, even more severe, that these network's
netmasks have to be on byte boundaries\&. All subnets at Groucho Marx
University have a netmask of \fB255\&.255\&.255\&.0\fR, whence an
\fBin-addr\&.arpa\fR zone could be created for each subnet\&. However, if
the netmask was \fB255\&.255\&.255\&.128\fR instead, creating zones for the
subnet \fB149\&.76\&.12\&.128\fR would be impossible, because there's no
way to tell DNS that the \fB12\&.76\&.149\&.in-addr\&.arpa\fR domain has been
split in two zones of authority, with host names ranging from \fB1\fR
through \fB127\fR, and \fB128\fR through \fB255\fR, respectively\&.
.P 1
.INDEX {DNS!reverse mapping|)}
.INDEX {reverse mapping|)}
.INDEX {DNS|)}
.P 1
.H 1 "Configuring the Networking Hardware"
.SETR "hardware"
.INDEX {configuring!network hardware|(}
.INDEX {hardware!networking|(}
.P 1
.H 2 "Devices, Drivers, and all that"
.SETR "hardware.drivers"
.INDEX {network!devices}
.INDEX {interface}
.P 1
Up to now, we've been talking quite a bit about network interfaces and
general TCP/IP issues, but didn't really cover exactly \fIwhat\fR
happens when ``the networking code'' in the kernel accesses a piece of
hardware\&.  For this, we have to talk a little about the concept of
interfaces and drivers\&.
.P 1
First, of course, there's the hardware itself, for example an Ethernet
board: this is a slice of Epoxy, cluttered with lots of tiny chips
with silly numbers on them, sitting in a slot of your PC\&.  This is
what we generally call a device\&.
.P 1
For you to be able to use the Ethernet board, special functions have
to be present in your Linux kernel that understand the particular
way this device is accessed\&. These are the so-called device drivers\&.
For example, Linux has device drivers for several brands of
Ethernet boards that are very similar in function\&.  They are known as
the ``Becker Series Drivers'', named after their author, Donald
Becker\&. A different example is the D-Link driver that handles a D-Link
pocket adaptor attached to a parallel port\&.
.P 1
But, what do we mean when we say a driver ``handles'' a device?  Let's
go back to that Ethernet board we examined above\&. The driver has to be
able to communicate with the peripheral's on-board logic somehow: it
has to send commands and data to the board, while the board should
deliver any data received to the driver\&.
.P 1
In PCs, this communication takes place through an area of I/O memory
that is mapped to on-board registers and the like\&.  All commands and
data the kernel sends to the board have to go through these registers\&.
I/O memory is generally described by giving its starting or \fIbase
address\fR\&. Typical base addresses for Ethernet boards are \fB0x300\fR,
or \fB0x360\fR\&.
.P 1
Usually, you don't have to worry about any hardware issues such as the
base address, because the kernel makes an attempt at boot time to
detect a board's location\&. This is called autoprobing, which means
that the kernel reads several memory locations and compares the data
read with what it should see if a certain Ethernet board was
installed\&. However, there may be Ethernet boards it cannot detect
automatically; this is sometimes the case with cheap Ethernet cards
that are not-quite clones of standard boards from other manufacturers\&.
Also, the kernel will attempt to detect only one Ethernet device when
booting\&. If you're using more than one board, you have to tell the
kernel about this board explicitly\&.
.P 1
.INDEX {IRQ}
Another such parameter that you might have to tell the kernel about is
the interrupt request channel\&.  Hardware components usually interrupt
the kernel when they need care taken of them, e\&.g\&.  when data has
arrived, or a special condition occurs\&. In a PC, interrupts may occur on
one of 15 interrupt channels numbered 0, 1, and 3 through 15\&. The
interrupt number assigned to a hardware component is called its
\fIinterrupt request number\fR, or IRQ\&.(\*F)
.FS
IRQs 2 and 9 are the same because the PC has two cascaded interrupt
processors with eight IRQs each; the secondary processor is connected
to IRQ 2 of the primary one\&.
.FE
.P 1
.INDEX {IP!interface}
.INDEX {interface}
As described in chapter 
.GETHN "tcpip"
\&, the kernel accesses a device
through a so-called interface\&.  Interfaces offer an abstract set of
functions that is the same across all types of hardware, such as
sending or receiving a datagram\&.
.P 1
Interfaces are identified by means of names\&. These are names defined
internally in the kernel, and are not device files in the \fI/dev\fR
directory\&.  Typical names are \fIeth0\fR, \fIeth1\fR, etc, for
Ethernet interfaces\&. The assignment of interfaces to devices usually
depends on the order in which devices are configured; for instance the
first Ethernet board installed will become \fIeth0\fR, the next will
be \fIeth1\fR, and so on\&. One exception from this rule are SLIP
interfaces, which are assigned dynamically; that is, whenever a SLIP
connection is established, an interface is assigned to the serial
port\&.
.P 1
The picture given in figure 
.GETHN "hardware.fig.drivers"
\& tries to show
the relationship between the hardware, device drivers and interfaces\&.
.P 1
When booting, the kernel displays what devices it detects, and what
interfaces it installs\&. The following is an excerpt of a typical
boot screen:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 .
 .
This processor honours the WP bit even when in supervisor mode. Good.
Floppy drive(s): fd0 is 1.44M
Swansea University Computer Society NET3.010
IP Protocols: ICMP, UDP, TCP
PPP: version 0.2.1 (4 channels) OPTIMIZE_FLAGS
TCP compression code copyright 1989 Regents of the University of California
PPP line discipline registered.
SLIP: version 0.7.5 (4 channels)
CSLIP: code copyright 1989 Regents of the University of California
dl0: D-Link DE-600 pocket adapter, Ethernet Address: 00:80:C8:71:76:95
Checking 386/387 coupling... Ok, fpu using exception 16 error reporting.
Linux version 1.1.11 (okir@monad) #3 Sat May 7 14:57:18 MET DST 1994
.ENDVERBATIM
\"
\fR
.DE
.P 1
This shows that the kernel has been compiled with TCP/IP enabled, and
drivers for SLIP, CSLIP, and PPP included\&.  The third line from below says
that a D-Link pocket adaptor was detected, and installed as interface
\fIdl0\fR\&.  If you have a different type of Ethernet card, the kernel will
usually print a line starting with \fIeth0\fR, followed by the type of
card detected\&.  If you have an Ethernet card installed but don't see any
such message, this means that the kernel is unable to detect your board
properly\&.  This is dealt with in a later section\&.
.P 1
.H 2 "Kernel Configuration"
.P 1
Most Linux distributions come along with boot disks that
work for all common types of PC hardware\&.  This means that the kernel
on those disks has all sorts of drivers configured in that you will
never need, but which waste precious system memory because parts
of the kernel cannot be swapped out\&. Therefore, you will generally
roll your own kernel, including only those drivers you actually need or
want\&.
.P 1
When running a Linux system, you should be familiar with building a
kernel\&. The basics of this are explained in Matt Welsh's ``Installation and
Getting Started'' Guide, which is also part of the Linux Documentation
Project's series\&.  In this section, we will therefore discuss only those
configuration options that affect networking\&.
.P 1
When running \fBmake config\fR, you will first be asked general
configurations, for instance whether you want kernel math emulation or
not, etc\&. One of these asks you whether you want TCP/IP networking
support\&. You must answer this with \fBy\fR to get a kernel capable of
networking\&.
.P 1
.H 3 "Kernel Options in Linux 1\&.0 and Higher"
.INDEX {configuring!kernel}
.INDEX {network!kernel options}
.INDEX {kernel network configuration}
.INDEX {configuring!Ethernet}
.INDEX {configuring!SLIP}
.INDEX {configuring!PLIP}
.INDEX {configuring!PPP}
.P 1
After the general option part is complete, the configuration will go
on to ask you for various features such as SCSI drivers, etc\&. The
subsequent list questions deal with networking support\&. The exact set
of configuration options is in constant flux because of the ongoing
development\&. A typical list of options offered by most kernel versions
around 1\&.0 and 1\&.1 looks like this (comments are given in italics):
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
*
* Network device support
*
Network device support? (CONFIG_ETHERCARDS) [y]
.ENDVERBATIM
\"
\fR
.DE
.P 1
Despite the macro name displayed in brackets, you must
answer this question with \fBy\fR if you want to use \fIany\fR
type of networking devices, regardless of whether this is
Ethernet, SLIP, or PPP\&.  When answering this question with
\fBy\fR, support for Ethernet-type devices is enabled
automatically\&.  Support for other types of network drivers
must be enabled separately:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
SLIP (serial line) support? (CONFIG_SLIP) [y]
 SLIP compressed headers (SL_COMPRESSED) [y]
PPP (point-to-point) support (CONFIG_PPP) [y]
PLIP (parallel port) support (CONFIG_PLIP) [n]
.ENDVERBATIM
\"
\fR
.DE
.P 1
These questions concern the various link layer protocols
supported by Linux\&.  SLIP allows you to transport IP
datagrams across serial lines\&.  The compressed header option
provides support for CSLIP, a technique that compresses
TCP/IP headers to as little as three bytes\&.  Note that this
kernel option does not turn on CSLIP automatically, it
merely provides the necessary kernel functions for it\&.
.P 1
PPP is another protocol to send network traffic across
serial lines\&.  It is much more flexible than SLIP, and is
not limited to IP, but will also support IPX once it is
implemented\&.  As PPP support has been completed only lately,
this option may not be present in your kernel\&.
.P 1
PLIP provides for a way to send IP datagrams across a
parallel port connection\&.  It is mostly used to communicate
with PCs running DOS\&.
.P 1
The following questions deal with Ethernet boards from
various vendors\&.  As more drivers are being developed,
you are likely to see questions added to this section\&.
If you want to build a kernel you can use on a number of
different machines, you can enable more than one driver\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
NE2000/NE1000 support (CONFIG_NE2000) [y]
WD80*3 support (CONFIG_WD80x3) [n]
SMC Ultra support (CONFIG_ULTRA) [n]
3c501 support (CONFIG_EL1) [n]
3c503 support (CONFIG_EL2) [n]
3c509/3c579 support (CONFIG_EL3) [n]
HP PCLAN support (CONFIG_HPLAN) [n]
AT1500 and NE2100 (LANCE and PCnet-ISA) support (CONFIG_LANCE) [n]
AT1700 support (CONFIG_AT1700) [n]
DEPCA support (CONFIG_DEPCA) [n]
D-Link DE600 pocket adaptor support (CONFIG_DE600) [y]
AT-LAN-TEC/RealTek pocket adaptor support (CONFIG_ATP) [n]
*
* CD-ROM drivers
*
 ...
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {configuring!NFS}
Finally, in the filesystem section, the configuration script
will ask you whether you want support for NFS, the
networking filesystem\&.  NFS lets you export filesystems
to several hosts, which makes the files appear as if they
were on an ordinary hard disk attached to the host\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
NFS filesystem support (CONFIG_NFS_FS) [y]
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "Kernel Options in Linux 1\&.1\&.14 and Higher"
.P 1
Starting with Linux 1\&.1\&.14, which added alpha support for IPX,
the configuration procedure changed slightly\&. The general options section
now asks whether you want networking support in general\&. It is
immediately followed by a couple of question on miscellaneous
networking options\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
*
* Networking options
*
TCP/IP networking (CONFIG_INET) [y]
.ENDVERBATIM
\"
\fR
.DE
.P 1
To use TCP/IP networking, you must answer this question with
\fBy\fR\&. If you answer with \fBn\fR, however, you will still
be able to compile the kernel with IPX support\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
IP forwarding/gatewaying (CONFIG_IP_FORWARD) [n]
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {forwarding!IP}
.INDEX {IP!forwarding}
You have to enable this option if your system acts as a
gateway between two Ethernets, or between and Ethernet and a
SLIP link, etc\&.  Although it doesn't hurt to enable this by
default, you may want to disable this to configure a host as a
so-called firewall\&. Firewalls are hosts that are connected to
two or more networks, but don't route traffic between them\&.
They are commonly used to provide users from a company network
with Internet access at a minimal risk to the internal
network\&. Users will be allowed to log into the firewall and
use Internet services, but the company's machines will be
protected from outside attacks because any incoming
connections can't cross the firewall\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
*
* (it is safe to leave these untouched)
*
PC/TCP compatibility mode (CONFIG_INET_PCTCP) [n]
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {PC/TCP compatibility}
This option works around an incompatibility with some versions
of PC/TCP, a commercial TCP/IP implementation for DOS-based
PCs\&. If you enable this option, you will still be able to
communicate with normal Un*x machines, but performance may
be hurt over slow links\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
Reverse ARP (CONFIG_INET_RARP) [n]
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {RARP}
This function enables RARP, the Reverse Address Resolution
Protocol\&. RARP is used by diskless clients and X terminals to
inquire their IP address when booting\&.  You should enable RARP
only when you plan to serve this sort of clients\&.  The latest
package of network utilities (\fInet-0\&.32d\fR) contains a small
utility named \fIrarp\fR that allows you to add systems to the
RARP cache\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
Assume subnets are local (CONFIG_INET_SNARL) [y]
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {IP!routing}
.INDEX {IP!subnet}
.INDEX {subnet (IP)}
.INDEX {Subnets Are Local@`Subnets Are Local' Policy}
.INDEX {SNARL|see`Subnets Are Local' Policy}
When sending data over TCP, the kernel has to break up the
stream into several packets before giving it to IP\&. For hosts
that can be reached over a local network such as an Ethernet,
larger packets will be used than for hosts where data has to
go through long-distance links\&.(\*F)
.FS
This is to avoid fragmentation by links that have a very small
maximum packet size\&.
.FE
If you don't enable \fISNARL\fR, the kernel will assume
only those networks are local that it actually has an interface
to\&. However, if you look at the class B network at Groucho
Marx University, the whole class B network is local, but most
hosts interface to only one or two subnets\&. If you enable
\fISNARL\fR, the kernel will assume \fIall\fR subnets
are local and use large packets when talking to all hosts on
campus\&.
.P 1
If you do want to use smaller packet sizes for data sent to
specific hosts (because, for instance, the data goes through
a SLIP link), you can do so using the \fImtu\fR option of
\fIroute\fR, which is briefly discussed at the end of this
chapter\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
Disable NAGLE algorithm (normally enabled) (CONFIG_TCP_NAGLE_OFF) [n]
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {Nagle's algorithm}
.INDEX {avoid tinygrams}
.INDEX {IP!tinygrams}
.INDEX {tinygrams}
Nagle's rule is a heuristic to avoid sending particularly
small IP packets, also called tinygrams\&. Tinygrams are usually
created by interactive networking tools that transmit single
keystrokes, such as \fItelnet\fR or \fIrsh\fR\&. Tinygrams can
become particularly wasteful on low-bandwidth links like SLIP\&.
The Nagle algorithm attempts to avoid them by holding back
transmission of TCP data briefly under some circumstances\&. You
might only want to disable Nalge's algorithm if you have
severe problems with packets getting dropped\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
The IPX protocol (CONFIG_IPX) [n]
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {configuring!IPX}
.INDEX {protocol!IPX}
.INDEX {IPX}
This enables support for IPX, the transport protocol used by
Novell Networking\&. It is still under development, and isn't
really useful yet\&. One benefit of this will be that you can
exchange data with IPX-based DOS utilities one day, and route
traffic between your Novell-based networks through a PPP link\&.
Support for the high-level protocols of Novell
networking is however not in sight, as the specifications for
these are available only at horrendous cost and under a
non-disclosure agreement\&.
.P 1
Starting in the 1\&.1\&.16 kernel, Linux supports another
driver type, the dummy driver\&.  The following question appears
toward the start of the device driver section\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
Dummy net driver support (CONFIG_DUMMY) [y]
.ENDVERBATIM
\"
\fR
.DE
.P 1
The dummy driver doesn't really do much, but is quite useful 
on standalone or SLIP hosts\&.  It is basically a masqueraded
loopback interface\&. The reason to have this sort of interface
is that on hosts that do SLIP but have no Ethernet, you want to
have an interface that bears your IP address all the time\&.
This is discussed in a little more detail in
section 
.GETHN "iface.interface.dummy"
\& in chapter 
.GETHN "iface"
\&\&.
.P 1
.H 2 "A Tour of Linux Network Devices"
The Linux kernel supports a number of hardware drivers for various
types of equipment\&. This section gives a short overview of the driver
families available, and the interface names used for them\&.
.P 1
.INDEX {interface}
There are a number of standard names for interfaces in Linux, which
are listed below\&. Most drivers support more than one interface, in
which case the interfaces are numbered, as in \fIeth0\fR,
\fIeth1\fR, etc\&.
.P 1
\"
.BL 10
.LI "\fIlo\fR"
.INDEX {interface!loopback}
The local loopback interface\&. It is used for testing purposes,
as well as a couple of network applications\&. It works like a
closed circuit in that any datagram written to it will be
immediately returned to the host's networking layer\&.  There's
always one loopback device present in the kernel, and there's
little sense in having fewer or more\&.
.P 1
.LI "\fIeth\fB\fIn\fB\fI\fR"
.INDEX {interface!Ethernet}
The \fB\fIn\fB\fR-th Ethernet card\&. This is the generic interface name
for most Ethernet boards\&.
.P 1
.LI "\fIdl\fB\fIn\fB\fI\fR"
.INDEX {interface!D-Link DE-600}
These interfaces access a D-Link DE-600 pocket adapter, another
Ethernet device\&. It is a little special in that the DE-600
is driven through a parallel port\&.
.P 1
.LI "\fIsl\fB\fIn\fB\fI\fR"
.INDEX {interface!SLIP}
The \fB\fIn\fB\fR-th SLIP interface\&. SLIP interfaces are associated
with serial lines in the order in which they are allocated for
SLIP; i\&.e\&., the first serial line being configured for SLIP
becomes \fIsl0\fR, etc\&. The kernel supports up to four SLIP
interfaces\&.
.P 1
.LI "\fIppp\fB\fIn\fB\fI\fR"
.INDEX {interface!PPP}
The \fB\fIn\fB\fR-th PPP interface\&. Just like SLIP interfaces, a PPP
interface is associated with a serial line once it is converted
to PPP mode\&. At the moment, up to four interfaces are supported\&.
.P 1
.LI "\fIplip\fB\fIn\fB\fI\fR"
.INDEX {interface!PLIP}
The \fB\fIn\fB\fR-th PLIP interface\&. PLIP transports IP datagrams
over parallel lines\&. Up to three PLIP interfaces are supported\&.
They are allocated by the PLIP driver at system boot time, and
are mapped onto parallel ports\&.
.P 1
\"
.LE
.P 1
.INDEX {protocol!AX\&.25}
.INDEX {protocol!IPX}
.INDEX {driver!ISDN}
.INDEX {AX\&.25}
.INDEX {ISDN}
For other interface drivers that may be added in the future, like ISDN,
or AX\&.25, other names will be introduced\&. Drivers for IPX (Novell's
networking protocol), and AX\&.25 (used by ham radio amateurs) are under
development, but are at alpha stage still\&.
.P 1
During the following sections, we will discuss the details of using
the drivers described above\&.
.P 1
.H 2 "Ethernet Installation"
.SETR "hardware.drivers.ethernet"
.INDEX {configuring!Ethernet|(}
.INDEX {Ethernet!Becker drivers}
.INDEX {Ethernet!installation}
.INDEX {Becker, Donald}
.INDEX {driver!Ethernet}
.INDEX {Ekwall, Bjorn@Ekwall, Bj\C'/o'rn}
.INDEX {Davies, David C\&.}
.INDEX {Ethernet!through parallel port}
.INDEX {parallel port!Ethernet}
.INDEX {D-Link pocket adaptor}
.INDEX {driver!Ethernet}
.INDEX {driver!D-Link}
.P 1
The current Linux network code supports various brands of Ethernet
cards\&. Most drivers were written by Donald Becker
(\fBbecker@super\&.org\fR), who authored a family of drivers for cards
based on the National Semiconductor 8390 chip; these have become known
as the Becker Series Drivers\&.  There are also drivers for a couple of
products from D-Link, among them the D-Link pocket adaptor that allows
you to access an Ethernet through a parallel port\&. The driver for this
was written by Bj\C'/o'rn Ekwall (\fBbj0rn@blox\&.se\fR)\&. The DEPCA
driver was written by David C\&. Davies
(\fBdavies@wanton\&.lkg\&.dec\&.com\fR)\&.
.P 1
.H 3 "Ethernet Cabling"
.INDEX {Ethernet!cabling}
.INDEX {Ethernet!thin}
.INDEX {BNC connector}
.INDEX {thinnet}
.P 1
If you're installing an Ethernet for the first time in your life, a few
words about the cabling may be in order here\&. Ethernet is very picky
about proper cabling\&. The cable must be terminated on both ends with a
50 Ohm resistor, and you must not have any branches (i\&.e\&. three cables
connected in a star-shape)\&. If you are using a thin coax cable with
T-shaped BNC junctions, these junctions must be twisted on the board's
connector directly; you should not insert a cable segment\&.
.P 1
If you connect to a thicknet installation, you have to attach your
host through a transceiver (sometimes called Ethernet Attachment
Unit)\&.  You can plug the transceiver into the 25-pin AUI port on your
board directly, but may also use a shielded cable\&.
.P 1
.H 3 "Supported Boards"
.INDEX {HOWTO!Ethernet}
.INDEX {Gortmaker, Paul}
A complete list of supported boards is available in
the Ethernet HOWTOs posted monthly to \fBcomp\&.os\&.linux\&.announce\fR
by Paul Gortmaker\&.(\*F)
.FS
Paul can be reached at \fBgpg109@rsphysse\&.anu\&.edu\&.au\fR\&.
.FE
.P 1
Here's a list of the more widely-known boards supported by Linux\&. The
actual list in the HOWTO is about three times longer\&. However, even if
you find your board in this list, check the HOWTO first; there are
sometimes important details about operating these cards\&. A case in point
is the case of some DMA-based Ethernet boards that use the same DMA
channel as the Adaptec 1542 SCSI controller by default\&. Unless you move
either of them to a different DMA channel, you will wind up with the 
Ethernet board writing packet data to arbitrary locations on your hard
disk\&.
.P 1
\"
.BL 10
.LI "3Com EtherLink"
Both 3c503 and 3c503/16 are supported, as are 3c507 and 3c509\&.
The 3c501 is supported, too, but is too slow to be worth buying\&.
.P 1
.LI "Novell Eagle"
NE1000 and NE2000, and a variety of clones\&. NE1500 and NE2100
are supported, too\&.
.P 1
.LI "Western Digital/SMC"
WD8003 and WD8013 (same as SMC Elite and SMC Elite Plus)
are supported, and also the newer SMC Elite 16 Ultra\&.
.P 1
.LI "Hewlett Packard"
HP 27252, HP 27247B, and HP J2405A\&.
.P 1
.LI "D-Link"
DE-600 pocket adaptor, DE-100, DE-200, and DE-220-T\&.
There's also a patch kit for the DE-650-T, which is a PCMCIA
card\&.(\*F)
.FS
It can be gotten -- along with other Laptop-related stuff --
from \fBtsx-11\&.mit\&.edu\fR in \fIpackages/laptops\fR\&.
.FE
.P 1
.LI "DEC"
DE200 (32K/64K), DE202, DE100, and DEPCA rev E\&.
.P 1
.LI "Allied Teliesis"
AT1500 and AT1700\&.
.P 1
\"
.LE
.P 1
To use one of these cards with Linux, you may use a precompiled
kernel from one of the major Linux distributions\&. These generally
have drivers for all of them built in\&. In the long term, 
however, it's better to roll your own kernel and compile in only those
drivers you actually need\&.
.P 1
.H 3 "Ethernet Autoprobing"
.INDEX {Ethernet!autoprobing|(}
.INDEX {autoprobing, Ethernet}
.P 1
At boot time, the Ethernet code will try to locate your board and
determine its type\&. Cards are probed for at the following addresses and
in the following order:
.P 1
.SP 2
.br
.ad c
.ti 0		
.TS
box tab(&);
| l | l |.
_
Board &Addresses probed for 
_
WD/SMC &\fB0x300\fR, \fB0x280\fR, \fB0x380\fR, \fB0x240\fR 
SMC 16 Ultra &\fB0x300\fR, \fB0x280\fR 
3c501 &\fB0x280\fR 
3c503 &\fB0x300\fR, \fB0x310\fR, \fB0x330\fR, \fB0x350\fR, \fB0x250\fR, 
&\fB0x280\fR, \fB0x2a0\fR, \fB0x2e0\fR 
NEx000 &\fB0x300\fR, \fB0x280\fR, \fB0x320\fR, \fB0x340\fR, \fB0x360\fR 
HP &\fB0x300\fR, \fB0x320\fR, \fB0x340\fR, \fB0x280\fR, \fB0x2C0\fR, 
&\fB0x200\fR, \fB0x240\fR 
DEPCA &\fB0x300\fR, \fB0x320\fR, \fB0x340\fR, \fB0x360\fR 
_
.TE
.P 1
.ad b
.SP 2
.P 1
There are two limitations to the autoprobing code\&. For one, it may not
recognize all boards properly\&. This is especially true for some of the
cheaper clones of common boards, but also for some WD80x3 boards\&. The
second problem is that the kernel will not auto-probe for more than one
board at the moment\&. This is a feature, because it is assumed you want
to have control about which board is assigned which interface\&.
.P 1
If you are using more than one board, or if the autoprobe should fail to
detect your board, you have to tell the kernel explicitly about the
card's base address and name\&.
.P 1
.INDEX {configuring!Ethernet}
.INDEX {manual configuration (Ethernet)}
.INDEX {Space\&.c@\fISpace\&.c\fR}
.INDEX {autoprobing fails}
.INDEX {lilo@\fIlilo\fR}
In Net-3, you have can use two different schemes to accomplish this\&.
One way is to change or add information in the
\fIdrivers/net/Space\&.c\fR file in the kernel source code that
contains all information about drivers\&. This is recommended only if
you are familiar with the networking code\&. A much better way is to
provide the kernel with this information at boot time\&.  If you use
\fIlilo\fR to boot your system, you can pass parameters to the kernel
by specifying them through the \fIappend\fR option in
\fIlilo\&.conf\fR\&. To inform the kernel about an Ethernet device, you
can pass the following parameter:
.P 1
.P 1
.DS I F 5
\fBether=\fB\fIirq\fB\fB,\fB\fIbase_addr\fB\fB,\fB\fIparam1\fB\fB,\fB\fIparam2\fB\fB,\fB\fIname\fB\fB
\"
\fR
.DE
.P 1
The first four parameters are numerical, while the last is the device
name\&. All numerical values are optional; if they are omitted or set
to zero, the kernel will try to detect the value by probing for it, or
use a default value\&.
.P 1
.INDEX {auto-IRQ}
.INDEX {IRQ}
The first parameter sets the IRQ assigned to the device\&. By default,
the kernel will try to auto-detect the device's IRQ channel\&. The
3c503 driver has a special feature that selects a free IRQ from the
list 5, 9, 3, 4, and configures the board to use this line\&.
.P 1
The \fB\fIbase_addr\fB\fR parameter gives the I/O base address of the board;
a value of zero tells the kernel to probe the addresses listed above\&.
.P 1
The remaining two parameters may be used differently by different
drivers\&. For shared-memory boards such as the WD80x3, they specify
start and end addresses of the shared memory area\&. Other cards commonly
use \fB\fIparam1\fB\fR to set the level of debugging information that is
being displayed\&. Values of 1 through 7 denote increasing levels of
verbosity, while 8 turns them off altogether; 0 denotes the default\&.
The 3c503 driver uses \fB\fIparam2\fB\fR to select the internal transceiver
(default) or an external transceiver (a value of 1)\&. The former uses
the board's BNC connector; the latter uses its AUI port\&.
.P 1
If you have two Ethernet boards, you can have Linux autodetect one
board, and pass the second board's parameters with \fIlilo\fR\&.
However, you must make sure the driver doesn't accidentally find the
second board first, else the other one won't be registered at all\&. You
do this by passing \fIlilo\fR a \fBreserve\fR option, which
explicitly tells the kernel to avoid probing the I/O space taken up by
the second board\&.
.P 1
For instance, to make Linux install a second Ethernet board at
\fB0x300\fR as \fIeth1\fR, you would pass the following parameters
to the kernel:
.P 1
.P 1
.DS I F 5
\fBreserve=\fB0x300\fB,32 ether=0,\fB0x300\fB,eth1
\"
\fR
.DE
.P 1
The \fIreserve\fR option makes sure no driver accesses the board's
I/O space when probing for some device\&. You may also use the kernel
parameters to override autoprobing for \fIeth0\fR:
.P 1
.P 1
.DS I F 5
\fBreserve=\fB0x340\fB,32 ether=0,\fB0x340\fB,eth0
\"
\fR
.DE
.P 1
To turn off autoprobing altogether, you can specify a \fB\fIbase_addr\fB\fR
argument of -1:
.P 1
.P 1
.DS I F 5
\fBether=0,-1,eth0
\"
\fR
.DE
.P 1
.INDEX {Ethernet!autoprobing|)}
.INDEX {configuring!Ethernet|)}
.P 1
.H 2 "The PLIP Driver"
.SETR "hardware.drivers.plip"
.INDEX {configuring!PLIP}
.INDEX {IP!parallel line|see PLIP}
.INDEX {parallel port!IP}
.INDEX {driver!PLIP}
.INDEX {PLIP}
.P 1
PLIP stands for \fIParallel Line IP\fR and is a cheap way to
network when you want to connect only two machines\&. It uses a
parallel port and a special cable, achieving speeds of 10kBps to
20kBps\&.
.P 1
PLIP was originally developed by Crynwr, Inc\&.  Its design is rather
ingenuous (or, if you prefer, hackish): for a long time, the parallel
ports on PCs used to be only uni-directional printer ports; that is,
the eight data lines could only be used to send from the PC to the
peripheral device, but not the other way round\&. PLIP works around
this by using the port's five status line for input, which limits it
to transferring all data as nibbles (half bytes) only\&. This mode of
operation is called mode zero PLIP\&.  Today, these uni-directional
ports don't seem to be used much anymore\&. Therefore, there is also a
PLIP extension called mode 1 that uses the full 8 bit interface\&.
.P 1
Currently, Linux only supports mode 0\&.  Unlike earlier versions of the
PLIP code, it now attempts to be compatible with the PLIP implementations
from Crynwr, as well as the PLIP driver in NCSA \fItelnet\fR\&.(\*F)
.FS
NCSA \fItelnet\fR is a popular program for DOS that runs TCP/IP
over Ethernet or PLIP, and supports \fItelnet\fR and FTP\&.
.FE
To connect two machines using PLIP, you need a special cable sold at
some shops as ``Null Printer'' or ``Turbo Laplink'' cable\&. You can,
however, make one yourself fairly easily\&. Appendix 
.GETHN "appendix.plip"
\&
shows you how\&.
.P 1
.INDEX {Yutaka, Niibe}
The PLIP driver for Linux is the work of almost countless persons\&.
It is currently maintained by Niibe Yutaka\&.  If compiled into the
kernel, it sets up a network interface for each of the possible
printer ports, with \fIplip0\fR corresponding to parallel port
\fIlp0\fR, \fIplip1\fR corresponding to \fIlp1\fR, etc\&.  The
mapping of interface to ports is currently this:
.P 1
.SP 2
.br
.ad c
.ti 0		
.TS
box tab(&);
| l | l | l |.
_
Interface &I/O Port &IRQ 
_
\fIplip0\fR &\fB0x3BC\fR &7 
\fIplip1\fR &\fB0x378\fR &7 
\fIplip2\fR &\fB0x278\fR &5 
_
.TE
.P 1
.ad b
.SP 2
.P 1
.INDEX {configuring!PLIP}
.INDEX {manual configuration (PLIP)}
.INDEX {Space\&.c@\fISpace\&.c\fR}
If you have configured your printer port in a different way, you
have to change these values in \fIdrivers/net/Space\&.c\fR in
the Linux kernel source, and build a new kernel\&.
.P 1
This mapping does not mean, however, that you cannot use these
parallel ports as usual\&. They are accessed by the PLIP driver only
when the corresponding interface is configured \fIup\fR\&.
.P 1
.H 2 "The SLIP and PPP Drivers"
.SETR "hardware.drivers.slip"
.INDEX {driver!SLIP}
.INDEX {driver!PPP}
.INDEX {SLIP}
.INDEX {IP!serial line|see SLIP}
.P 1
SLIP (Serial Line IP), and PPP (Point-to-Point Protocol) are a widely
used protocol for sending IP packets over a serial link\&. A number of
institutions offer dialup SLIP and PPP access to machines that are on
the Internet, thus providing IP connectivity to private persons
(something that's otherwise hardly affordable)\&.
.P 1
To run SLIP or PPP, no hardware modifications are necessary; you can use
any serial port\&. Since serial port configuration is not specific to
TCP/IP networking, a separate chapter has been devoted to this\&.  Please
refer to chapter 
.GETHN "serial"
\& for more information\&.
.P 1
.INDEX {configuring!network hardware|)}
.INDEX {hardware!networking|)}
.P 1
.H 1 "Setting up the Serial Hardware"
.SETR "serial"
.INDEX {hardware!serial|(}
.INDEX {device, serial|(}
.P 1
There are rumors that there are some people out there in netland who
only own one PC and don't have the money to spend on a T1 Internet link\&.
To get their daily dose of news and mail nevertheless, they are said to
rely on SLIP links, UUCP networks, and bulletin board systems (BBS's)
that utilize public telephone networks\&.
.P 1
.INDEX {Hankins, Greg}
.INDEX {HOWTO!Serial}
This chapter is intended to help all those people who rely on modems to
maintain their link\&. However, there are many details that this chapter
cannot go into, for instance how to configure your modem for dialin\&. All
these topics will be covered in the upcoming Serial HOWTO by Greg
Hankins,(\*F)
.FS
To be reached at \fBgregh@cc\&.gatech\&.edu\fR\&.
.FE
to be posted to \fBcomp\&.os\&.linux\&.announce\fR on a regular basis\&.
.P 1
.H 2 "Communication Software for Modem Links"
.SETR "serial.software"
.INDEX {terminal programs}
.INDEX {BBS}
.INDEX {bulletin board}
.P 1
There are a number of communication packages available for Linux\&. Many
of them are \fIterminal programs\fR which allow a user to dial into
another computer as if she was sitting in front of a simple terminal\&.
The traditional terminal program for Un*ces is \fIkermit\fR\&. It is,
however, somewhat Spartan\&. There are more comfortable programs
available that support a dictionary of telephone numers, script languages
for calling and logging into remote computer systems, etc\&. One of them
is \fIminicom\fR, which is close to some terminal programs former
DOS users might be accustomed to\&. There are also X-based communications
packages, e\&.g\&. \fIseyon\fR\&.
.P 1
Also, a number of Linux-based BBS packages are available for people
that want to run a bulletin board system\&.  Some of these packages can be
found at \fBsunsite\&.unc\&.edu\fR in \fI/pub/Linux/system/Network\fR\&.
.P 1
.INDEX {UUCP}
.INDEX {FidoNet}
Apart from terminal programs, there is also software that uses a serial
link non-interactively to transport data to or from your computer\&. The
advantage of this technique is that it takes much less time to download
a few dozen kilobytes automatically, than it might take you to read your
mail on-line in some mailbox and browse a bulletin board for interesting
articles\&. On the other hand, this requires more disk storage because of
the loads of useless information you usually get\&.
.P 1
The epitome of this sort of communications software is UUCP\&. It is a
program suite that copies files from one host to another, executes
programs on a remote host, etc\&. It is frequently used to transport mail
or news in private networks\&. Ian Taylor's UUCP package, which also runs
under Linux, is described in the following chapter\&.  Other
non-interactive communication software is, for example, used throughout
Fidonet\&. Ports of Fidonet applications like \fIifmail\fR are also
available\&.
.P 1
.INDEX {SLIP}
SLIP, the serial line Internet protocol, is somewhat inbetween,
allowing both interactive and non-interactive use\&. Many people
use SLIP to dial up their campus network or some other sort of
public SLIP server to run FTP sessions, etc\&. SLIP may however also
be used over permanent or semi-permanent connections for LAN-to-LAN
coupling, although this is really only interesting with ISDN\&.
.P 1
.H 2 "Introduction to Serial Devices"
.SETR "serial.ttys"
.INDEX {tty|(}
.P 1
The devices a Un*x kernel provides for accessing serial devices are
typically called \fIttys\fR\&. This is an abbreviation for \fITeletype\fR(tm),
which used to be one of the major manufacturers of terminals in the
early days of Unix\&.  The term is used nowadays for any character-based data
terminal\&.  Throughout this chapter, we will use the term exclusively to
refer to kernel devices\&.
.P 1
Linux distinguishes three classes of ttys: (virtual) consoles,
pseudo-terminals (similar to a two-way pipe, used by application such as
X11), and serial devices\&.  The latter are also counted as ttys, because
they permit interactive sessions over a serial connection; be it from a
hard-wired terminal or a remote computer over a telephone line\&.
.P 1
Ttys have a number of configurable parameters which can be set using the
\fIioctl(2)\fR system call\&. Many of them apply only to serial devices,
since they need a great deal more flexibility to handle varying types of
connections\&.
.P 1
.INDEX {line discipline}
.INDEX {tty!line discipline}
Among the most prominent line parameters are the line speed and parity\&.
But there are also flags for the conversion between upper and lower case
characters, of carriage return into line feed, etc\&. The tty driver may
also support various \fIline disciplines\fR which make the device
driver behave completely different\&. For example, the SLIP driver for
Linux is implemented by means of a special line discipline\&.
.P 1
.INDEX {serial line!speed}
.INDEX {modem, speed}
.INDEX {Baud rate}
.INDEX {Bit rate}
There is a bit of ambiguity about how to measure a line's speed\&.  The
correct the term is \fIBit rate\fR, which is related to the line's transfer
speed measured in bits per second (or bps for short)\&.  Sometimes, you hear
people refer to it as the \fIBaud rate\fR, which is not quite correct\&.
These two terms are, however, not interchangeable\&. The Baud rate
refers to a physical characteristic of some serial device, namely the
clock rate at which pulses are transmitted\&.  The bit rate rather
denotes a current state of an existing serial connection between two
points, namely the average number of bits transferred per second\&. It
is important to know that these two values are usually different, as
most devices encode more than one bit per electrical pulse\&.
.P 1
.H 2 "Accessing Serial Devices"
.SETR "serial.devices"
Like all devices in a Un*x system, serial ports are accessed
through device special files, located in the \fI/dev\fR directory\&.
There are two varieties of device files related to serial drivers,
and for each port, there is one device file from each of them\&.
Depending on the file it is accessed by, the device will behave
differently\&.
.P 1
.INDEX {dev/cua*@\fI/dev/cua*\fR|(}
.INDEX {dev/ttyS*@\fI/dev/ttyS*\fR|(}
.INDEX {serial line!device file}
.INDEX {dialout device}
.INDEX {dialin device}
The first variety is used whenever the port is used for dialing in; it
has a major number of 4, and the files are named \fIttyS0\fR,
\fIttyS1\fR, etc\&. The second variety is used when dialing out
through a port; the files are called \fIcua0\fR, etc, and
have a major number of 5\&.
.P 1
.INDEX {COM port}
.INDEX {port!COM}
Minor numbers are identical for both types\&. If you have your modem on
one of the ports \fICOM1\fR through \fICOM4\fR, its minor number will
be the \fICOM\fR port number plus 63\&. If your setup is different from
that, for example when using a board supporting multiple serial lines,
please refer to the Serial Howto\&.
.P 1
Assume your modem is on \fICOM2\fR\&. Thus its minor number will be 65,
and its major number will be 5 for dialing out\&.  There should be a
device \fIcua1\fR which has these numbers\&. List the serial ttys in
the \fI/dev\fR directory\&.  Columns 5 and 6 should show major and minor
numbers, respectively:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ ls -l /dev/cua*
crw-rw-rw-   1 root     root       5,  64 Nov 30 19:31 /dev/cua0
crw-rw-rw-   1 root     root       5,  65 Nov 30 22:08 /dev/cua1
crw-rw-rw-   1 root     root       5,  66 Oct 28 11:56 /dev/cua2
crw-rw-rw-   1 root     root       5,  67 Mar 19  1992 /dev/cua3
.ENDVERBATIM
\"
\fR
.DE
.P 1
If there is no such device, you will have to create one: become
super-user and type
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# mknod -m 666 /dev/cua1 c 5 65
# chown root.root /dev/cua1
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {dev/modem@\fI/dev/modem\fR}
Some people suggest making \fI/dev/modem\fR a symbolic link to your
modem device, so that casual users don't have to remember the somewhat
unintuitive \fIcua1\fR\&. However, you cannot use \fImodem\fR in one
program, and the real device file name in another\&. This is because
these programs use so-called \fIlock files\fR to signal that the
device is used\&. By convention, the lock file name for \fIcua1\fR, for
instance, is \fILCK\&.\&.cua1\fR\&.  Using different device files for the
same port means that programs will fail to recognize each other's lock
files, and will both use the device at the same time\&. As a result, both
applications will not work at all\&.
.P 1
.INDEX {dev/cua*@\fI/dev/cua*\fR|)}
.INDEX {dev/ttyS*@\fI/dev/ttyS*\fR|)}
.P 1
.H 2 "Serial Hardware"
.SETR "serial.hardware"
.INDEX {RS-232}
.P 1
Linux currently supports a wide variety of serial boards which use
the RS-232 standard\&.  RS-232 is currently the most common standard for
serial communcications in the PC world\&. It uses a number of circuits for
transmitting single bits as well as for synchronization\&. Additional
lines may be used for signaling the presence of a carrier (used by
modems), and handshake\&.
.P 1
.INDEX {serial line!hardware handshake}
.INDEX {handshake, hardware}
.INDEX {hardware!handshake}
.INDEX {RTS/CTS}
Although hardware handshake is optional, it is very useful\&. It allows
either of the two stations to signal whether it is ready to receive more
data, or if the other station should pause until the receiver is done
processing the incoming data\&.  The lines used for this are called
``Clear to Send'' (CTS) and ``Ready to Send'' (RTS), respectively, which
accounts for the colloquial name of hardware handshake, namely
``RTS/CTS''\&.
.P 1
.INDEX {16450 UART}
.INDEX {16550 UART}
.INDEX {UART}
In PCs, the RS-232 interface is usually driven by a UART chip derived
from the National Semiconductor 16450 chip, or a newer version thereof,
the NSC 16550A(\*F)
.FS
There was also a NSC 16550, but it's FIFO never really worked\&.
.FE
\&. Some brands (most notably internal modems equipped with the Rockwell
chipset) also use completely different chips that have been programmed
to behave as if they were 16550's\&.
.P 1
.INDEX {8250 UART}
The main difference between 16450's and 16550's that the latter have a
FIFO buffer of 16 Bytes, while the former only have a 1-Byte buffer\&.
This makes 16450's suitable for speeds up to 9600 Baud, while higher
speeds require a 16550-compatible chip\&.  Besides these chips, Linux
also supports the 8250 chip, which was the original UART for the PC-AT\&.
.P 1
In the default configuration, the kernel looks for four standard serial
boards on \fICOM1\fR through \fICOM4\fR\&. These will be assigned
device minor numbers 64 through 67, as described above\&.
.P 1
.INDEX {configuring!serial port|(}
.INDEX {setserial@\fIsetserial\fR}
.INDEX {T'so, Theodore}
If you want to configure your serial ports properly, you should install
Ted Tso's \fIsetserial\fR command along with the \fIrc\&.serial\fR
script\&.  This script should be invoked from \fI/etc/rc\fR at system
boot time\&. It uses \fIsetserial\fR to configure the kernel serial
devices\&. A typical \fIrc\&.serial\fR script looks like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /etc/rc.serial - serial line configuration script.
#
# Do wild interrupt detection
/sbin/setserial -W /dev/cua*

# Configure serial devices
/sbin/setserial /dev/cua0 auto_irq skip_test autoconfig
/sbin/setserial /dev/cua1 auto_irq skip_test autoconfig
/sbin/setserial /dev/cua2 auto_irq skip_test autoconfig
/sbin/setserial /dev/cua3 auto_irq skip_test autoconfig

# Display serial device configuration
/sbin/setserial -bg /dev/cua*
.ENDVERBATIM
\"
\fR
.DE
.P 1
.br
.ti 0
Please refer to the documentation that comes along with \fIsetserial\fR
for an explanation of the parameters\&.
.P 1
If your serial card is not detected, or the \fIsetserial -bg\fR command
shows an incorrect setting, you will have to force the configuration
by explicitly supplying the correct values\&. Users with internal modems equipped
with the Rockwell chipset are reported to experience this problem\&. If,
for example, the UART chip is reported to be a NSC 16450, while in fact
it is NSC 16550-compatible, you have to change the configuration command
for the offending port to
.P 1
.P 1
.DS I F 5
\fB/sbin/setserial /dev/cua1 auto_irq skip_test autoconfig uart 16550
\"
\fR
.DE
.P 1
Similar options exist to force \fICOM\fR port, base address, and IRQ
setting\&. Please refer to the \fIsetserial(8)\fR manual page\&.
.P 1
.INDEX {serial line!hardware handshake}
.INDEX {handshake, hardware}
.INDEX {hardware!handshake}
If your modem supports hardware handshake, you should make sure to
enable it\&. Surprising as it is, most communication programs do not
attempt to enable this by default; you have to set it manually instead\&.
This is best performed in the \fIrc\&.serial\fR script, using the
\fIstty\fR command:
.P 1
.P 1
.DS I F 5
\fB$ stty crtscts < /dev/cua1
\"
\fR
.DE
.P 1
To check if hardware handshake is in effect, use
.P 1
.P 1
.DS I F 5
\fB$ stty -a < /dev/cua1
\"
\fR
.DE
.P 1
This gives you the status of all flags for that device; a flag
shown with a preceding minus as in \fB-crtscts\fR means that the
flag has been turned off\&.
.P 1
.INDEX {configuring!serial port|)}
.P 1
.INDEX {tty|)}
.INDEX {device, serial|)}
.INDEX {hardware!serial|)}
.P 1
.H 1 "Configuring TCP/IP Networking"
.SETR "iface"
In this chapter, we will go through all the steps necessary to setting
up TCP/IP networking on your machine\&. Starting with the assignment of
IP addresses, we will slowly work our way through the configuration of
TCP/IP network interfaces, and introduce a few tools that come quite
handy when hunting down problems with your network installation\&.
.P 1
.INDEX {rc scripts@\fIrc\fR scripts}
.INDEX {bootup sequence}
.INDEX {initializing networking}
.INDEX {network!booting}
.INDEX {rc\&.inet@\fIrc\&.inet\fR}
.INDEX {rc\&.inet@\fIrc\&.inet\fR}
.P 1
Most of the tasks covered in this chapter you will generally have to
do only once\&. Afterwards, you have to touch most configuration files
only when adding a new system to your network, or when you reconfigure
your system entirely\&. Some of the commands used to configure TCP/IP,
however, have to be executed each time the system is booted\&. This is
usually done by invoking them from the system \fI/etc/rc\fR scripts\&.
.P 1
Commonly, the network-specific part of this procedure is contained
in a script called \fIrc\&.net\fR or \fIrc\&.inet\fR\&. Sometimes, you will
also see two scripts named \fIrc\&.inet1\fR and \fIrc\&.inet2\fR, where the
former initializes the kernel part of networking, while the latter
starts basic networking services and applications\&. Throughout
the following, I will adhere to the latter concept\&.
.P 1
Below, I will discuss the actions performed by \fIrc\&.inet1\fR, while
applications will be covered in later chapters\&. After finishing this
chapter, you should have established a sequence of commands that
properly configure TCP/IP networking on your computer\&. You should then
replace any sample commands in \fIrc\&.inet1\fR with your commands, make
sure \fIrc\&.inet1\fR is executed at startup time, and reboot your
machine\&.  The networking \fIrc\fR scripts that come along with your
favorite Linux distribution should give you a good example\&.
.P 1
.H 2 "Setting up the proc Filesystem"
.SETR "iface.procfs"
.INDEX {mounting!the proc filesystem@the \fIproc\fR filesystem}
.INDEX {proc filesystem@\fIproc\fR filesystem}
.P 1
Some of the configuration tools of the Net-2 release rely on
the \fIproc\fR filesystem for communicating with the kernel\&. This
is an interface that permits access to kernel run-time information
through a filesystem-like mechanism\&. When mounted, you can list its
files like any other filesystem, or display their contents\&.  Typical
items include the \fIloadavg\fR file that contains the system load
average, or \fImeminfo\fR, which shows current core memory and swap
usage\&.
.P 1
.INDEX {/proc/net@\fI/proc/net\fR}
To this, the networking code adds the \fInet\fR directory\&.
It contains a number of files that show things like the
kernel ARP tables, the state of TCP connections, and the routing tables\&.
Most network administration tools get their information from these files\&.
.P 1
.INDEX {fstab@\fIfstab\fR}
The \fIproc\fR filesystem (or \fIprocfs\fR as it is also known)
is usually mounted on \fI/proc\fR at system boot time\&. The best 
method is to add the following line to \fI/etc/fstab\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# procfs mont point:
none		/proc		proc	defaults
.ENDVERBATIM
\"
\fR
.DE
.P 1
.br
.ti 0
and execute ``\fBmount /proc\fR'' from your \fI/etc/rc\fR script\&.
.P 1
The \fIprocfs\fR is nowadays configured into most kernels by default\&.
If the \fIprocfs\fR is not in your kernel, you will get a message like
``\fBmount: fs type procfs not supported by kernel\fR''\&. You will then
have to recompile the kernel and answer ``yes'' when asked for
\fIprocfs\fR support\&.
.P 1
.H 2 "Installing the Binaries"
.SETR "iface.binaries"
.INDEX {installing!network binaries}
.P 1
If you are using one of the pre-packaged Linux distributions, it
will most probably contain the major networking applications and
utilities along with a coherent set of sample files\&.  The only case
where you might have to obtain and install new utilities is when you
install a new kernel release\&. As they occasionally involve changes in
the kernel networking layer, you will need to update the basic
configuration tools\&. This at least involves recompiling, but sometimes
you may also be required to obtain the latest set of binaries\&.  These
are usually distributed along with the kernel, packaged in an archive
called \fInet-\fB\fIXXX\fB\fI\&.tar\&.gz\fR, where \fB\fIXXX\fB\fR is the version
number\&. The release matching Linux 1\&.0 is 0\&.32b, the latest
kernel as of this writing (1\&.1\&.12 and later) require 0\&.32d\&.
.P 1
If you want to compile and install the standard TCP/IP network
applications yourself, you can obtain the sources from most Linux
FTP servers\&.  These are more or less heavily patched versions of
programs from Net-BSD or other sources\&.  Other applications, such as
\fIXmosaic\fR, \fIxarchie\fR, or Gopher and IRC clients must be
obtained separately\&.  Most of them compile out of the box if you
follow the instructions\&.
.P 1
.INDEX {obtaining the source code}
.INDEX {FTP, location of Linux code}
.INDEX {Net-2e}
.INDEX {Net-3}
.INDEX {Net-BSD}
The official FTP site for Net-3 is \fBsunacm\&.swan\&.ac\&.uk\fR, mirrored
by \fBsunsite\&.unc\&.edu\fR below \fIsystem/Network/sunacm\fR\&.  The
latest Net-2e patch kit and binaries are available from
\fBftp\&.aris\&.com\fR\&.  Matthias Urlichs' BSD-derived networking code
can be gotten from \fBftp\&.ira\&.uka\&.de\fR in
\fI/pub/system/linux/netbsd\fR\&.
.P 1
.H 2 "Another Example"
.SETR "iface.brewery"
.INDEX {Virtual Brewery}
.INDEX {Brewery, Virtual}
.P 1
For the remainder of this book, let me introduce a new example
that is less complex than Groucho Marx University, and may be closer
to the tasks you will actually encounter\&. Consider the Virtual
Brewery, a small company that brews, as the name indicates, virtual
beer\&. To manage their business more efficiently, the virtual brewers
want to network their computers, which all happen to be PCs running
a bright and shiny Linux 1\&.0\&.
.P 1
On the same floor, just across the hall, there's the Virtual Winery,
who work closely with the brewery\&.  They run an Ethernet of their own\&.
Quite naturally, the two companies want to link their networks once
they are operational\&.  As a first step, they want to set up a gateway
host that forwards datagrams between the two subnets\&. Later, they also
want to have a UUCP link to the outside world, through which they
exchange mail and news\&.  In the long run, the also want to set up a
SLIP connection to connect to the Internet occasionally\&.
.P 1
.H 2 "Setting the Hostname"
.SETR "iface.hostname"
.INDEX {hostname!setting}
.INDEX {configuring!hostname}
.INDEX {setting!hostname}
.P 1
Most, if not all, network applications rely on the local host's
name having been set to some reasonable value\&. This is usually
done during the boot procedure by executing the \fIhostname\fR
command\&. To set the hostname to \fB\fIname\fB\fR, it is invoked as 
.P 1
.P 1
.DS I F 5
\fB# hostname \fB\fIname\fB\fB
\"
\fR
.DE
.P 1
It is common practice to use the unqualified hostname without any
domain name for this\&. For instance, hosts at the Virtual Brewery might
be called \fBvale\&.vbrew\&.com\fR, \fBvlager\&.vbrew\&.com\fR, etc\&.  These
are their official, fully qualified domain names\&.  Their local
hostnames would be only the first component of the name, such as
\fBvale\fR\&. However, as the local hostname is frequently used to look
up the host's IP address, you have to make sure that the resolver
library is able to look up the host's IP address\&. This usually means
that you have to enter the name in \fI/etc/hosts\fR (see below)\&.
.P 1
.INDEX {domain name!NIS vs\&. DNS}
.INDEX {domainname@\fIdomainname\fR}
.INDEX {setting!domain name}
Some people suggest to use the \fIdomainname\fR command to set the
kernel's idea of a domain name to the remaining part of the FQDN\&. In
this way you could combine the output from \fIhostname\fR and
\fIdomainname\fR to get the FQDN again\&.  However, this is at best
only half correct\&. \fIdomainname\fR is generally used to set the
host's NIS domain, which may be entirely different from the DNS domain
your host belongs to\&.  NIS is covered in chapter 
.GETHN "nis"
\&\&.
.P 1
.H 2 "Assigning IP Addresses"
.SETR "iface.addresses"
.INDEX {assigning IP addresses}
.INDEX {IP!address!assigning}
.INDEX {address!choosing (IP)}
.INDEX {choosing!IP addresses}
.P 1
If you configure the networking software on your host for standalone
operation (for instance, to be able to run the INN netnews software),
you can safely skip this section, because you will need an IP address
just for the loopback interface, which is always \fB127\&.0\&.0\&.1\fR\&.
.P 1
Things are a little more complicated with real networks like Ethernets\&.
If you want to connect your host to an existing network, you have to ask
its administrators to give you an IP address on this network\&.  When
setting up the network all by yourself, you have to assign IP addresses
yourself as described below\&.
.P 1
Hosts within a local network should usually share addresses from the
same logical IP network\&. Hence you have to assign an IP network address\&.
If you have several physical networks, you either have to assign them
different network numbers, or use subnetting to split your IP address
range into several subnetworks\&.
.P 1
If your network is not connected to the Internet, you are free to choose
any (legal) network address\&. You only have to make sure to choose one from
classes A, B, or C, else things will most likely not work properly\&.
However, if you intend to get on the Internet in the near future, you
should obtain an official IP address \fInow\fR\&. The best way to proceed is
to ask your network service provider to help you\&.  If you want to obtain a
network number just in case you might get on the Internet someday, request
a Network Address Application Form from \fBhostmaster@internic\&.net\fR\&.
.P 1
.INDEX {creating!subnets}
.INDEX {subnet (DNS)}
.INDEX {interface!netmask}
.INDEX {IP!netmask}
To operate several Ethernets (or other networks, once a driver is
available), you have to split your network into subnets\&. Note that
subnetting is required only if you have more than one \fIbroadcast
network\fR; point-to-point links don't count\&. For instance, if you have
one Ethernet, and one or more SLIP links to the outside world, you
don't need to subnet your network\&. The reason for this will be
explained in chapter 
.GETHN "slip"
\&\&.
.P 1
As an example, the brewery's network manager applies to the NIC for a
class B network number, and is given \fB191\&.72\&.0\&.0\fR\&.  To accomodate
the two Ethernets, she decides to use eight bits of the host part as
additional subnet bits\&. This leaves another eight bits for the host
part, allowing for 254 hosts on each of the subnets\&. She then assigns
subnet number 1 to the brewery, and gives the winery number 2\&. Their
respective network addresses are thus \fB191\&.72\&.1\&.0\fR and
\fB191\&.72\&.2\&.0\fR\&. The subnet mask is \fB255\&.255\&.255\&.0\fR\&.
.P 1
\fBvlager\fR, which is the gateway between the two networks, is assigned a
host number of 1 on both of them, which gives it the IP addresses
\fB191\&.72\&.1\&.1\fR and \fB191\&.72\&.2\&.1\fR, respectively\&.
Figure 
.GETHN "interface.fig.subnet"
\& shows the two subnets, and the gateway\&.
.P 1
Note that in this example I am using a class B network to keep things
simple; a class C network would be more realistic\&.  With the new networking
code, subnetting is not limited to byte boundaries, so even a class C
network may be split into several subnets\&. For instance, you could use 2
bits of the host part for the netmask, giving you four possible subnets
with 64 hosts on each\&.(\*F)
.FS
The last number on each subnet is reserved as the broadcast address,
so it's in fact 63 hosts per subnet\&.
.FE
.P 1
.H 2 "Writing hosts and networks Files"
.SETR "iface.simple-resolv"
.INDEX {configuring!hostname resolution}
.INDEX {hosts file@\fIhosts\fR file}
.INDEX {networks file@\fInetworks\fR file}
.INDEX {hostname!resolution}
.INDEX {network!names}
.INDEX {hosts@\fIhosts\fR}
.P 1
After you have subnetted your network, you should prepare for some simple
sort of hostname resolution using the \fI/etc/hosts\fR file\&. If you are
not going to use DNS or NIS for address resolution, you have to put all
hosts in the \fIhosts\fR file\&.
.P 1
Even if you want to run DNS or NIS during normal operation, you want to
have some subset of all hostnames in \fI/etc/hosts\fR nevertheless\&.
For one, you want to have some sort of name resolution even when no
network interfaces are running, for example during boot time\&.  This is
not only a matter of convenience, but also allows you to use symbolic
hostnames in your \fIrc\&.inet\fR scripts\&. Thus, when changing
IP addresses, you only have to copy an updated \fIhosts\fR file to all
machines and reboot, rather than having to edit a large number of
\fIrc\fR files separately\&.  Usually, you will put all local hostnames
and addresses in \fIhosts\fR, adding those of any gateways and NIS
servers if used\&.(\*F)
.FS
You will need the address of any NIS servers only if you use Peter
Eriksson's NYS\&. Other NIS implementations locate their servers at
run-time only by using \fIypbind\fR\&.
.FE
.P 1
Also, during intial testing, you should make sure your resolver only
uses information from the \fIhosts\fR file\&. Your DNS or NIS software may
come with sample files that may produce strange results when being used\&.
To make all applications use \fI/etc/hosts\fR exclusively when looking
up the IP address of a host, you have to edit the \fI/etc/host\&.conf\fR
file\&. Comment out any lines that begin with the keyword \fIorder\fR
by preceding them with a hash sign, and insert the line
.P 1
.P 1
.DS I F 5
\fBorder hosts
\"
\fR
.DE
.P 1
The configuration of the resolver library will be covered in detail
in chapter 
.GETHN "resolv"
\&\&.
.P 1
The \fIhosts\fR file contains one entry per line, consisting of an
IP address, a hostname, and an optional list of aliases for the
hostname\&.  The fields are separated by spaces or tabs, and the address
field must begin in column one\&. Anything following a hash sign (#) is
regarded as a comment and is ignored\&.
.P 1
Hostnames can be either fully qualified, or relative to the local
domain\&.  For \fBvale\fR, you would usually enter the the fully
qualified name, \fBvale\&.vbrew\&.com\fR, and \fBvale\fR by itself in the
\fIhosts\fR file, so that it is known by both its official name and the
shorter local name\&.
.P 1
This is an example how a \fIhosts\fR file at the Virtual Brewery
might look\&.  Two special names are included, \fBvlager-if1\fR and
\fBvlager-if2\fR that give the addresses for both interfaces used
on \fBvlager\fR\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# Hosts file for Virtual Brewery/Virtual Winery
#
# IP            local       fully qualified domain name
#
127.0.0.1       localhost
#
191.72.1.1      vlager      vlager.vbrew.com
191.72.1.1      vlager-if1
191.72.1.2      vstout      vstout.vbrew.com
191.72.1.3      vale        vale.vbrew.com
#
191.72.2.1      vlager-if2
191.72.2.2      vbeaujolais  vbeaujolais.vbrew.com
191.72.2.3      vbardolino   vbardolino.vbrew.com
191.72.2.4      vchianti     vchianti.vbrew.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
Just as with a host's IP address, you sometimes would like to use a
symbolic name for network numbers, too\&. Therefore, the \fIhosts\fR file
has a companion called \fI/etc/networks\fR that maps network names to
network numbers and vice versa\&. At the Virtual Brewery, we might install
a \fInetworks\fR file like this:(\*F)
.FS
Note that names in \fInetworks\fR must not collide with hostnames
from the \fIhosts\fR file, else some programs may produce strange
results\&.
.FE
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /etc/networks for the Virtual Brewery
brew-net      191.72.1.0
wine-net      191.72.2.0
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 2 "Interface Configuration for IP"
.SETR "iface.interface"
.INDEX {IP!interface configuration} 
.INDEX {interface!configuration}
.INDEX {configuring!network interfaces}
.INDEX {ifconfig@\fIifconfig\fR}
.INDEX {route@\fIroute\fR}
.P 1
.INDEX {rc\&.inet@\fIrc\&.inet\fR}
.INDEX {rc\&.inet@\fIrc\&.inet\fR}
After setting up your hardware as explained in the previous chapter, you
have to make these devices known to the kernel networking software\&.  A
couple of commands are used to configure the network interfaces, and
initialize the routing table\&. These tasks are usually performed from the
\fIrc\&.inet1\fR script each time the system is booted\&.  The basic tools for
this are called \fIifconfig\fR (where ``if'' stands for interface), and
\fIroute\fR\&.
.P 1
\fIifconfig\fR is used to make an interface accessible to the kernel
networking layer\&. This involves the assignment of an IP address and other
parameters, and activating the interface, also known as ``taking up\&.''
Being active here means that the kernel will send and receive IP datagrams
through the interface\&.  The simplest way to invoking it is
.P 1
.P 1
.DS I F 5
\fBifconfig \fB\fIinterface ip-address\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
which assigns \fB\fIip-address\fB\fR to \fB\fIinterface\fB\fR and activates it\&.
All other parameters are set to default values\&. For instance, the
default subnet mask is derived from the network class of the IP address,
such as \fB255\&.255\&.0\&.0\fR for a class B address\&.  \fIifconfig\fR is
described in detail at the end of this chapter\&.
.P 1
\fIroute\fR allows you to add or remove routes from the kernel routing
table\&. It can be invoked as
.P 1
.P 1
.DS I F 5
\fBroute [add|del] \fB\fItarget\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
where the \fBadd\fR and \fBdel\fR arguments determine whether
to add or delete the route to \fB\fItarget\fB\fR\&.
.P 1
.H 3 "The Loopback Interface"
.SETR "iface.interface.loopback"
.INDEX {configuring!loopback interface}
.INDEX {loopback!interface}
.INDEX {interface!loopback}
.INDEX {lo (loopback interface)@\fIlo\fR (loopback interface)}
.P 1
The very first interface to be activated is the loopback interface:
.P 1
.P 1
.DS I F 5
\fB# ifconfig lo 127\&.0\&.0\&.1
\"
\fR
.DE
.P 1
.INDEX {localhost@\fBlocalhost\fR}
Occasionally, you will also see the dummy hostname \fBlocalhost\fR
being used instead of the IP address\&. \fIifconfig\fR will look up
the name in the \fIhosts\fR file where an entry should declare
it as the hostname for \fB127\&.0\&.0\&.1\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# Sample /etc/hosts entry for localhost
localhost     127.0.0.1
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {checking!network interface}
To view the configuration of an interface, you invoke \fIifconfig\fR
giving it the interface name as argument:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ ifconfig lo
lo        Link encap Local Loopback  
          inet addr 127.0.0.1  Bcast [NONE SET]  Mask 255.0.0.0
          UP BROADCAST LOOPBACK RUNNING  MTU 2000  Metric 1
          RX packets 0 errors 0 dropped 0 overrun 0
          TX packets 0 errors 0 dropped 0 overrun 0
.ENDVERBATIM
\"
\fR
.DE
.P 1
As you can see, the loopback interface has been assigned a netmask
of \fB255\&.0\&.0\&.0\fR, since \fB127\&.0\&.0\&.1\fR is a class A address\&.
As you can see, the interface doesn't have a broadcast address set,
which isn't normally very useful for the loopback anyway\&. However, if
you run the \fIrwhod\fR daemon on your host, you may have to set the
loopback device's broadcast address in order for \fIrwho\fR to function
properly\&. Setting the broadcast is explained in section ``All about
\fIifconfig\fR'' below\&.
.P 1
Now, you can almost start playing with your mini-``network\&.'' What is
still missing is an entry in the routing table that tells IP that
it may use this interface as route to destination \fB127\&.0\&.0\&.1\fR\&.
This is accomplished by typing
.P 1
.P 1
.DS I F 5
\fB# route add 127\&.0\&.0\&.1
\"
\fR
.DE
.P 1
Again, you can use \fBlocalhost\fR instead of the IP address\&.
.P 1
.INDEX {testing network configuration}
.INDEX {checking!network configuration}
.INDEX {checking!reachabilty}
.INDEX {reaching a host}
.INDEX {round-trip time (IP)}
.INDEX {ping@\fIping\fR}
Next, you should check that everything works fine, for example by using
\fIping\fR\&.  \fIping\fR is the networking equivalent of a sonar
device(\*F)
.FS
Anyone remember Pink Floyd's ``Echoes''?
.FE
and is used to verify that a given address is actually reachable, and
to measure the delay that occurs when sending a datagram to it and back
again\&.  The time required for this is often referred to as the
round-trip time\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ping localhost
PING localhost (127.0.0.1): 56 data bytes
64 bytes from 127.0.0.1: icmp_seq=0 ttl=32 time=1 ms
64 bytes from 127.0.0.1: icmp_seq=1 ttl=32 time=0 ms
64 bytes from 127.0.0.1: icmp_seq=2 ttl=32 time=0 ms
^C

--- localhost ping statistics ---
3 packets transmitted, 3 packets received, 0% packet loss
round-trip min/avg/max = 0/0/1 ms
.ENDVERBATIM
\"
\fR
.DE
.P 1
When invoking \fIping\fR as shown here, it will go on emitting packets
forever unless interrupted by the user\&. The \fB^C\fR above marks the
place where we pressed Ctrl-C\&.
.P 1
The above example shows that packets for \fB127\&.0\&.0\&.1\fR are properly
delivered and a reply is returned to \fIping\fR almost instantaneously\&.
This shows you have succeeded in setting up your first network interface\&.
.P 1
.INDEX {Network Unreachable error message@``Network Unreachable'' error message}
.INDEX {network!unreachable}
If the output you get from \fIping\fR does not resemble that shown above,
you are in trouble\&. Check any error if they indicate some file hasn't
been installed properly\&. Check that the \fIifconfig\fR and \fIroute\fR
binaries you use are compatible with the kernel release you run, and,
above all, that the kernel has been compiled with networking enabled
(you see this from the presence of the \fI/proc/net\fR directory)\&.
If you get an error message saying ``Network unreachable,'' then you
probably have got the \fIroute\fR command wrong\&. Make sure you use
the same address as you gave to \fIifconfig\fR\&.
.P 1
.INDEX {rc\&.inet@\fIrc\&.inet\fR}
The steps described above are enough to use networking applications on
a standalone host\&. After adding the above lines to \fIrc\&.inet1\fR and
making sure both \fIrc\&.inet\fR scripts are executed from
\fI/etc/rc\fR, you may reboot your machine and try out various
applications\&. For instance, ``\fItelnet localhost\fR'' should
establish a \fItelnet\fR connection to your host, giving you a login
prompt\&.
.P 1
However, the loopback interface is useful not only as an example in
networking books, or as a testbed during development, but is actually
used by some applications during normal operation\&.(\*F)
.FS
For instance, all applications based on RPC use the loopback interface
to register themselves with the \fIportmapper\fR daemon at startup\&.
.FE
Therefore, you always have to configure it, regardless of whether your
machine is attached to a network or not\&.
.P 1
.H 3 "Ethernet Interfaces"
.SETR "iface.interface.ethernet"
.INDEX {configuring!Ethernet}
.INDEX {Ethernet!configuration}
.INDEX {interface!Ethernet}
.INDEX {IP!netmask}
.INDEX {interface!netmask}
.INDEX {eth0 (Ethernet interface)@\fIeth0\fR (Ethernet interface)}
.INDEX {address!broadcast}
.INDEX {IP!broadcast address}
.P 1
Configuring an Ethernet interface goes pretty much the same as
with the loopback interface, it just requires a few more parameters
when you are using subnetting\&. 
.P 1
At the Virtual Brewery, we have subnetted the IP network, which was
originally a class B network, into class C subnetworks\&. To make the
interface recognize this, the \fIifconfig\fR incantation would look
like this:
.P 1
.P 1
.DS I F 5
\fB# ifconfig eth0 vstout netmask 255\&.255\&.255\&.0
\"
\fR
.DE
.P 1
This assigns the \fIeth0\fR interface the IP address of \fBvstout\fR
(\fB191\&.72\&.1\&.2\fR)\&. If we had omitted the netmask, \fIifconfig\fR
would have deduced the the netmask from the IP network class, which
would have resulted in a netmask of \fB255\&.255\&.0\&.0\fR\&.
Now a quick check shows:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ifconfig eth0
eth0      Link encap 10Mps Ethernet HWaddr  00:00:C0:90:B3:42
          inet addr 191.72.1.2 Bcast 191.72.1.255 Mask 255.255.255.0
          UP BROADCAST RUNNING  MTU 1500  Metric 1
          RX packets 0 errors 0 dropped 0 overrun 0
          TX packets 0 errors 0 dropped 0 overrun 0
.ENDVERBATIM
\"
\fR
.DE
.P 1
You can see that \fIifconfig\fR automatically set the broadcast
address (the \fBBcast\fR field above) to the usual value, which is
the hosts network number with the host bits all set\&. Also, the message
transfer unit (the maximum size of Ethernet frames the kernel will
generate for this interface) has been set to the maximum value of 1500
bytes\&. All these values can be overidden with special options that
will be described later\&.
.P 1
Quite similar to the loopback case, you now have to install a routing
entry that informs the kernel about the network that can be reached
through \fIeth0\fR\&.  For the Virtual Brewery, you would invoke
\fIroute\fR as
.P 1
.P 1
.DS I F 5
\fB# route add -net 191\&.72\&.1\&.0
\"
\fR
.DE
.P 1
At first, this looks a little like magic, because it's not really
clear how \fIroute\fR detects which interface to route through\&.
However, the trick is rather simple: the kernel checks all interfaces
that have been configured so far and compares the destination address
(\fB191\&.72\&.1\&.0\fR in this case) to the network part of the interface
address (that is, the bitwise and of the interface address and the
netmask)\&. The only interface that matches is \fIeth0\fR\&.
.P 1
Now, what's that \fB-net\fR option for? This is used because
\fIroute\fR can handle both routes to networks and routes to single
hosts (as you have seen above with \fBlocalhost\fR)\&. When being given an
address in dotted quad notation, it attempts to guess whether it is a
network or a hostname by looking at the host part bits\&. If the address'
host part is zero, \fIroute\fR assumes it denotes a network, otherwise
it takes it as a host address\&. Therefore, \fIroute\fR would think that
\fB191\&.72\&.1\&.0\fR is a host address rather than a network number,
because it cannot know that we use subnetting\&. We therefore have to tell
it explicitly that it denotes a network, giving it the \fB-net\fR
flag\&.
.P 1
Of course, the above \fIroute\fR command is a little tedious to type,
and it's prone to spelling mistakes\&. A more convenient approach is to
use the network names we have defined in \fI/etc/networks\fR above\&.
This makes the command much more readable; even the \fB-net\fR flag
can now be omitted, because \fIroute\fR now knows that
\fB191\&.72\&.1\&.0\fR denotes a network\&.
.P 1
.P 1
.DS I F 5
\fB# route add brew-net
\"
\fR
.DE
.P 1
.INDEX {testing network configuration}
.INDEX {checking!network configuration}
.INDEX {checking!reachabilty}
Now that you've finished the basic configuration steps, we want to
make sure your Ethernet interface is indeed running happily\&. Choose a
host from your Ethernet, for instance \fBvlager\fR, and type
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ping vlager
PING vlager: 64 byte packets
64 bytes from 191.72.1.1: icmp_seq=0. time=11. ms
64 bytes from 191.72.1.1: icmp_seq=1. time=7. ms
64 bytes from 191.72.1.1: icmp_seq=2. time=12. ms
64 bytes from 191.72.1.1: icmp_seq=3. time=3. ms
^C

----vstout.vbrew.com PING Statistics----
4 packets transmitted, 4 packets received, 0% packet loss
round-trip (ms)  min/avg/max = 3/8/12
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you don't see any output similar to this, then something is broken,
obviously\&.  If you encounter unusual packet loss rates, this hints at
a hardware problem, like bad or missing terminators, etc\&.  If you
don't receive any packets at all, you should check the interface
configuration with \fInetstat\fR\&. The packet statistics displayed by
\fIifconfig\fR should tell you whether any packets have been sent out
on the interface at all\&. If you have access to the remote host, too,
you should go over to that machine and check the interface statistics,
too\&. In this way, you can determine exactly where the packets got
dropped\&.  In addition, you should display the routing information with
\fIroute\fR to see if both hosts have the correct routing entry\&. 
\fIroute\fR prints out the complete kernel routing table when invoked
without any arguments (the \fB-n\fR option only makes it print
addresses as dotted quad instead of using the hostname):
.P 1
.INDEX {IP!routing table}
.INDEX {display!IP routing table}
.INDEX {checking!IP routing table}
.INDEX {route@\fIroute\fR}
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# route -n
Kernel routing table
Destination     Gateway         Genmask         Flags Metric Ref Use    Iface
127.0.0.1       *               255.255.255.255 UH    1      0      112 lo
191.72.1.0      *               255.255.255.0   U     1      0       10 eth0
.ENDVERBATIM
\"
\fR
.DE
.P 1
The detailed meaning of these fields is explained below in
section 
.GETHN "iface.netstat"
\&\&. The \fBFlag\fR column contains a list of
flags set for each interface\&. \fBU\fR is always set for active
interfaces, and \fBH\fR says the destination address denotes a host\&.
If the \fBH\fR flag is set for a route that you meant to be a network
route, then you have to specify the \fB-net\fR option with the
\fIroute\fR command\&. To check whether a route you have entered is used
at all, check if the \fBUse\fR field in the second to last column
increases between two invocations of \fIping\fR\&.
.P 1
.H 3 "Routing through a Gateway"
.SETR "iface.interface.gateway"
.INDEX {routing!IP gateway}
.INDEX {IP!routing}
.INDEX {IP!gateway}
.INDEX {IP!subnet}
.INDEX {gateway!IP}
.P 1
In the previous section, I covered only the case of setting up a host
on a single Ethernet\&. Quite frequently, however, one encounters
networks connected to one another by gateways\&. These gateways may
simply link two or more Ethernets, but may provide a link to the
outside world, the Internet, as well\&. In order to use the service of a
gateway, you have to provide additional routing information to the
networking layer\&.
.P 1
For instance, the Ethernets of the Virtual Brewery and the Virtual
Winery are linked through such a gateway, namely the host \fBvlager\fR\&.
Assuming that \fBvlager\fR has already been configured, we only have to
add another entry to \fBvstout\fR's routing table that tells the kernel
it can reach all hosts on the Winery's network through \fBvlager\fR\&.
The appropriate incantation of \fIroute\fR is shown below; the
\fBgw\fR keyword tells it that the next argument denotes a gateway\&.
.P 1
.P 1
.DS I F 5
\fB# route add wine-net gw vlager
\"
\fR
.DE
.P 1
Of course, any host on the Winery network you wish to talk to must have
a corresponding routing entry for the Brewery's network, otherwise you
would only be able to send data from \fBvstout\fR to \fBvbardolino\fR,
but any response returned by the latter would go into the great bit
bucket\&.
.P 1
This example describes only a gateway that switches packets between two
isolated Ethernets\&. Now assume that \fBvlager\fR also has a connection
to the Internet (say, through an additional SLIP link)\&. Then we would
want datagrams to \fIany\fR destination network other than the Brewery
to be handed to \fBvlager\fR\&. This can be accomplished by making it the
default gateway for \fBvstout\fR:
.P 1
.P 1
.DS I F 5
\fB# route add default gw vlager
\"
\fR
.DE
.P 1
.INDEX {IP!default route}
.INDEX {route, default}
The network name \fBdefault\fR is a shorthand for \fB0\&.0\&.0\&.0\fR,
which denotes the default route\&. You do not have to add this name to
\fI/etc/networks\fR, because it is built into \fIroute\fR\&.
.P 1
When you see high packet loss rates when \fIping\fRing a host behind
one or more gateways, this may hint at a very congested network\&.  Packet
loss is not so much due to technical deficiencies as due to temporary
excess loads on forwarding hosts, which makes them delay or even drop
incoming datagrams\&.
.P 1
.H 3 "Configuring a Gateway"
.SETR "iface.interface.gateway-conf"
.INDEX {configuring!IP gateway}
.INDEX {gateway!configuring}
.INDEX {IP!gateway}
.INDEX {IP!routing}
.INDEX {IP!subnet}
.P 1
Configuring a machine to switch packets between two Ethernets is
pretty straightforward\&. Assume we're back at \fBvlager\fR, which
is equipped with two Ethernet boards, each being connected to one
of the two networks\&. All you have to do is configure both interfaces
separately, giving them their respective IP address, and that's it\&.
.P 1
It is quite useful to add information on the two interfaces to
the \fIhosts\fR file in the way shown below, so we have handy
names for them, too:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
191.72.1.1      vlager      vlager.vbrew.com
191.72.1.1      vlager-if1
191.72.2.1      vlager-if2
.ENDVERBATIM
\"
\fR
.DE
.P 1
The sequence of commands to set up the two interfaces is then:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ifconfig eth0 vlager-if1
# ifconfig eth1 vlager-if2
# route add brew-net
# route add wine-net
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "The PLIP Interface"
.SETR "iface.interface.plip"
.INDEX {configuring!PLIP}
.INDEX {interface!PLIP}
.INDEX {point-to-point link}
.INDEX {Parallel Line IP|see PLIP}
.INDEX {PLIP}
.INDEX {plip1 (PLIP interface)@\fIplip1\fR (PLIP interface)}
.P 1
When using a PLIP link to connect two machines, things are a
little different from what you have to do when using an Ethernet\&.
The former are so-called \fIpoint-to-point\fR links, because
they involve ony two hosts (``points''), as opposed
to broadcast networks\&.
.P 1
As an example, we consider the laptop computer of some employee at
the Virtual Brewery that is connected to \fBvlager\fR via PLIP\&.
The laptop itself is called \fBvlite\fR, and has only one
parallel port\&. At boot time, this port will be registered as
\fIplip1\fR\&. To activate the link, you have to configure the
\fIplip1\fR interface using the following commands:(\*F)
.FS
Note that \fBpointopoint\fR is not a typo\&. It's really
spelt like this\&.
.FE
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ifconfig plip1 vlite pointopoint vlager
# route add default gw vlager
.ENDVERBATIM
\"
\fR
.DE
.P 1
The first command configures the interface, telling the kernel that this
is a point-to-point link, with the remote side having the address of
\fBvlager\fR\&. The second installs the default route, using
\fBvlager\fR as gateway\&.  On \fBvlager\fR, a similar \fIifconfig\fR
command is necessary to activate the link (a \fIroute\fR invocation is
not needed):
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ifconfig plip1 vlager pointopoint vlite
.ENDVERBATIM
\"
\fR
.DE
.P 1
The interesting point is that the \fIplip1\fR interface on
\fBvlager\fR does not have to have a separate IP address, but may also
be given the address \fB191\&.72\&.1\&.1\fR\&.(\*F)
.FS
Just as a matter of caution, you should however configure a PLIP or
SLIP link only after you have completely set up the routing table
entries for your Ethernets\&. With some older kernels, your network
route might otherwise end up pointing at the point-to-point link\&.
.FE
.P 1
Now, we have configured routing from the laptop to the Brewery's
network; what's still missing is a way to route from any of the
Brewery's hosts to \fBvlite\fR\&. One particularly cumbersome way is
to add a specific route to every host's routing table that names 
\fBvlager\fR as a gateway to \fBvlite\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# route add vlite gw vlager
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {routing!dynamic}
.INDEX {Routing Information Protocol}
.INDEX {gated@\fIgated\fR}
.INDEX {ARP!proxy}
.INDEX {proxy ARP}
A much better option when faced with temporary routes is to use dynamic
routing\&.  One way to do so is to use \fIgated\fR, a routing daemon,
which you would have to install on each host in the network in order
to distribute routing information dynamically\&.  The easiest way,
however, is to use \fIproxy\fR ARP\&. With proxy ARP, \fBvlager\fR will
respond to any ARP query for \fBvlite\fR by sending its own Ethernet
address\&. The effect of this is that all packets for \fBvlite\fR will wind
up at \fBvlager\fR, which then forwards them to the laptop\&. We will come
back to proxy ARP in section 
.GETHN "iface.verify.arp"
\& below\&.
.P 1
Future Net-3 releases will contain a tool called \fIplipconfig\fR
which will allow you to set the IRQ of the printer port to use\&. Later,
this may even be replaced by a more general \fIifconfig\fR command\&.
.P 1
.H 3 "The SLIP and PPP Interface"
.SETR "iface.interface.slip"
.INDEX {sl0 (SLIP interface)@\fIsl0\fR (SLIP interface)}
.INDEX {sl0 (PPP interface)@\fIsl0\fR (PPP interface)}
.INDEX {point-to-point link}
.INDEX {configuring!SLIP}
.INDEX {configuring!PPP}
.INDEX {interface!SLIP}
.INDEX {interface!PPP}
.INDEX {SLIP}
.INDEX {PPP}
.P 1
Although SLIP and PPP links are only simple point-to-point links like
PLIP connections, there is much more to be said about them\&.  Usually,
establishing a SLIP connection involves dialing up a remote site
through your modem, and setting the serial line to SLIP mode\&. PPP is
used in a similar fashion\&. The tools required for setting up a SLIP or
PPP link will be described in chapters 
.GETHN "slip"
\& and 
.GETHN "ppp"
\&\&.
.P 1
.H 3 "The Dummy Interface"
.SETR "iface.interface.dummy"
.INDEX {dummy interface}
.INDEX {interface!dummy}
.INDEX {standalone host}
.INDEX {host!standalone}
.INDEX {configuring!SLIP}
.INDEX {configuring!PPP}
.P 1
The dummy interface is really a little exotic, but rather useful
nevertheless\&. Its main benefit is with standalone hosts, and machines
whose only IP network connection is a dial-up link\&. In fact, the
latter are standalone hosts most of the time, too\&.
.P 1
The dilemma with standalone hosts is that they only have a single network
device active, the loopback device, which is usually assigned
the address \fB127\&.0\&.0\&.1\fR\&.  On some occasions, however, you need
to send data to the `official' IP address of the local host\&. For
instance, consider the laptop \fBvlite\fR, that has been disconnected
from any network for the duration of this example\&.  An application
on \fBvlite\fR may now want to send some data to another application on
the same host\&. Looking up \fBvlite\fR in \fI/etc/hosts\fR yields
an IP address of \fB191\&.72\&.1\&.65\fR, so the application tries to send
to this address\&. As the loopback interface is currently the only active
interface on the machine, the kernel has no idea that this address
actually refers to itself! As a consequence, the kernel discards the
datagram, and returns an error to the application\&.
.P 1
This is where the dummy device steps in\&. It solves the dilemma by
simply serving as the alter ego of the loopback interface\&.  In the
case of \fBvlite\fR, you would simply give it the address
\fB191\&.72\&.1\&.65\fR and add a host route pointing to it\&. Every datagram
for \fB191\&.72\&.1\&.65\fR would then be delivered locally\&. The proper
invocation is:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ifconfig dummy vlite
# route add vlite
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 2 "All About ifconfig"
.SETR "iface.ifconfig"
.INDEX {ifconfig@\fIifconfig\fR}
.P 1
There are a lot more parameters to \fIifconfig\fR than we have
described above\&. Its normal invocation is this:
.P 1
.P 1
.DS I F 5
\fBifconfig \fB\fIinterface\fB\fB [[-net|-host] \fB\fIaddress\fB\fB [\fB\fIparameters\fB\fB]]
\"
\fR
.DE
.P 1
\fB\fIinterface\fB\fR is the interface name, and \fB\fIaddress\fB\fR is the
IP address to be assigned to the interface\&.  This may either be an
IP address in dotted quad notation, or a name \fIifconfig\fR will look
up in \fI/etc/hosts\fR and \fI/etc/networks\fR\&.  The \fB-net\fR and
\fB-host\fR options force \fIifconfig\fR to treat the address as
network number or host address, respectively\&.
.P 1
.INDEX {display!interface configuration}
If \fIifconfig\fR is invoked with only the interface name, it displays
that interface's configuration\&. When invoked without any parameters, it
displays all interfaces you configured so far; an option of \fB-a\fR
forces it to show the inactive ones as well\&.  A sample invocation for the
Ethernet interface \fIeth0\fR may look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ifconfig eth0
eth0      Link encap 10Mbps Ethernet  HWaddr 00:00:C0:90:B3:42
          inet addr 191.72.1.2 Bcast 191.72.1.255 Mask 255.255.255.0
          UP BROADCAST RUNNING  MTU 1500  Metric 0
          RX packets 3136 errors 217 dropped 7 overrun 26
          TX packets 1752 errors 25 dropped 0 overrun 0

.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {Maximum Transfer Unit}
.INDEX {routing!metric}
The \fBMTU\fR and \fBMetric\fR fields show the current MTU and metric
value for that interface\&. The metric value is traditionally used by some
operating systems to compute the cost of a route\&. Linux doesn't use this
value yet, but defines it for compatibility nevertheless\&.
.P 1
The RX and TX lines show how many packets have been received or
transmitted error free, how many errors occurred, how many packets
were dropped, probably because of low memory, and how many were lost
because of an overrun\&. Receiver overruns usually happen when packets
come in faster than the kernel can service the last interrupt\&.  The
flag values printed by \fIifconfig\fR correspond more or less to the
names of its command line options; they will be explained below\&.
.P 1
The following is a list of parameters recognized by \fIifconfig\fR with
the corresponding flag names are given in brackets\&. Options that simply
turn on a feature also allow it to be turned off again by preceding the
option name by a dash (-)\&.
.P 1
\"
.BL 10
.LI "\fBup\fR"
This marks an interface ``up'', i\&.e\&. accessible to the IP layer\&.
This option is implied when an \fB\fIaddress\fB\fR is given on the
command line\&. It may also be used to re-eenable an interface
that has been taken down temporarily using the \fBdown\fR
option\&.
.P 1
.br
.ti 0
(This option corresponds to the flags \fBUP RUNNING\fR\&.)
.P 1
.LI "\fBdown\fR"
This marks an interface ``down'', i\&.e\&. inaccessible to the IP
layer\&. This effectively disables any IP traffic through the
interface\&.  Note that this does not delete all routing entries
that use this interface automatically\&.  If you take the
interface down permanently, you should to delete these routing
entries and supply alternative routes if possible\&.
.P 1
.LI "\fBnetmask\fR \fB\fImask\fB\fR"
.INDEX {IP!netmask}
.INDEX {interface!netmask}
This assigns a subnet mask to be used by the interface\&.  It may
be given as either a 32-bit hexadecimal number preceded by 0x,
or as a dotted quad of decimal numbers\&.
.P 1
.LI "\fBpointopoint\fR \fB\fIaddress\fB\fR"
.INDEX {point-to-point link}
This option is used for point-to-point IP links that involve
only two hosts\&. This option is needed to configure, for example,
SLIP or PLIP interfaces\&.
.P 1
.br
.ti 0
(If a point-to-point address has been set, \fIifconfig\fR
displays the \fBPOINTOPOINT\fR flag\&.)
.P 1
.LI "\fBbroadcast\fR \fB\fIaddress\fB\fR"
.INDEX {IP!broadcast address}
.INDEX {broadcast address}
.INDEX {address!broadcast}
The broadcast address is usually made up from the network number
by setting all bits of the host part\&. Some IP implementations
use a different scheme; this option is there to adapt to these
strange environments\&.
.P 1
.br
.ti 0
(If a broadcast address has been set, \fIifconfig\fR displays
the \fBBROADCAST\fR flag\&.)
.P 1
.LI "\fBmetric\fR \fB\fInumber\fB\fR"
.INDEX {Routing Information Protocol}
.INDEX {routing!metric}
.INDEX {IP!metric}
This option may be used to assign a metric value to the routing
table entry created for the interface\&. This metric is used
by the Routing Information Protocol (RIP) to build routing
tables for the network\&.(\*F)
.FS
.SETR "iface.interface.ifconfig.metric"
RIP chooses the optimal route to a given host based on the
``length'' of the path\&. It is computed by summing up the
individual metric values of each host-to-host link\&.  By
default, a hop has length 1, but this may be any positive
integer less than 16\&. (A route length of 16 is equal to
infinity\&. Such routes are considered unusable\&.) The
\fBmetric\fR parameter sets this hop cost, which is then
broadcast by the routing daemon\&.
.FE
The default metric used by \fIifconfig\fR is a value of
zero\&. If you don't run a RIP daemon, you don't need this
option at all; if you do, you will rarely need to change the
metric value\&.
.P 1
.LI "\fBmtu\fR \fB\fIbytes\fB\fR"
.INDEX {Maximum Transfer Unit}
.INDEX {MTU|see Maximum Transfer Unit}
.INDEX {IP!MTU|see Maximum Transfer Unit}
This sets the Maximum Transmission Unit, which is the maximum
number of octets the interface is able to handle in one
transaction\&. For Ethernets, the MTU defaults to 1500; for SLIP
interfaces, this is 296\&.
.P 1
.LI "\fBarp\fR"
.INDEX {disabling ARP}
.INDEX {enabling ARP}
.INDEX {ARP!enabling}
This is an option specific to broadcast networks such as
Ethernets or packet radio\&. It enables the use of ARP, the
Address Resolution Protocol, to detect the physical addresses
of hosts attached to the network\&. For broadcast networks, is
on by default\&.
.P 1
.br
.ti 0
(If ARP is disabled, \fIifconfig\fR displays the flag \fBNOARP\fR\&.)
.P 1
.LI "\fB-arp\fR"
Disables the use of ARP on this interface\&.
.P 1
.LI "\fBpromisc\fR"
.INDEX {Ethernet!promiscuous mode}
.INDEX {security!Ethernet}
Puts the interface in promiscuous mode\&. On a broadcast network,
this makes the interface receive all packets, regardless of whether
they were destined for another host or not\&. This allows an analysis
of network traffic using packet filters and such, also called
\fIEthernet snooping\fR\&.  Usually, this is a good technique
of hunting down network problems that are otherwise hard to
come by\&.
.P 1
On the other hand, this allows attackers to skim the traffic of
your network for passwords and do other nasty things\&. One
protection against this type of attack is not to let anyone
just plug in their computers in your Ethernet\&. Another
option is to use secure authentication protocols, such as
Kerberos, or the SRA login suite\&.(\*F)
.FS
SRA can be obtained from \fBftp\&.tamu\&.edu\fR in
\fI/pub/sec/TAMU\fR\&.
.FE
.P 1
.br
.ti 0
(This option corresponds to the flag \fBPROMISC\fR\&.)
.P 1
.LI "\fB-promisc\fR"
Turns off promiscuous mode\&.
.P 1
.LI "\fBallmulti\fR"
.INDEX {IP!multicast addresses}
Multicast addresses are some sort of broadcast to a group of
hosts who don't necessarily have to be on the same subnet\&.
Multicast addresses are not yet supported by the kernel\&.
.P 1
.br
.ti 0
(This option corresponds to the flag \fBALLMULTI\fR\&.)
.P 1
.LI "\fB-allmulti\fR"
Turns off multicast addresses\&.
.P 1
\"
.LE
.P 1
.H 2 "Checking with netstat"
.SETR "iface.netstat"
.INDEX {netstat@\fInetstat\fR|(}
.P 1
Next, I will turn to a useful tool for checking your network
configuration and activity\&. It is called \fInetstat\fR and is, in
fact, rather a collection of several tools lumped together\&. We will
discuss each of its functions in the following sections\&.
.P 1
.H 3 "Displaying the Routing Table"
.SETR "iface.netstat.-r"
.INDEX {IP!routing table}
.INDEX {checking!the routing table}
.INDEX {display!IP routing table}
.INDEX {routing!table}
.P 1
When invoking \fInetstat\fR with the \fB-r\fR flag, it displays the
kernel routing table in the way we've been doing this with \fIroute\fR
above\&.  On \fBvstout\fR, it produces:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# netstat -nr
Kernel routing table
Destination     Gateway         Genmask         Flags Metric Ref Use    Iface
127.0.0.1       *               255.255.255.255 UH    1      0       50 lo
191.72.1.0      *               255.255.255.0   U     1      0      478 eth0
191.72.2.0      191.72.1.1      255.255.255.0   UGN   1      0      250 eth0
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fB-n\fR option makes \fInetstat\fR print addresses as dotted
quad IP numbers rather than the symbolic host and network names\&. This is
especially useful when you want to avoid address lookups over the network
(e\&.g\&. to a DNS or NIS server)\&.
.P 1
The second column of \fInetstat\fR's output shows the gateway the
routing entry points to\&. If no gateway is used, an asterisk is printed
instead\&. Column three shows the ``generality'' of the route\&. When given
an IP address to find a suitable route for, the kernel goes through all
routing table entries, taking the bitwise AND of the address and the
genmask before comparing it to the target of the route\&.
.P 1
The fourth column displays various flags that describe the route:
.P 1
\"
.BL 10
.LI "G"
The route uses a gateway\&.
.P 1
.LI "U"
The interface to be used is up\&.
.P 1
.LI "H"
Only a single host can be reached through the route\&. For
example, this is the case for the loopback entry
\fB127\&.0\&.0\&.1\fR\&.
.P 1
.LI "D"
This is set if the table entry has been generated
by an ICMP redirect message (see section 
.GETHN "tcpip.icmp"
\&)\&.
.P 1
.LI "M"
This is set if the table entry was modified by an ICMP
redirect message\&.
\"
.LE
.P 1
The \fBRef\fR column of \fInetstat\fR's output shows the number of
references to this route, that is, how many other routes (e\&.g\&. through
gateways) rely on the presence of this route\&. The last two columns show
the number of times the routing entry has been used, and the interface
that datagrams are passed to for delivery\&.
.P 1
.H 3 "Displaying Interface Statistics"
.SETR "iface.netstat.-i"
.INDEX {display!interface statistics}
.INDEX {interface!statistics}
.INDEX {checking!network interface}
.P 1
When invoked with the \fB-i\fR flag, \fInetstat\fR will display
statistics for the network interfaces currently configured\&. If, in
addition, the \fB-a\fR option is given, it will print \fIall\fR
interfaces present in the kernel, not only those that have been
configured currently\&. On \fBvstaout\fR, the output from \fInetstat\fR
will look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ netstat -i
Kernel Interface table
Iface   MTU Met  RX-OK RX-ERR RX-DRP RX-OVR  TX-OK TX-ERR TX-DRP TX-OVR Flags
lo        0   0   3185      0      0      0   3185      0      0      0 BLRU
eth0   1500   0 972633     17     20    120 628711    217      0      0 BRU
.ENDVERBATIM
\"
\fR
.DE
.P 1
The MTU and Met fields show the current MTU and metric value for that
interface\&. The RX and TX columns show how many packets have been
received or transmitted error free (RX-OK/TX-OK), damaged
(RX-ERR/TX-ERR), how many were dropped (RX-DRP/TX-DRP), and how many
were lost because of an overrun (RX-OVR/TX-OVR)\&.
.P 1
The last column shows the flags that have been set for this interface\&.
These are one-character versions of the long flag names the are printed
when you display the interface configuration with \fIifconfig\fR\&.
.P 1
\"
.BL 10
.LI "B"
A broadcast address has been set\&.
.LI "L"
This interface is a loopback device
.LI "M"
All packets are received (promiscuous mode)\&.
.LI "N"
Trailers are avoided\&.
.LI "O"
ARP is turned off for this interface\&.
.LI "P"
This is a point-to-point connection\&.
.LI "R"
Interface is running\&.
.LI "U"
Interface is up\&.
\"
.LE
.P 1
.H 3 "Displaying Connections"
.SETR "iface.netstat.-t-u-x"
.INDEX {display!active connections}
.INDEX {network!display connections}
.INDEX {connections, display}
.INDEX {checking!network connections}
.INDEX {checking!TCP server activity}
.P 1
\fInetstat\fR supports a set of options to display active or passive
sockets\&. The options \fB-t\fR, \fB-u\fR, \fB-w\fR, and
\fB-x\fR show active TCP, UDP, RAW, or UNIX socket connections\&.
If you provide the \fB-a\fR flag in addition, sockets that are
waiting for a connection (i\&.e\&. listening) are displayed as well\&.
This will give you a list of all servers that are currently running
on your system\&.
.P 1
Invoking \fInetstat -ta\fR on \fBvlager\fR produces
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ netstat -ta
Active Internet connections
Proto Recv-Q Send-Q Local Address    Foreign Address    (State)
tcp        0      0 *:domain         *:*                LISTEN  
tcp        0      0 *:time           *:*                LISTEN  
tcp        0      0 *:smtp           *:*                LISTEN  
tcp        0      0 vlager:smtp      vstout:1040        ESTABLISHED  
tcp        0      0 *:telnet         *:*                LISTEN  
tcp        0      0 localhost:1046   vbardolino:telnet  ESTABLISHED  
tcp        0      0 *:chargen        *:*                LISTEN  
tcp        0      0 *:daytime        *:*                LISTEN  
tcp        0      0 *:discard        *:*                LISTEN  
tcp        0      0 *:echo           *:*                LISTEN  
tcp        0      0 *:shell          *:*                LISTEN  
tcp        0      0 *:login          *:*                LISTEN  
.ENDVERBATIM
\"
\fR
.DE
.P 1
This shows most servers simply waiting for an incoming connection\&. However,
the fourth line shows an incoming SMTP connection from \fBvstout\fR, and
the sixth line tells you there is an outgoing \fItelnet\fR connection
to \fBvbardolino\fR\&.(\*F)
.FS
You can tell whether a connection is outgoing or not from the port
numbers involved\&. The port number shown for the \fIcalling\fR host
will always be a simple integer, while on the host being called, a
well-known service port will be in use, for which \fInetstat\fR uses
the symbolic name found in \fI/etc/services\fR\&.
.FE
.P 1
Using the \fB-a\fR flag all by itself will display all sockets
from all families\&.
.P 1
.INDEX {netstat@\fInetstat\fR|)}
.P 1
.H 2 "Checking the ARP Tables"
.SETR "iface.verify.arp"
.INDEX {checking!Ethernet interface}
.INDEX {checking!ARP tables}
.INDEX {ARP!display table}
.INDEX {display!ARP table}
.P 1
On some occasions, it is useful to view or even alter the contents of
the kernel's ARP tables, for example when you suspect a duplicate
Internet address is the cause for some intermittent network problem\&.
The \fIarp\fR tool was made for things like these\&.  Its command line
options are
.P 1
.P 1
.DS I F 5
\fBarp [-v] [-t \fB\fIhwtype\fB\fB] -a [\fB\fIhostname\fB\fB]           
.br
arp [-v] [-t \fB\fIhwtype\fB\fB] -s \fB\fIhostname\fB\fB \fB\fIhwaddr\fB\fB
.br
arp [-v] -d \fB\fIhostname\fB\fB [\fB\fIhostname\fB\fB\&.\&.\&.]    
\"
\fR
.DE
.P 1
All \fB\fIhostname\fB\fR arguments may be either symbolic host names or
IP addresses in dotted quad notation\&.
.P 1
The first invocation displays the ARP entry for the IP address or host
specified, or all hosts known if no \fB\fIhostname\fB\fR is given\&.  For example,
invoking \fIarp\fR on \fBvlager\fR may yield
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# arp -a
IP address      HW type                 HW address
191.72.1.3      10Mbps Ethernet         00:00:C0:5A:42:C1
191.72.1.2      10Mbps Ethernet         00:00:C0:90:B3:42
191.72.2.4      10Mbps Ethernet         00:00:C0:04:69:AA
.ENDVERBATIM
\"
\fR
.DE
.P 1
.br
.ti 0
which shows the Ethernet addresses of \fBvlager\fR, \fBvstout\fR and
\fBvale\fR\&.
.P 1
Using the \fB-t\fR option you can limit the display to the hardware
type specified\&.  This may be \fIether\fR, \fIax25\fR, or
\fIpronet\fR, standing for 10Mbps Ethernet, AMPR AX\&.25, and IEEE 802\&.5
token ring equipment, respectively\&.
.P 1
The \fB-s\fR option is used to permanently add \fB\fIhostname\fB\fR's
Ethernet address to the ARP tables\&. The \fB\fIhwaddr\fB\fR argument specifies
the hardware address, which is by default expected to be an Ethernet
address, specified as six hexadecimal bytes separated by colons\&.  You
may also set the hardware address for other types of hardware, too,
using the \fB-t\fR option\&.
.P 1
One problem which may require you to manually add an IP address to the
ARP table is when for some reasons ARP queries for the remote host fail,
for instance when its ARP driver is buggy or there is another host in
the network that erroneously identifies itself with that host's
IP address\&.  Hard-wiring IP addresses in the ARP table is also a (very
drastic) measure to protect yourself from hosts on your Ethernet that
pose as someone else\&.
.P 1
Invoking \fIarp\fR using the \fB-d\fR switch deletes all ARP entries
relating to the given host\&.  This may be used to force the interface to
re-attempt to obtain the Ethernet address for the IP address in question\&.
This is useful when a misconfigured system has broadcast wrong ARP
information (of course, you have to reconfigure the broken host before)\&.
.P 1
.INDEX {point-to-point link}
.INDEX {routing!proxy ARP}
.INDEX {routing!dynamic}
.INDEX {proxy ARP}
.INDEX {ARP!proxy}
.INDEX {SLIP!routing}
.INDEX {PLIP!routing}
.INDEX {PPP!routing}
The \fB-s\fR option may also be used to implement \fIproxy\fR ARP\&.
This is a special technique where a host, say \fBgate\fR, acts as a
gateway to another host named \fBfnord\fR, by pretending that both
addresses refer to the same host, namely \fBgate\fR\&. It does so by
publishing an ARP entry for \fBfnord\fR that points to its own Ethernet
interface\&. Now when a host sends out an ARP query for \fBfnord\fR,
\fBgate\fR will return a reply containing its own Ethernet address\&. The
querying host will then send all datagrams to \fBgate\fR, which
dutyfully forwards them to \fBfnord\fR\&.
.P 1
These contortions may be necessary, for instance, when you want to
access \fBfnord\fR from a DOS machine with a broken TCP implementation
that doesn't understand routing too well\&. When you use proxy ARP, it will
appear to the DOS machine as if \fBfnord\fR was on the local subnet,
so it doesn't have to know about how to route through a gateway\&.
.P 1
Another very useful application of proxy ARP is when one of your hosts
acts as a gateway to some other host only temporarily, for instance
through a dial-up link\&. In a previous example, we already encountered
the laptop \fBvlite\fR which was connected to \fBvlager\fR through a
PLIP link only from time to time\&.  Of course, this will work only if the
address of the host you want to provide proxy ARP for is on the same
IP subnet as your gateway\&. For instance, \fBvstout\fR could proxy ARP
for any host on the Brewery subnet (\fB191\&.72\&.1\&.0\fR), but never for a
host on the Winery subnet (\fB191\&.72\&.2\&.0\fR)\&.
.P 1
The proper invocation to provide proxy ARP for \fBfnord\fR is given
below; of course, the Ethernet address given must be that of \fBgate\fR\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# arp -s fnord 00:00:c0:a1:42:e0 pub
.ENDVERBATIM
\"
\fR
.DE
.P 1
The proxy ARP entry may be removed again by invoking:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# arp -d fnord
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 2 "The Future"
.P 1
Linux networking is still evolving\&.  Major changes at the kernel
layer will bring a very flexible configuration scheme that will allow
you to configure the network devices at run time\&.  For instance, the
\fIifconfig\fR command will take arguments that set the IRQ line and
DMA channel\&.
.P 1
.INDEX {Maximum Transfer Unit}
.INDEX {route@\fIroute\fR}
Another change to come soon is the additional \fBmtu\fR flag to the
\fIroute\fR command which will set the Maximum Transmission Unit for a 
particular route\&.  This route-specific MTU overrides the MTU specified
for the interface\&.  You will typically use this option for routes
through a gateway, where the link between the gateway and the
destination host requires a very low MTU\&. For instance, assume 
host \fBwanderer\fR is connected to \fBvlager\fR through a SLIP link\&.
When sending data from \fBvstout\fR to \fBwanderer\fR, the
networking layer on \fBwanderer\fR would would use packets of up to
1500 bytes, because packets are sent across the Ethernet\&. The SLIP
link, on the other hand, is operated with an MTU of 296, so the network
layer on \fBvlager\fR would have to break up the IP packets into
smaller fragments that fit into 296 bytes\&. If instead, you would have
configured the route on \fBvstout\fR to use a MTU of 296 right from
the start, this relatively expensive fragmentation could be avoided:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# route add wanderer gw vlager mtu 296
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {Subnets Are Local@`Subnets Are Local' Policy}
Note that the \fBmtu\fR option also allows you to selectively undo
the effects of the `Subnets Are Local' Policy (SNARL)\&. This policy is
a kernel configuration option and is described in chapter 
.GETHN "hardware"
\&\&.
.P 1
.H 1 "Name Service and Resolver Configuraton"
.SETR "resolv"
.P 1
.SETR "resolv.intro"
.INDEX {configuring!hostname resolution|(}
.INDEX {hostname!resolution}
.P 1
As discussed in chapter 
.GETHN "tcpip"
\&, TCP/IP networking may rely on
different schemes to convert names into addresses\&.  The simplest way,
which takes no advantage of the way the name space has been split up
into zones is a host table stored in \fI/etc/hosts\fR\&.  This is
useful only for small LANs that are run by one single administrator,
and otherwise have no IP traffic with the outside world\&.  The format
of the \fIhosts\fR file has already been described in
chapter 
.GETHN "iface"
\&\&.
.P 1
.INDEX {Berkeley Internet Name Domain}
.INDEX {BIND}
.INDEX {named@\fInamed\fR}
Alternatively, you may use BIND -- the Berkeley Internet Name Domain
Service --  for resolving host names to IP addresses\&.  Configuring BIND
may be a real chore, but once you've done it, changes in the network
topology are easily made\&. On Linux, as on many other Un*xish
systems, name service is provided through a program called \fInamed\fR\&.
At startup, it loads a set of  master files into its cache, and waits
for queries from remote or local user processes\&. There are different
ways to set up BIND, and not all require you to run a name server on
every host\&.
.P 1
This chapter can do little more but give a rough sketch of how to
operate a name server\&. If you plan to use BIND in an enviroment with
more than just a small LAN and probably an Internet uplink, you should
get a good book on BIND, for instance Cricket Liu's ``DNS and BIND''
(see [
GETST "liu-dns"
])\&. For current information, you may also want to
check the release notes contained in the BIND sources\&. There's also a
newsgroup for DNS questions called \fBcomp\&.protocols\&.tcp-ip\&.domains\fR\&.
.P 1
.H 2 "The Resolver Library"
.SETR "resolv.library"
.INDEX {resolver!library}
.P 1
When talking of ``the resolver'', we do not mean any special
application, but rather refer to the \fIresolver library\fR, a
collection of functions that can be found in the standard C library\&. The
central routines are \fIgethostbyname(2)\fR and \fIgethostbyaddr(2)\fR
which look up all IP addresses belonging to a host, and vice versa\&.
They may be configured to simply look up the information in
\fIhosts\fR, query a number of name servers, or use the \fIhosts\fR
database of NIS (Network Information Service)\&.  Other applications, like
\fIsmail\fR, may include different drivers for any of these, and need
special care\&.
.P 1
.H 3 "The host\&.conf File"
.SETR "resolv.host-conf"
.INDEX {resolver!using NIS}
.INDEX {resolver!using a name server}
.INDEX {resolver!configuring|(}
.INDEX {host\&.conf@\fIhost\&.conf\fR}
.P 1
The central file that controls your resolver setup is \fIhost\&.conf\fR\&.
It resides in \fI/etc\fR and tells the resolver which services
to use, and in what order\&.
.P 1
Options in \fIhost\&.conf\fR must occur on separate lines\&. Fields may be
separated by white space (spaces or tabs)\&. A hash sign (\fI#\fR)
introduces a comment that extends to the next newline\&.
.P 1
The following options are available:
\"
.BL 10
.LI "\fIorder\fR"
.INDEX {NIS!and the resolver}
.INDEX {order of resolver services used}
This determines the order in which the resolving services are
tried\&. Valid options are \fIbind\fR for querying the name
server, \fIhosts\fR for lookups in \fI/etc/hosts\fR, and
\fInis\fR for NIS lookups\&.  Any or all of them may be
specified\&. The order in which they appear on the line detemines
the order in which the respective services are tried\&.
.P 1
.LI "\fImulti\fR"
Takes \fIon\fR or \fIoff\fR as options\&. This detemines
if a host in \fI/etc/hosts\fR is allowed to have several
IP addresses, which is usually referred to as being
``multi-homed''\&. This flag has no effect on DNS or NIS queries\&.
.P 1
.LI "\fInospoof\fR"
.INDEX {security!false hostnames}
.INDEX {security!spoofing}
.INDEX {prevent spoofing}
.INDEX {spoofing}
As explained in the previous chapter, DNS allows you to find the
hostname belonging to an IP address by using the
\fBin-addr\&.arpa\fR domain\&. Attempts by name servers to supply a
false hostname are called ``\fIspoofing\fR''\&. To guard against
this, the resolver may be configured to check if the original
IP address is in fact associated with the hostname obtained\&. If
not, the name is rejected and an error returned\&. This behavior
is turned on by setting \fInospoof on\fR\&.
.P 1
.LI "\fIalert\fR"
This option takes \fIon\fR or \fIoff\fR as arguments\&.
If it is turned on, any spoof attempts (see above) will cause
the resolver to log a message to the \fIsyslog\fR facility\&.
.P 1
.LI "\fItrim\fR"
This option takes a domain name as an argument, which will be
removed from hostnames before lookup\&. This is useful for
\fIhosts\fR entries, where you might only want to specify
hostnames without local domain\&.  A lookup of a host with the
local domain name appended will have this removed, thus allowing
the lookup in \fI/etc/hosts\fR to succeed\&.
.P 1
\fItrim\fR options accumulate, making it possible to consider 
your host as being local to several domains\&.
\"
.LE
.P 1
A sample file for \fBvlager\fR is shown below:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /etc/host.conf
# We have named running, but no NIS (yet)
order   bind hosts
# Allow multiple addrs
multi   on
# Guard against spoof attempts
nospoof on
# Trim local domain (not really necessary).
trim    vbrew.com.
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "Resolver Environment Variables"
.SETR "resolv.environ"
.INDEX {resolver!environment variables}
.P 1
The settings from \fIhost\&.conf\fR may be overridden using a number
of environment variables\&. These are
.P 1
\"
.BL 10
.LI "\fBRESOLV_HOST_CONF\fR"
This specifies a file to be read instead of \fI/etc/host\&.conf\fR\&.
.P 1
.LI "\fBRESOLV_SERV_ORDER\fR"
Overrides the \fIorder\fR option given in \fIhost\&.conf\fR\&.
Services are given as \fIhosts\fR, \fIbind\fR, and
\fInis\fR, separated by a space, comma, colon, or semicolon\&.
.P 1
.LI "\fBRESOLV_SPOOF_CHECK\fR"
Determines the measures taken against spoofing\&. It is completely
disabled by \fIoff\fR\&.  The values \fIwarn\fR and
\fIwarn off\fR enable spoof checking, but turn logging on
and off, respectively\&. A value of \fI*\fR turns on spoof
checks, but leaves the logging facility as defined in
\fIhost\&.conf\fR\&.
.P 1
.LI "\fBRESOLV_MULTI\fR"
A value of \fIon\fR or \fIoff\fR may be used to override the \fImulti\fR
options from tt host\&.conf\&.
.P 1
.LI "\fBRESOLV_OVERRIDE_TRIM_DOMAINS\fR"
This environment specifies a list of trim domains which override
those given in \fIhost\&.conf\fR\&.
.P 1
.LI "\fBRESOLV_ADD_TRIM_DOMAINS\fR"
This environment specifies a list of trim domains which are added
to those given in \fIhost\&.conf\fR\&.
.P 1
\"
.LE
.P 1
.H 3 "Configuring Name Server Lookups --- resolv\&.conf"
.SETR "resolv.resolv"
.INDEX {configuring!use of name server}
.INDEX {resolv\&.conf@\fIresolv\&.conf\fR}
.P 1
When configuring the resolver library to use the BIND name service for
host lookups, you also have to tell it which name servers to use\&.
There is a separate file for this, called \fIresolv\&.conf\fR\&.
If this file does not exist or is empty, the resolver assumes the
name server is on your local host\&.
.P 1
If you run a name server on your local host, you have to set it up
separately, as will be explained in the following section\&.
If your are on a local network and have the opportunity to use an
existing nameserver, this should always be preferred\&.
.P 1
The most important option in \fIresolv\&.conf\fR is \fInameserver\fR,
which gives the IP address of a name server to use\&. If you specifiy
several name servers by giving the \fInameserver\fR option several
times, they are tried in the order given\&. You should therefore put the
most reliable server first\&.  Currently, up to three name servers are
supported\&.
.P 1
If no \fInameserver\fR option is given, the resolver attempts
to connect to the name server on the local host\&.
.P 1
.INDEX {domain name!default}
.INDEX {configuring!default domain}
Two other options, \fIdomain\fR and \fIsearch\fR deal with default
domains that are tacked onto a hostname if BIND fails to resolve it
with the first query\&. The \fIsearch\fR option specifies a list of
domain names to be tried\&. The list items are separated by spaces
or tabs\&.
.P 1
If no \fIsearch\fR option is given, a default search list is constructed
from the local domain name by using the domain name itself, plus all
parent domains up to the root\&. The local domain name may be given using
the \fIdomain\fR statement; if none is given, the resolver obtains
it through the \fIgetdomainname(2)\fR system call\&.
.P 1
.br
.ti 0
If this sounds confusing to you, consider this sample \fIresolv\&.conf\fR
file for the Virtual Brewery:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /etc/resolv.conf
# Our domain
domain         vbrew.com
#
# We use vlager as central nameserver:
nameserver     191.72.1.1
.ENDVERBATIM
\"
\fR
.DE
.P 1
When resolving the name \fBvale\fR, the resolver would look up
\fBvale\fR, and failing this, \fBvale\&.vbrew\&.com\fR, and
\fBvale\&.com\fR\&.
.P 1
.H 3 "Resolver Robustness"
.SETR "resolv.robustness"
.INDEX {resolver!robustness}
.P 1
If you are running a LAN inside a larger network, you definitely should
use central name servers if they are available\&. The advantage of this is
that these will develop rich caches, since all queries are forwarded to
them\&. This scheme, however has a drawback: when a fire recently
destroyed the backbone cable at our university, no more work was
possible on our department's LAN, because the resolver couldn't reach
any of the name servers anymore\&. There was no logging in on X terminals
anymore, no printing, etc\&.
.P 1
Although it is not very common for campus backbones to go down in 
flames, one might want to take precautions against cases like these\&.
.P 1
One option is to set up a local name server that resolves hostnames from
your local domain, and forwards all queries for other hostnames to the
main servers\&. Of course, this is applicable only if you are running
your own domain\&.
.P 1
Alternatively, you can maintain a backup host table for your domain
or LAN in \fI/etc/hosts\fR\&. In \fI/etc/host\&.conf\fR you would then
include ``\fIorder bind hosts\fR'' to make the resolver fall
back to the hosts file if the central name server is down\&.
.P 1
.INDEX {resolver!configuring|)}
.P 1
.H 2 "Running named"
.SETR "resolv.named"
.INDEX {named@\fInamed\fR|(}
.INDEX {name server!configuring|(}
.INDEX {configuring!name server|(}
.INDEX {DNS!configuring server|(}
.INDEX {BIND|(}
.P 1
The program that provides domain name service on most Un*x machines is
usually called \fInamed\fR (pronounced \fIname-dee\fR)\&. This is a
server program originally developed for BSD providing name service to
clients, and possibly to other name servers\&. The version currently 
used on most Linux installations seems to be BIND-4\&.8\&.3\&. The new
version, BIND-4\&.9\&.3, is being Beta-tested at the moment, and should be
available on Linux soon\&.
.P 1
This section requires some understanding of the way the Domain Name
System works\&. If the following discussion is all Greek to you, you may
want to re-read chapter 
.GETHN "tcpip"
\&, which has some more information
on the basics of DNS\&.
.P 1
.INDEX {named\&.boot@\fInamed\&.boot\fR|(}
\fInamed\fR is usually started at system boot time, and runs until
the machine goes down again\&.  It takes its information from a
configuration file called \fI/etc/named\&.boot\fR, and various files
that contain data mapping domain names to addresses and the like\&. The
latter are called \fIzone files\fR\&.  The formats and semantics of
these files will be explained in the following section\&.
.P 1
To run \fInamed\fR, simply enter 
.P 1
.P 1
.DS I F 5
\fB# /usr/sbin/named
\"
\fR
.DE
.P 1
.br
.ti 0
at the prompt\&. \fInamed\fR will come up, read the \fInamed\&.boot\fR
file and any zone files specified therein\&. It writes its process id to
\fI/var/run/named\&.pid\fR in ASCII, downloads any zone files from primary
servers, if necessary, and starts listening on port 53 for DNS
queries\&.(\*F)
.FS
There are various \fInamed\fR binaries floating around Linux FTP
sites, each configured a little differently\&. Some have their pid file
in \fI/etc\fR, some store it in \fI/tmp\fR or \fI/var/tmp\fR\&.
.FE
.P 1
.H 3 "The named\&.boot File"
The \fInamed\&.boot\fR file is generally very small and contains little
else but pointers to master files containing zone information, and
pointers to other name servers\&.  Comments in the boot file start with a
semicolon and extend to the next newline\&.
Before we discuss the format of \fInamed\&.boot\fR in more detail, we
will take a look at the sample file for \fBvlager\fR given in
figure 
.GETHN "resolv.fig.named.boot"
\&\&.(\*F)
.FS
Note that the domain names in this example are given \fIwithout\fR
trailing dot\&. Earlier versions of \fInamed\fR seem to treat trailing
dots in \fInamed\&.boot\fR as an error, and silently discards the
line\&. BIND-4\&.9\&.3 is said to fix this\&.
.FE
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
;
; /etc/named.boot file for vlager.vbrew.com
;
directory     /var/named
;
;             domain                   file
;---------------------------------------------------
cache         .                        named.ca
primary       vbrew.com                named.hosts
primary       0.0.127.in-addr.arpa     named.local
primary       72.191.in-addr.arpa      named.rev
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " The \fInamed\&\&.boot\fR file for \fIvlager\fR\&\&. " "" 0 "resolv.fig.named.boot"
.DE
.P 1
The \fIcache\fR and \fIprimary\fR commands shown in this
example load information into \fInamed\fR\&. This information is taken
from the master files specified in the second argument\&. They contain
textual representations of DNS resource records, which we will look at
below\&.
.P 1
In this example, we configured \fInamed\fR as the primary name server
for three domains, as indicated by the \fIprimary\fR statements
at the end of the file\&. The first of these lines, for instance, instructs
\fInamed\fR to act as a primary server for \fBvbrew\&.com\fR, taking the
zone data from the file \fInamed\&.hosts\fR\&. The \fIdirectory\fR
keyword tells it that all zone files are located in \fI/var/named\fR\&.
.P 1
The \fIcache\fR entry is very special and should be present on
virtually all machines running a name server\&. Its function is
two-fold: it instructs \fInamed\fR to enable its cache, and to load
the \fIroot name server hints\fR from the cache file specified
(\fInamed\&.ca\fR in our example)\&. We will come back to the name server
hints below\&.
.P 1
Here's a list of the most important options you can use in
\fInamed\&.boot\fR:
.P 1
\"
.BL 10
.LI "\fIdirectory\fR"
This specifies a directory in which zone files reside\&.
Names of files may be given relative to this directory\&.
Several directories may be specified by repeatedly using
\fIdirectory\fR\&. According to the Linux filesystem
standard, this should be \fI/var/named\fR\&.
.P 1
.LI "\fIprimary\fR"
.INDEX {primary (BIND option)@\fIprimary\fR (BIND option)}
.INDEX {name server!primary}
This takes a \fB\fIdomain name\fB\fR and a \fB\fIfile name\fB\fR as an
argument, declaring the local server authoritative for the named
domain\&. As a primary server, \fInamed\fR loads the zone
information from the given master file\&.
.P 1
Generally, there will always be at least one \fIprimary\fR
entry in every boot file, namely for reverse mapping of network
\fB127\&.0\&.0\&.0\fR, which is the local loopback network\&.
.P 1
.LI "\fIsecondary\fR"
.INDEX {secondary (BIND option)@\fIsecondary\fR (BIND option)}
.INDEX {name server!secondary}
This statement takes a \fB\fIdomain name\fB\fR, an \fB\fIaddress
list\fB\fR, and a \fB\fIfile name\fB\fR as an argument\&. It declares the
local server a secondary master server for the domain specified\&.
.P 1
A secondary server holds authoritative data on the domain,
too, but it doesn't gather it from files, but tries
to download it from the primary server\&. The IP address of
at least one primary server must thus be given to
\fInamed\fR in the address list\&. The local server will
contact each of them in turn until it successfully transfers
the zone database, which is then stored in the backup file
given as the third argument\&.
If none of the primary servers responds, the zone data is
retrieved from the backup file instead\&.
.P 1
\fInamed\fR will then attempt to refresh the zone data
at regular intervals\&. This is explained below along in
connection with the SOA resource record type\&.
.P 1
.LI "\fIcache\fR"
.INDEX {cache (BIND option)@\fIcache\fR (BIND option)}
.INDEX {name server!cache}
This takes a \fB\fIdomain\fB\fR and a \fB\fIfile name\fB\fR as arguments\&.
This file contains the root server hints, that is a list of
records pointing to the root name servers\&. Only NS and A
records will be recognized\&. The \fB\fIdomain\fB\fR
argument is generally the root domain name ``\fI\&.\fR''\&.
.P 1
This information is absolutely crucial to \fInamed\fR:
if the \fIcache\fR statement does not occur in the boot
file, \fInamed\fR will not develop a local cache at all\&. This
will severely degrade performance and increase network load if
the next server queried is not on the local net\&. Moreover, 
\fInamed\fR will not be able to reach any root name servers,
and thus it won't resolve any addresses except those it is authoritative
for\&. An exception from this rule is when using forwarding
servers (cf\&. the \fIforwarders\fR option below)\&.
.P 1
.LI "\fIforwarders\fR"
This statement takes an \fB\fIaddress list\fB\fR as an argument\&.
The IP addresses in this list specify a list of name servers
that \fInamed\fR may query if it fails to resolve a
query from its local cache\&. They are tried in order until
one of them responds to the query\&.
.P 1
.LI "\fIslave\fR"
.INDEX {name server!slave}
This statement makes the name server a \fIslave\fR server\&. That
is, it will never perform recursive queries itself, but only
forwards them to servers specified with the \fIforwarders\fR
statement\&.
.P 1
\"
.LE
.P 1
There are two options which we will not describe here, being
\fIsortlist\fR and \fIdomain\fR\&.  Additionally, there are two
directives that may be used inside the zone database files\&. These are
\fI$INCLUDE\fR and \fI$ORIGIN\fR\&.  Since they are rarely
needed, we will not describe them here, either\&.
.P 1
.INDEX {named\&.boot@\fInamed\&.boot\fR|)}
.P 1
.H 3 "The DNS Database Files"
Master files included by \fInamed\fR, like \fInamed\&.hosts\fR, always
have a domain associated with them, which is called the \fIorigin\fR\&.
This is the domain name specified with the \fIcache\fR and
\fIprimary\fR commands\&. Within a master file, you are allowed to
specify domain and host names relative to this domain\&.  A name given in
a configuration file is considered \fIabsolute\fR if it ends in a single
dot, otherwise it is considered relative to the origin\&.  The origin all
by itself may be referred to using ``\fI@\fR''\&.
.P 1
.INDEX {DNS!resource record}
All data contained in a master file is split up in \fIresource
records\fR, or RRs for short\&. They make up the smallest unit of
information available through DNS\&. Each resource record has a type\&. A
records, for instance, map a hostname to an IP address, and a CNAME
record associates an alias for a host with its official hostname\&. As
an example, take a look at figure 
.GETHN "resolv.fig.named.hosts"
\& on
page 
.GETPN "resolv.fig.named.hosts"
, which shows the
\fInamed\&.hosts\fR master file for the virtual brewery\&.
.P 1
Resource record representations in master files share a
common format, which is
.P 1
.P 1
.DS I F 5
\fB\fI[\fB\fIdomain\fB\fI] [\fB\fIttl\fB\fI] [\fB\fIclass\fB\fI] \fB\fItype\fB\fI \fB\fIrdata\fB\fI
\"
\fB\fR
.DE
.P 1
Fields are separated by spaces or tabs\&. An entry may be continued
across several lines if an opening brace occurs before the first newline,
and the last field is followed by a closing brace\&. Anything
between a semicolon and a newline is ignored\&.
.P 1
\"
.BL 10
.LI "\fB\fIdomain\fB\fR"
This is the domain name to which the entry applies\&. If no domain
name is given, the RR is assumed to apply to the domain of the
previous RR\&.
.P 1
.LI "\fB\fIttl\fB\fR"
.INDEX {DNS!time to live}
In order to force resolvers to discard information after a
certain time, each RR is associated a ``\fItime to live\fR'', or
\fIttl\fR for short\&. The \fB\fIttl\fB\fR field specifies the time in
seconds the information is valid after it has been retrieved
from the server\&. It is a decimal number with at most eight
digits\&.
.P 1
If no \fB\fIttl\fB\fR value is given, it defaults to the value of the
\fB\fIminimum\fB\fR field of the preceding SOA record\&.
.P 1
.LI "\fB\fIclass\fB\fR"
This is an address class, like IN for IP addresses, or HS for
objects in the Hesiod class\&. For TCP/IP networking, you have to
make this IN\&.
.P 1
If no \fB\fIclass\fB\fR field is given, the class of the preceding RR
is assumed\&.
.P 1
.LI "\fB\fItype\fB\fR"
This describes the type of the RR\&. The most common types are A,
SOA, PTR, and NS\&.  The following sections describe the various
types of RR's\&.
.P 1
.LI "\fB\fIrdata\fB\fR"
This holds the data associated with the RR\&. The format of this
field depends on the type of the RR\&. Below, it will be described
for each RR separately\&.
.P 1
\"
.LE
.P 1
.SP 3
.br
.ti 0
The following is an incomplete list of RRs to be used in DNS master
files\&. There are a couple more of them, which we will not explain\&.
They are experimental, and of little use generally\&.
.P 1
\"
.BL 10
.LI "SOA"
.INDEX {authoritative name server}
.INDEX {SOA (DNS record)}
.INDEX {DNS!zone}
.P 1
This describes a zone of authority (SOA means ``Start of
Authority'')\&. It signals that the records following the SOA
RR contain authoritative information for the domain\&. Every master file
included by a \fIprimary\fR statement must contain an SOA
record for this zone\&. The resource data contains the following fields:
.P 1
\"
.BL 10
.LI "\fB\fIorigin\fB\fR"
This is the canonical hostname of the primary name server
for this domain\&. It is usually given as an absolute name\&.
.P 1
.LI "\fB\fIcontact\fB\fR"
This is the email address of the person responsible for
maintaining the domain, with the `\fI@\fR' character
replaced by a dot\&. For instance, if the responsible person at
the Virtual Brewery is \fBjanet\fR, then this field would
contain \fIjanet\&.vbrew\&.com\fR\&.
.P 1
.LI "\fB\fIserial\fB\fR"
This is the version number of the zone file, expressed as a
single decimal number\&. Whenever data is changed in the zone
file, this number should be incremented\&.
.P 1
The serial number is used by secondary name servers to recognize
when zone information has changed\&. To stay up to date, secondary
servers request the primary server's SOA record at certain
intervals, and compare the serial number to that of the cached
SOA record\&.  If the number has changed, the secondary servers
transfers the whole zone database from the primary server\&.
.P 1
.LI "\fB\fIrefresh\fB\fR"
This specifies the interval in seconds that the secondary
servers should wait between checking the SOA record of the
primary server\&. Again, this is a decimal number with at most
eight digits\&.
.P 1
Generally, the network topology doesn't change too often, so
that this number should specify an interval of roughly a day for
larger networks, and even more for smaller ones\&.
.P 1
.LI "\fB\fIretry\fB\fR"
This number determines the intervals at which a secondary
server should retry contacting the primary server if
a request or a zone refresh fails\&. It must not be too low,
or else a temporary failure of the server or a network problem
may cause the secondary server to waste network resources\&.
One hour, or perhaps one half hour, might be a good choice\&.
.P 1
.LI "\fB\fIexpire\fB\fR"
This specifies the time in seconds after which the server should
finally discard all zone data if it hasn't been able to contact
the primary server\&. It should normally be very large\&.  Craig
Hunt ([
GETST "hunt-tcpip"
]) recommends 42 days\&.
.P 1
.LI "\fB\fIminimum\fB\fR"
This is the default ttl value for resource records that do not
explicitly specify one\&. This requires other name servers to
discard the RR after a certain amount of time\&.  It has however
nothing to do with the time after which a secondary server tries
to update the zone information\&.
.P 1
\fB\fIminimum\fB\fR should be a large value, especially for LANs where
the network topology almost never changes\&.  A value of around a
week or a month is probably a good choice\&. In the case that
single RRs may change more frequently, you can still assign them
different ttl's\&.
.P 1
\"
.LE
.P 1
.LI "A"
.INDEX {A (DNS record)}
.INDEX {address!DNS resource record}
.P 1
This associates an IP address with a hostname\&. The resource data field
contains the address in dotted quad notation\&.
.P 1
.INDEX {hostname!canonical}
.INDEX {canonical hostname}
.INDEX {CNAME (DNS record)}
.INDEX {hostname!aliases}
.INDEX {alias!hostname}
For each host, there must be only one A record\&. The hostname used in
this A record is considered the official or \fIcanonical\fR hostname\&.
All other hostnames are aliases and must be mapped onto the canonical
hostname using a CNAME record\&.
.P 1
.LI "NS"
.P 1
This points to a master name server of a subordinate zone\&. For an
explanation why one has to have NS records, see section 
.GETHN "tcpip.dns"
\&\&.
The resource data field contains the hostname of the name server\&. To
resolve the hostname, an additional A record is needed, the so-called
\fIglue record\fR which gives the name server's IP address\&.
.P 1
.LI "CNAME"
.INDEX {CNAME (DNS record)}
.P 1
This associates an alias for a host with its \fIcanonical hostname\fR\&.
The canonical hostname is the one the master file provides an A record
for; aliases are simply linked to that name by a CNAME record, but don't
have any other records of their own\&.
.P 1
.LI "PTR"
.INDEX {PTR (DNS record)}
.P 1
This type of record is used to associate names in the \fBin-addr\&.arpa\fR
domain with hostnames\&. This is used for reverse mapping of IP addresses
to hostnames\&. The hostname given must be the canonical hostname\&.
.P 1
.LI "MX"
.INDEX {MX (DNS record)}
.P 1
This RR announces a \fImail exchanger\fR for a domain\&. The reasons to
have mail exchangers are discussed in section 
.GETHN "mail.routing.internet"
\&
in chapter 
.GETHN "mail"
\&\&.  The syntax of an MX record is
.P 1
.P 1
.DS I F 5
\fB\fI[\fB\fIdomain\fB\fI] [\fB\fIttl\fB\fI] [\fB\fIclass\fB\fI] MX \fB\fIpreference\fB\fI \fB\fIhost\fB\fI
\"
\fB\fR
.DE
.P 1
\fB\fIhost\fB\fR names the mail exchanger for \fB\fIdomain\fB\fR\&. Every
mail exchanger has an integer \fB\fIpreference\fB\fR associated with it\&.
A mail transport agent who desires to deliver mail to \fB\fIdomain\fB\fR
will try all hosts who have an MX record for this domain
until it succeeds\&. The one with the lowest preference value is
tried first, then the others in order of increasing preference
value\&.
.P 1
.LI "HINFO"
This record provides information on the system's hardware
and software\&. Its syntax is
.P 1
.P 1
.DS I F 5
\fB\fI[\fB\fIdomain\fB\fI] [\fB\fIttl\fB\fI] [\fB\fIclass\fB\fI] HINFO \fB\fIhardware software\fB\fI
\"
\fB\fR
.DE
.P 1
The \fB\fIhardware\fB\fR field identifies the hardware used by this host\&.
There are special conventions to specify this\&. A list of valid names is
given in the ``Assigned Numbers'' (RFC 1340)\&. If the field contains any
blanks, it must be enclosed in double quotes\&.  The \fB\fIsoftware\fB\fR field
names the operating system software used by the system\&. Again, a valid
name from the ``Assigned Numbers'' RFC should be chosen\&.
\"
.LE
.P 1
.H 3 "Writing the Master Files"
Figures 
.GETHN "resolv.fig.named.cache"
\&, 
.GETHN "resolv.fig.named.hosts"
\&,
.GETHN "resolv.fig.named.local"
\&, and 
.GETHN "resolv.fig.named.rev"
\& give sample
files for a name server at the brewery, located on \fIvlager\fR\&. Owing
to the nature of the network discussed (a single LAN), the example is
pretty straightforward\&.  If your requirements are more complex, and you
can't get \fInamed\fR going, get ``DNS and BIND'' by Cricket Liu and
Paul Albitz ([
GETST "liu-dns"
])\&.
.P 1
.INDEX {DNS!root name servers}
.INDEX {name server!root}
The \fInamed\&.ca\fR cache file shown in figure 
.GETHN "resolv.fig.named.cache"
\&
shows sample hint records for a root name server\&. A typical cache file
usually describes about a dozen name servers, or so\&. You can obtain the
current list of name servers for the root domain using the \fInslookup\fR
tool described toward the end of this chapter\&.(\*F)
.FS
Note that you can't query your name server for the root servers if
you don't have any root server hints installed: Catch 22! To escape
this dilemma, you can either make \fInslookup\fR use a different name
server, or you can use the sample file in
figure 
.GETHN "resolv.fig.named.cache"
\& as a starting point, and then
obtain the full list of valid servers\&.
.FE
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
;
; /var/named/named.ca          Cache file for the brewery.
;                We're not on the Internet, so we don't need
;                any root servers. To activate these
;                records, remove the semicolons.
;
; .                99999999   IN    NS  NS.NIC.DDN.MIL
; NS.NIC.DDN.MIL   99999999   IN    A   26.3.0.103
; .                99999999   IN    NS  NS.NASA.GOV
; NS.NASA.GOV      99999999   IN    A   128.102.16.10
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " The \fInamed\&\&.ca\fR file\&\&. " "" 0 "resolv.fig.named.cache"
.DE
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
;
; /var/named/named.hosts       Local hosts at the brewery
;                               Origin is vbrew.com
;
@                   IN  SOA   vlager.vbrew.com. (
                              janet.vbrew.com.
                              16         ; serial
                              86400      ; refresh: once per day
                              3600       ; retry:   one hour
                              3600000    ; expire:  42 days
                              604800     ; minimum: 1 week
                              )
                    IN  NS    vlager.vbrew.com.
;
; local mail is distributed on vlager
                    IN  MX    10 vlager
;
; loopback address
localhost.          IN  A     127.0.0.1
; brewery Ethernet
vlager              IN  A     191.72.1.1
vlager-if1          IN  CNAME vlager
; vlager is also news server
news                IN  CNAME vlager
vstout              IN  A     191.72.1.2
vale                IN  A     191.72.1.3
; winery Ethernet
vlager-if2          IN  A     191.72.2.1
vbardolino          IN  A     191.72.2.2
vchianti            IN  A     191.72.2.3
vbeaujolais         IN  A     191.72.2.4
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " The \fInamed\&\&.hosts\fR file\&\&. " "" 0 "resolv.fig.named.hosts"
.DE
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
;
; /var/named/named.local       Reverse mapping of 127.0.0
;                               Origin is 0.0.127.in-addr.arpa.
;
@                   IN  SOA   vlager.vbrew.com. (
                              joe.vbrew.com.
                              1          ; serial
                              360000     ; refresh: 100 hrs
                              3600       ; retry:   one hour
                              3600000    ; expire:  42 days
                              360000     ; minimum: 100 hrs
                              )
                    IN  NS    vlager.vbrew.com.
1                   IN  PTR   localhost.
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " The \fInamed\&\&.local\fR file\&\&. " "" 0 "resolv.fig.named.local"
.DE
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
;
; /var/named/named.rev         Reverse mapping of our IP addresses
;                               Origin is 72.191.in-addr.arpa.
;
@                   IN  SOA   vlager.vbrew.com. (
                              joe.vbrew.com.
                              16         ; serial
                              86400      ; refresh: once per day
                              3600       ; retry:   one hour
                              3600000    ; expire:  42 days
                              604800     ; minimum: 1 week
                              )
                    IN  NS    vlager.vbrew.com.
; brewery
1.1                 IN  PTR   vlager.vbrew.com.
2.1                 IN  PTR   vstout.vbrew.com.
3.1                 IN  PTR   vale.vbrew.com.
; winery
1.2                 IN  PTR   vlager-if1.vbrew.com.
2.2                 IN  PTR   vbardolino.vbrew.com.
3.2                 IN  PTR   vchianti.vbrew.com.
4.2                 IN  PTR   vbeaujolais.vbrew.com.
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " The \fInamed\&\&.rev\fR file\&\&. " "" 0 "resolv.fig.named.rev"
.DE
.P 1
.H 3 "Verifying the Name Server Setup"
.SETR "resolv.nslookup"
.INDEX {name server!checking}
.INDEX {checking!name server}
.INDEX {nslookup@\fInslookup\fR|(}
.INDEX {checking!host names}
.INDEX {hostname!lookup}
.INDEX {DNS!checking}
.P 1
There's a fine tool for checking the operation of your name server
setup\&. It is called \fInslookup\fR, and may be used both interactively
and from the command line\&. In the latter case, you simply invoke it
as
.P 1
.P 1
.DS I F 5
\fBnslookup \fB\fIhostname\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
and it will query the name server specified in \fIresolv\&.conf\fR for
\fB\fIhostname\fB\fR\&.  (If this file names more than one server,
\fInslookup\fR will choose one at random)\&.
.P 1
The interactive mode, however, is much more exciting\&. Besides looking
up individual hosts, you may query for any type of DNS record, and
transfer the entire zone information for a domain\&.
.P 1
When invoked without argument, \fInslookup\fR will display the name
server it uses, and enter interactive mode\&. At the `\fB>\fR' prompt,
you may type any domain name it should query for\&. By default, it asks
for class A records, those containing the IP address relating to the
domain name\&.
.P 1
You may change this type by issuing ``\fBset type=\fItype\fB\fR'', where
\fB\fItype\fB\fR is one of the resource record names described above in
section 
.GETHN "resolv.named"
\&, or ANY\&.
.P 1
For example, you might have the following dialogue with it:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ nslookup
Default Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60

> sunsite.unc.edu
Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60

Non-authoritative answer:
Name:    sunsite.unc.edu
Address:  152.2.22.81
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you try to query for a name that has no IP address associated, but
other records were found in the DNS database, \fInslookup\fR will come
back with an error message saying ``\fBNo type A records found\fR''\&.
However, you can make it query for records other than type A by issuing
the ``\fBset type\fR'' command\&. For example, to get the SOA record of
\fBunc\&.edu\fR, you would issue:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
> unc.edu
*** No address (A) records available for unc.edu
Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60

> set type=SOA
> unc.edu
Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60

Non-authoritative answer:
unc.edu
        origin = ns.unc.edu
        mail addr = shava.ns.unc.edu
        serial = 930408
        refresh = 28800 (8 hours)
        retry   = 3600 (1 hour)
        expire  = 1209600 (14 days)
        minimum ttl = 86400 (1 day)

Authoritative answers can be found from:
UNC.EDU nameserver = SAMBA.ACS.UNC.EDU
SAMBA.ACS.UNC.EDU       internet address = 128.109.157.30
.ENDVERBATIM
\"
\fR
.DE
.P 1
In a similar fashion you can query for MX records, etc\&.  Using a type of
ANY returns all resource records associated with a given name\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
> set type=MX
> unc.edu
Non-authoritative answer:
unc.edu preference = 10, mail exchanger = lambada.oit.unc.edu
lambada.oit.unc.edu     internet address = 152.2.22.80

Authoritative answers can be found from:
UNC.EDU nameserver = SAMBA.ACS.UNC.EDU
SAMBA.ACS.UNC.EDU       internet address = 128.109.157.30
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {DNS!root name servers}
.INDEX {name server!root}
A practical application of \fInslookup\fR beside debugging is
to obtain the current list of root name servers for the \fInamed\&.ca\fR
file\&. You can do this by querying for all type NS records associated
with the root domain:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
> set typ=NS
> .
Name Server:  fb0430.mathematik.th-darmstadt.de
Address:  130.83.2.30

Non-authoritative answer:
(root)  nameserver = NS.INTERNIC.NET
(root)  nameserver = AOS.ARL.ARMY.MIL
(root)  nameserver = C.NYSER.NET
(root)  nameserver = TERP.UMD.EDU
(root)  nameserver = NS.NASA.GOV
(root)  nameserver = NIC.NORDU.NET
(root)  nameserver = NS.NIC.DDN.MIL

Authoritative answers can be found from:
(root)  nameserver = NS.INTERNIC.NET
(root)  nameserver = AOS.ARL.ARMY.MIL
(root)  nameserver = C.NYSER.NET
(root)  nameserver = TERP.UMD.EDU
(root)  nameserver = NS.NASA.GOV
(root)  nameserver = NIC.NORDU.NET
(root)  nameserver = NS.NIC.DDN.MIL
NS.INTERNIC.NET internet address = 198.41.0.4
AOS.ARL.ARMY.MIL        internet address = 128.63.4.82
AOS.ARL.ARMY.MIL        internet address = 192.5.25.82
AOS.ARL.ARMY.MIL        internet address = 26.3.0.29
C.NYSER.NET     internet address = 192.33.4.12
TERP.UMD.EDU    internet address = 128.8.10.90
NS.NASA.GOV     internet address = 128.102.16.10
NS.NASA.GOV     internet address = 192.52.195.10
NS.NASA.GOV     internet address = 45.13.10.121
NIC.NORDU.NET   internet address = 192.36.148.17
NS.NIC.DDN.MIL  internet address = 192.112.36.4
.ENDVERBATIM
\"
\fR
.DE
.P 1
The complete set of commands available with \fInslookup\fR may be
obtained by the \fBhelp\fR command from within \fInslookup\fR\&.
.P 1
.INDEX {nslookup@\fInslookup\fR|)}
.P 1
.H 3 "Other Useful Tools"
.INDEX {DNS!tools}
.P 1
There are a few tools that can help you with your tasks as a BIND
administrator\&. I will briefly describe two of them here\&.
Please refer to the documentation that comes with these tools for
information on how to use them\&.
.P 1
.INDEX {DNS!converting /etc/hosts@converting \fI/etc/hosts\fR}
.INDEX {hosts@\fIhosts\fR!converting to BIND master files}
.INDEX {hostcvt@\fIhostcvt\fR}
\fIhostcvt\fR is a tool that helps you with your initial
BIND configuration by converting your \fI/etc/hosts\fR file
into master files for \fInamed\fR\&. It generates both the forward
(A) and reverse mapping (PTR) entries, and takes care of aliases
and the like\&. Of course, it won't do the whole job for you, as you may
still want to tune the timeout values in the SOA record, for instance,
or add MX records and the like\&. Still, it may help you save a few
aspirins\&. \fIhostcvt\fR is part of the BIND source, but can also
be found as a standalone package on a few Linux FTP servers\&.
.P 1
.INDEX {DNS!debugging databases}
.INDEX {dnswalk@\fIdnswalk\fR}
.INDEX {debugging!DNS databases}
After setting up your name server, you may want to test your
configuration\&.  The ideal (and, to my knowledge) only tool for
this is \fIdnswalk\fR, a \fIperl\fR-based package that 
walks your DNS database, looking for common mistakes and
verifying that the information is consistent\&. \fIdnswalk\fR
has been released on \fBcomp\&.sources\&.misc\fR recently, and
should be available on all FTP sites that archive this group
(\fBftp\&.uu\&.net\fR should be a safe bet if you don't know
of any such site near you)\&.
.P 1
.INDEX {configuring!name server|)}
.INDEX {name server!configuring|)}
.INDEX {DNS!configuring server|)}
.INDEX {BIND|)}
.INDEX {named@\fInamed\fR|)}
.INDEX {configuring!hostname resolution|)}
.P 1
.H 1 "Serial Line IP"
.SETR "slip"
.INDEX {IP!dial-up}
.INDEX {IP!serial line}
.INDEX {dial-up IP}
.INDEX {telephone, sending data over}
.INDEX {Internet!connecting to}
.INDEX {configuring!SLIP|(}
.P 1
The serial line protocols, SLIP and PPP, provide the Internet
connectivity for the poor\&. Apart from a modem and a serial board
equipped with a FIFO buffer, no hardware is needed\&. Using it is not much
more complicated than a mailbox, and an increasing number of private
organizations offer dial-up IP at an affordable cost to everyone\&.
.P 1
There are both SLIP and PPP drivers available for Linux\&. SLIP
has been there for quite a while, and works fairly reliable\&.
A PPP driver has been developed recently by Michael Callahan and 
Al Longyear\&.  It will be described in the next chapter\&.
.P 1
.H 2 "General Requirements"
.SETR "slip.general"
.INDEX {SLIP|(}
.INDEX {PPP}
.P 1
To use SLIP or PPP, you have to configure some basic networking features
as described in the previous chapters, of course\&. At the least, you have
to set up the looback interface, and provide for name resolution\&. When
connecting to the Internet, you will of course want to use DNS\&.  The
simplest option is to put the address of some name server into your
\fIresolv\&.conf\fR file; this server will be queried as soon as the SLIP
link is activated\&. The closer this name server is to the point where you
dial in, the better\&.
.P 1
.INDEX {configuring!caching-only name server}
.INDEX {configuring!DNS over SLIP/PPP}
.INDEX {caching-only name server}
.INDEX {name server!caching-only}
However, this solution is not optimal, because all name lookups will
still go through your SLIP/PPP link\&. If you worry about the bandwidth this
consumes, you can also set up a \fIcaching-only\fR name server\&.  It
doesn't really serve a domain, but only acts as a relay for all DNS
queries produced on your host\&. The advantage of this scheme is that it
builds up a cache, so that most queries have to be sent over the serial
line only once\&. A \fInamed\&.boot\fR file for a caching-only server looks
like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
; named.boot file for caching-only server
directory                            /var/named

primary       0.0.127.in-addr.arpa   db.127.0.0 ; loopback net
cache         .                      db.cache   ; root servers
.ENDVERBATIM
\"
\fR
.DE
.P 1
In addition to this \fIname\&.boot\fR file, you also have to set up
the \fIdb\&.cache\fR file with a valid list of root name servers\&.
This is described toward the end of the Resolver Configuration
chapter\&.
.P 1
.H 2 "SLIP Operation"
.SETR "slip.operation"
.INDEX {SLIPDISC}
.INDEX {tty!line discipline}
.INDEX {line discipline}
.P 1
Dial-up IP servers frequently offer SLIP service through special user
accounts\&. After logging into such an account, you are not dropped into
the common shell; instead a program or shell script is executed that
enables the server's SLIP driver for the serial line and configures the
appropriate network interface\&. Then you have to do the same at your end
of the link\&.
.P 1
On some operating systems, the SLIP driver is a user-space program;
under Linux, it is part of the kernel, which makes it a lot faster\&.
This requires, however, that the serial line be converted to SLIP mode
explicitly\&. This is done by means of a special tty line discipline,
SLIPDISC\&. While the tty is in normal line discipline (DISC0), it will
exchange data only with user processes, using the normal \fIread(2)\fR
and \fIwrite(2)\fR calls, and the SLIP driver is unable to write to or
read from the tty\&. In SLIPDISC, the roles are reversed: now any
user-space processes are blocked from writing to or reading from the
tty, while all data coming in on the serial port will be passed directly
to the SLIP driver\&.
.P 1
.INDEX {Van Jacobson header compression}
.INDEX {compressing TCP/IP packets}
.INDEX {Compressed Serial Line IP}
.INDEX {CSLIP}
The SLIP driver itself understands a number of variations on the SLIP
protocol\&. Apart from ordinary SLIP, it also understands CSLIP, which
performs the so-called Van Jacobson header compression on outgoing
IP packets\&.(\*F)
.FS
Van Jacobson header compression is described in RFC 1441\&.
.FE
This improves throughput for interactive sessions noticeably\&.
Additionally, there are six-bit versions for each of these protocols\&.
.P 1
.INDEX {slattach@\fIslattach\fR}
A simple way to convert a serial line to SLIP mode is by using the
\fIslattach\fR tool\&. Assume you have your modem on \fI/dev/cua3\fR,
and have logged into the SLIP server successfully\&. You will then
execute:
.P 1
.P 1
.DS I F 5
\fB# slattach /dev/cua3 &\"
\fR
.DE
.P 1
This will switch the line discipline of \fIcua3\fR to SLIPDISC, and
attach it to one of the SLIP network interfaces\&. If this is your first
active SLIP link, the line will be attached to \fIsl0\fR; the second
would be attached to \fIsl1\fR, and so on\&. The current kernels support
up to eight simultaneous SLIP links\&.
.P 1
.INDEX {CSLIP}
The default encapsulation chosen by \fIslattach\fR is CSLIP\&.  You may
choose any other mode using the \fB-p\fR switch\&.  To use normal SLIP
(no compression), you would use
.P 1
.P 1
.DS I F 5
\fB# slattach -p slip /dev/cua3 &\"
\fR
.DE
.P 1
Other modes are \fBcslip\fR, \fBslip6\fR, \fBcslip6\fR (for the
six-bit version of SLIP), and \fBadaptive\fR for adaptive SLIP\&.  The
latter leaves it to the kernel to find out which type of SLIP
encapsulation the remote end uses\&.
.P 1
Note that you must use the same encapsulation as your peer does\&.  For
example, if \fBcowslip\fR uses CSLIP, you have to do so, too\&.  The
symptoms of a mismatch will be that a \fIping\fR to the remote host
will not receive any packets back\&.  If the other host \fIping\fRs you,
you may also see messages like ``\fBCan't build ICMP header\fR'' on
your console\&. One way to avoid these difficulties is to use 
adaptive SLIP\&.
.P 1
In fact, \fIslattach\fR does not only allow you to enable
SLIP, but other protocols that use the serial line as well,
like PPP or KISS (another protocol used by ham radio people)\&.
For details, please refer to the \fIslattach(8)\fR manual page\&.
.P 1
After turning over the line to the SLIP driver, you have to configure
the network interface\&. Again, we do this using the standard
\fIifconfig\fR and \fIroute\fR commands\&. Assume that from
\fBvlager\fR, we have dialed up a server named \fBcowslip\fR\&. You
would then execute
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ifconfig sl0 vlager pointopoint cowslip
# route add cowslip
# route add default gw cowslip
.ENDVERBATIM
\"
\fR
.DE
.P 1
The first command configures the interface as a point-to-point link to
\fBcowslip\fR, while the second and third add the route to
\fBcowslip\fR and the default route using \fBcowslip\fR as a gateway\&.
.P 1
When taking down the SLIP link, you first have to remove all routes
through \fBcowslip\fR using \fIroute\fR with the \fBdel\fR option,
take the interface down, and send \fIslattach\fR the hangup signal\&.
Afterwards you have to hang up the modem using your terminal program
again:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# route del default
# route del cowslip
# ifconfig sl0 down
# kill -HUP 516
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 2 "Using dip"
.SETR "slip.dip"
.INDEX {configuring!dip@\fIdip\fR}
.INDEX {dip@\fIdip\fR|(}
.P 1
Now, that was rather simple\&. Nevertheless, you might want to automate
the above steps so that you only have to invoke a simple command that
performs all steps shown above\&. This is what \fIdip\fR is
for\&.(\*F)
.FS
\fIdip\fR means \fIDialup IP\fR\&. It was written by Fred van Kempen\&.
.FE
The current release as of this writing is version 3\&.3\&.7\&. It has been
patched very heavily by a number of people, so that you can't speak of
\fIthe\fR \fIdip\fR program anymore\&. These different strains of
development will hopefully be merged in a future release\&.
.P 1
\fIdip\fR provides an interpreter for a simple scripting language that
can handle the modem for you, convert the line to SLIP mode, and
configure the interfaces\&.  This is rather primitive and restrictive, but
sufficient for most cases\&. A new release of \fIdip\fR may feature a
more versatile language one day\&.
.P 1
.INDEX {SLIP!let users initiate}
.INDEX {access!granting}
.INDEX {security!SLIP}
To be able to configure the SLIP interface, \fIdip\fR requires root
privilege\&. It would now be tempting to make \fIdip\fR setuid to
\fBroot\fR, so that all users can dial up some SLIP server without
having to give them root access\&. This is very dangerous, because setting
up bogus interfaces and default routes with \fIdip\fR may disrupt
routing on your network badly\&.  Even worse, this will give your users
the power to connect to \fIany\fR SLIP server, and launch dangerous
attacks on your network\&. So if you want to allow your users to fire up a
SLIP connection, write small wrapper programs for each prospective SLIP
server, and have these wrappers invoke \fIdip\fR with the specific
script that establishes the connection\&. These programs can then safely
be made setuid \fBroot\fR\&.(\*F)
.FS
\fIdiplogin\fR can (and must) be run setuid, too\&. See the section
at the end of this chapter\&.
.FE
.P 1
.H 3 "A Sample Script"
.SETR "slip.dip.sample"
.P 1
\"
.DF I F 5
\"
.VERBATIM
 # Sample dip script for dialing up cowslip

 # Set local and remote name and address
 get $local vlager
 get $remote cowslip

 port cua3                # choose a serial port
 speed 38400              # set speed to max
 modem HAYES              # set modem type
 reset                    # reset modem and tty
 flush                    # flush out modem response

 # Prepare for dialing.
 send ATQ0V1E1X1\r
 wait OK 2
 if $errlvl != 0 goto error
 dial 41988
 if $errlvl != 0 goto error
 wait CONNECT 60
 if $errlvl != 0 goto error

 # Okay, we're connected now
 sleep 3
 send \r\n\r\n
 wait ogin: 10
 if $errlvl != 0 goto error
 send Svlager\n
 wait ssword: 5
 if $errlvl != 0 goto error
 send hey-jude\n
 wait running 30
 if $errlvl != 0 goto error

 # We have logged in, and the remote side is firing up SLIP.
 print Connected to $remote with address $rmtip
 default                  # Make this link our default route
 mode SLIP                # We go to SLIP mode, too
 # fall through in case of error

error:
 print SLIP to $remote failed.
.ENDVERBATIM
\"
\"
.br
.FG " A sample \fIdip\fR script " "" 0 "slip.fig.script"
.DE
.P 1
A sample script is produced in figure 
.GETHN "slip.fig.script"
\&\&. It can be
used to connect to \fBcowslip\fR by invoking \fIdip\fR with the script
name as argument:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# dip cowslip.dip
DIP: Dialup IP Protocol Driver version 3.3.7 (12/13/93)
Written by Fred N. van Kempen, MicroWalt Corporation.

connected to cowslip.moo.com with addr 193.174.7.129
#
.ENDVERBATIM
\"
\fR
.DE
.P 1
After connecting to \fBcowslip\fR and enabling SLIP, \fIdip\fR will
detach from the terminal and go to the background\&. You can then start
using the normal networking services on the SLIP link\&. To terminate the
connection, simply invoke \fBdip\fR with the \fB-k\fR option\&. This
sends a hangup signal to \fIdip\fR process, using the process id
\fIdip\fR records in \fI/etc/dip\&.pid\fR:(\*F)
.FS
See the newsgroup \fBalt\&.tla\fR for more palindromic fun with
three-letter acronyms\&.
.FE
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# kill -k
.ENDVERBATIM
\"
\fR
.DE
.P 1
In \fIdip\fR's scripting language, keywords prefixed with a dollar
symbol denote variable names\&.  \fIdip\fR has a predefined set of
variables which will be listed below\&.  \fI$remote\fR and
\fI$local\fR, for instance, contain the hostnames of the local and
remote host involved in the SLIP link\&.
.P 1
The first two statements in the sample script are \fIget\fR commands,
which is \fIdip\fR's way to set a variable\&. Here, the local and remote
hostname are set to \fBvlager\fR and \fBcowslip\fR, respectively\&.
.P 1
.INDEX {chat!SLIP}
The next five statements set up the terminal line and the modem\&.  The
\fIreset\fR sends a reset string to the modem; for Hayes-compatible
modems, this is the \fIATZ\fR command\&.  The next statement flushes
out the modem response, so that the login chat in the next few lines
will work properly\&. This chat is pretty straight-forward: it simply
dials 41988, the phone number of \fBcowslip\fR, and logs into the
account \fISvlager\fR using the password \fIhey-jude\fR\&. The
\fIwait\fR command makes \fIdip\fR wait for the string given as its
first argument; the number given as second argument make the wait time
out after that many seconds if no such string is received\&.  The
\fIif\fR commands interspersed in the login procedure check that no
error has occurred while executing the command\&.
.P 1
The final commands executed after logging in are \fIdefault\fR,
which makes the SLIP link the default route to all hosts, and
\fImode\fR, which enables SLIP mode on the line and configures the
interface and routing table for you\&.
.P 1
.H 3 "A dip Reference"
.SETR "slip.dip.reference"
Although widely used, \fIdip\fR hasn't been very well documented yet\&.
In this section, we will therefore give a reference for most of
\fIdip\fR's commands\&. You can get an overview of all commands it
provides by invoking \fIdip\fR in test mode, and entering the
\fIhelp\fR command\&. To find out about the syntax of a command, you may
enter it without any arguments; of course this does not work with
commands that take no arguments\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ dip -t
DIP: Dialup IP Protocol Driver version 3.3.7 (12/13/93)
Written by Fred N. van Kempen, MicroWalt Corporation.

DIP> help
DIP knows about the following commands:

	databits default  dial     echo     flush    
	get      goto     help     if       init     
	mode     modem    parity   print    port     
	reset    send     sleep    speed    stopbits 
	term     wait     

DIP> echo
Usage: echo on|off
DIP> _
.ENDVERBATIM
\"
\fR
.DE
.P 1
Throughout the following, examples that display the \fBDIP>\fR
prompt show how to enter a command in test mode, and what output
it produces\&. Examples lacking this prompt should be taken as
script excerpts\&.
.P 1
.H 4 "The Modem Commands"
There is a number of commands \fIdip\fR provides to configure your
serial line and modem\&. Some of these are obvious, such as
\fIport\fR, which selects a serial port, and \fIspeed\fR,
\fIdatabits\fR, \fIstopbits\fR, and \fIparity\fR, which set
the common line parameters\&.
.P 1
The \fImodem\fR command selects a modem type\&. Currently, the
only type supported is \fIHAYES\fR (capitalization required)\&.
You have to provide \fIdip\fR with a modem type, else it will
refuse to execute the \fIdial\fR and \fIreset\fR commands\&.
The \fIreset\fR command sends a reset string to the modem;
the string used depends on the modem type selected\&. For
Hayes-compatible modems, this is \fIATZ\fR\&.
.P 1
The \fIflush\fR code can be used to flush out all responses
the modem has sent so far\&. Otherwise a chat script following the
\fIreset\fR might be confused, because it reads the \fIOK\fR
responses from earlier commands\&.
.P 1
The \fIinit\fR command selects an initialization string to be passed
to the modem before dialling\&. The default for Hayes modems is
``\fIATE0 Q0 V1 X1\fR'', which turns on echoing of commands and long
result codes, and selects blind dialing (no checking of dial tone)\&.
.P 1
The \fIdial\fR command finally sends the initialization string to
the modem and dials up the remote system\&. The default dial command for
Hayes modems is \fIATD\fR\&.
.P 1
.H 4 "echo and term"
The \fIecho\fR command serves as a debugging aid, in that using
\fIecho on\fR makes \fIdip\fR echo to the console everything sends
to the serial device\&. This can be turned off again by calling
\fIecho off\fR\&.
.P 1
\fIdip\fR also allows you to leave script mode temporarily and
enter terminal mode\&. In this mode, you can use \fIdip\fR just
like any ordinary terminal program, writing to the serial line
and reading from it\&. To leave this mode, enter `Ctrl-]'\&.
.P 1
.H 4 "The get Command"
The \fIget\fR command is \fIdip\fR's way of setting a variable\&.
The simplest form is to set a variable to a constant, as used
throughout the above example\&. You may, however, also prompt the
user for input by specifying the keyword \fIask\fR instead
of a value:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
DIP> get $local ask
Enter the value for $local: _
.ENDVERBATIM
\"
\fR
.DE
.P 1
A third method is to try to obtain the value from the remote host\&.
Bizarre as it seems first, this is very useful in some cases:
Some SLIP servers will not allow you to use your own IP address on the
SLIP link, but will rather assign you one from a pool of addresses
whenever you dial in, printing some message that informs you about
the address you have been assigned\&. If the message looks something
like this ``\fBYour address: 193\&.174\&.7\&.202\fR'', then the following
piece of \fIdip\fR code would let you pick up the address:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 ... login chat ....
wait address: 10
get $locip remote
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 4 "The print Command"
This is the command to echo text to the console \fIdip\fR
was started from\&. Any of \fIdip\fR's variables may be used in
print commands, such as
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
DIP> print Using port $port at speed $speed
Using port cua3 at speed 38400
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 4 "Variable Names"
\fIdip\fR only understands a predefined set of variables\&. A
variable name always begins with a dollar symbol and must be
written in lower-case letters\&.
.P 1
The \fI$local\fR and \fI$locip\fR variables contain
the local host's name and IP address\&. Setting the hostname makes
\fIdip\fR store the canonical hostname in \fI$local\fR,
at the same time assigning \fI$locip\fR the corresponding
IP address\&. The analogous thing happens when setting the 
\fI$locip\fR\&.
.P 1
The \fI$remote\fR and \fI$rmtip\fR variables do the same for
the remote host's name and address\&.  \fI$mtu\fR contains the MTU
value for the connection\&.
.P 1
These five variables are the only ones that may be assigned values
directly using the \fIget\fR command\&. A host of other variables can
only be set through corresponding commands, but may be used
\fIprint\fR statements; these are \fI$modem\fR, \fI$port\fR,
and \fI$speed\fR\&.
.P 1
\fI$errlvl\fR is the variable through which you can access the
result of the last command executed\&. An error level of 0 indicates
success, while a non-zero value denotes an error\&.
.P 1
.H 4 "The if and goto Commands"
The \fIif\fR command is rather a conditional branch than
what one usually calls an if\&. Its syntax is
.P 1
.P 1
.DS I F 5
\fBif \fB\fIvar\fB\fB \fB\fIop\fB\fB \fB\fInumber\fB\fB goto \fB\fIlabel\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
where the expression must be a simple comparison between one of the
variables \fI$errlvl\fR, \fI$locip\fR, and \fI$rmtip\fR\&.
The second operand must be an integer number; the operator \fB\fIop\fB\fR may
be one of \fB==\fR, \fB!=\fR, \fB<\fR, \fB>\fR, \fB<=\fR, and
\fB>=\fR\&.
.P 1
The \fIgoto\fR command makes the execution of the script continue at
the line following that bearing the label\&. A label must occur as the very
first token on the line, and must be followed immediately by a colon\&.
.P 1
.H 4 "send, wait and sleep"
These commands help implement simple chat scripts in \fIdip\fR\&.
\fIsend\fR outputs its arguments to the serial line\&. It does not
support variables, but understands all C-style backslash character
sequences such as \fI\\n\fR and \fI\\b\fR\&.  The tilde
character (\fI~\fR) is used as an abbreviation for carriage
return/newline\&.
.P 1
\fIwait\fR takes a word as an argument, and scans all input
on the serial line until it recognizes this word\&. The word itself
may not contain any blanks\&. Optionally, you may give \fIwait\fR
a timeout value as second argument; if the expected word is not
received within that many seconds, the command will return
with an \fI$errlvl\fR value of one\&.
.P 1
The \fIsleep\fR statement may be used to wait for a certain amount
of time, for instance to patiently wait for any login sequence
to complete\&. Again, the interval is specified in seconds\&.
.P 1
.H 4 "mode and default"
These commands are used to flip the serial line to SLIP mode
and configure the interface\&. 
.P 1
The \fImode\fR command is the last command executed by \fIdip\fR
before gong into daemon mode\&. Unless an error occurs, the command
does not return\&.
.P 1
\fImode\fR takes a protocol name as argument\&. \fIdip\fR
currently recognizes \fISLIP\fR and \fICSLIP\fR as
valid names\&. The current version of \fIdip\fR does not understand
adaptive SLIP, however\&.
.P 1
After enabling SLIP mode on the serial line, \fIdip\fR executes
\fIifconfig\fR to configure the interface as a point-to-point link, and
invokes \fIroute\fR to set the route to the remote host\&.
.P 1
If, in addition, the script executes the \fIdefault\fR command
before \fImode\fR, \fIdip\fR will also make the default
route point to the SLIP link\&.
.P 1
.H 2 "Running in Server Mode"
.SETR "slip.server"
.INDEX {diplogin@\fIdiplogin\fR}
.INDEX {configuring!SLIP server}
.P 1
Setting up your SLIP client was the hard part\&. Doing the opposite,
namely configuring your host to act as a SLIP server, is much easier\&.
.P 1
One way to do this is to to use \fIdip\fR in server mode, which can
be achieved by invoking it as \fIdiplogin\fR\&. Its main configuration
file is \fI/etc/diphosts\fR, which associates login names with the
address this host is assigned\&.  Alternatively, you can also use
\fIsliplogin\fR, a BSD-derived tool that features a more flexible
configuration scheme that lets you execute shell scripts whenever a
host connects and disconnects\&. It is currently at Beta\&.
.P 1
.INDEX {Dent, Arthur}
Both programs require that you set up one login account per SLIP
client\&. For instance, assume you provide SLIP service to Arthur Dent
at \fBdent\&.beta\&.com\fR, you might create an account named \fBdent\fR
by adding the following line to your \fIpasswd\fR file:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
dent:*:501:60:Arthur Dent's SLIP account:/tmp:/usr/sbin/diplogin
.ENDVERBATIM
\"
\fR
.DE
.P 1
.br
.ti 0
Afterwards, you would set \fBdent\fR's password using the
\fIpasswd\fR utility\&.
.P 1
.INDEX {diphosts@\fIdiphosts\fR}
Now, when \fBdent\fR logs in, \fIdip\fR will start up as a server\&.
To find out if he is indeed permitted to use SLIP, it will look
up the user name in \fI/etc/diphosts\fR\&. This file details the access
rights and connection parameter for each SLIP user\&. A sample entry for
\fBdent\fR could look like this:
.P 1
.P 1
.DS I F 5
\fBdent::dent\&.beta\&.com:Arthur Dent:SLIP,296
\"
\fR
.DE
.P 1
.INDEX {CSLIP}
The first of the colon-separated fields is the name the user
must log in as\&. The second field may contain an additional
password (see below)\&. The third is the hostname or IP address
of the calling host\&. Next comes an informational field without
any special meaning (yet)\&. The last field describes the connection
parameters\&. This is a comma-separated list specifying the
protocol (currently one of \fISLIP\fR or \fICSLIP\fR),
followed by the MTU\&.
.P 1
When \fBdent\fR logs in, \fIdiplogin\fR extracts the information on
him from the \fIdiphosts\fR file, and, if the second field is not
empty, prompts for an ``external security password''\&. The string
entered by the user is compared to the (unencrypted) password from
\fIdiphosts\fR\&. If they do not match, the login attempt is rejected\&.
.P 1
Otherwise, \fIdiplogin\fR proceeds by flipping the serial line to CSLIP
or SLIP mode, and sets up the interface and route\&. This connection
remains established until the user disconnects and the modem drops the
line\&. \fIdiplogin\fR will then return the line to normal line
discipline, and exit\&.
.P 1
.INDEX {access!granting}
.INDEX {security}
\fIdiplogin\fR requires super-user privilege\&.  If you don't have
\fIdip\fR running setuid \fBroot\fR, you should make \fIdiplogin\fR a
separate copy of \fIdip\fR instead of a simple link\&. \fIdiplogin\fR
can then safely be made setuid, without affecting the status of
\fIdip\fR itself\&.
.P 1
.INDEX {dip@\fIdip\fR|)}
.INDEX {configuring!SLIP|)}
.INDEX {SLIP|)}
.P 1
.H 1 "The Point-to-Point Protocol"
.SETR "ppp"
.P 1
.H 2 "Untangling the P's"
.INDEX {Internet!connecting to}
.INDEX {telephone, sending data over}
.INDEX {IP!serial line}
.INDEX {IP!dial-up}
.INDEX {Point-to-Point Protocol}
.INDEX {point-to-point link}
.INDEX {configuring!PPP|(}
.INDEX {PPP|(}
.P 1
Just like SLIP, PPP is a protocol to send datagrams across a serial
connection, but addresses a couple of deficiencies of the former\&.  It
lets the communicating sides negotiate options such as the IP address
and the maximum datagram size at startup time, and provides for client
authorization\&.  For each of these capabilities, PPP has a separate
protocol\&.  Below, we will briefly cover these basic building blocks of
PPP\&. This discussion is far from complete; if you want to know more
about PPP, you are urged to read its specification in RFC 1548, as well
as the dozen or so companion RFCs\&.(\*F)
.FS
The relevant RFCs are listed in the Annoted Bibiliography at the end
of this book\&.
.FE
.P 1
.INDEX {HDLC}
At the very bottom of PPP is the \fIHigh-Level Data Link Control\fR
Protocol, abbreviated HDLC,(\*F)
.FS
In fact, HDLC is a much more general protocol devised by the
International Standards Organization (ISO)\&.
.FE
which defines the boundaries around the individual PPP frames, and
provides a 16 bit checksum\&.  As opposed to the more primitive SLIP
encapsulation, a PPP frame is capable of holding packets from other
protocols than IP, such as Novell's IPX, or Appletalk\&. PPP achieves
this by adding a protocol field to the basic HDLC frame that
identifies the type of packet is carried by the frame\&.
.P 1
.INDEX {LCP|see Link Control Protocol (PPP)}
.INDEX {Link Control Protocol (PPP)}
.INDEX {serial line!looped back}
.INDEX {looped back serial line}
LCP, the Link Control Protocol, is used on top of HDLC to negotiate
options pertaining to the data link, such as the Maximum Receive Unit
(MRU) that states the maximum datagram size one side of the link agrees
to receive\&.
.P 1
.INDEX {authorization!with PPP}
.INDEX {PAP|see Password Authentication Protocol}
.INDEX {Password Authentication Protocol}
.INDEX {CHAP|see Challenge Handshake Authentication Protocol}
.INDEX {Challenge Handshake Authentication Protocol}
An important step at the configuration stage of a PPP link is client
authorization\&. Although it is not mandatory, it is really a must for
dial-up lines\&.  Usually, the called host (the server) asks the client to
authorize itself by proving it knows some secret key\&.  If the caller fails
to produce the correct secret, the connection is terminated\&.  With PPP,
authorization works both ways; that is, the caller may also ask the server
to authenticate itself\&.  These authentication procedures are totally
independent of each other\&.  There are two protocols for different types of
authorization, which we will discuss further below\&.  They are named
Password Authentication Protocol, or PAP, and Challenge Handshake
Authentication Protocol, or CHAP\&.
.P 1
.INDEX {Network Control Protocols}
.INDEX {NCP|see Network Control Protocols}
.INDEX {IP!Network Control Protocol (PPP)}
.INDEX {IP!Control Protocol}
.INDEX {IPCP|see IP, Control Protocol}
Each network protocol that is routed across the data link, like IP,
AppleTalk, etc, is configured dynamically using a corresponding Network
Control Protocol (NCP)\&.  For instance, to send IP datagrams across the
link, both PPPs must first negotiate which IP address each of them uses\&.
The control protocol used for this is IPCP, the Internet Protocol Control
Protocol\&.
.P 1
.INDEX {Van Jacobson header compression}
.INDEX {compressing TCP/IP packets}
.INDEX {PPP!compressing data}
.INDEX {CSLIP}
Beside sending standard IP datagrams across the link, PPP also supports
Van Jacobson header compression of IP datagrams\&. This is a technique to
shrink the headers of TCP packets to as little as three bytes\&. It is
also used in CSLIP, and is more colloquially referred to as VJ header
compression\&.  The use of compression may be negotiated at startup time
through IPCP as well\&.
.P 1
.H 2 "PPP on Linux"
.INDEX {driver!PPP}
.INDEX {PPP!driver}
.INDEX {PPP!daemon}
.INDEX {pppd@\fIpppd\fR}
.P 1
On Linux, PPP functionality is split up in two parts, a low-level HDLC
driver located in the kernel, and the user space \fIpppd\fR daemon
that handles the various control protocols\&.  The current release of PPP
for Linux is \fIlinux-ppp-1\&.0\&.0\fR, and contains the kernel PPP
module, \fIpppd\fR, and a program named \fIchat\fR used to dial up the
remote system\&.
.P 1
The PPP kernel driver was written by Michael Callahan\&.  \fIpppd\fR was
derived from a free PPP implementation for Sun and 386BSD machines,
which was written by Drew Perkins and others, and is maintained by Paul
Mackerras\&. It was ported to Linux by Al Longyear\&.(\*F)
.FS
Both authors have said they will be very busy for some time to come\&.
If you have any questions on PPP in general, you'd best ask the people
on the NET channel of the Linux activists mailing list\&.
.FE
\fIchat\fR was written by Karl Fox\&.(\*F)
.FS
\fBkarl@morningstar\&.com\fR\&.
.FE
.P 1
.INDEX {tty!line discipline}
.INDEX {line discipline}
Just like SLIP, PPP is implemented by means of a special line discipline\&.
To use some serial line as a PPP link, you frst establish the connection
over your modem as usual, and subsequently convert the line to PPP mode\&.
In this mode, all incoming data is passed to the PPP driver, which checks
the incoming HDLC frames for validity (each HDLC frame carries a 16 bit
checksum), and unwraps and dispatches them\&.  Currently, it is able to
handle IP datagrams, optionally using Van Jacobson header compression\&.
As soon as Linux supports IPX, the PPP driver will be extended to
handle IPX packets, too\&.
.P 1
The kernel driver is aided by \fIpppd\fR, the PPP daemon, which performs
the entire initialization and authentication phase that is necessary before
actual network traffic can be sent across the link\&.  \fIpppd\fR's behavior
may be fine-tuned using a number of options\&.  As PPP is rather complex, it
is impossible to explain all of them in a single chapter\&.  This book
therefore cannot cover all aspects of \fIpppd\fR, but only give you an
introduction\&. For more information, refer to the manual pages and
\fIREADME\fRs in the \fIpppd\fR source distribution, which should help
you sort out most questions this chapter fails to discuss\&.  If your
problems persist even after reading all documentation, you should turn to
the newsgroup \fBcomp\&.protocols\&.ppp\fR for help, which is the place where
you will reach most of the people involved in the development of
\fIpppd\fR\&.
.P 1
.H 2 "Running pppd"
.INDEX {Internet!connecting to}
.INDEX {pppd@\fIpppd\fR|(}
.P 1
When you want to connect to the Internet through a PPP link, you have to
set up basic networking capabilities such as the loopback device, and
the resolver\&.  Both have been covered in the previous chapters\&.  There
are some things to be said about using DNS over a serial link; please
refer to the SLIP chapter for a discussion of this\&.
.P 1
As an introductory example of how to establish a PPP connection with
\fIpppd\fR, assume you are at \fBvlager\fR again\&. You have already
dialed up the PPP server, \fBc3po\fR, and logged into the \fBppp\fR
account\&.  \fBc3po\fR has already fired up its PPP driver\&.  After
exiting the communications program you used for dialing, you execute
the following command:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# pppd /dev/cua3 38400 crtscts defaultroute
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {handshake, hardware}
.INDEX {hardware!handshake}
This will flip the serial line \fIcua3\fR to PPP mode and establish
an IP link to \fBc3po\fR\&. The transfer speed used on the serial port
will be 38400bps\&.  The \fIcrtscts\fR option turns on hardware
handshake on the port, which is an absolute must at speeds above
9600 bps\&.
.P 1
The first thing \fIpppd\fR does after starting up is to negotiate
several link characteristics with the remote end, using LCP\&. Usually,
the default set of options \fIpppd\fR tries to negotiate will work,
so we won't go into this here\&.  We will return to LCP in more detail in
some later section\&.
.P 1
For the time being, we also assume that \fBc3po\fR doesn't require
any authentication from us, so that the configuration phase is
completed successfully\&.
.P 1
.INDEX {PPP!and IP addresses}
.INDEX {IP!address!negotiation in PPP}
.INDEX {address!negotiation with PPP}
\fIpppd\fR will then negotiate the IP parameters with its peer using
IPCP, the IP control protocol\&. Since we didn't specify any particular
IP address to \fIpppd\fR above, it will try to use the address obtained
by having the resolver look up the local hostname\&.  Both will then
announce their address to each other\&.
.P 1
Usually, there's nothing wrong with these defaults\&. Even if your
machine is on an Ethernet, you can use the same IP address for both
the Ethernet and the PPP interface\&.  Nevertheless, \fIpppd\fR allows
you to use a different address, or even to ask your peer to use some
specific address\&.  These options are discussed in a later section\&.
.P 1
.INDEX {interface!PPP}
.INDEX {configuring!PPP}
.INDEX {PPP!default route}
.INDEX {route, default}
After going through the IPCP setup phase, \fIpppd\fR will prepare
your host's networking layer to use the PPP link\&. It first configures
the PPP network interface as a point-to-point link, using \fIppp0\fR
for the first PPP link that is active, \fIppp1\fR for the second, and
so on\&.  Next, it will set up a routing table entry that points to the
host at the other end of the link\&. In the example shown above,
\fIpppd\fR will make the default network route point to \fBc3po\fR,
because we gave it the \fIdefaultroute\fR option\&.(\*F)
.FS
The default network route is only installed if none is present yet\&.
.FE
This causes all datagrams to hosts not on your local network to be
sent to \fBc3po\fR\&. There are a number of different routing schemes
\fIpppd\fR supports, which we will cover in detail later in this
chapter\&.
.P 1
.H 2 "Using Options Files"
.SETR "ppp.ppprc"
.INDEX {PPP!option files}
.P 1
Before \fIpppd\fR parses its command line arguments, it scans several
files for default options\&.  These files may contain any valid command
line arguments, spread out across an arbitrary number of lines\&.
comments are introduced by has signs\&.
.P 1
The first options file is \fI/etc/ppp/options\fR, which is always scanned
when \fIpppd\fR starts up\&.  Using it to set some global defaults is a good
idea, because it allows you to keep your users from doing several things
that may compromise security\&.  For instance, to make \fIpppd\fR require
some kind of authentication (either PAP or CHAP) from the peer, you would
add the \fBauth\fR option to this file\&.  This option cannot be
overridden by the user, so that it becomes impossible to establish a PPP
connection with any system that is not in our authentication databases\&.
.P 1
.INDEX {ppprc@\fI\&.ppprc\fR}
The other option file, which is read after \fI/etc/ppp/options\fR, is
\fI\&.ppprc\fR in the user's home directory\&. It allows each user to
specify her own set of default options\&.
.P 1
A sample \fI/etc/ppp/options\fR file might look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# Global options for pppd running on vlager.vbrew.com
auth                 # require authentication
usehostname          # use local hostname for CHAP
lock                 # use UUCP-style device locking
domain vbrew.com     # our domain name
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {lock files!and PPP}
.INDEX {PPP!lock files}
The first two of these options apply to authentication and will be
explained below\&.  The \fBlock\fR keyword makes \fIpppd\fR comply
to the standard UUCP method of device locking\&.  With this convention,
each process that accesses a serial device, say \fI/dev/cua3\fR,
creates a lock file named \fILCK\&.\&.cua3\fR in the UUCP spool directory
to signal that the device is in use\&. This is necessary to prevent any
other programs such as \fIminicom\fR or \fIuucico\fR to open the
serial device while used by PPP\&.
.P 1
The reason to provide these options in the global configuration file
is that options such as those shown above cannot be overridden, and so
provide for a reasonable level of security\&. Note however, that some
options can be overridden later; one such an example is the
\fIconnect\fR string\&.
.P 1
.H 2 "Dialing out with chat"
.INDEX {establishing the connection}
.INDEX {chat!PPP}
.INDEX {PPP!chat script|(}
.P 1
One of the things that may have struck you as inconvenient in the above
example is that you had to establish the connection manually before you
could fire up \fIpppd\fR\&.  Unlike \fIdip\fR, \fIpppd\fR does not have
its own scripting language for dialing the remote system and logging in,
but rather relies on some external program or shell script to do this\&.
The command to be executed can be given to \fIpppd\fR with the
\fIconnect\fR command line option\&.  \fIpppd\fR will redirect the
command's standard input and output to the serial line\&.  One useful
program for this is \fIexpect\fR, written by Don Libes\&.  It has a very
powerful language based on Tcl, and was designed exactly for this sort
of application\&.
.P 1
.INDEX {chat@\fIchat\fR|(}
.INDEX {chat script}
The \fIpppd\fR package comes along with a similar program called
\fIchat\fR, which lets you specify a UUCP-style chat script\&.
Basically, a chat script consists of an alternating sequence of
strings that we expect to receive from the remote system, and the
answers we are to send\&. We will call the expect and send strings,
respectively\&.  This is a typical excerpt from a chat script;
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
ogin: b1ff ssword: s3kr3t
.ENDVERBATIM
\"
\fR
.DE
.P 1
This tells \fIchat\fR to wait for the remote system to send the login
prompt, and return the login name \fBb1ff\fR\&. We only wait for
\fBogin:\fR so that it doesn't matter if the login prompt starts with
an uppercase or lowercase l, or if it arrives garbled\&.  The following
string is an expect-string again that makes \fIchat\fR wait for the
password prompt, and send our password in response\&.
.P 1
This is basically all that chat scripts are about\&. A complete script to
dial up a PPP server would, of course, also have to include the appropriate
modem commands\&. Assume your modem understands the Hayes command set, and
the server's telephone number was 318714\&. The complete \fIchat\fR
invocation to establish a connection with \fBc3po\fR would then be
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ chat -v '' ATZ OK ATDT318714 CONNECT '' ogin: ppp word: GaGariN
.ENDVERBATIM
\"
\fR
.DE
.P 1
By definition, the first string must be an expect string, but as the
modem won't say anything before we have kicked it, we make \fIchat\fR
skip the first expect by specifying an empty string\&.  We go on and send
\fBATZ\fR, the reset command for Hayes-compatible modems, and wait for
its response (\fBOK\fR)\&. The next string sends the dial command along
with the phone number to \fIchat\fR, and expects the \fBCONNECT\fR
message in response\&.  This is followed by an empty string again, because
we don't want to send anything now, but rather wait for the login
prompt\&. The remainder of the chat script works exactly as described
above\&.
.P 1
The \fB-v\fR option makes \fIchat\fR log all activities to the
\fIsyslog\fR daemon's \fIlocal2\fR facility\&.(\*F)
.FS
If you edit \fIsyslog\&.conf\fR to redirect these log messages to
a file, make sure this file isn't world readable, as \fIchat\fR
also logs the entire chat script by default -- including passwords
and all\&.
.FE
.P 1
.INDEX {security!PPP}
Specifying the chat script on the command line bears a certain risk,
because users can view a process' command line with the \fIps\fR
command\&.  You can avoid this by putting the chat script in a file, say
\fIdial-c3po\fR\&.  You make \fIchat\fR read the script from the file
instead of the command line by giving it the \fB-f\fR option, followed
by the file name\&.  The complete \fIpppd\fR incantation would now look like
this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# pppd connect "chat -f dial-c3po" /dev/cua3 38400 -detach \
        crtscts modem defaultroute
.ENDVERBATIM
\"
\fR
.DE
.P 1
Beside the \fIconnect\fR option that specifies the dial-up script,
we have added two more options to the command line: \fI-detach\fR,
which tells \fIpppd\fR not to detach from the console and become a
background process\&. The \fImodem\fR keyword makes it perform some
modem-specific actions on the serial device, like hanging up the line
before and after the call\&. If you don't use this keyword, \fIpppd\fR
will not monitor the port's DCD line, and will therefore not detect if
the remote end hangs up unexpectedly\&.
.P 1
The examples shown above were rather simple; \fIchat\fR allows for much
more complex chat scripts\&.  One very useful feature is the ability to
specify strings on which to abort the chat with an error\&.  Typical abort
strings are messages like \fBBUSY\fR, or \fBNO CARRIER\fR, that your
modem usually generates when the called number is busy, or doesn't pick
up the phone\&.  To make \fIchat\fR recognize these immediately, rather
than timing out, you can specify them at the beginning of the script
using the \fBABORT\fR keyword:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ chat -v ABORT BUSY ABORT 'NO CARRIER' '' ATZ OK ...
.ENDVERBATIM
\"
\fR
.DE
.P 1
In a similar fashion, you may change the timeout value for parts of the
chat scripts by inserting \fBTIMEOUT\fR options\&. For details, please
check the \fIchat(8)\fR manual page\&.
.P 1
Sometimes, you'd also want to have some sort of conditional execution
of parts of the chat script\&. For instance, when you don't receive the
remote end's login prompt, you might want to send a BREAK, or a carriage
return\&. You can achieve this by appending a sub-script to an expect
string\&.  It consists of a sequence of send- and expect-strings, just
like the overall script itself, which are separated by hyphens\&. The
sub-script is executed whenever the expected string they are appended to
is not received in time\&.  In the example above, we would modify the chat
script as follows:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
ogin:-BREAK-ogin: ppp ssword: GaGariN
.ENDVERBATIM
\"
\fR
.DE
.P 1
Now, when \fIchat\fR doesn't see the remote system send the login
prompt, the sub-script is executed by first sending a BREAK, and then
waiting for the login prompt again\&. If the prompt now appears, the
script continues as usual, otherwise it will terminate with an error\&.
.P 1
.INDEX {PPP!chat script|)}
.INDEX {chat@\fIchat\fR|)}
.P 1
.H 2 "Debugging Your PPP Setup"
.INDEX {PPP!debug information}
.INDEX {debugging!PPP setup}
.INDEX {syslog@\fIsyslog\fR}
.INDEX {checking!PPP}
.P 1
By default, \fIpppd\fR will log any warnings and error messages to
\fIsyslog\fR's \fIdaemon\fR facility\&.  You have to add an entry
to \fIsyslog\&.conf\fR that redirects this to a file, or even the
console, otherwise \fIsyslog\fR simply discards these messages\&. The
following entry sends all messages to \fI/var/log/ppp-log\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
daemon.*                /var/log/ppp-log
.ENDVERBATIM
\"
\fR
.DE
.P 1
If your PPP setup doesn't work at once, looking into this log file
should give you a first hint of what goes wrong\&. If this doesn't help,
you can also turn on extra debugging output using the \fBdebug\fR
option\&. This makes \fIpppd\fR log the contents of all control packets
sent or received to \fIsyslog\fR\&.  All messages will go to the
\fIdaemon\fR facility\&.
.P 1
Finally, the most drastic feature is to enable kernel-level debugging
by invoking \fIpppd\fR with the \fIkdebug\fR option\&.  It is
followed by a numeric argument that is the bitwise OR of the following
values: 1 for general debug messages, 2 for printing the contents of
all incoming HDLC frames, and 4 to make the driver print all outgoing
HDLC frames\&. To capture kernel debugging messages, you must either run
a \fIsyslogd\fR daemon that reads the \fI/proc/kmsg\fR file, or the
\fIklogd\fR daemon\&. Either of them directs kernel debugging to
\fIsyslog\fR's \fIkernel\fR facility\&.
.P 1
.H 2 "IP Configuration Options"
.INDEX {IP!Control Protocol}
.P 1
IPCP is used to negotiate a couple of IP parameters at link
configuration time\&.  Usually, each peer may send an IPCP Configuration
Request packet, indicating which values it wants to change from the
defaults, and to what value\&. Upon receipt, the remote end inspects each
option in turn, and either acknowledges or rejects it\&.
.P 1
\fIpppd\fR gives you a lot of control about which IPCP options it will try
to negotiate\&.  You can tune this through various command line options we
will discuss below\&.
.P 1
.H 3 "Choosing IP Addresses"
.INDEX {PPP!IP addresses|(}
.INDEX {IP!address!negotiation in PPP}
.INDEX {address!negotiation with PPP}
.P 1
In the example above, we had \fIpppd\fR dial up \fBc3po\fR and establish
an IP link\&.  No provisions were taken to choose a particular IP address on
either end of the link\&.  Instead, we picked \fBvlager\fR's address as the
local IP address, and let \fBc3po\fR provide its own\&.  Sometimes, however,
it is useful to have control over what address is used on one or the other
end of the link\&.  \fIpppd\fR supports several variations of this\&.
.P 1
To ask for particular addresses, you generally provide \fIpppd\fR with
the following option:
.P 1
.P 1
.DS I F 5
\fB\fB\fIlocal_addr\fB\fB:\fB\fIremote_addr\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
where \fB\fIlocal_addr\fB\fR and \fB\fIremote_addr\fB\fR may be specified
either in dotted quad notation, or as hostnames\&.(\*F)
.FS
Using hostnames in this option has consequences on CHAP
authentication\&. Please refer to the section on CHAP below\&.
.FE
This makes \fIpppd\fR attempt to use the first address as its own
IP address, and the second as the peer's\&. If the peer rejects either of
them during IPCP negotiation, no IP link will be established\&.(\*F)
.FS
You can allow the peer PPP to override your ideas of IP addresses by
giving \fIpppd\fR the \fBipcp-accept-local\fR and
\fBipcp-accept-remote\fR options\&. Please refer to the manual page
for details\&.
.FE
.P 1
If you want to set only the local address, but accept any address the
peer uses, you simply leave out the \fB\fIremote_addr\fB\fR part\&. For
instance, to make \fBvlager\fR use the IP address \fB130\&.83\&.4\&.27\fR
instead of its own, you would give it \fB130\&.83\&.4\&.27:\fR on the
command line\&.  Similarly, to set the remote address only, you would
leave the \fB\fIlocal_addr\fB\fR field blank\&. By default, \fIpppd\fR
will then use the address associated with your hostname\&.
.P 1
.INDEX {PPP!dynamic address assignment}
Some PPP servers that handle a lot of client sites assign addresses
dynamically: addresses are assigned to systems only when calling in, and
are claimed after they have logged off again\&. When dialing up such a
server, you must make sure that \fIpppd\fR doesn't request any particular
IP address from the server, but rather accept the address the server asks
you to use\&. This means that you mustn't specify a \fB\fIlocal_addr\fB\fR
argument\&. In addition, you have to use the \fBnoipdefault\fR option,
which makes \fIpppd\fR wait for the peer to provide the IP address instead
of using the local host's address\&.
.P 1
.INDEX {PPP!IP addresses|)}
.P 1
.H 3 "Routing Through a PPP Link"
.INDEX {routing!over PPP}
.INDEX {PPP!routing|(}
.P 1
After setting up the network interface, \fIpppd\fR will usually set up
a host route to its peer only\&. If the remote host is on a LAN, you
certainly want to be able to connect to hosts ``behind'' your peer as
well; that is, a network route must be set up\&.
.P 1
We have already seen above that \fIpppd\fR can be asked to set the
default route using the \fBdefaultroute\fR option\&.  This option is
very useful if the PPP server you dialed up will act as your Internet
gateway\&.
.P 1
.INDEX {ARP!proxy}
.INDEX {proxy ARP}
.INDEX {PPP!proxy ARP}
The reverse case, where your system acts as a gateway for a single
host, is also relatively easy to accomplish\&.  For example, take some
employee at the Virtual Brewery whose home machine is called
\fBloner\fR\&.  When connecting to \fBvlager\fR through PPP, he uses
an address on the Brewery's subnet\&.  At \fBvlager\fR, we can now give
\fIpppd\fR the \fBproxyarp\fR option, which will install a proxy
ARP entry for \fBloner\fR\&.  This will automatically make \fBloner\fR
accessible from all hosts at the Brewery and the Winery\&.
.P 1
.INDEX {LAN!connecting}
.INDEX {connecting LANs}
However, things aren't always as easy as that, for instance when
linking two local area networks\&.  This usually requires adding a
specific network route, because these networks may have their own
default routes\&.  Besides, having both peers use the PPP link as the
default route would generate a loop, where packets to unknown
destinations would ping-pong between the peers until their
time-to-live expired\&.
.P 1
As an example, suppose the Virtual Brewery opens a branch in some
other city\&. The subsidiary runs an Ethernet of their own using the IP
network number \fB191\&.72\&.3\&.0\fR, which is subnet 3 of the Brewery's
class B network\&. They want to connect to the Brewery's main Ethernet
via PPP to update customer databases, etc\&.  Again, \fBvlager\fR acts
as the gateway; its peer is called \fBsub-etha\fR and has an
IP address of \fB191\&.72\&.3\&.1\&.\fR\&.
.P 1
When \fBsub-etha\fR connects to \fBvlager\fR, it will make the
default route point to \fBvlager\fR as usual\&. On \fBvlager\fR,
however, we will have to install a network route for subnet 3 that
goes through \fBsub-etha\fR\&.  For this, we use a feature of
\fIpppd\fR not discussed so far -- the \fIip-up\fR command\&.  This is
a shell script or program located in \fI/etc/ppp\fR that is executed
after the PPP interface has been configured\&. When present, it is
invoked with the following parameters:
.P 1
.P 1
.DS I F 5
\fBip-up \fB\fIiface\fB\fB \fB\fIdevice\fB\fB \fB\fIspeed\fB\fB \fB\fIlocal_addr\fB\fB
\fB\fIremote_addr\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
where \fB\fIiface\fB\fR names the network interface used, \fB\fIdevice\fB\fR is the
pathname of the serial device file used (\fI/dev/tty\fR if stdin/stdout
are used), and \fB\fIspeed\fB\fR is the device's speed\&.  \fB\fIlocal_addr\fB\fR and
\fB\fIremote_addr\fB\fR give the IP addresses used at both ends of the link in
dotted quad notation\&. In our case, the \fIip-up\fR script may contain the
following code fragment:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#!/bin/sh
case $5 in
191.72.3.1)            # this is sub-etha
        route add -net 191.72.3.0 gw 191.72.3.1;;
...
esac
exit 0
.ENDVERBATIM
\"
\fR
.DE
.P 1
In a similar fashion, \fI/etc/ppp/ip-down\fR is used to undo all
actions of \fIip-up\fR after the PPP link has been taken down again\&.
.P 1
.INDEX {routing!dynamic}
.INDEX {gated@\fIgated\fR}
However, the routing scheme is not yet complete\&.  We have set up routing
table entries on both PPP hosts, but so far, all other hosts on both
networks don't know anything about the PPP link\&.  This is not a big
problem if all hosts at the subsidiary have their default route pointing
at \fBsub-etha\fR, and all Brewery hosts route to \fBvlager\fR by
default\&.  If this is not the case, your only option will usually be to
use a routing daemon like \fIgated\fR\&.  After creating the network
route on \fBvlager\fR, the routing daemon would broadcast the new
route to all hosts on the attached subnets\&.
.P 1
.INDEX {PPP!routing|)}
.P 1
.H 2 "Link Control Options"
.INDEX {Link Control Protocol (PPP)|(}
.P 1
Above, we already encountered LCP, the Link Control Protocol, which is
used to negotiate link characteristics, and to test the link\&.
.P 1
The two most important options that may be negotiated by LCP are the
maximum receive unit, and the Asynchronous Control Character Map\&.  There
are a number of other LCP configuration options, but they are far too
specialized to discuss here\&. Please refer to RFC 1548 for a description
of those\&.
.P 1
.INDEX {serial line!protecting characters}
.INDEX {PPP!escaping control characters}
.INDEX {PPP!async map}
The Asynchronous Control Character Map, colloquially called the async map,
is used on asynchronous links such as telephone lines to identify control
characters that must be escaped (replaced by a specific two-character
sequence)\&. For instance, you may want to avoid the XON and XOFF characters
used for software handshake, because some misconfigured modem might choke
upon receipt of an XOFF\&.  Other candidates include \fBCtrl-]\fR (the
\fItelnet\fR escape character)\&.  PPP allows you to escape any of the
characters with ASCII codes 0 through 31 by specifying them in the async
map\&.
.P 1
The async map is a bitmap 32 bits wide, with the least significant bit
corresponding to the ASCII NUL character, and the most significant bit
corrsponding to ASCII 31\&.  If a bit is set, it signals that the
corresponding character must be escaped before sending it across the
link\&.  Initially, the async map is set to \fI0xffffffff\fR, that is,
all control characters will be esaped\&.
.P 1
To tell your peer that it doesn't have to escape all control characters
but only a few of them, you can specify a new asyncmap to \fIpppd\fR
using the \fBasyncmap\fR option\&. For instance, if only \fB^S\fR and
\fB^Q\fR (ASCII 17 and 19, commonly used for XON and XOFF) must be
escaped, use the following option:
.P 1
.P 1
.DS I F 5
\fBasyncmap 0x000A0000
\"
\fR
.DE
.P 1
.INDEX {MRU|see PPP, Maximum Receive Unit}
.INDEX {PPP!Maximum Receive Unit}
.INDEX {Maximum Receive Unit (PPP)}
.INDEX {Maximum Transfer Unit}
The Maximum Receive Unit, or MRU, signals to the peer the maximum size
of HDLC frames we want to receive\&.  Although this may remind you of the
MTU value (Maximum Transfer Unit), these two have little in common\&. The
MTU is a parameter of the kernel networking device, and describes the
maximum frame size the interface is able to handle\&. The MRU is more of
an advice to the remote end not to generate any frames larger than the
MRU; the interface must nevertheless be able to receive frames of up to
1500 bytes\&.
.P 1
.INDEX {PPP!compressing data}
Choosing an MRU is therefore not so much a question of what the link is
capable of transferring, but of what gives you the best throughput\&.  If you
intend to run interactive applications over the link, setting the MRU to
values as low as 296 is a good idea, so that an occasional larger packet
(say, from an FTP session) doesn't make your cursor ``jump''\&.  To tell
\fIpppd\fR to request an MRU of 296, you would give it the option
\fBmru 296\fR\&.  Small MRUs, however, only make sense if you don't have
VJ header compression disabled (it is enabled by default)\&.
.P 1
\fIpppd\fR understands also a couple of LCP options that configure
the overall behavior of the negotiation process, such as the maximum
number of configuration requests that may be exchanged before the
link is terminated\&.  Unless you kow exactly what you are doing, you
should leave these alone\&.
.P 1
Finally, there are two options that apply to LCP echo messages\&. PPP
defines two messages, Echo Request and Echo Response\&. \fIpppd\fR uses
this feature to check if a link is still operating\&.  You can enable this
by using the \fBlcp-echo-interval\fR option together with a time in
seconds\&.  If no frames are received from the remote host within this
interval, \fIpppd\fR generates an Echo Request, and expects the peer to
return an Echo Response\&.  If the peer does not produce a response, the
link is terminated after a certain number of requests sent\&.  This number
can be set using the \fBlcp-echo-failure\fR option\&.  By default, this
feature is disabled altogether\&.
.P 1
.INDEX {Link Control Protocol (PPP)|)}
.P 1
.H 2 "General Security Considerations"
.INDEX {access!PPP}
.INDEX {pppd@\fIpppd\fR}
.INDEX {PPP!security}
.INDEX {security!PPP|(}
.P 1
A misconfigured PPP daemon can be a devastating security breach\&.  It can
be as bad as letting anyone plug in their machine into your Ethernet
(and that is very bad)\&. In this section, we will discuss a few measures
that should make your PPP configuration safe\&.
.P 1
One problem with \fIpppd\fR is that to configure the network device
and the routing table, it requires \fBroot\fR privilege\&.  You will
usually solve this by running it setuid \fBroot\fR\&. However,
\fIpppd\fR allows users to set various security-relevant options\&.  To
protect against any attacks a user may launch by manipulating these
options, it is suggested you set a couple of default values in the
global \fI/etc/ppp/options\fR file, like those shown in the sample
file in section 
.GETHN "ppp.ppprc"
\&\&.  Some of them, such as the
authentication options, cannot be overridden by the user, and so
provide a reasonable protection against manipulations\&.
.P 1
Of course, you have to protect yourself from the systems you speak PPP
with, too\&.  To fend off hosts posing as someone else, you should
always some sort of authentication from your peer\&.  Additionally, you
should not allow foreign hosts to use any IP address they choose, but
restrict them to at least a few\&.  The following section will deal with
these topics\&.
.P 1
.H 2 "Authentication with PPP"
.INDEX {PPP!authentication|(}
.P 1
.H 3 "CHAP versus PAP"
.INDEX {authorization!with PPP|(}
.INDEX {Challenge Handshake Authentication Protocol}
.INDEX {Password Authentication Protocol}
.INDEX {PPP!using PAP}
.INDEX {PPP!using CHAP}
.P 1
With PPP, each system may require its peer to authenticate itself
using one of two authentication protocols\&.  These are the Password
Authentication Protocol (PAP), and the Challenge Handshake
Authentication Protocol (CHAP)\&.  When a connection is established,
each end can request the other to authenticate itself, regardless of
whether it is the caller or the callee\&.  Below I will loosely talk of
`client' and `server' when I want to distinguish between the
authenticating system and the authenticator\&.  A PPP daemon can ask its
peer for authentication by sending yet another LCP configuration
request identifying the desired authentication protocol\&.
.P 1
PAP works basically the same way as the normal login procedure\&. The
client authenticates itself by sending a user name and an (optionally
encrypted) password to the server, which the server compares to its
secrets database\&.  This technique is vulnerable to eavesdroppers who may
try to obtain the password by listening in on the serial line, and to
repeated trial and error attacks\&.
.P 1
CHAP does not have these deficiencies\&. With CHAP, the authenticator
(i\&.e\&. the server) sends a randomly generated ``challenge'' string to
the client, along with its hostname\&. The client uses the hostname to
look up the appropriate secret, combines it with the challenge, and
encrypts the string using a one-way hashing function\&.  The result is
returned to the server along with the client's hostname\&. The server
now performs the same computation, and acknowledges the client if it
arrives at the same result\&.
.P 1
Another feature of CHAP is that it doesn't only require the client to
authenticate itself at startup time, but sends challenges at regular
intervals to make sure the client hasn't been replaced by an intruder,
for instance by just switching phone lines\&.
.P 1
\fIpppd\fR keeps the secret keys for CHAP and PAP in two separate
files, called \fI/etc/ppp/chap-secrets\fR and \fIpap-secrets\fR,
respectively\&.  By entering a remote host in one or the other file, you
have a fine control over whether CHAP or PAP is used to authenticate
ourselves with our peer, and vice versa\&.
.P 1
By default, \fIpppd\fR doesn't require authentication from the
remote, but will agree to authenticate itself when requested by the
remote\&.  As CHAP is so much stronger than PAP, \fIpppd\fR tries to
use the former whenever possible\&.  If the peer does not support it, or
if \fIpppd\fR can't find a CHAP secret for the remote system in its
\fIchap-secrets\fR file, it reverts to PAP\&. If it doesn't have a PAP
secret for its peer either, it will refuse to authenticate altogether\&.
As a consequence, the connection is closed down\&.
.P 1
This behavior can be modified in several ways\&. For instance, when
given the \fBauth\fR keyword, \fIpppd\fR will require the peer to
authenticate itself\&. \fIpppd\fR will agree to use either CHAP or PAP
for this, as long as it has a secret for the peer in its CHAP or PAP
database, respectively\&. There are other options to turn a particular
authentication protocol on or off, but I won't describe them here\&.
Please refer to the \fIpppd(8)\fR manual page for details\&.
.P 1
If all systems you talk PPP with agree to authenticate themselves with
you, you should put the \fBauth\fR option in the global
\fI/etc/ppp/options\fR file and define passwords for each system in the
\fIchap-secrets\fR file\&. If a system doesn't support CHAP, add an entry
for it to the \fIpap-secrets\fR file\&. In this way, you can make sure no
unauthenticated system connects to your host\&.
.P 1
The next two sections discuss the two PPP secrets files, \fIpap-secrets\fR
and \fIchap-secrets\fR\&. They are located in \fI/etc/ppp\fR and contain
triples of clients, servers and passwords, optionally followed by a list of
IP addresses\&.  The interpretation of the client and server fields is
different for CHAP and PAP, and also depends on whether we authenticate
ourselves with the peer, or whether we require the server to authenticate
itself with us\&.
.P 1
.H 3 "The CHAP Secrets File"
.INDEX {Challenge Handshake Authentication Protocol|(}
.INDEX {PPP!using CHAP|(}
.P 1
When it has to authenticate itself with some server using CHAP, \fIpppd\fR
searches the \fIpap-secrets\fR file for an entry with the client field
equal to the local hostname, and the server field equal to the remote
hostname sent in the CHAP Challenge\&.  When requiring the peer to
authenticate itself, the roles are simply reversed: \fIpppd\fR will then
look for an entry with the client field equal to the remote hostname (sent
in the client's CHAP Response), and the server field equal to the local
hostname\&.
.P 1
The following is a sample \fIchap-secrets\fR file for
\fBvlager\fR:(\*F)
.FS
The double quotes are not part of the password, they merely serve to
protect the white space within the password\&.
.FE
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# CHAP secrets for vlager.vbrew.com
#
# client          server            secret                addrs
#----------------------------------------------------------------------
vlager.vbrew.com  c3po.lucas.com    "Use The Source Luke" vlager.vbrew.com
c3po.lucas.com    vlager.vbrew.com  "riverrun, pasteve"   c3po.lucas.com
*                 vlager.vbrew.com  "VeryStupidPassword"  pub.vbrew.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
When establishing a PPP connection with \fBc3po\fR, \fBc3po\fR asks
\fBvlager\fR to authenticate itself using CHAP by sending a CHAP
challenge\&. \fIpppd\fR then scans \fIchap-secrets\fR for an entry
with the client field equal to \fBvlager\&.vbrew\&.com\fR and the server
field equal to \fBc3po\&.lucas\&.com\fR,(\*F)
.FS
This hostname is taken from the CHAP challenge\&.
.FE
and finds the first line shown above\&. It then produces the CHAP Response
from the challenge string and the secret (\fBUse The Source Luke\fR),
and sends it off to \fBc3po\fR\&.
.P 1
At the same time, \fIpppd\fR composes a CHAP challenge for \fBc3po\fR,
containing a unique challenge string, and its fully qualified hostname
\fBvlager\&.vbrew\&.com\fR\&. \fBc3po\fR constructs a CHAP Response in the
manner we just discussed, and returns it to \fBvlager\fR\&. \fIpppd\fR now
extracts the client hostname (\fBc3po\&.vbrew\&.com\fR) from the Response, and
searches the \fIchap-secrets\fR file for a line matching \fBc3po\fR as a
client, and \fBvlager\fR as the server\&. The second line does this, so
\fIpppd\fR combines the CHAP challenge and the secret \fBriverrun,
pasteve\fR, encrypts them, and compares the result to \fBc3po\fR's CHAP
respnose\&.
.P 1
.INDEX {address!negotiation with PPP}
.INDEX {IP!address!negotiation in PPP}
.INDEX {access!restricting}
The optional fourth field lists the IP addresses that are acceptable
for the clients named in the first field\&. The addresses may be given
in dotted quad notation or as hostnames that are looked up with the
resolver\&.  For instance, if \fBc3po\fR requests to use an IP address
during IPCP negotiation that is not in this list, the request will be
rejected, and IPCP will be shut down\&.  In the sample file shown above,
\fBc3po\fR is therefore limited to using its own IP address\&.  If the
address field is empty, any addresses will be allowed; a value of
\fI-\fR prevents the use of IP with that client altogether\&.
.P 1
The third line of the sample \fIchap-secrets\fR file allows any host to
establish a PPP link with \fBvlager\fR because a client or server field of
\fI*\fR matches any hostname\&.  The only requirement is that it knows
the secret, and uses the address of \fBpub\&.vbrew\&.com\fR\&.  Entries with
wildcard hostnames may appear anywhere in the secrets file, since
\fIpppd\fR will always use the most specific entry that applies to a
server/client pair\&.
.P 1
There are some words to be said about the way \fIpppd\fR arrives at the
hostnames it looks up in the secrets file\&. As explained before, the remote
hostname is always provided by the peer in the CHAP Challenge or Response
packet\&.  The local hostname will be derived by calling the
\fIgethostname(2)\fR function by default\&. If you have set the system
name to your unqualified hostname, such you have to provide \fIpppd\fR
with the domain name in addition using the \fBdomain\fR option:
.P 1
.P 1
.DS I F 5
\fB# pppd \&.\&.\&.domain vbrew\&.com
\"
\fR
.DE
.P 1
This will append the Brewery's domain name to \fBvlager\fR for all
authentication-related activities\&.  Other options that modify
progpppd's idea of the local hostname are \fBusehostname\fR and
\fBname\fR\&.  When you give the local IP address on the command line
using ``\fB\fIlocal\fB\fR\fB:\fRvarremote'', and \fB\fIlocal\fB\fR is a name
instead of a dotted quad, \fIpppd\fR will use this as the local
hostname\&. For details, please refer to the \fIpppd(8)\fR manual page\&.
.P 1
.INDEX {PPP!using CHAP|)}
.INDEX {Challenge Handshake Authentication Protocol|)}
.P 1
.H 3 "The PAP Secrets File"
.INDEX {PPP!using PAP|(}
.P 1
The PAP secrets file is very similar to that used by CHAP\&. The first two
fields always contain a user name and a server name; the third holds the
PAP secret\&.  When the remote sends an authenticate request, \fIpppd\fR
uses the entry that has a server field equal to the local hostname, and
a user field equal to the user name sent in the request\&.  When
authenticating itself with the peer, \fIpppd\fR picks the secret to be
sent from the line with the user field equal to the local user name, and
the server field equal to the remote hostname\&.
.P 1
A sample PAP secrets file might look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /etc/ppp/pap-secrets
#
# user          server          secret          addrs
vlager-pap      c3po            cresspahl       vlager.vbrew.com
c3po            vlager          DonaldGNUth     c3po.lucas.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
The first line is used to authenticate ourselves when talking to
\fBc3po\fR\&.  The second line describes how a user named \fBc3po\fR has
to authenticate itself with us\&.
.P 1
The name \fBvlager-pap\fR in column one is the user name we
send to \fBc3po\fR\&.  By default, \fIpppd\fR will pick the local
hostname as the user name, but you can also specify a different name by
giving the \fBuser\fR option, followed by that name\&.
.P 1
When picking an entry from the \fIpap-secrets\fR file for
authentication with the peer, \fIpppd\fR has to know the remote host's
name\&.  As it has no way of finding that out, you have to specify it on
the command line using the \fBremotename\fR keyword, followed by the
peer's hostname\&. For instance, to use the above entry for authentication with 
\fBc3po\fR, we have to add the following option to \fIpppd\fR's command
line:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 \#{} pppd ... remotename c3po user vlager-pap
.ENDVERBATIM
\"
\fR
.DE
.P 1
In the fourth field (and all fields following), you may specify what
IP addresses are allowed for that particular host, just as in the CHAP
secrets file\&.  The peer may then only request addresses from that list\&.
In the sample file, we require \fBc3po\fR to use its real IP address\&.
.P 1
Note that PAP is a rather weak authentication method, and it is
suggested you use CHAP instead whenever possible\&. We will therefore
not cover PAP in greater detail here;  if you are interested in using
PAP, you will find some more PAP features in the \fIpppd(8)\fR manual
page\&.
.P 1
.INDEX {PPP!using PAP|)}
.P 1
.INDEX {authorization!with PPP|)}
.INDEX {PPP!authentication|)}
.INDEX {security!PPP|)}
.P 1
.H 2 "Configuring a PPP Server"
.INDEX {PPP!server}
.P 1
Running \fIpppd\fR as a server is just a matter of adding the appropriate
options to the command line\&.  Ideally, you would create a special account,
say \fBppp\fR, and give it a script or program as login shell that invokes
\fIpppd\fR with these options\&. For instance, you would add the following
line to \fI/etc/passwd\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
ppp:*:500:200:Public PPP Account:/tmp:/etc/ppp/ppplogin
.ENDVERBATIM
\"
\fR
.DE
.P 1
Of course, you may want to use different uids and gids than those shown
above\&. You would also have to set the password for the above account
using the \fIpasswd\fR command\&.
.P 1
The \fIppplogin\fR script might then look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#!/bin/sh
# ppplogin - script to fire up pppd on login
mesg n
stty -echo
exec pppd -detach silent modem crtscts
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fImesg\fR command disables other users to write to the tty
using, for instance, the \fIwrite\fR command\&. The \fIstty\fR command
turns off character echoing\&. The is necessary, because otherwise
everything the peer sends would be echoed back to it\&.  The most
important \fIpppd\fR option given above is \fB-detach\fR, because
it prevents \fIpppd\fR drom detaching from the controlling tty\&.  If
we didn't specify this option, it would go to the background, making
the shell script exit\&. This would in turn would cause the serial line
to be hung up and the connection to be dropped\&.  The \fIsilent\fR
option causes \fIpppd\fR to wait until it receives a packet from the
calling system before it starts sending\&. This prevents transmit
timeouts to occur when the calling system is slow in firing up its PPP
client\&.  The \fBmodem\fR makes \fIpppd\fR watch the DTR line to
see if the peer has dropped the connection, and \fBcrtscts\fR turns
on hardware handshake\&.
.P 1
Beside these options, you might want to force some sort of authentication,
for example by specifying \fBauth\fR on \fIpppd\fR's command line, or
in the global options file\&.  The manual page also discusses more specific
options for turning individual authentication protocols on and off\&.
.P 1
.INDEX {pppd@\fIpppd\fR|)}
.P 1
.INDEX {PPP|)}
.INDEX {configuring!PPP|)}
.P 1
.H 1 "Various Network Applications"
.SETR "appl"
.P 1
After successfully setting up IP and the resolver, you have to turn to
the services you want to provide over the network\&. This chapter covers
the configuration of a few simple network applications, including the
\fIinetd\fR server, and the programs from the \fIrlogin\fR family\&.
The Remote Procedure Call interface that services like the Network File
System (NFS) and the Network Information System (NIS) are based upon
will be dealt with briefly, too\&. The configuration of NFS and NIS,
however, takes up more room, will be described in separate chapters\&.
This applies to electronic mail and netnews as well\&.
.P 1
Of course, we can't cover all network applications in this book\&. If you
want to install one that's not discussed here, like \fItalk\fR,
\fIgopher\fR, or \fIXmosaic\fR please refer to its manual pages for
details\&.
.P 1
.H 2 "The inetd Super-Server"
.SETR "appl.inetd"
.INDEX {inetd@\fIinetd\fR}
.INDEX {services!setting up}
.INDEX {server!inetd@\fIinetd\fR|(}
.INDEX {configuring!network services}
.P 1
Frequently, services are performed by so-called \fIdaemons\fR\&. A daemon
is a program that opens a certain port, and waits for incoming
connections\&.  If one occurs, it creates a child process which accepts
the connection, while the parent continues to listen for further
requests\&.  This concept has the drawback that for every service offered,
a daemon has to run that listens on the port for a connection to occur,
which generally means a waste of system resources like swap space\&.
.P 1
Thus, almost all Un*x installations run a ``super-server'' that
creates sockets for a number of services, and listens on all of them
simultaneously using the \fIselect(2)\fR system call\&. When a remote
host requests one of the services, the super-server notices this and
spawns the server specified for this port\&.
.P 1
.INDEX {inetd\&.conf@\fIinetd\&.conf\fR|(}
.INDEX {chargen@\fIchargen\fR}
.INDEX {daytime@\fIdaytime\fR}
The super-server commonly used is \fIinetd\fR, the Internet Daemon\&.
It is started at system boot time, and takes the list of services it
is to manage from a startup file named \fI/etc/inetd\&.conf\fR\&.  In
addition to those servers invoked, there are a number of trivial
services which are performed by \fIinetd\fR itself called \fIinternal
services\fR\&. They include \fIchargen\fR which simply generates a string of
characters, and \fIdaytime\fR which returns the system's idea of the time
of day\&.
.P 1
An entry in this file consists of a single line made up of the
following fields:
.P 1
.P 1
.DS I F 5
\fB\fB\fIservice type protocol wait user server cmdline\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
The meaning of each field is as follows:
.P 1
\"
.BL 10
.LI "\fB\fIservice\fB\fR"
.INDEX {services@\fIservices\fR}
gives the service name\&. The service name has to be translated to
a port number by looking it up in the \fI/etc/services\fR file\&.
This file will be described in section 
.GETHN "appl.services"
\&
below\&.
.P 1
.LI "\fB\fItype\fB\fR"
specifies a socket type, either \fIstream\fR (for
connection-oriented protocols) or \fIdgram\fR (for datagram
protocols)\&.  TCP-based services should therefore always use
\fIstream\fR, while UDP-based services should always use
\fIdgram\fR\&.
.P 1
.LI "\fB\fIprotocol\fB\fR"
.INDEX {protocols@\fIprotocols\fR}
names the transport protocol used by the service\&. This must be a
valid protocol name found in the \fIprotocols\fR file, also
explained below\&.
.P 1
.LI "\fB\fIwait\fB\fR"
This option applies only to \fIdgram\fR sockets\&. It may
be either \fIwait\fR or \fInowait\fR\&. If \fIwait\fR is
specified, \fIinetd\fR will only execute one server for
the specified port at any time\&. Otherwise, it will immediately
continue to listen on the port after executing the server\&.
.P 1
This is useful for ``single-threaded'' servers that read all
incoming datagrams until no more arrive, and then exit\&. Most RPC
servers are of this type and should therefore specify
\fIwait\fR\&.  The opposite type, ``multi-threaded'' servers,
allow an unlimited number of instances to run concurrently; this
is only rarely used\&. These servers should specify
\fInowait\fR\&.
.P 1
\fIstream\fR sockets should always use \fInowait\fR\&.
.P 1
.LI "\fB\fIuser\fB\fR"
This is the login id of the user the process is executed under\&.
This will frequently be the \fBroot\fR user, but some services
may use different accounts\&. It is a very good idea to apply the
principle of least privilege here, which states that you shouldn't
run a command under a privileged account if the program doesn't
require this for proper functioning\&.
For example, the NNTP news server will run as \fBnews\fR, while
services that may pose a security risk (such as \fItftp\fR or
\fIfinger\fR) are often run as \fBnobody\fR\&.
.P 1
.LI "\fB\fIserver\fB\fR"
gives the full path name of the server program to be executed\&.
Internal services are marked by the keyword \fIinternal\fR\&.
.P 1
.LI "\fB\fIcmdline\fB\fR"
This is the command line to be passed to the server\&. This includes
argument 0, that is the command name\&. Usually, this will be
the program name of the server, unless the program behaves
differently when invoked by a different name\&.
.P 1
This field is empty for internal services\&.
.P 1
\"
.LE
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
# 
# inetd services
ftp       stream tcp nowait root   /usr/sbin/ftpd    in.ftpd -l
telnet    stream tcp nowait root   /usr/sbin/telnetd in.telnetd -b/etc/issue
#finger    stream tcp nowait bin    /usr/sbin/fingerd in.fingerd
#tftp      dgram  udp wait   nobody /usr/sbin/tftpd   in.tftpd
#tftp      dgram  udp wait   nobody /usr/sbin/tftpd   in.tftpd /boot/diskless
login     stream tcp nowait root   /usr/sbin/rlogind in.rlogind
shell     stream tcp nowait root   /usr/sbin/rshd    in.rshd
exec      stream tcp nowait root   /usr/sbin/rexecd  in.rexecd
#
#       inetd internal services
#
daytime   stream tcp nowait root internal
daytime   dgram  udp nowait root internal
time      stream tcp nowait root internal
time      dgram  udp nowait root internal
echo      stream tcp nowait root internal
echo      dgram  udp nowait root internal
discard   stream tcp nowait root internal
discard   dgram  udp nowait root internal
chargen   stream tcp nowait root internal
chargen   dgram  udp nowait root internal
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " A sample \fI/etc/inetd\&\&.conf\fR file\&\&. " "" 0 "appl.fig.inetd.conf"
.DE
.P 1
.INDEX {security!TCP servers}
.INDEX {finger@\fIfinger\fR}
A sample \fIinetd\&.conf\fR file is shown in figure 
.GETHN "appl.fig.inetd.conf"
\&\&.
The \fIfinger\fR service commented out, so that it is not available\&.
This is often done for security reasons, because may be used by
attackers to obtain names of users on your system\&.
.P 1
.INDEX {TFTP|see Trivial File Transfer Protocol}
.INDEX {Trivial File Transfer Protocol}
.INDEX {tftp@\fItftp\fR}
The \fItftp\fR is shown commented out as well\&. \fItftp\fR implements
the \fIPrimitive File Transfer Protocol\fR that allows to transfer any
world-readable files from your system without password checking etc\&.
This is especially harmful with the \fI/etc/passwd\fR file, even more
so when you don't use shadow password\&.
.P 1
TFTP is commonly used by diskless clients and X terminals to download
their code from a boot server\&. If you need to run \fItftpd\fR for this
reason, make sure to limit its scope to those directories clients will
retrieve files from by adding those directory names to \fItftpd\fR's
command line\&. This is shown in the second \fItftp\fR line in the
example\&.
.P 1
.INDEX {inetd\&.conf@\fIinetd\&.conf\fR|)}
.P 1
.H 2 "The tcpd access control facility"
.SETR "appl.tcpd"
.INDEX {security!TCP servers}
.INDEX {services!restricting access}
.INDEX {access!restricting}
.INDEX {restricting access}
.INDEX {wrapper, TCP}
.INDEX {TCP!wrapper program}
.INDEX {tcpd@\fItcpd\fR|(}
.INDEX {server!inetd@\fItcpd\fR|(}
.P 1
Since opening a computer to network access involves many security risks,
applications are designed to guard against several types of attacks\&.
Some of these, however, may be flawed (most drastically demonstrated
by the RTM Internet worm), or do not distinguish between secure hosts
from which requests for a particular service will be accepted, and
insecure hosts whose requests should be rejected\&. We already briefly
discussed the \fIfinger\fR and \fItftp\fR services above\&.  Thus, one
would want to limit access to these services to ``trusted hosts'' only,
which is impossible with the usual setup, where \fIinetd\fR either
provides this service to all clients, or not at all\&.
.P 1
A useful tool for this is \fItcpd\fR,(\*F)
.FS
Written by Wietse Venema, \fBwietse@wzv\&.win\&.tue\&.nl\fR\&.
.FE
a so-called daemon wrapper\&. For TCP services you want to monitor or
protect, it is invoked instead of the server program\&. \fItcpd\fR logs
the request to the \fIsyslog\fR daemon, ckecks if the remote host is
allowed to use that service, and only if this succeeds will it executes
the real server program\&. Note that this does not work with UDP-based
services\&.
.P 1
For example, to wrap the \fIfinger\fR daemon, you have to change the
corresponding line in \fIinetd\&.conf\fR to
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# wrap finger daemon
finger  stream  tcp     nowait  root    /usr/sbin/tcpd   in.fingerd
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {syslog@\fIsyslog\fR}
Without adding any access control, this will appear to the client
just as a usual \fIfinger\fR setup, except that any requests are logged
to \fIsyslog\fR's \fIauth\fR facility\&.
.P 1
Access control is implemented by means of two files called
\fI/etc/hosts\&.allow\fR and \fI/etc/hosts\&.deny\fR\&.  They contain
entries allowing and denying access, respectively, to certain services
and hosts\&.  When \fItcpd\fR handles a request for a service such as
\fIfinger\fR from a client host named \fBbiff\&.foobar\&.com\fR, it
scans \fIhosts\&.allow\fR and \fIhosts\&.deny\fR (in this order) for an
entry matching both the service and client host\&. If a matching entry
is found in \fIhosts\&.allow\fR, access is granted, regardless of any
entry in \fIhosts\&.deny\fR\&. If a match is found in \fIhosts\&.deny\fR,
the request is rejected by closing down the connection\&. If no match is
found at all, the request is accepted\&.
.P 1
Entries in the access files look like this:
.P 1
.P 1
.DS I F 5
\fB\fB\fIservicelist\fB\fB: \fB\fIhostlist\fB\fB [:\fB\fIshellcmd\fB\fB]
\"
\fR
.DE
.P 1
\fB\fIservicelist\fB\fR is a list of service names from \fI/etc/services\fR,
or the keyword \fIALL\fR\&. To match all services except \fIfinger\fR and
\fItftp\fR, use ``\fIALL\fR \fIEXCEPT\fR \fIfinger, tftp\fR''\&.
.P 1
\fB\fIhostlist\fB\fR is a list of host names or IP addresses, or the keywords
\fIALL\fR, \fILOCAL\fR, or \fIUNKNOWN\fR\&. \fIALL\fR matches any host,
while \fILOCAL\fR matches host names not containing a dot\&.(\*F)
.FS
Usually only local host names obtained from lookups in \fI/etc/hosts\fR
contain no dots\&.
.FE
\fIUNKNOWN\fR matches any hosts whose name or address lookup failed\&.
A name starting with a dot matches all hosts whose domain is equal to this
name\&. For example, \fB\&.foobar\&.com\fR matches \fBbiff\&.foobar\&.com\fR\&.
There are also provisions for IP network addresses and subnet numbers\&.
Please refer to the \fIhosts_access(5)\fR manual page for details\&.
.P 1
To deny access to the \fIfinger\fR and \fItftp\fR services to all but
the local hosts, put the following in \fI/etc/hosts\&.deny\fR, and leave
\fI/etc/hosts\&.allow\fR empty:
.P 1
.P 1
.DS I F 5
\fBin\&.tftpd, in\&.fingerd: ALL EXCEPT LOCAL, \fB\fI\&.your\&.domain\fB\fB
\"
\fR
.DE
.P 1
The optional \fB\fIshellcmd\fB\fR field may contain a shell command
to be invoked when the entry is matched\&. This is useful to set up
traps that may expose potential attackers:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
in.ftpd: ALL EXCEPT LOCAL, .vbrew.com : \
      echo "request from %d@%h" >> /var/log/finger.log; \
      if [ %h != "vlager.vbrew.com" ]; then \
          finger -l @%h >> /var/log/finger.log \
      fi
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fI%h\fR and \fI%d\fR arguments are expanded by \fItcpd\fR
to the client host name and service name, respectively\&. Please refer to the
\fIhosts_access(5)\fR manual page for details\&.
.P 1
.INDEX {tcpd@\fItcpd\fR|)}
.INDEX {server!inetd@\fItcpd\fR|)}
.INDEX {server!inetd@\fIinetd\fR|)}
.P 1
.H 2 "The services and protocols Files"
.SETR "appl.services"
.SETR "appl.protocols"
.INDEX {services@\fIservices\fR|(}
.INDEX {protocols@\fIprotocols\fR|(}
.INDEX {services!well-known}
.P 1
The port numbers on which certain ``standard'' services are offered are
defined in the ``Assigned Numbers'' RFC\&. To enable server and client
programs to convert service names to these numbers, at least a part of
the list is kept on each host; it is stored in a file called
\fI/etc/services\fR\&.  An entry is made up like this:
.P 1
.P 1
.DS I F 5
\fB\fB\fIservice\fB\fB \fB\fIport\fB\fB/\fB\fIprotocol\fB\fB   [\fB\fIaliases\fB\fB]
\"
\fR
.DE
.P 1
Here, \fB\fIservice\fB\fR specifies the service name, \fB\fIport\fB\fR defines the
port the service is offered on, and \fB\fIprotocol\fB\fR defines which
transport protocol is used\&. Commonly, this is either \fIudp\fR or
\fItcp\fR\&. It is possible for a service to be offered for more
than one protocol, as well as offering different services on the same
port, as long as the protocols are different\&. The \fB\fIaliases\fB\fR field
allows to specify alternative names for the same service\&.
.P 1
Usually, you don't have to change the services file that comes along
with the network software on your Linux system\&. Nevertheless, we
give a small excerpt from that file below\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# The services file:
#
# well-known services
echo           7/tcp                 # Echo
echo           7/udp                 #
discard        9/tcp  sink null      # Discard
discard        9/udp  sink null      #
daytime       13/tcp                 # Daytime
daytime       13/udp                 #
chargen       19/tcp  ttytst source  # Character Generator
chargen       19/udp  ttytst source  #
ftp-data      20/tcp                 # File Transfer Protocol (Data)
ftp           21/tcp                 # File Transfer Protocol (Control)
telnet        23/tcp                 # Virtual Terminal Protocol
smtp          25/tcp                 # Simple Mail Transfer Protocol
nntp         119/tcp  readnews       # Network News Transfer Protocol
#
# UNIX services
exec         512/tcp                 # BSD rexecd
biff         512/udp  comsat         # mail notification
login        513/tcp                 # remote login
who          513/udp  whod           # remote who and uptime
shell        514/tcp  cmd            # remote command, no passwd used
syslog       514/udp                 # remote system logging
printer      515/tcp  spooler        # remote print spooling
route        520/udp  router routed  # routing information protocol
.ENDVERBATIM
\"
\fR
.DE
.P 1
Note that, for example, the \fIecho\fR service is offered on
port 7 for both TCP and UDP, and that port 512 is used for two different
services, namely the COMSAT daemon (which notifies users of newly
arrived mail, see \fIxbiff(1x)\fR), over UDP, and for remote
execution (\fIrexec(1)\fR), using TCP\&.
.P 1
.INDEX {protocol numbers}
Similar to the services file, the networking library needs a way to
translate protocol names --- for example, those used in the services
file --- to protocol numbers understood by the IP layer on other hosts\&.
This is done by looking up the name in the \fI/etc/protocols\fR file\&.
It contains one entry per line, each containing a protocol name, and the
associated number\&. Having to touch this file is even more unlikely than
having to meddle with \fI/etc/services\fR\&. A sample file is given 
below:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# Internet (IP) protocols
#
ip      0       IP              # internet protocol, pseudo protocol number
icmp    1       ICMP            # internet control message protocol
igmp    2       IGMP            # internet group multicast protocol
tcp     6       TCP             # transmission control protocol
udp     17      UDP             # user datagram protocol
raw     255     RAW             # RAW IP interface
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {services@\fIservices\fR|)}
.INDEX {protocols@\fIprotocols\fR|)}
.P 1
.H 2 "Remote Procedure Call"
.SETR "appl.rpc"
.INDEX {Remote Procedure Call|(}
.INDEX {RPC|see Remote Procedure Call}
.P 1
A very general mechanism for client-server applications is provided by
RPC, the \fIRemote Procedure Call\fR package\&. RPC was developed by Sun
Micrsystems, and is a collection of tools and library functions\&.
Important applications built on top of RPC are NFS, the Network
Filesystem, and NIS, the Network Information System, both of which will
be introduced in later chapters\&.
.P 1
.INDEX {External Data Representation}
.INDEX {XDR|see External Data Representation}
An RPC server consists of a collection of procedures that client may
call by sending an RPC request to the server, along with the procedure
parameters\&. The server will invoke the indicated procedure on behalf of
the client, handing back the return value, if there is any\&.  In order to
be machine-independent, all data exchanged between client and server is
converted to a so-called \fIExternal Data Representation\fR format (XDR)
by the sender, and converted back to the machine-local representation by
the receiver\&.
.P 1
Sometimes, improvements to an RPC application introduce incompatible
changes in the procedure call interface\&. Of course, simply changing the
server would crash all application that still expect the original
behavior\&.  Therefore, RPC programs have version numbers assigned to
them, usually starting with 1, and with each new version of the RPC
interface this counter will be bumped\&. Often, a server may offer several
versions simultaneously; clients then indicate by the version number in
their requests which implementation of the service they want to use\&.
.P 1
.INDEX {rpc@\fIrpc\fR}
.INDEX {Remote Procedure Call!program numbers}
The network communication between RPC servers and clients is somewhat
peculiar\&. An RPC server offers one or more collections of procedures;
each set is being called a \fIprogram\fR, and is uniquely identified
by a \fIprogram number\fR\&. A list mapping service names to program numbers
is usually kept in \fI/etc/rpc\fR, an excerpt of which is reproduced below
in figure 
.GETHN "rpc.fig"
\&\&.
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# /etc/rpc - miscellaenous RPC-based services
#
portmapper      100000  portmap sunrpc
rstatd          100001  rstat rstat_svc rup perfmeter
rusersd         100002  rusers
nfs             100003  nfsprog
ypserv          100004  ypprog
mountd          100005  mount showmount
ypbind          100007
walld           100008  rwall shutdown
yppasswdd       100009  yppasswd
bootparam       100026
ypupdated       100028  ypupdate
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " A sample \fI/etc/rpc\fR file\&\&. " "" 0 "rpc.fig"
.DE
.P 1
In TCP/IP networks, the authors of RPC were faced with  the problem of
mapping program numbers to generic network services\&. They
chose to have each server provide both a TCP and a UDP port for each
program and each version\&. Generally, RPC applications will use UDP when
sending data, and only fall back to TCP when the data to be transferred
doesn't fit into a single UDP datagram\&.
.P 1
.INDEX {portmapper daemon}
.INDEX {Remote Procedure Call!mapping ports to programs}
.INDEX {portmap@\fIportmap\fR}
Of course, client programs have to have a way to find out which port
a program number maps to\&. Using a configuration file for this would be
too unflexible; since RPC applications don't use reserved ports, there's
no guarantee that a port originally meant to be used by our database
application hasn't been taken by some other process\&. Therefore, RPC
applications pick any port they can get, and register it with the so-called
\fIportmapper daemon\fR\&. The latter acts as a service broker for all
RPC servers running on its machine: a client that wishes to contact
a service with a given program number will first query the portmapper
on the server's host which returns the TCP and UDP port numbers the
service can be reached at\&.
.P 1
.INDEX {inetd@\fIinetd\fR}
This method has the particular drawback that it introduces a single point
of failure, much like the \fIinetd\fR daemon does for the standard
Berkeley services\&. However, this case is even a little worse, because
when the portmapper dies, all RPC port information is lost; this
usually means you have to restart all RPC servers manually, or reboot
the entire machine\&.
.P 1
On Linux, the portmapper is called \fIrpc\&.portmap\fR and resides
in \fI/usr/sbin\fR\&. Other than making sure it is started form
\fIrc\&.inet2\fR, the portmapper doesn't require any configuration work\&.
.P 1
.INDEX {Remote Procedure Call|)}
.P 1
.H 2 "Configuring the r Commands"
.SETR "appl.remote"
.INDEX {configuring!the r commands@the \fIr\fR commands|(}
.INDEX {authorization!and r commands@and \fIr\fR commands}
.INDEX {LAN!r commands@\fIr\fR commands}
.INDEX {LAN!passwords}
.INDEX {passwords!and remote login}
.INDEX {remote!command execution}
.INDEX {security!r commands@\fIr\fR commands}
.INDEX {security!remote login}
.INDEX {remote!login}
.INDEX {remote!file access}
.INDEX {rlogin@\fIrlogin\fR}
.INDEX {rcp@\fIrcp\fR}
.INDEX {rsh@\fIrsh\fR}
.P 1
There are a number of commands for executing commands on remote
hosts\&. These are \fIrlogin\fR, \fIrsh\fR, \fIrcp\fR and \fIrcmd\fR\&.
They all spawn a shell on the remote host and allow the user
to execute commands\&. Of course, the client needs to have an account
on the host where the commmand is to be executed\&. Thus all these commands
perform an authorization procedure\&. Usually, the client will tell
the user's login name to the server, which in turn requests a password
that is validated in the usual way\&.
.P 1
Sometimes, however, it is desirable to relax authorization checks for
certain users\&.  For instance, if you frequently have to log into other
machines on your LAN, you might want to be admitted without having to
type your password every time\&.
.P 1
Disabling authorization is advisable only on a small number of hosts
whose password databases are synchronized, or for a small number of
privileged users who need to access many machines for administrative
reasons\&. Whenever you want to allow people to log into your host without
having to specify a login id or password, make sure that you don't
accidentally grant access to anybody else\&.
.P 1
.INDEX {hosts\&.equiv@\fIhosts\&.equiv\fR}
.INDEX {rhosts@\fI\&.rhosts\fR}
There are two ways to disable authorization checks for the \fIr\fR
commands\&. One is for the super user to allow certain or all
users on certain or all hosts (the latter definitely being a bad
idea) to log in without being asked for a password\&. This access
is controlled by a file called \fI/etc/hosts\&.equiv\fR\&. It contains
a list of host and user names that are considered equivalent to users
on the local host\&.  An alternative option is for a user to grant other
users on certain hosts access to her account\&. These may be listed in the
file \fI\&.rhosts\fR in the user's home directory\&. For security reasons,
this file must be owned by the user or the super user, and must not be a
symbolic link, otherwise it will be ignored\&.(\*F)
.FS
In an NFS environment, you may need to give it a protection of 444,
because the super user is often very restricted in accessing files on
disks mounted via NFS\&.
.FE
.P 1
When a client requests an \fIr\fR service, her host and user name are
searched in the \fI/etc/hosts\&.equiv\fR file, and then in the
\fI\&.rhosts\fR file of the user she wants to log in as\&. As am example,
assume \fBjanet\fR is working on \fBgauss\fR and tries to log into
\fBjoe\fR's account on \fBeuler\fR\&. Throughout the following, we will
refer to Janet as the \fIclient\fR user, and to Joe as the \fIlocal\fR
user\&.  Now, when Janet types
.P 1
.P 1
.DS I F 5
\fB$ rlogin -l joe euler
\"
\fR
.DE
.P 1
.br
.ti 0
on \fBgauss\fR, the server will first check \fIhosts\&.equiv\fR(\*F)
.FS
Note that the \fIhosts\&.equiv\fR file is \fInot\fR
searched when someone attempts to log in as \fBroot\fR\&.
.FE
if Janet should be granted free access, and if this fails,
it will try to look her up in \fI\&.rhosts\fR in \fBjoe\fR's home directory\&.
.P 1
The \fIhosts\&.equiv\fR file on \fBeuler\fR looks like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
gauss
euler
-public
quark.physics.groucho.edu     andres
.ENDVERBATIM
\"
\fR
.DE
.P 1
An entry consists of a host name, optionally followed by a user name\&.
If a host name appears all by itself, all users from that host will be
admitted to their local accounts without any checks\&. In the above
example, Janet would be allowed to log into her account \fBjanet\fR
when coming from \fBgauss\fR, and the same applies to any other user
except \fBroot\fR\&. However, if Janet wants to log in as \fBjoe\fR,
she will be prompted for a password as usual\&.
.P 1
If a host name is followed by a user name, as in the last line of the
above sample file, this user is given password-free access to \fIall\fR
accounts except the \fBroot\fR account\&.
.P 1
The host name may also be preceded by a minus sign, as in the entry
``\fB-public\fR''\&. This requires authorization for all accounts on
\fBpublic\fR, regardless of what rights individual users grant in their
\fI\&.rhosts\fR file\&.
.P 1
The format of the \fI\&.rhosts\fR file is identical to that of
\fIhosts\&.equiv\fR, but its meaning is  a little different\&. Consider
Joe's \fI\&.rhosts\fR file on \fBeuler\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
chomp.cs.groucho.edu
gauss      janet
.ENDVERBATIM
\"
\fR
.DE
.P 1
The first entry grants \fBjoe\fR free acess when logging in from
\fBchomp\&.cs\&.groucho\&.edu\fR, but does not affect the rights of any other
account on \fBeuler\fR or \fBchomp\fR\&. The second entry is a slight
variation of this, in that it grants \fBjanet\fR free access to Joe's
account when logging in from \fBgauss\fR\&.
.P 1
Note that the client's host name is obtained by reverse mapping the
caller's address to a name, so that this feature will fail with hosts
unknown to the resolver\&. The client's host name is considered to match
the name in the hosts files in one of the following cases:
.P 1
\"
.BL 10
.LI
The client's canonical host name (not an alias) literally
matches the host name in the file\&.
.P 1
.LI
If the client's host name is a fully qualified domain name (such
as returned by the resolver when you have DNS running), and it
doesn't literally match the host name in the hosts file, it is
compared to that host name expanded with the local domain name\&.
.P 1
\"
.LE
.P 1
.INDEX {configuring!the r commands@the \fIr\fR commands|)}
.P 1
.H 1 "The Network Information System"
.SETR "nis"
.INDEX {configuring!NIS|(}
.INDEX {Network Information System|see NIS}
.INDEX {Yellow Pages|see NIS}
.INDEX {YP|see NIS}
.INDEX {NIS|(}
.INDEX {network!synchronizing passwords}
.INDEX {hostname!resolution}
.P 1
When you are running a local area network, your overall goal is usually
to provide an environment to your users that makes the network
transparent\&.  An important stepping stone to this end is to keep vital
data such as user account information synchronized between all hosts\&.
We have seen before that for host name resolution, a powerful and
sophisticated service exists, being DNS\&. For others tasks, there is no
such specialized service\&. Moreover, if you manage only a small LAN with
no Internet connectivity, setting up DNS may not seem worth the trouble
for many administrators\&.
.P 1
This is why Sun developed NIS, the \fINetwork Information System\fR\&.
NIS provides generic database access facilities that can be used to
distribute information such as that contained in the \fIpasswd\fR and
\fIgroups\fR files to all hosts on your network\&.  This makes the
network appear just as a single system, with the same accounts on all
hosts\&. In a similar fashion, you can use NIS to distribute the hostname
information form \fI/etc/hosts\fR to all machines on the network\&.
.P 1
NIS is based on RPC, and comprises a server, a client-side library, and
several administrative tools\&.  Originally, NIS was called \fIYellow
Pages\fR, or YP, which is still widely used to informally refer this
service\&. On the other hand, Yellow Pages is a trademark of British
Telecom, which required Sun to drop that name\&. As things go, some
names stick with people, and so YP lives on as a prefix to the names
of most NIS-related commands such as \fIypserv\fR, \fIypbind\fR,
etc\&.
.P 1
.INDEX {Thummler, Swen@Th\C':u'mmler, Swen}
.INDEX {Reber, Tobias}
.INDEX {yp-linux@\fIyp-linux\fR}
.INDEX {yps@\fIyps\fR}
Today, NIS is available for virtually all Un*ces, and there are even
free implementations of it\&. One is from the BSD Net-2 release, and has
been derived from a public domain reference implementation donated by
Sun\&.  The library client code from this release has been in the GNU
\fIlibc\fR for a long time, while the administrative programs have only
recently been ported to Linux by Swen Th\C':u'mmler\&.(\*F)
.FS
To be reached at \fBswen@uni-paderborn\&.de\fR\&. The NIS clients are
available as \fByp-linux\&.tar\&.gz\fR from \fBsunsite\&.unc\&.edu\fR in
\fIsystem/Network\fR\&.
.FE
An NIS server is missing from the reference implementation\&.  Tobias
Reber has written another NIS package including all tools and a server;
it is called \fIyps\fR\&.(\*F)
.FS
The current version (as of this writing) is \fByps-0\&.21\fR and can
be obtained from \fBftp\&.lysator\&.liu\&.se\fR in the \fI/pub/NYS\fR
directory\&.
.FE
.P 1
.INDEX {Eriksson, Peter}
.INDEX {NYS|(}
.INDEX {host\&.conf@\fIhost\&.conf\fR}
Currently, a complete rewrite of the NIS code called NYS is being done
by Peter Eriksson,(\*F)
.FS
To be reached at \fBpen@lysator\&.liu\&.se\fR\&.
.FE
which supports both plain NIS and Sun's much revised NIS+\&. NYS
not only provides a set of NIS tools and a server, but also adds a whole
new set of library functions which will most probably make it into the
standard \fIlibc\fR eventually\&. This includes a new configuration scheme
for hostname resolution that replaces the current scheme using
\fIhost\&.conf\fR\&. The features of these functions will be discussed
below\&.
.P 1
This chapter will focus on NYS rather than the other two packages, to which
I will refer as the ``traditional'' NIS code\&. If you do want to run any of
these packages, the instructions in this chapter may or may not be enough\&.
To obtain additional information, please get a standard book on NIS, such
as Hal Stern's \fINFS and NIS\fR (see [
GETST "stern-nfs"
])\&.
.P 1
For the time being, NYS is still under development, and therefore standard
Linux utilities such as the network programs or the \fIlogin\fR program
are not yet aware of the NYS configuration scheme\&.  Until NYS is merged
into the mainstream \fIlibc\fR you therefore have to recompile all these
binaries if you want to make them use NYS\&.  In any of these applications'
\fIMakefile\fRs, specify \fI-lnsl\fR as the last option before
\fIlibc\fR to the linker\&. This links in the relevant functions from
\fIlibnsl\fR, the NYS library, instead of the standard C library\&.
.P 1
.H 2 "Getting Acquainted with NIS"
.INDEX {NIS!databases}
.INDEX {NIS!map|(}
.P 1
NIS keeps database information is in so-called \fImaps\fR containing
key-value pairs\&. Maps are stored on a central host running the NIS
server, from which clients may retrieve the information through various
RPC calls\&. Quite frequently, maps are stored in DBM files\&.(\*F)
.FS
DBM is a simple database management library that uses hashing
techniques to speed up search operations\&. There's a free DBM
implementation from the GNU project called \fIgdbm\fR, which is
part of most Linux distributions\&.
.FE
.P 1
.INDEX {hosts@\fIhosts\fR}
.INDEX {passwd@\fIpasswd\fR}
.INDEX {hosts\&.byname@\fIhosts\&.byname\fR}
.INDEX {hosts\&.byaddr@\fIhosts\&.byaddr\fR}
The maps themselves are usually generated from master text files such as
\fI/etc/hosts\fR or \fI/etc/passwd\fR\&. For some files, several maps
are created, one for each search key type\&. For instance, you may search
the \fIhosts\fR file for a host name as well as for an IP address\&.
Accordingly, two NIS maps are derived from it, called \fIhosts\&.byname\fR
and \fIhosts\&.byaddr\fR, respectively\&.  Table 
.GETHN "nis.table.maps"
\& lists
common maps and the files they are generated form\&.
.P 1
\"
.DF CB F 5
.br
.ad c
.ti 0		
.TS
box tab(&);
| l | l l |.
_
Master File &Map(s) &
_
_
\fI/etc/hosts\fR &\fIhosts\h'0'.byname\fR &\fIhosts\h'0'.byaddr\fR
\fI/etc/networks\fR &\fInetworks\h'0'.byname\fR &\fInetworks\h'0'.byaddr\fR
\fI/etc/passwd\fR &\fIpasswd\h'0'.byname\fR &\fIpasswd\h'0'.byuid\fR
\fI/etc/group\fR &\fIgroup\h'0'.byname\fR &\fIgroup\h'0'.bygid\fR
\fI/etc/services\fR &\fIservices\h'0'.byname\fR &\fIservices\h'0'.bynumber\fR
\fI/etc/rpc\fR &\fIrpc\h'0'.byname\fR &\fIrpc\h'0'.bynumber\fR
\fI/etc/protocols\fR &\fIprotocols\h'0'.byname\fR&\fIprotocols\h'0'.bynumber\fR
\fI/usr/lib/aliases\fR&\fImail\h'0'.aliases\fR &
_
.TE
.P 1
.ad b
\"
\"
.br
.TB " Some standard NIS maps and the corresponding files\&\&. " "" 0 "nis.table.maps"
.DE
.P 1
There are other files and maps you may find support for in some NIS
package or other\&. These may contain information for applications not
discussed in this book, such as the \fIbootparams\fR map that may used
by some BOOTP servers, or which currently don't have any function in
Linux (like the \fIethers\&.byname\fR and \fIethers\&.byaddr\fR maps)\&.
.P 1
.INDEX {display!NIS map nicknames}
.INDEX {ypcat@\fIypcat\fR}
.INDEX {NIS!nickname}
.INDEX {NIS!map}
For some maps, people commonly use \fInicknames\fR, which are shorter
and therefore easier to type\&. To obtain a full list of nicknames
understood by your NIS tools, run the following command:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ ypcat -x
NIS map nickname translation table:
        "passwd" -> "passwd.byname"
        "group" -> "group.byname"
        "networks" -> "networks.byaddr"
        "hosts" -> "hosts.byname"
        "protocols" -> "protocols.bynumber"
        "services" -> "services.byname"
        "aliases" -> "mail.aliases"
        "ethers" -> "ethers.byname"
        "rpc" -> "rpc.bynumber"
        "netmasks" -> "netmasks.byaddr"
        "publickey" -> "publickey.byname"
        "netid" -> "netid.byname"
        "passwd.adjunct" -> "passwd.adjunct.byname"
        "group.adjunct" -> "group.adjunct.byname"
        "timezone" -> "timezone.byname"
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {NIS!map|)}
.INDEX {NIS!server|(}
.INDEX {ypserv@\fIypserv\fR}
.INDEX {server!ypserv@\fIypserv\fR}
.INDEX {server!NIS}
The NIS server is traditionally called \fIypserv\fR\&. For an average
network, a single server usually suffices; large networks may choose to
run several of these on different machines and different segments of the
network to relieve the load on the server machines and routers\&.  These
servers are synchronized by making one of them the \fImaster server\fR,
and the others \fIslave servers\fR\&. Maps will be created only on the
master server's host\&. From there, they are distributed to all slaves\&.
.P 1
.INDEX {NIS!domain|(}
.INDEX {choosing!a NIS domain}
You will have noticed that we have been talking about ``networks''
very vaguely all the time; of course there's a distinctive concept in
NIS that refers to such a network, that is the collection of all hosts
that share part of their system configuration data through NIS: the
\fINIS domain\fR\&.  Unfortunately, NIS domains have absolutely nothing in
common with the domains we encountered in DNS\&. To avoid any ambiguity
throughout this chapter, I will therefore always specify which type of
domain I mean\&.
.P 1
.INDEX {setting!NIS domain}
.INDEX {domain name!setting NIS}
.INDEX {domainname@\fIdomainname\fR}
NIS domains have a purely administrative function only\&. They are mostly
invisible to users, except for the sharing of passwords between all
machines in the domain\&. Therefore, the name given to a NIS domain is
relevant only to the administrators\&. Usually, any name will do, as long
as it is different from any other NIS domain name on your local network\&.
For instance, the administrator at the Virtual Brewery may choose to
create two NIS domains, one for the Brewery itself, and one for the
Winery, which she names \fBbrewery\fR and \fBwinery\fR, respectively\&.
Another quite common scheme is to simply use the DNS domain name for NIS
as well\&. To set and display the NIS domain name of your host, you can
use the \fIdomainname\fR command\&. When invoked without any argument, it
prints the current NIS domain name; to set the domain name, you must
become super user and type:
.P 1
.P 1
.DS I F 5
\fB# domainname brewery
\"
\fR
.DE
.P 1
NIS domains determine which NIS server an application will query\&. For
instance, the \fIlogin\fR program on a host at the Winery should, of
course, only query the Winery's NIS server (or one of them, if there
were several) for a user's password information; while an application on
a Brewery host should stick with the Brewery's server\&.
.P 1
.INDEX {NIS!locating server}
.INDEX {ypbind@\fIypbind\fR}
One mystery now remains to be solved, namely how a client finds out
which server to connect to\&. The simplest approach would be to have
a configuration file that names the host on which to find the server\&.
However, this approach is rather inflexible, because it doesn't allow
clients to use different servers (from the same domain, of course), 
depending on their availability\&. Therefore, traditional NIS
implementations rely on a special daemon called \fIypbind\fR to detect
a suitable NIS server in their NIS domain\&. Before being able to perform
any NIS queries, any application first finds out from \fIypbind\fR
which server to use\&.
.P 1
\fIypbind\fR probes for servers by broadcasting to the local IP network;
the first to respond is assumed to be the potentially fastest one and
will be used in all subsequent NIS queries\&. After a certain interval has
elapsed, or if the server becomes unavailable, \fIypbind\fR will
probe for active servers again\&.
.P 1
Now, the arguable point about dynamic binding is that you rarely need
it, and that it introduces a security problem: \fIypbind\fR
blindly believes whoever answers, which could be a humble NIS server
as well as a malicious intruder\&. Needless to say this becomes especially
troublesome if you manage your password databases over NIS\&.  To guard
against this, NYS does \fInot\fR use \fIypbind\fR by default, but
rather picks up the server host name from a configuration file\&.
.P 1
.INDEX {NIS!domain|)}
.INDEX {NIS!server|)}
.P 1
.H 2 "NIS versus NIS+"
.SETR "nis.nisplus"
.INDEX {NIS+@NIS+}
.P 1
NIS and NIS+ share little more than their name and a common goal\&.
NIS+ is structured in an entirely different way\&. Instead of a flat
name space with disjoint NIS domains, it uses a hierarchical name space
similar to that of DNS\&. Instead of maps, so called \fItables\fR are
used that are made up of rows and columns, where each row represents an
object in the NIS+ database, while the columns cover those properties
of the objects that NIS+ knows and cares about\&. Each table for a
given NIS+ domain comprises those of its parent domains\&. In addition,
an entry in a table may contain a link to another table\&. These features
make it possible to structure information in many ways\&.
.P 1
Traditional NIS has an RPC version number of 2, while NIS+ is
version 3\&.
.P 1
NIS+ does not seem to be very widely used yet, and I don't really
know that much about it\&. (Well, almost nothing)\&. For this reason, we
will not deal with it here\&. If you are interested in learning more about
it, please refer to Sun's NIS+ administration manual
([
GETST "nisplus"
])\&.
.P 1
.H 2 "The Client Side of NIS"
.SETR "nis.clients"
.INDEX {NIS!client|(}
.INDEX {NIS!map}
.P 1
If you are familiar with writing or porting network applications, you
will notice that most NIS maps listed above correspond to library
functions in the C library\&. For instance, to obtain \fIpasswd\fR
information, you generally use the \fIgetpwnam(3)\fR and
\fIgetpwuid(3)\fR functions which return the account information
associated with the given user name or numerical user id, repsectively\&.
Under normal circumstances, these functions will perform the requested
lookup on the standard file, such as \fI/etc/passwd\fR\&.
.P 1
A NIS-aware implementation of these functions, however, will modify this
behavior, and place an RPC call to have the NIS server look up the user
name or id\&. This happens completely transparent to the application\&.  The
function may either ``append'' the NIS map to or ``replace'' the
original file with it\&. Of course, this does not refer to a real
modification of the file, it only means that it \fIappears\fR to the
application as if the file had been replaced or appended to\&.
.P 1
For traditional NIS implementations, there used to be certain
conventions as to which maps replaced, and which were appended to the
original information\&.  Some, like the \fIpasswd\fR maps, required kludgy
modifications of the \fIpasswd\fR file which, when done wrong, would
open up security holes\&. To avoid these pitfalls, NYS uses a general
configuration scheme that determines whether a particular set of client
functions uses the original files, NIS, or NIS+, and in which
order\&. It will be described in a later section of this chapter\&.
.P 1
.INDEX {NIS!client|)}
.P 1
.H 2 "Running a NIS Server"
.SETR "nis.server"
.INDEX {configuring!NIS}
.INDEX {NIS!server|(}
.P 1
After so much theoretical techno-babble, it's time to get our hands
dirty with actual configuration work\&. In this section, we will cover the
configuration of a NIS server\&. If there's already a NIS server running
on your network, you won't have to set up your own server; in this case,
you may safely skip this section\&.
.P 1
.P 1
.DS I F 5
.MARGINPAR
<>
.ENDMARGINPAR
Note that if you are just going to experiment with the server, make
sure you don't set it up for a NIS domain name that is already in use
on your network\&. This may disrupt the entire network service and make a
lot of people very unhappy, and very angry\&.
\"
.DE
.P 1
There are currently two NIS servers freely available for Linux, one
contained in Tobias Reber's \fIyps\fR package, and the other in Peter
Eriksson's \fIypserv\fR package\&. It shouldn't matter which one you run,
regardless of whether you use NYS or the standard NIS client code that
is in \fIlibc\fR currently\&. At the time of this writing, the code for
the handling of NIS slave servers seems to be more complete in
\fIyps\fR\&. So if you have to deal with slave servers, \fIyps\fR might
be a better choice\&.
.P 1
After installing the server program (\fIypserv\fR) in \fI/usr/sbin\fR,
you should create the directory that is going to hold the map files your
server is to distribute\&. When setting up a NIS domain for the
\fBbrewery\fR domain, the maps would go to \fI/var/yp/brewery\fR\&.  The
server determines if it is serving a particular NIS domain by checking
if the map directory is present\&. If you are disabling service for some
NIS domain, make sure to remove the directory as well\&.
.P 1
.INDEX {NIS!creating maps}
.INDEX {creating!NIS maps}
Maps are usually stored in DBM files to speed up lookups\&. They are
created from the master files using a program called \fImakedbm\fR (for
Tobias' server) or \fIdbmload\fR (for Peter's server)\&. These may not be
interchangeable\&. Transforming a master file into a form parseable by
\fIdbmload\fR usually requires some \fIawk\fR or \fIsed\fR magic,
which tend to be a little tedious to type and hard to remember\&.
Therefore, Peter Eriksson's \fIypserv\fR package contains a Makefile
(called \fIypMakefile\fR) that does all these jobs for you\&. You should
install it as \fIMakefile\fR in your map directory, and edit it to
reflect the maps you want to distribute\&. Towards the top of the file,
you find the \fIall\fR target that lists the services \fIypserv\fR
is to offer\&.  By default, the line looks something like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
all: ethers hosts networks protocols rpc services passwd group netid
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {checking!NIS}
If you don't want to produce the \fIethers\&.byname\fR and
\fIethers\&.byaddr\fR maps, for example, simply remove the
\fIethers\fR prerequisite from this rule\&. To test your setup, it may
suffice to start with just one or two maps, like the \fIservices\&.*\fR
maps\&.
.P 1
After editing the \fIMakefile\fR, while in the map directory, type
``\fBmake\fR''\&. This will automatically generate and install the maps\&.
You have to make sure to update the maps whenever you change the master
files, otherwise the changes will remain invisible to the network\&.
.P 1
.INDEX {checking!NIS}
The next section explains how to configure the NIS client code\&.  If your
setup doesn't work, you should try to find out whether any requests
arrive at your server or not\&. If you specify the \fB-D\fR command
line flag to the NYS server, it prints debugging messages to the console
about all incoming NIS queries, and the results returned\&. These should
give you a hint as to where the problem lies\&. Tobias' server has no such
option\&.
.P 1
.INDEX {NIS!server|)}
.P 1
.H 2 "Setting up a NIS Client with NYS"
.SETR "nis.yp"
.INDEX {configuring!NIS}
.INDEX {NIS!client|(}
.P 1
Throughout the remainder of this chapter, we will cover the
configuration of a NIS client\&.
.P 1
.INDEX {yp\&.conf@\fIyp\&.conf\fR|(}
.INDEX {setting!NIS domain}
Your first step should be to tell NYS which server to use for NIS
service, setting it in the \fI/etc/yp\&.conf\fR configuration file\&.
A very simple sample file for a host on the Winery's network may look
like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# yp.conf - YP configuration for NYS library.
#
domainname winery
server vbardolino 
.ENDVERBATIM
\"
\fR
.DE
.P 1
The first statement tells all NIS clients that they belong to the
\fBwinery\fR NIS domain\&.  If you omit this line, NYS will use the
domain name you assigned your system through the \fIdomainname\fR
command\&.  The \fIserver\fR statement names the NIS server to use\&.
Of course, the IP address corresponding to \fBvbardolino\fR must be set
in the \fIhosts\fR file; alternatively, you may use the IP address
itself with the \fIserver\fR statement\&.
.P 1
In the form shown above, the \fIserver\fR command tells NYS to use the
named server whatever the current NIS domain may be\&. If, however, you are
moving your machine between different NIS domains frequently, you may want
to keep information for several domains in the \fIyp\&.conf\fR file\&. You can
have information on the servers for various NIS domains in \fIyp\&.conf\fR
by adding the NIS domain name to the \fIserver\fR statement\&.  For
instance, you might change the above sample file for a laptop to look like
this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# yp.conf - YP configuration for NYS library.
# 
server vbardolino winery
server vstout     brewery
.ENDVERBATIM
\"
\fR
.DE
.P 1
This allows you to bring up the laptop in any of the two domains by simply
setting the desired NIS domain at boot time through the \fIdomainname\fR
command\&.
.INDEX {yp\&.conf@\fIyp\&.conf\fR|)}
.P 1
.INDEX {ypcat@\fIypcat\fR}
.INDEX {checking!NIS}
After creating this basic configuration file and making sure it is
world-readable, you should run your first test to check if you can
connect to your server\&. Make sure to choose any map your server
distributes, like \fIhosts\&.byname\fR, and try to retrieve it by using
the \fIypcat\fR utility\&. \fIypcat\fR, like all other administrative
NIS tools, should live in \fI/usr/sbin\fR\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# ypcat hosts.byname
191.72.2.2      vbeaujolais  vbeaujolais.linus.lxnet.org
191.72.2.3      vbardolino   vbardolino.linus.lxnet.org
191.72.1.1      vlager       vlager.linus.lxnet.org
191.72.2.1      vlager       vlager.linus.lxnet.org
191.72.1.2      vstout       vstout.linus.lxnet.org
191.72.1.3      vale         vale.linus.lxnet.org
191.72.2.4      vchianti     vchianti.linus.lxnet.org
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {rpcinfo@\fIrpcinfo\fR}
The output you get should look somthing like that shown above\&. If you
get an error message instead that says ``\fBCan't bind to server
which serves domain\fR'' or something similar, then either the NIS domain
name you've set doesn't have a matching server defined in
\fIyp\&.conf\fR, or the server is unreachable for some reason\&. In the
latter case, make sure that a \fIping\fR to the host yields a positive
result, and that it is indeed running a NIS server\&. You can verify the
latter by using \fIrpcinfo\fR, which should produce the following
output:
.P 1
.P 1
.DS I F 5
\fB# rpcinfo -u \fIserverhost\fB ypserv
.br
program 100004 version 2 ready and waiting
\"
\fR
.DE
.P 1
.H 2 "Choosing the Right Maps"
.SETR "nis.nsswitch"
.INDEX {nsswitch\&.conf@\fInsswitch\&.conf\fR|(}
.INDEX {choosing!NIS maps}
.P 1
Having made sure you can reach the NIS server, you have to decide which
configuration files to replace or augment with NIS maps\&. Commonly, you
will want use NIS maps for the host and password lookup functions\&. The
former is especially useful if you do not run BIND\&. The latter permits
all users to log into their account from any system in the NIS domain;
this usually requires sharing a central \fI/home\fR directory between
all hosts via NFS\&. It is explained detail in section 
.GETHN "nis.passwd"
\&
below\&. Other maps, like \fIservices\&.byname\fR, aren't such
a dramatic gain, but save you some editing work if you install any
network applications that use a service name that's not in the
standard \fIservices\fR file\&.
.P 1
Generally, you want to have some freedom of choice when a lookup
function uses the local files, and when it queries the NIS server\&.
NYS allows you to configure the order in which a function accesses these
services\&. This is controlled through the \fI/etc/nsswitch\&.conf\fR file,
which stands for \fIName Service Switch\fR but of course isn't limited
to the name service\&.  For any of the data lookup functions supported by
NYS, it contains a line naming the services to use\&.
.P 1
.INDEX {services\&.byname@\fIservices\&.byname\fR}
.INDEX {hosts\&.byname@\fIhosts\&.byname\fR}
The right order of services depends on the type of data\&. It is unlikely
that the \fIservices\&.byname\fR map will contain entries differing from those
in the local \fIservices\fR file; it may only contain more\&. So a good
choice may be to query the local files first, and check NIS only if
the service name wasn't found\&. Hostname information, on the other hand,
may change very frequently, so that DNS or the NIS server should always
have the most accurate account, while the local \fIhosts\fR file
is only kept as a backup if DNS and NIS should fail\&. In this case,
you would want to check the local file last\&.
.P 1
The example below shows how to configure \fIgethostbyname(2)\fR,
\fIgethostbyaddr(2)\fR, and \fIgetservbyname(2)\fR functions as
described above\&. They will try the listed services in turn; if a lookup
succeeds, the result is returned, otherwise the next service is tried\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# small sample /etc/nsswitch.conf
#
hosts:     nis dns files 
services:  files nis
.ENDVERBATIM
\"
\fR
.DE
.P 1
The complete list of services that may be used with an entry in the
\fInsswitch\&.conf\fR file is shown below\&. The actual maps, files,
servers and objects being queried depend on the entry name\&. 
.P 1
\"
.BL 10
.LI "\fInisplus\fR or \fInis+\fR"
Use the NIS+ server for this domain\&. The location of the
server is obtained from the \fI/etc/nis\&.conf\fR file\&.
.P 1
.LI "\fInis\fR"
Use the current NIS server of this domain\&. The location of the
server queried is configured in the \fIyp\&.conf\fR file as shown
in the previous section\&.  For the \fIhosts\fR entry, the
maps \fIhosts\&.byname\fR and \fIhosts\&.byaddr\fR are queried\&.
.P 1
.LI "\fIdns\fR"
Use the DNS name server\&. This service type is only useful with
the \fIhosts\fR entry\&. The name servers queried are still
determined by the standard \fIresolv\&.conf\fR file\&.
.P 1
.LI "\fIfiles\fR"
Use the local file, such as the \fI/etc/hosts\fR file for the
\fIhosts\fR entry\&.
.P 1
.LI "\fIdbm\fR"
Look up the information from DBM files located in
\fI/var/dbm\fR\&.  The name used for the file is that of the
corresponding NIS map\&.
.P 1
\"
.LE
.P 1
Currently, NYS supports the following \fInsswitch\&.conf\fR entries:
\fIhosts\fR, \fInetworks\fR, \fIpasswd\fR, \fIgroup\fR,
\fIshadow\fR, \fIgshadow\fR, \fIservices\fR,
\fIprotocols\fR, \fIrpc\fR, and \fIethers\fR\&. More entries
are likely to be added\&.
.P 1
Figure 
.GETHN "nis.fig.switch"
\& shows a more complete example which
introduces another feature of \fInsswitch\&.conf\fR: the
\fI[NOTFOUND=return]\fR keyword in the \fIhosts\fR entry tells
NYS to return if the desired item couldn't be found in the NIS or DNS
database\&.  That is, NYS will continue and search the local files 
\fIonly\fR if calls to the NIS and DNS servers failed for some other
reason\&. The local files will then only be used at boot time and as a
backup when the NIS server is down\&.
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /etc/nsswitch.conf
#
hosts:      nis dns [NOTFOUND=return] files
networks:   nis [NOTFOUND=return] files

services:   files nis
protocols:  files nis
rpc:        files nis
.ENDVERBATIM
\"
\fR
.DE
\"
\"
.br
.FG " Sample \fInsswitch\&\&.conf\fR file\&\&. " "" 0 "nis.fig.switch"
.DE
.P 1
.INDEX {nsswitch\&.conf@\fInsswitch\&.conf\fR|)}
.P 1
.H 2 "Using the passwd and group Maps"
.SETR "nis.passwd"
.INDEX {NIS!passwd maps@\fIpasswd\fR maps|(}
.INDEX {passwd\&.byname@\fIpasswd\&.byname\fR}
.INDEX {passwd\&.byuid@\fIpasswd\&.byuid\fR}
.INDEX {group\&.byname@\fIgroup\&.byname\fR}
.INDEX {group\&.bygid@\fIgroup\&.bygid\fR}
.INDEX {passwords!network-wide|(}
.INDEX {network!passwords}
.INDEX {LAN!passwords}
.P 1
One of the major applications of NIS is in synchronizing user and
account information on all hosts in a NIS domain\&. To this end, you
usually keep only a small local \fI/etc/passwd\fR file, to which
the site-wide information from the NIS maps is appended\&. However,
simply enabling NIS lookups for this service in \fInsswitch\&.conf\fR
is not nearly enough\&.
.P 1
When relying on the password information distributed by NIS, you first
have to make sure that the numeric user id's of any users you have in
your local \fIpasswd\fR file match the NIS server's idea of user id's\&.
You will want this for other purposes as well, like mounting NFS volumes
from other hosts in your network\&.
.P 1
If any of the numeric ids in \fI/etc/passwd\fR or \fI/etc/group\fR
deviate from those in the maps, you have to adjust file ownerships for
all files that belong to that user\&. First you should change all uids and gids
in \fIpasswd\fR and \fIgroup\fR to the new values; then find all files
that belong to the users just changed, and finally change their
ownership\&.  Assume \fBnews\fR used to have a user id of 9, and
\fBokir\fR had a user id of 103, which were changed to some other
value; you could then issue the following commands:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 # find / -uid   9 -print >/tmp/uid.9
 # find / -uid 103 -print >/tmp/uid.103
 # cat /tmp/uid.9   | xargs chown news
 # cat /tmp/uid.103 | xargs chown okir
.ENDVERBATIM
\"
\fR
.DE
.P 1
It is important that you execute these commands with the \fInew\fR
\fIpasswd\fR file installed, and that you collect all file names before
you change the ownership of any of them\&. To update the group ownerships
of files, you will use a similar command\&.
.P 1
Having done this, the numerical uid's and gid's on your system will
agree with those on all other hosts in your NIS domain\&.  The next step
will be to add configuration lines to \fInsswitch\&.conf\fR that enables
NIS lookups for user and group information:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /etc/nsswitch.conf - passwd and group treatment
passwd: nis files
group:  nis files
.ENDVERBATIM
\"
\fR
.DE
.P 1
This makes the \fIlogin\fR command and all its friends first query
the NIS maps when a user tries to log in, and if this lookup fails,
fall back to the local files\&. Usually, you will remove almost all
users from your local files, and only leave entries for \fBroot\fR
and generic accounts like \fBmail\fR in it\&.  This is because some
vital system tasks may require to map uids to user names or vice
versa\&.  For example, administrative \fIcron\fR jobs may execute the
\fIsu\fR command to temporarily become \fBnews\fR, or the UUCP
subsystem may mail a status report\&.  If \fBnews\fR and \fBuucp\fR
don't have entries in the local \fIpasswd\fR file, these jobs will
fail miserably during a NIS brownout\&.
.P 1
There are two big caveats in order here: on one hand, the setup as
described up to here only works for login suites that don't use shadow
password, like those included in the \fIutil-linux\fR package\&. The
intricacies of using shadow passwords with NIS will be covered below\&.
On the other hand, the login commands are not the only ones that
access the \fIpasswd\fR file -- look at the \fIls\fR command which
most people use almost constantly\&. Whenever doing a long listing,
\fIls\fR will display the symbolic names for user and group owners of
a file; that is, for each uid and gid it encounters, it will have to
query the NIS server once\&. This will slow things down rather badly if
your local network is clogged, or, even worse, when the NIS server is
not on the same physical network, so that datagrams have to pass
through a router\&.
.P 1
Still, this is not the whole story yet\&. Imagine what happens if a user
wants to change her password\&. Usually, she will invoke \fIpasswd\fR,
which reads the new password and updates the local \fIpasswd\fR
file\&. This is impossible with NIS, since that file isn't available
locally anymore, but having users log into the NIS server whenever they
want to change their password is not an option either\&. Therefore, NIS
provides a drop-in replacement for \fIpasswd\fR called \fIyppasswd\fR,
which does the analoguous thing in the presence of NIS\&. To change the
password on the server host, it contacts the \fIyppasswdd\fR daemon on
that host via RPC, and provides it with the updated password
information\&. Usually, you install \fIyppasswd\fR over the normal
program by doing something like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# cd /bin
# mv passwd passwd.old
# ln yppasswd passwd
.ENDVERBATIM
\"
\fR
.DE
.P 1
At the same time you have to install \fIrpc\&.yppasswdd\fR on the server
and start it from \fIrc\&.inet2\fR\&.  This will effectively hide any of
the contortions of NIS from your users\&.
.P 1
.INDEX {passwords!network-wide|)}
.INDEX {NIS!passwd maps@\fIpasswd\fR maps|)}
.P 1
.H 2 "Using NIS with Shadow Support"
.SETR "nis.shadow"
.INDEX {NIS!and shadow passwords}
.P 1
There is no NIS support yet for sites that use the shadow login suite\&.
John F\&. Haugh, the author of the shadow suite, recently released a
version of the shadow library functions covered by the GNU Library GPL
to \fBcomp\&.sources\&.misc\fR\&. It already has some support for NIS, but
it isn't complete, and the files haven't been added to the standard C
library yet\&. On the other hand, publishing the information from
\fI/etc/shadow\fR via NIS kind of defeats the purpose of the shadow
suite\&.
.P 1
Although the NYS password lookup functions don't use a \fIshadow\&.byname\fR
map or anything likewise, NYS supports using a local \fI/etc/shadow\fR
file transparently\&. When the NYS implementation of \fIgetpwnam\fR is
called to look up information related to a given login name, the facilities
specified by the \fIpasswd\fR entry in \fInsswitch\&.conf\fR are
queried\&. The \fInis\fR service will simply look up the name in the
\fIpasswd\&.byname\fR map on the NIS server\&. The \fIfiles\fR service,
however, will check if \fI/etc/shadow\fR is present, and if so, try to
open it\&. If none is present, or if the user doesn't have \fBroot\fR
privilege, if reverts to the traditional behavior of looking up the user
information in \fI/etc/passwd\fR only\&. However, if the \fIshadow\fR file
exists and can be opened, NYS will extract the user password from
\fIshadow\fR\&. The \fIgetpwuid\fR function is implemented accordingly\&.  In
this fashion, binaries compiled with NYS will deal with a local
the shadow suite installation transparently\&.
.P 1
.H 2 "Using the Traditional NIS Code"
.SETR "nis.old-code"
.INDEX {NIS!traditional code}
.P 1
If you are using the client code that is in the standard \fIlibc\fR
currently, configuring a NIS client is a little different\&. On one
hand, it uses a \fIypbind\fR daemon to broadcast for active servers
rather than gathering this information from a configuration file\&.
You therefore have to make sure to start \fIypbind\fR at boot
time\&. It must be invoked after the NIS domain has been set and the
RPC portmapper has been started\&. Invoking \fIypcat\fR to test the
server should then work as shown above\&.
.P 1
.INDEX {portmapper failure (error message)}
Recently, there have been numerous bug reports that NIS fails with
an error message saying ``\fBclntudp_create: RPC: portmapper
failure - RPC: unable to receive\fR''\&. These are due to an incompatible
change in the way \fIypbind\fR communicates the binding information
to the library functions\&. Obtaining the latest sources for the NIS
utilities and recompiling them should cure this problem\&.(\*F)
.FS
The source for \fIyp-linux\fR can be gotten from
\fBftp\&.uni-paderborn\&.de\fR in directory \fI/pub/Linux/LOCAL\fR\&.
.FE
.P 1
.INDEX {NIS!passwd maps@\fIpasswd\fR maps}
.INDEX {network!passwords}
.INDEX {LAN!passwords}
Also, the way traditional NIS decides if and how to merge NIS
information with that from the local files deviates from that used by
NYS\&. For instance, to use the NIS password maps, you have to include
the following line somewhere in your \fI/etc/passwd\fR map:
.P 1
.P 1
.DS I F 5
\fB+:*:0:0:::
\"
\fR
.DE
.P 1
.INDEX {host\&.conf@\fIhost\&.conf\fR}
.INDEX {network!hostname resolution}
.INDEX {LAN!hostname resolution}
.INDEX {hostname!resolution}
This marks the place where the password lookup functions ``insert'' the
NIS maps\&.  Inserting a similar line (minus the last two colons) into
\fI/etc/group\fR does the same for the \fIgroup\&.*\fR maps\&.  To use the
\fIhosts\&.*\fR maps distributed by NIS, change the \fIorder\fR line
in the \fIhost\&.conf\fR file\&. For instance, if you want to use NIS, DNS,
and the \fI/etc/hosts\fR file (in that order), you need to change the
line to
.P 1
.P 1
.DS I F 5
\fBorder yp bind hosts
\"
\fR
.DE
.P 1
The traditional NIS implementation does not support any other maps
at the moment\&.
.P 1
.INDEX {NIS!client|)}
.P 1
.INDEX {configuring!NIS|)}
.INDEX {NYS|)}
.INDEX {NIS|)}
.P 1
.H 1 "The Network File System"
.SETR "nfs"
.INDEX {file sharing}
.INDEX {remote!file access}
.INDEX {Network File System|see NFS}
.INDEX {NFS|(}
.P 1
NFS, the network filesystem, is probably the most prominent network
services using RPC\&. It allows to access files on remote hosts in exactly
the same way as a user would access any local files\&. This is made
possible by a mixture of kernel functionality on the client side (that
uses the remote file system) and an NFS server on the server side (that
provides the file data)\&.  This file access is completely transparent to
the client, and works across a variety of server and host architectures\&.
.P 1
NFS offers a number of advantages:
.P 1
\"
.BL 10
.LI
Data accessed by all users can be kept on a central
host, with clients mounting this directory at boot time\&. For
example, you can keep all user accounts on one host, and have
all hosts on your network mount \fI/home\fR from that host\&. If
installed alongside with NIS, users can then log into any
system, and still work on one set of files\&.
.P 1
.LI
Data consuming large amounts of disk space may be kept
on a single host\&.  For example, all files and programs relating
to LaTeX and METAFONT could be kept and maintained in one
place\&.
.P 1
.LI
Administrative data may be kept on a single host\&.
No need to use \fIrcp\fR anymore to install the same
stupid file on 20 different machines\&.
.P 1
\"
.LE
.P 1
Linux NFS is largely the work of Rick Sladkey,(\*F)
.FS
Rick can be reached at \fBjrs@world\&.std\&.com\fR\&.
.FE
who wrote the NFS kernel code and large parts of the NFS server\&. The
latter is derived from the \fIunfsd\fR user-space NFS server originally
written by Mark Shand, and the \fIhnfs\fR Harris NFS server written by
Donald Becker\&.
.P 1
.INDEX {NFS!mounting a volume}
Let's have a look now at how NFS works: A client may request to mount a
directory from a remote host on a local directory just the same way it
can mount a physical device\&.  However, the syntax used to specify the
remote directory is different\&. For example, to mount \fI/home\fR from
host \fBvlager\fR to \fI/users\fR on \fBvale\fR, the administrator
would issue the following command on \fBvale\fR:(\*F)
.FS
Note that you can omit the \fB-t nfs\fR argument, because
\fImount\fR sees from the colon that this specifies an NFS
volume\&.
.FE
.P 1
.P 1
.DS I F 5
\fB# mount -t nfs vlager:/home /users
\"
\fR
.DE
.P 1
\fImount\fR will then try to connect to the \fImountd\fR mount daemon
on \fBvlager\fR via RPC\&. The server will check if \fBvale\fR is
permitted to mount the directory in question, and if so, return it a
file handle\&. This file handle will be used in all subsequent requests to
files below \fI/users\fR\&.
.P 1
.INDEX {server!nfsd@\fInfsd\fR}
.INDEX {nfsd@\fInfsd\fR}
When someone accesses a file over NFS, the kernel places an RPC call to
\fInfsd\fR (the NFS daemon) on the server machine\&. This call takes the
file handle, the name of the file to be accessed, and the user's user
and group id as parameters\&. These are used in determining access rights
to the specified file\&. In order to prevent unauthorized users from
reading or modifying files, user and group ids must be the same on both
hosts\&.
.P 1
On most Un*x implementations, the NFS functionality of both client
and server are implemented as kernel-level daemons that are started from
user space at system boot\&.  These are the NFS daemon (\fInfsd\fR) on
the server host, and the \fIBlock I/O Daemon\fR (\fIbiod\fR) running
on the client host\&. To improve throughput, \fIbiod\fR performs
asynchronous I/O using read-ahead and write-behind; also, several
\fInfsd\fR daemons are usually run concurrently\&.
.P 1
The NFS implementation of Linux is a little different in that the
client code is tightly integrated in the virtual file system (VFS) layer
of the kernel and doesn't require additional control through
\fIbiod\fR\&. On the other hand, the server code runs entirely in user
space, so that running several copies of the server at the same time is
almost impossible because of the synchronization issues this would
involve\&. Linux NFS currently also lacks read-ahead and write-behind,
but Rick Sladkey plans to add this someday\&.(\*F)
.FS
The problem with write-behind is that the kernel buffer cache is indexed
by device/inode pairs, and therefore can't be used for NFS-mounted
file systems\&.
.FE
.P 1
.INDEX {NFS!limitations}
.INDEX {NFS!server}
The biggest problem with the Linux NFS code is that the Linux
kernel as of version 1\&.0 is not able to allocate memory in chunks bigger
than 4K; as a consequence, the networking code cannot handle datagrams
bigger than roughly 3500 bytes after subtracting header sizes etc\&. This
means that transfers to and from NFS daemons running on systems that use
large UDP datagrams by default (e\&.g\&. 8K on SunOS) need to be downsized
artificially\&. This hurts performance badly under some
circumstances\&.(\*F)
.FS
As explained to me by Alan Cox:
The NFS specification requires the server to flush each write to disk
before it returns an acknowledgement\&. As BSD kernels are only capable
of page-sized writes (4K), writing a 4 chunks of 1K each to a BSD-based
NFS server results in 4 write operations of 4K each\&.
.FE
This limit is gone in late Linux-1\&.1 kernels, and the client code
has been modified to take advantage of this\&.
.P 1
.H 2 "Preparing NFS"
.SETR "nfs.nfsd"
.P 1
Before you can use NFS, be it as server or client, you must make sure
your kernel has NFS support compiled in\&.  Newer kernels have a simple
interface on the proc filesystem for this, the \fI/proc/filesystems\fR
file,  which you can display using \fIcat\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ cat /proc/filesystems
	minix
	ext2
	msdos
nodev	proc
nodev	nfs
.ENDVERBATIM
\"
\fR
.DE
.P 1
If \fInfs\fR is missing from this list, then you have to compile
your own kernel with NFS enabled\&.  Configuring the kernel network
options is explained in section ``Kernel Configuration'' in
chapter 
.GETHN "hardware"
\&\&.
.P 1
For older kernels prior to Linux 1\&.1, the easiest way to find out
whether your kernel has NFS support enabled is to actually try to
mount an NFS file system\&. For this, you could create a directory below
\fI/tmp\fR, and try to mount a local directory on it:
.P 1
.P 1
.DS I F 5
\fB# mkdir /tmp/test 
.br
# mount localhost:/etc /tmp/test
\"
\fR
.DE
.P 1
If this mount attempt fails with an error message saying ``\fBfs
type nfs no supported by kernel\fR'', you must make a new kernel with
NFS enabled\&.  Any other error messages are completely harmless, as
you haven't configured the NFS daemons on your host yet\&.
.P 1
.H 2 "Mounting an NFS Volume"
.SETR "nfs.mountd"
.INDEX {remote!file system}
.INDEX {mounting!an NFS volume}
.INDEX {acessing!remote files}
.INDEX {NFS!mounting a volume}
.P 1
NFS volumes(\*F)
.FS
One doesn't say file system, because these are not proper file systems\&.
.FE
are mounted very much the way usual file systems are mounted\&. You invoke
\fImount\fR using the following syntax:
.P 1
.P 1
.DS I F 5
\fB# mount -t nfs \fB\fInfs_volume local_dir options\fB\fB 
\"
\fR
.DE
.P 1
\fB\fInfs_volume\fB\fR is given as \fB\fIremote_host\fB\fR\fI:\fR\fB\fIremote_dir\fB\fR\&.
Since this notation is unique to NFS file systems, you can leave out
the \fB-t nfs\fR option\&.
.P 1
.INDEX {fstab@\fIfstab\fR}
.INDEX {fstab@\fIfstab\fR}
There are a number of additional options that you may specify to
\fImount\fR upon mounting an NFS volume\&. These may either be given
following the \fB-o\fR switch on the command line, or in the options
field of the \fI/etc/fstab\fR entry for the volume\&. In both cases,
multiple options are separated from each other by commas\&. Options
specified on the command line always override those given in the
\fIfstab\fR file\&.
.P 1
A sample entry in \fI/etc/fstab\fR might be
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# volume              mount point       type  options
news:/usr/spool/news  /usr/spool/news   nfs   timeo=14,intr
.ENDVERBATIM
\"
\fR
.DE
.P 1
This volume may then be mounted using
.P 1
.P 1
.DS I F 5
\fB# mount news:/usr/spool/news
\"
\fR
.DE
.P 1
In the absence of a \fIfstab\fR entry, NFS \fImount\fR invocations
look a lot uglier\&. For instance, suppose you mount your users' home
directories from a machine named \fBmoonshot\fR, which uses a default
block size of 4K for read/write operations\&. You might decrease
block size to 2K to suit Linux' datagram size limit by issuing
.P 1
.P 1
.DS I F 5
\fB# mount moonshot:/home /home -o rsize=2048,wsize=2048
\"
\fR
.DE
.P 1
.INDEX {NFS!restricting block size}
The list of all valid options is described in its entirety in the
\fInfs(5)\fR manual page that comes with Rick Sladkey's NFS-aware
\fImount\fR tool which can be found in Rik Faith's \fIutil-linux\fR
package)\&.  The following is an incomplete list of those you would
probably want to use:
.P 1
\"
.BL 10
.LI "\fIrsize=\fR\fB\fIn\fB\fR and \fIwsize=\fR\fB\fIn\fB\fR"
These specify the datagram size used by the NFS clients on
read and write requests, respectively\&. They currently default
to 1024 bytes, due to the limit on UDP datagram size described
above\&.
.P 1
.LI "\fItimeo=\fR\fB\fIn\fB\fR"
This sets the time (in tenths of a second) the NFS client will
wait for a request to complete\&. The default values is 0\&.7 seconds\&.
.P 1
.LI "\fIhard\fR"
Explicitly mark this volume as hard-mounted\&. This is on
by default\&.
.P 1
.LI "\fIsoft\fR"
Soft-mount the driver (as opposed to hard-mount)\&.
.P 1
.LI "\fIintr\fR"
Allow signals to interrupt an NFS call\&. Useful for aborting
when the server doesn't respond\&.
.P 1
\"
.LE
.P 1
Except for \fIrsize\fR and \fIwsize\fR, all of these options
apply to the client's behavior if the server should become inaccessible
temporarily\&. They play together in the following way: whenever the
client sends a request to the NFS server, it expects the operation to
have finished after a given interval (specified in the \fItimeout\fR
option)\&. If no confirmation is received within this time, a so-called
\fIminor timeout\fR occurs, and the operation is retried with the
timeout interval doubled\&. After reaching a maximum timeout of 60
seconds, a \fImajor timeout\fR occurs\&.
.P 1
.INDEX {NFS!hard-mounting vs\&. soft-mounting}
.INDEX {NFS!timeout}
By default, a major timeout will cause the client to print a message to
the console and start all over again, this time with an initial timeout
interval twice that of the previous cascade\&. Potentially, this may go on
forever\&. Volumes that stubbornly retry an operation until the server
becomes available again are called \fIhard-mounted\fR\&. The opposite
variety, \fIsoft-mounted\fR volumes gerenates an I/O error for the
calling process whenever a major timeout occurs\&. Because of the
write-behind introduced by the buffer cache, this error condition is not
propagated to the process itself before it calls the \fIwrite(2)\fR
function the next time, so a program can never be sure that a write
operation to a soft-mounted volume has succeded at all\&.
.P 1
Whether you hard- or soft-mount a volume is not simply a question of
taste, but also has to do with what sort of information you want to
access from this volume\&. For example, if you mount your X programs by
NFS, you certainly would not want your X session to go berserk just
because someone brought the network to a grinding halt by firing up
seven copies of \fIxv\fR at the same time, or by pulling the Ethernet
plug for a moment\&.  By hard-mounting these, you make sure that your
computer will wait until it is able to re-establish contact with your
NFS-server\&.  On the other hand, non-critical data such as NFS-mounted
news partititons or FTP archives may as well be soft-mounted, so it
doesn't hang your session in case the remote machine should be
temporarily unreachable, or down\&. If your network connection to the
server is flakey or goes through a loaded router, you may either
increase the initial timeout using the \fItimeo\fR option, or
hard-mount the volumes, but allow for signals interrupting the NFS call
so that you may still abort any hanging file access\&.
.P 1
Usually, the \fImountd\fR daemon will in some way or other keep track
of which directories have been mounted by what hosts\&. This information
can be displayed using the \fIshowmount\fR program, which is also
included in the NFS server package\&. The Linux \fImountd\fR, however,
does not do this yet\&.
.P 1
.H 2 "The NFS Daemons"
.SETR "nfs.daemons"
.INDEX {NFS!server}
.INDEX {rc\&.inet@\fIrc\&.inet\fR}
.INDEX {mountd@\fImountd\fR}
.INDEX {nfsd@\fInfsd\fR}
.P 1
If you want to provide NFS service to other hosts, you have to run the
\fInfsd\fR and \fImountd\fR daemons on your machine\&.  As RPC-based
programs, they are not managed by \fIinetd\fR, but are started up at
boot time, and register themselves with the portmapper\&. Therefore, you
have to make sure to start them only after \fIrpc\&.portmap\fR is
running\&.  Usually, you include the following two lines in your
\fIrc\&.inet2\fR script:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
if [ -x /usr/sbin/rpc.mountd ]; then
        /usr/sbin/rpc.mountd; echo -n " mountd"
fi
if [ -x /usr/sbin/rpc.nfsd ]; then
        /usr/sbin/rpc.nfsd; echo -n " nfsd"
fi
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {NFS!matching uids and gids}
The ownership information of files a NFS daemon provides to its
clients usually contains only numerical user and group id's\&.  If both
client and server associate the same user and group names with these
numerical id's, they are said to share the same uid/gid space\&. For
example, this is the case when you use NIS to distribute the
\fIpasswd\fR information to all hosts on your LAN\&.
.P 1
On some occasions, however, they do not match\&. Rather updating the
uid's and gid's of the client to match those of the server, you can
use the \fIugidd\fR mapping daemon to work around this\&. Using the
\fImap_daemon\fR option explained below, you can tell \fInfsd\fR
to map the server's uid/gid space to the client's uid/gid space with
the aid of the \fIugidd\fR on the client\&.
.P 1
\fIugidd\fR is an RPC-based server, and is started from
\fIrc\&.inet2\fR just like \fInfsd\fR and \fImountd\fR\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
if [ -x /usr/sbin/rpc.ugidd ]; then
        /usr/sbin/rpc.ugidd; echo -n " ugidd"
fi
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 2 "The exports File"
.SETR "nfs.exports"
.INDEX {NFS!exporting a volume}
.INDEX {NFS!exports@\fIexports\fR}
.INDEX {exporting an NFS volume}
.INDEX {access!granting}
.INDEX {mountd@\fImountd\fR}
.INDEX {exports@\fIexports\fR}
.P 1
While the above options applied to the client's NFS configuration,
there is a different set of options on the server side that configure
its per-client behavior\&. These options must be set in the
\fI/etc/exports\fR file\&.
.P 1
By default, \fImountd\fR will not allow anyone to mount directories
from the local host, which is a rather sensible attitude\&. To permit
one or more hosts to NFS-mount a directory, it must \fIexported\fR, that
is, must be specified in the \fIexports\fR file\&. A sample file may
look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# exports file for vlager
/home             vale(rw) vstout(rw) vlight(rw)
/usr/X386         vale(ro) vstout(ro) vlight(ro)
/usr/TeX          vale(ro) vstout(ro) vlight(ro)
/                 vale(rw,no_root_squash)
/home/ftp         (ro)
.ENDVERBATIM
\"
\fR
.DE
.P 1
Each line defines a directory, and the hosts allowed to mount it\&.  A
host name is usually a fully qualified domain name, but may additionally
contain the \fI*\fR and \fI?\fR wildcard, which act the way they
do with the Bourne shell\&. For instance, \fBlab*\&.foo\&.com\fR matches
\fBlab01\&.foo\&.com\fR as well as \fBlaber\&.foo\&.com\fR\&.  If no host name
is given, as with the \fI/home/ftp\fR directory in the example above,
any host is allowed to mount this directory\&.
.P 1
When checking a client host against the \fIexports\fR file,
\fImountd\fR will look up the client's hostname using the
\fIgethostbyaddr(2)\fR call\&. With DNS, this call returns the client's
canonical hostname, so you must make sure not to use aliases in
\fIexports\fR\&.  Without using DNS, the returned name is the first
hostname found in the \fIhosts\fR file that matches the client's
address\&.
.P 1
The host name is followed by an optional, comma-separated list of flags,
enclosed in brackets\&. These flags may take the following values:
.P 1
\"
.BL 10
.LI "\fIinsecure\fR"
Permit non-authenticated access from this machine\&.
.P 1
.LI "\fIunix-rpc\fR"
Require UNIX-domain RPC authentication from this machine\&.  This
simply requires that requests originate from a reserved internet
port (i\&.e\&. the port number has to be less than 1024)\&.  This
option is on by default\&.
.P 1
.LI "\fIsecure-rpc\fR"
Require secure RPC authentication from this machine\&. This has
not been implemented yet\&. See Sun's documentation on Secure RPC\&.
.P 1
.LI "\fIkerberos\fR"
Require Kerberos authentication on accesses from this machine\&.
This has not been implemented yet\&.  See the MIT documentation on
the Kerberos authentication system\&.
.P 1
.LI "\fIroot_squash\fR"
.INDEX {restrict root access@restrict \fBroot\fR access}
.INDEX {access!restrict}
This is a security feature that denies the super user on the
specified hosts any special access rights by mapping requests
from uid 0 on the client to uid 65534 (-2) on the server\&.  This
uid should be associated with the user \fBnobody\fR\&.
.P 1
.LI "\fIno_root_squash\fR"
Don't map requests from uid 0\&.  This option is on by default\&.
.P 1
.LI "\fIro\fR"
.INDEX {mounting!readonly}
.INDEX {readonly NFS volume}
.INDEX {NFS!readonly volume}
Mount file hierarchy read-only\&.  This option is on by default\&.
.P 1
.LI "\fIrw\fR"
Mount file hierarchy read-write\&.
.P 1
.LI "\fIlink_relative\fR"
Convert absolute symbolic links (where the link contents start
with a slash) into relative links by prepending the necessary
number of \fI\&.\&./\fR's to get from the directory containing the
link to the root on the server\&. This option only makes sense
when a host's entire file system is mounted, else some of the
links might point to nowhere, or even worse, files they were
never meant to point to\&.
.P 1
This option is on by default\&.
.P 1
.LI "\fIlink_absolute\fR"
Leave all symbolic link as they are (the normal behavior for
Sun-supplied NFS servers)\&.
.P 1
.LI "\fImap_identity\fR"
.INDEX {NFS!matching uids and gids}
The \fImap_identity\fR option tells the server to assume
that the client uses the same uid's and gid's as the server\&.
This option is on by default\&.
.P 1
.LI "\fImap_daemon\fR"
This option tells the NFS server to assume that client and
server do not share the same uid/gid space\&.  \fInfsd\fR will
then build a list mapping id's between client and server by
querying the client's \fIugidd\fR daemon\&.
.P 1
\"
.LE
.P 1
.INDEX {syslog@\fIsyslog\fR}
An error parsing the \fIexports\fR file is reported to \fIsyslogd\fR's
\fIdaemon\fR facility at level \fInotice\fR whenever \fInfsd\fR or
\fImountd\fR is started up\&.
.P 1
Note that host names are obtained from the client's IP address by
reverse mapping, so you have to have the resolver configured properly\&.
If you use BIND and are very security-conscious, you should enable spoof
checking in your \fIhost\&.conf\fR file\&.
.P 1
.H 2 "The Linux Automounter"
.SETR "nfs.automounter"
.INDEX {NFS!automounter}
.INDEX {mounting!automatically}
.INDEX {automounter}
.INDEX {amd@\fIamd\fR}
.P 1
Sometimes, it is wasteful to mount all NFS volumes users might possibly
want to access; either because of the sheer number of volumes to be
mounted, or because of the time this would take at startup\&. A viable
alternative to this is a so-called \fIautomounter\fR\&. This is a daemon
that automatically and transparently mounts any NFS volume as needed,
and unmounts them after they have not been used for some time\&. One of
the clever things about an automounter is that it is able to mount a
certain volume from alternative places\&.  For instance, you may keep
copies of your X programs and support files on two or three hosts, and
have all other hosts mount them via NFS\&.  Using an automounter, you may
specify all three of them to be mounted on \fI/usr/X386\fR; the
automounter will then try to mount any of these until one of the mount
attempts succeeds\&.
.P 1
The automounter commonly used with Linux is called \fIamd\fR\&. It
was originally written by Jan-Simon Pendry and has been ported to
Linux by Rick Sladkey\&. The current version is \fIamd-5\&.3\fR\&.
.P 1
Explaining \fIamd\fR is beyond the scope of this chapter; for
a good manual please refer to the sources; they contain a texinfo
file with very detailed information\&.
.P 1
.INDEX {NFS|)}
.P 1
.H 1 "Managing Taylor UUCP"
.SETR "uucp"
.INDEX {configuring!UUCP|(}
.INDEX {UUCP|(}
.P 1
.H 2 "History"
.P 1
UUCP was designed in the late seventies by Mike Lesk at AT&T Bell
Laboratories to provide a simple dial-up network over public telephone
lines\&. Since most people that want to have email and Usenet News on
their home machine still communicate through modems, UUCP has remained
very popular\&.  Although there are many implementations running on a
wide variety of hardware platforms and operating systems, they are
compatible to a high degree\&.
.P 1
However, as with most software that has somehow become ``standard'' over
the years, there is no UUCP which one would call \fIthe\fR UUCP\&.  It
has undergone a steady process of evolution since the first version
which was implemented in 1976\&.  Currently, there are two major species
which differ mainly in their support of hardware and their
configuration\&.  Of these, various implementations exist, each varying
slightly from its siblings\&.
.P 1
.INDEX {UUCP!Version 2}
One species is the so-called ``Version 2 UUCP'', which dates back to
a 1977 implementation by Mike Lesk, David A\&. Novitz, and Greg Chesson\&.
Although it is fairly old, it is still in frequent use\&. Recent
implementations of Version 2 provide much of the comfort of the newer
UUCP species\&.
.P 1
.INDEX {UUCP!HDB}
.INDEX {UUCP!BNU}
.INDEX {Basic Networking Utilities|see UUCP, HDB}
.INDEX {HoneyDanBer|see UUCP, HDB}
.INDEX {HDB|see UUCP, HDB}
.INDEX {BNU|see UUCP, HDB}
The second species was developed in 1983, and is commonly referred
to as BNU (Basic Networking Utilities), HoneyDanBer UUCP, or HDB for
short\&.  The name is derived from the authors' names, P\&. Honeyman,
D\&. A\&. Novitz, and B\&. E\&. Redman\&.  HDB was conceived to eliminate some of
Version 2 UUCP's deficiencies\&.  For example, new transfer protocols were
added, and the spool directory was split so that now there is one
directory for each site you have UUCP traffic with\&.
.P 1
.INDEX {UUCP!Taylor}
.INDEX {Taylor, Ian}
The implementation of UUCP currently distributed with Linux is Taylor
UUCP 1\&.04,(\*F)
.FS
Written and copyrighted by Ian Taylor, 1993\&.
.FE
which is the version this chapter is based upon\&.  Taylor UUCP Version
1\&.04 was released in February 1993\&.  Apart from traditional
configuration files, Taylor UUCP may also be compiled to understand the
new-style -- a\&.k\&.a\&. ``Taylor'' -- configuration files\&.
.P 1
Version 1\&.05 has been released recently, and will soon make its way into
most distributions\&. The differences between these versions mostly affect
features you will never use, so you should be able to configure Taylor
UUCP 1\&.05 using the information form this book\&.
.P 1
As included in most Linux distributions, Taylor UUCP is usually
compiled for BNU compatibility, or the Taylor configuiration scheme, or
both\&.  As the latter is much more flexible, and probably easier to
understand than the often rather obscure BNU configuration files, I
will describe the Taylor scheme below\&.
.P 1
The purpose of this chapter is not to give you an exhaustive description
of what the command line options for the UUCP commands are and what they
do, but to give you an introduction on how to set up a working UUCP
node\&.  The first section gives a hopefully gentle introduction about how
UUCP implements remote execution and file transfers\&. If you are not
entirely new to UUCP, you might want to skip this and move on to
section 
.GETHN "uucp.config.files"
\&, which explains the various files used
to set up UUCP\&.
.P 1
We will however assume that you are familiar with the user programs of
the UUCP suite\&. These are \fIuucp\fR and \fIuux\fR\&. For a description,
please refer to the on-line manual pages\&.
.P 1
Besides the publicly accessible programs, \fIuux\fR and \fIuucp\fR,
the UUCP suite contains a number of commands used for administrative
purposes only\&. They are used to monitor UUCP traffic across your node,
remove old log files, or compile statistics\&. None of these will be
described here, because they're peripheral to the main tasks of UUCP\&.
Besides, they're well documented and fairly easy to understand\&.
However, there is a third category, which comprises the actual UUCP
``work horses''\&.  They are called \fIuucico\fR (where cico stands for
copy-in copy-out), and \fIuuxqt\fR, which executes jobs sent from
remote systems\&.
.P 1
.H 3 "More Information on UUCP"
Those who don't find everything they need in this chapter should read
the documentation that comes along with the package\&.  This is a set of
texinfo files that describe the setup using the Taylor configuration
scheme\&.  Texinfo can be converted to DVI and to GNU info files using
\fItex\fR and \fImakeinfo\fR, respectively\&.
.P 1
.INDEX {HOWTO!UUCP}
If you want to use BNU or even (shudder!) Version 2 configuration files, 
there is a very good book, ``Managing UUCP and Usenet''
([
GETST "reilly-uucp"
])\&.  I find it very useful\&. Another good source for
information about UUCP on Linux is Vince Skahan's UUCP-HOWTO, which is
posted regularly to \fBcomp\&.os\&.linux\&.announce\fR\&.
.P 1
There's also a newsgroup for the discussion of UUCP, called
\fBcomp\&.mail\&.uucp\fR\&.  If you have questions specific to Taylor UUCP,
you may be better off asking them there, rather than on the
\fBcomp\&.os\&.linux\fR groups\&.
.P 1
.H 2 "Introduction"
.P 1
.H 3 "Layout of UUCP Transfers and Remote Execution"
.SETR "uucp.intro.grades"
.P 1
.INDEX {UUCP!job}
Vital to the understanding of UUCP is the concept of \fIjobs\fR\&.
Every transfer a user initiates with \fIuucp\fR or \fIuux\fR is
called a job\&. It is made up of a \fIcommand\fR to be executed on
a remote system, and a collection of \fIfiles\fR to be transferred
between sites\&. One of these parts may be missing\&.
.P 1
As an example, assume you issued the following command on your host, which
makes UUCP copy the file \fInetguide\&.ps\fR to host \fBpablo\fR, and
makes it execute the \fIlpr\fR command to print the file\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ uux -r pablo!lpr !netguide.ps
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {UUCP!spool directory}
UUCP does not generally call the remote system immediately to execute
a job (else you could make do with \fIkermit\fR)\&. Instead, it
temporarily stores the job description away\&. This is called
\fIspooling\fR\&.  The directory tree under which jobs are stored is
therefore called the \fIspool directory\fR and is generally located
in \fI/var/spool/uucp\fR\&.  In our example, the job description would contain
information about the remote command to be executed (\fIlpr\fR), the
user who requested the execution, and a couple of other items\&.  In
addition to the job description, UUCP has to store the input file,
\fInetguide\&.ps\fR\&.
.P 1
The exact location and naming of spool files may vary, depending on
some compile-time options\&. HDB-compatible UUCP's generally store spool
files in a directory named \fI/var/spool/uucp\fR\fI/\fB\fIsite\fB\fI\fR, where
\fB\fIsite\fB\fR is the name of the remote site\&. When compiled for Taylor
configuration, UUCP will create subdirectories below the site-specific
spool directory for different types of spool files\&.
.P 1
At regular intervals, UUCP dials up the remote system\&.  When a
connection to the remote machine is established, UUCP transfers the
files describing the job, plus any input files\&.  The incoming jobs
will not be executed immediately, but only after the connection
terminates\&. This is done by \fIuuxqt\fR, which also takes care of
forwarding any jobs if they are designated for another site\&.
.P 1
.INDEX {UUCP!priorities}
.INDEX {UUCP!spool grade}
.INDEX {UUCP!job}
To distinguish between important and less important jobs, UUCP
associates a \fIgrade\fR with each job\&. This is a single letter,
ranging from 0 through 9, A though Z, and a through z, in decreasing
precedence\&.  Mail is customarily spooled with grade B or C, while news
is spooled with grade N\&.  Jobs with higher grade are transferred
earlier\&. Grades may be assigned using the \fB-g\fR flag when
invoking \fIuucp\fR or \fIuux\fR\&.
.P 1
You can also disallow the transfer of jobs below a given grade at
certain times\&.  This is also called the \fImaximum spool grade\fR
allowed during a conversation and defaults to z\&. Note the
terminological ambiguity here: a file is transferred only if it is
\fIequal or above\fR the maximum spool grade\&.
.P 1
.H 3 "The Inner Workings of uucico"
.SETR "uucico.connect"
.INDEX {UUCP!uucico@\fIuucico\fR|(}
.P 1
.MARGINPAR
<>
.ENDMARGINPAR
To understand why \fIuucico\fR needs to know certain things, a quick
description of how it actually connects to a remote system might be in
order here\&.
.P 1
When you execute \fIuucico -s \fB\fIsystem\fB\fI\fR from the command line, it
first has to connect physically\&. The actions taken depend on the type of
connection to open -- e\&.g\&. when using telephone line, it has to find a
modem, and dial out\&. Over TCP, it has to call \fIgethostbyname(3)\fR to
convert the name to a network address, find out which port to open, and
bind the address to the corresponding socket\&.
.P 1
.INDEX {UUCP!master}
.INDEX {UUCP!slave}
After this connection has been established, an authorization procedure
has to be passed\&. It generally consists of the remote system asking for
a login name, and possibly a password\&. This is commonly called the
\fIlogin chat\fR\&. The authorization procedure is performed either by the
usual \fIgetty\fR/\fIlogin\fR suite, or -- on TCP sockets -- by
\fIuucico\fR itself\&.  If authorization succeeds, the remote end fires
up \fIuucico\fR\&. The local copy of \fIuucico\fR which initiated the
connection is referred to as \fImaster\fR, the remote copy as \fIslave\fR\&.
.P 1
.INDEX {UUCP!call sequence check}
.INDEX {UUCP!handshake}
.INDEX {UUCP!protocol}
Next follows the \fIhandshake phase\fR: the master now sends its
hostname, plus several flags\&.  The slave checks this hostname for
permission to log in, send and receive files, etc\&.  The flags describe
(among other things) the maximum grade of spool files to transfer\&. If
enabled, a conversation count, or \fIcall sequence number\fR check
takes place here\&. With this feature, both sites maintain a count of
successful connections, which are compared\&. If they do not match, the
handshake fails\&. This is useful to protect yourself against impostors\&.
.P 1
Finally, the two \fIuucico\fR's try to agree on a common \fItransfer
protocol\fR\&. This protocol governs the way data is transferred, checked for
consistency, and retransmitted in case of an error\&. There is a need for
different protocols because of the differing types of connections
supported\&. For example, telephone lines require a ``safe'' protocol which
is pessimistic about errors, while TCP transmission is inherently reliable
and can use a more efficient protocol that foregoes most extra error
checking\&.
.P 1
After the handshake is complete, the actual transmission phase begins\&.
Both ends turn on the selected protocol driver\&. The drivers possibly
perform a protocol-specific initialization sequence\&.
.P 1
First, the master sends all files queued for the remote system whose
spool grade is high enough\&. When it has finished, it informs the slave
that it is done, and that the slave may now hang up\&. The slave now can
either agree to hang up, or take over the conversation\&.  This is a
change of roles: now the remote system becomes master, and the local one
becomes slave\&. The new master now sends its files\&.  When done, both
\fIuucico\fR's exchange termination messages, and close the connection\&.
.P 1
We will not go into this in greater detail: please refer to either the
sources or any good book on UUCP for this\&. There is also a really
antique article floating around the net, written by David A\&. Novitz,
which gives a detailed description of the UUCP protocol\&.  The Taylor
UUCP FAQ also disucsses some details of the way UUCP is implemented\&.
It is posted to \fBcomp\&.mail\&.uucp\fR regularly\&.
.P 1
.H 3 "uucico Command Line Options"
.INDEX {UUCP!uucico@\fIuucico\fR}
.INDEX {uucico@\fIuucico\fR}
.INDEX {UUCP!calling out}
.INDEX {UUCP!logging and debugging}
.INDEX {debugging!UUCP setup}
.P 1
This section describes the most important command line options for
\fIuucico\fR\&.  For a complete list, please refer to the
\fIuucico(1)\fR manual page\&.
.P 1
\"
.BL 10
.LI "\fB-s \fB\fIsystem\fB\fB\fR"
Call the named \fB\fIsystem\fB\fR unless prohibited by call time
restrictions\&.
.P 1
.LI "\fB-S \fB\fIsystem\fB\fB\fR"
Call the named \fB\fIsystem\fB\fR unconditionally\&.
.P 1
.LI "\fB-r1\fR"
Start \fIuucico\fR in master mode\&. This is the default when
\fB-s\fR or \fB-S\fR is given\&. All by itself, the
\fB-r1\fR option causes \fIuucico\fR to try to call all
systems in \fIsys\fR, unless prohibited by call or retry time
restrictions\&.
.P 1
.LI "\fB-r0\fR"
Start \fIuucico\fR in slave mode\&. This is the default when no
\fB-s\fR or \fB-S\fR is given\&.  In slave mode, either
standard input/output are assumed to be connected to a serial
port, or the TCP port specified by the \fB-p\fR option is
used\&.
.P 1
.LI "\fB-x \fB\fItype\fB\fB\fR, \fB-X \fB\fItype\fB\fB\fR"
Turn on debugging of the specified type\&. Several types may be
given as a comma-separated list\&. The following types are valid:
\fIabnormal\fR, \fIchat\fR, \fIhandshake\fR,
\fIuucp-proto\fR, \fIproto\fR, \fIport\fR,
\fIconfig\fR, \fIspooldir\fR, \fIexecute\fR,
\fIincoming\fR, \fIoutgoing\fR\&. Using \fIall\fR
turns on all options\&.  For compatibility with other UUCP
implementations, a number may be specified instead, which turns
on debugging for the first \fB\fIn\fB\fR items from the above list\&.
.P 1
Debugging messages will be logged to the file \fIDebug\fR below
\fI/var/spool/uucp\fR\&.
.P 1
\"
.LE
.P 1
.INDEX {UUCP!uucico@\fIuucico\fR|)}
.P 1
.H 2 "UUCP Configuration Files"
.SETR "uucp.config.files"
.P 1
In contrast to simpler file transfer programs, UUCP was designed to be
able to handle all transfers automatically\&. Once it is set up
properly, interference by the administrator should not be necessary
on a day-to-day basis\&. The information required for this is is kept in
a couple of \fIconfiguration files\fR that reside in the directory
\fI/usr/lib/uucp\fR\&. Most of these files are used only when dialing out\&.
.P 1
.H 3 "A Gentle Introduction to Taylor UUCP"
.INDEX {UUCP!configuration files|(}
.P 1
To say that UUCP configuration is hard would be an understatement\&. It
is really a hairy subject, and the sometimes terse format of the
configuration files doesn't make things easier (although the Talyor
format is almost easy reading compared to the older formats in HDB or
Version 2)\&.
.P 1
To give you a feel how all these files interact, we will introduce you
to the most important ones, and have a look at sample entries of these
files\&. We won't explain everything in detail now; a more accurate
account is given in separate sections below\&. If you want to set up your
machine for UUCP, you had best start with some sample files, and adapt
them gradually\&.  You can pick either those shown below, or those
included in your favorite Linux distribution\&.
.P 1
All files described in this section are kept in \fI/usr/lib/uucp\fR or a
subdirectory thereof\&. Some Linux distributions contain UUCP
binaries that have support for both HDB and Taylor configuration
enabled, and use different subdirectories for each configuration file
set\&. There will usually be a \fIREADME\fR file in \fI/usr/lib/uucp\fR\&.
.P 1
For UUCP to work properly, these files must be owned by the
\fBuucp\fR user\&.  Some of them contain passwords and telephone
numbers, and therefore should have permissions of 600\&.(\*F)
.FS
Note that although most UUCP commands must be setuid to \fBuucp\fR,
you must make sure the \fIuuchk\fR program is \fInot\fR\&.  Otherwise,
users will be able to display passwords even though they have mode
600\&.
.FE
.P 1
The central UUCP configuration file is \fI/usr/lib/uucp\fR\fI/config\fR, and is
used to set general parameters\&. The most important of them (and for
now, the only one), is your host's UUCP name\&. At the Virtual Brewery,
they use \fBvstout\fR as their UUCP gateway:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/uucp/config - UUCP main configuration file
hostname         vstout
.ENDVERBATIM
\"
\fR
.DE
.P 1
The next important configuration file is the \fIsys\fR file\&. It
contains all system-specific information of sites you are linked to\&.
This includes the site's name, and information on the link itself, such
as the telephone number when using a modem link\&.  A typical entry for a
modem-connected site called \fBpablo\fR would be
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/uucp/sys - name UUCP neighbors
# system: pablo
system          pablo
time            Any
phone           123-456
port            serial1
speed           38400
chat            ogin: vstout ssword: lorca
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fIport\fR names a port to be used, and \fItime\fR
specifies the times at which it may be called\&.  \fIchat\fR
describes the login chat scripts -- the sequence of strings that must
be exchanged between to allow \fIuucico\fR to log into \fBpablo\fR\&.
We will get back to chat scripts later\&.  The \fIport\fR command
does not name a device special file such as \fI/dev/cua1\fR, but
rather names an entry in the \fIport\fR file\&.  You can assign these
names as you like as long as they refer to a valid entry in
\fIport\fR\&.
.P 1
The \fIport\fR file holds information specific to the link itself\&.  For
modem links, it describes the device special file to be used, the range
of speeds supported, and the type of dialing equipment connected to the
port\&. The entry below describes \fI/dev/cua1\fR (a\&.k\&.a\&. COM 2), to
which a NakWell modem is connected that is capable of running at
speeds up to 38400bps\&.  The entry's name way chosen to match the port
name given in the \fIsys\fR file\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/uucp/port - UUCP ports
# /dev/cua1 (COM2)
port            serial1
type            modem
device          /dev/cua1
speed           38400
dialer          nakwell
.ENDVERBATIM
\"
\fR
.DE
.P 1
The information pertaining to the dialers itself is kept in yet another
file, called -- you guessed it: \fIdial\fR\&. For each dialer type, it
basically contains the sequence of commands to be issued to dial up a
remote site, given the telephone number\&. Again, this is specified as a
chat script\&. For example, the entry for the above NakWell might look
like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/uucp/dial - per-dialer information
# NakWell modems
dialer          nakwell
chat            "" ATZ OK ATDT\T CONNECT
.ENDVERBATIM
\"
\fR
.DE
.P 1
The line starting with \fIchat\fR specifies the modem chat, which is
the sequence of commands sent to and received from the modem to
initialize it and make it dial the desired number\&. The ``\fI\\T\fR''
sequence will be replaced with the phone number by \fIuucico\fR\&.
.P 1
\"
.DF I F 5
\"
\"
.br
.FG " Interaction of Taylor UUCP Configuration Files\&\&. " "" 0 "uucp.fig.files"
.DE
.P 1
To give you a rough idea how \fIuucico\fR deals with these
configuration files, assume you issued the command
.P 1
.P 1
.DS I F 5
\fB$ uucico -s pablo
\"
\fR
.DE
.P 1
.br
.ti 0
on the command line\&. The first thing \fIuucico\fR does is look up
\fBpablo\fR in the \fIsys\fR file\&. From the \fIsys\fR file entry
for \fBpablo\fR it sees that it should use the \fIserial1\fR port
to establish the connection\&.  The \fIport\fR file tells it that this is
a modem port, and that it has a NakWell modem attached\&.
.P 1
\fIuucico\fR now searches \fIdial\fR for the entry describing
the NakWell modem, and having found one, opens the serial port 
\fI/dev/cua1\fR and executes the dialer chat\&. That is, it sends
``\fBATZ\fR'', waits for the ``\fBOK\fR'' response, etc\&. When
encountering the string ``\fI\\T\fR'', it substitutes the phone
number (123--456) extracted from the \fIsys\fR file\&.
.P 1
After the modem returns \fBCONNECT\fR, the connection has been
established, and the modem chat is complete\&. \fIuucico\fR now returns
to the \fIsys\fR file and executes the login chat\&. In our example, it
would wait for the ``\fBlogin:\fR'' prompt, then send its user name
(\fBneruda\fR), wait for the ``\fBpassword:\fR'' prompt, and send its
password, ``\fBlorca\fR''\&.
.P 1
After completing authorization, the remote end is assumed to fire up
its own \fIuucico\fR\&. The two will then enter the handshake phase
described in the previous section\&.
.P 1
The way the configuration files depend on each other is also shown in
figure 
.GETHN "uucp.fig.files"
\&\&.
.P 1
.INDEX {UUCP!configuration files|)}
.P 1
.H 3 "What UUCP Needs to Know"
.SETR "uucp.starting.parameters"
.P 1
Before you start writing the UUCP configuration files, you have to
gather some information it needs to know\&.
.P 1
First, you will have to figure out what serial device your modem is
attached to\&.  Usually, the (DOS) ports COM1 through COM4 map to the
device special files \fI/dev/cua0\fR through \fI/dev/cua3\fR\&.  Most
distributions, such as Slackware, create a link \fI/dev/modem\fR as a
link to the appropriate \fIcua*\fR device file, and configure
\fIkermit\fR, \fIseyon\fR, etc, to use this generic file\&.  In this
case, you should either use \fI/dev/modem\fR in your UUCP
configuration, too\&.
.P 1
The reason for this is that all dial-out programs use so-called
\fIlock files\fR to signal when a serial port is in use\&. The names of
these lock files are a concatenation of the string \fILCK\&.\&.\fR and
the device file name, for instance \fILCK\&.\&.cua1\fR\&. If programs use
different names for the same device, they will fail to recognize each
other's lock files\&.  As a consequence, they will disrupt each other's
session when started at the same time\&.  This is not an unlikely event
when you schedule your UUCP calls using a \fIcrontab\fR entry\&.
.P 1
For details of setting up your serial ports, please refer to
chapter 
.GETHN "serial"
\&\&.
.P 1
Next, you must find out at what speed your modem and Linux will
communicate\&.  You will have to set this to the maximum effective
transfer rate you expect to get\&. The effective transfer rate may be
much higher than the raw physical transfer rate your modem is capable
of\&.  For instance, many modems send and receive data at 2400bps (bits
per second)\&.  Using compression protocols such as V\&.42bis, the actual
transfer rate may climb up to 9600bps\&.
.P 1
Of course, if UUCP is to do anything, you will need the phone number of
a system to call\&.  Also, you will need a valid login id and possibly a
password for the remote machine\&.(\*F)
.FS
If you're just going to try out UUCP, get the number of an archive
site near you\&. Write down the login and password -- they're public to
make anonymous downloads possible\&. In most cases, they're something
like \fBuucp/uucp\fR or \fBnuucp/uucp\fR\&.
.FE
.P 1
.INDEX {UUCP!logging in}
You will also have to know \fIexactly\fR how to log into the system\&.
E\&.g\&., do you have to press the BREAK key before the login prompt
appears? Does it display \fBlogin:\fR or \fBuser:\fR? This is
necessary for composing the \fIchat script\fR, which is a recipe telling
\fIuucico\fR how to log in\&. If you don't know, or if the usual chat
script fails, try to call the system with a terminal program like
\fIkermit\fR or \fIminicom\fR, and write down exactly what you have
to do\&.
.P 1
.H 3 "Site Naming"
.SETR "uucp.starting.sitename"
.INDEX {address!UUCP hostname}
.INDEX {choosing!UUCP hostname}
.INDEX {UUCP!hostname}
.INDEX {hostname!UUCP}
.P 1
As with TCP/IP-based networking, your host has to have a name for UUCP
networking\&. As long as you simply want to use UUCP for file transfers to
or from sites you dial up directly, or on a local network, this name
does not have to meet any standards\&.(\*F)
.FS
The only limitation is that it shouldn't be longer than 7 characters,
so as to not confuse hosts with filesystems that impose a narrow limit
on file names\&.
.FE
.P 1
However, if you use UUCP for a mail or news link, you should think about
having the name registered with the UUCP Mapping project\&. The UUCP
Mapping Project is described in chapter 
.GETHN "mail"
\&\&. Even if you
participate in a domain, you might consider having an official UUCP name
for your site\&.
.P 1
Frequently, people choose their UUCP name to match the first component
of their fully qualified domain name\&. Suppose your site's domain
address is \fBswim\&.twobirds\&.com\fR, then your UUCP host name would be
\fBswim\fR\&.  Think of UUCP sites as knowing each other on a
first-name basis\&.  Of course, you can also use a UUCP name completely
unrelated to your fully qualified domain name\&.
.P 1
.INDEX {UUCP!Mapping Project}
However, make sure not to use the unqualified site name in mail
addresses unless you have registered it as your official UUCP
name\&.(\*F)
.FS
The UUCP Mapping Project registers all UUCP hostnames world-wide and
makes sure they are unique\&. To register your UUCP name, ask the
maintainers of the site that handles your mail; they will be able to
help you with it\&.
.FE
At the very best, mail to an unregistered UUCP host will vanish in
some big black bit bucket\&. If you use a name already held by some other
site, this mail will be routed to that site, and cause its postmaster
no end of headaches\&.
.P 1
By default, the UUCP suite uses the name set by \fIhostname\fR as the
site's UUCP name\&. This name is commonly set in the \fI/etc/rc\&.local\fR
script\&.  If your UUCP name is different from what you set your host name
to, you have to use the \fIhostname\fR option in the \fIconfig\fR
file to tell \fIuucico\fR about your UUCP name\&. This is described
below\&.
.P 1
.H 3 "Taylor Configuration Files"
.P 1
We now return to the configuration files\&.  Taylor UUCP gets its
information from the following files:
.P 1
\"
.BL 10
.LI "\fIconfig\fR"
This is the main configuration file\&. You can define your site's
UUCP name here\&.
.P 1
.LI "\fIsys\fR"
This file describes all sites known to you\&.  For each site, it
specifies its name, at what times to call it, which number to
dial (if any), what type of device to use, and how to log on\&.
.P 1
.LI "\fIport\fR"
Contains entries describing each port available, together with
the line speed supported and the dialer to be used\&.
.P 1
.LI "\fIdial\fR"
Describes dialers used to establish a telephone
connection\&.
.P 1
.LI "\fIdialcode\fR"
Contains expansions for symbolic dialcodes\&.
.P 1
.LI "\fIcall\fR"
Contains the login name and password to be used when calling
a system\&.  Rarely used\&.
.P 1
.LI "\fIpasswd\fR"
Contains login names and passwords systems may use when logging
in\&. This file is used only when \fIuucico\fR does its own
password checking\&.
.P 1
\"
.LE
.P 1
Taylor configuration files are generally made up of lines containing
keyword-value pairs\&. A hash sign introduces a comment that entends
to the end of the line\&. To use a hash sign by itself, you may escape it
with a backslash\&.
.P 1
There are quite a number of options you can tune with these
configuration files\&.  We can't go into all parameters here, but will
only cover the most important ones\&. They you should be able to
configure a modem-based UUCP link\&.  Additional sections will describe
the modifications necessary if you want to use UUCP over TCP/IP or
over a direct serial line\&.  A complete reference is given in the
Texinfo documents that accompany the Taylor UUCP sources\&.
.P 1
.INDEX {display!UUCP configuration}
.INDEX {checking!UUCP}
.INDEX {UUCP!checking}
When you think you have configured your UUCP system completely, you
can check your configuration using the \fIuuchk\fR tool (located in
\fI/usr/lib/uucp\fR)\&. \fIuuchk\fR reads your configuration files, and prints
out a detailed report of the configuration values used for each
system\&.
.P 1
.H 3 "General Configuration Options -- the config File"
.INDEX {UUCP!config file@\fIconfig\fR file}
.INDEX {UUCP!hostname}
.P 1
You won't generally use this file to describe much beside your UUCP
hostname\&.  By default, UUCP will use the name you set with the
\fIhostname\fR command, but it is generally a good idea to set the UUCP
name explicitly\&. A sample file is shown below:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/uucp/config - UUCP main configuration file
hostname        vstout
.ENDVERBATIM
\"
\fR
.DE
.P 1
Of course, there are a number of miscellaneous parameters that may be
set here, too, such as the name of the spool directory, or access rights
for anonymous UUCP\&.  The latter will be described in a later section\&.
.P 1
.H 3 "How to Tell UUCP about other Systems -- the sys File"
.SETR "uucp.systems.file"
.INDEX {UUCP!sys file@\fIsys\fR file}
.INDEX {UUCP!remote system|(}
.P 1
The \fIsys\fR file describes the systems your machine knows about\&.  An
entry is introduced by the \fIsystem\fR keyword; the subsequent
lines up to the next \fIsystem\fR directive detail the parameters
specific to that site\&.  Commonly, a system entry will define parameters
such as the telephone number and the login chat\&.
.P 1
Parameters before the very first \fIsystem\fR line set default
values used for all systems\&.  Usually, you will set protocol paramters
and the like in the defaults section\&.
.P 1
Below, the most prominent fields are discussed in some detail\&.
.P 1
.H 4 "System Name"
.INDEX {UUCP!remote system}
.INDEX {UUCP!hostname}
.P 1
The \fIsystem\fR command names the remote system\&. You must specify
the correct name of the remote system, not an alias you invented,
because \fIuucico\fR will check it against what the remote system says
it is called when you log on\&.(\*F)
.FS
Older Version 2 UUCP's don't broadcast their name when being called;
however, newer implementations often do, and so does Taylor UUCP\&.
.FE
.P 1
Each system name may appear more only once\&.  If you want to use
several sets of configurations for the same system (such as different
telephone numbers \fIuucico\fR should try in turn), you can specify
\fIalternates\fR\&.  Alternates are described below\&.
.P 1
.H 4 "Telephone Number"
.INDEX {UUCP!phone number}
.P 1
If the remote system is to be reached over a telephone line, the
\fIphone\fR field specifies the number the modem should dial\&.  It
may contain several tokens interpreted by \fIuucico\fR's dialing
procedure\&.  An equal sign means to wait for a secondary dial tone, and
a dash generates a one-second pause\&. For instance, some telephone
installations will choke when you don't pause between dialing the
prefix code and telephone number\&.
.P 1
\fB[Don't know the proper English term for this -- you know,
something like a company's private internal installation where you
have to dial a 0 or 9 to get a line to the outside\&.]\fR
.P 1
.INDEX {UUCP!dialcode file@\fIdialcode\fR file}
Any embedded alphabetic string may be used to hide site-dependent
information like area codes\&. Any such string is translated to a
dialcode using the \fIdialcode\fR file\&. Suppose you have the
following \fIdialcode\fR file:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/uucp/dialcode - dialcode translation
Bogoham         024881
Coxton          035119
.ENDVERBATIM
\"
\fR
.DE
.P 1
With these translations, you can use a phone number such as
\fIBogoham7732\fR in the \fIsys\fR file, which makes things probably
a little more legible\&.
.P 1
.H 4 "Port and Speed"
.INDEX {UUCP!device}
.P 1
The \fIport\fR and \fIspeed\fR options are used to select
the device used for calling the remote system, and the maximum
speed to which the device should be set\&.(\*F)
.FS
The Baud rate of the tty must be at least as high as the maximum
transfer speed\&.
.FE
A \fIsystem\fR entry may use either option alone, or both options
in conjunction\&.  When looking up a suitable device in the \fIport\fR
file, only those ports are selected that have a matching port name
and/or speed range\&.
.P 1
Generally, using the \fIspeed\fR option should suffice\&. If you have
only one serial device defined in \fIport\fR, \fIuucico\fR will always
pick the right one, anyway, so you only have to give it the desired
speed\&.  If you have several modems attached to your systems, you still
often don't want to name a particular port, because if \fIuucico\fR
finds that there are several matches, it tries each device in turn until
it finds an unused one\&.
.P 1
.H 4 "The Login Chat"
.INDEX {UUCP!logging in}
.INDEX {UUCP!login chat}
.INDEX {UUCP!chat scripts|(}
.INDEX {chat script!UUCP}
.P 1
Above, we already encountered the login chat script, which tells
\fIuucico\fR how to log into the remote system\&.  It consists of a list
of tokens, specifying strings expected and sent by the local
\fIuucico\fR process\&. The intention is to make \fIuucico\fR wait until
the remote machine sends a login prompt, then return the login name,
wait for the remote system to send the password prompt, and send the
password\&. Expect and send strings are given in alternation\&.
\fIuucico\fR automatically appends a carriage return character
(\fI\\r\fR) to any send string\&. Thus, a simple chat script would
look like
.P 1
.P 1
.DS I F 5
\fBogin: vstout ssword: catch22
\"
\fR
.DE
.P 1
You will notice that the expect fields don't contain the whole prompts\&.
This is to make sure that the login succeeds even if the remote system
broadcasts \fBLogin:\fR instead of \fBlogin:\fR\&.
.P 1
\fIuucico\fR also allows for some sort of conditional execution, for
example in the case that the remote machine's \fIgetty\fR needs to be
reset before sending a prompt\&. For this, you can attach a sub-chat to an
expect string, offset by a dash\&.  The sub-chat is executed only if the
main expect fails, i\&.e\&. a timeout occurs\&.  One way to use this feature
is to send a BREAK if the remote site doesn't display a login prompt\&.
The following example gives an allround chat script that should also
work in case you have to hit return before the login appears\&.
\fB""\fR tells UUCP to not wait for anything and continue with
the next send string immediately\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 "" \n\r\d\r\n\c ogin:-BREAK-ogin: vstout ssword: catch22
.ENDVERBATIM
\"
\fR
.DE
.P 1
There are a couple of special strings and escape characters which may
occur in the chat script\&. The following is an incomplete list of
characters legal in expect strings:
.P 1
\"
.BL 10
.LI "\fI""\fR"
The empty string\&. It tells \fIuucico\fR not to wait for
anything, but proceed with the next send string immediately\&.
.P 1
.LI "\fI\\\\\\\\t\fR"
Tab character\&.
.P 1
.LI "\fI\\\\\\\\r\fR"
Carriage return character\&.
.P 1
.LI "\fI\\\\\\\\s\fR"
Space character\&. You need this to embed spaces in a chat string\&.
.P 1
.LI "\fI\\\\\\\\n\fR"
Newline character\&.
.P 1
.LI "\fI\\\\\\\\\\\\\\\\\fR"
Backslash character\&.
.P 1
\"
.LE
.P 1
.SP 2
.br
.ti 0
On send strings, the following escape characters and strings are legal
in addition to the above:
.P 1
\"
.BL 10
.LI "\fIEOT\fR"
End of transmission character (\fB^D\fR)\&.
.P 1
.LI "\fIBREAK\fR"
Break character\&.
.P 1
.LI "\fI\\\\\\\\c\fR"
Suppress sending of carriage return at end of string\&.
.P 1
.LI "\fI\\\\\\\\d\fR"
Delay sending for 1 second\&.
.P 1
.LI "\fI\\\\\\\\E\fR"
Enable echo checking\&. This requires \fIuucico\fR to wait for
the echo of everything it writes to be read back from the device
before it can continue with the chat\&. It is primarily useful
when used in modem chats (which we will encounter below)\&. Echo
checking is off by default\&.
.P 1
.LI "\fI\\\\\\\\e\fR"
Disable echo checking\&.
.P 1
.LI "\fI\\\\\\\\K\fR"
Same as \fIBREAK\fR\&.
.P 1
.LI "\fI\\\\\\\\p\fR"
Pause for fraction of a second\&.
\"
.LE
.P 1
.INDEX {UUCP!chat scripts|)}
.P 1
.H 4 "Alternates"
.INDEX {UUCP!alternates}
.P 1
Sometimes it is desirable to have multiple entries for a single system,
for instance if the system can be reached on different modem lines\&.
With Taylor UUCP, you can do this by defining a so-called \fIalternate\fR\&.
.P 1
An alternate entry retains all settings from the main system entry, and
and specifies only those values that should be overridden in the default
system entry, or added to it\&.  An alternate is offset from the system
entry by a line containing the keyword \fIalternate\fR\&.
.P 1
To use two phone numbers for \fBpablo\fR, you would modify its
\fIsys\fR entry in the following way:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
system       pablo
phone        123-456
... entries as above ...
alternate
phone        123-455
.ENDVERBATIM
\"
\fR
.DE
.P 1
When calling \fBpablo\fR, \fIuucico\fR will now first dial 123-456,
and if this fails, try the alternate\&.  The alternate entry retains all
settings from the main system entry, and overrides only the telephone
number\&.
.P 1
.H 4 "Restricting Call Times"
.INDEX {UUCP!restrict!call time}
.INDEX {UUCP!call time}
.P 1
Taylor UUCP provides a number of ways you may restrict the times when
calls can be placed to a remote system\&.  You might do this either
because of limitations the remote host places on its services during
business hours, or simply to avoid times with high call rates\&. Note
that it is always possible to override call time restrictions by
giving \fIuucico\fR the \fB-S\fR or \fB-f\fR option\&.
.P 1
By default, Taylor UUCP will disallow connections at any time, so you
\fIhave\fR to use some sort of time specification in the \fIsys\fR
file\&.  If you don't care about call time restrictions, you can specify
the \fItime\fR option with a value of \fIAny\fR in your
\fIsys\fR file\&.
.P 1
The simplest way to restrict call time is the \fItime\fR entry,
which is followed by a string made up of a day and a time subfield\&.
Day may be any of \fIMo, Tu, We, Th, Fr, Sa, Su\fR combined, or
\fIAny\fR, \fINever\fR, or \fIWk\fR for weekdays\&. The time
consists of two 24-hour clock values, separated by a dash\&. They
specify the range during which calls may be placed\&. The combination of
these tokens is written without white space in between\&.  Any number of
day and time specifications may be grouped together with commas\&.  For
example,
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
time            MoWe0300-0730,Fr1805-2000
.ENDVERBATIM
\"
\fR
.DE
.P 1
.br
.ti 0
allows calls on Monday and Wednesdays from 3 a\&.m\&. to 7\&.30, and on
Fridays between 18\&.05 and 20\&.00\&.  When a time field spans midnight, say
\fIMo1830-0600\fR, it actually means Monday, between midnight and
6 a\&.m\&., and between 6\&.30 p\&.m\&. and midnight\&.
.P 1
The special time strings \fIAny\fR and \fINever\fR mean what
they say: Calls may be placed at any or no time, respectively\&.
.P 1
.INDEX {UUCP!retry interval}
The \fItime\fR command takes an optional second argument that
describes a retry time in minutes\&. When an attempt to establish a
connection fails, \fIuucico\fR will not allow another attempt to dial
up the remote host within a certain interval\&. By default,
\fIuucico\fR uses an exponential backoff scheme, where the retry
interval increases with each repeated failure\&.  For instance, when you
specify a retry time of 5 minutes, \fIuucico\fR will refuse to call
the remote system within 5 minutes after the last failure\&.
.P 1
.INDEX {UUCP!priorities|(}
.INDEX {UUCP!spool grade|(}
The \fItimegrade\fR command allows you to attach a maximum spool
grade to a schedule\&. For instance, assume you have the following
\fItimegrade\fR commands in a \fIsystem\fR entry:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
timegrade           N Wk1900-0700,SaSu 
timegrade           C Any
.ENDVERBATIM
\"
\fR
.DE
.P 1
This allows jobs with a spoolgrade of C or higher (usually, mail is
queued with grade B or C) to be transferred whenever a call is
established, while news (usually queued with grade N) will be
transferred only during the night and at weekends\&.
.P 1
Just like \fItime\fR, the \fItimegrade\fR command takes
a retry interval in minutes as an optional third argument\&.
.P 1
However, a caveat about spool grades is in order here: First, the
\fItimegrade\fR option applies only to what \fIyour\fR systems
sends; the remote system may still transfer anything it likes\&.  You can
use the \fIcall-timegrade\fR option to explicitly request it to send
only jobs above some given spool grade; but there's no guarantee it will
obey this request\&.(\*F)
.FS
If the remote system runs Talyor UUCP, it will obey\&.
.FE
.P 1
Similarly, the \fItimegrade\fR field is not checked when a remote
system calls in, so any jobs queued for the calling system will be sent\&.
However, the remote system can explicitly request your \fIuucico\fR to
restrict itself to a certain spool grade\&.
.P 1
.INDEX {UUCP!priorities|)}
.INDEX {UUCP!spool grade|)}
.INDEX {UUCP!remote system|)}
.P 1
.H 3 "What Devices there are -- the port File"
.INDEX {UUCP!port file@\fIport\fR file}
.INDEX {UUCP!device|(}
.INDEX {UUCP!modem}
.P 1
The \fIport\fR file tells \fIuucico\fR about the available ports\&.
These may be modem ports, but other types such as direct serial lines
and TCP sockets are supported as well\&.
.P 1
Like the \fIsys\fR file, \fIport\fR consists of separate entries
starting with the keyword \fIport\fR, followed by the port name\&.
This name may be used by in the \fIsys\fR file's \fIport\fR
statement\&.  The name need not be unique; if there are several ports
with the same name, \fIuucico\fR will try each in turn until it finds
one that is not currently being used\&.
.P 1
The \fIport\fR command should be immediately followed by the
\fItype\fR statement that describes what type of port is described\&.
Valid types are \fImodem\fR, \fIdirect\fR for direct
connections, and \fItcp\fR for TCP sockets\&. If the \fIport\fR
command is missing, the port type defaults to modem\&.
.P 1
In this section, we will cover only modem ports; TCP ports and direct
lines are discussed in a later section\&.
.P 1
For modem and direct ports, you have to specify the device for calling
out using the \fIdevice\fR directive\&.  Usually, this is the name of
a device special file in the \fI/dev\fR directory, like
\fI/dev/cua1\fR\&.(\*F)
.FS
Some people use the \fIttyS*\fR devices instead, which are intended
for dial-in only\&.
.FE
.P 1
In the case of a modem device, the port entry also determines what type
of modem is connected to the port\&.  Different types of modems have to be
configured differently\&.  Even modems that claim to be Hayes-compatible
needn't be really compatible with each other\&.  Therefore, you have to
tell \fIuucico\fR how to initialize the modem and how to make it dial
the desired number\&.  Taylor UUCP keeps the descriptions of all dialers
in a file named \fIdial\fR\&.  To use any of these, you have to specify
the dialer's name using the \fIdialer\fR command\&.
.P 1
Sometimes, you will want to use a modem in different ways, depending
on which system you call\&.  For instance, some older modems don't
understand when a high-speed modem attempts to connect at 14400bps;
they simply drop the line instead of negotiating a connect at, say,
9600bps\&. When you know site \fBdrop\fR uses such a dumb modem, you
have to set up your modem differently when calling them\&. For this, you
need an additional port entry in the \fIport\fR file that specifies a
different dialer\&.  Now you can give the new port a different name,
such as \fIserial1-slow\fR, and use the \fIport\fR directive
in \fBdrop\fR system entry in \fIsys\fR\&.
.P 1
A better way is to distinguish the ports by the speeds they support\&.
For instance, the two port entries for the above situation may look
like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# NakWell modem; connect at high speed
port            serial1         # port name
type            modem           # modem port
device          /dev/cua1       # this is COM2
speed           38400           # supported speed
dialer          nakwell         # normal dialer

# NakWell modem; connect at low speed
port            serial1         # port name
type            modem           # modem port
device          /dev/cua1       # this is COM2
speed           9600            # supported speed
dialer          nakwell-slow    # don't attempt fast connect
.ENDVERBATIM
\"
\fR
.DE
.P 1
The system entry for site \fBdrop\fR would now give \fIserial1\fR
as port name, but request to use it at 9600bps only\&.  \fIuucico\fR
will then automatically use the second port entry\&. All remaining
sites that have a speed of 38400bps in the system entry will be called
using the first port entry\&.
.P 1
.INDEX {UUCP!device|)}
.P 1
.H 3 "How to Dial a Number -- the dial File"
.INDEX {UUCP!dial file@\fIdial\fR file}
.INDEX {UUCP!modem|(}
.P 1
The \fIdial\fR file describes the way various dialers are used\&.
Traditionally, UUCP talks of dialers rather than modems, because in
earlier times, it was usual practice to have one (expensive) automatic
dialing device serve a whole bank of modems\&. Today, most modems have
dialing support builtin, so this distinction gets a little blurred\&.
.P 1
Nevertheless, different dialers or modems may require a different
configuration\&.  You can describe each of them in the \fIdial\fR file\&.
Entries in \fIdial\fR start with the \fIdialer\fR command that
gives the dialer's name\&.
.P 1
The most important entry beside this is the modem chat, specified by
the \fIchat\fR command\&. Similar to the login chat, it consists of
a sequence of strings \fIuucico\fR sends to the dialer and the
responses it expects in return\&. It is commonly used to reset the modem
to some known state, and dial the number\&. The following sample dialer
entry shows a typical modem chat for a Hayes-compatible modem:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# NakWell modem; connect at high speed
dialer          nakwell         # dialer name
chat            "" ATZ OK\r ATH1E0Q0 OK\r ATDT\T CONNECT
chat-fail       BUSY
chat-fail       ERROR
chat-fail       NO\sCARRIER
dtr-toggle      true
.ENDVERBATIM
\"
\fR
.DE
.P 1
The modem chat begins with \fB""\fR, the empty expect string\&.
\fIuucico\fR will therefore send the first command (\fBATZ\fR) right
away\&.  \fBATZ\fR is the Hayes command to reset the modem\&. It then waits
until the modem has sent \fBOK\fR, and sends the next command which
turns off local echo, and the like\&. After the modem returns \fBOK\fR
again, \fIuucico\fR sends the dialing command (\fBATDT\fR)\&. The escape
sequence \fB\\T\fR in this string is replaced with the phone number
taken from the system entry \fIsys\fR file\&. \fIuucico\fR then waits for
the modem to return the string \fBCONNECT\fR, which signals that a
connection with the remote modem has been established successfully\&.
.P 1
Often, the modem fails to connect to the remote system, for instance if
the other system is talking to someone else and the line is busy\&.  In
this case, the modem will return some error message indicating the
reason\&.  Modem chats are not capable to detect such messages;
\fIuucico\fR will continue to wait for the expected string until it
times out\&. The UUCP log file will therefore only show a bland ``timed
out in chat script'' instead of the true reason\&.
.P 1
However, Taylor UUCP allows you to tell \fIuucico\fR about these error
messages using the \fIchat-fail\fR command as shown above\&. When
\fIuucico\fR detects a chat-fail string while executing the modem chat,
it aborts the call, and logs the error message in the UUCP log file\&.
.P 1
The last command in the example shown above tells UUCP to toggle the
DTR line before starting the modem chat\&. Most modems can be configured
to go on-hook when detecting a change on the DTR line, and enter
command mode\&.(\*F)
.FS
You can also configure some modems to reset themselves when
detecting a transition on DTR\&.  Some of them, however, don't
seem to like this, and occasionally get hung\&.
.FE
.P 1
.INDEX {UUCP!modem|)}
.P 1
.H 3 "UUCP Over TCP"
.INDEX {UUCP!over TCP/IP}
.INDEX {TCP!UUCP}
.P 1
Absurd as it may sound at the first moment, using UUCP to transfer data
over TCP not that bad an idea, especially when transferring large
amount of data such as Usenet news\&.  On TCP-based links, news is
generally exchanged using the NNTP protocol, where articles are
requested and sent individually, without compression or any other
optimization\&.  Although adequate for large sites with several concurrent
newsfeeds, this technique is very unfavorable for small sites that
receive their news over a slow connection such as ISDN\&.  These sites
will usually want to combine the qualities of TCP with the advantages of
sending news in large batches, which can be compressed and thus
transferred with very low overhead\&. A standard way to transfer these
batches is to use UUCP over TCP\&.
.P 1
In \fIsys\fR, you would specify a system to be called via TCP
in the following way:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
system          gmu
address         news.groucho.edu
time            Any
port            tcp-conn
chat            ogin: vstout word: clouseau
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fIaddress\fR command gives the IP address of the host, or its
fully qualified domain name\&.  The corresponding \fIport\fR entry would
read:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
port            tcp-conn
type            tcp
service         540
.ENDVERBATIM
\"
\fR
.DE
.P 1
The entry states that a TCP connection should be used when a \fIsys\fR
entry references \fItcp-conn\fR, and that \fIuucico\fR should
attempt to connect to the TCP network port 540 on the remote host\&.  This
is the default port number of the UUCP service\&. Instead of the port
number, you may also give a symbolic port name to the \fIservice\fR
command\&. The port number corresponding to this name will be looked up
in \fI/etc/services\fR\&. The common name for the UUCP service is
\fIuucpd\fR\&.
.P 1
.H 3 "Using a Direct Connection"
.INDEX {UUCP!direct lines}
.P 1
Assume you use a direct line connecting your system \fBvstout\fR
to \fBtiny\fR\&. Very much like in the modem case, you have to
write a system entry in the \fIsys\fR file\&. The \fIport\fR command
identifies the serial port \fItiny\fR is hooked up to\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
system          tiny
time            Any
port            direct1
speed           38400
chat            ogin: cathcart word: catch22
.ENDVERBATIM
\"
\fR
.DE
.P 1
In the \fIport\fR file, you have to describe the serial port for the
direct connection\&. A \fIdialer\fR entry is not needed, because
there's no need for dialing\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
port            direct1
type            direct
speed           38400
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 2 "The Do's and Dont's of UUCP -- Tuning Permissions"
.SETR "uucp.permissions"
.INDEX {security!UUCP|(}
.INDEX {access!UUCP|(}
.P 1
.H 3 "Command Execution"
.INDEX {UUCP!restrict!command execution}
.INDEX {UUCP!command execution}
.P 1
UUCP's task is to copy files from one system to another, and to request
execution of certain commands on remote hosts\&. Of course, you as an
administrator would want to control what rights you grant other
systems -- allowing them to execute any command on your system is
definitely not a good idea\&.
.P 1
.INDEX {SMTP!batched}
.INDEX {rmail@\fIrmail\fR}
.INDEX {rnews@\fIrnews\fR}
.INDEX {UUCP!mail}
.INDEX {UUCP!news}
By default, the only commands Taylor UUCP allows other systems to
execute on your machine are \fIrmail\fR and \fIrnews\fR, which are
commonly used to to exchange email and Usent news over UUCP\&. The default
search path used by \fIuuxqt\fR is a compile-time option, but should
usually contain \fI/bin\fR, \fI/usr/bin\fR, and \fI/usr/local/bin\fR\&.
To change the set of commands for a particular system, you can use the
\fIcommands\fR keyword in the \fIsys\fR file\&. Similarly, the search
path can be changed with the \fIcommand-path\fR statement\&.  For
instance, you may want to allow system \fBpablo\fR to execute the
\fIrsmtp\fR command in addition to \fIrmail\fR and
\fIrnews\fR:(\*F)
.FS
\fIrsmtp\fR is used to deliver mail with batched SMTP\&. This is
described in the mail chapters\&.
.FE
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
system          pablo
...
commands        rmail rnews rsmtp
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "File Transfers"
.INDEX {UUCP!restrict!file transfer}
.INDEX {UUCP!file transfer}
.P 1
Taylor UUCP also allows you to fine-tune file transfers in great
detail\&.  At one extreme, you can disable transfers to and from a
particular system\&.  Just set \fIrequest\fR to \fIno\fR, and
the remote system will not be able either to retrieve files from your
system or send it any files\&.  Similarly, you can prohibit your users
from transferring files to or from a system by setting
\fItransfer\fR to \fIno\fR\&.  By default, users on both the
local and the remote system are allowed to up- and download files\&.
.P 1
In addition, you can configure the directories to and from which files may
be copied\&. Usually, you will want to restrict access from remote systems
to a single directory hierarchy, but still allow your users to send
files from their home directory\&. Commonly, remote users will be allowed
to receive files only from the public UUCP directory, \fI/var/spool/uucppublic\fR\&.
This is the traditional place to make files publicly available; very
much like FTP servers on the Internet\&.  It is commonly referred to using
the tilde character\&.
.P 1
Therefore, Taylor UUCP provides four different commands to configure the
directories for sending and receiving files\&. They are
\fIlocal-send\fR, which specifies the list of directories a user may
ask UUCP to send files from; \fIlocal-receive\fR, which gives the
the list of directories a user may ask to receive files to; and
\fIremote-send\fR and \fIremote-receive\fR, which do the
analogous for requests from a foreign system\&.
Consider the following example:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
system          pablo
...
local-send      /home ~
local-receive   /home ~/receive
remote-send     ~ !~/incoming !~/receive
remote-receive  ~/incoming
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fIlocal-send\fR command allows users on your host to send any
files below \fI/home\fR and from the public UUCP directory to
\fBpablo\fR\&. The \fIlocal-receive\fR command allows them to
receive files either to the world-writable \fIreceive\fR directory in
the \fIuucppublic\fR, or any world-writable directory below \fI/home\fR\&.  The
\fIremote-send\fR directive allows \fBpablo\fR to request files
from \fI/var/spool/uucppublic\fR, except for files below the \fIincoming\fR and
\fIreceive\fR directories\&. This is signaled to \fIuucico\fR by
preceding the directory names with exclamation marks\&. Finally, the
last line allows \fBpablo\fR to upload any files to \fBincoming\fR\&.
.P 1
One of the biggest problems with file transfers using UUCP is that
will only receive files to directories that are world-writable\&.
This may tempt some users to set up traps for other users, etc\&.
However, there's no way escaping this problem except disabling UUCP
file transfers altogether\&.
.P 1
.H 3 "Forwarding"
.INDEX {UUCP!restrict!forwarding}
.INDEX {UUCP!forwarding}
.P 1
UUCP provides a mechanism to have other systems execute file transfers
on your behalf\&.  For instance, this allows you to make \fBseci\fR
retrieve a file from \fBuchile\fR for you, and send it to your
system\&.  The following command would achieve this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ uucp -r seci!uchile!~/find-ls.gz ~/uchile.files.gz
.ENDVERBATIM
\"
\fR
.DE
.P 1
This technique of passing a job through several systems is called
\fIforwarding\fR\&.   In the above example, the reason to use forwarding
may be that \fBseci\fR has UUCP access to \fBuchile\fR, but your
host doesn't\&.  However, if you run a UUCP system, you would want to
limit the forwarding service to a few hosts you trust not to run up
a horrendous phone bill by making you download the latest X11R6 source
release for them\&.
.P 1
By default, Taylor UUCP disallows forwarding altogether\&. To enable
forwarding for a particular system, you can use the \fIforward\fR
command\&.  This command specifies a list of sites the system may
request you to forward jobs to and from\&. For instance, the UUCP
administrator of \fBseci\fR would have to add the following lines to
the \fIsys\fR file to allow \fBpablo\fR to request files from
\fBuchile\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
####################
# pablo
system          pablo
...
forward         uchile
####################
# uchile
system          uchile
...
forward-to      pablo
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fIforward-to\fR entry for \fBuchile\fR is necessary so that
any files returned by it are actually passed on to \fBpablo\fR\&.
Otherwise UUCP would drop them\&. This entry uses a variation of the
\fIforward\fR command that permits \fBuchile\fR only to send
files to \fBpablo\fR through \fBseci\fR; not the other way round\&.
.P 1
To permit forwarding to any system, use the special keyword \fIANY\fR
(capital letters required)\&.
.P 1
.H 2 "Setting up your System for Dialing in"
.SETR "uucp.dialin"
.INDEX {UUCP!configure as server|(}
.INDEX {UUCP!calling in}
.INDEX {server!UUCP|(}
.P 1
If you want to set up your site for dialing in, you have to permit logins
on your serial port, and customize some system files to provide UUCP
accounts\&. This will be the topic of the current section\&.
.P 1
.H 3 "Setting up getty"
.SETR "uucp.dialin.uugetty"
.INDEX {UUCP!and getty@and \fIgetty\fR}
.INDEX {uugetty@\fIuugetty\fR}
.INDEX {getty@\fIgetty\fR}
.INDEX {mgetty@\fImgetty\fR}
.P 1
If you want to use a serial line as a dialin port, you have to enable
a \fIgetty\fR process on this port\&.  However, some \fIgetty\fR
implementations aren't really suitable for this, because you usually
want to use a serial port for dialing in and out\&.  You therefore have
to make sure to use a \fIgetty\fR that is able to share the line with
other programs like \fIuucico\fR, or \fIminicom\fR\&. One program that
does this is \fIuugetty\fR from the \fIgetty_ps\fR package\&.  Most
Linux distributions have it; check for \fIuugetty\fR in your
\fI/sbin\fR directory\&.  Another program I am aware of is Gert
Doering's \fImgetty\fR, which also supports reception of facsimiles\&.
You can also obtain the latest versions of these from
\fBsunsite\&.unc\&.edu\fR as either binary or source\&.
.P 1
Explaining the differences in the way \fIuugetty\fR and \fImgetty\fR
handle logins is beyond the scope of this little section; for more
information, please refer to the Serial HOWTO by Grag Hankins, as well
as the documentation that comes along with \fIgetty_ps\fR and
\fImgetty\fR\&.
.P 1
.H 3 "Providing UUCP Accounts"
.SETR "uucp.dialin.accounts"
.INDEX {UUCP!accounts}
.INDEX {UUCP!set up logins|(}
.P 1
Next, you have to set up user accounts that let remote sites log into
your system and establish a UUCP connection\&. Generally, you will provide
a separate login name to each system that polls you\&.  When setting up an
account for system \fBpablo\fR, you would probably give it
\fBUpablo\fR as the user name\&.
.P 1
For systems that dial in through the serial port, you usually have to
add these accounts to the system password file, \fI/etc/passwd\fR\&. A
good practice is to put all UUCP logins in a special group such as
\fBuuguest\fR\&.  The account's home directory should be set to the public
spool directory \fI/var/spool/uucppublic\fR; its login shell must be \fIuucico\fR\&.
.P 1
If you have the shadow password suite installed, you can do this with
the \fIuseradd\fR command:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# useradd -d /var/spool/uucppublic -G uuguest -s /usr/lib/uucp/uucico Upablo
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you don't use the shadow password suite, you probably have to edit
\fI/etc/passwd\fR by hand, adding a line like that shown below, where
5000 and 150 are the numerical uid and gid assigned to user
\fBUpablo\fR and group \fBuuguest\fR, respectively\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
Upablo:x:5000:150:UUCP Account:/var/spool/uucppublic:/usr/lib/uucp/uucico
.ENDVERBATIM
\"
\fR
.DE
.P 1
After installing the account, you have to activate it by setting its
password with the \fIpasswd\fR command\&.
.P 1
To serve UUCP systems that connect to your site over TCP, you have to
set up \fIinetd\fR to handle incoming connections on the
\fIuucp\fR port\&.  You do this by adding the following line to
\fI/etc/inetd\&.conf\fR:(\*F)
.FS
Note that usually, \fItcpd\fR has mode 700, so that you must
invoke it as user \fBroot\fR, not \fBuucp\fR as you would
usually do\&.
.FE
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
uucp   stream  tcp   nowait  root  /usr/sbin/tcpd  /usr/lib/uucp/uucico -l
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {UUCP!passwd file@\fIpasswd\fR file}
The \fB-l\fR option makes \fIuucico\fR perform its own login
authorization\&. It will prompt for a login name and a password just like the
standard \fIlogin\fR program, but will rely on its private password
database instead of \fI/etc/passwd\fR\&.  This private password file is
named \fI/usr/lib/uucp\fR\fI/passwd\fR and contains pairs of login names and
passwords:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
Upablo  IslaNegra
Ulorca  co'rdoba
.ENDVERBATIM
\"
\fR
.DE
.P 1
Of course, this file must be owned by \fBuucp\fR and have permissions
of 600\&.
.P 1
.INDEX {mgetty@\fImgetty\fR}
If this database sounds like such a good idea you would like to use on
normal serial logins, too, you will be disappointed to hear that this
isn't possible at the moment without major contortions\&. First off, you
need Taylor UUCP 1\&.05 for this, because it allows \fIgetty\fR to pass
the login name of the calling user to \fIuucico\fR using the
\fB-u\fR option\&.(\*F)
.FS
The \fB-u\fR option is present in 1\&.04, too, but is only a no-op\&.
.FE
Then, you have to trick the \fIgetty\fR you are using into invoking
\fIuucico\fR instead of the usual \fI/bin/login\fR\&. With
\fIgetty_ps\fR, you can do this by setting the \fILOGIN\fR option in
the configuration file\&. However, this disables interactive logins
altogether\&.  \fImgetty\fR, on the other hand, has a nice feature that
allows you to invoke different login commands based on the name the user
provided\&. For instance, you can tell \fImgetty\fR to use \fIuucico\fR for
all users that provide a login name beginning with a capital U, but let
everyone else be handled by the standard \fIlogin\fR command\&.
.P 1
To protect your UUCP users from callers giving a false system name
and snarfing all their mail, you should add \fIcalled-login\fR
commands to each system entry in the \fIsys\fR file\&. This is
described in section 
.GETHN "uucp.security.called-login"
\& above\&.
.P 1
.INDEX {UUCP!set up logins|)}
.P 1
.H 3 "Protecting Yourself Against Swindlers"
.SETR "uucp.security.called-login"
.INDEX {security!UUCP logins|(}
.INDEX {UUCP!login security|(}
.P 1
One of the biggest problems about UUCP is that the calling system
can lie about its name; it announces its name to the called system after
logging in, but the server doesn't have a way to check this\&. Thus, an
attacker could log into his or her own UUCP account, pretend to be
someone else, and pick up that other site's mail\&. This is particularly
troublesome if you offer login via anonymous UUCP, where the password is
made public\&.
.P 1
Unless you know you can trust all sites that call your system to be honest,
you \fImust\fR guard against this sort of impostors\&. The cure against
this disease is to require each system to use a particular login name
by specifying a \fIcalled-login\fR in \fIsys\fR\&. A sample system entry
may look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
system          pablo
... usual options ...
called-login    Upablo
.ENDVERBATIM
\"
\fR
.DE
.P 1
The upshot of this is that whenever a system logs in and pretends it is
\fBpablo\fR, \fIuucico\fR will check whether it has logged in as
\fBUpablo\fR\&. If it hasn't, the calling system will be turned down, and
the connection is dropped\&. You should make it a habit to add the
\fIcalled-login\fR command to every system entry you add to your
\fIsys\fR file\&. It is important that you do this for \fIall\fR sytems,
regardless of whether they will ever call your site or not\&. For those sites
that never call you, you should probably set \fIcalled-login\fR to some
totally bogus user name, such as \fBneverlogsin\fR\&.
.P 1
.H 3 "Be Paranoid -- Call Sequence Checks"
.INDEX {UUCP!call sequence check|(}
.P 1
Another way to fend off and detect impostors is to use call sequence
checks\&.  Call sequence checks help you protect against intruders that
somehow managed to find out the password you log into your UUCP system
with\&.
.P 1
When using call sequence checks, both machines keep track of the number
of connections established so far\&. It is incremented with each
connection\&.  After logging in, the caller sends its call sequence
number, and the callee checks it against its own number\&. If they don't
match, the connection attempt will be rejected\&. If the initial number is
chosen at random, attackers will have a hard time guessing the correct
call sequence number\&.
.P 1
But call sequence checks do more for you than this: even if some very
clever person should detect your call sequence number as well as your
password, you will find this out\&. When the attacker call your UUCP feed
and steals your mail, this will increase the feeds call sequence number
by one\&.  The next time \fIyou\fR call your feed and try to log in, the
remote \fIuucico\fR will refuse you, because the numbers don't match
anymore!
.P 1
If you have enabled call sequence checks, you should check your log
files regularly for error messages that hint at possible attacks\&.
If your system rejects the call sequence number the calling system offers
it, \fIuucico\fR will put a message into the log file saying something
like ``Out of sequence call rejected''\&. If your system is rejected by its
feed because the sequence numbers are out of sync, it will put a message
in the log file saying ``Handshake failed (RBADSEQ)''\&.
.P 1
To enable call sequence checks, you have to add following command to the
system entry:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# enable call sequence checks
sequence        true
.ENDVERBATIM
\"
\fR
.DE
.P 1
Beside this, you have to create the file containing the sequence number
itself\&.  Taylor UUCP keeps the sequence number is in a file called
\fI\&.Sequence\fR in the remote site's spool directory\&. It \fImust\fR
be owned by \fBuucp\fR, and must be mode 600 (i\&.e\&. readable and
writeable only by \fBuucp\fR)\&.  It is best to initialize this file with
an arbitrary, agreed-upon start value\&.  Otherwise, an attacker might
manage to guess the number by trying out all values smaller than, say,
60\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# cd /var/spool/uucp/pablo
# echo 94316 > .Sequence
# chmod 600 .Sequence
# chown uucp.uucp .Sequence
.ENDVERBATIM
\"
\fR
.DE
.P 1
Of course, the remote site has to enable call sequence checks as well,
and start by using exactly the same sequence number as you\&.
.P 1
.INDEX {UUCP!call sequence check|)}
.P 1
.INDEX {security!UUCP logins|)}
.INDEX {UUCP!login security|)}
.P 1
.INDEX {server!UUCP|)}
.INDEX {security!UUCP|)}
.INDEX {access!UUCP|)}
.P 1
.H 3 "Anonymous UUCP"
.INDEX {UUCP!anonymous}
.INDEX {anonymous UUCP}
.P 1
If you want to provide anonymous UUCP access to your system, you first
have to set up a special account for it as described above\&.  A common
practive is to give it a login name and a password of \fBuucp\fR\&.
.P 1
In addition, you have to set a few of the security options for unknown
systems\&. For instance, you may want to prohibit them from executing any
commands on your system\&. However, you cannot set these parameters in a
\fIsys\fR file entry, because the \fIsystem\fR command requires the
system's name, which you don't have\&. Taylor UUCP solves this dilemma
through the \fIunknown\fR command\&. \fIunknown\fR can be used in
the \fIconfig\fR file to specify any command that can usually appear in
a system entry:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
unknown         remote-receive ~/incoming
unknown         remote-send ~/pub
unknown         max-remote-debug none
unknown         command-path /usr/lib/uucp/anon-bin
unknown         commands rmail
.ENDVERBATIM
\"
\fR
.DE
.P 1
This will restrict unknown systems to downloading files from below the
\fIpub\fR directory and uploading files to the \fIincoming\fR
directory below \fI/var/spool/uucppublic\fR\&. The next line will make \fIuucico\fR
ignore any requests from the remote system to turn on debugging
locally\&.  The last two lines permit unknown systems to execute
\fIrmail\fR; but the command path specified makes \fIuucico\fR look
for the \fIrmail\fR command in a private directory named
\fIanon-bin\fR only\&. This allows you to provide some special
\fIrmail\fR that, for instance, forwards all mail to the super-user
for examination\&. This allows anonymous users to reach the maintainer
of the system, but prevents them at the same time from injecting any
mail to other sites\&.
.P 1
To enable anonymous UUCP, you must specify at least one \fIunknown\fR
statement in \fIconfig\fR\&. Otherwise \fIuucico\fR will reject any unknown
systems\&.
.P 1
.INDEX {UUCP!configure as server|)}
.P 1
.H 2 "UUCP Low-Level Protocols"
.SETR "uucp.protocols"
.INDEX {UUCP!protocol|(}
.P 1
To negotiate session control and file transfers with the remote end,
\fIuucico\fR uses a set of standardized messages\&. This is often
referred to as the high-level protocol\&. During the initialization phase
and the hangup phase these are simply sent across as strings\&. However,
during the real transfer phase, an additional low-level protocol is
employed which is mostly transparent to the higher levels\&. This is to
make error checks possible when using unreliable lines, for instance\&.
.P 1
.H 3 "Protocol Overview"
.INDEX {protocol!UUCP}
.P 1
As UUCP is used over different types of connections, such as serial
lines or TCP, or even X\&.25, specific low-level protocols are needed\&. In
addition, several implementations of UUCP have introduced different
protocols that do roughly the same thing\&.
.P 1
Protocols can be divided into two categories: streaming and
packet-oriented protocols\&. Protocols of the latter variety transfer a
file as a whole, possibly computing a checksum over it\&. This is nearly
free of any overhead, but requires a reliable connection, because any
error will cause the whole file to be retransmitted\&. These protocols
are commonly used over TCP connections, but are not suitable for use
over telephone lines\&.  Although modern modems do quite a good job at
error correction, they are not perfect, nor is there any error
detection between your computer and the modem\&.
.P 1
On the other hand, packet protocols split up the file into several
chunks of equal size\&. Each packet is sent and received separately, a
checksum is computed, and an acknowledgement is returned to the sender\&.
To make this more efficient, sliding-window protocols were invented,
which allow for a limited number (a window) of outstanding
acknoledgements at any time\&.  This greatly reduces the amount of time
\fIuucico\fR has to wait during a transmission\&.  Still, the relatively
large overhead compared to a streaming protocol make packet protocls
inefficient for use over TCP\&.
.P 1
The width of the data path also makes a difference\&. Sometimes, sending
eight-bit characters over a serial connection is impossible, for
instance if the connection goes through a stupid terminal server\&.  In
this case, characters with the eighth bit set have to be quoted on
transmission\&.  When you transmit eight-bit characters over a seven-bit
connection, they have to be Under worst-case assumptions, this doubles
the amount of data to be transmitted, although compression done by the
hardware may compensate for this\&.  Lines that can transmit arbitrary
eight-bit characters are usually called eight-bit clean\&. This is the
case for all TCP connections, as well as for most modem connections\&.
.P 1
The following protocols are available with Taylor UUCP 1\&.04:
.P 1
\"
.BL 10
.LI "\fIg\fR"
This is the most common protocol and should be understood by
virtually all \fIuucico\fR's\&. It does thorough error checking
and is therefore well-suited for noisy telephone links\&.
\fIg\fR requires an eight-bit clean connection\&.  It is a
packet-oriented protocol which uses a sliding-window
technique\&.
.P 1
.LI "\fIi\fR"
This is a bidirectional packet protocol which can send and
receive files at the same time\&. It requires a full-duplex
connection and an eight-bit clean data path\&. It is currently
understood only by Taylor UUCP\&.
.P 1
.LI "\fIt\fR"
This is a protocol intended for use over a TCP connection, or
other truly error-free networks\&.  It uses packets of 1024 bytes
and requires an eight-bit clean connection\&.
.P 1
.LI "\fIe\fR"
This should basically do the same as \fIt\fR\&. The main
difference is that \fIe\fR is a streaming protocol\&.
.P 1
.LI "\fIf\fR"
This is intended for use with reliable X\&.25 connections\&.  It is
a streaming protocol and expects a seven-bit data path\&.
Eight-bit characters are quoted, which can make it very
inefficient\&.
.P 1
.LI "\fIG\fR"
This is the System V Release 4 version of the \fIg\fR protocol\&.
It is also understood by some other versions of UUCP\&.
.P 1
.LI "\fIa\fR"
This protocol is similiar to ZMODEM\&. It requires an eight bit
connection, but quotes certain control characters like XON and
XOFF\&.
.P 1
\"
.LE
.P 1
.H 3 "Tuning the Transmission Protocol"
.INDEX {UUCP!protocol!tuning}
.P 1
All protocols allow for some variation in packet sizes, timeouts, and
the like\&.  Usually, the defaults provided work well under standard
circumstances, but may not be optimal for your situation\&.  The \fIg\fR
protocol, for instance, uses window sizes from 1 to 7, and packet sizes
in powers of 2 ranging from 64 through 4096\&.(\*F)
.FS
Most binaries included in Linux distributions default to a window
size of 7 and 128 byte packets\&.
.FE
If your telephone line is usually so noisy that it drops more than
5 percent all packets, you should probably lower the packet size and
shrink the window\&.  On the other hand, on very good telephone lines
the protocol overhead of sending ACKs for every 128 bytes may prove
wasteful, so that you might increase the packet size to 512 or even
1024\&.
.P 1
Taylor UUCP provides a meachanism to suit your needs by tuning these
parameters with the \fIprotocol-parameter\fR command in the
\fIsys\fR file\&.  For instance, to set the \fIg\fR protocol's packet
size to 512 when talking to \fBpablo\fR, you have to add:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
system          pablo
...
protocol-parameter g  packet-size  512
.ENDVERBATIM
\"
\fR
.DE
.P 1
The tunable parameters and their names vary from protocol to protocol\&.
For a complete list of them please refer to the documentation enclosed
in the Taylor UUCP source\&.
.P 1
.H 3 "Selecting Specific Protocols"
.INDEX {UUCP!protocol!selection}
.P 1
Not every implementation of \fIuucico\fR speaks and understand each
protocol, so during the initial handshake phase, both processes have to
agree on a common protocol\&.  The master \fIuucico\fR offers the slave a
list of supported protocols by sending \fBP\fB\fIprotlist\fB\fB\fR, from
which the slave may pick one\&.
.P 1
Based on the type of port used (modem, TCP, or direct), \fIuucico\fR will
compose a default list of protocols\&. For modem and direct connections, this
list usually comprises \fIi\fR, \fIa\fR, \fIg\fR, \fIG\fR, and
\fIj\fR\&.  For TCP connections, the list is \fIt\fR, \fIe\fR, \fIi\fR,
\fIa\fR, \fIg\fR, \fIG\fR, \fIj\fR, and \fIf\fR\&. You can override this
default list with the \fIprotocols\fR command, which may be specified
in a system entry as well as a port entry\&. For instance, you might edit the
\fIport\fR file entry for your modem port like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
port            serial1
...
protocols       igG
.ENDVERBATIM
\"
\fR
.DE
.P 1
This will require any incoming or outgoing connection through this port
to use \fIi\fR, \fIg\fR, or \fIG\fR\&. If the remote system does not
support any of these, the conversation will fail\&.
.P 1
.INDEX {UUCP!protocol|)}
.P 1
.H 2 "Troubleshooting"
.SETR "uucp.misc.faq"
.INDEX {UUCP!troubleshooting}
.P 1
This section describes what may go wrong with your UUCP connection, and
makes suggestions where to look for the error\&.  However, the questions
were compiled off the top of my head\&. There's much more that can go
wrong\&.
.P 1
.INDEX {UUCP!checking}
In any case, enable debugging with \fB-xall\fR, and take a look at
the output in \fIDebug\fR in the spool directory\&.  It should help you
to quickly recognize where the problem lies\&.  Also, I have always found
it helpful to turn on my modem's speaker when it didn't connect\&. With
Hayes-compatible modems, this is accomplished by adding ``\fBATL1M1 OK\fR''
to the modem chat in the \fIdial\fR file\&.
.P 1
The first check always should be whether all file permissions are set
correctly\&.  \fIuucico\fR should be setuid \fBuucp\fR, and all files in
\fI/usr/lib/uucp\fR, \fI/var/spool/uucp\fR and \fI/var/spool/uucppublic\fR should be owned by
\fBuucp\fR\&. There are also some hidden files(\*F)
.FS
That is, files whose name begins with a dot\&. Such files aren't
normally displayed by the \fIls\fR command\&.
.FE
in the spool directory which must be owned by \fBuucp\fR as well\&.
.P 1
\fB\fIuucico\fB keeps saying ``Wrong time to call''\fR:
This probably means that in the system entry in \fIsys\fR, you didn't
specify a \fItime\fR command that details when the remote system may
be called, or you gave one which actually forbids calling at the current
time\&. If no call schedule is given, \fIuucico\fR assumes that the
system may never be called\&.
.P 1
\fB\fIuucico\fB complains that the site is already locked\fR:
This means that \fIuucico\fR detected a lock file for the remote
system in \fI/var/spool/uucp\fR\&.  The lock file may be from an earlier call to
the system that crashed, or was killed\&. However, it's also likely that
there's another \fIuucico\fR process sitting around that is trying to
dial the remote system and got stuck in a chat script, etc\&. If this
\fIuucico\fR process doesn't succeed in connecting to the remote
system, kill it with a hangup signal, and remove any lock files it left
lying around\&.
.P 1
\fBI can connect to the remote site, but the chat script fails\fR:
Look at the text you receive from the remote site\&. If it's garbled, this
might be a speed-related problem\&.  Otherwise, confirm if it really
agrees with what your chat script expects\&.  Remember, the chat script
starts with an expect string\&. If you receive the login prompt, then send
your name, but never get the password prompt, insert some delays before
sending it, or even in-between the letters\&. You might be too fast for
your modem\&.
.P 1
\fBMy modem does not dial\fR:
If your modem doesn't indicate that the DTR line has been raised when
\fIuucico\fR calls out, you possibly haven't given the right device to
\fIuucico\fR\&. If your modem recognizes DTR, check with a terminal
program that you can write to it\&. If this works, turn on echoing with
\fI\\E\fR at the start of the modem chat\&. If it doesn't echo your
commands during the modem chat, check if your line speed is too high or
low for your modem\&. If you see the echo, check if you have disabled
modem responses, or set them to number codes\&.  Verify that the chat
script itself is correct\&. Remember that you have to write two
backslashes to send one to the modem\&.
.P 1
\fBMy modem tries to dial, but doesn't get out\fR:
Insert a delay into the phone number\&. This is especially useful when
dialing out from a company's internal telephone net\&.  For people in
Europe, who usually dial pulse-tone, try touch-tone\&.  In some countries,
postal services have been upgrading their nets recently\&. Touch-tone
sometimes helps\&.
.P 1
\fBI log file says I have extremely high packet loss rates\fR:
This looks like a speed problem\&. Maybe the link between computer and
modem is too slow (remember to adapt it to the highest effective rate
possible)? Or is it your hardware that is too slow to service interrupts
in time? With a NSC 16550A chipset on your serial port, 38kbps are said
to work reasonably well; however, without FIFOs (like 16450 chips), 9600
bps is the limit\&. Also, you should make sure hardware handshake is
enabled on the serial line\&.
.P 1
Another likely cause is that hardware handshake isn't enabled on the
port\&.  Taylor UUCP 1\&.04 has no provisions for turning on RTS/CTS
handshake\&.  You have to enable this explicitly from \fIrc\&.serial\fR
using the following command:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ stty crtscts < /dev/cua3
.ENDVERBATIM
\"
\fR
.DE
.P 1
\fBI can log in, but handshake fails\fR:
Well, there can be a number of problems\&. The output in the log file
should tell you a lot\&. Look at what protocols the remote site offers (It
sends a string \fBP\fR\fB\fIprotlist\fB\fR during the handshake)\&.  Maybe they
don't have any in common (did you select any protocols in \fIsys\fR or
\fIport\fR?)\&.
.P 1
If the remote system sends \fBRLCK\fR, there is a stale lockfile for
you on the remote system\&. If it's not because you're already connected
to the remote system on a different line, ask to have it removed\&.
.P 1
If it sends \fBRBADSEQ\fR, the other site has conversation count checks
enabled for you, but numbers didn't match\&. If it sends \fBRLOGIN\fR,
you were not permitted to login under this id\&.
.P 1
.H 2 "Log Files"
.INDEX {UUCP!logging and debugging|(}
.P 1
When compiling the UUCP suite to use Taylor-style logging, you have only
three global log files, all of which reside in the spool directory\&.  The
main log file is named \fILog\fR and contains all information about
connections established and files transferred\&. A typical excerpt looks
like this (after a little reformatting to make it fit the page):
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
uucico pablo - (1994-05-28 17:15:01.66 539) Calling system pablo (port cua3)
uucico pablo - (1994-05-28 17:15:39.25 539) Login successful
uucico pablo - (1994-05-28 17:15:39.90 539) Handshake successful
               (protocol 'g' packet size 1024 window 7)
uucico pablo postmaster (1994-05-28 17:15:43.65 539) Receiving D.pabloB04aj
uucico pablo postmaster (1994-05-28 17:15:46.51 539) Receiving X.pabloX04ai
uucico pablo postmaster (1994-05-28 17:15:48.91 539) Receiving D.pabloB04at
uucico pablo postmaster (1994-05-28 17:15:51.52 539) Receiving X.pabloX04as
uucico pablo postmaster (1994-05-28 17:15:54.01 539) Receiving D.pabloB04c2
uucico pablo postmaster (1994-05-28 17:15:57.17 539) Receiving X.pabloX04c1
uucico pablo - (1994-05-28 17:15:59.05 539) Protocol 'g' packets: sent 15,
                resent 0, received 32
uucico pablo - (1994-05-28 17:16:02.50 539) Call complete (26 seconds)
uuxqt pablo postmaster (1994-05-28 17:16:11.41 546) Executing X.pabloX04ai
               (rmail okir)
uuxqt pablo postmaster (1994-05-28 17:16:13.30 546) Executing X.pabloX04as
               (rmail okir)
uuxqt pablo postmaster (1994-05-28 17:16:13.51 546) Executing X.pabloX04c1
               (rmail okir)
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {UUCP!statistics}
The next important log file is \fIStats\fR, which lists file transfer
statistics\&.  The section of \fIStats\fR corresponding to the above
transfer looks like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
postmaster pablo (1994-05-28 17:15:44.78)
                  received 1714 bytes in 1.802 seconds (951 bytes/sec)
postmaster pablo (1994-05-28 17:15:46.66)
                  received 57 bytes in 0.634 seconds (89 bytes/sec)
postmaster pablo (1994-05-28 17:15:49.91)
                  received 1898 bytes in 1.599 seconds (1186 bytes/sec)
postmaster pablo (1994-05-28 17:15:51.67)
                  received 65 bytes in 0.555 seconds (117 bytes/sec)
postmaster pablo (1994-05-28 17:15:55.71)
                  received 3217 bytes in 2.254 seconds (1427 bytes/sec)
postmaster pablo (1994-05-28 17:15:57.31)
                  received 65 bytes in 0.590 seconds (110 bytes/sec)
.ENDVERBATIM
\"
\fR
.DE
.P 1
Again, the lines have been split to make it fit the page\&.
.P 1
The third file if \fIDebug\fR\&. This is the place where debugging
information is written\&. If you use debugging, you should make sure
that this file has a protection mode of 600\&. Depending on the debug
mode you selected, it may contain the login and password you use to
connect to the remote system\&.
.P 1
.INDEX {UUCP!HDB}
Some UUCP binaries included in Linux distributions have been compiled
to use HDB-style logging\&. HDB UUCP uses a whole bunch of log files
stored below \fI/var/spool/uucp\fR\fI/\&.Log\fR\&. This directory contains three more
directories, named \fIuucico\fR, \fIuuxqt\fR, and \fIuux\fR\&.  They
contain the logging output generated by each of the corresponding
commands, sorted into different files for each site\&. Thus, output from
\fIuucico\fR when calling site \fBpablo\fR will go into
\fI\&.Log/uucico/pablo\fR, while the subsequent \fIuuxqt\fR run will
write to \fI\&.Log/uuxqt/pablo\fR\&. The lines written to the various
lofiles are however the same as with Taylor logging\&.
.P 1
When you enable debugging output with HDB-style logging compiled in, it
will go to the \fI\&.Admin\fR directory below \fI/var/spool/uucp\fR\&. During outgoing
calls, debugging information will be sent to \fI\&.Admin/audit\&.local\fR,
while the output from \fIuucico\fR when someone calls in will go to
\fI\&.Admin/audit\fR\&.
.P 1
.INDEX {UUCP!logging and debugging|)}
.P 1
.INDEX {UUCP|)}
.INDEX {configuring!UUCP|)}
.P 1
.H 1 "Electronic Mail"
.SETR "mail"
.INDEX {electronic mail}
.INDEX {mail}
.INDEX {email|see mail}
.P 1
One of the most prominent uses of networking since the first networks
were devised, has been eletronic mail\&.  It started as a simple service
that copied a file from one machine to another, and appended it to the
recipient's \fImailbox\fR file\&. Basically, this is still what email is
all about, although an ever growing net with its complex routing
requirements and its ever increasing load of messages has made a more
elaborate scheme necessary\&.
.P 1
.INDEX {multi-media mail}
.INDEX {mail!multi-media}
Various standards of mail exchange have been devised\&. Sites on the
Internet adhere to one laid out in RFC 822, augmented by some RFCs that
describe a machine-independent way of transferring special characters,
and the like\&. Much thought has also been given recently to ``multi-media
mail'', which deals with including pictures and sound in mail messages\&.
Another standard, X\&.400, has been defined by CCITT\&.
.P 1
.INDEX {sendmail@\fIsendmail\fR}
.INDEX {Allman, Eric}
Quite a number of mail transport programs have been implemented for
Un*x systems\&. One of the best-known is the University of Berkeley's
\fIsendmail\fR, which is used on a number of platforms\&. The original
author was Eric Allman, who is now actively working on the
\fIsendmail\fR team again\&.  There are two Linux ports of
\fIsendmail-5\&.56c\fR available, one of which will be described in
chapter 
.GETHN "sendmail"
\&\&. The \fIsendmail\fR version currently being
developed is 8\&.6\&.5\&.
.P 1
.INDEX {smail@\fIsmail\fR}
.INDEX {Karr, Ronald S\&.}
.INDEX {Noll, Curt Landon}
The mail agent most commonly used with Linux is \fIsmail-3\&.1\&.28\fR,
written and copyrighted by Curt Landon Noll and Ronald S\&. Karr\&. This is the
one included in most Linux distributions\&.  In the following, we will
refer to it simply as \fIsmail\fR, although there are other versions of it
which are entirely different, and which we don't describe here\&.
.P 1
Compared to \fIsendmail\fR, \fIsmail\fR is rather young\&. When handling
mail for a small site without complicated routing requirements, their
capabilities are pretty close\&. For large sites, however, \fIsendmail\fR
always wins, because its configuration scheme is much more flexible\&.
.P 1
Both \fIsmail\fR and \fIsendmail\fR support a set of configuration
files that have to be customized\&. Apart from the information that is
required to make the mail subsystem run (such as the local hostname),
there are many more parameters that may be tuned\&.  \fIsendmail\fR's
main configuration file is very hard to understand at first\&. It looks as
if your cat had taken a nap on your keyboard with the shift key pressed\&.
\fIsmail\fR configuration files are more structured and easier to
understand than \fIsendmail\fR's, but don't give the user as much power
in tuning the mailer's behavior\&.  However, for small UUCP or Internet
sites the work required in setting up any of them is roughly the same\&.
.P 1
In this chapter, we will deal with what email is and what issues you as
an administrator will have to deal with\&.  Chapters 
.GETHN "smail"
\&
and 
.GETHN "sendmail"
\& will give instructions on setting up \fIsmail\fR and
\fIsendmail\fR for the first time\&.  The information provided there
should suffice to get smaller sites operational, but there are many more
options, and you can spend many happy hours in front of your computer
configuring the fanciest features\&.
.P 1
Toward the end of the current chapter we will briefly cover setting up
\fIelm\fR, a very common mail user agent on many Un*xish systems,
including Linux\&.
.P 1
For more information about issues specific to electronic mail on
Linux, please refer to the Electronic Mail HOWTO by Vince Skahan,
which is posted to \fBcomp\&.os\&.linux\&.announce\fR regularly\&.  The
source distributions of \fIelm\fR, \fIsmail\fR and \fIsendmail\fR
also contain very extensive documentation that should answer most of
your questions on setting them up\&.  If you are looking for information
on email in general, there's a number of RFCs that deal with this
topic\&. They are listed in the bibliography at the end of the book\&.
.P 1
.H 2 "What is a Mail Message?"
.SETR "mail.message-format"
.INDEX {mail!message format}
.INDEX {mail!headers}
.P 1
A Mail message generally consists of a message body, which is the text
the sender wrote, and special data specifying recipients, transport
medium, etc\&., very much like what you see when you look at a letter's
envelope\&.
.P 1
This administrative data falls into two categories; in the first
category is any data that is specific to the transport medium, like
the address of sender and recipient\&. It is therefore called \fIthe
envelope\fR\&.  It may be transformed by the transport software as the
message is passed along\&.
.P 1
The second variety is any data necessary for handling the mail message,
which is not particular to any transport mechanism, such as the
message's subject line, a list of all recipients, and the date the
message was sent\&.  In many networks, it has become standard to prepend
this data to the mail message, forming the so-called \fImail header\fR\&.
It is offset from the \fImail body\fR by an empty line\&.(\*F)
.FS
It is customary to append a \fIsignature\fR or \fI\&.sig\fR to a mail
message, usually containing information on the author, along with a
joke or a motto\&. It is offset from the mail message by a line
containing ``\fB-- \fR''\&.
.FE
.P 1
Most mail transport software in the Un*x world uses a header format
outlined in a RFC 822\&.  Its original purpose was to specify a standard
for use on the ARPANET, but since it was designed to be independent from
any environment, it has been easily adapted to other networks, including
many UUCP-based networks\&.
.P 1
RFC 822 however is only the greatest common denominator\&. More recent
standards have been conceived to cope with growing needs as, for
example, data encryption, international character set support, and
multi-media mail extensions (MIME)\&.
.P 1
In all these standards, the header consists of several lines, separated
by newline characters\&. A line is made up of a field name, beginning in
column one, and the field itself, offset by a colon and white space\&. The
format and semantics of each field vary depending on the field name\&. A
header field may be continued across a newline, if the next line begins
with a TAB\&.  Fields can appear in any order\&.
.P 1
A typical mail header may look like this:
.P 1
.br
.ti 0
.P 1
.DS I F 5
\fB\"
.VERBATIM
From brewhq.swb.de!ora.com!andyo Wed Apr 13 00:17:03 1994
Return-Path: <brewhq.swb.de!ora.com!andyo>
Received: from brewhq.swb.de by monad.swb.de with uucp
        (Smail3.1.28.1 #6) id m0pqqlT-00023aB; Wed, 13 Apr 94 00:17 MET DST
Received: from ora.com (ruby.ora.com) by brewhq.swb.de with smtp
        (Smail3.1.28.1 #28.6) id <m0pqoQr-0008qhC>; Tue, 12 Apr 94 21:47 MEST
Received: by ruby.ora.com (8.6.8/8.6.4) id RAA26438; Tue, 12 Apr 94 15:56 -0400
Date: Tue, 12 Apr 1994 15:56:49 -0400
Message-Id: <199404121956.PAA07787@ruby>
From: andyo@ora.com (Andy Oram)
To: okir@monad.swb.de
Subject: Re: Your RPC section
.ENDVERBATIM
\"
\fR
.DE
.P 1
Usually, all necessary header fields are generated by the mailer
interface you use, like \fIelm\fR, \fIpine\fR, \fImush\fR, or
\fImailx\fR\&. Some however are optional, and may be added by the user\&.
\fIelm\fR, for example, allows you to edit part of the message header\&.
Others are added by the mail transport software\&. A list of common
header fields and their meaning are given below:
.P 1
\"
.BL 10
.LI "\fBFrom:\fR"
This contains the sender's email address, and possibly the
``real name''\&. A complete zoo of formats is used here\&.
.P 1
.LI "\fBTo:\fR"
This is the recipient's email address\&. 
.P 1
.LI "\fBSubject:\fR"
Describes the content of the mail in a few words\&. At least
that's what it \fIshould\fR do\&.
.P 1
.LI "\fBDate:\fR"
The date the mail was sent\&.
.P 1
.LI "\fBReply-To:\fR"
Specifies the address the sender wants the recipient's reply
directed to\&. This may be useful if you have several accounts,
but want to receive the bulk of mail only on the one you use
most frequently\&. This field is optional\&.
.P 1
.LI "\fBOrganization:\fR"
The organization that owns the machine from which the mail
originates\&. If your machine is owned by you privately, either
leave this out, or insert ``private'' or some complete nonsense\&.
This field is optional\&.
.P 1
.LI "\fBMessage-ID:\fR"
A string generated by mail transport on the originating system\&.
It is unique to this message\&.
.P 1
.LI "\fBReceived:\fR"
Every site that processes your mail (including the machines
of sender and recipient) inserts such a field into the header,
giving its site name, a message id, time and date it received
the message, which site it is from, and which transport software
was used\&. This is so that you can trace which route the message
took, and can complain to the person responsible if something
went wrong\&.
.P 1
.LI "\fBX-\fIanything:\fB\fR"
No mail-related programs should complain about any header which
starts with \fBX-\fR\&. It is used to implement additional
features that have not yet made it into an RFC, or never will\&.
This is used by the Linux Activists mailing list, for example,
where the channel is selected by the \fBX-Mn-Key:\fR header
field\&.
.P 1
\"
.LE
.P 1
The one exception to this structure is the very first line\&. It starts
with the keyword \fBFrom\fR which is followed by a blank instead of a
colon\&.  To distinguish it from the ordinary \fBFrom:\fR field, it is
frequently referred to as \fBFrom_\fR\&.  It contains the route the
message has taken in UUCP bang-path style (explained below), time and
date when it was received by the last machine having processed it, and
an optional part specifying which host it was received from\&. Since this
field is regenerated by every system that processes the message, it is
somtimes subsumed under the envelope data\&.
.P 1
The \fBFrom_\fR field is there for backward compatibilty with some
older mailers, but is not used very much anymore, except by
mail user interfaces that rely on it to mark the beginning of a
message in the user's mailbox\&. To avoid potential trouble with lines
in the message body that begin with ``From '', too, it has become
standard procedure to escape any such occurence by preceding it with
``>''\&.
.P 1
.H 2 "How is Mail Delivered?"
.SETR "mail.delivery"
.INDEX {mail!composing}
.INDEX {composing mail}
.INDEX {mail!delivering|(}
.INDEX {delivering!mail|(}
.INDEX {exchanging!mail|(}
.INDEX {lmail@\fIlmail\fR}
.INDEX {rmail@\fIrmail\fR}
.P 1
Generally, you will compose mail using a mailer interface like \fImail\fR
or \fImailx\fR; or more sophisticated ones like \fIelm\fR, \fImush\fR,
or \fIpine\fR\&. These programs are called \fImail user agents\fR, or MUA's
for short\&. If you send a mail message, the interface program will in most
cases hand it to another program for delivery\&. This is called the
\fImail transport agent\fR, or MTA\&. On some systems, there are different
mail transport agents for local and remote delivery; on others, there is
only one\&.  The command for remote delivery is usually called \fIrmail\fR,
the other is called \fIlmail\fR (if it exists)\&.
.P 1
.INDEX {mail!bounce}
.INDEX {bounce mail}
Local delivery of mail is, of course, more than just appending the
incoming message to the recipient's mailxbox\&. Usually, the local MTA
will understand aliasing (setting up local recipient addresses pointing
to other addresses), and forwarding (redirecting a user's mail to some
other destination)\&. Also, messages that cannot be delivered must usually
be \fIbounced\fR, that is, returned to the sender along with some
error message\&.
.P 1
.INDEX {Simple Mail Transfer Protocol|see SMTP}
.INDEX {SMTP}
For remote delivery, the transport software used depends on the nature
of the link\&.  If the mail must be delivered over a network using TCP/IP,
SMTP is commonly used\&.  SMTP stands for Simple Mail Transfer Protocol,
and is defined in RFC 788 and RFC 821\&.  SMTP usually connects to the
recipient's machine directly, negotiating the message transfer with the
remote side's SMTP daemon\&.
.P 1
.INDEX {remote!execution}
.INDEX {UUCP!mail}
.INDEX {mail!over UUCP}
In UUCP networks, mail will usually not be delivered directly, but
rather be forwarded to the destination host by a number of intermediate
systems\&. To send a message over a UUCP link, the sending MTA will
usually execute \fIrmail\fR on the forwarding system using \fIuux\fR,
and feed it the message on standard input\&.
.P 1
.INDEX {BSMTP}
.INDEX {SMTP!batched}
.INDEX {mail!batching}
.INDEX {batching!mail}
.INDEX {rsmtp@\fIrsmtp\fR}
Since this is done for each message separately, it may produce a
considerable work load on a major mail hub, as well as clutter the UUCP
spool queues with hundreds of small files taking up an unproportional
amount of disk space\&.(\*F)
.FS
This is because disk space is usually allocated in blocks of 1024 Bytes\&.
So even a message of at most 400 Bytes will eat a full KB\&.
.FE
Some MTAs therefore allow you to collect several messages for a remote
system in a single batch file\&. The batch file contains the SMTP commands
that the local host would normally issue if a direct SMTP connection was
used\&.  This is called BSMTP, or \fIbatched\fR SMTP\&. The batch is then
fed to the \fIrsmtp\fR or \fIbsmtp\fR program on the remote system,
which will process the input as if a normal SMTP connection had
occurred\&.
.P 1
.INDEX {mail!delivering|)}
.INDEX {exchanging!mail|)}
.INDEX {delivering!mail|)}
.P 1
.H 2 "Email Addresses"
.SETR "mail.address"
.INDEX {mail!address formats|(}
.INDEX {address!mail|(}
.P 1
For electronic mail, an address is made up of at least the name of a
machine handling the person's mail, and a user identification recognized
by this system\&. This may be the recipient's login name, but may also be
anything else\&. Other mail addressing schemes, like X\&.400, use a more
general set of ``attributes'' which are used to look up the recipient's
host in an X\&.500 directory server\&.
.P 1
The way a machine name is interpreted, i\&.e\&. at which site your message
will finally wind up, and how to combine this name with the recipient's
user name greatly depends on the network you are on\&.
.P 1
Internet sites adhere to the RFC 822 standard, which requires a notation
of \fBuser@host\&.domain\fR, where \fBhost\&.domain\fR is the host's fully
qualified domain name\&. The middle thing is called an ``at'' sign\&.
Because this notation does not involve a route to the destination host
but gives the (unique) hostname instead, this is called an \fIabsolute\fR
address\&.
.P 1
.INDEX {mail!bang path address}
.INDEX {address!bang path}
In the original UUCP environment, the prevalent form was
\fBpath!host!user\fR, where \fBpath\fR described a sequence of hosts
the message had to travel before reaching the destination \fBhost\fR\&.
This construct is called the \fIbang path\fR notation, because an
exclamation mark is loosely called a ``bang''\&.  Today, many UUCP-based
networks have adopted RFC 822, and will understand this type of
address\&.
.P 1
.INDEX {address!hybrid}
Now, these two types of addressing don't mix too well\&. Assume an address
of \fBhostA!user@hostB\fR\&. It is not clear whether the `\fB@\fR' sign
takes precedence over the path, or vice versa: do we have to send the
message to \fBhostB\fR, which mails it to \fBhostA!user\fR, or should it
be sent to \fBhostA\fR, which fowards it to \fBuser@hostB\fR?
.P 1
Addresses that mix different types of address operators are called
\fIhybrid addresses\fR\&. Most notorious is the above example\&. It is
usually resolved by giving the `\fB@\fR' sign precedence over the
path\&. In the above example, this means sending the message to
\fBhostB\fR first\&.
.P 1
.INDEX {address!route-addr}
.INDEX {mail!route-addr address}
However, there is a way to specify routes in RFC 822-conformant ways:
\fB<@hostA,@hostB:user@hostC>\fR denotes the address of \fBuser\fR on
\fBhostC\fR, where \fBhostC\fR is to be reached through \fBhostA\fR
and \fBhostB\fR (in that order)\&. This type of address is freqeuently
called a \fIroute-addr address\fR\&.
.P 1
.INDEX {Ye Olde ARPANET kludge}
Then, there is the `\fB%\fR' address operator: \fBuser%hostB@hostA\fR
will first be sent to \fBhostA\fR, which expands the rightmost (in this
case, only) percent sign to an `\fB@\fR' sign\&. The address is now
\fBuser@hostB\fR, and the mailer will happily forward your message to
\fBhostB\fR which delivers it to \fBuser\fR\&.  This type of address is
sometimes referred to as ``Ye Olde ARPANET Kludge'', and its use is
discouraged\&. Nevertheless, many mail transport agents generate this
type of address\&.
.P 1
Other networks have still different means of addressing\&. DECnet-based
networks, for example, use two colons as an address separator, yielding
an address of \fB\fIhost\fB\fR\fB::\fR\fB\fIuser\fB\fR\&.(\*F)
.FS
When trying to reach a DECnet address from an RFC 822 environment, you
may use \fB"\fB\fIhost\fB\fB::\fB\fIuser\fB\fB"@\fB\fIrelay\fB\fB\fR, where \fB\fIrelay\fB\fR
is the name of a known Internet-DECnet relay\&.
.FE
Lastly, the X\&.400 standard uses an entirely different scheme, by
describing a recipient by a set of attribute-value pairs, like country
and organization\&.  
.P 1
On FidoNet, each user is identified by a code like \fB2:320/204\&.9\fR,
consisting of four numbers denoting zone (2 is for Europe), net (320
being Paris and Banlieue), node (the local hub), and point (the
individual user's PC)\&. Fidonet addresses can be mapped to RFC 822; the
above would be written as
\fBThomas\&.Quinot@p9\&.f204\&.n320\&.z2\&.fidonet\&.org\fR\&. Now didn't I say
domain names are easy to remember?
.P 1
There are some implications to using these different types of addressing
which will be described throughout the following sections\&. In a RFC 822
environment, however, you will rarely use anything else than absolute
addresses like \fB\fB\fIuser\fB\fB@\fB\fIhost\fB\fB\&.\fB\fIdomain\fB\fB\fR\&.
.P 1
.INDEX {mail!address formats|)}
.INDEX {address!mail|)}
.P 1
.H 2 "How does Mail Routing Work?"
.SETR "mail.routing"
.INDEX {mail!routing|(}
.INDEX {routing!mail|see mail routing}
.P 1
The process of directing a message to the recipient's host is called
\fIrouting\fR\&. Apart from finding a path from the sending site to the
destination, it involves error checking as well as speed and cost
optimization\&.
.P 1
There is a big difference between the way a UUCP site handles routing,
and the way an Internet site does\&. On the Internet, the main job of
directing data to the recipient host (once it is known by it's
IP address) is done by the IP networking layer, while in the UUCP zone,
the route has to be supplied by the user, or generated by the mail
transfer agent\&.
.P 1
.H 3 "Mail Routing on the Internet"
.SETR "mail.routing.internet"
.INDEX {mail!routing!Internet}
.INDEX {mail!domain-based routing}
.INDEX {mail!centralizing}
.INDEX {centralized mail handling}
.INDEX {Internet!mail routing}
.INDEX {Mail Exchanger (DNS record)}
.INDEX {MX (DNS record)}
.INDEX {mail!gateway}
.INDEX {gateway!mail}
.P 1
On the Internet, it depends entirely on the destination host whether any
specific mail routing is performed at all\&. The default is to deliver the
message to the destination host directly by looking up its IP address,
and leave the actual routing of the data to the IP transport layer\&.
.P 1
.INDEX {mail!routing!between Internet and UUCP}
Most sites will usually want to direct all inbound mail to a highly
available mail server that is capable of handling all this traffic, and
have it distribute this mail locally\&. To announce this service, the site
publishes a so-called MX record for their local domain in the DNS
database\&.  MX stands for \fIMail Exchanger\fR and basically states
that the server host is willing to act as a mail forwarder for all
machines in this domain\&.  MX records may also be used to handle traffic
for hosts that are not connected to the Internet themselves, like UUCP
networks, or company networks with hosts carrying confidential
information\&.
.P 1
MX records also have a \fIpreference\fR associated with them\&.  This is
a positive integer\&. If several mail exchangers exist for one host, the
mail transport agent will try to transfer the message to the exchanger
with the lowest preference value, and only if this fails will it try a
host with a higher value\&. If the local host is itself a mail exchanger
for the destination address, it must not forward messages to any MX
hosts with a higher preference than its own; this is a safe way of
avoiding mail loops\&.
.P 1
Suppose that an organization, say Foobar Inc\&., want all their mail
handled by their machine called \fBmailhub\fR\&.  They will then have an
MX record like this in the DNS database:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
foobar.com        IN   MX      5    mailhub.foobar.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
This announces \fBmailhub\&.foobar\&.com\fR as a mail exchanger for
\fBfoobar\&.com\fR with a preference value of 5\&. A host that wishes to
deliver a message to \fBjoe@greenhouse\&.foobar\&.com\fR will check DNS for
\fBfoobar\&.com\fR, and finds the MX record pointing at \fBmailhub\fR\&.
If there's no MX with a preference smaller than 5, the message will be
delivered to \fBmailhub\fR, which then dispatches it to
\fBgreenhouse\fR\&.
.P 1
The above is really only a sketch of how MX records work\&.  For more
information on the mail routing on the Internet, please refer to
RFC 974\&.
.P 1
.H 3 "Mail Routing in the UUCP World"
.SETR "mail.routing.uucp"
.INDEX {mail!routing!UUCP networks}
.INDEX {mail!bang path address}
.INDEX {address!bang path}
.INDEX {UUCP!mail}
.P 1
Mail routing on UUCP networks is much more complicated than on the
Internet, because the transport software does not perform any routing
itself\&.  In earlier times, all mail had to be addressed using bang paths\&.
Bang paths specified a list of hosts through which to forward the
message, separated by exclamation marks, and followed by the user's
name\&.  To address a letter to Janet User on a machine named \fBmoria\fR,
you would have used the path \fBeek!swim!moria!janet\fR\&. Whis would
have sent the mail from your host to \fBeek\fR, from there on to
\fBswim\fR and finally to \fBmoria\fR\&.
.P 1
The obvious drawback of this technique is that it requires you to
remember much about the network topology, fast links, etc\&.  Much worse
than that, changes in the network topology --- like links being deleted
or hosts being removed --- may cause messages to fail simply because you
weren't aware of the change\&. And finally, in case you move to a
different place, you will most likely have to update all these routes\&.
.P 1
.INDEX {hostname!ambiguous}
One thing, however, that made the use of source routing necessary was
the presence of ambiguous hostnames: For instance, assume there are two
sites named \fBmoria\fR, one in the U\&.S\&., and one in France\&. Which site
now does \fBmoria!janet\fR refer to? This can be made clear by
specifying what path to reach \fBmoria\fR through\&.
.P 1
.INDEX {UUCP!Mapping Project}
.INDEX {mail!maps}
.INDEX {Usenet!maps}
.INDEX {maps, Usenet}
The first step in disambiguating hostnames was the founding of
\fIThe UUCP Mapping Project\fR\&. It is located at Rutgers University, and
registers all official UUCP hostnames, along with information on their
UUCP neighbors and their geographic location, making sure no hostname is
used twice\&. The information gathered by the Mapping Project is published
as the \fIUsenet Maps\fR, which are distributed regularly through
Usenet\&.(\*F)
.FS
Maps for sites registered with The UUCP Mapping Project are distributed
through the newsgroup \fBcomp\&.mail\&.maps\fR; other organizations may
publish separate maps for their network\&.
.FE
A typical system entry in a Map (after removing the comments) looks
like this\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
moria
        bert(DAILY/2),
        swim(WEEKLY)
.ENDVERBATIM
\"
\fR
.DE
.P 1
This entry says that \fBmoria\fR has a link to \fBbert\fR, which it
calls twice a day, and \fBswim\fR, which it calls weekly\&. We will
come back to the Map file format in more detail below\&.
.P 1
.INDEX {mail!paths file@\fIpaths\fR file}
.INDEX {pathalias@\fIpathalias\fR}
.INDEX {paths file@\fIpaths\fR file}
Using the connectivity information provided in the maps, you can
automatically generate the full paths from your host to any destination
site\&. This information is usually stored in the \fIpaths\fR file,
also called \fIpathalias database\fR sometimes\&.  Assume the Maps
state that you can reach \fBbert\fR through \fBernie\fR, then a
pathalias entry for \fBmoria\fR generated from the Map snippet above
may look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
moria           ernie!bert!moria!%s
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you now give a destination address of \fBjanet@moria\&.uucp\fR,
your MTA will pick the route shown above, and send the message to
\fBernie\fR with an envelope address of \fBbert!moria!janet\fR\&.
.P 1
.INDEX {mail!routing!smart-host}
.INDEX {mail!default route}
.INDEX {default mail route}
.INDEX {smart-host routing}
.INDEX {routing!smart-host}
.INDEX {leaf site}
.INDEX {site!leaf}
Building a \fIpaths\fR file from the full Usenet maps is however not
a very good idea\&. The information provided in them is usually rather
distorted, and occasionally out of date\&.  Therefore, only a number of
major hosts use the complete UUCP world maps to build their
\fIpaths\fR file\&.  Most sites only maintain routing information for
sites in their neighborhood, and send any mail to sites they don't
find in their databases to a smarter host with more complete routing
information\&. This scheme is called \fIsmart-host routing\fR\&.  Hosts
that have only one UUCP mail link (so-called \fIleaf sites\fR) don't
do any routing of their own; they rely entirely on their smart-host\&.
.P 1
.H 3 "Mixing UUCP and RFC 822"
.INDEX {mail!centralizing}
.INDEX {centralized mail handling}
.INDEX {mail!routing!domain-based}
.INDEX {domain!mail routing}
The best cure against the problems of mail routing in UUCP networks so
far is the adoption of the domain name system in UUCP networks\&. Of
course, you can't query a name server over UUCP\&. Nevertheless, many
UUCP sites have formed small domains that coordinate their routing
internally\&. In the Maps, these domains announce one or two host as
their mail gateways, so that there doesn't have to be a map entry for
each host in the domain\&. The gateways handle all mail that flows into
and out of the domain\&. The routing scheme inside the domain is completely
invisible to the outside world\&.
.P 1
This works very well with the smart-host routing scheme described
above\&.  Global routing information is maintained by the gateways only;
minor hosts within a domain will get along with only a small
hand-written \fIpaths\fR file that lists the routes inside their
domain, and the route to the mail hub\&.  Even the mail gateways
do not have to have routing information for every single UUCP host in
the world anymore\&.  Beside the complete routing information for the
domain they serve, they only need to have routes to entire domains in
their databases now\&. For instance, the pathalias entry shown below
will route all mail for sites in the \fBsub\&.org\fR domain to
\fBsmurf\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 .sub.org        swim!smurf!%s
.ENDVERBATIM
\"
\fR
.DE
.P 1
Any mail addressed to \fBclaire@jones\&.sub\&.org\fR will be sent to
\fBswim\fR with an envelope address of \fBsmurf!jones!claire\fR\&.
.P 1
The hierarchical organization of the domain name space allows mail
servers to mix more specific routes with less specific ones\&. For
instance, a system in France may have specific routes for subdomains
of \fBfr\fR, but route any mail for hosts in the \fBus\fR domain
toward some system in the U\&.S\&.  In this way, domain-based routing (as
this technique is called) greatly reduces the size of routing datbases
as well as te administrative overhead needed\&.
.P 1
The main benefit of using domain names in a UUCP environment, however,
is that compliance with RFC 822 permits easy gatewaying between UUCP
networks and the Internet\&.  Many UUCP domains nowadays have a link
with an Internet gateway that acts as their smart-host\&.  Sending
messages across the Internet is faster, and routing information is
much more reliable because Internet hosts can use DNS instead of the
Usenet Maps\&.
.P 1
In order to be reachable from the Internet, UUCP-based domains usually
have their Internet gateway announce an MX record for them (MX records
were described above)\&. For instance, assume that \fBmoria\fR belongs
to the \fBorcnet\&.org\fR domain\&.  \fBgcc2\&.groucho\&.edu\fR acts as
their Internet gateway\&. \fBmoria\fR would therefore use \fBgcc2\fR
as its smart-host, so that all mail for foreign domains is delivered
across the Internet\&.  On the other hand, \fBgcc2\fR would announce an
MX record for \fBorcnet\&.org\fR, and deliver all incoming mail for
\fBorcnet\fR sites to \fBmoria\fR\&.
.P 1
The only remaining problem is that the UUCP transport programs can't
deal with fully qualified domain names\&.  Most UUCP suites were
designed to cope with site names of up to eight characters, some even
less, and using non-alphanumeric characters such as dots is completely
out of the question for most\&.
.P 1
Therefore, some mapping between RFC 822 names and UUCP hostnames is
needed\&.  The way this mapping is done is completely
implementation-dependent\&. One common way of mapping FQDNs to UUCP
names is to use the pathalias file for this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
moria.orcnet.org  ernie!bert!moria!%s
.ENDVERBATIM
\"
\fR
.DE
.P 1
This will produce a pure UUCP-style bang path from an address that
specifies a fully qualified domain name\&. Some mailers provide a
special files for this; \fIsendmail\fR, for instance, uses the
\fIuucpxtable\fR for this\&.
.P 1
The reverse transformation (colloquially called domainizing)  is
sometimes required when sending mail from a UUCP network to the
Internet\&.  As long as the mail sender uses the fully qualified domain
name in the destination address, this problem can be avoided by not
removing the domain name from the envelope address when forwarding the
message to the smart-host\&. However, there are still some UUCP sites
that are not part of any domain\&.  They are usually domainized by
appending the pseudo-domain \fBuucp\fR\&.
.P 1
.INDEX {mail!routing|)}
.P 1
.H 2 "Pathalias and Map File Format"
.SETR "mail.pathalias"
.SETR "mail.maps"
.INDEX {mail!paths file@\fIpaths\fR file|(}
.INDEX {paths file@\fIpaths\fR file|(}
.INDEX {generating a paths file@generating a \fIpaths\fR file}
.P 1
The pathalias database provides the main routing information in
UUCP-based networks\&. A typical entry looks like this (site name
and path are separated by TABs):
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
moria.orcnet.org  ernie!bert!moria!%s
moria             ernie!bert!moria!%s
.ENDVERBATIM
\"
\fR
.DE
.P 1
This makes any message to \fBmoria\fR be delivered via \fBernie\fR
and \fBbert\fR\&. Both \fBmoria\fR's fully qualified name and its UUCP
name have to be given if the mailer does not have a separate way to
map between these name spaces\&.
.P 1
.INDEX {mail!centralizing}
.INDEX {centralized mail handling}
.INDEX {mail!domain-based routing}
If you want to direct all messages to hosts inside some domain to its
mail relay, you may also specify a path in the pathalias database,
giving the domain name as target, preceded by a dot\&. For example, if
all hosts in the \fBsub\&.org\fR may be reached through
\fBswim!smurf\fR, the pathalias entry might look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
\&.sub.org        swim!smurf!%s
.ENDVERBATIM
\"
\fR
.DE
.P 1
Writing a pathalias file is acceptable only when you are running a site
that does not have to do much routing\&.  If you have to do routing for a
large number of hosts, a better way is to use the \fIpathalias\fR command
to create the file from map files\&.  Maps can be maintained much easier,
because you may simply add or remove a system by editing the system's map
entry, and re-create the map file\&.  Although the maps published by the
Usenet Mapping Project aren't used for routing very much anymore, smaller
UUCP networks may provide routing information in their own set of maps\&.
.P 1
.INDEX {mail!maps}
.INDEX {Usenet!maps}
.INDEX {UUCP!maps}
.INDEX {maps, Usenet}
A map file mainly consists of a list of sites, listing the sites
each system polls or is polled by\&.  The system name begins in column
one, and is followed by a comma-separated list of links\&. The list may
be continued across newlines if the next line begins with a tab\&.  Each
link consists of the name of the site, followed by a cost given in
brackets\&. The cost is an arithmetic expression, made up of numbers and
symbolic costs\&. Lines beginning with a hash sign are
ignored\&.
.P 1
As an example, consider \fBmoria\fR, which polls \fBswim\&.twobirds\&.com\fR
twice a day, and \fBbert\&.sesame\&.com\fR once per week\&. Moreover, the link
to \fBbert\fR only uses a slow 2400bps modem\&.  \fBmoria\fR's would publish
the following maps entry:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
moria.orcnet.org
        bert.sesame.com(DAILY/2),
        swim.twobirds.com(WEEKLY+LOW)

moria.orcnet.org = moria
.ENDVERBATIM
\"
\fR
.DE
.P 1
The last line would make it known under its UUCP name, too\&.  Note that
it must be \fIDAILY/2\fR, because calling twice a day actually
halves the cost for this link\&.
.P 1
Using the information from such map files, \fIpathalias\fR is able to
calculate optimal routes to any destination site listed in the paths
file, and produce a pathalias database from this which can then be used
for routing to these sites\&.
.P 1
.INDEX {pathalias@\fIpathalias\fR|(}
\fIpathalias\fR provides a couple of other features like site-hiding
(i\&.e\&. making sites accessible only through a gateway) etc\&. See the
manual page for \fIpathalias\fR for details, as well as a complete list
of link costs\&.
.P 1
Comments in the map file generally contain additional information on
the sites described in it\&. There is a rigid format in which to specify
this, so that it can be retrieved from the maps\&.  For instance, a
program called \fIuuwho\fR uses a database created from the map files
to display this information in a nicely formatted way\&.
.P 1
When you register your site with an organization that distributes map files
to its members, you generally have to fill out such a map entry\&.
.P 1
Below is a sample map entry (in fact, it's the one for my site):
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#N      monad, monad.swb.de, monad.swb.sub.org
#S      AT 486DX50; Linux 0.99
#O      private
#C      Olaf Kirch
#E      okir@monad.swb.de
#P      Kattreinstr. 38, D-64295 Darmstadt, FRG
#L      49 52 03 N / 08 38 40 E
#U      brewhq
#W      okir@monad.swb.de (Olaf Kirch); Sun Jul 25 16:59:32 MET DST 1993
#
monad   brewhq(DAILY/2)
# Domains
monad = monad.swb.de
monad = monad.swb.sub.org
.ENDVERBATIM
\"
\fR
.DE
.P 1
The white space after the first two characters is a TAB\&.  The meaning of
most of the fields is pretty obvious; you will receive a detailed
description from whichever domain you register with\&.  The \fIL\fR
field is the most fun to find out: it gives your geographical position
in latitude/longitude and is used to draw the postscript maps that show
all sites for each country, as well as world-wide\&.(\*F)
.FS
They are posted regularly in \fBnews\&.lists\&.ps-maps\fR\&. Beware\&. They're
HUGE\&.
.FE
.P 1
.INDEX {mail!paths file@\fIpaths\fR file|)}
.INDEX {pathalias@\fIpathalias\fR|)}
.INDEX {paths file@\fIpaths\fR file|)}
.P 1
.H 2 "Configuring elm"
.SETR "mail.elm"
.INDEX {configuring!elm@\fIelm\fR|(}
.INDEX {elm@\fIelm\fR|(}
.P 1
\fIelm\fR stands for ``electronic mail'' and is one of the more reasonably
named Un*x tools\&. It provides a full-screen interface with a good help
feature\&. We won't discuss here how to use \fIelm\fR, but only dwell on its
configuration options\&.
.P 1
Theoretically, you can run \fIelm\fR unconfigured, and everything works
well --- if you are lucky\&. But there are a few options that must be set,
although only required on occasions\&.
.P 1
When it starts, \fIelm\fR reads a set of configuration variables from the
\fIelm\&.rc\fR file in \fI/usr/lib/elm\fR\&. Then, it will attempt to read the file
\fI\&.elm/elmrc\fR in your home directory\&. You don't usually write this file
yourself\&. It is created when you choose ``save options'' from \fIelm\fR's
options menu\&.
.P 1
The set of options for the private \fIelmrc\fR file is also available
in the global \fIelm\&.rc\fR file\&. Most settings in your private
\fIelmrc\fR file override those of the global file\&.
.P 1
.H 3 "Global elm Options"
.SETR "mail.elm.global"
.P 1
In the global \fIelm\&.rc\fR file, you must set the options that pertain
to your host's name\&. For example, at the Virtual Brewery, the file
for \fBvlager\fR would contain the following:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# The local hostname
hostname = vlager
#
# Domain name
hostdomain = .vbrew.com
#
# Fully qualified domain name
hostfullname = vlager.vbrew.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
These options set \fIelm\fR's idea of the local hostname\&. Although this
information is rarely used, you should set these options nevertheless\&.
Note that these options only take effect when giving them in the global
configuration file; when found in your private \fIelmrc\fR, they will
be ignored\&.
.P 1
.H 3 "National Character Sets"
.SETR "mail.elm.charsets"
.INDEX {elm@\fIelm\fR!national character sets}
.INDEX {internationalization for \fIelm\fR}
.INDEX {national character sets in \fIelm\fR}
.INDEX {character set in \fIelm\fR}
.INDEX {ISO-8859-1}
.INDEX {Latin-1 character set}
.P 1
Recently, there have been proposals to amend the RFC 822 standard to
support various types of messages, such as plain text, binary data,
Postscript files, etc\&. The set of standards and RFCs covering these
aspects are commonly referred to as MIME, or Multipurpose Internet Mail
Extensions\&.  Among other things, this also lets the recipient know if a
character set other than standard ASCII has been used when writing the
message, for example using French accents, or German umlauts\&.  This is
supported by \fIelm\fR to some extent\&.
.P 1
The character set used by Linux internally to represent characters is
usually referred to as ISO-8859-1, which is the name of the standard it
conforms to\&. It is also known as Latin-1\&.  Any message using characters
from this character set should have the following line in its header:
.P 1
.P 1
.DS I F 5
\fBContent-Type: text/plain; charset=iso-8859-1
\"
\fR
.DE
.P 1
The receiving system should recognize this field and take appropriate
measures when displaying the message\&. The default for
\fItext/plain\fR messages is a \fIcharset\fR value of
\fIus-ascii\fR\&.
.P 1
To be able to display messages with character sets other than ASCII,
\fIelm\fR must know how to print these characters\&. By default, when
\fIelm\fR receives a message with a \fIcharset\fR field other than
\fIus-ascii\fR (or a content type other than \fItext/plain\fR,
for that matter), it tries to display the message using a command called
\fImetamail\fR\&. Messages that require \fImetamail\fR to be displayed
are shown with an `\fBM\fR' in the very first column in the overview
screen\&.
.P 1
.INDEX {metamail@\fImetamail\fR}
Since Linux' native character set is ISO-8859-1, calling
\fImetamail\fR is not necessary to display messages using this
character set\&. If \fIelm\fR is told that the display understands
ISO-8859-1, it will not use \fImetamail\fR but will display the message
directly instead\&. This can be done by setting the following option in
the global \fIelm\&.rc\fR:
.P 1
.P 1
.DS I F 5
\fBdisplaycharset = iso-8859-1
\"
\fR
.DE
.P 1
Note that you should set this options even when you are never going to
send or receive any messages that actually contain characters other than
ASCII\&. This is because people who do send such messages usually
configure their mailer to put the proper \fBContent-Type:\fR field into
the mail header by default, whether or not they are sending ASCII-only
messages\&.
.P 1
However, setting this option in \fIelm\&.rc\fR is not enough\&.  The
problem is that when displaying the message with its builtin pager,
\fIelm\fR calls a library function for each character to determine
whether it is printable or not\&. By default, this function will only
recognize ASCII characters as printable, and display all other
characters as ``\fB^?\fR''\&.  You may overcome this by setting the
environment variable \fILC_CTYPE\fR to \fIISO-8859-1\fR, which
tells the library to accept Latin-1 characters as printable\&. Support for
this and other features is available since \fIlibc-4\&.5\&.8\fR\&.
.P 1
When sending messages that contain special characters from ISO-8859-1,
you should make sure to set two more variables in the \fIelm\&.rc\fR
file:
.P 1
.P 1
.DS I F 5
\fBcharset = iso-8859-1	
.br
textencoding = 8bit
\"
\fR
.DE
.P 1
This makes \fIelm\fR report the character set as ISO-8859-1 in the mail
header, and send it as an 8 bit value (the default is to strip all
characters to 7 bit)\&.
.P 1
Of course, any of these options can also be set in the private
\fIelmrc\fR file instead of the global one\&.
.P 1
.INDEX {elm@\fIelm\fR|)}
.INDEX {configuring!elm@\fIelm\fR|)}
.P 1
.H 1 "Getting smail Up and Running"
.SETR "smail"
.INDEX {configuring!smail@\fIsmail\fR|see \fIsmail\fR}
.INDEX {smail@\fIsmail\fR|(}
.P 1
This chapter will give you a quick introduction to setting up \fIsmail\fR,
and an overview of the functionality it provides\&. Although \fIsmail\fR
is largely compatible with \fIsendmail\fR in its behaviour, their
configuration files are completely different\&.
.P 1
.INDEX {smail@\fIsmail\fR!config file@\fIconfig\fR file}
The main configuration file is the \fI/usr/lib/smail\fR\fI/config\fR\&.  You always
have to edit this file to reflect values specific to your site\&. If you
are only a UUCP leaf site, you will have relatively little else to do,
ever\&.  Other files that configure routing and transport options may also
be used; they will be dealt with briefly, too\&.
.P 1
.INDEX {mail!queue}
By default, \fIsmail\fR processes and delivers all incoming mail
immediately\&. If you have relatively high traffic, you may instead have
\fIsmail\fR collect all messages in the so-called \fIqueue\fR, and
process it at regular intervals only\&.
.P 1
.INDEX {mail!daemon}
When handling mail within a TCP/IP network, \fIsmail\fR is frequently
run in daemon mode: at system boot time, it is invoked from
\fIrc\&.inet2\fR, and puts itself in the background where it waits for
incoming TCP connections on the SMTP port (usually port 25)\&.  This is
very beneficial whenever you expect to have a significant amount of
traffic, because \fIsmail\fR isn't started up separately for every
incoming connection\&. The alternative would be to have \fIinetd\fR
manage the SMTP port, and have it spawn \fIsmail\fR whenever there is a
connection on this port\&.
.P 1
.INDEX {smail@\fIsmail\fR!utilities}
\fIsmail\fR has a lot a flags that control it behavior; describing
them in detail here wouldn't make help you much\&. Fortunately,
\fIsmail\fR supports a number of standard modes of operation that are
enabled when you invoke it by a special command name, like \fIrmail\fR,
or \fIsmtpd\fR\&.  Usually, these aliases are symbolic links to the
\fIsmail\fR binary itself\&. We will encounter most of them when
discussing the various features of \fIsmail\fR\&.
.P 1
There are two links to \fIsmail\fR you should have under all
circumstances; namely \fI/usr/bin/rmail\fR and
\fI/usr/sbin/sendmail\fR\&.(\*F)
.FS
This is the new standard location of \fIsendmail\fR according to the
Linux File System Standard\&. Another common location is \fI/usr/lib\fR\&.
.FE
When you compose and send a mail message with a user agent like
\fIelm\fR, the message will be piped into \fIrmail\fR for delivery,
with the recipient list given to it on the command line\&. The same
happens with mail coming in via UUCP\&. Some versions of \fIelm\fR,
however, invoke \fI/usr/sbin/sendmail\fR instead of \fIrmail\fR, so you
need both of them\&.  For example, if you keep \fIsmail\fR in
\fI/usr/local/bin\fR, type the following at the shell prompt:
.P 1
.P 1
.DS I F 5
\fB# ln -s /usr/local/bin/smail /usr/bin/rmail    
.br
# ln -s /usr/local/bin/smail /usr/sbin/sendmail
\"
\fR
.DE
.P 1
If you want to dig further into the details of configuring \fIsmail\fR,
please refer to the manual pages \fIsmail(1)\fR and  \fIsmail(5)\fR\&.
If it isn't included in your favorite Linux distribution, you can get
it from the source to \fIsmail\fR\&.
.P 1
.H 2 "UUCP Setup"
.SETR "smail.simple"
.INDEX {smail@\fIsmail\fR!UUCP|(}
.INDEX {smail@\fIsmail\fR!BSMTP}
.INDEX {UUCP!using smail@using \fIsmail\fR}
.INDEX {configuring!UUCP mail}
.P 1
To use \fIsmail\fR in a UUCP-only environment, the basic installation
is rather simple\&. First, you must make sure you have the two symbolic
links to \fIrmail\fR and \fIsendmail\fR mentioned above\&. If you expect
to receive SMTP batches from other sites, you also have to make
\fIrsmtp\fR a link to \fIsmail\fR\&.
.P 1
.INDEX {smail@\fIsmail\fR!config file@\fIconfig\fR file|(}
In Vince Skahan's \fIsmail\fR distribution, you will find a sample
configuration file\&. It is named \fIconfig\&.sample\fR and resides in
\fI/usr/lib/smail\fR\&. You have to copy it to \fIconfig\fR and edit it to reflect
values specific to your site\&.
.P 1
Assume your site is named \fIswim\&.twobirds\&.com\fR, and is registered
in the UUCP maps as \fIswim\fR\&. Your smarthost is \fIulysses\fR\&.
Then your \fIconfig\fR file should look like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# Our domain names
visible_domain=two.birds:uucp
#
# Our name on outgoing mails
visible_name=swim.twobirds.com
#
# Use this as uucp-name as well
uucp_name=swim.twobirds.com
#
# Our smarthost
smart_host=ulysses
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {smail@\fIsmail\fR!local hostnames}
The first statement tells \fIsmail\fR about the domains your site
belongs to\&.  Insert their names here, separated by colons\&. If your site
name is registered in the UUCP maps, you should also add \fIuucp\fR\&.
When being handed a mail message, \fIsmail\fR determines your host's
name using the \fIhostname(2)\fR system call, and checks the
recipient's address against this hostname, tacking on all names from
this list in turn\&. If the address matches any of these names, or
the unqualified hostname, the recipient is considered local, and
\fIsmail\fR attempts to deliver the message to a user or alias on the
local host\&. Otherwise, the recipient is considered remote, and delivery
to the destination host is attempted\&.
.P 1
\fIvisible_name\fR should contain a single, fully qualified domain name
of your site that you want to use on outgoing mails\&. This name is used
when generating the sender's address on all outgoing mail\&.  You must
make sure to use a name that \fIsmail\fR recognizes as referring to the
local host (i\&.e\&. the hostname with one of the domains listed in the
\fIvisible_domain\fR attribute)\&. Otherwise, replies to your mails
will bounce off your site\&.
.P 1
.INDEX {smail@\fIsmail\fR!routing!smart-host}
The last statement sets the path used for smart-host routing (described
in section 
.GETHN "mail.routing"
\&)\&. With this sample setup, \fIsmail\fR
will forward any mail for remote addresses to the smart host\&. The path
specified in the \fIsmart_path\fR attribute will be used as a route
to the smart host\&.  Since messages will be delivered via UUCP, the
attribute must specify a system known to your UUCP software\&. Please
refer to chapter 
.GETHN "uucp"
\& on making a site known to UUCP\&.
.P 1
There's one option used in the above file that we haven't explained yet;
this is \fIuucp_name\fR\&. The reason to use the option is this: By
default, \fIsmail\fR uses the value returned by \fIhostname(2)\fR
for UUCP-specific things such as the return path given in the
\fIFrom_\fR header line\&. If your hostname is \fInot\fR registered
with the UUCP mapping project, you should tell \fIsmail\fR to use your
fully qualified domain name instead\&.(\*F)
.FS
The reason is this: Assume your hostname is \fImonad\fR, but is not
registered in the maps\&. However, there is a site in the maps called
\fImonad\fR, so every mail to \fImonad!root\fR, even sent from
a direct UUCP neighbor of yours, will wind up on the other
\fImonad\fR\&. This is a nuisance for everybody\&.
.FE
This can be done by adding the \fIuucp_name\fR option to the
\fIconfig\fR file\&.
.P 1
There is another file in \fI/usr/lib/smail\fR, called \fIpaths\&.sample\fR\&. It
is an example of what a \fIpaths\fR file might look like\&. However, you
will not need one unless you have mail links to more than one site\&.
If you do, however, you will have to write one yourself, or generate one
from the Usenet maps\&. The \fIpaths\fR file will be described later in
this chapter\&.
.P 1
.INDEX {smail@\fIsmail\fR!config file@\fIconfig\fR file|)}
.INDEX {smail@\fIsmail\fR!UUCP|)}
.P 1
.H 2 "Setup for a LAN"
.SETR "smail.lan"
.INDEX {configuring!mail on a LAN|(}
.INDEX {smail@\fIsmail\fR!on a LAN|(}
.P 1
If you are running a site with two or more hosts connected by a LAN, you
will have to designate one host that handles your UUCP connection with
the outside world\&. Between the hosts on your LAN, you will most probably
want to exchange mail with SMTP over TCP/IP\&.  Assume we're back at the
Virtual Brewery again, and \fBvstout\fR is set up as the UUCP gateway\&.
.P 1
.INDEX {mailboxes!mounting via NFS}
.INDEX {mail!site hiding}
.INDEX {mail!on a LAN}
.INDEX {LAN!mail}
In a networked environment, it is best to keep all user mailboxes on a
single file system, which is NFS-mounted on all other hosts\&. This allows
users to move from machine to machine, without having to move their mail
around (or even worse, check some three or four machines for
newly-arrived mail each morning)\&. Therefore, you also want to make
sender addresses independent from the machine the mail was written on\&.
It is common practice to use the domain name all by itself in the sender
address, instead of a hostname\&.  Janet User, for example, would specify
\fBjanet@vbrew\&.com\fR instead of \fBjanet@vale\&.vbrew\&.com\fR\&.  We
will explain below how to make the server recognize the domain name as a
valid name for your site\&.
.P 1
.INDEX {Interactive Mail Access Protocol}
.INDEX {Post Office Protocol}
.INDEX {IMAP}
.INDEX {POP}
A different way of keeping all mailboxes on a central host is to use
POP or IMAP\&.  POP stands for \fIPost Office Protocol\fR and lets
users access their mailboxes over a simple TCP/IP conection\&.  IMAP,
the \fIInteractive Mail Access Protocol\fR, is similar to POP, but
more general\&. Both clients and servers for IMAP and POP have been
ported to Linux, and are available from \fBsunsite\&.unc\&.edu\fR below
\fI/pub/Linux/system/Network\fR\&.
.P 1
.H 3 "Writing the Configuration Files"
.INDEX {smail@\fIsmail\fR!handling mail for a domain}
.P 1
The configuration for the Brewery works as follows: all hosts except the
mail server \fBvstout\fR itself route all outgoing mail to the server,
using smart host routing\&. \fBvstout\fR itself sends all outgoing mail
to the real smart host that routes all of the Brewery's mail; this host
is called \fBmoria\fR\&.
.P 1
The standard \fIconfig\fR file for all hosts other than \fBvstout\fR
looks like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# Our domain:
visible_domain=vbrew.com
#
# What we name ourselves
visible_name=vbrew.com
#
# Smart-host routing: via SMTP to vstout
smart_path=vstout
smart_transport=smtp
.ENDVERBATIM
\"
\fR
.DE
.P 1
This is very similar to what we used for a UUCP-only site\&. The main
difference is that the transport used to send mail to the smart host
is, of course, SMTP\&. The \fIvisible_domain\fR attribute makes
\fIsmail\fR use the domain name instead of the local hostname on
all outgoing mail\&.
.P 1
.INDEX {configuring!mail gateway}
On the UUCP mail gateway \fBvstout\fR, the \fIconfig\fR file looks a
little different:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# Our hostnames:
hostnames=vbrew.com:vstout.vbrew.com:vstout
#
# What we name ourselves
visible_name=vbrew.com
#
# in the uucp world, we're known as vbrew.com
uucp_name=vbrew.com
#
# Smart transport: via uucp to moria
smart_path=moria
smart_transport=uux
#
# we're authoritative for our domain
auth_domains=vbrew.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
This \fIconfig\fR file uses a different scheme to tell \fIsmail\fR
what the local host is called\&.  Instead of giving it a list of domains
and letting it find the hostname with a system call, it specifies a list
explicitly\&.  The above list contains both the fully qualified and the
unqualified hostname, and the domain name all by itself\&. This makes
\fIsmail\fR recognize \fBjanet@vbrew\&.com\fR as a local address, and
deliver the message to \fBjanet\fR\&.
.P 1
The \fIauth_domains\fR variable names the domains for which
\fBvstout\fR is considered to be authoritative\&. That is, if
\fIsmail\fR receives any mail addressed to \fB\fIhost\fB\fR\fB\&.vbrew\&.com\fR
where \fB\fIhost\fB\fR does not name an existing local machine, it rejects the
message and returns it to the sender\&.  If this entry isn't present, any
such message will be sent to the smart-host, who will return it to
\fBvstout\fR, and so on until it is discarded for exceeding the maximum
hop count\&.
.P 1
.H 3 "Running smail"
.INDEX {smail@\fIsmail\fR!SMTP|(}
.P 1
First, you have to decide whether to run \fIsmail\fR as a separate
daemon, or whether to have \fIinetd\fR manage the SMTP port and invoke
\fIsmail\fR only whenever an SMTP connection is requested from some
client\&. Usually, you will prefer daemon operation on the mail server,
because this loads the machine far less than spawning \fIsmail\fR over
and over again for each single connection\&. As the mail server also
delivers most incoming mail directly to the users, you will choose
\fIinetd\fR operation on most other hosts\&.
.P 1
.INDEX {SMTP!service}
Whatever mode of operation you choose for each individual host,
you have to make sure you have the following entry in your
\fI/etc/services\fR file:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
smtp            25/tcp          # Simple Mail Transfer Protocol
.ENDVERBATIM
\"
\fR
.DE
.P 1
This defines the TCP port number that \fIsmail\fR should use for SMTP
conversations\&. 25 is the standard defined by the Assigned Numbers RFC\&.
.P 1
When run in daemon mode, \fIsmail\fR will put itself in the background,
and wait for a connection to occur on the SMTP port\&. When a connection
occurs, it forks and conducts an SMTP conversation with the peer
process\&.  The \fIsmail\fR daemon is usually started by invoking it from
the \fIrc\&.inet2\fR script using the following command:
.P 1
.P 1
.DS I F 5
\fB/usr/local/bin/smail -bd -q15m
\"
\fR
.DE
.P 1
The \fB-bd\fR flag turns on daemon mode, and \fB-q15m\fR makes
it process whatever messages have accumulated in the message queue every
15 minutes\&.
.P 1
.INDEX {inetd@\fIinetd\fR}
If you want to use \fIinetd\fR instead, your \fI/etc/inetd\&.conf\fR
file should contain a line like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
smtp    stream  tcp nowait  root  /usr/sbin/smtpd smtpd
.ENDVERBATIM
\"
\fR
.DE
.P 1
\fIsmtpd\fR should be a symbolic link to the \fIsmail\fR binary\&.
Remember you have to make \fIinetd\fR re-read \fIinetd\&.conf\fR by
sending it a \fIHUP\fR signal after making these changes\&.
.P 1
Daemon mode and \fIinetd\fR mode are mutually exclusive\&. If you run
\fIsmail\fR in deamon mode, you should make sure to comment out any
line in \fIinetd\&.conf\fR for the \fIsmtp\fR service\&. Equivalently,
when having \fIinetd\fR manage \fIsmail\fR, make sure that
\fIrc\&.inet2\fR does not start the \fIsmail\fR daemon\&.
.P 1
.INDEX {smail@\fIsmail\fR!SMTP|)}
.INDEX {configuring!mail on a LAN|)}
.INDEX {smail@\fIsmail\fR!on a LAN|)}
.P 1
.H 2 "If You Don't Get Through\&.\&.\&."
.INDEX {smail@\fIsmail\fR!troubleshooting}
.INDEX {smail@\fIsmail\fR!log files}
.P 1
If something goes wrong with your installation, there are a number of
features that may help you to find what's at the root of the problem\&.
The first place to check are \fIsmail\fR's log files\&. They are
kept in \fI/var/spool/smail\fR\fI/log\fR, and are named \fIlogfile\fR
and \fIpaniclog\fR, respectively\&. The former lists all transactions,
while the latter is only for error messages related to configuration
errors and the like\&.
.P 1
A typical entry in \fIlogfile\fR looks like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
04/24/94 07:12:04: [m0puwU8-00023UB] received
|            from: root
|         program: sendmail
|            size: 1468 bytes
04/24/94 07:12:04: [m0puwU8-00023UB] delivered
|             via: vstout.vbrew.com
|              to: root@vstout.vbrew.com
|         orig-to: root@vstout.vbrew.com
|          router: smart_host
|       transport: smtp
.ENDVERBATIM
\"
\fR
.DE
.P 1
This shows that a message from \fBroot\fR to
\fBroot@vstout\&.vbrew\&.com\fR has been properly delivered to host
\fBvstout\fR over SMTP\&.
.P 1
Messages \fIsmail\fR could not deliver generate a similar entry in
the log file, but with an error message instead of the \fBdelivered\fR
part:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
04/24/94 07:12:04: [m0puwU8-00023UB] received
|            from: root
|         program: sendmail
|            size: 1468 bytes
04/24/94 07:12:04: [m0puwU8-00023UB] root@vstout.vbrew.com ... deferred
 (ERR_148) transport smtp: connect: Connection refused
.ENDVERBATIM
\"
\fR
.DE
.P 1
The above error is typical for a situation in which \fIsmail\fR
properly recognizes that the message should be delivered to
\fBvstout\fR but was not able to connect to the SMTP service on
\fBvstout\fR\&. If this happens, you either have a configuration problem,
or TCP support is missing from your \fIsmail\fR binaries\&.
.P 1
.INDEX {checking!smail configuration@\fIsmail\fR configuration}
This problem is not as uncommon as one might think\&. There have been
precompiled \fIsmail\fR binaries around, even in some Linux
distributions, without support for TCP/IP networking\&. If this is the
case for you, you have to compile \fIsmail\fR yourself\&. Having
installed \fIsmail\fR, you can check if it has TCP networking support
by telnetting to the SMTP port on your machine\&. A successful connect to
the SMTP server is shown below (your input is marked \fB\fIlike this\fB\fR):
.P 1
.P 1
.DS I F 5
\fB$ \fB\fItelnet localhost smtp\fB\fB         
.br
Trying 127\&.0\&.0\&.1\&.\&.\&.                    
.br
Connected to localhost\&.                
.br
Escape character is '^]'\&.           
.br
220 monad\&.swb\&.de Smail3\&.1\&.28\&.1 #6 ready at Sun, 23 Jan 94 19:26 MET   
.br
\fB\fIQUIT\fB\fB                             
.br
221 monad\&.swb\&.de closing connection
\"
\fR
.DE
.P 1
If this test doesn't produce the SMTP banner (the line starting with
the 220 code), first make sure that your configuration is \fIreally\fR
correct before you go through compiling \fIsmail\fR yourself, which 
is described below\&.
.P 1
If you encounter a problem with \fIsmail\fR that you are unable to
locate from the error message \fIsmail\fR generates, you may want to
turn on debugging messages\&. You can do this using the \fB-d\fR flag,
optionally followed by a number specifying the level of verbosity (you
may not have any space between the flag and the numerical argument)\&.
\fIsmail\fR will then print a report of its operation to the screen,
which may give you more hints about what is going wrong\&.
.P 1
\fB[Don't know,\&.\&.\&.Maybe people don't find this funny:]\fR
If nothing else helps, you may want to invoke \fIsmail\fR in Rogue mode
by giving the \fB-bR\fR option on the command line\&. The manpage says
on this option: ``Enter the hostile domain of giant mail messages, and
RFC standard scrolls\&. Attempt to make it down to protocol level 26 and
back\&.'' Although this option won't solve your problems, it may provide
you some comfort and consolation\&.(\*F)
.FS
Don't use this if you're in a really bad mood\&.
.FE
.P 1
.H 3 "Compiling smail"
.INDEX {smail@\fIsmail\fR!compiling}
.P 1
If you know for sure that \fIsmail\fR is lacking TCP network support,
you have to get the source\&. It is probably included in your
distribution, if you got it via CD-ROM, otherwise you may get it from
the net via FTP\&.(\*F)
.FS
If you bought this with a Linux distribution from a vendor, you are
entitled to the source code ``for a nominal shipping charge'',
according to \fIsmail\fR's copying conditions\&.
.FE
.P 1
When compiling \fIsmail\fR, you had best start with the set of
configuration files from Vince Skahan's \fInewspak\fR distribution\&. To
compile in the TCP networking driver, you have to set the
\fIDRIVER_CONFIGURATION\fR macro in the \fIconf/EDITME\fR file to either
\fIbsd-network\fR or \fIarpa-network\fR\&.  The former is suitable for LAN
installations, but the Internet requires \fIarpa-network\fR\&.  The
difference between these two is that the latter has a special driver for
BIND service that is able to recognize MX records, which the former
doesn't\&.
.P 1
.H 2 "Mail Delivery Modes"
.SETR "smail.queue"
.INDEX {smail@\fIsmail\fR!delivery modes}
.INDEX {smail@\fIsmail\fR!queuing mail}
.INDEX {queuing mail}
.INDEX {mail!queue|(}
.P 1
As noted above, \fIsmail\fR is able to deliver messages immediately, or
queue them for later processing\&.  If you choose to queue messages,
\fIsmail\fR will store away all mail in the \fImessages\fR directory
below \fI/var/spool/smail\fR\&. It will not process them until explicitly told so
(this is also called ``running the queue'')\&.
.P 1
You can select one of three delivery modes by setting the
\fIdelivery_mode\fR attribute in the \fIconfig\fR file to either
of \fIforeground\fR, \fIbackground\fR, or \fIqueued\fR\&. These
select delivery in the foreground (immediate processing of incoming
messages), in the background, (message is delivered by a child of the
receiving process, with the parent process exiting immediately after
forking), and queued\&. Incoming mail will always be queued regardless
of this option if the boolean variable \fIqueue_only\fR is set
in the \fIconfig\fR file\&.
.P 1
If you turn on queuing, you have to make sure the queues are
checked regularly; probably every 10 or 15 minutes\&.  If you run
\fIsmail\fR in daemon mode, you have to add the option \fB-q10m\fR
on the command line to process the queue every 10 minutes\&.
Alternatively, you can invoke \fIrunq\fR from \fIcron\fR at these
intervals\&. \fIrunq\fR should be a link to \fIsmail\fR\&.
.P 1
.INDEX {smail@\fIsmail\fR!check mail queue}
.INDEX {checking!mail queue}
You can display the current mail queue by invoking \fIsmail\fR
with the \fB-bp\fR option\&. Equivalently, you can make \fImailq\fR
a link to \fIsmail\fR, and invoke \fImailq\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ mailq -v
m0pvB1r-00023UB	From: root  (in /var/spool/smail/input)
                Date: Sun, 24 Apr 94 07:12 MET DST
                Args: -oem -oMP sendmail root@vstout.vbrew.com
Log of transactions:
 Xdefer: <root@vstout.vbrew.com> reason: (ERR_148) transport smtp:
 connect: Connection refused
.ENDVERBATIM
\"
\fR
.DE
.P 1
This shows a single message sitting in the message queue\&. The
transaction log (which is only displayed if you give \fImailq\fR the
\fB-v\fR option) may give an additional reason why it is still
waiting for delivery\&.  If no attempt has been made yet to deliver the
message, no transaction log will be displayed\&.
.P 1
.INDEX {smail@\fIsmail\fR!run the queue}
Even when you don't use queuing, \fIsmail\fR will occasionally put
messages into the queue when it finds immediate delivery fails for a
transient reason\&. For SMTP connections, this may be an unreachable host;
but messages may also be deferred when the file system is found to be
full\&.  You should therefore put in a queue run every hour or so (using
\fIrunq\fR), else any deferred message will stick around the queue
forever\&.
.P 1
.INDEX {mail!queue|)}
.P 1
.H 2 "Miscellaneous config Options"
.SETR "smail.options"
.INDEX {smail@\fIsmail\fR!config file@\fIconfig\fR file}
.P 1
There are quite a number of options you may set in the \fIconfig\fR file,
which, although useful, are not essential to running \fIsmail\fR, and
which we will not discuss here\&. Instead, we will only mention a
few that you might find a reason to use:
.P 1
\"
.BL 10
.LI "\fIerror_copy_postmaster\fR"
.INDEX {mail!postmaster}
.INDEX {smail@\fIsmail\fR!postmaster}
.INDEX {mail!bounce}
If this boolean variable is set, any error will generate a
message to the postmaster\&.  Usually, this is only done for
errors that are due to a faulty configuration\&.  The variable can
be turned on by putting it in the \fIconfig\fR file, preceded
by a plus (\fI+\fR)\&.
.P 1
.LI "\fImax_hop_count\fR"
.INDEX {smail@\fIsmail\fR!routing!avoid loops}
.INDEX {avoid mail routing loops}
.INDEX {routing!loop avoidance}
If the hop count for a message (i\&.e\&. the number of hosts
already traversed) equals or exceeds this number, attempts at
remote delivery will result in an error message being returned
to the sender\&. This is used to prevent messages from looping
forever\&. The hop count is generally computed from the number
of \fIReceived:\fR fields in the mail header, but may also
be set manually using the \fB-h\fR option on the
command line\&.
.P 1
This variable defaults to 20\&.
.P 1
.LI "\fIpostmaster\fR"
.INDEX {mail!postmaster}
.INDEX {smail@\fIsmail\fR!postmaster}
The postmaster's address\&. If the address \fBPostmaster\fR
cannot be resolved to a valid local address, then this
is used as the last resort\&. The default is \fBroot\fR\&.
.P 1
\"
.LE
.P 1
.H 2 "Message Routing and Delivery"
.SETR "smail.delivery"
.INDEX {smail@\fIsmail\fR!routing}
.P 1
\fIsmail\fR splits up mail delivery into three different tasks,
the router, director, and transport module\&.
.P 1
The router module resolves all remote addresses, determining to which
host the message should be sent to next, and which transport must be
used\&. Depending on the nature of the link, different transports
such as UUCP or SMTP may be used\&.
.P 1
Local addresses are given to the director task which resolves any
forwarding or aliasing\&. For example, the address might be an alias or a
mailing list, or the user might want to forward her mail to another
address\&.  If the resulting address is remote, it is handed to the router
module for additional routing, otherwise it is assigned a transport for
local delivery\&. By far the most common case will be delivery to a
mailbox, but messages may also be piped into a command, or appended to
some arbitrary file\&.
.P 1
The transport module, finally, is responsible for whatever method
of delivery has been chosen\&. It tries to deliver the message, and in
case of failure either generates a bounce message, or defers it for
a later retry\&.
.P 1
.INDEX {smail@\fIsmail\fR!transports@\fItransports\fR}
.INDEX {smail@\fIsmail\fR!routers@\fIrouters\fR}
.INDEX {smail@\fIsmail\fR!directors@\fIdirectors\fR}
With \fIsmail\fR, you have much freedom in configuring these tasks\&.
For each of them, a number of drivers are available, from
which you can choose those you need\&. You describe them to \fIsmail\fR
in a couple of files, namely \fIrouters\fR, \fIdirectors\fR, and
\fItransports\fR, located in \fI/usr/lib/smail\fR\&. If these files do not exist,
reasonable defaults are assumed that should be suitable for many sites
that either use SMTP or UUCP for transport\&. If you want to change
\fIsmail\fR's routing policy, or modify a transport, you should get the
sample files from the \fIsmail\fR source distribution,(\*F)
.FS
The default configuration files can be found in \fIsamples/generic\fR
below the source directory\&.
.FE
copy the sample files to \fI/usr/lib/smail\fR, and modify them according to your
needs\&. Sample configuration files are also given in
Appendix 
.GETHN "appendix.smail"
\&\&.
.P 1
.H 2 "Routing Messages"
.SETR "smail.routing"
.INDEX {smail@\fIsmail\fR!routing|(}
.P 1
When given a message, \fIsmail\fR first checks if the destination is
the local host, or a remote site\&.  If the target host address is one of
the local hostnames configured in \fIconfig\fR, the message is handed
to the director module\&. Otherwise, \fIsmail\fR hands the destination
address to a number of router drivers to find out which host to forward
a message to\&.  They can be described in the \fIrouters\fR file; if this
file does not exist, a set of default routers are used\&.
.P 1
The destination host is passed to all routers in turn, and the one
finding the most specific route is selected\&. Consider a message
addressed to \fBjoe@foo\&.bar\&.com\fR\&. Then, one router might know a
default route for all hosts in the \fBbar\&.com\fR domain, while another
one has information for \fBfoo\&.bar\&.com\fR itself\&. Since the latter is
more specific, it is chosen over the former\&. If there are two routers
that provide a ``best match'', the one coming first in the
\fIrouters\fR file is chosen\&.
.P 1
This router now specifies the transport to be used, for instance UUCP,
and generates a new destination address\&. The new address is passed to
the transport along with the host to forward the message to\&.  In the
above example, \fIsmail\fR might find out that \fBfoo\&.bar\&.com\fR is to
be reached via UUCP using the path \fBernie!bert\fR\&.  It will then
generate a new target of \fBbert!foo\&.bar\&.com!user\fR, and have the
UUCP transport use this as the envelope address to be passed to
\fBernie\fR\&.
.P 1
When using the default setup, the following routers are available:
.P 1
\"
.BL 10
.LI
If the destination host address can be resolved using the
\fIgethostbyname(3)\fR or \fIgethostbyaddr(3)\fR library call,
the message will be delivered via SMTP\&. The only exception is if
the address is found to refer to the local host, it is handed to
the director module, too\&.
.P 1
\fIsmail\fR also recognizes IP addresses written as dotted quad
as a legal hostname, as long as they can be resolved through a
\fIgethostbyaddr(3)\fR call\&.  For example,
\fBscrooge@[149\&.76\&.12\&.4]\fR would be a valid although highly
unusual mail address for \fBscrooge\fR on
\fBquark\&.physics\&.groucho\&.edu\fR\&.
.P 1
If your machine is on the Internet, these routers are not what
you are looking for, because they do not support MX records\&. See
below for what to do in this case\&.
.P 1
.LI
.INDEX {smail@\fIsmail\fR!paths file@\fIpaths\fR file}
.INDEX {smail@\fIsmail\fR!routing!UUCP}
If \fI/usr/lib/smail\fR\fI/paths\fR, the pathalias database, exists,
\fIsmail\fR will try to look up the target host (minus
any trailing \fB\&.uucp\fR) in this file\&.
Mail to an address matched by this router will be
delivered using UUCP, using the path found in the database\&.
.P 1
.LI
.INDEX {smail@\fIsmail\fR!UUCP}
The host address (minus any trailing \fB\&.uucp\fR) will be
compared to the output of the \fIuuname\fR command to check if
the target host is in fact a UUCP neighbor\&. If this is the case,
the message will be delivered using the UUCP transport\&.
.P 1
.LI
If the address has not been matched by any of the above
routers, it will be delivered to the smart host\&. The path
to the smart host as well as the transport to be used are
set in the \fIconfig\fR file\&.
.P 1
\"
.LE
.P 1
These defaults work for many simple setups, but fail if routing
requirements get a little more complicated\&. If you are faced with any
of the problems discussed below, you will have to install your own
\fIrouters\fR file to override the defaults\&. A sample \fIrouters\fR
file you might start with is given in appendix 
.GETHN "appendix.smail"
\&\&.
Some Linux distributions also come with a set of configuration
files that are tailored to work around these difficulties\&.
.P 1
.INDEX {smail@\fIsmail\fR!routing!UUCP vs\&. SLIP}
.INDEX {smail@\fIsmail\fR!and SLIP/PPP}
.INDEX {smail@\fIsmail\fR!UUCP}
Probably the worst problems arise when your host lives in a dual
universe with both dialup IP and UUCP links\&. You will then have
hostnames in your \fIhosts\fR file that you only talk occasionally to
through your SLIP link, so \fIsmail\fR will attempt to deliver any mail
for these hosts via SMTP\&. This is usually not what you want, because even
if the SLIP link is activated regularly, SMTP is much slower than sending
the mail over UUCP\&. With the default setup, there's no way escaping
\fIsmail\fR\&.
.P 1
You can avoid this problem by having \fIsmail\fR check the \fIpaths\fR
file before querying the resolver, and put all hosts you want to force
UUCP delivery to into the \fIpaths\fR file\&. If you don't want to send
any messages over SMTP \fIever\fR, you can also comment out the
resolver-based routers altogether\&.
.P 1
.INDEX {smail@\fIsmail\fR!routing!Internet}
Another problem is that the default setup doesn't provide for true
Internet mail routing, because the resolver-based router does not
evaluate MX records\&. To enable full support for Internet mail routing,
comment out this router, and uncomment the one that used BIND instead\&.
There are, however, \fIsmail\fR binaries included in some Linux
distributions that don't have BIND support compiled in\&. If you enable
BIND, but get a message in the \fIpaniclog\fR file saying
``\fBrouter inet_hosts: driver bind not found\fR'', then you have to
get the sources and recompile \fIsmail\fR (see section 
.GETHN "smail.lan"
\&
above)\&.
.P 1
Finally, it is not generally a good idea to use the \fIuuname\fR
driver\&.  For one, it will generate a configuration error when you don't
have UUCP installed, because no \fIuuname\fR command will be found\&. The
second is when you have more sites listed in your UUCP \fISystems\fR
file than you actually have mail links with\&. These may be sites you only
exchange news with, or sites you occasionally download files from via
anonymous UUCP, but have no traffic with otherwise\&.
.P 1
To work around the first problem, you can substitute a shell script for
\fIuuname\fR which does a simple \fIexit 0\fR\&.  The more general
solution is, however, to edit the \fIrouters\fR file and remove
this driver altogether\&.
.P 1
.H 3 "The paths database"
.SETR "smail.pathalias"
.INDEX {smail@\fIsmail\fR!paths file@\fIpaths\fR file}
.INDEX {smail@\fIsmail\fR!routing!UUCP}
.INDEX {smail@\fIsmail\fR!UUCP}
.P 1
\fIsmail\fR expects to find the pathalias database in the \fIpaths\fR
file below \fI/usr/lib/smail\fR\&. This file is optional, so if you don't want to
perform any pathalias routing at all, simply remove any existing
\fIpaths\fR file\&.
.P 1
\fIpaths\fR must be a sorted ASCII file that contains entries which map
destination site names to UUCP bang paths\&. The file has to be sorted
because \fIsmail\fR uses a binary search for looking up a site\&.
Comments are not allowed in this file, and the site name must be
separated from the path using a TAB\&.  Pathalias databases are discussed
in somewhat greater detail in chapter 
.GETHN "mail"
\&\&.
.P 1
If you generate this file by hand, you should make sure to include all
legal names for a site\&. For example, if a site is known by both a plain
UUCP name and a fully qualified domain name, you have to add an entry
for each of them\&.  The file can be sorted by piping it through the
\fIsort(1)\fR command\&.
.P 1
If your site is only a leaf site, however, then no \fIpaths\fR
file should be necessary at all: just set up the smart host
attributes in your \fIconfig\fR file, and leave all routing to
your mail feed\&.
.P 1
.INDEX {smail@\fIsmail\fR!routing|)}
.P 1
.H 2 "Delivering Messages to Local Addresses"
.SETR "smail.directors"
.INDEX {smail@\fIsmail\fR!local addresses|(}
.P 1
Most commonly, a local address is just a user's login name, in which case
the message is delivered to her mailbox, \fI/var/spool/mail\fR\fI/\fB\fIuser\fB\fI\fR\&.
Other cases include aliases and mailing list names, and mail forwarding
by the user\&. In these cases, the local address expands to a new list
of addresses, which may be either local or remote\&.
.P 1
Apart from these ``normal'' addresses, \fIsmail\fR can handle other
types of local message destinations, like file names, and pipe commands\&.
These are not addresses in their own right, so you can't send mail
to, say, \fB/etc/passwd@vbrew\&.com\fR; they are only valid if they have 
been taken from forwarding or alias files\&.
.P 1
.INDEX {smail@\fIsmail\fR!directing mail to a file}
.INDEX {mail!directing to a file}
.INDEX {directing mail to a file}
A \fIfile name\fR is anything that begins with a slash (\fI/\fR) or a
tilde (\fI~\fR)\&.  The latter refers to the user's home directory, and
is possible only if the filename was taken from a \fI\&.forward\fR file
or a forwarding entry in the mailbox (see below)\&.  When delivering to a
file, \fIsmail\fR appends the messages to the file, creating it if
necessary\&.
.P 1
.INDEX {smail@\fIsmail\fR!feeding mail to a command}
.INDEX {mail!feeding to a command}
.INDEX {feeding mail to a command}
A \fIpipe command\fR may be any Un*x command preceded by the pipe
symbol (\fB|\fR)\&. This causes \fIsmail\fR to hand the command to the
shell along with its arguments, but without the leading `\fB|\fR'\&.  The
message itself is fed to this command on standard input\&.
.P 1
For example, to gate a mailing list into a local newsgroup,
you might use a shell script named \fIgateit\fR, and set up
a local alias which delivers all messages from this mailing list
to the script using \fI"|gateit"\fR\&.
.P 1
If the invocation contains white space, it has to be enclosed
in double quotes\&. Due to the security issues involved, care is taken not
to execute the command if the address has been obtained in a somewhat
dubious way (for example, if the alias file from which the address was
taken was writable by everyone)\&.
.P 1
.H 3 "Local Users"
.INDEX {smail@\fIsmail\fR!user mailbox}
.INDEX {mailbox file}
.P 1
The most common case for a local address is to denote a user's mailbox\&.
This mailbox is located in \fI/var/spool/mail\fR and has the name of the user\&.
It is owned by her, with a group of \fBmail\fR, and has mode 660\&.  If it
does not exist, it is created by \fIsmail\fR\&.
.P 1
Note that although \fI/var/spool/mail\fR is currently the standard place to
put the mailbox files, some mail software may have different paths
compiled in, for example \fI/usr/spool/mail\fR\&. If delivery to users
on your machine fails consistently, you should try if it helps to make
this a symbolic link to \fI/var/spool/mail\fR\&.
.P 1
There are two addresses \fIsmail\fR requires to exist:
\fBMAILER-DAEMON\fR and \fBPostmaster\fR\&. When generating a bounce
message for an undeliverable mail, a carbon copy is sent to the
\fBpostmaster\fR account for examination (in case this might be due to
a configuration problem)\&.  The \fBMAILER-DAEMON\fR is used as the
sender's address on the bounce message\&.
.P 1
If these addresses do not name valid accounts on your system,
\fIsmail\fR implicitly maps \fBMAILER-DAEMON\fR to \fBpostmaser\fR,
and \fBpostmaster\fR to \fBroot\fR, respectively\&. You should usually
override this by aliasing the \fBpostmaster\fR account to whoever is
responsible for maintaining the mail software\&.
.P 1
.H 3 "Forwarding"
.INDEX {smail@\fIsmail\fR!forwarding}
.INDEX {mail!forwarding}
.INDEX {forwarding!mail}
.P 1
A user may redirect her mail by having it forwarded to an alternative
address using one of two methods supported by \fIsmail\fR\&.  One option
is to put
.P 1
.P 1
.DS I F 5
\fBForward to \fB\fIrecipient\fB\fB,\&.\&.\&.\"
\fR
.DE
.P 1
.br
.ti 0
in the first line of her mailbox file\&.  This will send all incoming mail
to the specified list of recipients\&. Alternatively, she might create
a \fI\&.forward\fR file in her home directory, which contains the
comma-separated list of recipients\&.  With this variety of forwarding,
all lines of the file are read and interpreted\&.
.P 1
Note that any type of address may be used\&. Thus, a practical example
of a \fI\&.forward\fR file for vacations might be
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
janet, "|vacation"
.ENDVERBATIM
\"
\fR
.DE
.P 1
The first address delivers the incoming message to \fBjanet\fR's
mailbox nevertheless, while the \fIvacation\fR command returns a short
notification to the sender\&.
.P 1
.H 3 "Alias Files"
.INDEX {aliases@\fIaliases\fR|(}
.INDEX {smail@\fIsmail\fR!user aliases|(}
.INDEX {mail!aliases|(}
.INDEX {mail!forwarding}
.INDEX {forwarding!mail}
.INDEX {alias!mail}
.P 1
\fIsmail\fR is able to handle alias files compatible with those known by
Berkeley's \fIsendmail\fR\&. Entries in the alias file may have the form
.P 1
.P 1
.DS I F 5
\fB\fIalias\fB: \fIrecipients\fB
\"
\fR
.DE
.P 1
\fB\fIrecipients\fB\fR is a comma-separated list of addresses that will be
substituted for the alias\&. The recipient list may be continued across
newlines if the next line begins with a TAB\&.
.P 1
There is a special feature that allows \fIsmail\fR to handle mailing lists
from the alias file: if you specify ``\fB:include:\fR\fB\fIfilename\fB\fR''
as recipient, \fIsmail\fR will read the file specified, and substitute
its contents as a list of recipients\&.
.P 1
The main aliases file is \fI/usr/lib/aliases\fR\&. If you choose to make
this file world-writable, \fIsmail\fR wil not deliver any messages to
shell commands given in this file\&. A sample file is shown below:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# vbrew.com /usr/lib/aliases file
hostmaster: janet
postmaster: janet
usenet: phil
# The development mailing list.
development: joe, sue, mark, biff
        /var/mail/log/development
owner-development: joe
# Announcements of general interest are mailed to all
# of the staff
announce: :include: /usr/lib/smail/staff,
        /var/mail/log/announce
owner-announce: root
# gate the foobar mailing list to a local newsgroup
ppp-list: "|/usr/local/lib/gateit local.lists.ppp"
.ENDVERBATIM
\"
\fR
.DE
.P 1
If an error occurs while delivering to an address generated from the
\fIaliases\fR file, \fIsmail\fR will attempt to send a copy of the
error message to the ``alias owner''\&. For example, if delivery to
\fBbiff\fR fails when delivering a message to the \fBdevelopment\fR
mailing list, a copy of the error message will be mailed to the sender,
as well as to \fBpostmaster\fR and \fBowner-development\fR\&.  If the
owner address does not exist, no additional error message will be
generated\&.
.P 1
When delivering to files or when invoking programs given in the
\fIaliases\fR file, \fIsmail\fR will become the \fBnobody\fR user to
avoid any security hassles\&. Especially when delivering to files, this
can be a real nuisance\&. In the file given above, for instance, the log
files must be owned and writable by \fBnobody\fR, or delivery to them
will fail\&.
.P 1
.INDEX {aliases@\fIaliases\fR|)}
.INDEX {smail@\fIsmail\fR!user aliases|)}
.INDEX {mail!aliases|)}
.P 1
.H 3 "Mailing Lists"
.SETR "smail.director.mailing-lists"
.INDEX {smail@\fIsmail\fR!mailing lists|}
.P 1
Instead of using the \fIaliases\fR file, mailing lists may also be
managed by means of files in the \fI/usr/lib/smail\fR\fI/lists\fR directory\&. A
mailing list named \fInag-bugs\fR is described by the file
\fIlists/nag-bugs\fR, which should contain the members' addresses,
separated by commas\&. The list may be given on multiple lines, with
comments being introduced by a hash sign\&.
.P 1
For each mailing list, a user (or alias) named
\fBowner-\fR\fB\fIlistname\fB\fR should exist; any errors occurring when
resolving an address are reported to this user\&. This address is also
used as the sender's address on all outgoing messages in the
\fBSender:\fR header field\&.
.P 1
.INDEX {smail@\fIsmail\fR!local addresses|)}
.P 1
.H 2 "UUCP-based Transports"
.SETR "smail.uucp"
.INDEX {smail@\fIsmail\fR!UUCP|(}
.P 1
There are a number of transports compiled into \fIsmail\fR that utilize
the UUCP suite\&. In a UUCP environment, messages are usually passed on by
invoking \fIrmail\fR on the next host, giving it the message on
standard input and the envelope address on the command line\&. On your
host, \fIrmail\fR should be a link to the \fIsmail\fR command\&.
.P 1
When handing a message to the UUCP transport, \fIsmail\fR converts the
target address to a UUCP bang path\&. For example, \fBuser@host\fR will
be transformed to \fBhost!user\fR\&. Any occurrence of the `\fB%\fR'
address operator is preserved, so \fBuser%host@gateway\fR will become
\fBgateway!user%host\fR\&. However, \fIsmail\fR will never generate
such addresses itself\&.
.P 1
.INDEX {smail@\fIsmail\fR!BSMTP}
Alternatively, \fIsmail\fR can send and receive BSMTP batches via UUCP\&.
With BSMTP, one or more messages are wrapped up in a single batch that
contains the commands the local mailer would issue if a real SMTP
connection had be established\&.  BSMTP is frequently used in
store-and-forward (e\&.g\&. UUCP-based) networks to save disk space\&.  The
sample \fItransports\fR file in appendix 
.GETHN "appendix.smail"
\& contains
a transport dubbed \fIbsmtp\fR that generates partial BSMTP batches
in a queue directory\&. They must be combined into the final batches
later, using a shell script that adds the appropriate \fIHELO\fR and
\fIQUIT\fR command\&.
.P 1
To enable the \fIbsmtp\fR transport for specific UUCP links you
have to use so-called \fImethod\fR files (please refer to the
\fIsmail(5)\fR manual page for details)\&.  If you have only one UUCP
link, and use the smart host router, you enable sending SMTP batches by
setting the \fIsmart_transport\fR configuration variable to
\fIbsmtp\fR instead of \fIuux\fR\&.
.P 1
To receive SMTP batches over UUCP, you must make sure that you have the
unbatching command the remote site sends its batches to\&. If the remote
site uses \fIsmail\fR, too, you need to make \fIrsmtp\fR a link to
\fIsmail\fR\&. If the remote site runs \fIsendmail\fR, you should
additionally install a shell script named \fI/usr/bin/bsmtp\fR that
does a simple ``\fIexec\fR \fIrsmtp\fR'' (a symbolic link won't work)\&.
.P 1
.INDEX {smail@\fIsmail\fR!UUCP|)}
.P 1
.H 2 "SMTP-based Transports"
.SETR "smail.smtp"
.INDEX {smail@\fIsmail\fR!SMTP|(}
.P 1
\fIsmail\fR currently supports an SMTP driver to deliver mail over
TCP connections\&.(\*F)
.FS
The authors call this support ``simple''\&. For a future version of
\fIsmail\fR, they advertise a complete backend which will handle this
more efficiently\&.
.FE
It is capable of delivering a message to any number of addresses on
one single host, with the hostname being specified as either a fully
qualified domain name that can be resolved by the networking software,
or in dotted quad notation enclosed in square brackets\&.  Generally,
addresses resolved by any of the BIND, \fIgethostbyname(3)\fR, or
\fIgethostbyaddr(3)\fR router drivers will be delivered to the SMTP
transport\&.
.P 1
The SMTP driver will attempt to connect to the remote host immediately
through the \fIsmtp\fR port as listed in \fI/etc/services\fR\&.  If
it cannot be reached, or the connection times out, delivery will be
reattempted at a later time\&.
.P 1
Delivery on the Internet requires that routes to the destination host be
specified in the \fIroute-addr\fR format described in
chapter 
.GETHN "mail"
\&, rather than as a bang path\&.(\*F)
.FS
However, the use of routes in the Internet is discouraged altogether\&.
Fully qualified domain names should be used instead\&.
.FE
\fIsmail\fR will therefore transform \fBuser%host@gateway\fR,
where \fBgateway\fR is reached via \fBhost1!host2!host3\fR, into the
source-route address \fB<@host2,@host3:user%host@gateway>\fR which
will be sent as the message's envelope address to \fBhost1\fR\&.  To
enable these transformation (along with the built-in BIND driver), you
have to edit the entry for the \fIsmtp\fR driver in the
\fItransports\fR file\&.  A sample \fItransports\fR file is given in
Appendix 
.GETHN "appendix.smail"
\&\&.
.P 1
.INDEX {smail@\fIsmail\fR!SMTP|)}
.P 1
.H 2 "Hostname Qualification"
.SETR "smail.qualify"
.INDEX {hostname!catching unqualified}
.INDEX {smail@\fIsmail\fR!unqualified hostnames}
.P 1
Sometimes it is desirable to catch unqualified hostnames (i\&.e\&. those
that don't have a domain name) specified in sender or recipient
addresses, for example when gatewaying between two networks, where one
requires fully qualified domain names\&.  On an Internet-UUCP relay,
unqualifed hostnames should be mapped to the \fBuucp\fR domain by
default\&.  Other address modifications than these are questionable\&.
.P 1
The \fI/usr/lib/smail\fR\fI/qualify\fR file tells \fIsmail\fR which domain names
to tack onto which hostnames\&.  Entries in the \fIqualify\fR file
consists of a hostname beginning in column one, followed by domain name\&.
Lines containing a hash sign as its first non-white character are
considered comments\&.  Entries are searched in the order they appear in\&.
.P 1
If no \fIqualify\fR file exists, no hostname qualification is performed
at all\&.
.P 1
A special hostname of \fB*\fR matches any hostnames, thus enabling you
to map all hosts not mentioned before into a default domain\&. It should
be used only as the last entry\&.
.P 1
At the Virtual Brewery, all hosts have been set up to use fully
qualified domain names in the sender's addresses\&. Unqualified recipient
addresses are considered to be in the \fBuucp\fR domain, so only a
single entry in the \fIqualify\fR file is needed\&.
.P 1
.P 1
.DS I F 5
\"
.VERBATIM
# /usr/lib/smail/qualify, last changed Feb 12, 1994 by janet
#
*            uucp
.ENDVERBATIM
\"
.DE
.P 1
.INDEX {smail@\fIsmail\fR|)}
.P 1
.H 1 "Sendmail+IDA"
.SETR "sendmail"
.P 1
.INDEX {configuring!sendmail@\fIsendmail\fR|(}
.INDEX {sendmail@\fIsendmail\fR|(}
.P 1
.H 2 "Introduction to Sendmail+IDA"
.P 1
It's been said that you aren't a \fIreal\fR Unix system administrator until
you've edited a \fIsendmail\&.cf\fR file\&.  It's also been said that you're
crazy if you've attempted to do so twice\fB:-)\fR
.P 1
Sendmail is an incredibly powerful program\&.  It's also incredibly difficult
to learn and understand for most people\&.  Any program whose definitive
reference (\fISendmail\fR, published by O'Reilly and Associates) is 792 pages
long quite justifiably scares most people off\&.
.P 1
.INDEX {sendmail\&.cf@\fIsendmail\&.cf\fR|see \fIsendmail\fR, \fIsendmail\&.cf\fR}
.INDEX {sendmail@\fIsendmail\fR!sendmail\&.cf@\fIsendmail\&.cf\fR}
Sendmail+IDA is different\&.  It removes the need to edit the always cryptic
\fIsendmail\&.cf\fR file and allows the administrator to define the
site-specific routing and addressing configuration through relatively easy to
understand support files called \fItables\fR\&.  Switching to sendmail+IDA can
save you many hours of work and stress\&.
.P 1
Compared to the other major mail transport agents, there is probably nothing
that can't be done faster and simpler with sendmail+IDA\&.  Typical things that
are needed to run a normal UUCP or Internet site become simple to accomplish\&.
Configurations that normally are extremely difficult are simple to create and
maintain\&.
.P 1
At this writing, the current version of \fIsendmail5\&.67b+IDA1\&.5\fR is
available via anonymous FTP from \fBvixen\&.cso\&.uiuc\&.edu\fR\&.  It compiles
without any patching required under Linux\&.
.P 1
All the configuration files required to get sendmail+IDA sources to compile,
install, and run under Linux are included in \fInewspak-2\&.2\&.tar\&.gz\fR
which is available via anonymous FTP on \fBsunsite\&.unc\&.edu\fR in the
directory \fI/pub/Linux/system/Mail\fR\&.
.P 1
.H 2 "Configuration Files --- Overview"
.INDEX {IDA|see \fIsendmail\fR, IDA}
.P 1
.INDEX {sendmail@\fIsendmail\fR!CF}
Traditional sendmail is set up through a system configuration file (typically
\fI/etc/sendmail\&.cf\fR or \fI/usr/lib/sendmail\&.cf\fR), that is not anything
close to any language you've seen before\&. Editing the \fIsendmail\&.cf\fR file
to provide customized behavior can be a humbling experience\&.
.P 1
.INDEX {sendmail@\fIsendmail\fR!IDA}
Sendmail+IDA makes such pain essentially a thing of the past by having all
configuration options table-driven with rather easy to understand syntax\&.
These options are configured by running \fIm4\fR (a macro processor) or
\fIdbm\fR (a database processor) on a number of data files via Makefiles
supplied with the sources\&.
.P 1
.INDEX {sendmail@\fIsendmail\fR!tables}
The \fIsendmail\&.cf\fR file defines only the default behavior of the system\&.
Virtually all special customization is done through a number of optional
tables rather than by directly editing the \fIsendmail\&.cf\fR file\&.  A list
of all \fIsendmail\fR tables is given in figure 
.GETHN "sendmail.fig.tables"
\&\&.
.P 1
\"
.DF I F 5
.P 1
.DS I F 5
\"
.BL 10
.LI "\fImailertable\fR"
defines special behavior for remote hosts or domains\&.
.LI "\fIuucpxtable\fR"
forces UUCP delivery of mail to hosts that are in DNS format\&.
.LI "\fIpathtable\fR"
defines UUCP bang-paths to remote hosts or domains\&.
.LI "\fIuucprelays\fR"
short-circuits the pathalias path to well-known remote hosts\&.
.LI "\fIgenericfrom\fR"
converts internal addresses into generic ones visible to the
outside world\&.
.LI "\fIxaliases\fR"
converts generic addresses to/from valid internal ones\&.
.LI "\fIdecnetxtable\fR"
converts RFC-822 addresses to DECnet-style addresses\&.
\"
.LE
\"
.DE
\"
\"
.br
.FG " \fIsendmail\fR Support Files\&\&. " "" 0 "sendmail.fig.tables"
.DE
.P 1
.H 2 "The sendmail\&.cf File"
.INDEX {sendmail@\fIsendmail\fR!CF|(}
.P 1
The \fIsendmail\&.cf\fR file for sendmail+IDA is not edited directly, but is
generated from an \fIm4\fR configuration file provided by the local system
administrator\&. In the following, we will refer to it as \fIsendmail\&.m4\fR\&.
.P 1
This file contains a few definitions and otherwise merely points to the
tables where the real work gets done\&.   In general, it is only necessary to
specify:
.P 1
\"
.BL 10
.LI
the pathnames and filenames used on the local system\&.
.LI
the name(s) the site is known by for e-mail purposes\&.
.LI
which default mailer (and perhaps smart relay host) is desired\&.
\"
.LE
.P 1
There are a large variety of parameters that can be defined to establish the
behavior of the local site or to override compiled-in configuration items\&.
These configuration options are identified in the file
\fIida/cf/OPTIONS\fR in the source directory\&.
.P 1
A \fIsendmail\&.m4\fR file for a minimal configuration (UUCP or SMTP
with all non-local mail being relayed to a directly connected
smart-host) can be as short as 10 or 15 lines excluding comments\&.
.P 1
.H 3 "An Example sendmail\&.m4 File"
.P 1
A \fIsendmail\&.m4\fR file for \fBvstout\fR at the Virtual Brewery is shown
below\&.  \fBvstout\fR uses SMTP to talk to all hosts on the Brewery's LAN,
and sends all mail for other destinations to \fBmoria\fR, its Internet relay
host, via UUCP\&.
.P 1
\"
.DF I F 5
\"
.VERBATIM
dnl #------------------ SAMPLE SENDMAIL.M4 FILE ------------------
dnl # (the string 'dnl' is the m4 equivalent of commenting out a line)
dnl # you generally don't want to override LIBDIR from the compiled in paths
dnl #define(LIBDIR,/usr/local/lib/mail)dnl    # where all support files go
define(LOCAL_MAILER_DEF, mailers.linux)dnl    # mailer for local delivery
define(POSTMASTERBOUNCE)dnl                   # postmaster gets bounces
define(PSEUDODOMAINS, BITNET UUCP)dnl         # don't try DNS on these
dnl #-------------------------------------------------------------
dnl #
define(PSEUDONYMS, vstout.vbrew.com  vstout.UUCP vbrew.com)
dnl                                           # names we're known by
define(DEFAULT_HOST, vstout.vbrew.com)dnl     # our primary 'name' for mail
define(UUCPNAME, vstout)dnl                   # our uucp name
dnl #
dnl #-------------------------------------------------------------
dnl #
define(UUCPNODES, |uuname|sort|uniq)dnl       # our uucp neighbors
define(BANGIMPLIESUUCP)dnl                    # make certain that uucp
define(BANGONLYUUCP)dnl                       #  mail is treated correctly
define(RELAY_HOST, moria)dnl                  # our smart relay host
define(RELAY_MAILER, UUCP-A)dnl               # we reach moria via uucp
dnl #
dnl #--------------------------------------------------------------------
dnl #
dnl # the various dbm lookup tables
dnl #
define(ALIASES, LIBDIR/aliases)dnl            # system aliases
define(DOMAINTABLE, LIBDIR/domaintable)dnl    # domainize hosts
define(PATHTABLE, LIBDIR/pathtable)dnl        # paths database
define(GENERICFROM, LIBDIR/generics)dnl       # generic from addresses
define(MAILERTABLE, LIBDIR/mailertable)dnl    # mailers per host or domain
define(UUCPXTABLE, LIBDIR/uucpxtable)dnl      # paths to hosts we feed
define(UUCPRELAYS, LIBDIR/uucprelays)dnl      # short-circuit paths
dnl #
dnl #--------------------------------------------------------------------
dnl #
dnl # include the 'real' code that makes it all work
dnl # (provided with the source code)
dnl #
include(Sendmail.mc)dnl                         # REQUIRED ENTRY !!!
dnl #
dnl #------------ END OF SAMPLE SENDMAIL.M4 FILE -------
.ENDVERBATIM
\"
\"
.br
.FG " A sample \fIsendmail\&\&.m4\fR file for \fBvstout\fR\&\&. " "" 0 "sendmail.fig.m4"
.DE
.P 1
.H 3 "Typically Used sendmail\&.m4 Parameters"
.P 1
A few or the items in the \fIsendmail\&.m4\fR file are required all the
time; others can be ignored if you can get away with defaults\&.  The
following sections describe each of the items in the example
\fIsendmail\&.m4\fR file in more detail\&.
.P 1
.H 4 "Items that Define Paths"
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
dnl #define(LIBDIR,/usr/local/lib/mail)dnl  # where all support files go
.ENDVERBATIM
\"
\fR
.DE
.P 1
\fILIBDIR\fR defines the directory where sendmail+IDA expects to
find configuration files, the various dbm tables, and special local
definitions\&.  In a typical binary distribution, this is compiled into
the sendmail binary and does not need to be explicitly set in the
sendmail\&.m4 file\&.
.P 1
The above example has a leading \fIdnl\fR which means that this line
is essentially a comment for information only\&.
.P 1
To change the location of the support files to a different location,
remove the leading \fIdnl\fR from the above line, set the path to the
desired location, and rebuild and reinstall the \fIsendmail\&.cf\fR file\&.
.P 1
.H 4 "Defining the Local Mailer"
.INDEX {sendmail@\fIsendmail\fR!transport|see \fIsendmail\fR, mailers}
.INDEX {sendmail@\fIsendmail\fR!mailers}
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
define(LOCAL_MAILER_DEF, mailers.linux)dnl  # mailer for local delivery
.ENDVERBATIM
\"
\fR
.DE
.P 1
Most operating systems provide a program to handle local delivery of mail\&.
Typical programs for many of the major variants of Unix are already built into
the sendmail binary\&.
.P 1
In Linux, it is necessary to explicitly define the appropriate local mailer
since a local delivery program is not necessarily present in the distribution
you've installed\&.  This is done by specifying \fILOCAL_MAILER_DEF\fR in the
\fIsendmail\&.m4\fR file\&.
.P 1
.INDEX {sendmail@\fIsendmail\fR!deliver@\fIdeliver\fR}
For example, to have the commonly used \fIdeliver\fR program(\*F)
.FS
\fIdeliver\fR was written by Chip Salzenberg (\fBchip%tct@ateng\&.com\fR)\&.
It is part of several Linux distributions and can be found in the
usual anonymous FTP archives such as \fBftp\&.uu\&.net\fR\&.
.FE
provide this service, you would set \fILOCAL_MAILER_DEF\fR to
\fImailers\&.linux\fR\&.
.P 1
The following file should then be installed as \fImailers\&.linux\fR in
the directory pointed to by \fILIBDIR\fR\&.  It explicitly defines the
\fIdeliver\fR program in the internal \fIMlocal\fR mailer with the
proper parameters to result in \fIsendmail\fR correctly delivering mail
targeted for the local system\&.  Unless you are a sendmail expert, you
probably do not want to alter the following example\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# -- /usr/local/lib/mail/mailers.linux --
#     (local mailers for use on Linux )
Mlocal, P=/usr/bin/deliver, F=SlsmFDMP, S=10, R=25/10, A=deliver $u
Mprog,  P=/bin/sh,       F=lsDFMeuP,   S=10, R=10, A=sh -c $u
.ENDVERBATIM
\"
\fR
.DE
.P 1
There is a also built-in default for \fIdeliver\fR in the \fISendmail\&.mc\fR
file that gets included into the \fIsendmail\&.cf\fR file\&.
To specify it, you would not use the mailers\&.linux file and would
instead define the following in your \fIsendmail\&.m4\fR file:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
dnl --- (in sendmail.m4) ---
define(LOCAL_MAILER_DEF, DELIVER)dnl       # mailer for local delivery
.ENDVERBATIM
\"
\fR
.DE
.P 1
Unfortunately, \fISendmail\&.mc\fR assumes deliver is installed in
\fI/bin\fR, which is not the case with Slackware1\&.1\&.1 (which installs
it in \fI/usr/bin\fR)\&.  In that case you'd need to either fake it with
a link or rebuild deliver from sources so that it resides in
\fI/bin\fR\&.
.P 1
.H 4 "Dealing with Bounced Mail"
.INDEX {sendmail@\fIsendmail\fR!postmaster@\fBpostmaster\fR}
.INDEX {mail!bounce}
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
define(POSTMASTERBOUNCE)dnl                # postmaster gets bounces
.ENDVERBATIM
\"
\fR
.DE
.P 1
Many sites find that it is important to ensure that mail is sent and received
with close to a 100% success rate\&.  While examining \fIsyslogd(8)\fR logs
is helpful, the local mail administrator generally needs to see the headers
on bounced mail in order to determine if the mail was undeliverable because
of user error or a configuration error on one of the systems involved\&.
.P 1
Defining \fIPOSTMASTERBOUNCE\fR results in a copy of each bounced message
being set to the person defined as \fBPostmaster\fR for the system\&.
.P 1
Unfortunately, setting this parameter also results in the \fItext\fR of the
message being sent to the Postmaster, which potentially has related privacy
concerns for people using mail on the system\&.
.P 1
Site postmasters should in general attempt to discipline themselves (or do so
via technical means through shell scripts that delete the text of the bounce
messages they receive) from reading mail not addressed to them\&.
.P 1
.H 4 "Domain Name Service Related Items"
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
define(PSEUDODOMAINS, BITNET UUCP)dnl       # don't try DNS on these
.ENDVERBATIM
\"
\fR
.DE
.P 1
There are several well known networks that are commonly referenced in mail
addresses for historical reasons but that are not valid for DNS purposes\&.
Defining \fIPSEUDODOMAINS\fR prevents needless DNS lookup attempts that will
always fail\&.
.P 1
.H 4 "Defining Names the Local System is Known by"
.INDEX {sendmail@\fIsendmail\fR!local hostnames}
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
define(PSEUDONYMS, vstout.vbrew.com  vstout.UUCP vbrew.com)
dnl                                         # names we're known by
define(DEFAULT_HOST, vstout.vbrew.com)dnl   # our primary 'name' for mail
.ENDVERBATIM
\"
\fR
.DE
.P 1
Frequently, systems wish to hide their true identity, serve as mail gateways,
or receive and process mail addressed to `old' names by which they used to be
known\&.
.P 1
\fIPSEUDONYMS\fR specifies the list of all hostnames for which the local
system will accept mail\&.
.P 1
\fIDEFAULT_HOST\fR specifies the hostname that will appear in messages
originating on the local host\&.  It is important that this parameter be set
to a valid value or all return mail will be undeliverable\&.
.P 1
.H 4 "UUCP-Related Items"
.INDEX {sendmail@\fIsendmail\fR!local hostnames}
.INDEX {sendmail@\fIsendmail\fR!UUCP}
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
define(UUCPNAME, vstout)dnl                 # our uucp name
define(UUCPNODES, |uuname|sort|uniq)dnl     # our uucp neighbors
define(BANGIMPLIESUUCP)dnl                  # make certain that uucp
define(BANGONLYUUCP)dnl                     #  mail is treated correctly 
.ENDVERBATIM
\"
\fR
.DE
.P 1
Frequently, systems are known by one name for DNS purposes and another for
UUCP purposes\&.  \fIUUCPNAME\fR permits you to define a different hostname that
appears in the headers of outgoing UUCP mail\&.
.P 1
\fIUUCPNODES\fR defines the commands that return a list of hostnames for the 
systems we are connected directly to via UUCP connections\&.
.P 1
\fIBANGIMPLIESUUCP\fR and \fIBANGONLYUUCP\fR ensure that mail addressed with
UUCP `bang' syntax is treated according to UUCP behavior rather than the more
current Domain Name Service behavior used today on Internet\&.
.P 1
.H 4 "Relay Systems and Mailers"
.INDEX {sendmail@\fIsendmail\fR!routing!smart-host}
.INDEX {sendmail@\fIsendmail\fR!relay host}
.INDEX {sendmail@\fIsendmail\fR!mailers}
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
define(RELAY_HOST, moria)dnl                # our smart relay host
define(RELAY_MAILER, UUCP-A)dnl             # we reach moria via UUCP
.ENDVERBATIM
\"
\fR
.DE
.P 1
Many system administrators do not want to be bothered with the work needed to
ensure that their system is able to reach all the networks (and therefore
systems) on all networks worldwide\&.  Instead of doing so, they would rather
relay all outgoing mail to another system that is known to be indeed
``smart''\&.
.P 1
\fIRELAY_HOST\fR defines the UUCP hostname of such a smart neighboring
system\&.
.P 1
\fIRELAY_MAILER\fR defines the mailer used to relay the messages there\&.
.P 1
It is important to note that setting these parameters results in your outgoing
mail being forwarded to this remote system, which will affect the load of
their system\&.  Be certain to get explicit agreement from the remote Postmaster
before you configure your system to use another system as a general purpose
relay host\&.
.P 1
.H 4 "The Various Configuration Tables"
.INDEX {sendmail@\fIsendmail\fR!tables}
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
define(ALIASES, LIBDIR/aliases)dnl          # system aliases
define(DOMAINTABLE, LIBDIR/domaintable)dnl  # domainize hosts
define(PATHTABLE, LIBDIR/pathtable)dnl      # paths database
define(GENERICFROM, LIBDIR/generics)dnl     # generic from addresses
define(MAILERTABLE, LIBDIR/mailertable)dnl  # mailers per host or domain
define(UUCPXTABLE, LIBDIR/uucpxtable)dnl    # paths to hosts we feed
define(UUCPRELAYS, LIBDIR/uucprelays)dnl    # short-circuit paths
.ENDVERBATIM
\"
\fR
.DE
.P 1
With these macros, you can change the location where sendmail+IDA looks
for the various dbm tables that define the system's ``real'' behavior\&.
It is generally wise to leave them in \fILIBDIR\fR\&.
.P 1
.H 4 "The Master Sendmail\&.mc File"
.P 1
.DS I F 5
\fB\"
.VERBATIM
include(Sendmail.mc)dnl                     # REQUIRED ENTRY !!!
.ENDVERBATIM
\"
\fR
.DE
.P 1
The authors of sendmail+IDA provide the \fISendmail\&.mc\fR file which contains
the true ``guts'' of what becomes the sendmail\&.cf file\&.  Periodically, new
versions are released to fix bugs or add functionality without requiring a
full release and recompilation of sendmail from sources\&.
.P 1
It is important \fInot\fR to edit this file\&.
.P 1
.H 4 "So Which Entries are Really Required?"
.INDEX {sendmail@\fIsendmail\fR!CF}
.P 1
When not using any of the optional dbm tables, sendmail+IDA delivers mail via
the \fIDEFAULT_MAILER\fR (and possibly \fIRELAY_HOST\fR and
\fIRELAY_MAILER\fR) defined in the \fIsendmail\&.m4\fR file used to
generate \fIsendmail\&.cf\fR\&.  It is easily possible to override this behavior
through entries in the \fIdomaintable\fR or \fIuucpxtable\fR\&.
.P 1
.INDEX {sendmail@\fIsendmail\fR!Internet site}
.INDEX {sendmail@\fIsendmail\fR!UUCP leaf site}
A generic site that is on Internet and speaks Domain Name Service, or one
that is UUCP-only and forwards all mail via UUCP through a smart
\fIRELAY_HOST\fR, probably does not need any specific table entries at
all\&.
.P 1
Virtually all systems should set the \fIDEFAULT_HOST\fR and
\fIPSEUDONYMS\fR macros, which define the canonical site name and aliases
it is known by, and \fIDEFAULT_MAILER\fR\&. If all you have is a relay
host and relay mailer, you don't need to set these defaults since it works
automagically\&.
.P 1
UUCP hosts will probably also need to set \fIUUCPNAME\fR to their
official UUCP name\&.  They will also probably set \fIRELAY_MAILER\fR, and
\fIRELAY_HOST\fR which enable smart-host routing through a mail relay\&.
The mail transport to be used is defined in \fIRELAY_MAILER\fR and
should usually be \fIUUCP-A\fR for UUCP sites\&.
.P 1
If your site is SMTP-only and talks `Domain Name Service', you would change
the \fIDEFAULT_MAILER\fR to \fITCP-A\fR and probably delete the
\fIRELAY_MAILER\fR and \fIRELAY_HOST\fR lines\&.
.P 1
.INDEX {sendmail@\fIsendmail\fR!CF|)}
.P 1
.H 2 "A Tour of Sendmail+IDA Tables"
.P 1
Sendmail+IDA provides a number of tables that allow you to override the
default behavior of sendmail (specified in the \fIsendmail\&.m4\fR
file) and define special behavior for unique situations, remote
systems, and networks\&.  These tables are post-processed with
\fIdbm\fR using the Makefile provided with the distribution\&.
.P 1
Most sites will need few, if any, of these tables\&.  If your site does not
require these tables, the easiest thing is probably to make them zero length
files (with the \fItouch\fR command) and use the default Makefile in
\fILIBDIR\fR rather than editing the Makefile itself\&.
.P 1
.H 3 "mailertable"
.INDEX {sendmail@\fIsendmail\fR!mailertable@\fImailertable\fR}
.INDEX {sendmail@\fIsendmail\fR!mailers}
.P 1
The \fImailertable\fR defines special treatment for specific hosts or domains
based on the remote host or network name\&.  It is frequently used on Internet
sites to select an intermediate mail relay host or gateway to reach a remote
network through, and to specify a particular protocol (UUCP or SMTP) to be used\&.
UUCP sites will generally not need to use this file\&.
.P 1
Order is important\&.  Sendmail reads the file top-down and processes the message
according to the first rule it matches\&. So it is generally wise to place the
most explicit rules at the top of the file and the more generic rules below\&.
.P 1
Suppose you want to forward all mail for the Computer Science department
at Groucho Marx University via UUCP to a relay host \fBada\fR\&.    To
do so, you would have a \fImailertable\fR entry that looked like the
following:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 # (in mailertable)
 #
 # forward all mail for the domain .cs.groucho.edu via UUCP to ada
 UUCP-A,ada         .cs.groucho.edu
.ENDVERBATIM
\"
\fR
.DE
.P 1
Suppose you want all mail to the larger \fBgroucho\&.edu\fR domain to go to a
different relayhost \fBbighub\fR for address resolution and delivery\&.  The
expanded mailertable entries would look quite similar\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 # (in mailertable)
 #
 # forward all mail for the domain cs.groucho.edu via UUCP to ada
 UUCP-A,ada         .cs.groucho.edu
 #
 # forward all mail for the domain groucho.edu via UUCP to bighub
 UUCP-A,bighub      .groucho.edu
.ENDVERBATIM
\"
\fR
.DE
.P 1
As mentioned above, order is important\&.  Reversing the order of the two rules
shown above will result in all mail to \fB\&.cs\&.groucho\&.edu\fR going through the
more generic \fBbighub\fR path instead of the explicit \fBada\fR path that is
really desired\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 # (in mailertable)
 #
 # forward all mail for the domain .groucho.edu via UUCP to bighub
 UUCP-A,bighub     .groucho.edu
 #
 # (it is impossible to reach the next line because 
 #    the rule above will be matched first) 
 UUCP-A,ada        .cs.groucho.edu
 #
.ENDVERBATIM
\"
\fR
.DE
.P 1
In the mailertable examples above, the \fIUUCP-A\fR mailer makes
\fIsendmail\fR use UUCP delivery with domainized headers\&.
.P 1
The comma between the mailer and remote system tells it to forward the message
to \fBada\fR for address resolution and delivery\&.
.P 1
Mailertable entries are of the format:
.P 1
.P 1
.DS I F 5
\fB\fImailer delimiter relayhost\h'3c' host_or_domain
\"
\fB\fR
.DE
.P 1
There are a number of possible mailers\&.  The differences are generally in how
they treat addresses\&.  Typical mailers are \fITCP-A\fR (TCP/IP with
Internet-style addresses), \fITCP-U\fR (TCP/IP with UUCP-style
addresses), and \fIUUCP-A\fR (UUCP with Internet-style addresses)\&.
.P 1
The character that separates the mailer from the host portion on the
left-hand-side of a mailertable line defines how the address is modified by
the mailertable\&.  The important thing to realize is that this only rewrites
the envelope (to get the mail into the remote system)\&.  Rewriting anything
other than the envelope is generally frowned upon due to the high probability
of breaking the mail configuration\&.
.P 1
\"
.BL 10
.LI "!"
An exclamation point strips off the recipient hostname before
forwarding to the mailer\&.   This can be used when you want to wish to
essentially force mail into a misconfigured remote site\&.
.P 1
.LI ","
A comma does not change the address in any way\&.
The message is merely forwarded via the specified
mailer to the specified relay host\&.
.P 1
.LI ":"
A colon removes the recipient hostname only if there are
intermediate hosts between you and the destination\&.
Thus, \fBfoo!bar!joe\fR will have \fBfoo\fR removed, while
\fBxyzzy!janet\fR will remain unchanged\&.
\"
.LE
.P 1
.H 3 "uucpxtable"
.INDEX {sendmail@\fIsendmail\fR!fully qualified domain name}
.INDEX {sendmail@\fIsendmail\fR!unqualified hostname}
.INDEX {sendmail@\fIsendmail\fR!routing!UUCP}
.INDEX {sendmail@\fIsendmail\fR!mailers}
.INDEX {sendmail@\fIsendmail\fR!UUCP}
.P 1
Usually, mail to hosts with fully-qualified domain names is delivered via
Internet style (SMTP) delivery using Domain Name Service (DNS), or via the
relay host\&.  The \fIuucpxtable\fR forces delivery via UUCP routing by
converting the domainized name into a UUCP-style un-domainized remote
hostname\&.
.P 1
It is frequently used when you're a mail forwarder for a site or domain or
when you wish to send mail via a direct and reliable UUCP link rather than
potentially multiple hops through the default mailer and any intermediate
systems and networks\&.
.P 1
UUCP sites that talk to UUCP neighbors who use domainized mail headers would
use this file to force delivery of the mail through the direct UUCP
point-to-point link between the two systems rather than using the less direct
route through the \fIRELAY_MAILER\fR and \fIRELAY_HOST\fR or
through the \fIDEFAULT_MAILER\fR\&.
.P 1
Internet sites who do not talk UUCP probably would not use the
\fIuucpxtable\fR\&.
.P 1
Suppose you provide mail forwarding service to a system called
\fBsesame\&.com\fR in DNS and \fBsesame\fR in the UUCP maps\&.  You would need
the following \fIuucpxtable\fR entry to force mail for their host to go
through your direct UUCP connection\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#============== /usr/local/lib/mail/uucpxtable ============
# Mail sent to joe@sesame.com is rewritten to sesame!joe and 
# therefore delivered via UUCP
#
sesame   	sesame.com
#
#----------------------------------------------------------
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "pathtable"
.INDEX {sendmail@\fIsendmail\fR!routing}
.P 1
The \fIpathtable\fR is used to define explicit routing to remote hosts or
networks\&. The \fIpathtable\fR file should be in pathalias-style syntax,
sorted alphabetically\&.  The two fields on each line must be separated by a
real TAB, else \fIdbm\fR might complain\&.
.P 1
Most systems will not need any \fIpathtable\fR entries\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#=============== /usr/local/lib/mail/pathtable ================
#
# this is a pathalias-style paths file to let you kick mail to 
# UUCP neighbors to the direct UUCP path so you don't have to
# go the long way through your smart host that takes other traffic
#
# you want real tabs on each line or m4 might complain
#
# route mail through one or more intermediate sites to a remote 
# system using UUCP-style addressing.
#
sesame!ernie!%s            ernie
#	
# forwarding to a system that is a UUCP neighbor of a reachable
# internet site.
#
swim!%s@gcc.groucho.edu    swim
#
# The following sends all mail for two networks through different
# gateways (see the leading '.' ?).
# In this example, "uugate" and "byte" are specific systems that serve
# as mail gateways to the .UUCP and .BITNET pseudo-domains respectively
#
%s@uugate.groucho.edu           .UUCP
byte!%s@mail.shift.com          .BITNET
#
#=================== end of pathtable =======================
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "domaintable"
.INDEX {sendmail@\fIsendmail\fR!fully qualified domain name}
.INDEX {sendmail@\fIsendmail\fR!unqualified hostname}
.INDEX {sendmail@\fIsendmail\fR!mailers}
.P 1
The \fIdomaintable\fR is generally used to force certain behavior after a
DNS lookup has occurred\&.  It permits the administrator to make shorthand
names available for commonly referenced systems or domains by replacing the
shorthand name with the proper one automatically\&.  It can also be used to
replace incorrect host or domain names with the ``correct'' information\&.
.P 1
Most sites will not need any \fIdomaintable\fR entries\&.
.P 1
The following example shows how to replace an incorrect address people are
attempting to mail to with the correct address:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#============= /usr/local/lib/mail/domaintable =================
#
#
brokenhost.correct.domain         brokenhost.wrong.domain
#
#
#=================== end of domaintable ========================
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "aliases"
.INDEX {sendmail@\fIsendmail\fR!writing mail to a file}
.INDEX {sendmail@\fIsendmail\fR!user aliases}
.INDEX {sendmail@\fIsendmail\fR!aliases}
.P 1
Aliases permit a number of things to happen:
.P 1
\"
.BL 10
.LI
They provide a shorthand or well-known name for mail to be addressed
to in order to go to one or more persons\&.
.LI
They invoke a program with the mail message as the input to the
program\&.
.LI
They send mail to a file\&.
\"
.LE
.P 1
.INDEX {sendmail@\fIsendmail\fR!postmaster}
All systems require aliases for \fBPostmaster\fR and \fBMAILER-DAEMON\fR to
be RFC-compliant\&.
.P 1
Always be extremely aware of security when defining aliases that invoke
programs or write to programs since sendmail generally runs setuid-root\&.
.P 1
Changes to the \fIaliases\fR file do not take effect until the command
.P 1
.P 1
.DS I F 5
\fB# /usr/lib/sendmail -bi
\"
\fR
.DE
.P 1
.br
.ti 0
is executed to build the required dbm tables\&.  This can also be done by
executing the \fInewaliases\fR command, usually from cron\&.
.P 1
Details concerning mail aliases may be found in the \fIaliases(5)\fR manual
page\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#--------------------- /usr/local/lib/mail/aliases ------------------
#
# demonstrate commonly seen types of aliases
#
usenet:         janet                     # alias for a person
admin:          joe,janet                 # alias for several people
newspak-users:  :include:/usr/lib/lists/newspak
                                          # read recipients from a file
changefeed:     | /usr/local/lib/gup      # alias that invokes a program
complaints:     /var/log/complaints       # alias that writes mail to a file
#
# The following two aliases must be present to be RFC-compliant. 
# It is important to have them resolve to 'a person' who reads mail routinely.
#
postmaster:     root                      # required entry
MAILER-DAEMON:  postmaster                # required entry
#
#-------------------------------------------------------------------
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "Rarely Used Tables"
.INDEX {sendmail@\fIsendmail\fR!tables}
.P 1
The following tables are available, but rather infrequently used\&.  Consult
with the documentation that comes with the sendmail+IDA sources for details\&.
.P 1
\"
.BL 10
.LI "\fIuucprelays\fR"
.INDEX {sendmail@\fIsendmail\fR!routing!UUCP}
The \fIuucprelays\fR file is used to ``short-circuit'' the UUCP path
to especially well known sites rather than using a multi-hop or
unreliable path generated by processing the UUCP maps with
\fIpathalias\fR\&.
.P 1
.LI "\fIgenericfrom\fR and \fIxaliases\fR"
.INDEX {sendmail@\fIsendmail\fR!user aliases}
The \fIgenericfrom\fR file hides local usernames and addresses from
the outside world by automatically converting local usernames to
generic sender addresses that do not match internal usernames\&.
.P 1
The associated \fIxalparse\fR utility automates the generation of
the genericfrom and aliases file so that both incoming and outgoing
username translations occur from a master xaliases file\&.
.P 1
.LI "\fIdecnetxtable\fR"
.INDEX {sendmail@\fIsendmail\fR!DECnet}
The \fIdecnetxtable\fR rewrites domainized addresses into
decnet-style addresses much like the domaintable can be used to
rewrite undomainized addresses into domainized SMTP-style addresses\&.
.P 1
\"
.LE
.P 1
.H 2 "Installing sendmail"
.INDEX {sendmail@\fIsendmail\fR!installing}
.P 1
In this section, we'll take a look at how to install a typical binary
distribution of sendmail+IDA, and walk through what needs to be done to make
it localized and functional\&.
.P 1
The current binary distribution of sendmail+IDA for Linux can be
gotten from \fBsunsite\&.unc\&.edu\fR in \fI/pub/Linux/system/Mail\fR\&.
Even if you have an earlier version of \fIsendmail\fR I strongly recommend
you go to the \fIsendmail5\&.67b+IDA1\&.5\fR version since all required
Linux-specific patches are now in the vanilla sources and several
significant security holes have been plugged that were in versions
prior to about December 1, 1993\&.
.P 1
.INDEX {sendmail@\fIsendmail\fR!version}
If you are building \fIsendmail\fR from the sources, you should
follow the instructions in the \fIREADME\fRs included in the source
distribution\&.  The current sendmail+IDA source is available from
\fBvixen\&.cso\&.uiuc\&.edu\fR\&.
To build sendmail+IDA on Linux, you also need the Linux-specific
configuration files from \fInewspak-2\&.2\&.tar\&.gz\fR, which is available on
\fBsunsite\&.unc\&.edu\fR in the \fI/pub/Linux/system/Mail\fR directory\&.
.P 1
If you have previously installed \fIsmail\fR or another mail
delivery agent, you'll probably want to remove (or rename) all the
files from smail to be safe\&.
.P 1
.H 3 "Extracting the binary distribution"
.P 1
First, you have to unpack the archive file in some safe location:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ gunzip -c sendmail5.65b+IDA1.5+mailx5.3b.tgz | tar xvf -
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you have a ``modern'' \fItar\fR, for example from a recent Slackware
Distribution, you can probably just do a \fBtar -zxvf \fB\fIfilename\fB\fB\&.tgz\fR
and get the same results\&.
.P 1
Unpacking the archive creates a directory named
\fIsendmail5\&.65b+IDA1\&.5+mailx5\&.3b\fR\&. In this directory, you find a
complete installation of sendmail+IDA plus a binary of the
\fImailx\fR user agent\&. All file paths below this directory reflect
the location where the files should be installed, so it's safe to work
up a \fItar\fR command to move 'em over:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# cd sendmail5.65b+IDA1.5+mailx5.3b
# tar cf - . | (cd /; tar xvvpoof -)
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "Building sendmail\&.cf"
.INDEX {sendmail@\fIsendmail\fR!generating sendmail\&.cf@generating \fIsendmail\&.cf\fR|(}
.INDEX {sendmail@\fIsendmail\fR!CF|(}
.P 1
To build a \fIsendmail\&.cf\fR file customized for your site, you have to
write a \fIsendmail\&.m4\fR file, and process it with \fIm4\fR\&.
In \fI/usr/local/lib/mail/CF\fR, you find a sample file called
\fIsample\&.m4\fR\&.  Copy it to \fB\fIyourhostname\fB\fR\fI\&.m4\fR, and edit
it to reflect the situation of your site\&.
.P 1
The sample file is set up for a UUCP-only site that has domainized
headers and talks to a smart host\&.  Sites like this only need to edit
a few items\&.
.P 1
In the current section, I will only give a short overview of the
macros you have to change\&. For a complete description of what they do,
please refer to the earlier discussion of the \fIsendmail\&.m4\fR\&.
.P 1
\"
.BL 10
.LI "\fILOCAL_MAILER_DEF\fR"
Define define the file that defines the mailers for local mail
delivery\&.  See section ``Defining the Local Mailer'' above for
what goes in here\&.
.P 1
.LI "\fIPSEUDONYMS\fR"
Define all the names your local host is known by\&. 
.P 1
.LI "\fIDEFAULT_HOST\fR"
Put in your fully qualified domain name\&. This name will appear
as your hostname in all outgoing mail\&.
.P 1
.LI "\fIUUCPNAME\fR"
Put in your unqualified hostnmae\&.
.P 1
.LI "\fIRELAY_HOST\fR and \fIRELAY_MAILER\fR"
If you talk UUCP to a smart-host, set \fIRELAY_HOST\fR to
the UUCP name of your `smart relay' uucp neighbor\&.  Use the
UUCP-A mailer if you want domainized headers\&.
.P 1
.LI "\fIDEFAULT_MAILER\fR"
If you are on Internet and talk DNS, you should set this to
\fITCP-A\fR\&.  This tells sendmail to use the \fITCP-A\fR
mailer, which delivers mail via SMTP using normal RFC style
addressing for the envelope\&.  Internet sites probably do not need
to define \fIRELAY_HOST\fR or \fIRELAY_MAILER\fR\&.
.P 1
\"
.LE
.P 1
To create the \fIsendmail\&.cf\fR file, execute the command
.P 1
.P 1
.DS I F 5
\fB# make \fB\fIyourhostname\fB\fB\&.cf
\"
\fR
.DE
.P 1
This processes the \fB\fIyourhostname\fB\fR\fI\&.m4\fR file and creates
\fB\fIyourhostname\fB\fR\fI\&.cf\fR from it\&.
.P 1
Next, you should test whether the configuration file you've created
does what you expect it to do\&.  This is explained in the following two
sections\&.
.P 1
Once you're happy with its behavior, copy it into place with the
command:
.P 1
.P 1
.DS I F 5
\fB# cp \fB\fIyourhostname\fB\fB\&.cf /etc/sendmail\&.cf
\"
\fR
.DE
.P 1
.INDEX {sendmail@\fIsendmail\fR!generating sendmail\&.cf@generating \fIsendmail\&.cf\fR|)}
.INDEX {sendmail@\fIsendmail\fR!CF|)}
.P 1
.INDEX {server!sendmail@\fIsendmail\fR}
.INDEX {sendmail@\fIsendmail\fR!running}
At this point, your sendmail system is ready for action\&.  Put the following
line in the appropriate startup file (generally \fI/etc/rc\&.inet2\fR)\&.  You
can also execute it by hand to have the process start up now\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/sendmail -bd -q1h
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "Testing the sendmail\&.cf file"
.INDEX {sendmail@\fIsendmail\fR!testing|(}
.INDEX {checking!sendmail@\fIsendmail\fR|(}
.P 1
To put sendmail into `test' mode, you invoke it with the \fB-bt\fR
flag\&.  The default configuration file is the sendmail\&.cf file that is
installed on the system\&.  You can test an alternate file by using the
\fB-C\fR\fB\fIfilename\fB\fR option\&.
.P 1
In the following examples, we test \fIvstout\&.cf\fR, the configuration
file generated from the \fIvstout\&.m4\fR file shown in
figure 
.GETHN "sendmail.fig.m4"
\&\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
>
.ENDVERBATIM
\"
\fR
.DE
.P 1
The following tests ensure that \fIsendmail\fR is able to deliver all
mail to users on your system\&.  In all cases the result of the test
should be the same and point to the local system name with the
\fILOCAL\fR mailer\&.
.P 1
First test how a mail to a local user would be delivered\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM

# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
> 3,0 me
rewrite: ruleset  3   input: me
rewrite: ruleset  7   input: me
rewrite: ruleset  9   input: me
rewrite: ruleset  9 returns: < me >
rewrite: ruleset  7 returns: < > , me
rewrite: ruleset  3 returns: < > , me
rewrite: ruleset  0   input: < > , me
rewrite: ruleset  8   input: < > , me
rewrite: ruleset 20   input: < > , me
rewrite: ruleset 20 returns: < > , @ vstout . vbrew . com , me
rewrite: ruleset  8 returns: < > , @ vstout . vbrew . com , me
rewrite: ruleset 26   input: < > , @ vstout . vbrew . com , me
rewrite: ruleset 26 returns: $# LOCAL $@ vstout . vbrew . com $: me
rewrite: ruleset  0 returns: $# LOCAL $@ vstout . vbrew . com $: me
.ENDVERBATIM
\"
\fR
.DE
.P 1
The output shows how \fIsendmail\fR processes the address internally\&.
It is handed to various rulesets which analyze it, invoke other
rulesets in turn, and break it up into its components\&.
.P 1
In our example, we passed the address \fBme\fR to rulesets 3 and 0
(this is the meaning of the \fB3,0\fR entered before the address)\&.
The last line shows the parsed address as returned by ruleset 0,
containing the mailer the message would be delivered by, and the host
and user name given to the mailer\&.
.P 1
Next, test mail to a user on your system with UUCP syntax\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM

# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
> 3,0 vstout!me
rewrite: ruleset  3   input: vstout ! me
[...]
rewrite: ruleset  0 returns: $# LOCAL $@ vstout . vbrew . com  $: me
>

.ENDVERBATIM
\"
\fR
.DE
.P 1
Next, test mail addressed to a user on your system with Internet syntax
to your fully qualified hostname\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM

# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
> 3,0 me@vstout.vbrew.com
rewrite: ruleset  3   input: me @ vstout . vbrew . com
[...]
rewrite: ruleset  0 returns: $# LOCAL $@ vstout . vbrew . com $: me
>

.ENDVERBATIM
\"
\fR
.DE
.P 1
You should repeat the above two tests with each of the names you
specified in the \fIPSEUDONYMS\fR and \fIDEFAULT_NAME\fR
parameters in your \fIsendmail\&.m4\fR file\&.
.P 1
Lastly, test that you can mail to your relay host\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM

# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
> 3,0 fred@moria.com
rewrite: ruleset  3   input: fred @ moria . com
rewrite: ruleset  7   input: fred @ moria . com
rewrite: ruleset  9   input: fred @ moria . com
rewrite: ruleset  9 returns: < fred > @ moria . com
rewrite: ruleset  7 returns: < @ moria . com > , fred
rewrite: ruleset  3 returns: < @ moria . com > , fred
rewrite: ruleset  0   input: < @ moria . com > , fred
rewrite: ruleset  8   input: < @ moria . com > , fred
rewrite: ruleset  8 returns: < @ moria . com > , fred
rewrite: ruleset 29   input: < @ moria . com > , fred
rewrite: ruleset 29 returns: < @ moria . com > , fred
rewrite: ruleset 26   input: < @ moria . com > , fred
rewrite: ruleset 25   input: < @ moria . com > , fred
rewrite: ruleset 25 returns: < @ moria . com > , fred
rewrite: ruleset  4   input: < @ moria . com > , fred
rewrite: ruleset  4 returns: fred @ moria . com                                               
rewrite: ruleset 26 returns: < @ moria . com > , fred
rewrite: ruleset  0 returns: $# UUCP-A $@ moria $: < @ moria . com > , fred
>

.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "Putting it all together - Integration Testing sendmail\&.cf and the tables"
.INDEX {sendmail@\fIsendmail\fR!tables}
.P 1
At this point, you've verified that mail will have the desired default
behavior and that you'll be able to both send and received validly
addressed mail\&.  To complete the installation, it may be necessary to
create the appropriate dbm tables to get the desired final results\&.
.P 1
After creating the table(s) that are required for your site, you must
process them through \fIdbm\fR by typing \fImake\fR in the directory
containing the tables\&.
.P 1
If you are UUCP-only, you do \fInot\fR need to create any of the tables
mentioned in the \fIREADME\&.linux\fR file\&.  You'll just have to touch
the files so that the Makefile works\&.
.P 1
If you're UUCP-only and you talk to sites in addition to your
smart-host, you'll need to add \fIuucpxtable\fR entries for each (or
mail to them will also go through the smart host) and run \fIdbm\fR
against the revised \fIuucpxtable\fR\&.
.P 1
First, you need to make certain that mail through your
\fIRELAY_HOST\fR is sent to them via the \fIRELAY_MAILER\fR\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM

# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
> 3,0 fred@sesame.com
rewrite: ruleset  3   input: fred @ sesame . com
rewrite: ruleset  7   input: fred @ sesame . com
rewrite: ruleset  9   input: fred @ sesame . com
rewrite: ruleset  9 returns: < fred > @ sesame . com
rewrite: ruleset  7 returns: < @ sesame . com > , fred
rewrite: ruleset  3 returns: < @ sesame . com > , fred
rewrite: ruleset  0   input: < @ sesame . com > , fred
rewrite: ruleset  8   input: < @ sesame . com > , fred
rewrite: ruleset  8 returns: < @ sesame . com > , fred
rewrite: ruleset 29   input: < @ sesame . com > , fred
rewrite: ruleset 29 returns: < @ sesame . com > , fred
rewrite: ruleset 26   input: < @ sesame . com > , fred
rewrite: ruleset 25   input: < @ sesame . com > , fred
rewrite: ruleset 25 returns: < @ sesame . com > , fred
rewrite: ruleset  4   input: < @ sesame . com > , fred
rewrite: ruleset  4 returns: fred @ sesame . com
rewrite: ruleset 26 returns: < @ sesame . com > , fred                                                          
rewrite: ruleset  0 returns: $# UUCP-A $@ moria $: < @ sesame . com > , fred
>
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you have UUCP neighbors other than your \fIRELAY_HOST\fR, you
need to ensure that mail to them has the proper behavior\&.  Mail
addressed with UUCP-style syntax to a host you talk UUCP with should
go directly to them (unless you explicitly prevent it with a
\fIdomaintable\fR entry)\&. Assume host \fBswim\fR is a direct
UUCP neighbor of yours\&. Then feeding \fBswim!fred\fR to
\fIsendmail\fR should produce the following result:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM

# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
> 3,0 swim!fred
rewrite: ruleset  3   input: swim ! fred
[...lines omitted...]
rewrite: ruleset  0 returns: $# UUCP $@ swim $: < > , fred
>
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you have \fIuucpxtable\fR entries to force UUCP delivery to
certain UUCP neighbors who send their mail with Internet style
domainized headers, that also needs to be tested\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM

# /usr/lib/sendmail -bt -Cvstout.cf
ADDRESS TEST MODE
Enter <ruleset> <address>
[Note: No initial ruleset 3 call]
> 3,0 dude@swim.2birds.com
rewrite: ruleset  3   input: dude @ swim . 2birds . com
[...lines omitted...]
rewrite: ruleset  0 returns: $# UUCP $@ swim . 2birds $: < > , dude
>

.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {sendmail@\fIsendmail\fR!testing|)}
.INDEX {checking!sendmail@\fIsendmail\fR|)}
.P 1
.H 2 "Administrivia and Stupid Mail Tricks"
.P 1
Now that we've discussed the theory of configuring, installing, and testing a
sendmail+IDA system, lets take a few moments to look into things that
\fIdo\fR happen routinely in the life of a mail administrator\&.
.P 1
Remote systems sometimes break\&.  Modems or phone lines fail, DNS definitions
are set incorrectly due to human error\&.  Networks go down unexpectedly\&.  In
such cases, mail administrators need to know how to react quickly,
effectively, and \fIsafely\fR to keep mail flowing through alternate routes
until the remote systems or service providers can restore normal services\&.
.P 1
The rest of this chapter is intended to provide you with the solutions to the
most frequently encountered ``electronic mail emergencies''\&.
.P 1
.H 3 "Forwarding Mail to a Relay Host"
.INDEX {sendmail@\fIsendmail\fR!routing!domain}
.INDEX {sendmail@\fIsendmail\fR!relay host}
.P 1
To forward mail for a particular host or domain to a designated relay
system, you generally use the \fImailertable\fR\&.
.P 1
For example, to forward mail for \fBbackwood\&.org\fR to their UUCP gateway
system \fBbackdoor\fR, you'd put the following entry into \fImailertable\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 UUCP-A,backdoor   backwood.org
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "Forcing Mail into Misconfigured Remote Sites"
.INDEX {sendmail@\fIsendmail\fR!remote site misconfigured}
.INDEX {sendmail@\fIsendmail\fR!forcing mail}
.P 1
Frequently, Internet hosts will have trouble getting mail into misconfigured
remote sites\&.  There are several variants of this problem, but the general
symptom is that mail is bounced by the remote system or never gets there at
all\&.
.P 1
These problems can put the local system administrator in a bad position
because your users generally don't care that you don't personally administer
every system worldwide (or know how to get the remote administrator to fix
the problem)\&.  They just know that their mail didn't get through to the
desired recipient on the other end and that you're a likely person to complain
to\&.
.P 1
A remote site's configuration is their problem, not yours\&.  In all cases, be
certain to \fInot\fR break your site in order to communicate with a
misconfigured remote site\&. If you can't get in touch with the Postmaster at
the remote site to get them to fix their configuration in a timely manner,
you have two options\&.
.P 1
\"
.BL 10
.LI
It is generally possible to force mail into the remote system
successfully, although since the remote system is misconfigured,
replies on the remote end might not work\&.\&.\&.but then that's the
remote administrator's problem\&.
.P 1
You can fix the bad headers in the envelope on your outgoing messages
only by using a \fIdomaintable\fR entry for their host/domain that
results in the invalid information being corrected in mail
originating from your site:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
	 braindead.correct.domain.com        braindead.wrong.domain.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
.LI
Frequently, misconfigured sites `bounce' mail back to the sending
system and effectively say ``that mail isn't for this site'' because
they do not have their \fIPSEUDONYMNS\fR or equivalent set
properly in their configuration\&.  It is possible to totally strip off
all hostname and domain information from the envelope of messages
going from your site to them\&.
.P 1
The \fI!\fR in the following \fImailertable\fR delivers mail to
their remote site making it appear to their \fIsendmail\fR as if it
had originated locally on their system\&.  Note that this changes only
the envelope address, so the proper return address will still show up
in the message\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
	 TCP!braindead.correct.domain.com   braindead.wrong.domain.com
.ENDVERBATIM
\"
\fR
.DE
\"
.LE
.P 1
Regardless, even if you get mail into their system, there is no guarantee that
they can reply to your message (they're broken, remember\&.\&.\&.) but then their
users are yelling at their administrators rather than your users yelling at
you\&.
.P 1
.H 3 "Forcing Mail to be Transferred via UUCP"
.INDEX {mail!forcing UUPC delivery}
.INDEX {sendmail@\fIsendmail\fR!forcing UUPC delivery}
.INDEX {sendmail@\fIsendmail\fR!unqualified hostname}
.INDEX {sendmail@\fIsendmail\fR!routing!UUCP}
.INDEX {sendmail@\fIsendmail\fR!UUCP}
.INDEX {sendmail@\fIsendmail\fR!mailers}
.P 1
In an ideal world (from the Internet perspective), all hosts have records in
the Domain Name Service (DNS) and will send mail with fully qualified domain
names\&.
.P 1
If you happen to talk via UUCP to such a site, you can force mail to go
through the point-to-point UUCP connection rather than through your default
mailer by essentially ``undomainizing'' their hostname through the
\fIuucpxtable\fR\&.
.P 1
To force UUCP delivery to \fBsesame\&.com\fR, you would put the following in
your \fIuucpxtable\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 # un-domainize sesame.com to force UUCP delivery
 sesame    sesame.com
.ENDVERBATIM
\"
\fR
.DE
.P 1
The result is that sendmail will then determine (via
\fIUUCPNODES\fR in the \fIsendmail\&.m4\fR file) that you are
directly connected to the remote system and will queue the mail for
delivery with UUCP\&.
.P 1
.H 3 "Preventing Mail from Being Delivered via UUCP"
.INDEX {mail!preventing UUPC delivery}
.INDEX {sendmail@\fIsendmail\fR!preventing UUPC delivery}
.INDEX {sendmail@\fIsendmail\fR!unqualified hostname}
.INDEX {sendmail@\fIsendmail\fR!routing!UUCP}
.INDEX {sendmail@\fIsendmail\fR!UUCP}
.INDEX {sendmail@\fIsendmail\fR!mailers}
.P 1
The opposite condition also occurs\&. Frequently, systems may have a number of
direct UUCP connections that are used infrequently or that are not as reliable
and always available as the default mailer or relay host\&.
.P 1
For example, in the Seattle area there are a number of systems that exchange
the various Linux distributions via anonymous UUCP when the distributions
are released\&.  These systems talk UUCP only when necessary, so it is generally
faster and more reliable to send mail through multiple very reliable hops and
common (and always available) relay hosts\&.
.P 1
It is easily possible to prevent UUCP delivery of mail to a host that you are
directly connected to\&. If the remote system has a fully-qualified domain name,
you can add an entry like this to the \fIdomaintable\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
 # prevent mail delivery via UUCP to a neighbor
 snorkel.com       snorkel
.ENDVERBATIM
\"
\fR
.DE
.P 1
This will replace any occurence of the UUCP name with the FQDN, and thus
prevent a match by the \fIUUCPNODES\fR line in the \fIsendmail\&.m4\fR file\&.
The result is generally that mail will go via the \fIRELAY_MAILER\fR
and \fIRELAY_HOST\fR (or \fIDEFAULT_MAILER\fR)\&.
.P 1
.H 3 "Running the Sendmail Queue on Demand"
.INDEX {sendmail@\fIsendmail\fR!queue operation}
.INDEX {sendmail@\fIsendmail\fR!run the queue}
.P 1
To process queued messages immediately, merely type '/usr/lib/runq'\&. This
invokes sendmail with the appropriate options to cause sendmail to run through
the queue of pending jobs immediately rather than waiting for the next
scheduled run\&.
.P 1
.H 3 "Reporting Mail Statistics"
.INDEX {sendmail@\fIsendmail\fR!statistics}
.P 1
Many site administrators (and the persons they work for) are interested in the
volume of mail passing to, from, and through the local site\&.  There are a
number of ways to quantify mail traffic\&.
.P 1
\"
.BL 10
.LI
Sendmail comes with a utility called \fImailstats\fR that reads a
file called \fI/usr/local/lib/mail/sendmail\&.st\fR and reports
the number of messages and number of bytes transferred by each
of the mailers used in the \fIsendmail\&.cf\fR file\&.   This
file must be created by the local administrator manually for
sendmail logging to occur\&. The running totals are cleared by
removing and recreating the \fIsendmail\&.st\fR file\&.  One way
is to do the following:
.P 1
.P 1
.DS I F 5
\fB# cp /dev/null /usr/lib/local/mail/sendmail\&.st
\"
\fR
.DE
.P 1
.LI
Probably the best way to do quality reporting regarding who uses mail
and how much volume passes to, from, and through the local system is
to turn on mail debugging with \fIsyslogd(8)\fR\&.  Generally, this
means running the \fI/etc/syslogd\fR daemon from your system startup
file (which you should be doing anyway), and adding a line to
\fI/etc/syslog\&.conf(5)\fR that looks something like the following:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
	mail.debug                         /var/log/syslog.mail
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you use \fImail\&.debug\fR and get any medium to high mail
volume, the syslog output can get quite large\&.  Output files from
\fIsyslogd\fR generally need to be rotated or purged on a routine
basis from \fIcrond(8)\fR\&.
.P 1
There are a number of commonly available utilities that can summarize
the output of mail logging from syslogd\&.  One of the more well known
utilities is \fIsyslog-stat\&.pl\fR, a \fIperl\fR script that is
distributed with the sendmail+IDA sources\&.
.P 1
\"
.LE
.P 1
.H 2 "Mixing and Matching Binary Distributions"
.INDEX {sendmail@\fIsendmail\fR!file locations}
.P 1
There is no true standard configuration of electronic mail transport and
delivery agents and there is no ``one true directory structure\&.''
.P 1
Accordingly, it is necessary to ensure that all the various pieces of the
system (USENET news, mail, TCP/IP) agree on the location of the local mail
delivery program (\fIlmail\fR, \fIdeliver\fR, etc\&.), remote mail delivery
program (\fIrmail\fR), and the mail transport program (\fIsendmail\fR or
\fIsmail\fR)\&. Such assumptions are not generally documented, although use of
the \fIstrings\fR command can help determine what files and directories are
expected\&.  The following are some problems we've seen in the past with some
of the commonly available Linux binary distributions and sources\&.
.P 1
\"
.BL 10
.LI
Some versions of the NET-2 distribution of TCP/IP have services
defined for a program called \fIumail\fR rather than
\fIsendmail\fR\&.
.P 1
.LI
There are various ports of \fIelm\fR and \fImailx\fR that look for
a delivery agent of \fI/usr/bin/smail\fR rather than sendmail\&.
.P 1
.LI
Sendmail+IDA has a built-in local mailer for \fIdeliver\fR, but
expects it to be located in \fI/bin\fR rather than the more typical
Linux location of \fI/usr/bin\fR\&.
.P 1
\"
.LE
.P 1
Rather than go through the trouble of building all the mail clients from
sources, we generally fake it with the appropriate soft links\&.\&.\&.
.P 1
.H 2 "Where to Get More Information"
.P 1
There are many places you can look for more information on
\fIsendmail\fR\&.  For a list, see the Linux MAIL Howto posted
regularly to \fBcomp\&.answers\fR\&. It is also available for anonymous
FTP on \fBrtfm\&.mit\&.edu\fR\&. However, the definitive place is in the
sendmail+IDA sources\&.  Look in the directory \fIida/cf\fR below the
source directory for the files \fIDBM-GUIDE\fR, \fIOPTIONS\fR, and
\fISendmail\&.mc\fR\&.
.P 1
.INDEX {configuring!sendmail@\fIsendmail\fR|)}
.INDEX {sendmail@\fIsendmail\fR|)}
.P 1
.H 1 "Netnews"
.SETR "news"
.P 1
.H 2 "Usenet History"
.SETR "news.history"
.INDEX {news|(}
.P 1
The idea of network news was born in 1979 when two graduate students, Tom
Truscott and Jim Ellis, thought of using UUCP to connect machines for the 
purpose of information exchange among Un*x users\&. They set up
a small network of three machines in North Carolina\&.
.P 1
Initially, traffic was handled by a number of shell scripts (later
rewritten in C), but they were never released to the public\&. They
were quickly replaced by ``A'' news, the first public release of news
software\&.
.P 1
``A'' news was not designed to handle more than a few articles
per group and day\&. When the volume continued to grow, it was rewritten
by Mark Horton and Matt Glickman, who called it the ``B'' release
(a\&.k\&.a\&. Bnews)\&. The first public release of Bnews was version 2\&.1
in 1982\&. It was expanded continuously, with several new features 
being added\&. Its current version is Bnews 2\&.11\&. It is slowly
becoming obsolete, with its last official maintainer having switched to
INN\&.
.P 1
.INDEX {Collyer, Geoff}
.INDEX {Spencer, Henry}
.INDEX {news!C release|see C News}
.INDEX {C News}
Another rewrite was done and released in 1987 by Geoff Collyer and Henry
Spencer; this is release ``C'', or C News\&. In the time following there
have been a number of patches to C News, the most prominent being the
C News Performance Release\&. On sites that carry a large number of groups,
the overhead involved in frequently invoking \fIrelaynews\fR, which is
responsible for dispatching incoming articles to other hosts, is
significant\&. The Performance Release adds an option to \fIrelaynews\fR
that allows to run it in \fIdaemon mode\fR, in which the program puts
itself in the background\&.
.P 1
The Performance Release is the C News version currently included in most
Linux releases\&.
.P 1
.INDEX {Network News Transfer Protocol|see NNTP}
.INDEX {NNTP}
All news releases up to ``C'' are primarily targeted for UUCP networks,
although they may be used in other environments as well\&.  Efficient news
transfer over networks like TCP/IP, DECNet, or related requires a new
scheme\&. This was the reason why, in 1986, the ``Network News Transfer
Protocol'', NNTP, was introduced\&. It is based on network connections,
and specifies a number of commands to interactively transfer and
retrieve articles\&.
.P 1
There are a number of NNTP-based applications available from
the Net\&. One of them is the \fInntpd\fR package by Brian Barber
and Phil Lapsley, which you can use, among other things, to
provides newsreading service to a number of hosts inside a local
network\&. \fInntpd\fR was designed to complement news packages such as
Bnews or C News to give them NNTP features\&.
.P 1
.INDEX {InterNet News (INN)}
.INDEX {INN}
A different NNTP package is INN, or Internet News\&. It is not merely
a front end, but a news system by its own right\&. It comprises a
sophisticated news relay daemon that is capable of maintaining
several concurrent NNTP links efficiently, and is therefore the
news server of choice for many Internet sites\&.
.P 1
.H 2 "What is Usenet, Anyway?"
.SETR "news.usenet"
.INDEX {news!Usenet}
.INDEX {Usenet}
.INDEX {Zen}
.P 1
One of the most astounding facts about Usenet is that it isn't part of
any organization, or has any sort of centralized network management
authority\&. In fact, it's part of Usenet lore that except for a technical
description, you cannot define \fIwhat\fR it is, you can only say what
it isn't\&. If you have Brendan Kehoe's excellent ``Zen and the Art of the
Internet'' (available online or through Prentice-Hall, see [
GETST "zen"
])
at hand, you will find an amusing list of Usenet's non-properties\&.
.P 1
.INDEX {news!exchanging}
.INDEX {exchanging!news}
.INDEX {news!feeding}
At the risk of sounding stupid, one might define Usenet as a
collaboration of separate sites who exchange Usenet news\&.  To be a
Usenet site, all you have to do is find another site Usenet site, and
strike an agreement with its owners and maintainers to exchange news
with you\&. Providing another site with news is also called \fIfeeding\fR
it, whence another common axiom of Usenet philosophy originates: ``Get a
feed and you're on it\&.''
.P 1
.INDEX {news!article}
The basic unit of Usenet news is the article\&. This is a message a user
writes and ``posts'' to the net\&. In order to enable news sytems to deal
with it, it is prepended with administrative information, the so-called
article header\&. It is very similar to the mail header format laid down
in the Internet mail standard RFC 822, in that it consists of several
lines of text, each beginning with a field name terminated by a colon,
which is followed by the field's value\&.(\*F)
.FS
The format of Usenet news messages is specified in RFC 1036,
``Standard for interchange of USENET messages''\&.
.FE
.P 1
.INDEX {news!groups}
Articles are submitted to one or more \fInewsgroups\fR\&.  One may
consider a newsgroup a forum for articles relating to a common topic\&.
All newsgroups are organized in a hierarchy, with each group's name
indicating its place in the hierarchy\&. This often makes it easy to see
what a group is all about\&. For example, anybody can see from the
newsgroup name that \fBcomp\&.os\&.linux\&.announce\fR is used for
announcements concerning a computer operating system named Linux\&.
.P 1
.INDEX {news!exchanging}
.INDEX {exchanging!news}
.INDEX {news!feeding}
These articles are then exchanged between all Usenet sites that are
willing to carry news from this group\&.  When two sites agree to exchange
news, they are free to exchange whatever newsgroups they like to, and
may even add their own local news hierarchies\&. For example,
\fBgroucho\&.edu\fR might have a news link to \fBbarnyard\&.edu\fR, which
is a major news feed, and several links to minor sites which it feeds
news\&. Now, Barnyard College might receive all Usenet groups, while GMU
only wants to carry a few major hierarchies like \fBsci\fR,
\fBcomp\fR, \fBrec\fR, etc\&. Some of the downstream sites, say a UUCP
site called \fBbrewhq\fR, will want to carry even fewer groups, because
they don't have the network or hardware resources\&. On the other hand,
\fBbrewhq\fR might want to receive newsgroups from the \fBfj\fR
hierarchy, which GMU doesn't carry\&. It therefore maintains another link
with \fBgargleblaster\&.com\fR, who carry all \fBfj\fR groups, and feed
them to \fBbrewhq\fR\&. The news flow is shown in
figure 
.GETHN "news.fig.article-flow"
\&\&.
.P 1
\"
.DF I F 5
\"
\"
.br
.FG " Usenet news flow through Groucho Marx University\&\&. " "" 0 "news.fig.article-flow"
.DE
.P 1
The labels on the arrows originating from \fBbrewhq\fR may require some
explanation, though\&.  By default, it wants all locally generated news to
be sent to \fBgroucho\&.edu\fR\&.  However, as \fBgroucho\&.edu\fR does not
carry the \fBfj\fR groups, there's no pointing in sending it any
messages from those groups\&.  Therefore, the feed from \fBbrewhq\fR to
GMU is labelled \fBall,!fj\fR, meaning that all groups except those
below \fBfj\fR are sent to it\&.
.P 1
.H 2 "How Does Usenet Handle News?"
.SETR "news.algorithm"
.INDEX {exchanging!news}
.INDEX {news!exchanging|(}
.INDEX {news!feeding|(}
.INDEX {news!flooding algorithm}
.INDEX {flooding algorithm}
.P 1
Today, Usenet has grown to enormous proportions\&. Sites that carry
the whole of netnews usually transfer something like a paltry 
sixty megabytes a day\&.(\*F)
.FS
Wait a moment: 60 Megs at 9600 bps, that's 60 million by 1200,
that is\&.\&.\&.mutter, mutter,\&.\&.\&.Hey! That's 34 hours!
.FE
Of course this requires much more than pushing around files\&.  So let's
take a look at the way most Un*x systems handle Usenet news\&.
.P 1
.INDEX {feed, news}
News is distributed through the net by various transports\&. The
historical medium used to be UUCP, but today the main traffic is carried
by Internet sites\&. The routing algorithm used is called \fIflooding\fR:
Each site maintains a number of links (\fInews feeds\fR) to other sites\&.
Any article generated or received by the local news system is forwarded
to them, unless it has already been seen at that site, in which case it
is discarded\&. A site may find out about all other sites the article has
already traversed by looking at the \fBPath:\fR header field\&. This
header contains a list of all systems the article has been forwarded by
in bang path notation\&.
.P 1
.INDEX {news!message id}
.INDEX {news!history}
To distinguish articles and recognize duplicates, Usenet articles have
to carry a message id (specified in the \fBMessage-Id:\fR header
field), which combines the posting site's name and a serial number into
``\fB<\fB\fIserial\fB\fB@\fB\fIsite\fB\fB>\fR''\&. For each article processed, the
news system logs this id into a \fIhistory\fR file against which all
newly arrived articles are checked\&.
.P 1
.INDEX {news!limit a feed}
.INDEX {news!distribution}
The flow between any two sites may be limited by two criteria: for one,
an article is assigned a distribution (in the \fBDistribution:\fR
header field) which may be used to confine it to a certain group of
sites\&.  On the other hand, the newsgroups exchanged may be limited by
both the sending or receiving system\&.  The set of newsgroups and
distributions allowed for transmission to a site are usually kept in the
\fIsys\fR file\&.
.P 1
.INDEX {news!batching}
.INDEX {batching!news}
.INDEX {delivering!news|(}
The sheer number of articles usually requires that improvements be made
to the above scheme\&. On UUCP networks, the natural thing to do is to
collect articles over a period of time, and combine them into a single
file, which is compressed and sent to the remote site\&. This is called
\fIbatching\fR\&.(\*F)
.FS
The golden rule of netnews, according to Geoff Collyer: ``Thou shalt
batch thine articles\&.''
.FE
.P 1
.INDEX {news!ihave/sendme}
An alternative technique is the \fIihave/sendme\fR protocol that
prevents duplicate articles from being transferred in the first place,
thus saving net bandwidth\&. Instead of putting all articles in batch
files and sending them along, only the message ids of articles are
combined into a giant ``ihave'' message and sent to the remote site\&.  It
reads this message, compares it to its history file, and returns the
list of articles it wants in a ``sendme'' message\&. Only these articles
are then sent\&.
.P 1
Of course, ihave/sendme only makes sense if it involves two big sites
that receive news from several independent feeds each, and who poll each
other often enough for an efficient flow of news\&.
.P 1
.INDEX {news!NNTP}
Sites that are on the Internet generally rely on TCP/IP-based software
that uses the Network News Transfer Protocol, NNTP\&.(\*F)
.FS
Described in RFC 977\&.
.FE
It transfers news between feeds and provides Usenet access to single
users on remote hosts\&.
.P 1
.INDEX {news!pulling}
.INDEX {news!pushing}
NNTP knows three different ways to transfer news\&. One is a real-time
version of ihave/sendme, also referred to as \fIpushing\fR news\&. The
second technique is called \fIpulling\fR news, in which the client
requests a list of articles in a given newsgroup or hierarchy that have
arrived at the server's site after a specified date, and chooses those
it cannot find in its history file\&.  The third mode is for interactive
newsreading, and allows you or your newsreader to retrieve articles from
specified newgroups, as well as post articles with incomplete header
information\&.
.P 1
.INDEX {delivering!news|)}
.INDEX {news!exchanging|)}
.INDEX {news!feeding|)}
.P 1
.INDEX {news!spool}
.INDEX {news!active file@\fIactive\fR file}
At each site, news are kept in a directory hierarchy below \fI/var/spool/news\fR,
each article in a separate file, and each newsgroup in a separate
directory\&.  The directory name is made up of the newsgroup name, with
the components being the path components\&. Thus,
\fBcomp\&.os\&.linux\&.misc\fR articles are kept in
\fI\fI/var/spool/news\fI/comp/os/linux/misc\fR\&. The articles in a newsgroup are
assigned numbers in the order they arrive\&. This number serves as the
file's name\&.  The range of numbers of articles currently online is kept
in a file called \fIactive\fR, which at the same time serves as a list
of newsgroups known at your site\&.
.P 1
.INDEX {news!deleting old news}
.INDEX {news!expiring old articles}
Since disk space is a finite resource,(\*F)
.FS
Some people claim that Usenet is a conspiracy by modem and hard disk
vendors\&.
.FE
one has to start throwing away articles after some time\&. This is
called \fIexpiring\fR\&. Usually, articles from certain groups and
hierarchies are expired at a fixed number of days after they arrive\&.
This may be overridden by the poster by specifying a date of expiration
in the \fBExpires:\fR field of the article header\&.
.P 1
.INDEX {news|)}
.P 1
.H 1 "C News"
.SETR "cnews"
.INDEX {C News|(}
.P 1
One of the most popular software packages for Netnews is C News\&. It was
designed for sites that carry news over UUCP links\&. This chapter
will discuss the central concepts of C News, and the basic installation
and maintenance tasks\&.
.P 1
.INDEX {C News!spool directory}
C News stores its configuration files in \fI/usr/lib/news\fR, and most of its
binaries in the \fI/usr/lib/news/bin\fR directory\&.  Articles are kept below
\fI/var/spool/news\fR\&. You should make sure virtually all files in these
directories are owned by user \fBnews\fR, group \fBnews\fR\&. Most
problems arise from files being inaccessible to C News\&. Make it a rule
for you to become user \fBnews\fR using \fIsu\fR before you touch
anything in there\&.  The only exceptions is \fIsetnewsids\fR, which is
used to set the real user id of some news programs\&. It must be owned by
\fBroot\fR and must have the setuid bit set\&.
.P 1
In the following, we describe all C News configuration files in detail,
and show you what you have to do to keep your site running\&.
.P 1
.H 2 "Delivering News"
.SETR "cnews.rnews"
.INDEX {inews@\fIinews\fR}
.INDEX {rnews@\fIrnews\fR}
.P 1
.INDEX {delivering!news}
Articles may be fed to C News in several ways\&. When a local user posts an
article, the newsreader usually hands it to the \fIinews\fR command,
which completes the header information\&. News from remote sites, be it a
single article or a whole batch, is given to the \fIrnews\fR command,
which stores it in the \fI/var/spool/news\fR\fIin\&.coming\fR directory, from where
it will be picked up at a later time by \fInewsrun\fR\&. With any of
these two techniques, however, the article will eventually be handed to
the \fIrelaynews\fR command\&.
.P 1
.INDEX {C News!relaynews@\fIrelaynews\fR}
.INDEX {C News!history file@\fIhistory\fR file}
.INDEX {C News!active file@\fIactive\fR file}
.INDEX {news!active file@\fIactive\fR file}
.INDEX {news!history}
.INDEX {C News!receiving news|(}
.INDEX {news!message id}
For each article, the \fIrelaynews\fR command first checks if the
article has already been seen at the local site by looking up the
message id in the \fIhistory\fR file\&. Duplicate articles will be
dropped\&. Then, \fIrelaynews\fR looks at the \fBNewsgroups:\fR header
line to find out if the local site requests articles from any of these
groups\&.  If it does, and the newsgroup is listed in the \fIactive\fR
file, \fIrelaynews\fR tries to store the article in the corresponding
directory in the news spool area\&. If this directory does not exist, it
is created\&.  The article's message id will then be logged to the
\fIhistory\fR file\&.  Otherwise, \fIrelaynews\fR drops the article\&.
.P 1
.INDEX {junk newsgroup@\fBjunk\fR newsgroup}
If \fIrelaynews\fR fails to store an incoming article because a group
it has been posted to is not listed in your \fIactive\fR file, the
article will be moved to the \fBjunk\fR group\&.(\*F)
.FS
There may be a difference between the groups that exist at your site,
and those that your site is willing to receive\&. For example, the
subscription list may specify \fBcomp\&.all\fR, which means all
newsgroups below the \fBcomp\fR hierarchy, but at your site, only a
number of \fBcomp\fR groups are listed in \fIactive\fR\&. articles
posted to those groups will be moved to \fBjunk\fR\&.
.FE
\fIrelaynews\fR will also check for stale or misdated articles and
reject them\&. Incoming batches that fail for any other reason are moved
to \fI/var/spool/news\fR\fI/in\&.coming/bad\fR, and an error message is logged\&.
.P 1
After this, the article will be relayed to all other sites that request
news from these groups, using the transport specified for each
particular site\&. To make sure it isn't sent to a site that already has
seen it, each destination site is checked against the article's
\fBPath:\fR header field, which contains the list of sites the article
has traversed so far, written in bang path style\&.  Only if the
destination site's name does not appear in this list will the article be
sent to it\&.
.P 1
.INDEX {C News!UUCP}
.INDEX {UUCP!news}
C News is commonly used to relay news between UUCP sites, altough it is
also possible to use it in a NNTP environment\&. To deliver news to a remote
UUCP site --- either single articles or whole batches --- \fIuux\fR
is used to execute the \fIrnews\fR command on the remote site, and
feed the article or batch to it on standard input\&.
.P 1
.INDEX {C News!batching}
.INDEX {news!batching}
When batching is enabled for a given site, C News does not send any
incoming article immediately, but appends its path name to a file,
usually \fIout\&.going/\fB\fIsite\fB\fI/togo\fR\&.  Periodically, a batcher
program is executed from a crontab entry,(\*F)
.FS
Note that this should be the crontab of \fBnews\fR, in order not
to mangle file permissions\&.
.FE
which puts the articles in one or more files, optionally compresses
them, and sends them to \fIrnews\fR at the remote site\&.
.P 1
Figure 
.GETHN "cnews.fig.flow"
\& shows the news flow through
\fIrelaynews\fR\&. Articles may be relayed to the local site (denoted by
\fIME\fR), to some site named \fBponderosa\fR via email, and a site
named \fBmoria\fR, for which batching is enabled\&.
.P 1
\"
.DF I F 5
.so flow.ascii
\"
\"
.br
.FG " News flow through \fIrelaynews\fR\&\&. " "" 0 "cnews.fig.flow"
.DE
.P 1
.INDEX {C News!receiving news|)}
.P 1
.H 2 "Installation"
.INDEX {configuring!C News|(}
.INDEX {configuring!Usenet news|(}
.P 1
To install C News, untar the files into their proper places if you
haven't done so yet, and edit the configuration files listed below\&.
They are all located in \fI/usr/lib/news\fR\&.  Their formats will be described in
the following sections\&.
.P 1
\"
.BL 10
.LI "\fIsys\fR"
.INDEX {C News!sys file@\fIsys\fR file}
You probably have to modify the \fIME\fR line that describes
your system, although using \fIall/all\fR is always a safe
bet\&. You also have to add a line for each site you feed news to\&.
.P 1
If you are a leaf site, you only need a line that sends all
locally generated articles to your feed\&.  Assume your feed is
\fBmoria\fR, then your \fIsys\fR file should look like this:
.P 1
.P 1
.DS I F 5
\fBME:all/all::
.br
moria/moria\&.orcnet\&.org:all/all,!local:f:
\"
\fR
.DE
.P 1
.LI "\fIorganization\fR"
Your organization's name\&. For example, ``\fBVirtual Brewery,
Inc\&.\fR''\&.  On your home machine, enter ``private site'', or
anything else you like\&.  Most people will not call your site
properly configured if you haven't customized this file\&.
.P 1
.LI "\fInewsgroups\fR"
.P 1
.LI "\fImailname\fR"
Your site's mail name, e\&.g\&. \fBvbrew\&.com\fR\&.
.P 1
.LI "\fIwhoami\fR"
Your site's name for news purposes\&. Quite often, the UUCP site
name is used, for example \fBvbrew\fR\&.
.P 1
.LI "\fIexplist\fR"
You should probably edit this file to reflect your preferred
expiry times for some special newsgroups\&. Disk space may play an
important role in it\&.
.P 1
\"
.LE
.P 1
.INDEX {C News!create initial configuration}
.INDEX {C News!active file@\fIactive\fR file|(}
.INDEX {C News}
To create an initial hierarchy of newsgroups, obtain an \fIactive\fR
and a \fInewsgroups\fR file from the site that feeds you, and install
them in \fI/usr/lib/news\fR, making sure they are owned by news and have a mode of
644\&. Remove all \fBto\&.*\fR groups from the active file, and add
\fBto\&.\fR\fB\fImysite\fB\fR and \fBto\&.\fR\fB\fIfeedsite\fB\fR, as well as
\fBjunk\fR and \fBcontrol\fR\&. The \fBto\&.*\fR groups are normally used
for exchanging ihave/sendme messages, but you should create them
regardless of whether you plan to use ihave/sendme or not\&.  Next,
replace all article numbers in the second and third field of
\fIactive\fR using the following command:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# cp active active.old
# sed 's/ [0-9]* [0-9]* / 0000000000 00001 /' active.old > active
# rm active.old
.ENDVERBATIM
\"
\fR
.DE
.P 1
The second command is an invocation of \fIsed(1)\fR, one of my
favorite Un*x commands\&. This invocation replaces two strings of digits
with a string of zeroes and the string \fB000001\fR, respectively\&.
.P 1
Finally, create the news spool directory and the subdirectories used for
incoming and outgoing news:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# cd /var/spool
# mkdir news news/in.coming news/out.going
# chown -R news.news news
# chmod -R 755 news
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you're using a later release of C News, you may also have to create
the \fIout\&.master\fR directory in the news spool directory\&.
.P 1
If you're using newsreaders from a different distribution than the C News
you have running, you may find that some expect the news spool on
\fI/usr/spool/news\fR rather than in \fI/var/spool/news\fR\&. If your
newsreader doesn't seem to find any articles, create a symbolic
from \fI/usr/spool/news\fR to \fI/var/spool/news\fR\&.
.P 1
Now, you are ready to receive news\&. Note that you don't have to create
any directories other than those shown above, because each time C News
receives an article from a group for which there's no spool directory
yet, it will create it\&.
.P 1
In particular, this happens to \fIall\fR groups an article has
been crossposted to\&. So, after a while, you will find your news spool
cluttered with directories for newsgroups you have never subscribed
to, like \fBalt\&.lang\&.teco\fR\&. You may prevent this by either removing
all unwanted groups from \fIactive\fR, or by regularly running a
shell script which removes all empty directories below \fI/var/spool/news\fR
(except \fIout\&.going\fR and \fIin\&.coming\fR, of course)\&.
.P 1
.INDEX {C News!active file@\fIactive\fR file|)}
.P 1
.INDEX {C News!usenet@\fBusenet\fR}
.INDEX {C News!newsmaster}
.INDEX {news!newsmaster}
.INDEX {newsmaster}
C News needs a user to send error messages and status reports to\&.  By
default, this is \fBusenet\fR\&. If you use the default, you have to set
up an alias for it which forwards all of its mail to one or more
responsible persons\&.  (Chapters 
.GETHN "smail"
\& and 
.GETHN "sendmail"
\& explain
how to do so for \fIsmail\fR and \fIsendmail\fR)\&.  You may also
override this behavior by setting the environment variable
\fINEWSMASTER\fR to the appropriate name\&.  You have to do so in
\fBnews\fR' crontab file, as well as every time you invoke an
administrative tool manually, so installing an alias is probably easier\&.
.P 1
.INDEX {passwd@\fIpasswd\fR!real user names}
.INDEX {real user names}
.INDEX {full user names}
While you're hacking \fI/etc/passwd\fR, make sure that every user has 
her real name in the \fIpw_gecos\fR field of the password file (this
is the fourth field)\&. It is a question of Usenet netiquette that the
sender's real name appears in the \fBFrom:\fR field of the article\&.
Of course, you will want to do so anyway when you use mail\&.
.P 1
.H 2 "The sys file"
.SETR "cnews.sys"
.INDEX {C News!sys file@\fIsys\fR file|(}
.P 1
The \fIsys\fR file, located in \fI/usr/lib/news\fR, controls which
hierarchies you receive and forward to other sites\&. Although there
are maintenance tools named \fIaddfeed\fR and \fIdelfeed\fR, I think
it's better to maintain this file by hand\&.
.P 1
The \fIsys\fR file contains entries for each site you forward news to,
as well as a description of the groups you will accept\&.
An entry looks like
.P 1
.P 1
.DS I F 5
\fB\fB\fIsite\fB\fB[/\fB\fIexclusions\fB\fB]:\fB\fIgrouplist\fB\fB[/\fB\fIdistlist\fB\fB][:\fB\fIflags\fB\fB[:\fB\fIcmds\fB\fB]]
\"
\fR
.DE
.P 1
Entries may be continued across newlines using a backslash (\fI\\\fR)\&.
A hash sign (\fI#\fR) denotes a comment\&.
.P 1
\"
.BL 10
.LI "\fB\fIsite\fB\fR"
This is the name of the site the entry applies to\&. One usually
chooses the site's UUCP name for this\&.  There has to be an entry
for your site in the \fIsys\fR file, too, else you will not
receive any articles yourself\&.
.P 1
.INDEX {C News!receiving news}
.INDEX {receiving news}
.INDEX {news!receiving}
The special site name \fIME\fR denotes your site\&. The
\fIME\fR entry defines all groups you are willing to store
locally\&. Articles that aren't matched by the \fIME\fR line
will go to the \fBjunk\fR group\&.
.P 1
.INDEX {C News!excluding sites}
.INDEX {C News!hostname aliases}
.INDEX {alias!and C News}
Since C News checks \fB\fIsite\fB\fR against the site names in
the \fBPath:\fR header field, you have to make sure they really
match\&. Some sites use their fully qualified domain name in this
field, or an alias like \fBnews\&.\fR\fB\fIsite\&.domain\fB\fR\&. To prevent
any articles from being returned to these sites, you have to add
these to the exclusion list, separated by commas\&.
.P 1
For the entry applying to site \fBmoria\fR, for instance, the
site field would contain \fBmoria/\fR\fBmoria\&.orcnet\&.org\fR\&.
.P 1
.LI "\fB\fIgrouplist\fB\fR"
.INDEX {C News!exchanging news}
.INDEX {C News!limit a feed}
This is a comma-separated subscription list of groups and
hierarchies for that particular site\&. A hierarchy may be specified
by giving the hierarchy's prefix (such as \fBcomp\&.os\fR
for all groups whose name starts with this prefix), optionally
followed by the keyword \fBall\fR (e\&.g\&. \fBcomp\&.os\&.all\fR)\&.
.P 1
A hierarchy or group is excluded from forwarding by preceding it
with an exclamation mark\&. If a newsgroup is checked against the
list, the longest match applies\&. For example, if \fB\fIgrouplist\fB\fR
contains
.P 1
.P 1
.DS I F 5
\fB!comp,comp\&.os\&.linux,comp\&.folklore\&.computers
\"
\fR
.DE
.P 1
.br
.ti 0
no groups from the \fBcomp\fR hierarchy except
\fBcomp\&.folklore\&.computers\fR and all groups below
\fBcomp\&.os\&.linux\fR will be fed to that site\&.
.P 1
If the site requests to be forwarded all news
you receive yourself, enter \fIall\fR as \fB\fIgrouplist\fB\fR\&.
.P 1
.LI "\fB\fIdistlist\fB\fR"
.INDEX {C News!limit a feed}
.INDEX {C News!limit a feed}
.INDEX {news!distributions}
is offset from the \fB\fIgrouplist\fB\fR by a slash, and contains a
list of distributions to be forwarded\&.  Again, you may exclude
certain distributions by preceding them with an exclamation
mark\&. All distributions are denoted by \fIall\fR\&. Omitting
\fB\fIdistlist\fB\fR implies a list of \fIall\fR\&.
.P 1
For example, you may use a distribution list of
\fIall,!local\fR to prevent news for local use only from
being sent to remote sites\&.
.P 1
There are usually at least two distributions: \fIworld\fR,
which is often the default distribution used when none is
specified by the user, and \fIlocal\fR\&. There may be other
distributions that apply to a certain region, state, country,
etc\&. Finally, there are two distributions used by C News only;
these are \fIsendme\fR and \fIihave\fR, and are used for
the sendme/ihave protocol\&.
.P 1
The use of distributions is a subject of debate\&. For one, some
newsreaders create bogus distributions by simply using the top
level hierarchy, for example \fBcomp\fR when posting to
\fBcomp\&.os\&.linux\fR\&.  Distributions that apply to regions are
often questionable, too, because news may travel outside of your
region when sent across the Internet\&.(\*F)
.FS
It is not uncommon for an article posted in, say Hamburg,
to go to Frankfurt via \fBreston\&.ans\&.net\fR in the 
Netherlands, or even via some site in the U\&.S\&.
.FE
Distributions applying to an organization, however, are very
meaningful, for example to prevent confidential information from
leaving the company network\&. This purpose, however, is generally
served better by creating a separate newsgroup or hierarchy\&.
.P 1
.LI "\fB\fIflags\fB\fR"
.P 1
This describes certain parameters for the feed\&. It may be
empty, or a combination of the following:
.P 1
\"
.BL 10
.LI "\fIF\fR"
.INDEX {C News!batching}
This flag enables batching\&.
.P 1
.LI "\fIf\fR"
.INDEX {C News!batching}
This is almost identical to the \fIF\fR flag, but allows 
C News to calculate the size of outgoing batches more
precisely\&.
.P 1
.LI "\fII\fR"
.INDEX {C News!ihave/sendme}
This flag makes C News produce an article list suitable
for use by ihave/sendme\&. Additional modifications to the
\fIsys\fR and the \fIbatchparms\fR file are required
to enable ihave/sendme\&.
.P 1
.LI "\fIn\fR"
.INDEX {C News!NNTP support}
This creates batch files for active NNTP transfer
clients like \fInntpxmit\fR (see chapter 
.GETHN "nntp"
\&)\&.
The batch files contain the article's filename along
with its message id\&.
.P 1
.LI "\fIL\fR"
This tells C News to transmit only articles posted at your
site\&. This flag may be followed by a decimal number
\fB\fIn\fB\fR, which makes C News only transfer articles
posted within \fB\fIn\fB\fR hops from your site\&. C News
determines the number of hops from the \fBPath:\fR field\&.
.P 1
.LI "\fIu\fR"
This tells C News to batch only articles from unmoderated
groups\&. 
.P 1
.LI "\fIm\fR"
This tells C News to batch only articles from moderated
groups\&. 
\"
.LE
.P 1
You may use at most one of \fIF\fR, \fIf\fR,
\fII\fR, or \fIn\fR\&.
.P 1
.LI "\fB\fIcmds\fB\fR"
.INDEX {C News!rnews@\fIrnews\fR}
.INDEX {C News!exchanging news}
.INDEX {C News!sending news}
This field contains a command to be executed for each article,
unless batching is enabled\&. The article will be fed to the
command on standard input\&. This should only be used for very
small feeds; otherwise the load on both systems will be too high\&.
.P 1
The default command is
.P 1
.P 1
.DS I F 5
\fBuux - -r -z \fB\fIsystem\fB\fB!rnews
\"
\fR
.DE
.P 1
.br
.ti 0
which invokes \fIrnews\fR on the remote system, feeding it
the article on standard input\&.
.P 1
The default search path for commands given in this field is
\fI/bin:/usr/bin:\fI/usr/lib/news/bin\fI/batch\fR\&. The latter directory
contains a number of shell scripts whose name starts with
\fIvia\fR; they are briefly described later in this chapter\&.
.P 1
.INDEX {C News!batching}
.INDEX {C News!togo file@\fItogo\fR file}
If batching is enabled using either of the \fIF\fR or
\fIf\fR, \fII\fR or \fIn\fR flags, C News expects to
find a file name in this field rather than a command\&. If the
file name does not begin with a slash (\fI/\fR), it is assumed
to be relative to \fI/var/spool/news\fR\fI/out\&.going\fR\&. If the field is
empty, it defaults to \fI\fB\fIsystem\fB\fI/togo\fR\&.
.P 1
\"
.LE
.P 1
When setting up C News, you will most probably have to write your own
\fIsys\fR file\&. To help you with it, we give a sample file for
\fBvbrew\&.com\fR below, from which you might copy what you need\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# We take whatever they give us.
ME:all/all::

# We send everything we receive to moria, except for local and
# brewery-related articles. We use batching.
moria/moria.orcnet.org:all,!to,to.moria/all,!local,!brewery:f:

# We mail comp.risks to jack@ponderosa.uucp
ponderosa:comp.risks/all::rmail jack@ponderosa.uucp

# swim gets a minor feed
swim/swim.twobirds.com:comp.os.linux,rec.humor.oracle/all,!local:f:

# Log mail map articles for later processing
usenet-maps:comp.mail.maps/all:F:/var/spool/uumaps/work/batch
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {C News!sys file@\fIsys\fR file|)}
.P 1
.H 2 "The active file"
.SETR "cnews.active"
.INDEX {C News!active file@\fIactive\fR file|(}
.INDEX {C News!list of current groups}
.P 1
The \fIactive\fR file is located in \fI/usr/lib/news\fR and lists all groups
known at your site, and the articles currently online\&. You will rarely
have to touch it, but we explain it nevertheless for sake of
completeness\&.  Entries take the following form:
.P 1
.P 1
.DS I F 5
\fB\fB\fInewsgroup\fB\fB \fB\fIhigh\fB\fB \fB\fIlow\fB\fB \fB\fIperm\fB\fB
\"
\fR
.DE
.P 1
\fB\fInewsgroup\fB\fR is, of course, the group's name\&.  \fB\fIlow\fB\fR and
\fB\fIhigh\fB\fR are the lowest and highest numbers of articles currently
available\&.  If none are available at the moment, \fB\fIlow\fB\fR is equal to
\fB\fIhigh\fB\fR+1\&.
.P 1
.INDEX {C News!update low water mark}
At least, that's what the \fB\fIlow\fB\fR field is meant to do\&.  However, for
efficiency reasons, C News doesn't update this field\&.  This wouldn't be
such a big loss if there weren't some newsreaders that depend on it\&.
For instance, \fItrn\fR checks this field to see if it can purge any
articles from its thread database\&.  To update the \fB\fIlow\fB\fR field, you
therefore have to run the \fIupdatemin\fR command regularly (or, in
earlier version of C News, the \fIupact\fR script)\&.
.P 1
\fB\fIperm\fB\fR is a parameter detailing the access users are
granted to the group\&. It takes one of the following values:
.P 1
\"
.BL 10
.LI "\fIy\fR"
Users are allowed to post to this group\&.
.P 1
.LI "\fIn\fR"
Users are not allowed to post to this group\&. However,
the group may still be read\&.
.P 1
.LI "\fIx\fR"
This group has been disabled locally\&. This happens
sometimes when news admininistrators (or their superiors)
take offense to articles posted to certain groups\&.
.P 1
Articles received for this group are not stored locally,
although they are forwarded to the sites that request
them\&.
.P 1
.LI "\fIm\fR"
This denotes a moderated group\&. When a user tries to
post to this group, an intelligent newsreader will notify
her of this, and send the article to the moderator
instead\&. The moderator's address is taken from 
the \fImoderators\fR file in \fI/usr/lib/news\fR\&.
.P 1
.LI "\fI=\fB\fIreal-group\fB\fI\fR"
This marks \fB\fInewsgroup\fB\fR as being a local alias for
another group, namely \fB\fIreal-group\fB\fR\&. All articles
posted to \fB\fInewsgroup\fB\fR will be redirected to it\&.
\"
.LE
.P 1
In C News, you will generally not have to access this file directly\&.
Groups may be added or deleted locally using \fIaddgroup\fR and
\fIdelgroup\fR (see below in section 
.GETHN "cnews.maint"
\&)\&.
When groups are added or deleted for the whole of Usenet, this
is usually done by sending a \fInewgroup\fR or \fIrmgroup\fR
control message, respectively\&. \fINever send such a message yourself!\fR
For instructions on how to create a newsgroup, read the monthly
postings in \fBnews\&.announce\&.newusers\fR\&.
.P 1
A file closely related to \fIactive\fR is \fIactive\&.times\fR\&. Whenever
a group is created, C News logs a message to this file, containing
the name of the group created, the date of creation, whether it
was done by a \fInewgroup\fR control message or locally, and who did it\&.
This is for the convenience of newsreaders who may notify the user
of any recently created groups\&. It is also used by the
\fINEWGROUPS\fR command of NNTP\&.
.P 1
.INDEX {C News!active file@\fIactive\fR file|)}
.P 1
.H 2 "Article Batching"
.SETR "cnews.batcher"
.INDEX {C News!sending news|(}
.INDEX {C News!batching|(}
.INDEX {batching!news|(}
.INDEX {news!batching}
.P 1
Newsbatches follow a particular format which is the same for
Bnews, C News, and INN\&. Each article is preceded by a line like this:
.P 1
.P 1
.DS I F 5
\fB#! rnews \fB\fIcount\fB\fB
\"
\fR
.DE
.P 1
.br
.ti 0
where \fB\fIcount\fB\fR is the number of bytes in the article\&. When batch
compression is used, the resulting file is compressed as a whole, and
preceded by another line, indicated by the message to be used for
unpacking\&. The standard compression tool is \fBcompress\fR,
which is marked by
.P 1
.P 1
.DS I F 5
\fB#! cunbatch
\"
\fR
.DE
.P 1
Sometimes, when having to send batches via mail software that
removes the eighth bit from all data, a compressed batch may be
protected using what is called c7-encoding; these batches will be
marked by \fIc7unbatch\fR\&.
.P 1
When a batch is fed to \fIrnews\fR on the remote site, it checks for
these markers and processes the batch appropriately\&.  Some sites also
use other compression tools, like \fIgzip\fR, and precede their gzipped
files with \fIzunbatch\fR instead\&.  C News does not recognize
non-standard headers like these; you have to modify the source to
support them\&.
.P 1
.INDEX {sendbatches@\fIsendbatches\fR}
.INDEX {C News!sending news}
In C News, article batching is performed by \fI/usr/lib/news/bin\fR\fI/batch/sendbatches\fR,
which takes a list of articles from the \fB\fIsite\fB\fR\fI/togo\fR file, and
puts them into several newsbatches\&.  It should be executed once per hour
or even more frequently, depending on the volume of traffic\&.
.P 1
Its operation is controlled by the \fIbatchparms\fR file in \fI/usr/lib/news\fR\&.
This file describes the maximum batch size allowed for each site, the
batching and optional compression program to be used, and the transport
for delivering it to the remote site\&. You may specify batching parameters
on a per-site basis, as well as a set of default parameters for
sites not explicitly mentioned\&.
.P 1
To perform batching for a specific site, you invoke it as
.P 1
.P 1
.DS I F 5
\fB# su news -c "\fI/usr/lib/news/bin\fB/batch/sendbatches \fB\fIsite\fB\fB"
\"
\fR
.DE
.P 1
.INDEX {C News!batch parameters|(}
When invoked without arguments, \fIsendbatches\fR handles all batch
queues\&. The interpretation of ``all'' depends on the presence of a
default entry in \fIbatchparms\fR\&. If one is found, all directories in
\fI/var/spool/news\fR\fI/out\&.going\fR are checked, otherwise, it cycles through
all entries in \fIbatchparms\fR\&.  Note that \fIsendbatches\fR, when
scanning the \fIout\&.going\fR directory, takes only those directories
that contain no dot or at sign (\fI@\fR) as site names\&.
.P 1
When installing C News, you will most likely find a \fIbatchparms\fR
file in your distribution which contains a reasonable default entry,
so there's a good chance that you wouldn't have to touch the file\&.
Just in case, we describe its format nevertheless\&. Each line consists
of six fields, separated by spaces or tabs:
.P 1
.P 1
.DS I F 5
\fB\fB\fIsite\fB\fB \fB\fIsize\fB\fB \fB\fImax\fB\fB \fB\fIbatcher\fB\fB \fB\fImuncher\fB\fB \fB\fItransport\fB\fB
\"
\fR
.DE
.P 1
.SP 2
The meaning of these fields is as follows:
.P 1
\fB\fIsite\fB\fR is the name of the site the entry applies to\&. The \fItogo\fR
file for this site must reside in \fIout\&.going/togo\fR below the news
spool\&. A site name of \fI/default/\fR denotes the default entry\&.
.P 1
\fB\fIsize\fB\fR is the maximum size of article batches created (before
compression)\&. For single articles larger than this, C News makes an
exception and puts them in a single batch by themselves\&.
.P 1
\fB\fImax\fB\fR is the maximum number of batches created and scheduled
for transfer before batching stalls for this particular site\&. This
is useful in case the remote site should be down for a long time,
because it prevents C News from cluttering your UUCP spool directories 
with zillions of newsbatches\&.
.P 1
C News determines the number of queued batches using the \fIqueulen\fR
script in \fI/usr/lib/news/bin\fR\&. Vince Skahan's \fInewspak\fR release should contain
a script for BNU-compatible UUCPs\&. If you use a different flavor of spool
directories, for example, Taylor UUCP, you might have to write your
own\&.(\*F)
.FS
If you don't care about the number of spool files (because
you're the only person using your computer, and you don't
write articles by the megabyte), you may replace the script's
contents by a simple \fIexit 0\fR statement\&.
.FE
.P 1
.INDEX {C News!ihave/sendme}
The \fB\fIbatcher\fB\fR field contains the command used for producing a
batch from the list of articles in the \fItogo\fR file\&. For regular feeds,
this is usually \fIbatcher\fR\&. For other purposes, alternative
batchers may be provided\&. For instance, the ihave/sendme protocol
requires the article list to be turned into ihave or sendme control
messages, which are posted to the newsgroup \fBto\&.\fB\fIsite\fB\fB\fR\&.
This is performed by \fIbatchih\fR and \fIbatchsm\fR\&.
.P 1
.INDEX {C News!compressing batches}
The \fB\fImuncher\fB\fR field specifies the command used for compression\&.
Usually, this is \fBcompcun\fR, a script that produces a compressed
batch\&.(\*F)
.FS
As shipped with C News, \fBcompcun\fR uses \fBcompress\fR with the
12 bit option, since this is the least common denominator for most
sites\&. You may produce a copy of it, say \fBcompcun16\fR,
where you use 16 bit compression\&. The improvement is not too
impressive, though\&.
.FE
Alternatively, you might provide a muncher that uses \fIgzip\fR, say
\fIgzipcun\fR (to be clear: you have to write it yourself)\&.  You have
to make sure that \fIuncompress\fR on the remote site is patched to
recognize files compressed with \fIgzip\fR\&.
.P 1
If the remote site does not have an \fIuncompress\fR command, you may
specify \fInocomp\fR which does not do any compression\&.
.P 1
The last field, \fB\fItransport\fB\fR, describes the transport to be used\&.
A number of standard commands for different transports are available
whose names begin with \fIvia\fR\&. \fIsendbatches\fR passes them
the destination site name on the command line\&.  If the \fIbatchparms\fR
entry was not \fI/default/\fR, it derives the site name from the
\fB\fIsite\fB\fR field by stripping of anything after and including the first
dot or slash\&.  If entry was \fI/default/\fR, the directory names in
\fIout\&.going\fR are used\&.
.P 1
.INDEX {rnews@\fIrnews\fR}
.INDEX {uux@\fIuux\fR}
.INDEX {C News!UUCP}
There are two commands that use \fIuux\fR to execute \fIrnews\fR on
the remote system; \fIviauux\fR and \fIviauuxz\fR\&. The latter sets the
\fB-z\fR flag for (older versions of) \fIuux\fR to keep it from
returning success messages for each article delivered\&. Another command,
\fIviamail\fR, sends article batches to the user \fBrnews\fR on the
remote system via mail\&. Of course, this requires that the remote system
somehow feeds all mail for \fBrnews\fR to their local news system\&.  For
a complete list of these transports, refer to the \fInewsbatch(8)\fR
manual page\&.
.P 1
All commands from the last three fields must be located in either of
\fIout\&.going/\fR\fB\fIsite\fB\fR or \fI/usr/lib/news/bin\fR\fI/batch\fR\&.  Most of them are
scripts, so that you may easily tailor new tools for your personal
needs\&. They are invoked as a pipe\&. The list of articles is fed to the
batcher on standard input, which produces the batch on standard output\&.
This is piped into the muncher, and so on\&.
.P 1
A sample file is given below\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# batchparms file for the brewery
# site        | size   |max    |batcher  |muncher    |transport
#-------------+--------+-------+---------+-----------+-----------
/default/       100000  22      batcher   compcun     viauux
swim             10000  10      batcher   nocomp      viauux
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {C News!batch parameters|)}
.INDEX {C News!sending news|)}
.INDEX {C News!batching|)}
.INDEX {batching!news|)}
.P 1
.H 2 "Expiring News"
.SETR "cnews.explist"
.INDEX {C News!expiring|(}
.P 1
In Bnews, expiring used to be performed by a program called \fIexpire\fR,
which took a list of newsgroups as arguments, along with a time
specification after which articles had to be expired\&.  To have different
hierarchies expired at different times, you had to write a script that
invoked \fIexpire\fR for each of them separately\&.  C News offers a more
convenient solution to this: in a file called \fIexplist\fR, you may
specify newsgroups and expiration intervals\&.  A command called
\fIdoexpire\fR is usually run once a day from \fIcron\fR, and
processes all groups according to this list\&.
.P 1
.INDEX {C News!archiving}
.INDEX {news!archiving articles}
Occasionally, you may want to retain articles from certain groups even
after they have been expired; for example, you might want to keep
programs posted to \fBcomp\&.sources\&.unix\fR\&. This is called
\fIarchiving\fR\&. \fIexplist\fR permits you to mark groups for
archiving\&.
.P 1
An entry in \fIexplist\fR looks like this:
.P 1
.P 1
.DS I F 5
\fB\fB\fIgrouplist\fB\fB \fB\fIperm\fB\fB \fB\fItimes\fB\fB \fB\fIarchive\fB\fB
\"
\fR
.DE
.P 1
\fB\fIgrouplist\fB\fR is a comma-separated list of newsgroups to which
the entry applies\&. Hierarchies may be specified by giving the group
name prefix, optionally appended with \fIall\fR\&. For example, for
an entry applying to all groups below \fBcomp\&.os\fR, you might
either enter \fBcomp\&.os\fR or \fBcomp\&.os\&.all\fR in
\fB\fIgrouplist\fB\fR\&.
.P 1
When expiring news from a group, the name is checked against all
entries in \fIexplist\fR in the order given\&. The first matching entry
applies\&. For example, to throw away the majority of \fBcomp\fR after
four days, except for \fBcomp\&.os\&.linux\&.announce\fR which you want
to keep for a week, you simply have an entry for the latter,
which specifies a seven-day expiration period, followed by that for
\fBcomp\fR, which specifies four days\&.
.P 1
The \fB\fIperm\fB\fR field details if the entry applies to moderated,
unmoderated, or any groups\&. It may take the values \fIm\fR,
\fIu\fR, or \fIx\fR, which denote moderated, unmoderated, or any
type\&.
.P 1
The third field, \fB\fItimes\fB\fR, usually contains only a single number\&.
This is the number of days after which articles will be expired if they
haven't been assigned an artificial expiration date in an \fBExpires:\fR
field in the article header\&. Note that this is the number of days counting
from its \fIarrival\fR at your site, not the date of posting\&.
.P 1
The \fB\fItimes\fB\fR field may, however, be more complex than that\&.  It may
be a combination of up to three numbers, separated from one another by a
dash\&. The first denotes the number of days that have to pass before the
article is considered a candidate for expiration\&. It is rarely useful to
use a value other than zero\&. The second field is the above-mentioned
default number of days after which it will be expired\&. The third is the
number of days after which an article will be expired unconditionally,
regardless of whether it has an \fBExpires:\fR field or not\&. If only
the middle number is given, the other two take default values\&. These may
be specified using the special entry \fI/bounds/\fR, which is
described below\&.
.P 1
The fourth field, \fB\fIarchive\fB\fR, denotes whether the newsgroup is to be
archived, and where\&.  If no archiving is intended, a dash should be
used\&.  Otherwise, you either use a full path name (pointing to a
directory), or an at sign (\fI@\fR)\&. The at sign denotes the default
archive directory which must then be given to \fIdoexpire\fR by using
the \fB-a\fR flag on the command line\&.  An archive directory should
be owned by \fBnews\fR\&. When \fIdoexpire\fR archives an article from,
say \fBcomp\&.sources\&.unix\fR, it stores it in the directory
\fBcomp/sources/unix\fR below the archive directory, creating it if not
existent\&. The archive directory itself, however, will not be created\&.
.P 1
There are two special entries in your \fIexplist\fR file that
\fIdoexpire\fR relies on\&.  Instead of a list of newsgroups, they have
the keywords \fI/bounds/\fR and \fI/expired/\fR\&. The
\fI/bounds/\fR entry contains the default values for the three
values of the \fB\fItimes\fB\fR field described above\&.
.P 1
The \fI/expired/\fR field determines how long C News will hold on to
lines in the \fIhistory\fR file\&. This is needed because C News will not
remove a line from the history file once the corresponding article(s)
have been expired, but will hold on to it in case a duplicate should
arrive after this date\&. If you are fed by only one site, you can keep
this value small\&. Otherwise, a couple of weeks is advisable on UUCP
networks, depending on the delays you experience with articles from
these sites\&.
.P 1
A sample \fIexplist\fR file with rather tight expiry intervals
is reproduced below:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# keep history lines for two weeks. Nobody gets more than three months
/expired/                       x       14      -
/bounds/                        x       0-1-90  -

# groups we want to keep longer than the rest
comp.os.linux.announce          m       10      -
comp.os.linux                   x       5       -
alt.folklore.computers          u       10      -
rec.humor.oracle                m       10      -
soc.feminism                    m       10      -

# Archive *.sources groups
comp.sources,alt.sources        x       5       @

# defaults for tech groups
comp,sci                        x       7       -

# enough for a long weekend
misc,talk                       x       4       -

# throw away junk quickly
junk                            x       1       -

# control messages are of scant interest, too
control                         x       1       -

# catch-all entry for the rest of it
all                             x       2       -
.ENDVERBATIM
\"
\fR
.DE
.P 1
.INDEX {C News!update low water mark}
With expiring in C News, there are a number of potential troubles
looming\&.  One is that your newsreader might rely on the third field of
the active file, which contains the number of the lowest article
on-line\&.  When expiring articles, C News does not update this field\&. If
you need (or want) to have this field represent the real situation, you
need to run a program called \fIupdatemiin\fR after each run of
\fIdoexpire\fR\&.(\*F)
.FS
In older versions of C News, this was done by a script called
\fIupact\fR\&.
.FE
.P 1
.INDEX {C News!history file@\fIhistory\fR file}
Second, C News does not expire by scanning the newsgroup's directory,
but simply checks the \fIhistory\fR file if the article is due for
expiration\&.(\*F)
.FS
The article's date of arrival is kept in the middle field of the
history line, given in seconds since January 1, 1970\&.
.FE
If your history file somehow gets out of sync, articles may be
around on your disk forever, because C News has literally forgotten
them\&.(\*F)
.FS
I don't know \fIwhy\fR this happens, but for me, it does from time
to time\&.
.FE
You can repair this using the \fIaddmissing\fR script in
\fI/usr/lib/news/bin\fR\fI/maint\fR, which will add missing articles to the
\fIhistory\fR file, or \fImkhistory\fR, which re-builds the entire
file from scratch\&.  Don't forget to become \fBnews\fR before invoking
it, else you will wind up with a \fIhistory\fR file unreadable by
C News\&.
.P 1
.INDEX {C News!expiring|)}
.P 1
.H 2 "Miscellaneous Files"
.SETR "cnews.misc"
.P 1
There are a number of files that control C News' behavior, but are not
essential to its functioning\&. All of them reside in \fI/usr/lib/news\fR\&. We will
describe them briefly\&.
.P 1
\"
.BL 10
.LI "\fInewsgroups\fR"
.INDEX {C News!list of current groups}
This is a companion file of \fIactive\fR which contains a list
of newsgroup names, along with a one-line description of its
main topic\&.  This file is automatically updated when C News
receives a \fIchecknews\fR control message (see
section 
.GETHN "cnews.control"
\&)\&.
.P 1
.LI "\fIlocalgroups\fR"
If you have a number of local groups that you don't want C News
to complain about every time you receive a \fIchecknews\fR
message, put their names and descriptions in this file, just like
they would appear in \fInewsgroups\fR\&.
.P 1
.LI "\fImailpaths\fR"
.INDEX {C News!moderated groups}
This file contains the moderator's address for each moderated
group\&. Each line contains the group name, followed by the
moderator's email address (offset by a tab)\&.
.P 1
Two special entries are provided as default\&. These are
\fIbackbone\fR and \fIinternet\fR\&. Both provide --- in
bang-path notation --- the path to the nearest backbone site,
and the site that understands RFC 822-style addresses
(\fBuser@host\fR)\&.  The default entries are
.P 1
.P 1
.DS I F 5
\fBinternet\h'6n'backbone\h'6n'\"
\fR
.DE
.P 1
You will not have to change the \fIinternet\fR entry if you
have \fIsmail\fR or \fIsendmail\fR installed, because they
understand RFC 822-addressing\&.
.P 1
The \fIbackbone\fR entry is used whenever a user posts to a
moderated group whose moderator is not listed explicitly\&.  If
the newsgroup's name is \fBalt\&.sewer\fR, and the
\fIbackbone\fR entry contains \fB\fB\fIpath\fB\fB!%s\fR, C News
will mail the article to \fB\fB\fIpath\fB\fB!alt-sewer\fR, hoping
that the backbone machine is able to forward the article\&. To
find out which path to use, ask the news admins at the site that
feeds you\&.  As a last resort, you can also use
\fBuunet\&.uu\&.net!%s\fR\&.
.P 1
.LI "\fIdistributions\fR"
.INDEX {C News!limit a feed}
This file is not really a C News file, but it is used by some
newsreaders, and \fInntpd\fR\&. It contains the list of
distributions recognized by your site, and a description of its
(intended) effect\&. For example, Virtual Brewery has the
following file:
.P 1
.P 1
.DS I F 5
\fBworld\h'11n'    everywhere in the world
.br
local\h'11n'    Only local to this site
.br
nl\h'15n'       Netherlands only
.br
mugnet\h'10n'   MUGNET only
.br
fr\h'15n'       France only
.br
de\h'15n'       Germany only
.br
brewery\h'9n'   Virtual Brewery only
\"
\fR
.DE
.P 1
.LI "\fIlog\fR"
.INDEX {C News!log files}
This file contains a log of all C News activities\&. It is culled
regularly by running \fInewsdaily\fR; copies of the old logfiles
are kept in \fIlog\&.o\fR, \fIlog\&.oo\fR, etc\&.
.P 1
.LI "\fIerrlog\fR"
This is a log of all error messages created by C News\&. These do
not include articles junked due to wrong group, etc\&. This file
is mailed to the newsmaster (\fBusenet\fR by default)
automatically by \fInewsdaily\fR if it is found to be
non-empty\&.
.P 1
\fIerrlog\fR is cleared by \fInewsdaily\fR\&. Old copies are kept
in \fIerrlog\&.o\fR and companions\&.
.P 1
.LI "\fIbatchlog\fR"
This logs all runs of \fIsendbatches\fR\&. It is usually of scant
interest only\&. It is also attended by \fInewsdaily\fR\&.
.P 1
.LI "\fIwatchtime\fR"
This is an empty file created each time \fInewswatch\fR is run\&.
.P 1
\"
.LE
.P 1
.H 2 "Control Messages"
.SETR "cnews.control"
.INDEX {news!control messages}
.P 1
The Usenet news protocol knows a special category of articles which
evoke certain responses or actions by the news system\&. These are called
\fIcontrol\fR messages\&. They are recognized by the presence of a
\fBControl:\fR field in the article header, which contains the name of
the control operation to be performed\&. There are several types of them,
all of which are handled by shell scripts located in
\fI\fI/usr/lib/news\fI/ctl\fR\&.
.P 1
Most of these will perform their action automatically at the time
the article is processed by C News, without notifying the newsmaster\&.
By default, only \fIcheckgroups\fR messages will be handed to the
newsmaster,(\*F)
.FS
There's a funny typo in RFC 1036 (p\&.12):
``Implementors and administrators may choose to allow control
messages to be carried out automatically, or to queue them for annual
processing\&.''
.FE
but you may change this by editing the scripts\&.
.P 1
.H 3 "The cancel Message"
.SETR "cnews.control.cancel"
.INDEX {cancel control message@\fIcancel\fR control message}
.INDEX {news!cancel article}
.P 1
The most widely known message is \fIcancel\fR, with which a user may
cancel an article sent by her earlier\&. This effectively removes the
article from the spool directories, if it exists\&. The \fIcancel\fR
message is forwarded to all sites that receive news from the groups
affected, regardless of whether the article has been seen already or
not\&. This is to take into account the possibility that the original
article has been delayed over the cancellation message\&. Some news
systems allow users to cancel other person's messages; this is of course
a definite no-no\&.
.P 1
.H 3 "newgroup and rmgroup"
.SETR "cnews.control.addgroup"
.SETR "cnews.control.rmgroup"
.INDEX {newgroup control message@\fInewgroup\fR control message}
.INDEX {rmgroup control message@\fIrmgroup\fR control message}
.INDEX {news!add new group}
.INDEX {news!remove old group}
.P 1
Two messages dealing with creation or removal of newsgroups are the
\fInewgroup\fR and \fIrmgroup\fR message\&. Newsgroups below the
``usual'' hierarchies may be created only after a discussion and voting
has been held among Usenet readers\&. The rules applying to the \fBalt\fR
hierarchy allow for something close to anarchy\&.  For more information,
see the regular postings in \fBnews\&.announce\&.newusers\fR and
\fBnews\&.announce\&.newgroups\fR\&.  Never send a \fInewgroup\fR or
\fIrmgroup\fR message yourself unless you definitely know that you
are allowed to\&.
.P 1
.H 3 "The checkgroups Message"
.SETR "cnews.control.checkgroups"
.INDEX {checkgroups control message@\fIcheckgroups\fR control message}
.INDEX {C News!update active file@update \fIactive\fR file}
.INDEX {news!update active file@update \fIactive\fR file}
.P 1
\fIcheckgroups\fR messages are sent by news administrators to make
all sites within a network synchronize their \fIactive\fR files with
the realities of Usenet\&. For example, commercial Internet service
providers might send out such a message to their customers' sites\&.  Once
a month, the ``official'' \fIcheckgroups\fR message for the major
hierarchies is posted to \fBcomp\&.announce\&.newgroups\fR by its
moderator\&.  However, it is posted as an ordinary article, not as a
control message\&. To perform the \fIcheckgroups\fR operation, save
this article to a file, say \fI/tmp/check\fR, remove everything up to
the beginning of the control message itself, and feed it to the
\fIcheckgroups\fR script using the following command:
.P 1
.P 1
.DS I F 5
\fB# su news -c "\fI/usr/lib/news/bin\fB/ctl/checkgroups" < /tmp/check
\"
\fR
.DE
.P 1
This will update your \fInewsgroups\fR file, adding the groups
listed in \fIlocalgroups\fR\&. The old \fInewsgroups\fR file will be 
moved to \fInewsgroups\&.bac\fR\&. Note that posting the message locally
will rarely work, because \fIinews\fR refuses to accept that large
an article\&.
.P 1
If C News finds mismatches between the \fIcheckgroups\fR list and the
\fIactive\fR file, it will produce a list of commands that would bring
your site up to date, and mail it to the news administrator\&. The output
typically looks like this:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
From news Sun Jan 30 16:18:11 1994
Date: Sun, 30 Jan 94 16:18 MET
From: news (News Subsystem)
To: usenet
Subject: Problems with your active file

The following newsgroups are not valid and should be removed.
        alt.ascii-art
        bionet.molbio.gene-org
        comp.windows.x.intrisics
        de.answers

You can do this by executing the commands:
         /usr/lib/news/bin/maint/delgroup alt.ascii-art
         /usr/lib/news/bin/maint/delgroup bionet.molbio.gene-org
         /usr/lib/news/bin/maint/delgroup comp.windows.x.intrisics
         /usr/lib/news/bin/maint/delgroup de.answers

The following newsgroups were missing.
        comp.binaries.cbm
        comp.databases.rdb
        comp.os.geos
        comp.os.qnx
        comp.unix.user-friendly
        misc.legal.moderated
        news.newsites
        soc.culture.scientists
        talk.politics.crypto
        talk.politics.tibet

.ENDVERBATIM
\"
\fR
.DE
.P 1
When you receive a message like this from your news system, don't
believe it blindly\&. Depending on who sent the \fIcheckgroups\fR
message, it may lack a few groups or even entire hierarchies; so
you should be careful about removing any groups\&. If you find
groups are listed as missing that you want to carry at your site, 
you have to add them using the \fIaddgroup\fR script\&. Save the list
of missing groups to a file and feed it to the following little
script:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#!/bin/sh
cd /usr/lib/news

while read group; do
    if grep -si "^$group[[:space:]].*moderated" newsgroup; then
        mod=m
    else
        mod=y
    fi
    /usr/lib/news/bin/maint/addgroup $group $mod
done
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 3 "sendsys, version, and senduuname"
.SETR "cnews.control.sendsys"
.SETR "cnews.control.version"
.SETR "cnews.control.uuname"
.INDEX {senduuname control message@\fIcheckgroups\fR control message}
.INDEX {sendsys control message@\fIcheckgroups\fR control message}
.INDEX {version control message@\fIcheckgroups\fR control message}
.P 1
Finally, there are three messages that may be used to find out about the
network's topology\&. These are \fIsendsys\fR, \fIversion\fR, and
\fIsenduuname\fR\&. They cause C News to return to the sender the
\fIsys\fR file, a software version string, and the output of
\fIuuname(1)\fR, respectively\&. C News is very laconic about
\fIversion\fR messages; it returns a simple, unadorned ``C''\&.
.P 1
Again, you should \fInever\fR issue such a message, unless you have made
sure that it cannot leave a your (regional) network\&. Replies to
\fIsendsys\fR messages can quickly bring down a UUCP
network\&.(\*F)
.FS
I wouldn't try this on the Internet, either\&.
.FE
.P 1
.H 2 "C News in an NFS Environment"
.SETR "cnews.nfs"
.INDEX {configuring!C News on a LAN}
.INDEX {C News!LAN}
.INDEX {LAN!news}
.P 1
A simple way to distribute news within a local network is to keep all
news on a central host, and export the relevant directories via NFS, so
that newsreaders may scan the articles directly\&.  The advantage of this
method over NNTP is that the overhead involved in retrieving and
threading articles is significantly lower\&. NNTP, on the other hand, wins
in a heterogeneous network where equipment varies widely among hosts, or
where users don't have equivalent accounts on the server machine\&.
.P 1
When using NFS, articles posted on a local host have to be forwarded to
the central machine, because accessing adminstrative files might
otherwise expose the system to race-conditions that leave the files
inconsistent\&. Also, you might want to protect your news spool area by
exporting it read-only, which requires forwarding to the central
machine, too\&.
.P 1
C News handles this transparently\&. When you post an article, your
newsreader usually invokes \fIinews\fR to inject the article into the
news system\&. This command runs a number of checks on the article,
completes the header, and checks the file \fIserver\fR in \fI/usr/lib/news\fR\&. If
this file exists and contains a hostname different from the local host's
name, \fIinews\fR is invoked on that server host via \fIrsh\fR\&. Since
the \fIinews\fR script uses a number of binary commands and support files
from C News, you have to either have C News installed locally, or mount
the news software from the server\&.
.P 1
For the \fIrsh\fR invocation to work properly, each user must have an
equivalent account on the server system, i\&.e\&. one to which she can log
in without being asked for a password\&.
.P 1
Make sure that the hostname given in \fIserver\fR literally matches the
output of the \fIhostname(1)\fR command on the server machine, else
C News will loop forever when trying to deliver the article\&.
.P 1
.H 2 "Maintenance Tools and Tasks"
.SETR "cnews.maint"
.P 1
Despite the complexity of C News, a news administrator's life
can be fairly easy, because C News provides you with a wide variety
of maintenance tools\&.  Some of these are intended to be run regularly
from \fIcron\fR, like \fInewsdaily\fR\&.  Using these scripts reduces
daily care and feeding requirements of your C News installation greatly\&.
.P 1
Unless stated otherwise, these commands are located in
\fI/usr/lib/news/bin\fR\fI/maint\fR\&.  Note that you must become user \fBnews\fR
before invoking these commands\&. Running them as super-user may render
these files inaccessible to C News\&.
.P 1
\"
.BL 10
.LI "\fInewsdaily\fR"
The name already says it: runs this once a day\&.  It is an
important script that helps you keep log files small, retaining
copies of each from the last three runs\&.  It also tries to sense
any anomalies, like stale batches in the incoming and outgoing
directories, postings to unkown or moderated newsgroups, etc\&.
Resulting error messages will be mailed to the newsmaster\&.
.P 1
.LI "\fInewswatch\fR"
This is a script that should be run regularly to look for
anomalies in the news system, once an hour or so\&. It is intended
to detect problems that will have immediate effect on the
operability of your news system and mail a trouble report to the
newsmaster\&.  Things checked include stale lock files that don't
get removed, unattended input batches, and disk space shortage\&.
.P 1
.LI "\fIaddgroup\fR"
Adds a group to your site locally\&. The proper invocation is
.P 1
.P 1
.DS I F 5
\fBaddgroup \fB\fIgroupname\fB\fB y|n|m|=\fB\fIrealgroup\fB\fB
\"
\fR
.DE
.P 1
The second argument has the same meaning as the flag in the
\fIactive\fR file, meaning that anyone may post to the group
(\fIy\fR), that no-one may post (\fIn\fR), that it is
moderated (\fIm\fR), or that it is an alias for another
group (\fI=\fB\fIrealgroup\fB\fI\fR)\&.
.P 1
You might also want to use \fIaddgroup\fR when the first
articles in a newly created group arrive earlier than the
\fInewgroup\fR control message that is intended to create
it\&.
.P 1
.LI "\fIdelgroup\fR"
Allows you to delete a group locally\&. Invoke it as
.P 1
.P 1
.DS I F 5
\fBdelgroup \fB\fIgroupname\fB\fB
\"
\fR
.DE
.P 1
You still have to delete the articles that remain in the
newsgroup's spool directory\&. Alternatively, you might leave
it to the natural course of events (a\&.k\&.a\&. \fIexpire\fR) to
make them go away\&.
.P 1
.LI "\fIaddmissing\fR"
Adds missing articles to the \fIhistory\fR file\&. Run this script
when there are articles that seem to hang around forever\&.(\*F)
.FS
Ever wondered how to get rid of that ``Help! I can't get X11 to
work with 0\&.97\&.2!!!'' article?
.FE
.P 1
.LI "\fInewsboot\fR"
This script should be run at system boot time\&. It removes any lock files
left over when news processes were killed at shutdown, and closes
and executes any batches left over from NNTP connections that were
terminated when shutting down the system\&.
.P 1
.LI "\fInewsrunning\fR"
This resides in \fI/usr/lib/news/bin\fR\fI/input\fR, and may be used to
disable unbatching of incoming news, for instance during work
hours\&. You may turn off unbatching by invoking
.P 1
.P 1
.DS I F 5
\fB\fI/usr/lib/news/bin\fB/input/newsrunning off
\"
\fR
.DE
.P 1
It is turned on by using \fIon\fR instead of \fIoff\fR\&.
.P 1
\"
.LE
.P 1
.INDEX {configuring!C News|)}
.INDEX {configuring!Usenet news|)}
.INDEX {C News|)}
.P 1
.H 1 "A Description of NNTP"
.SETR "nntp"
.INDEX {configuring!NNTP|(}
.INDEX {protocol!NNTP}
.INDEX {news!nntpd@\fInntpd\fR}
.INDEX {server!NNTP}
.INDEX {NNTP}
.P 1
.H 2 "Introduction"
Due to the different network transport used, NNTP provides for a vastly
different approach to news exchange from C news\&.  NNTP stands for
``Network News Transfer Protocol'', and is not a particular software
package, but an Internet Standard\&.(\*F)
.FS
Formally specified in RFC 977\&.
.FE
It is based on a stream-oriented connection -- usually over TCP --
between a client anywhere in the network, and a server on a host that keeps
netnews on disk storage\&. The stream connection allows the client and server
to interactively negotiate article transfer with nearly no turnaround
delay, thus keeping the number of duplicate articles low\&. Together with the
Internet's high transfer rates, this adds up to a news transport that
surpasses the original UUCP networks by far\&. While some years ago it was
not uncommon for an article to take two weeks or more before it arrived in
the last corner of Usenet, this is now often less than two days; on the
Internet itself, it is even within the range of minutes\&.
.P 1
Various commands allow clients to retrieve, send and post articles\&.
The difference between sending and posting is that the latter may
involve articles with incomplete header information\&.(\*F)
.FS
When posting an article over NNTP, the server always adds at least one
header field, which is \fBNntp-Posting-Host:\fR\&. It contains the
client's host name\&.
.FE
Article retrieval may be used by news transfer clients as well as
newsreaders\&. This makes NNTP an excellent tool for providing news access to
many clients on a local network without going through the contortions that
are necessary when using NFS\&.
.P 1
.INDEX {news!pushing}
.INDEX {news!pulling}
NNTP also provides for an active and a passive way of news transfer,
colloquially called ``pushing'' and ``pulling''\&. Pushing is basically
the same as the C news ihave/sendme protocol\&. The client offers an
article to the server through the ``\fIIHAVE <varmsgid>\fR''
command, and the server returns a response code that indicates whether
it already has the article, or if it wants it\&. If so, the client sends
the article, terminated by a single dot on a separate line\&.
.P 1
Pushing news has the single disadvantage that it places a heavy load on
the server system, since it has to search its history database for every
single article\&.
.P 1
The opposite technique is pulling news, in which the client requests a
list of all (available) articles from a group that have arrived after a
specified date\&. This query is performed by the \fINEWNEWS\fR
command\&. From the returned list of message ids, the client selects those
articles it does not yet have, using the \fIARTICLE\fR command for
each of them in turn\&.
.P 1
The problem with pulling news is that it needs tight control by the server
over which groups and distributions it allows a client to request\&. For
example, it has to make sure that no confidential material from newsgroups
local to the site are sent to unauthorized clients\&.
.P 1
There are also a number of convenience commands for newsreaders that
permit them to retrieve the article header and body separately, or even
single header lines from a range of articles\&. This lets you keep all
news on a central host, with all users on the (presumably local) network
using NNTP-based client programs for reading and posting\&. This is an
alternative to exporting the news directories via NFS which is described
in chapter 
.GETHN "cnews"
\&\&.
.P 1
.INDEX {news!faking}
An overall problem of NNTP is that it allows the knowledgeable to insert
articles into the news stream with false sender specification\&. This is
called \fInews faking\fR\&.(\*F)
.FS
The same problem exists with SMTP, the Simple Mail Transfer Protocol\&.
.FE
An extension to NNTP allows to require a user authentication for
certain commands\&.
.P 1
.INDEX {nntpd@\fInntpd\fR}
.INDEX {Lapsley, Phil}
.INDEX {Barber, Stan}
There are a number of NNTP packages available\&. One of the more widely known
is the NNTP daemon, also known as the \fIreference implementation\fR\&.
Originally, it was written by Stan Barber and Phil Lapsley to illustrate
the details of RFC 977\&.  Its most recent version is \fInntpd-1\&.5\&.11\fR,
which will be described below\&.  You may either get the sources and compile
it yourself, or use the \fInntpd\fR from Fred van Kempen's \fInet-std\fR
binary package\&.  No ready-to-go binaries of \fInntpd\fR are provided,
because of various site-specific values that must be compiled in\&.
.P 1
The \fInntpd\fR package consists of a server and two clients for
pulling and pushing news, respectively, as well as an \fIinews\fR
replacement\&. They live in a Bnews environment, but with a little
tweaking, they will be happy with C news, too\&.  However if you plan to
use NNTP for more than offering newsreaders access to your news server,
the reference implementation is not really an option\&.  We will therefore
discuss only the NNTP daemon contained in the \fInntpd\fR package, and
leave out the client programs\&.
.P 1
.INDEX {Salz, Rich}
.INDEX {INN}
There is also a package called ``InterNet News'', or INN for short, that was
written by Rich Salz\&.  It provides both NNTP and UUCP-based news
transport, and is more suitable for large news hubs\&.  When it comes to
news transport over NNTP, it is definitely better than \fInntpd\fR\&.
INN is currently at version \fIinn-1\&.4sec\fR\&.  There is a kit for
building INN on a Linux machine from Arjan de Vet; it is available
from \fBsunsite\&.unc\&.edu\fR in the \fIsystem/Mail\fR directory\&.  If you
want to set up INN, please refer to the documentation that comes along
with the source, as well as the INN FAQ posted regularly to
\fBnews\&.software\&.b\fR\&.
.P 1
.H 2 "Installing the NNTP server"
.SETR "nntp.nntpd"
.P 1
The NNTP server is called \fInntpd\fR, and may be compiled in two ways,
depending on the expected load on the news system\&.  There are no compiled
versions available, because of some site-specific defaults that are
hard-coded into the executable\&.  All configuration is done through
macro definines in \fIcommon/conf\&.h\fR\&.
.P 1
\fInntpd\fR may be configured as either a standalone server that is
started at system boot time from \fIrc\&.inet2\fR, or a daemon managed by
\fIinetd\fR\&.  In the latter case you have to have the following entry in
\fI/etc/inetd\&.conf\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
nntp    stream  tcp nowait      news    /usr/etc/in.nntpd    nntpd
.ENDVERBATIM
\"
\fR
.DE
.P 1
If you configure \fInntpd\fR as standalone, make sure that any such
line in \fIinetd\&.conf\fR is commented out\&. In either case, you have to
make sure there's the following line in \fI/etc/services\fR:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
nntp    119/tcp   readnews untp    # Network News Transfer Protocol
.ENDVERBATIM
\"
\fR
.DE
.P 1
To temporarily store any incoming articles, etc, \fInntpd\fR also needs
a \fI\&.tmp\fR directory in your news spool\&. You should create it using
.P 1
.P 1
.DS I F 5
\fB# mkdir \fI/var/spool/news\fB/\&.tmp
.br
# chown news\&.news \fI/var/spool/news\fB/\&.tmp
\"
\fR
.DE
.P 1
.H 2 "Restricting NNTP Access"
.SETR "nntp.access"
.INDEX {NNTP!restricting access}
.INDEX {nntpaccess@\fInntp_access\fR}
.INDEX {access!NNTP}
.P 1
Access to NNTP resources is governed by the file \fInntp_access\fR in
\fI/usr/lib/news\fR\&. Lines in the file describe the access rights granted to
foreign hosts\&.  Each line has the following format:
.P 1
.P 1
.DS I F 5
\fB\fIsite\fB   read|xfer|both|no    post|no      [!\fIexceptgroups\fB]
\"
\fR
.DE
.P 1
If a client connects to the NNTP port, \fInntpd\fR attempts to obtain the
host's fully qualified domain name from its IP address by reverse lookup\&.
The client's hostname and IP address are checked against the \fB\fIsite\fB\fR
field of each entry in the order in which they appear in the file\&.
Matches may be either partial or exact\&. If an entry matches exactly, it
applies; if the match is partial, it only applies if there is no other
match following which is at least as good\&.  \fB\fIsite\fB\fR may be specified
in one of the following ways:
.P 1
\"
.BL 10
.LI "\fB\fIhostname\fB\fR"
This is a fully qualified domain name of a host\&. If this matches
the client's canonical hostname literally, the entry applies,
and all following entries are ignored\&.
.P 1
.LI "\fB\fIIP address\fB\fR"
This is an IP address in dotted quad notation\&.  If the client's
IP address matches this, the entry applies, and all following
entries are ignored\&.
.P 1
.LI "\fB\fIdomain name\fB\fR"
This is a domain name, specified as \fB*\&.\fR\fB\fIdomain\fB\fR\&. If
the client's hostname matches the domain name, the entry
matches\&.
.P 1
.LI "\fB\fInetwork name\fB\fR"
This is the name of a network as specified in
\fI/etc/networks\fR\&.  If the network number of the client's
IP address matches the network number associated with the
network name, the entry matches\&.
.P 1
.LI "\fIdefault\fR"
The \fIdefault\fR matches any client\&.
.P 1
\"
.LE
.P 1
Entries with a more general site specification should be specified earlier,
because any matches by these will be overridden by later, more exact
matches\&.
.P 1
The second and third field describe the access rights granted to the
client\&. The second details the permissions to retrieve news by pulling
(\fIread\fR), and transmit news by pushing (\fIxfer\fR)\&.  A
value of \fIboth\fR enables both, \fIno\fR denies access
altogether\&. The third field grants the client the right to post
articles, that is, deliver articles with incomplete header information
which is completed by the news software\&.  If the second field contains
\fIno\fR, the third field is ignored\&.
.P 1
The fourth field is optional, and contains a comma-separated list of
groups the client is denied access to\&.
.P 1
A sample \fInntp_access\fR file is shown below:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# by default, anyone may transfer news, but not read or post
default                 xfer            no
#
# public.vbrew.com offers public access via modem, we allow
# them to read and post to any but the local.* groups
public.vbrew.com        read            post    !local
#
# all other hosts at the brewery may read and post
*.vbrew.com             read            post
.ENDVERBATIM
\"
\fR
.DE
.P 1
.H 2 "NNTP Authorization"
.SETR "nntp.authorize"
.INDEX {NNTP!authorization}
.INDEX {NNTP!restricting access}
.INDEX {access!NNTP}
.INDEX {authorization!with NNTP}
.P 1
When capitalizing the access tokens like \fIxfer\fR or
\fIread\fR in the \fInntp_acces\fR file, \fInntpd\fR requires the
authorization from the client for the respective operations\&. For
instance, when specifying a permission of \fIXfer\fR or
\fIXFER\fR, \fInntpd\fR will not let the client transfer articles
to your site unless it passes authorization\&.
.P 1
The authorization procedure is implemented by means of a new NNTP
command named \fIAUTHINFO\fR\&. Using this command, the client
transmits a user name and a password to the NNTP server\&.  \fInntpd\fR
will validate them by checking them against the \fI/etc/passwd\fR
database, and verify that the user belongs to the \fBnntp\fR group\&.
.P 1
The current implementation of NNTP authorization is only experimental,
and has therefore not been implemented very portably\&.  The result of
this is that it works only with plain-style password databases; shadow
passwords will not be recognized\&.
.P 1
.H 2 "nntpd Interaction with C News"
.SETR "nntp.interact"
.INDEX {C News!NNTP support}
.INDEX {NNTP!and C News}
.P 1
When receiving an article, \fInntpd\fR has to deliver it to the news
subsystem\&. Depending on whether it was received as a result of an
\fIIHAVE\fR or \fIPOST\fR command, the article is handed to
\fIrnews\fR or \fIinews\fR, respectively\&. Instead of invoking
\fIrnews\fR, you may also configure it (at compile time) to batch the
incoming articles and move the resulting batches to
\fI/var/spool/news\fR\fI/in\&.coming\fR, where they are left for \fIrelaynews\fR to
pick them up at the next queue run\&.
.P 1
To be able to properly perform the ihave/sendme protocol, \fInntpd\fR
has to be able to access the \fIhistory\fR file\&. At compile time, you
therefore have to make sure the path is set correctly\&.  You should also
make sure that C news and \fInntpd\fR agree on the format of your
history file\&. C news uses \fIdbm\fR hashing functions to access it;
however, there are quite a number of different and slightly incompatible
implementations of the \fIdbm\fR library\&.  If C news has been linked
with the a different \fIdbm\fR library than you have in your standard
\fIlibc\fR, you have to link \fInntpd\fR with this library, too\&.
.P 1
.INDEX {checking!NNTP}
A typical symptom of \fInntpd\fR and C news disagreeing on the database
format are error messages in the system log that \fInntpd\fR could not
open it properly, or duplicate articles received via NNTP\&.  A good test
is to pick an article from your spool area, telnet to the \fInntp\fR
port, and offer it to \fInntpd\fR as shown in the example below (your
input is marked \fB\fIlike this\fB\fR)\&.  Of course, you have to replace
\fB\fI<msg@id>\fB\fR with the message-ID of the article you want to feed
to \fInntpd\fR again\&.
.P 1
.P 1
.DS I F 5
\fB\fB$ \fB\fItelnet localhost nntp\fB\fB		
.br
Trying 127\&.0\&.0\&.1\&.\&.\&.			
.br
Connected to loalhost			
.br
Escape characters is '^]'\&.		
.br
201 vstout NNTP[auth] server version 1\&.5\&.11t (16 November 1991) ready at
Sun Feb 6 16:02:32 1194 (no posting)	
.br
\fB\fIIHAVE <msg@id>\fB\fB		
.br
435 Got it\&.				
.br
\fB\fIQUIT\fB\fB
\"
\fB\fR
.DE
.P 1
This conversation shows the proper reaction of \fInntpd\fR; the message
``\fBGot it\fR'' tells you that it already has this article\&. If you get
a message of ``\fB335 Ok\fR'' instead, the lookup in the history file
failed for some reason\&. Terminate the conversation by typing Ctrl-D\&.
You can check what has gone wrong by checking the system log;
\fInntpd\fR logs all kinds of messages to the \fIdaemon\fR facility
of \fIsyslog\fR\&.  An incompatible \fIdbm\fR library usually manifests
itself in a message complaining that \fIdbminit\fR failed\&.
.P 1
.INDEX {configuring!NNTP|)}
.P 1
.H 1 "Newsreader Configuration"
.SETR "newsreaders"
.INDEX {news!reader|see newsreader}
.INDEX {newsreader!configuring}
.INDEX {configuring!newsreader}
.P 1
Newsreaders are intended to offer the user functionality that allows her
to access the functions of the news system easily, like posting
articles, or skimming the contents of a newsgroup in a comfortable way\&.
The quality of this interface is subject of endless flame wars\&.
.P 1
There are a couple of newsreaders available which have been ported to
Linux\&. Below I will describe the basic setup for the three most
popular ones, namely \fItin\fR, \fItrn\fR, and \fInn\fR\&.
.P 1
One of the most effective newsreaders is
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
$ find /var/spool/news -name '[0-9]*' -exec cat {} \; | more
.ENDVERBATIM
\"
\fR
.DE
.P 1
This is the way Un*x die-hards read their news\&.
.P 1
The majority of newsreaders, however, are much more sophisticated\&.
They usually offer a full-screen interface with separate levels for
displaying all groups the user has subscribed to, for displaying an
overview of all articles in one group\&. and for individual articles\&.
.P 1
At the newsgroup level, most newsreaders display a list of articles,
showing their subject line, and the author\&. In big groups, it is impossible
for the user to keep track of articles relating to each other, although
it is possible to identify responses to earlier articles\&.
.P 1
.INDEX {newsreader!threading}
.INDEX {news!follow-up}
A response usually repeats the original article's subject, prepending it
with ``\fBRe: \fR''\&. Additionally, the message id of the article it is
a direct follow-up to may be given in the \fBReferences:\fR header
line\&. Sorting articles by these two criteria generates small clusters
(in fact, trees) of articles, which are called \fIthreads\fR\&. One of the
tasks in writing a newsreader is devising an efficient scheme of
threading, because the time required for this is proportional to the
square of the number of articles\&.
.P 1
Here, we will not dig any further into how the user interfaces are
built\&. All newsreaders currently available for Linux have a good help
function, so you ought to get along\&.
.P 1
In the following, we will only deal with administrative tasks\&. Most of
these relate to the creation of threads databases and accounting\&.
.P 1
.H 2 "tin Configuration"
.SETR "newsreaders.tin"
.INDEX {newsreader!tass@\fItass\fR}
.INDEX {newsreader!tin@\fItin\fR}
.INDEX {tass@\fItass\fR}
.INDEX {tin@\fItin\fR}
.P 1
The most versatile newsreader with respect to threading is \fItin\fR\&.
It was written by Iain Lea and is loosely modeled on an older newsreader
named \fItass\fR\&.(\*F)
.FS
Written by Rich Skrenta\&.
.FE
It does its threading when the user enters the newsgroup, and it is
pretty fast at this unless you're doing this via NNTP\&.
.P 1
.INDEX {newsreader!threading}
.INDEX {INN}
On an 486DX50, it takes roughly 30 seconds to thread 1000 articles when
reading directly from disk\&.  Over NNTP to a loaded news server, this
would be somewhere above 5 minutes\&.(\*F)
.FS
Things improve drastically if the NNTP
server does the threading itself, and lets the client retrieve the
threads databases; INN-1\&.4 does this, for instance\&.
.FE
You may improve this by regularly updating your index file with the
\fB-u\fR option, or by invoking \fItin\fR with the \fB-U\fR
option\&.
.P 1
Usually, \fItin\fR dumps its threading databases in the user's
home directory below \fI\&.tin/index\fR\&. This may however be costly
in terms of resources, so that you should want to keep a single copy
of them in a central location\&. This may be achieved by making \fItin\fR
setuid to \fBnews\fR, for example, or some entirely unprivileged
account\&.(\*F)
.FS
However, do \fInot\fR use \fBnobody\fR for this\&. As a rule, no files
or commands whatsoever should be associated with this user\&.
.FE
\fItin\fR will then keep all thread databases below
\fI/var/spool/news/\&.index\fR\&.
For any file access or shell escape, it will reset its effective uid to
the real uid of the user who invoked it\&.(\*F)
.FS
This is the reason why you will get ugly error messages when invoking
it as super user\&. But then, you shouldn't work as \fBroot\fR, anyway\&.
.FE
.P 1
.INDEX {newsreader!creating thread databases}
A better solution is to install the \fItind\fR indexing daemon that
runs as a daemon and regularly updates the index files\&.  This daemon is
however not included in any release of Linux, so you would have to
compile it yourself\&. If you are running a LAN with a central news
server, you may even run \fItind\fR on the server and have all clients
retrieve the index files via NNTP\&. This, of course, requires an
extension to NNTP\&. Patches for \fInntpd\fR that implement this
extension are included in the \fItin\fR source\&.
.P 1
The version of \fItin\fR included in some Linux distributions has no
NNTP support compiled in, but most do have it now\&.  When invoked as
\fIrtin\fR or with the \fB-r\fR option, \fItin\fR tries to connect
to the NNTP server specified in the file \fI/etc/nntpserver\fR or in
the \fBNNTPSERVER\fR environment variable\&.  The \fInntpserver\fR
file simply contains the server's name on a single line\&.
.P 1
.H 2 "trn Configuration"
.SETR "newsreaders.trn"
.INDEX {newsreader!trn@\fItrn\fR}
.INDEX {trn@\fItrn\fR}
.P 1
\fItrn\fR is the successor to an older newsreader, too, namely
\fIrn\fR (which means \fIread news\fR)\&. The ``t'' in its name stands
for ``threaded''\&.  It was written by Wayne Davidson\&.
.P 1
.INDEX {newsreader!creating thread databases}
Unlike \fItin\fR, \fItrn\fR has no provision for generating its
threading database at run-time\&. Instead, it uses those prepared by a
program called \fImthreads\fR that has to be invoked regularly from
\fIcron\fR to update the index files\&.
.P 1
.INDEX {mthreads@\fImthreads\fR}
Not running \fImthreads\fR, however, doesn't mean you cannot access new
articles, it only means you will have all those ``Novell buys out
Linix!!'' articles scattered across your article selection menu,
instead of a single thread you may easily skip\&.
.P 1
To turn on threading for particular newsgroups, \fImthreads\fR is
invoked with the list of newsgroups on the command line\&.  The list is
made up in exactly the same fashion as the one in the \fIsys\fR file:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
mthreads comp,rec,!rec.games.go
.ENDVERBATIM
\"
\fR
.DE
.P 1
.br
.ti 0
will enable threading for all of \fBcomp\fR and \fBrec\fR, except for
\fBrec\&.games\&.go\fR (people who play Go don't need fancy threads)\&. After
that, you simply invoke it without any option at all to make it thread
any newly arrived articles\&.  Threading of all groups found in your
\fIactive\fR file can be turned on by invoking \fImthreads\fR with a
group list of \fBall\fR\&.
.P 1
If you're receiving news during the night, you will customarily run
\fImthreads\fR once in the morning, but you can also to do so more
frequently if needed\&.  Sites that have very heavy traffic may want to
run \fImthreads\fR in daemon mode\&.  When it is started at boot time using
the \fB-d\fR option, it puts itself in the background, and wakes up
every 10 minutes to check if there are any newly-arrived articles, and
threads them\&. To run \fImthreads\fR in daemon mode, put the following
line in your \fIrc\&.news\fR script:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
/usr/local/bin/rn/mthreads -deav
.ENDVERBATIM
\"
\fR
.DE
.P 1
The \fB-a\fR option makes \fImthread\fR automatically turn on threading
for new groups as they are created; \fB-v\fR enables verbose log
messages to \fImthreads\fR' log file, \fImt\&.log\fR in the directory
where you have \fItrn\fR installed\&.
.P 1
.INDEX {C News!update low water mark}
.INDEX {news!expiring}
Old articles no longer available must be removed from the index files
regularly\&.  By default, only articles whose number is below the low
water mark will be removed\&.(\*F)
.FS
Note that C news doesn't update this low water mark automatically;
you have to run \fIupdatemin\fR to do so\&. Please refer to
chapter 
.GETHN "cnews"
\&\&.
.FE
Articles above this number who have been expired nevertheless (because
the oldest article has been assigned an long expiry date by an
\fBExpires:\fR header field) may be removed by giving \fImthreads\fR
the \fB-e\fR option to force an ``enhanced'' expiry run\&. When
\fImthreads\fR is running in daemon mode, the \fB-e\fR option makes
it put in such an enhanced expiry run once a day, shortly after
midnight\&.
.P 1
.H 2 "nn Configuration"
.SETR "newsreaders.nn"
.INDEX {newsreader!nn@\fInn\fR}
.INDEX {nn@\fInn\fR}
.INDEX {Storm, Kim F\&.}
.P 1
\fInn\fR, written by Kim F\&. Storm, claims to be a newsreader whose
ultimate goal is not to read news\&. It's name stands for ``No News'', and
its motto is ``No news is good news\&. \fInn\fR is better\&.''
.P 1
To achieve this ambitious goal, \fInn\fR comes along with a large
assortment of maintenance tools that not only allow generation of
threads, but also extensive checks on the consistency of these
databases, accounting, gathering of usage statistics, and access
restrictions\&. There is also an administration program called
\fInnadmin\fR, which allows you to perform these tasks interactively\&.
It is very intuitive, hence we will not dwell on these aspects, and only
deal with the generation of the index files\&.
.P 1
.INDEX {newsreader!creating thread databases}
The \fInn\fR threads database manager is called \fInnmaster\fR\&.  It is
usually run as a daemon, started from the \fIrc\&.news\fR or
\fIrc\&.inet2\fR script\&.  It is invoked as
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
/usr/local/lib/nn/nnmaster -l -r -C
.ENDVERBATIM
\"
\fR
.DE
.P 1
This enables threading for all newsgroups present in your \fIactive\fR
file\&.
.P 1
Equivalently, you may invoke \fInnmaster\fR periodically from
\fIcron\fR, giving it a list of groups to act upon\&. This list is very
similar to the subscription list in the \fIsys\fR file, except that it
uses blanks instead of commas\&. Instead of the fake group name
\fBall\fR, an empty argument of \fB""\fR should be used to
denote all groups\&.  A sample invocation is
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# /usr/local/lib/nn/nnmaster !rec.games.go rec comp
.ENDVERBATIM
\"
\fR
.DE
.P 1
Note that the order is significant here: The leftmost group
specification that matches always wins\&. Thus, if we had put
\fI!rec\&.games\&.go\fR after \fIrec\fR, all articles from this
group had been threaded nevertheless\&.
.P 1
.INDEX {news!expiring}
\fInn\fR offers several methods to remove expired articles from its
databases\&.  The first is to update the database by scanning the news
group directories and discarding the entries whose corresponding article
is no longer available\&.  This is the default operation obtained by
invoking \fInnmaster\fR with the \fB-E\fR option\&. It is reasonably
fast unless you're doing this via NNTP\&.  
.P 1
Method 2 behaves exactly like a default expiry run of \fImthreads\fR,
in that it only removes those entries that refer to articles whose
number is below the low water mark in the \fIactive\fR file\&. It may be
enabled using the \fB-e\fR option\&.
.P 1
Finally, a third strategy is to discard the entire database and
recollect all articles\&. This may be done by giving \fB-E3\fR to
\fInnmaster\fR\&.
.P 1
The list of groups to be expired is given by the \fB-F\fR option in
the same fashion as above\&.  However, if you have \fInnmaster\fR running
as daemon, you must kill it (using \fB-k\fR) before expiry can take
place, and to re-start it with the original options afterwards\&.  Thus
the proper command to run expire on all groups using method 1 is:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# nnmaster -kF ""
# nnmaster -lrC
.ENDVERBATIM
\"
\fR
.DE
.P 1
There are many more flags that may be used to fine-tune the behavior of
\fInn\fR\&. If you are concerned about removing bad articles or
digestifying article digests, read the \fInnmaster\fR manual page\&.
.P 1
\fInnmaster\fR relies on a file named \fIGROUPS\fR, which is located
in \fI/usr/local/lib/nn\fR\&. If it does not exist initially, it is
created\&.  For each newsgroup, it contains a line that begins with the
group's name, optionally followed by a time stamp, and flags\&. You may
edit these flags to enable certain behavior for the group in question,
but you may not change the order in which the groups appear\&.(\*F)
.FS
This is because their order has to agree with that of the entries in the
(binary) \fIMASTER\fR file\&.
.FE
The flags allowed and their effects are detailed in the
\fInnmaster\fR manual page, too\&.
.P 1
\"
.P 1
.APP "" "A Null Printer Cable for PLIP"
.SETR "appendix.plip"
To make a Null Printer Cable for use with a PLIP connection, you need
two 25-pin connectors (called DB-25) and some 11-conductor cable\&.
The cable must be at most 15 meters long\&.
.P 1
If you look at the connector, you should be able to read tiny numbers
at the base of each pin, from 1 for the pin top left (if you hold the 
broader side up) to 25 for the pin bottom right\&. For the Null Printer 
cable, you have to connect the following pins of both connectors
with each other:
.P 1
.ti 0		
.TS
box tab(&);
l r r l.
\fBD0\fR &2 &15 &\fBERROR\fR 
\fBD1\fR &3 &13 &\fBSLCT\fR 
\fBD2\fR &4 &12 &\fBPAPOUT\fR 
\fBD3\fR &5 &10 &\fBACK\fR 
\fBD4\fR &6 &11 &\fBBUSY\fR 
\fBGROUND\fR &25 &25 &\fBGROUND\fR 
\fBERROR\fR &15 &2 &\fBD0\fR 
\fBSLCT\fR &13 &3 &\fBD1\fR 
\fBPAPOUT\fR &12 &4 &\fBD2\fR 
\fBACK\fR &10 &5 &\fBD3\fR 
\fBBUSY\fR &11 &6 &\fBD4\fR 
.TE
.P 1
.P 1
All remaining pins remain unconnected\&. If the cable is shielded,
the shield should be connected to the DB-25's metallic shell
on one end only\&.
.P 1
.APP "" "Sample smail Configuration Files"
.SETR "appendix.smail"
.P 1
This section shows sample configuration files for a UUCP leaf site on a
local area network\&. They are based on the sample files included
in the source distribution of \fIsmail-3\&.1\&.28\fR\&.
Although I make a feeble attempt to explain how these files work,
you are advised to read the very fine \fIsmail(8)\fR manual page,
which discusses these files in great length\&. Once you've understood
the basic idea behind \fIsmail\fR configuration, it's worthwhile
reading\&. It's easy!
.P 1
The first file shown is the \fIrouters\fR file, which describes a set of
routers to \fIsmail\fR\&.  When \fIsmail\fR has to deliver a message to
a given address, it hands the address to all routers in turn, until one
of them matches it\&.  Matching here means that the router finds the
destination host in its database, be it the \fIpaths\fR file,
\fI/etc/hosts\fR, or whatever routing mechanism the router interfaces
to\&.
.P 1
Entries in \fIsmail\fR configuration files always begin with a unique
name identifying the router, transport, or director\&.  They are followed
by a list of attributes that define its behavior\&.  This list consists of
a set of global attributes, such as the \fIdriver\fR used, and private
attributes that are only understood by that particular driver\&.
Attributes are separated by commas, while the sets of global and private
attributes are separated from each other using a semicolon\&.
.P 1
To make these fine distinctions clear, assume you want to maintain two
separate pathalias files; one containing the routing information for
your domain, and a second one containing global routing information,
probably generatzed from the UUCP maps\&. With \fIsmail\fR, you
can now specify two routers in the \fIrouters\fR file, both of
which use the \fIpathalias\fR driver\&.  This driver looks up hostnames
in a pathalias database\&. It expects to be given the name of the file
in a private attribute:
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
#
# pathalias database for intra-domain routing
domain_paths: 
        driver=pathalias,         # look up host in a paths file
        transport=uux;            # if matched, deliver over UUCP

        file=paths/domain,        # file is /usr/lib/smail/paths/domain
        proto=lsearch,            # file is unsorted (linear search)
        optional,                 # ignore if the file does not exist
        required=vbrew.com,       # look up only *.vbrew.com hosts

#
# pathalias database for routing to hosts outside our domain
world_paths:  
        driver=pathalias,         # look up host in a paths file
        transport=uux;            # if matched, deliver over UUCP

        file=paths/world,         # file is /usr/lib/smail/paths/world
        proto=bsearch,            # file is sorted with sort(1)
        optional,                 # ignore if the file does not exist
        -required,                # no required domains
        domain=uucp,              # strip ending ".uucp" before searching

.ENDVERBATIM
\"
\fR
.DE
.P 1
The second global attribute given in each of the two \fIrouters\fR
entries above defines the transport that should be used when the router
matches the address\&.  In our case, the message will be delivered using
the \fIuux\fR transport\&.  Transports are defined in the
\fItransports\fR file, which is exlained below\&.
.P 1
You can fine-tune by which transport a message will be delivered if you
specify a mathod file instead of the \fItransports\fR attribute\&.
Method files provide a mapping from target hostnames to transports\&.
We won't deal with them here\&.
.P 1
The following \fIrouters\fR file defines routers for a local area
network that query the resolver library\&.  On an Internet host, however,
you would want to use a router that handles MX records\&.  You should
therefore uncomment the alternative \fIinet_bind\fR router that
uses \fIsmail\fR's builtin BIND driver\&.
.P 1
In an environment that mixes UUCP and TCP/IP, you may encounterthe
problem that you have hosts in your \fI/etc/hosts\fR file that
you have only occasional SLIP or PPP contact with\&.  Usually, you
would still want to send any mail for them over UUCP\&. To prevent
the \fIinet_hosts\fR driver from matching these hosts, 
you have to put them into the \fIpaths/force\fR file\&. This is
another pathalias-style database, and is consulted before \fIsmail\fR
queries the resolver\&.
.P 1
.P 1
.DS I F 5
\fB\"
.VERBATIM
# A sample /usr/lib/smail/routers file
#
# force - force UUCP delivery to certain hosts, even when
#       they are in our /etc/hosts
force:
        driver=pathalias,         # look up host in a paths file
        transport=uux;            # if matched, deliver over UUCP

        file=paths/force,         # file is /usr/lib/smail/paths/force
        optional,                 # ignore if the file does not exist
        proto=lsearch,            # file is unsorted (linear search)
        -required,                # no required domains
        domain=uucp,              # strip ending ".uucp" before searching


# inet_addrs - match domain literals containing literal
#       IP addresses, such as in janet@[191.72.2.1]
inet_addrs:
        driver=gethostbyaddr,     # driver to match IP domain literals
        transport=smtp;           # deliver using SMTP over TCP/IP

        fail_if_error,            # fail if address is malformed 
        check_for_local,          # deliver directly if host is ourself

# inet_hosts - match hostnames with gethostbyname(3N)
#       Comment this out if you wish to use the BIND version instead.
inet_hosts:
        driver=gethostbyname,     # match hosts with the library function
        transport=smtp;           # use default SMTP

        -required,                # no required domains
        -domain,                  # no defined domain suffixes
        -only_local_domain,       # don't restrict to defined domains

# inet_hosts - alternate version using BIND to access the DNS
#inet_hosts:
#       driver=bind,              # use built-in BIND driver
#       transport=smtp;           # use TCP/IP SMTP for delivery
#
#       defnames,                 # use standard domain searching
#       defer_no_connect,         # try again if the nameserver is down
#       -local_mx_okay,           # fail (don't pass through) an MX
#                                 # to the local host

#
# pathalias database for intra-domain routing
domain_paths: 
        driver=pathalias,         # look up host in a paths file
        transport=uux;            # if matched, deliver over UUCP

        file=paths/domain,        # file is /usr/lib/smail/paths/domain
        proto=lsearch,            # file is unsorted (linear search)
        optional,                 # ignore if the file does not exist
        required=vbrew.com,       # look up only *.vbrew.com hosts

#
# pathalias database for routing to hosts outside our domain
world_paths:  
        driver=pathalias,         # look up host in a paths file
        transport=uux;            # if matched, deliver over UUCP

        file=paths/world,         # file is /usr/lib/smail/paths/world
        proto=bsearch,            # file is sorted with sort(1)
        optional,                 # ignore if the file does not exist
        -required,                # no required domains
        domain=uucp,              # strip ending ".uucp" before searching


# smart_host - a partically specified smarthost director
#       If the smart_path attribute is not defined in
#       /usr/lib/smail/config, this router is ignored.
#       The transport attribute is overridden by the global
#       smart_transport variable
smart_host:
        driver=smarthost,         # special-case driver
        transport=uux;            # by default deliver over UUCP

        -path,                    # use smart_path config file variable
.ENDVERBATIM
\"
\fR
.DE
.SP 2
.P 1
The handling of mail for local addresses is configured in the
\fIdirectors\fR file\&.  It is made up just like the \fIrouters\fR file,
with a list of entries that define a director each\&.  Directors do
\fInot\fR deliver a message, they merely perform all the redirection
that is possible, for instance through aliases, mail forwarding, and the
like\&.
.P 1
When delivering mail to a local address, such as \fBjanet\fR, 
\fIsmail\fR passes the usr name to all directors in turn\&. If
a director matches, it either specifies a transport the message
should be delivered by (for instance, to the user's mailbox file),
or generates a new address (for instance, after evaluating an
alias)\&.
.P 1
Because of the security issues involved, directors usually do a lot of
checking of whether the files they use may be compromised or not\&.
Addresses obtained in a somewhat dubious way (for instance from a
world-writable \fIaliases\fR file) are flagged as unsecure\&.  Some
transport drivers will turn down such addresses, for instance the
transport that delivers a message to a file\&.
.P 1
Apart from this, \fIsmail\fR also \fIassociates a user\fR with each
address\&.  Any write or read operations are performed as the user\&.  For
delivery to, say \fBjanet\fR's mailbox, the address is of course
associated with \fBjanet\fR\&.  Other addresses, such as those obtained
from the \fIaliases\fR file, have other users associated from them, for
instance, the \fBnobody\fR user\&.
.P 1
For details of these features, please refer to the \fIsmail(8)\fR
manpage\&.
.P 1
.SP 2
.P 1
.DS I F 5
\fB\"
.VERBATIM
# A sample /usr/lib/smail/directors file

# aliasinclude - expand ":include:filename" addresses produced
#       by alias files
aliasinclude:
        driver=aliasinclude,      # use this special-case driver
        nobody;                   # access file as nobody user if unsecure

        copysecure,               # get permissions from alias director
        copyowners,               # get owners from alias director

# forwardinclude - expand ":include:filename" addrs produced
#       by forward files
forwardinclude:
        driver=forwardinclude,    # use this special-case driver
        nobody;                   # access file as nobody user if unsecure

        checkpath,                # check path accessibility
        copysecure,               # get perms from forwarding director
        copyowners,               # get owners from forwarding director

# aliases - search for alias expansions stored in a database
aliases:
        driver=aliasfile,         # general-purpose aliasing director
        -nobody,                  # all addresses are associated
                                  # with nobody by default anyway
        sender_okay,              # don't remove sender from expansions
        owner=owner-$user;        # problems go to an owner address

        file=/usr/lib/aliases,    # default: sendmail compatible
        modemask=002,             # should not be globally writable
        optional,                 # ignore if file does not exist
        proto=lsearch,            # unsorted ASCII file

# dotforward - expand .forward files in user home directories
dotforward:
        driver=forwardfile,       # general-purpose forwarding director
        owner=real-$user,         # problems go to the user's mailbox
        nobody,                   # use nobody user, if unsecure
        sender_okay;              # sender never removed from expansion

        file=~/.forward,          # .forward file in home directories
        checkowner,               # the user can own this file
        owners=root,              # or root can own the file
        modemask=002,             # it should not be globally writable
        caution=0-10:uucp:daemon, # don't run things as root or daemons
        # be extra careful of remotely accessible home directories
        unsecure="~ftp:~uucp:~nuucp:/tmp:/usr/tmp",

# forwardto - expand a "Forward to " line at the top of
#       the user's mailbox file
forwardto:
        driver=forwardfile,
        owner=Postmaster,         # errors go to Postmaster
        nobody,                   # use nobody user, if unsecure
        sender_okay;              # don't remove sender from expansion

        file=/var/spool/mail/${lc:user}, # location of user's mailbox
        forwardto,                # enable "Forward to " check
        checkowner,               # the user can own this file
        owners=root,              # or root can own the file
        modemask=0002,            # under System V, group mail can write
        caution=0-10:uucp:daemon, # don't run things as root or daemons

# user - match users on the local host with delivery to their mailboxes
user:   driver=user;              # driver to match usernames

        transport=local,          # local transport goes to mailboxes

# real_user - match usernames when prefixed with the string "real-"
real_user:
        driver=user;              # driver to match usernames

        transport=local,          # local transport goes to mailboxes
        prefix="real-",           # for example, match real-root

# lists - expand mailing lists stored below /usr/lib/smail/lists
lists:  driver=forwardfile,
        caution,                  # flag all addresses with caution
        nobody,                   # and then associate the nobody user
        sender_okay,              # do NOT remove the sender
        owner=owner-$user;        # the list owner

        # map the name of the mailing list to lower case
        file=lists/${lc:user},
.ENDVERBATIM
\"
\fR
.DE
.SP 2
.P 1
After successfully routing or directing a message, \fIsmail\fR
hands the message to the transport specified by the router
or director that matched the address\&. These transports are
defined in the \fItransports\fR file\&. Again, a transport
is defined by a set of global and private options\&.
.P 1
The most important option defined by each entry is driver that handles
the transport, for instance the \fIpipe\fR driver, which invokes the
command specified in the \fIcmd\fR attribute\&.  Apart from this,
there are a number of global attributes a transport may use, that
perform various transformations on the message header, and possibly
message body\&.  The \fIreturn_path\fR attribute, for instance, makes
the transport insert a \fIreturn_path\fR field in the message header
The \fIunix_from_hack\fR attribute makes it precede every
occurrence of the word \fBFrom\fR at the beginning of a line with a
\fB>\fR sign\&.
.P 1
.SP 2
\"
.VERBATIM
# A sample /usr/lib/smail/transports file

# local - deliver mail to local users
local:  driver=appendfile,        # append message to a file
        return_path,              # include a Return-Path: field
        from,                     # supply a From_ envelope line
        unix_from_hack,           # insert > before From in body
        local;                    # use local forms for delivery

        file=/var/spool/mail/${lc:user}, # location of mailbox files
        group=mail,               # group to own file for System V
        mode=0660,                # group mail can access
        suffix="\n",              # append an extra newline

# pipe - deliver mail to shell commands
pipe:   driver=pipe,              # pipe message to another program
        return_path,              # include a Return-Path: field
        from,                     # supply a From_ envelope line
        unix_from_hack,           # insert > before From in body
        local;                    # use local forms for delivery

        cmd="/bin/sh -c $user", # send address to the Bourne Shell
        parent_env,               # environment info from parent addr
        pipe_as_user,             # use user-id associated with address
        ignore_status,            # ignore a non-zero exit status
        ignore_write_errors,      # ignore write errors, i.e., broken pipe
        umask=0022,               # umask for child process
        -log_output,              # do not log stdout/stderr

# file - deliver mail to files
file:   driver=appendfile,
        return_path,              # include a Return-Path: field
        from,                     # supply a From_ envelope line
        unix_from_hack,           # insert > before From in body
        local;                    # use local forms for delivery

        file=$user,               # file is taken from address
        append_as_user,           # use user-id associated with address
        expand_user,              # expand ~ and $ within address
        suffix="\n",              # append an extra newline
        mode=0600,                # set permissions to 600

# uux - deliver to the rmail program on a remote UUCP site
uux:    driver=pipe,
        uucp,                     # use UUCP-style addressing forms
        from,                     # supply a From_ envelope line
        max_addrs=5,              # at most 5 addresses per invocation
        max_chars=200;            # at most 200 chars of addresses

        cmd="/usr/bin/uux - -r -a$sender -g$grade $host!rmail $(($user)$)",
        pipe_as_sender,           # have uucp logs contain caller
        log_output,               # save error output for bounce messages
#       defer_child_errors,       # retry if uux returns an error

# demand - deliver to a remote rmail program, polling immediately
demand: driver=pipe,
        uucp,                     # use UUCP-style addressing forms
        from,                     # supply a From_ envelope line
        max_addrs=5,              # at most 5 addresses per invocation
        max_chars=200;            # at most 200 chars of addresses

        cmd="/usr/bin/uux - -a$sender -g$grade $host!rmail $(($user)$)",
        pipe_as_sender,           # have uucp logs contain caller
        log_output,               # save error output for bounce messages
#       defer_child_errors,       # retry if uux returns an error

# hbsmtp - half-baked BSMTP. The output files must
#       be processed regularly and sent out via UUCP.
hbsmtp: driver=appendfile,
        inet,                     # use RFC 822-addressing
        hbsmtp,                   # batched SMTP w/o HELO and QUIT
        -max_addrs, -max_chars;   # no limit on number of addresses

        file="/var/spool/smail/hbsmtp/$host",
        user=root,                # file is owned by root
        mode=0600,                # only read-/writeable by root.

# smtp - deliver using SMTP over TCP/IP
smtp:   driver=tcpsmtp,
        inet,
        -max_addrs, -max_chars;   # no limit on number of addresses

        short_timeout=5m,               # timeout for short operations
        long_timeout=2h,                # timeout for longer SMTP operations
        service=smtp,                   # connect to this service port
# For internet use: uncomment the below 4 lines
#       use_bind,                       # resolve MX and multiple A records
#       defnames,                       # use standard domain searching
#       defer_no_connect,               # try again if the nameserver is down
#       -local_mx_okay,                 # fail an MX to the local host
.ENDVERBATIM
.P 1
.APP "" "The GNU General Public License"
.SETR "appendix.gpl"
.P 1
Printed below is the GNU General Public License (the \fIGPL\fR or 
\fIcopyleft\fR), under which Linux is licensed\&. It is reproduced here to
clear up some of the confusion about Linux's copyright status---Linux 
is \fInot\fR shareware, and it is \fInot\fR in the public domain\&. The
bulk of the Linux kernel is copyright (C)1993 by Linus Torvalds, 
and other software and parts of the kernel are copyrighted by their authors\&.
Thus, Linux \fIis\fR copyrighted, however, you may redistribute it under
the terms of the GPL printed below\&.
.P 1
.SP 3
.ce 1
\fBGNU GENERAL PUBLIC LICENSE\fR
.ce 1
Version 2, June 1991
.P 1
Copyright (C) 1989, 1991 Free Software Foundation, Inc\&.
675 Mass Ave, Cambridge, MA 02139, USA
Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed\&.
.P 1
.H 2 "Preamble"
.P 1
The licenses for most software are designed to take away your
freedom to share and change it\&.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users\&.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it\&.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead\&.)  You can apply it to
your programs, too\&.
.P 1
When we speak of free software, we are referring to freedom, not
price\&.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things\&.
.P 1
To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights\&.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it\&.
.P 1
For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have\&.  You must make sure that they, too, receive or can get the
source code\&.  And you must show them these terms so they know their
rights\&.
.P 1
We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software\&.
.P 1
Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software\&.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations\&.
.P 1
Finally, any free program is threatened constantly by software
patents\&.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary\&.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all\&.
.P 1
The precise terms and conditions for copying, distribution and
modification follow\&.
.P 1
.H 2 "Terms and Conditions for Copying, Distribution, and Modification"
.P 1
\"
.AL 10
.LI "0\&."
This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License\&.  The ``Program'', below,
refers to any such program or work, and a ``work based on the Program''
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language\&.  (Hereinafter, translation is included without limitation in
the term ``modification''\&.)  Each licensee is addressed as ``you''\&.
.P 1
Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope\&.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program)\&.
Whether that is true depends on what the Program does\&.
.P 1
.LI "1\&."
You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program\&.
.P 1
You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee\&.
.P 1
.LI "2\&."
You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:
.P 1
\"
.AL 10
.LI "a\&."
You must cause the modified files to carry prominent notices
stating that you changed the files and the date of any change\&.
.P 1
.LI "b\&."
You must cause any work that you distribute or publish, that in
whole or in part contains or is derived from the Program or any
part thereof, to be licensed as a whole at no charge to all third
parties under the terms of this License\&.
.P 1
.LI "c\&."
If the modified program normally reads commands interactively
when run, you must cause it, when started running for such
interactive use in the most ordinary way, to print or display an
announcement including an appropriate copyright notice and a
notice that there is no warranty (or else, saying that you provide
a warranty) and that users may redistribute the program under
these conditions, and telling the user how to view a copy of this
License\&.  (Exception: if the Program itself is interactive but
does not normally print such an announcement, your work based on
the Program is not required to print an announcement\&.)
\"
.LE
.P 1
These requirements apply to the modified work as a whole\&.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works\&.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it\&.
.P 1
Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program\&.
.P 1
In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License\&.
.P 1
.LI "3\&."
You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:
.P 1
\"
.AL 10
.LI "a\&."
Accompany it with the complete corresponding machine-readable
source code, which must be distributed under the terms of Sections
1 and 2 above on a medium customarily used for software interchange; or,
.P 1
.LI "b\&."
Accompany it with a written offer, valid for at least three
years, to give any third party, for a charge no more than your
cost of physically performing source distribution, a complete
machine-readable copy of the corresponding source code, to be
distributed under the terms of Sections 1 and 2 above on a medium
customarily used for software interchange; or,
.P 1
.LI "c\&."
Accompany it with the information you received as to the offer
to distribute corresponding source code\&.  (This alternative is
allowed only for noncommercial distribution and only if you
received the program in object code or executable form with such
an offer, in accord with Subsection b above\&.)
\"
.LE
.P 1
The source code for a work means the preferred form of the work for
making modifications to it\&.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable\&.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable\&.
.P 1
If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code\&.
.P 1
.LI "4\&."
You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License\&.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License\&.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance\&.
.P 1
.LI "5\&."
You are not required to accept this License, since you have not
signed it\&.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works\&.  These actions are
prohibited by law if you do not accept this License\&.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it\&.
.P 1
.LI "6\&."
Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions\&.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein\&.
You are not responsible for enforcing compliance by third parties to
this License\&.
.P 1
.LI "7\&."
If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License\&.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all\&.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program\&.
.P 1
If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances\&.
.P 1
It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices\&.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice\&.
.P 1
This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License\&.
.P 1
.LI "8\&."
If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded\&.  In such case, this License incorporates
the limitation as if written in the body of this License\&.
.P 1
.LI "9\&."
The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time\&.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns\&.
.P 1
Each version is given a distinguishing version number\&.  If the Program
specifies a version number of this License which applies to it and ``any
later version'', you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation\&.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation\&.
.P 1
.LI "10\&."
If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission\&.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this\&.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally\&.
.P 1
.SP 3
.ce 1
\fRNO WARRANTY\fR
.P 1
.LI "11\&."
BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW\&.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM ``AS IS'' WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\&.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU\&.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION\&.
.P 1
.LI "12\&."
IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES\&.
.P 1
\"
.LE
.ce 1
\fREND OF TERMS AND CONDITIONS\fR
.P 1
.H 2 "Appendix: How to Apply These Terms to Your New Programs"
.P 1
If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms\&.
.P 1
To do so, attach the following notices to the program\&.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the ``copyright'' line and a pointer to where the full notice is found\&.
.P 1
.P 1
.DS I F 5
<one line to give the program's name and a brief idea of 
what it does\&.>
Copyright (C)19yy  <name of author>
.P 0
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version\&.
.P 0
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE\&.  See the
GNU General Public License for more details\&.
.P 0
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc\&., 675 Mass Ave, Cambridge, MA 02139, USA\&.
\"
.DE
.P 1
Also add information on how to contact you by electronic and paper mail\&.
.P 1
If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:
.P 1
.P 1
.DS I F 5
\fBGnomovision version 69, Copyright (C) 19yy name of author
Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'\&.
This is free software, and you are welcome to redistribute it
under certain conditions; type `show c' for details\&.
\"
\fR
.DE
.P 1
The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License\&.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program\&.
.P 1
You should also get your employer (if you work as a programmer) or your
school, if any, to sign a ``copyright disclaimer'' for the program, if
necessary\&.  Here is a sample; alter the names:
.P 1
.P 1
.DS I F 5
Yoyodyne, Inc\&., hereby disclaims all copyright interest in the program
`Gnomovision' (which makes passes at compilers) written by James Hacker\&.
.P 0
<signature of Ty Coon>, 1 April 1989
Ty Coon, President of Vice
\"
.DE
.P 1
This General Public License does not permit incorporating your program into
proprietary programs\&.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library\&.  If this is what you want to do, use the GNU Library General
Public License instead of this License\&.
.P 1
.nr Hu 1
.HU "Glossary"
.SETR "glossary"
.P 1
\fB[Meta: This could use more entries, and a little polishing\&.
Feel free to make suggestions\&.]\fR
.P 1
An enormous difficulty in networking is to remember what all the
abbreviations and terms one encounters really mean\&. Here's a list of
those used frequently throughout the guide, along with a short
explanation\&. 
.P 1
\"
.BL 10
.LI "ACU"
Automatic Call Unit\&. A modem\&.(\*F)
.FS
Alternatively: A teenager with a telephone\&.
.FE
.P 1
.LI "ARP"
Address Resolution Protocol\&. Used to map IP addresses
to Ethernet addresses\&.
.P 1
.LI "ARPA"
Advanced Research Project Agency, later DARPA\&. Founder
of the Internet\&.
.P 1
.LI "ARPANET"
The ancestor of today's Internet; an experimental network
funded by the U\&.S\&. Defense Advanced Research Project Agency
(DARPA)\&.
.P 1
.LI "Assigned Numbers"
The title of an \fIRFC\fR published regularly that lists
the publicly allocated numbers used for various things in
TCP/IP networking\&. For example, it contains the list of all
port numbers of well-known services like \fIrlogin\fR, 
\fItelnet\fR, etc\&. The most recent release of this
document is RFC 1340\&.
.P 1
.LI "bang path"
In UUCP networks, a special notation for the path from
one UUCP site to another\&. The name derives from the
use of exclamation marks (`bangs') to separate the
host names\&. Example: \fBfoo!bar!ernie!bert\fR denotes
a path to host \fBbert\fR, travelling (in this order)
\fBfoo\fR, \fBbar\fR, and \fBernie\fR\&.
.P 1
.LI "BBS"
Bulletin Board System\&. A dial-up mailbox system\&.
.P 1
.LI "BGP"
Border Gateway Protocol\&. A protocol for exchanging
routing information between autonomous systems\&.
.P 1
.LI "BIND"
The Berkeley Internet Name Domain server\&. An implementation
of a DNS server\&.
.P 1
.LI "BNU"
Basic Networking Utilities\&. This is the most common UUCP
variety at the moment\&.  It is also known as HoneyDanBer UUCP\&.
This name is derived from the authors' names: P\&. Honeyman,
D\&.A\&. Novitz, and B\&.E\&. Redman\&.
.P 1
.LI "broadcast network"
A network that allows one station to address a datagram
to all other stations on the network simultaneously\&.
.P 1
.LI "BSD"
Berkeley Software Distribution\&. A Un*x flavor\&.
.P 1
.LI "canonical hostname"
A host's primary name within the Domain Name System\&. This
is the host's only name that has an A record 
associated with it, and which is returned when performing
a reverse lookup\&.
.P 1
.LI "CCITT"
Comite\['e] Consultatif International de  T\['e]l\['e]graphique
et T\['e]l\['e]phonique\&. An International organization of
telephone services, etc\&.
.P 1
.LI "CSLIP"
Compressed Serial Line IP\&. A protocol for exchanging IP
packets over a serial line, using header compression of
most TCP/IP datagrams\&.
.P 1
.LI "DNS"
Domain name system\&. This is a distributed database used on the
Internet for mapping of host names to IP addresses\&.
.P 1
.LI "EGP"
External Gateway Protocol\&. A protocol for exchanging
routing information between autonomous systems\&.
.P 1
.LI "Ethernet"
In colloquial terms, the name of a sort of network equipment\&.
Technically, Ethernet is part of a set of standards set forth by
the IEEE\&. The Ethernet hardware uses a single piece of cable,
frequently coax cable, to connect a number of hosts, and
allows transfer rates of up to 10Mbps\&. The Ethernet protocol
defines the manner in which hosts may communicate over
this cable\&.(\*F)
.FS
As an aside, the Ethernet \fIprotocol\fR commonly used by TCP/IP
is \fInot\fR exactly the same as IEEE 802\&.3\&. Ethernet frames
have a type field where IEEE 802\&.3 frames have a length field\&.
.FE
.P 1
.LI "FQDN"
Fully Qualified Domain Name\&. A hostname with a domain name
tacked onto it, so that it is a valid index into the Domain Name
database\&.
.P 1
.LI "FTP"
File Transfer Protocol\&. The protocol one of the best-known
file transfer service is based on and named after\&.
.P 1
.LI "FYI"
``For Your Information\&.'' Series of documents with informal
information on Internet topics\&.
.P 1
.LI "GMU"
Groucho Marx University\&. Fictitious University used as an example
throughout this book\&.
.P 1
.LI "GNU"
GNU's not Unix -- this recursive acronym is the name of a project
by the Free Software Association to provide a coherent set of
Un*x-tools that may be used and copied free of charge\&. All
GNU software is covered by a special Copyright notice, also
called the GNU General Public License (GPL), or Copyleft\&.
The GPL is reproduced in section 
.GETHN "appendix.gpl"
\&\&.
.P 1
.LI "HoneyDanBer"
The name of a UUCP variety\&. See also BNU\&.
.P 1
.LI "host"
Generally, a network node: something that is able to receive and
transmit network messages\&. This will usually be a computer, but
you can also think of X-Terminals, or smart printers\&.
.P 1
.LI "ICMP"
Internet Control Message Protocol\&. A networking protocol used
by IP to return error information to the sending host, etc\&.
.P 1
.LI "IEEE"
Institute of Electrical and Eletronics Engineers\&. Another standards
organization\&. From a UNIX user's point of view, their most
important achievement are probably the POSIX standards which
define aspects of a UNIX systems, ranging from system call
interfaces and semantics to administration tools\&.
.P 1
Apart from this, the IEEE developed the specifications for
Ethernet, Token Ring, and Token Bus networks\&. A widely-used
standard for binary representation of real numbers is also due to
the IEEE\&.
.P 1
.LI "IETF"
Internet Engineering Task Force\&.
.P 1
.LI "internet"
A computer network formed of a collection of individual smaller
networks\&.
.P 1
.LI "Internet"
A particular world-wide internet\&.
.P 1
.LI "IP"
Internet Protocol\&. A networking protocol\&.
.P 1
.LI "ISO"
International Standards Organization\&.
.P 1
.LI "ISDN"
Integrated Services Digital Network\&. New telecommunications
technology using digital instead of analogue circuitry\&.
.P 1
.LI "LAN"
Local Area Network\&. A small computer network\&.
.P 1
.LI "MX"
Mail Exchanger\&. A DNS resource record type used for marking
a host as mail gateway for a domain\&.
.P 1
.LI "network, packet-switched"
A variety of networks that provide instantaneous forwarding
of data by all data up in small packets, which are tramsported
to their destination individually\&. Packet-switched networks
rely on permanent or semi-permanent connections\&.
.P 1
.LI "network, store-and-forward"
They are pretty much the opposite of packet-switched networks\&.
These networks transfer data as entire files, and don't
use permanent connections\&. Instead, hosts conect to each other
at certain intervals only, and transfer all data at once\&.
This requires that data be stored intermediately until a
connection is established\&.
.P 1
.LI "NFS"
Network File System\&. A standard networking protocol and
software suite for accessing data on remote disks
transparently\&.
.P 1
.LI "NIS"
Network Information System\&. An RPC-based application that
allows to share configuration files such as the password file
between several hosts\&. See also the entry under YP\&.
.P 1
.LI "NNTP"
Network News Transfer Protocol\&. Used to transfer news over
TCP network connections\&.
.P 1
.LI "octet"
On the Internet, the technical term referring to a quantity of
eight bits\&. It is used rather than \fIbyte\fR, because there
are machines on the Internet that have byte sizes other than eight
bits\&.
.P 1
.LI "OSI"
Open Systems Interconnection\&. An ISO standard on network software\&.
.P 1
.LI "path"
Often used in UUCP networks as a synonym for \fIroute\fR\&. Also
see \fIbang path\fR\&.
.P 1
.LI "PLIP"
Parallel Line IP\&. A protocol for exchanging IP packets over
a parallel line such as a printer port\&.
.P 1
.LI "port, TCP or UDP"
Ports are TCP's and UDP's abstraction of a service endpoint\&.
Before a process can provide or access some networking service,
it must claim (bind) a port\&. Together with the hosts' IP
addresses, ports uniquely identify the two peers of a TCP connection\&.
.P 1
.LI "portmapper"
The portmapper is the mediator between the program numbers used
by RPC as an identification of individual RPC servers, and the
TCP and UDP port numbers those services are listening to\&.
.P 1
.LI "PPP"
The point-to-point protocol\&. PPP is a flexible and
fast link-layer protocol to send various network protocols
such as IP or IPX across a point-to-point connection\&.  Apart
from being used on serial (modem) links, PPP can also be
employed as the link-level protocol on top of ISDN\&.
.P 1
.LI "RARP"
Reverse Address Resolution Protocol\&. It permits hosts to
find out their IP address at boot time\&.
.P 1
.LI "resolver"
This is a library responsible for mapping hostnames to
IP addresses and vice versa\&.
.P 1
.LI "resource record"
This is the basic unit of information in the DNS database, 
commonly abbreviated as RR\&.
Each record has a certain type and class associated with it,
for instance a record mapping a host name to an IP address
has a type of A (for address), and a class of IN
(for the Internet Protocol)\&.
.P 1
.LI "reverse lookup"
The act of looking up a host's name based on a given IP address\&.
Within DNS, this is done by looking up the host's IP address
in the \fBin-addr\&.arpa\fR domain\&.
.P 1
.LI "RFC"
Request For Comments\&. Series of documents describing
Internet standards\&.
.P 1
.LI "RIP"
Routing Information Protocol\&. This is a routing protocol used
dynamically adjust routes inside a (small) network\&.
.P 1
.LI "route"
The sequence of hosts a piece of information has to travel
from the originating host to the destination host\&. Finding
an appropriate route is also called \fIrouting\fR\&.
.P 1
.LI "routing daemon"
In larger networks, network topology changes are hard to adapt
to manually, so facilities are used to distribute current
routing information to the network's member hosts\&. This is
called dynamic routing; the routing information is exchanged
by \fIrouting daemons\fR running on central hosts in the network\&.
The protocols they employ are called \fIrouting protocols\fR\&.
.P 1
.LI "RPC"
Remote Procedure Call\&. Protocol for executing procdures inside
a process on a remote host\&.
.P 1
.LI "RR"
Short for \fIresource record\fR\&.
.P 1
.LI "RS-232"
This is a very common standard for serial interfaces\&.
.P 1
.LI "RTS/CTS"
A colloquial name for the hardware handshake performed by
two devices communicating over RS-232\&. The name derives from
the two cicuits involved, RTS (``Ready To Send''), and
CTS (``Clear To Send'')\&.
.P 1
.LI "RTM Internet Worm"
A Virus-like program that used several flaws in VMS and
BSD 4\&.3 Unix to spread through the Internet\&. Several ``mistakes''
in the program caused it to multiply without bound, and so
effectively bringing down large parts of the Internet\&.
RTM are the author's initials (Robert T\&. Morris), which he left
in the program\&.
.P 1
.LI "site"
An agglomeration of hosts which, to the outside, behave almost
like a single network node\&. For example, when speaking from an
Internet point of view, one would call a Groucho Marx University
a site, regardless of the complexity of its interior network\&.
.P 1
.LI "SLIP"
Serial Line IP\&. This is a protocol for exchanging IP packets over
a serial line, see also CSLIP\&.
.P 1
.LI "SMTP"
Simple Mail Transfer Protocol\&. Used for mail transport
over TCP connections, but also for mail batches transported
over UUCP links (batched SMTP)\&.
.P 1
.LI "SOA"
Start of Authority\&. A DNS resource record type\&.
.P 1
.LI "System V"
A Un*x flavor\&.
.P 1
.LI "TCP"
Transmission Control Protocol\&. A networking protocol\&.
.P 1
.LI "TCP/IP"
Sloppy description of the Internet protocol suite
as a whole\&.
.P 1
.LI "UDP"
User Datagram Protocol\&. A networking protocol\&.
.P 1
.LI "UUCP"
Unix to Unix Copy\&.
A suite of network transport commands for dial-up
networks\&.
.P 1
.LI "Version 2 UUCP"
An aging UUCP variety\&.
.P 1
.LI "virtual beer"
Every Linuxer's favorite drink\&. The first mention of virtual
beer I remember was in the release note of the Linux 0\&.98\&.X kernel,
where Linus listed the ``Oxford Beer Trolls'' in his credits section
for sending along some virtual beer\&.
.P 1
.LI "well-known services"
This term is frequently used to refer to common networking
services such as \fItelnet\fR and \fIrlogin\fR\&.  In a more
technical sense, it describes all services that have been
assigned an official port number in the ``Assigned Numbers''
RFC\&.
.P 1
.LI "YP"
Yellow Pages\&. An older name for NIS which is no longer used,
because Yellow Pages is a trademark of British Telecom\&.
Nevertheless, most NIS utilities have retained names with
a prefix of \fIyp\fR\&.
.P 1
\"
.LE
.P 1
.nr Hu 1
.HU "Annotated Bibliography"
.nr Hu 2
.HU "Books"
.P 1
The following is a list of books you might want to read to if you want
to know more about some of the topics covered in the Networking Guide\&.
It is not very complete or systematic, I just happen to have read them
and find them quite useful\&. Any additions to, and enhancement of
this list are welcome\&.
.P 1
.nr Hu 3
.HU "General Books on the Internet"
.P 1
.SETR "zen" "Kehoe92"
\"
.BL 10
.LI "[Kehoe92]"
Brendan P\&. Kehoe: \fIZen and the Art of the Internet\fR\&. \&.
.P 1
``Zen'' was one of, if not \fIthe\fR first Internet Guide, introducing
the novice user to the various trades, services and the folklore of
the Internet\&. Being a 100-page tome, it covered topics ranging from
email to Usenet news to the Internet Worm\&. 
It is available via anonymous FTP from many FTP servers, and may be
freely distributed and printed\&. A printed copy is also available from
Prentice-Hall\&.
.P 1
\"
.LE
.P 1
.nr Hu 3
.HU "Administration Issues"
.P 1
.SETR "hunt-tcpip" "Hunt92"
\"
.BL 10
.LI "[Hunt92]"
Craig Hunt: \fITCP/IP Network Administration\fR\&. O'Reilly and Associates, 1992\&.
ISBN 0-937175-82-X\&.
Appr\&. Price \&.
.P 1
If the Linux Network Administrators' Guide is not enough for 
you, get this book\&. It deals with everything from obtaining an
IP address to troubleshooting your network to security issues\&.
.P 1
Its focus is on setting up TCP/IP, that is, interface
configuration, the setup of routing, and name resolution\&.
It includes a detailed description of the facilities offered by
the routing daemons \fBrouted\fR and \fBgated\fR, which
supply dynamic routing\&.
.P 1
It also describes the configuration of application programs
and network daemons, such as \fBinetd\fR, the \fBr\fR 
commands, NIS, and NFS\&.
.P 1
The appendix has a detailed reference of \fBgated\fR, and
\fBnamed\fR, and a description of Berkeley's \fBsendmail\fR
configuration\&.
\"
.LE
.P 1
.SETR "stern-nfs" "Stern92"
\"
.BL 10
.LI "[Stern92]"
Hal Stern: \fIManaging NIS and NFS\fR\&. O'Reilly and Associates, 1992\&.
ISBN 0-937175-75-7\&.
Appr\&. Price \&.
.P 1
This is a companion book to Craig Hunt's ``TCP/IP Network Administration''
book\&. It covers the use of NIS, the Network Information System, and
NFS, the Network File System, in extenso, including the configuration
of an automounter, and PC/NFS\&.
\"
.LE
.P 1
.SETR "reilly-uucp" "OReilly89"
\"
.BL 10
.LI "[OReilly89]"
Tim O'Reilly and Grace Todino: \fIManaging UUCP and Usenet, 10th ed\fR\&. O'Reilly and Associates, 1992\&.
ISBN 0-93717593-5\&.
Appr\&. Price \&.
.P 1
This is the standard book on UUCP networking\&. It covers
Version 2 UUCP as well as BNU\&. It helps you to set up your
UUCP node from the start, giving practical tips and solutions
for many problems, like testing the connection, or writing good
chat scripts\&. It also deals with more exotic topics, like
how to set up a travelling UUCP node, or the
subtleties present in different flavors of UUCP\&.
.P 1
The second part of the book deals with Usenet and netnews software\&.
It explains the configuration of both Bnews (version 2\&.11) and 
C news, and introduces you to netnews maintenance tasks\&.
\"
.LE
.P 1
.SETR "security" "Spaf93"
\"
.BL 10
.LI "[Spaf93]"
Gene Spafford and Simson Garfinkel: \fIPractical UNIX Security\fR\&. O'Reilly and Associates, 1992\&.
ISBN 0-937175-72-2\&.
Appr\&. Price \&.
.P 1
This is a must-have for everyone who manages a system
with network access, and for others as well\&.  The book discusses
all issues relevant to computer security, ranging the basic 
security features Un*x offers physical security\&. Although
you should strive to secure all parts of your system, the discussion
of networks and security is the most interesting part of the book
in our context\&. Apart from basic security policies that concern
the Berkeley services (\fItelnet\fR, \fIrlogin\fR, etc), NFS
and NIS, it also deals with enhanced security features like MIT's
Kerberos, Sun's Secure RPC, and the use of firewalls to shield
your network from attacks from the Internet\&.
.P 1
\"
.LE
.P 1
.SETR "liu-dns" "AlbitzLiu92"
\"
.BL 10
.LI "[AlbitzLiu92]"
Paul Albitz and Cricket Liu: \fIDNS and BIND\fR\&. O'Reilly and Associates, 1992\&.
ISBN 1-56592-010-4\&.
Appr\&. Price \&.
.P 1
This book is useful for all those that have to manage DNS name service\&.
It explains all features of DNS in great detail and give examples that
make even those BIND options plausible that appear outright weird at
first sight\&. I found it fun to read, and really learned a lot from it\&.
\"
.LE
.P 1
.SETR "nisplus" "NISPlus"
\"
.BL 10
.LI "[NISPlus]"
Rick Ramsey: \fIAll about Administering NIS+\fR\&. Prentice-Hall, 1993\&.
ISBN 0-13-068800-2\&.
Appr\&. Price \&.
.P 1
\"
.LE
.P 1
.nr Hu 3
.HU "The Background"
.P 1
The following is a list of books that might be of interest to
people who want to know more about \fIhow\fR TCP/IP and its
applications work, but don't want to read RFCs\&.
.P 1
.SETR "stevens" "Stevens90"
\"
.BL 10
.LI "[Stevens90]"
Richard W\&. Stevens: \fIUNIX Network Programming\fR\&. Prentice-Hall International, 1990\&.
ISBN 0-13-949876-X\&.
Appr\&. Price \&.
.P 1
This is probably \fIthe\fR most widely used book on TCP/IP network
programming, which, at the same time, tells you a lot about the nuts and
bolts of the Internet Protocols\&.(\*F)
.FS
Note that Stevens has just written a new TCP/IP, called \fITCP/IP
Illustrated, Volume 1, The Protocols\fR, published by Addison Wesley\&.
I didn't have the time to look at it, though\&.
.FE
\"
.LE
.P 1
.SETR "ast89" "Tanen89"
\"
.BL 10
.LI "[Tanen89]"
Andrew S\&. Tanenbaum: \fIComputer Networks\fR\&. Prentice-Hall International, 1989\&.
ISBN 0-13-166836-6(\*F)
.FS
The ISBN under which it is available in North America might
be different\&.
.FE
\&.
Appr\&. Price \&.
.P 1
This book gives you a very good insight into general networking
issues\&. Using the OSI Reference Model, it explains the design
issues of each layer, and the algorithms that may be used to achieve
these\&. At each layer, the implementations of several networks,
among them the ARPAnet, are compared to each other\&.
.P 1
The only drawback this book has is the abundance of abbreviations,
which sometimes makes it hard to follow what the author says\&.  But this
is probably inherent to networking\&.
\"
.LE
.P 1
.SETR "comer" "Comer88"
\"
.BL 10
.LI "[Comer88]"
Douglas R\&. Comer: \fIInternetworking with TCP/IP: Principles, Protocols, and Architecture\fR\&. Prentice-Hall International, 1988\&.
.P 1
\"
.LE
.P 1
.nr Hu 2
.HU "HOWTOs"
The following is an excerpt of the HOWTO-INDEX, version 2\&.0
(17 March 1994), written by Matt Welsh\&.
.P 1
.nr Hu 3
.HU "What are Linux HOWTOs?"
.P 1
Linux HOWTOs are short online documents which describe in detail a
certain aspect of configuring or using the Linux system\&. For example,
there is the Installation HOWTO, which gives instructions on
installing Linux, and the Mail HOWTO, which describes how to set up
and configure mail under Linux\&.  Other examples include the
NET-2-HOWTO (previously the NET-2-FAQ) and the Printing HOWTO\&.
.P 1
Information in HOWTOs is generally more detailed and in-depth than
what can be squeezed into the Linux FAQ\&. For this reason, the Linux
FAQ is being rewritten\&. A large amount of the information contained
therein will be relegated to various HOWTO documents\&.  The FAQ will be
a shorter list of frequently asked questions about Linux, covering
small specific topics\&. Most of the ``useful'' information in the FAQ
will now be covered in the HOWTOs\&.
.P 1
HOWTOs are comprehensive documents---much like an FAQ but generally
not in question-and-answer format\&. However, many HOWTOs contain an FAQ
section at the end\&. For example, the NET-2-FAQ has been renamed to the
NET-2-HOWTO, because it wasn't in question-and-answer format\&. However,
you will see the NET-2-HOWTO named as the NET-2-FAQ in many places\&.
The two docs are one and the same\&.
.P 1
.nr Hu 3
.HU "Where to get Linux HOWTOs"
.P 1
HOWTOs can be retrieved via anonymous FTP from the following sites:
.P 1
\"
.BL 10
.LI
\fIsunsite\&.unc\&.edu:/pub/Linux/docs/HOWTO\fR
.P 1
.LI
\fItsx-11\&.mit\&.edu:/pub/linux/docs/HOWTO\fR
\"
.LE
.P 1
as well as the many mirror sites, which are listed in the Linux
META-FAQ (see below)\&.
.P 1
The Index, printed below, lists the currently available HOWTOs\&.
.P 1
HOWTOs are also posted regularly to the newsgroups \fBcomp\&.os\&.linux\fR and
\fBcomp\&.os\&.linux\&.announce\fR\&. In addition, a number of the HOWTOs will be
crossposted to \fBnews\&.answers\fR\&.  Therefore, you can find the Linux
HOWTOs on the \fBnews\&.answers\fR archive site \fBrtfm\&.mit\&.edu\fR\&.
.P 1
.nr Hu 3
.HU "HOWTO Index"
.P 1
The following Linux HOWTOs are currently available\&.
.P 1
\"
.BL 10
.LI
Linux Busmouse HOWTO, by \fBmike@starbug\&.apana\&.org\&.au\fR (Mike
Battersby)\&.  Information on bus mouse compatibility with Linux\&.
.P 1
.LI
Linux CDROM HOWTO, by \fBtranter@software\&.mitel\&.com\fR (Jeff Tranter)\&.
Information on CD-ROM drive compatibility for Linux\&.
.P 1
.LI
Linux DOSEMU HOWTO, by \fBdeisher@enws125\&.EAS\&.ASU\&.EDU\fR (Michael E\&.
Deisher)\&.  HOWTO about the Linux MS-DOS Emulator, DOSEMU\&.
.P 1
.LI
Linux Distribution HOWTO, by \fBmdw@sunsite\&.unc\&.edu\fR (Matt Welsh)\&.  A
list of mail order distributions and other commercial services\&.
.P 1
.LI
Linux Ethernet HOWTO, by Paul Gortmaker
\fBgpg109@rsphysse\&.anu\&.edu\&.au\fR\&.  Information on Ethernet hardware
compatibility for Linux\&.
.P 1
.LI
Linux Ftape HOWTO, by \fBftape@mic\&.dth\&.dk\fR (Linux ftape-HOWTO
maintainer)\&.  Information on ftape drive compatibility with Linux\&.
.P 1
.LI
Linux HOWTO Index, by \fBmdw@sunsite\&.unc\&.edu\fR (Matt Welsh)\&.  Index of
HOWTO documents about Linux\&.
.P 1
.LI
Linux Hardware Compatibility HOWTO, by \fBerc@apple\&.com\fR (Ed Carp)\&.  A
near-extensive list of hardware known to work with Linux\&.
.P 1
.LI
Linux Installation HOWTO, by \fBmdw@sunsite\&.unc\&.edu\fR (Matt Welsh)\&.  How
to obtain and install the Linux software\&.
.P 1
.LI
Linux JE-HOWTO, by Yasuhiro Yamazaki
\fBhiro@rainbow\&.physics\&.utoronto\&.ca\fR\&.  Information on JE, a set of
Japanese language extensions for Linux\&.
.P 1
.LI
Linux Keystroke HOWTO, by Zenon Fortuna (\fBzenon@netcom\&.com\fR)\&.
HOWTO bind macro actions to keystrokes under Linux\&.
.P 1
.LI
Linux MGR HOWTO, by \fBbroman@Np\&.nosc\&.mil\fR (Vincent Broman)\&.
Information on the MGR graphics interface for Linux\&.
.P 1
.LI
Linux Electronic Mail HOWTO, by \fBvince@victrola\&.wa\&.com\fR (Vince
Skahan)\&.  Information on Linux-based mail servers and clients\&.
.P 1
.LI
Linux NET-2 HOWTO, by \fBterryd@extro\&.ucc\&.su\&.oz\&.au\fR (Terry Dawson)\&.
HOWTO configure TCP/IP networking, SLIP, PLIP, and PPP under Linux\&.
.P 1
.LI
Linux News HOWTO, by \fBvince@victrola\&.wa\&.com\fR (Vince Skahan)\&.
Information on USENET news server and client software for Linux\&.
.P 1
.LI
Linux PCI-HOWTO, by Michael Will
\fBmichaelw@desaster\&.student\&.uni-tuebingen\&.de\fR\&.  Information on
PCI-architecture compatibility with Linux\&.
.P 1
.LI
Linux Printing HOWTO, by \fBgtaylor@cs\&.tufts\&.edu\fR (Grant Taylor)\&.
HOWTO on printing software for Linux\&.
.P 1
.LI
Linux SCSI HOWTO, by Drew Eckhardt \fBdrew@kinglear\&.cs\&.Colorado\&.EDU\fR\&.
Information on SCSI driver compatibility with Linux\&.
.P 1
.LI
Linux Serial HOWTO, by \fBgregh@cc\&.gatech\&.edu\fR (Greg Hankins)\&.
Information on use of serial devices and communications software\&.
.P 1
.LI
Linux Sound HOWTO, by \fBtranter@software\&.mitel\&.com\fR (Jeff Tranter)\&.
Sound hardware and software for the Linux operating system\&.
.P 1
.LI
Linux Term HOWTO, by Bill Reynolds \fBbill@goshawk\&.lanl\&.gov\fR\&.  HOWTO
use the `term' communications package on Linux systems\&.
.P 1
.LI
Linux Tips HOWTO, by Vince Reed \fBreedv@rpi\&.edu\fR\&.  HOWTO on
miscellaneous tips and tricks for Linux\&.
.P 1
.LI
Linux UUCP HOWTO, by \fBvince@victrola\&.wa\&.com\fR (Vince Skahan)\&.
Information on UUCP software for Linux\&.
.P 1
.LI
Linux XFree86 HOWTO, by \fBgeyer@polyhymnia\&.iwr\&.uni-heidelberg\&.de\fR
(Helmut Geyer)\&.  HOWTO on installation of XFree86 (X11R5) for Linux\&.
\"
.LE
.P 1
.nr Hu 3
.HU "Miscellaneous and Legalese"
.P 1
If you have questions, please feel free to mail
\fBmdw@sunsite\&.unc\&.edu\fR\&.  The Linux FAQ rewrite is being coordinated by
Ian Jackson, \fBijackson@nyx\&.cs\&.du\&.edu\fR, with help from others\&.
.P 1
Unless otherwise stated, Linux HOWTO documents are copyrighted by their
respective authors\&. Linux HOWTO documents may be reproduced and distributed
in whole or in part, in any medium physical or electronic, without
permission of the author\&. Translations and derivative works are similarly
permitted without express permission\&. Commercial redistribution is allowed
and encouraged; however, the author would like to be notified of any such
distributions\&.
.P 1
In short, we wish to promote dissemination of this information through as
many channels as possible\&. However, we do wish to retain copyright on the
HOWTO documents, and would like to be notified of any plans to redistribute
the HOWTOs\&. If you have questions, please contact Matt Welsh, the Linux
HOWTO coordinator, at \fBmdw@sunsite\&.unc\&.edu\fR\&.
.P 1
.nr Hu 2
.HU "RFCs"
.P 1
The following is a list of RFCs mentioned throughout this book\&.  All
RFCs are available via anonymous FTP from \fBnic\&.ddn\&.mil\fR,
\fBftp\&.uu\&.net\fR\&.  To obtain an RFC via email, send a message to
\fBservice@nic\&.ddn\&.mil\fR, putting the request \fBsend
RFC-\fB\fInumber\fB\fB\&.TXT\fR in the subject header line\&.
.P 1
\"
.BL 10
.LI "1340"
Assigned Numbers,
\fIPostel, J\&.\fR, and \fIReynolds, J\&.\fR
The Assigned Numbers RFC defines the meaning of
numbers used in various protocols, such as the
port numbers standard TCP and UDP servers are known
to listen on, and the protocol numbers used in
the IP datagram header\&.
.P 1
.LI "1144"
Compressing TCP/IP headers for low-speed serial links,
\fIJacobson, V\&.\fR
This document describes the algorithm used to compress
TCP/IP headers in CSLIP and PPP\&.  Very worthwhile reading!
.P 1
.LI "1033"
Domain Administrators Operations Guide,
\fILottor, M\&.\fR
Together with its companion RFCs, RFC 1034 and RFC 1035, this
is the definitive source on DNS, the Domain Name System\&.
.P 1
.LI "1034"
Domain Names - Concepts and Facilities,
\fIMockapetris, P\&.V\&.\fR
A companion to RFC 1033\&.
.P 1
.LI "1035"
Domain names - Implementation and Specification,
\fIMockapetris, P\&.V\&.\fR
A companion to RFC 1033\&.
.P 1
.LI "974"
Mail Routing and the Domain System,
\fIPartridge, C\&.\fR
This RFC describes mail routing on the Internet\&.
Read this for the full story about MX records\&.\&.\&.
.P 1
.LI "977"
Network News Transfer Protocol,
\fIKantor, B\&.\fR, and \fILapsley, P\&.\fR
The definition of NNTP, the common news transport used
on the Internet\&.
.P 1
.LI "1094"
NFS: Network File System Protocol specification,
\fINowicki, B\&.\fR
The formal specification of the NFS and mount protocols (version 2)\&.
.P 1
.LI "1055"
Nonstandard for Transmission of IP Datagrams over Serial Lines: SLIP,
\fIRomkey, J\&.L\&.\fR
Describes SLIP, the Serial Line Internet Protocol\&.
.P 1
.LI "1057"
RPC: Remote Procedure Call Protocol Specification: Version 2,
\fISun Microsystems, Inc\fR
.P 1
.LI "1058"
Routing Information Protocol,
\fIHedrick, C\&.L\&.\fR
Describes RIP, which is used to exchange dynamic routing 
information within LANs and MANs\&.
.P 1
.LI "821"
Simple Mail Transfer Protocol, \fIPostel, J\&.B\&.\fR
Defines SMTP, the mail transport protocol over
TCP/IP\&.
.P 1
.LI "1036"
Standard for the Interchange of USENET messages,
\fIAdams, R\&.\fR, and \fIHorton, M\&.R\&.\fR
This RFC describes the format of Usenet News messages,
and how they are exchanged on the Internet as well
as on UUCP networks\&. A revision of this RFC is expected
to be released sometime soon\&.
.P 1
.LI "822"
Standard for the Format of ARPA Internet text messages,
\fICrocker, D\&.\fR
This is the definitive source of wisdom regarding, well,
RFC-conformant mail\&. Everyone knows it, few have really
read it\&.
.P 1
.LI "968"
Twas the Night Before Start-up,
\fICerf, V\&.\fR
Who says the heroes of networking remain unsung?
.P 1
\"
.LE
.P 1
.PRINTINDEX net
.P 1

.TC 1 1 7



.br
.\" End of document. G'dbuy...
