package Gato;
# Atributos de clase
my $cantidad = 0;

# Constructor y destructor de clase
sub new {
    my $clase = shift;
    my $gato = {@_};

    # Atributos de instancia
    $gato->{lleno} ||= 0;
    $gato->{sueo} ||= 0;

    $cantidad++;
    bless $gato, $clase;

    return $gato;
}

sub DESTROY {
    $cantidad--;
}

# Accesores y mutadores
sub lee_lleno { my $gato = shift; return $gato->{lleno}; }
sub lee_sueo { my $gato = shift; return $gato->{sueo}; }
sub lee_sexo { my $gato = shift; return $gato->{sexo}; }
sub lee_pelo { my $gato = shift; return $gato->{pelo}; }
sub lee_peso { my $gato = shift; return $gato->{peso}; }

sub pon_lleno { 
    my $gato = shift; 
    my $lleno = shift;
    # Valido que sea numrico y no demasiado lleno
    return undef unless ($lleno =~ /^\d+$/ and $lleno < 20);
    $gato->{lleno} = $lleno;
    return 1;
}

sub pon_sueo { 
    my $gato = shift; 
    my $sueo = shift;
    # Slo valido que sea numrico
    return undef unless $sueo =~ /^\d+$/;
    $gato->{sueo} = $sueo;
    return 1;
}

sub pon_sexo {
    my $gato = shift;
    my $sexo = uc(shift);
    if defined $gato->{sexo} {
	warn 'El sexo ya haba sido definido';
	return undef;
    }
    return undef unless $sexo =~ /[MF]/;
    $gato->{sexo} = $sexo;
    return 1;
}

sub pon_pelo { my $gato = shift; $gato->{pelo} = shift; }

sub pon_peso {
    my $gato = shift; 
    $peso = shift; 
    return undef unless $peso =~ /^\d+$/;
    $gato->{peso} = $peso;
    return 1;
}

# Mtodos de instancia
sub come {
    my $gato = shift;
    my $cuanto_ingirio = shift;

    $gato->{lleno} += $cuanto_ingirio;
    $gato->vomita if ($gato->{lleno} > $gato->{peso} / 10);
    $gato->{sueo} += 2;

    return $gato->{lleno};
}

sub duerme {
    my $gato = shift;
    return 'No tengo sueo' if $gato->tiene_sueo < 1;
    $sueo = 0;

    return $sueo;
}

sub juega {
    my $gato = shift;
    return 'Estoy muy cansado' if $gato->tiene_sueo;
    return 'Tengo hambre' if $gato->tiene_hambre;
    $gato->{lleno} -= 1;
    $gato->{sueo} += 1;
    return 1;
}

sub vomita {
    my $gato = shift;
    $gato->{lleno} *= 2/3;
    return $gato->{lleno};
}

sub tiene_hambre {
    my $gato = shift;
    return ($gato->{lleno} < 5) ? 1 : 0;
}

sub tiene_sueo {
    my $gato = shift;
    return ($gato->{sueo} > 10) ? 1 : 0;
}

# Mtodos de clase
sub cuantos {
    my $clase = ref($_[0]) || $_[0];
    return $cantidad;
}
