/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_valid_d
 *
 * AUTHOR : Andrew Haisley
 *
 * This file 
 *
 * DESCRIPTION:
 *
 *  Dialogs with some validation routines for fields
 *
 *
 *
 *
 */
#ifndef MX_VALID_D_H
#define MX_VALID_D_H

#include <stdio.h>
#include <stdlib.h>

#include <mx_hash.h>
#include "mx_inform_d.h"
#include "mx_dialog.h"

class mx_valid_d : public mx_dialog
{
public:
    mx_valid_d(
            char  *name, 
            Widget parent, 
            bool   do_modal,
            bool   resizable);

    ~mx_valid_d();

    // runs an inform dialog by its resource name - all dialogs
    // run like this are cleaned up automatically when the object is
    // is deleted
    void run_inform(char *name, mx_inform_d_t type);

    bool validate_float(char *name, Widget w, float min, float max);
    bool validate_int(char *name, Widget w, int min, int max);

protected:
    mx_hash *inform_dialogs;
};

#endif
