/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_test_dlg
 *
 * AUTHOR : Tom Newton
 *
 * This file 
 *
 * DESCRIPTION:
 *
 *  An executable program to test various dialogues without having to build a
 *  complete maxwell system
 *
 *
 *
 *
 */

#include <mx.h>
#include "mx_dialog.h"
#include <Xm/Xm.h>

char *global_maxhome = NULL; 
Widget global_top_level;
XtAppContext global_app_context;

static void set_bitmap_path()
{
    static char temp[MAX_PATH_LEN];
    char *lp;

    // set the bitmap path
    lp = getenv("XBMLANGPATH");
#ifdef sun
    if (lp == NULL)
    {
        sprintf(temp, "XBMLANGPATH=%s/bitmaps/%%B", global_maxhome);
    }
    else
    {    
        sprintf(temp, "XBMLANGPATH=%s/bitmaps/%%B:%s", global_maxhome, lp);
    }
    putenv(temp);
#else
    if (lp == NULL)
    {
        sprintf(temp, "%s/bitmaps/%%B", global_maxhome);
    }
    else
    {    
        sprintf(temp, "%s/bitmaps/%%B:%s", global_maxhome, lp);
    }
    setenv("XBMLANGPATH", temp, TRUE);
    unsetenv("XAPPLRESDIR");
#endif
}

static void merge_resources()
{
    XrmDatabase db = NULL ;
    char file_name[MAX_PATH_LEN];

    db = XtDatabase(XtDisplay(global_top_level)) ;
    if(db == NULL) 
    {
        fprintf(stderr, "ERROR:couldn't get resource DB\n");
        exit(-1);
    }

    sprintf(file_name, "%s/resource/maxwell.rsc", global_maxhome);

    XrmCombineFileDatabase(file_name, &db, True);
}

#include "mx_tab_d.h"
void test1(int &err)
{
    {
        mx_tab_d td(global_top_level, FALSE);
        mx_ruler r;
        
        td.run(r, mx_inches);
    }
    {
        mx_tab_d td(global_top_level, FALSE);
        mx_ruler r;
        mx_tabstop a(mx_left, 10, mx_leader_dot_e);
        mx_tabstop b(mx_centre, 9.9, mx_leader_underline_e);
        mx_tabstop c(mx_right, 50, mx_leader_equals_e);
        
        r.add_tab(err, c);
        MX_ERROR_CHECK(err);
        
        r.add_tab(err, b);
        MX_ERROR_CHECK(err);
        
        r.add_tab(err, a);
        MX_ERROR_CHECK(err);
        
        td.run(r, mx_inches);
    }
abort:;
}

#include "mx_border_d.h"
#include <mx_nlist.h>
void test2(int &err)
{
    mx_border_style bds;
    mx_border_style_mod res;
    mx_nlist nl;
    mx_border_d bd(global_top_level, FALSE);

    nl.append_item(&bds);
    nl.append_item(&bds);
    nl.append();
    nl.append_item(&bds);
    nl.append_item(&bds);
    
    while (TRUE)
    {
        bd.run(nl, mx_inches, res);
        bds += res;
        res = mx_border_style_mod();
    }
abort:;
}

#include "mx_para_d.h"
void test3(int &err)
{
    mx_paragraph_style ps;
    mx_paragraph_style *ps1 = &ps;
    mx_paragraph_style **ps2 = &ps1;
    mx_paragraph_style_mod res;
    mx_para_d pd(global_top_level, FALSE);

    pd.run(ps2, 1, mx_inches, res);
abort:;
}

#include "mx_prog_d.h"
void test4(int &err)
{
    char message[100];
    mx_prog_d pd(global_top_level, FALSE);

    pd.centre();
    pd.activate("Crud");

    for (int i = 0; i < 10000; i++)
    {
        sprintf(message, "Crud Loop %d", i);
        pd.set_message(message);
    }
    pd.deactivate();
abort:;
}

void test5(int &err)
{
    mx_prog_d pd(global_top_level, TRUE);

    pd.centre();
    pd.activate("Crud");

    for (int i = 0; i < 10000; i++)
    {
        pd.set_progress(i / 100);
    }
    pd.deactivate();
abort:;
}

int main(int argc, char ** argv)
{
    int i;
    int err = MX_ERROR_OK;

    global_maxhome = getenv("MAXHOME");
    if(!global_maxhome)
    {
        global_maxhome = new char[100];
        strcpy(global_maxhome, "/usr/local/maxwell");
    }

    global_top_level = XtVaAppInitialize(&global_app_context, "Maxwell",
                                         NULL, 0, &argc, argv,
                                         NULL, NULL);

    merge_resources();
    set_bitmap_path();
    
    XtRealizeWidget(global_top_level);

    while (TRUE)
    {
        printf("tabs dialogue................1\n");
        printf("border dialogue..............2\n");
        printf("paragraph style dialogue.....3\n");
        printf("numeric progress dialogue....4\n");
        printf("bar progress dialogue........5\n");

        printf("which>");
        scanf("%d", &i);

        switch (i)
        {
        case 1 : test1(err); break;
        case 2 : test2(err); break;
        case 3 : test3(err); break;
        case 4 : test4(err); break;
        case 5 : test5(err); break;
        }
        MX_ERROR_CHECK(err);
    }
    return 0;
abort:
    global_error_trace->print();
    return -1;
}
