/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/param.h>
#include <mx.h>
#include <mx_path_exp.h>

char remote_path[MAX_PATH][MAX_MOUNTS];
char local_path[MAX_PATH][MAX_MOUNTS];

int num_mounts = 0;

static void add_mtab_entry(char *buf)
{
    int i = 0, j;

    /* does it represent a remote mount ? */
    while (TRUE)
    {
        if (isspace(buf[i]))
        {
            /* got a space before a ':', not remote */
            return;
        }
        if (buf[i] == 0)
        {
            return;
        }
        if (buf[i] == ':')
        {
            break;
        }
        i++;
    }

    /* copy up to the first space into remote path */
    i = 0;
    while (TRUE)
    {
        if (isspace(buf[i]))
        {
            remote_path[num_mounts][i] = 0;
            break;
        }
        remote_path[num_mounts][i] = buf[i];
        i++;
    }

    while (TRUE)
    {
        if (!isspace(buf[i++]))
        {
            i--;
            break;
        }
    }

    /* copy up to the next space into local path */
    j = 0;
    while (TRUE)
    {
        if (isspace(buf[i]))
        {
            local_path[num_mounts][j] = 0;
            break;
        }
        local_path[num_mounts][j] = buf[i];
        i++;
        j++;
    }
    num_mounts++;
}

static void setup_mtab()
{
    FILE *f;
    char buf[1001];

    num_mounts = 0;

#ifdef sun
    f = fopen("/etc/mnttab", "r");
#else
    f = fopen("/etc/mtab", "r");
#endif
    if (f == NULL)
    {
        return;
    }

    while (!feof(f))
    {
        fgets(buf, 1000, f);
        if (buf[0] != 0)
        {
            add_mtab_entry(buf);
        }
    }
    fclose(f);
}

void mx_realpath(char *path, char *resolved_path)
{
    static char root_name[MAX_PATH_LEN];
    static char temp_path[MAX_PATH_LEN];
    static char wd[MAX_PATH_LEN];
    int i;

    getcwd(wd, MAX_PATH_LEN);
    strcpy(temp_path, path);

    // first, extract the base name
    i = strlen(temp_path) - 1;
    while (temp_path[i] != '/' && i >= 0)
    {
        i--;
    }

    if (i != 0)
    {
        i++;
    }

    strcpy(root_name, temp_path + i);
  
    if (i != 0)
    {
        temp_path[i - 1] = 0;

        // it's not in the cwd, go there
        chdir(temp_path);
    }

    // get the directory again
    getcwd(resolved_path, MAX_PATH_LEN);

    // add the root name back on
    strcat(resolved_path, "/");
    strcat(resolved_path, root_name);

    // back to where we started
    chdir(wd);
}

char *mx_expand_path(char *path)
{
    int i, n;
    unsigned int s;
    static char res[1000];
    static char respath[1000];
    char hostname[100];

    mx_realpath(path, respath);

    setup_mtab();

    n = s = 0;
    for (i = 0; i < num_mounts; i++)
    {
        if (strncmp(respath, local_path[i], strlen(local_path[i])) == 0)
        {
            if (strlen(local_path[i]) > s)
            {
                n = i;
                s = strlen(local_path[i]);
            }
        }
    }
    
    if (s != 0)
    {
        strcpy(res, remote_path[n]);
        strcat(res, "/");
        strcat(res, respath + strlen(local_path[n]) + 1);
        return res;
    }
    else
    {
        if (gethostname(hostname, 99) < 0)
        {
            strcpy(res, respath);
            return res;
        }
        else
        {
            hostname[99] = 0;
            sprintf(res, "%s:%s", hostname, respath);
            return res;
        }
    }
}
