/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef MX_TYPE1_H
#define MX_TYPE1_H
/*
 * MODULE/CLASS : mx_type1
 *
 * AUTHOR : Andrew Haisley
 *
 * 
 * 
 * Description routines for manipulating type 1 fonts in clever and
 * interesting ways.
 *
 *
 *
 */

#include <mx.h>

// translates a type 1 pfb font into a type 1 pfa font
void mx_pfb_2_pfa(int &err, const char *in, const char *out);

// gets the font name out of a pfa
char *mx_pfa_name(int &err, char *in);

// gets the font name out of a pfb
char *mx_pfb_name(int &err, char *in);

// decrypt a type 1 font, generate our own font metrics file
void mx_type1_decrypt_font(int &err, char * t1_file, char * fm_file);

#endif
