/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE : mx_test_font_metrics.C
 *
 * AUTHOR : Tom Newton
 *
 * This file 
 *
 * DESCRIPTION: Use this program to test whether the mx_font_metrics class
 *              reads type 1 fonts correctly.
 * 
 *
 *
 *
 *
 */

#include <mx.h>
#include <mx_font.h>
#include <mx_font_metrics.h>

char * global_maxhome = "/usr/local/maxwell";

int main(int argc, char ** argv)
{
    int err = MX_ERROR_OK;
    mx_font_metrics fm;
    char output_name[MAX_PATH_LEN];

    if (argc == 3)
    {
        fm.read_type1(err, argv[1], argv[2]);
        MX_ERROR_CHECK(err);

        strcpy(output_name, fm.get_file_name());
        strcat(output_name, ".mfm");

        fm.write_mfm(err, output_name);
        MX_ERROR_CHECK(err);

        mx_font_metrics fm2;

        fm2.read_mfm(err, output_name);
        MX_ERROR_CHECK(err);

        printf("FM Object1:\n");
        printf("Family name: %s\n", fm.get_name());
        printf("X name: %s\n", fm.get_x_name());
        printf("PS name: %s\n", fm.get_ps_name());
        printf("File name: %s\n", fm.get_file_name());
        printf("Style: %d\n", (int)fm.get_style());
        printf("Ascender: %ld\n", fm.get_em_ascender());
        printf("Descender: %ld\n", fm.get_em_descender());

        printf("FM Object2:\n");
        printf("Family name: %s\n", fm2.get_name());
        printf("X name: %s\n", fm2.get_x_name());
        printf("PS name: %s\n", fm2.get_ps_name());
        printf("File name: %s\n", fm2.get_file_name());
        printf("Style: %d\n", (int)fm2.get_style());
        printf("Ascender: %ld\n", fm2.get_em_ascender());
        printf("Descender: %ld\n", fm2.get_em_descender());

        printf("ISO Num\t\tfm1wid\t\tfm2wid\n");
        for(int i = 0; i < 256; i++)
        {
            printf("%d\t\t%ld\t\t%ld\n", i, fm.get_em_width(i),
                   fm2.get_em_width(i));
        }
    }
    return 0;
abort:
    global_error_trace->print();
    return 1;
}

