/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "rastiff.h"
#include "rasjpeg.h"
#include "traster.h"
#include <Xm/DrawingA.h>
#include <Xm/ScrolledW.h>

int displayer(int argc,char **argv,raster *ras) ;

GC         gc ;
int width,height ;
raster    *gras ;

main(int argc,char **argv) 
{
   int err ;
   ipoint ipt(0,0);
   unsigned char *data,*data1 ;
   ipoint newSize(500,500) ;
   ipoint tileSize(64,60) ;
   ipoint tileSize2(24,80) ;


   rasjpeg test1("/raster/xv-3.10a/jpeg/testimg.jpg",FALSE,100) ;

   traster tester2(&test1) ;
   tester2.setSize(err,test1.getSize()) ;
   
/*   
   rastiff test1("/dosb/ionica/bwion.tif") ;


   traster tester5(&test1) ;
   
   tester5.setTileSize(err,tileSize2) ;
   
   traster tester1(&tester5) ;
   tester1.setPack(err,RPACK_BYTE) ;

   traster tester2(&tester1) ;
   tester2.setSize(err,newSize) ;
   tester2.setTileSize(err,tileSize) ;
   
   traster tester3(&tester2) ;
   tester3.setPack(err,RPACK_BIT) ;
*/
   displayer(argc,argv,&tester2) ;
/*
   data = tester3.tile(err,ipt) ;
   data1 = test1.tile(err,ipt) ;

   ipt.y = 1 ;

   data = tester3.tile(err,ipt) ;
   data1 = test1.tile(err,ipt) ;

   
   ipt.y = 2 ;

   data  = tester3.tile(err,ipt) ;
   data1 = test1.tile(err,ipt) ;

   ipt.y = 3 ;

   data = tester3.tile(err,ipt) ;
   data1 = test1.tile(err,ipt);
*/


}


void exposer(Widget da,XtPointer client_data,XtPointer call_data) 
{
   XGCValues   values; 
   XImage      *xImage ;
   rasterIterator rit ;
   ipoint      fullSize(gras->getTotalSize()) ;   
   irect       fullRaster(0,0,fullSize.x,fullSize.y) ;
   int         xtileSize,ytileSize ;
   int         err ;
   unsigned char *buffer ;
   irect        currentPixels ;
   unsigned char upbuffer[100000] ;
   
   XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) call_data ;

   xtileSize = gras->getTileSize().x ;
   ytileSize = gras->getTileSize().y ;
   
   if(gc == NULL) 
   {
      values.foreground = BlackPixel(XtDisplay(da),0) ;
      values.background = WhitePixel(XtDisplay(da),0) ;

      gc = XCreateGC(XtDisplay(da),XtWindow(da),(GCForeground|GCBackground),&values) ;
   }

   (fullRaster.xt)-- ;
   (fullRaster.yt)-- ;
   
   rit.set(err,gras,fullRaster) ;
   
   while(buffer = rit.next(err,currentPixels)) 
   {
     rasUnpack(xtileSize*ytileSize,buffer,upbuffer) ;
     rasPack(xtileSize*ytileSize,buffer,upbuffer) ;

     xImage = XCreateImage(XtDisplay(da),
			   DefaultVisual(XtDisplay(da),DefaultScreen(XtDisplay(da))),
			/*   1, XYBitmap, */
			   8,ZPixmap,
			   0, buffer,
			   xtileSize,
			   ytileSize,
/*			   8, (xtileSize+7)/8) ; */
			   8,xtileSize) ;
     

     xImage->byte_order       = LSBFirst;
     xImage->bitmap_bit_order = LSBFirst;

     XPutImage(XtDisplay(da), XtWindow(da),
	       gc, xImage, 0,0, 
	       currentPixels.xb, currentPixels.yb, xImage->width, xImage->height);
     
     xImage->data = NULL ;
     XDestroyImage(xImage) ;
     
   }
   
   return ;
}

int displayer(int argc,char **argv,raster *ras) 
{
   Widget da,toplevel,sw ;
   XtAppContext app_context ;
   int value,xhot,yhot ;
   int tester ;
   int   numColours ;
   mx_colour_t *colourArray ;
   unsigned char lut[256] ;
   XColor screenColour;
   bool gotPixel ;   
   traster *tras = (traster *) ras ;
   
   gras = ras ;
   
   toplevel = XtVaAppInitialize(&app_context,
				"Xtres",
				NULL,0,
				&argc,argv,NULL,
				NULL) ;

  sw = XtVaCreateManagedWidget("tester1",
                               xmScrolledWindowWidgetClass,
			       toplevel,
			       XmNwidth,500,
			       XmNheight,500,
			       XmNscrollingPolicy,XmAPPLICATION_DEFINED,
			       XmNscrollBarDisplayPolicy,XmSTATIC,
			       NULL) ;


   da = XtVaCreateManagedWidget("tester",
				xmDrawingAreaWidgetClass,
				sw,
			        XmNwidth,500,
				XmNheight,500,
				NULL) ;

   XtAddCallback(da,XmNexposeCallback,exposer,NULL) ;
   XtAddCallback(da,XmNresizeCallback,exposer,NULL) ;

   numColours = ras->getColours(&colourArray) ;
   
   for(int i=0;i<numColours;i++) 
   {
           // Try the pixel value 
      
      screenColour.red   = colourArray[i].red ;
      screenColour.green = colourArray[i].green ;
      screenColour.blue  = colourArray[i].blue ;

      gotPixel = XAllocColor(XtDisplay(da),
			     DefaultColormap(XtDisplay(da),DefaultScreen(XtDisplay(da))),
			     &screenColour) ;

      lut[i] = screenColour.pixel;
	   
   }

   int err ;
   
   tras->setLut(err,lut,numColours) ;

   XtRealizeWidget(toplevel) ;

   XtAppMainLoop(app_context) ;

}   









