/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include <stdio.h>
#include <mx.h>
#include <mx_db_object.h>
#include <mx_db_client.h>
#include <mx_attribute.h>
#include <mx_document.h>
#include <mx_sheet.h>
#include <mx_db_client_cache.h>
#include <rastiff.h>

void tester(uint32 cid)
{
    mx_db_object	*obj;
    mx_attribute	*a1,*a2,*a3;
    mx_attribute_value	v;
    int			err;
    mx_document		*doc;
    mx_sheet		*sheet1;
    mx_sheet		*sheet2;
    mx_image_area	*area;
    mx_polypoint_t	pp;
    mx_polypoint_t	*ol;
    int			i;
    mx_coord_t		coords[4];
    rastiff tester3("/dosb/ionica/bwion.tif") ;

    printf( "create a document\n" );
    doc=mx_db_client_open_document( err,cid,"/tmp/doc" );
    MX_ERROR_CHECK( err );

    printf( "set description\n" );
    doc->set_description( err,"a document" );
    MX_ERROR_CHECK( err );

    printf( "get description = %s\n",doc->get_description( err) );
    MX_ERROR_CHECK( err );

    printf( "num sheets=%d\n",doc->get_num_sheets( err ));
    MX_ERROR_CHECK( err );

    printf( "add a sheet\n" );
    sheet1=doc->add_sheet( err );
    MX_ERROR_CHECK( err );
    printf( "num sheets=%d\n",doc->get_num_sheets( err ));
    MX_ERROR_CHECK( err );

    printf( "add a sheet\n" );
    sheet2=doc->add_sheet( err );
    MX_ERROR_CHECK( err );
    printf( "num sheets=%d\n",doc->get_num_sheets( err ));

    (void)doc->sheet( err,0 );
    MX_ERROR_CHECK( err );
    (void)doc->sheet( err,1 );
    MX_ERROR_CHECK( err );

    printf( "%x %x %x %x\n", 
	sheet1,sheet2,
	doc->sheet( err,0 ),
	doc->sheet( err,1 ));

    printf( "add a text area\n" );
    area=sheet1->add_image_area( err );
    MX_ERROR_CHECK( err );
    printf( "num text areas = %d\n",sheet1->get_num_image_areas( err ));
    MX_ERROR_CHECK( err );


    
    area->attachRaster(err,tester3,COMP_UNCOMPRESSED) ;

    pp.num_coords=4;
    pp.coords=coords;
    coords[0].x=0.0;
    coords[0].y=0.0;
    coords[0].flag=TRUE;
    coords[1].x=100.0;
    coords[1].y=0.0;
    coords[1].flag=TRUE;
    coords[2].x=100.0;
    coords[2].y=100.0;
    coords[2].flag=TRUE;
    coords[3].x=0.0;
    coords[3].y=100.0;
    coords[3].flag=TRUE;

    printf( "set outline\n" );
    area->set_outline( err,pp );
    MX_ERROR_CHECK( err );

    printf( "get outline readonly\n" );
    ol=area->get_outline_readonly( err );
    MX_ERROR_CHECK( err );
    for( i=0; i<ol->num_coords; i++ ) {
	printf( "%d) %f,%f\n",i,ol->coords[i].x,ol->coords[i].y );
    }

    return;

abort:
    global_error_trace->print();
}

main( int argc, char *argv[] )
{
    int err;
    uint32 cid;
    int i;
    
    char name[100],password[100],server[100];


    printf( "name:" );
    scanf( "%s",name );
    printf( "password:" );
    scanf( "%s",password );
    printf( "server:" );
    scanf( "%s",server );

    (void)mx_db_client_login( err,cid,server,name,password );
    MX_ERROR_CHECK( err );

    printf( "Connection id=%d\n",cid );
     
    tester(cid);

abort:
    global_error_trace->print();
}

