/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <mx.h>
#include <mx_simple_w.h>
#include <mx_complex_w.h>
#include <mx_field_w.h>
#include <mx_space_w.h>
#include <mx_break_w.h>
#include <mx_paragraph.h>
#include <mx_document.h>
#include <maxwell.h>

char *global_maxhome;

void test1(int &err)
{
    mx_simple_word s1("hello");
    mx_simple_word s2(s1);
    mx_simple_word sp("wordsplit");
    mx_word *x;

    printf("s1.debug = "); s1.print_debug(); printf("\n");
    printf("s2.debug = "); s2.print_debug(); printf("\n");

    printf("s1.cstring=%s\n", s1.cstring());
    printf("s2.cstring=%s\n", s2.cstring());

    s2.set("world");

    printf("s2.cstring=%s\n", s2.cstring());

    printf("s1.debug = "); s1.print_debug(); printf("\n");
    printf("s2.debug = "); s2.print_debug(); printf("\n");

    for (int i = 0; i < 100; i++)
    {
        s1 += 'x';
    }

    printf("s1.cstring=%s\n", s1.cstring());

    printf("s1.debug = "); s1.print_debug(); printf("\n");
    printf("s2.debug = "); s2.print_debug(); printf("\n");

    s1 = "hello";
    s1 += s2;

    printf("s1.debug = "); s1.print_debug(); printf("\n");
    printf("s2.debug = "); s2.print_debug(); printf("\n");

    s1 += "morestuff";
    printf("s1.debug = "); s1.print_debug(); printf("\n");

    printf("s1.cstring=%s\n", s1.cstring());
    s1.insert(err, "-abc-", 1);
    MX_ERROR_CHECK(err);
    printf("s1.cstring=%s\n", s1.cstring());

    printf("s1.debug = "); s1.print_debug(); printf("\n");
    printf("s2.debug = "); s2.print_debug(); printf("\n");

    x = sp.split(err, 4);
    MX_ERROR_CHECK(err);

    printf("sp.cstring=%s   x.cstring=%s\n", sp.cstring(), x->cstring());

abort:;
}

void test2(int &err)
{
    mx_char_style a_style;
    mx_complex_word w("hello");
    mx_simple_word s("again");
    mx_char_style_mod m;
    mx_complex_word sp("helloworld");
    mx_word *x;

    w.set_style(&a_style);
    s.set_style(&a_style);
    sp.set_style(&a_style);

    w.print_debug();
    printf("\n");

    w += "world";

    w.print_debug();
    printf("\n");

    w += s;

    w.print_debug();
    printf("\n");

    w += m;
    w += 'x';
    w += m;

    w.print_debug();
    printf("\n");

    w += m;

    w.print_debug();
    printf("\n");

    w.insert(err, m, 2);
    MX_ERROR_CHECK(err);

    w.print_debug();
    printf("\n");

    w.insert(err, m, 2);
    MX_ERROR_CHECK(err);

    w.print_debug();
    printf("\n");

    w.remove(err, 5, 5);
    MX_ERROR_CHECK(err);

    w.print_debug();
    printf("\n");

    w.remove(err, 14, 14);
    MX_ERROR_CHECK(err);

    w.print_debug();
    printf("\n");

    x = sp.split(err, 4);
    MX_ERROR_CHECK(err);

    printf("sp.cstring=%s   x.cstring=%s\n", sp.cstring(), x->cstring());
abort:;
}

void test3(int &err)
{
    mx_field_word w1(mx_field_word::mx_date_time_field_e, mx_field_word::dt_hh24_mm_e, mx_field_word::dt_mm_dd_yyyy_e);
    mx_field_word w2(mx_field_word::mx_page_num_field_e);

    printf("w1.cstring=%s\n", w1.cstring());
    printf("w2.cstring=%s\n", w2.cstring());
abort:;
}

void test4(int &err)
{
abort:;
}

void test5(int &err)
{
abort:;
}

void test6()
{
    mx_simple_word *w;

    while (TRUE)
    {
        w = new mx_simple_word("hello");
        for (int i = 0; i < 100; i++)
        {
            *w = "start";
            for (int j = 0; j < 100; j++)
            {
                *w += "more";
            }
        }
        delete w;
    }
}


void test7(int &err)
{
    mx_paragraph_style p_st;
    mx_paragraph para;
    char s[500];
    int i;
    mx_simple_word *w;
    mx_space_word *sp;
    bool b = FALSE;
    mx_char_style_mod *cm;
    mx_char_style cs1, cs2;

    para.set_paragraph_style(&p_st);

    cs2.get_font()->set_size(72);

    for (i = 0; i < 20; i++)
    {
        sprintf(s, "word%d", i);
        w = new mx_simple_word(s);
        para.append_word(err, *w);
        MX_ERROR_CHECK(err);
        sp = new mx_space_word();
        sp->append_space();
        para.append_word(err, *sp);
        MX_ERROR_CHECK(err);
        cm = new mx_char_style_mod(cs1, cs2);
        para.append_mod(err, *cm);
        MX_ERROR_CHECK(err);
    }

    printf("\n\n==========================BEFORE FORMAT===============\n");
    para.print_debug();

    para.set_width(50.0);

    // reformat it
    para.reformat(err, b);
    MX_ERROR_CHECK(err);

    printf("\n\n==========================50mm WIDTH===============\n");
    para.print_debug();

    return;

abort:;
}

void test8(int &err)
{
    mx_paragraph para;
    char s[20];
    int i;
    mx_simple_word *w;
    mx_space_word *sp;

    for (i = 0; i < 1000; i++)
    {
        sprintf(s, "word%d", i);
        w = new mx_simple_word(s);
        para.append_word(err, *w);
        MX_ERROR_CHECK(err);
        sp = new mx_space_word();
        sp->append_space();
        para.append_word(err, *sp);
        MX_ERROR_CHECK(err);
    }

    para.set_width(50.0);

    bool b;

    while (TRUE)
    {
        printf(".");
        fflush(stdout);

        // reformat it
        para.reformat(err, b);
        MX_ERROR_CHECK(err);
    }
abort:;
}

void test9()
{
    mx_char_style *s;
    while (TRUE)
    {
        s = new mx_char_style;
        delete s;
    }
}

void test10()
{
    mx_font *f;
    while (TRUE)
    {
        f = new mx_font;
        delete f;
    }
}

void test11()
{
    mx_paragraph *para;
    char s[20];
    int i, err = MX_ERROR_OK;
    mx_simple_word *w;
    mx_space_word *sp;

    while (TRUE)
    {
        para = new mx_paragraph;
        for (i = 0; i < 100; i++)
        {
            sprintf(s, "word%d", i);
            w = new mx_simple_word(s);

            para->append_word(err, *w);
            MX_ERROR_CHECK(err);

            sp = new mx_space_word();
            sp->append_space();
            sp->append_tab();

            para->append_word(err, *sp);
            MX_ERROR_CHECK(err);

        }
        delete para;
    }

abort:;
}

void test12()
{
    mx_paragraph *para;
    char s[20];
    int i, err = MX_ERROR_OK, n;
    mx_simple_word *w;
    mx_space_word *sp;
    mx_para_pos pp;
    mx_para_pos pp_end;
    mx_paragraph_style st;
    bool b;
    int letter, old_line, para_letter_size = -1;

    while (TRUE)
    {
        para = new mx_paragraph;
        para->set_paragraph_style(&st);
        para->set_width(100.0);
        for (i = 0; i < 100; i++)
        {
            sprintf(s, "word%d", i);
            w = new mx_simple_word(s);

            para->append_word(err, *w);
            MX_ERROR_CHECK(err);

            sp = new mx_space_word();
            sp->append_space();
            sp->append_tab();

            para->append_word(err, *sp);
            MX_ERROR_CHECK(err);

        }

        para->reformat(err, b);
        MX_ERROR_CHECK(err);

        pp.moveto_end(err, para);
        MX_ERROR_CHECK(err);

        if (para_letter_size == -1)
        {
            pp.get_distance_from_start(err, para, para_letter_size);
            MX_ERROR_CHECK(err);

            n = para_letter_size;
        }
        else
        {
            n--;
            if (n == 0)
            {
                break;
            }
        }
        printf("n = %d\n", n);

        pp.set_distance_from_start(err, para, n);
        MX_ERROR_CHECK(err);

        while (TRUE)
        {
            para->delete_to_left(err, &pp);
            MX_ERROR_CHECK(err);

            if (pp.is_start())
            {
                break;
            }

            pp_end.moveto_end(err, para);
            MX_ERROR_CHECK(err);

            pp.get_distance_from_start(err, para, letter);
            MX_ERROR_CHECK(err);

            para->reformat(err, pp, pp_end, b);
            MX_ERROR_CHECK(err);

            pp.set_distance_from_start(err, para, letter);
            MX_ERROR_CHECK(err);
        }

        delete para;
    }
    return;

abort:
    global_error_trace->print();
}

void test13()
{
    int err = MX_ERROR_OK;
    mx_paragraph_style p_st;
    mx_paragraph para;
    char s[500];
    int i;
    mx_simple_word *w;
    mx_space_word *sp;
    bool b = FALSE;
    mx_char_style_mod *cm;
    mx_char_style cs1, cs2;

    para.set_paragraph_style(&p_st);

    cs2.get_font()->set_size(72);

    for (i = 0; i < 20; i++)
    {
        sprintf(s, "word%d", i);
        w = new mx_simple_word(s);
        para.append_word(err, *w);
        MX_ERROR_CHECK(err);
        sp = new mx_space_word();
        sp->append_space();
        para.append_word(err, *sp);
        MX_ERROR_CHECK(err);
        cm = new mx_char_style_mod(cs1, cs2);
        para.append_mod(err, *cm);
        MX_ERROR_CHECK(err);
    }

    printf("\n\n==========================BEFORE FORMAT===============\n");
    para.print_debug();

    para.set_width(50.0);

    // reformat it
    para.reformat(err, b);
    MX_ERROR_CHECK(err);

    printf("\n\n==========================50mm WIDTH===============\n");
    para.print_debug();

    {
        char *locked_by;
        char *locked_host;
        pid_t locked_pid;
        
        mx_document *doc = NULL;
        mx_paragraph usl_para;
        uint32 sl_size = 0;
        uint8 serial_buffer[10000];
        uint8 *buf_ptr = serial_buffer;
        
        printf("create a document\n");
        mx_db_cc_init(err);
        MX_ERROR_CHECK(err);

        doc = mx_db_client_open_temporary_wp_doc(err);
        MX_ERROR_CHECK(err);

        usl_para.set_document(doc);

        sl_size = para.get_serialised_size(err);
        MX_ERROR_CHECK(err);

        printf("\nparagraph reported serialised size = %ld\n", sl_size);

        para.serialise(err, &buf_ptr);

        printf("\nparagraph actual serialised size = %d\n", buf_ptr - serial_buffer);

        buf_ptr = serial_buffer;
        usl_para.unserialise(err, &buf_ptr);
        MX_ERROR_CHECK(err);

        usl_para.reformat(err, b);
        MX_ERROR_CHECK(err);

        printf("\nparagraph unserialised into new object -\n\n");
        usl_para.print_debug();
    }

    return;

abort:
    global_error_trace->print();
    MX_ERROR_CLEAR(err);
}

int main(int argc, char *argv[])
{
    int i;
    int err = MX_ERROR_OK;

    global_maxhome = getenv("MAXHOME");

    if(global_maxhome == NULL)
    {
        global_maxhome = new char[100];
        strcpy(global_maxhome, "/usr/local/maxwell");
    }

    while (TRUE)
    {
        printf("simple word..................1\n");
        printf("complex word.................2\n");
        printf("field word...................3\n");
        printf("space word...................4\n");
        printf("break word...................5\n");
        printf("thrash simple word...........6\n");
        printf("words in a paragraph.........7\n");
        printf("reformat speed/thrash........8\n");
        printf("style creation thrash........9\n");
        printf("font creation thrash.........10\n");
        printf("paragraph creation thrash....11\n");
        printf("delete to left thrash........12\n");
        printf("paragraph/word serialisation.13\n");

        printf("which>");
        scanf("%d", &i);

        switch (i)
        {
            case 1 : test1(err); MX_ERROR_CHECK(err); break;
            case 2 : test2(err); MX_ERROR_CHECK(err); break;
            case 3 : test3(err); MX_ERROR_CHECK(err); break;
            case 4 : test4(err); MX_ERROR_CHECK(err); break;
            case 5 : test5(err); MX_ERROR_CHECK(err); break;
            case 6 : test6(); break;
            case 7 : test7(err); MX_ERROR_CHECK(err); break;
            case 8 : test8(err); MX_ERROR_CHECK(err); break;
            case 9 : test9(); break;
            case 10 : test10(); break;
            case 11 : test11(); break;
            case 12 : test12(); break;
            case 13 : test13(); break;
        }
    }
abort:
    global_error_trace->print();
}
