/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <mx_nlist.h>
#include <mx_list.h>
#include <mx_list_iter.h>
#include <mx_nlist_iter.h>

static mx_nlist list;
static mx_nlist list2;

void print_nlist(mx_nlist &l)
{
    mx_list_iterator iter1(l.list);

    printf("\n\n-----------------------list------------\n");

    while (iter1.more())
    {
        mx_list *row = (mx_list *)iter1.data();

        mx_list_iterator iter2(*row);

        printf(">  ");

        while (iter2.more())
        {
            int i = (int)iter2.data();
            printf("%02d ", i);
        }
        printf("\n");
    }
}


void test1(int &err)
{
    int i;
    mx_list *l;

    printf("row num>");
    scanf("%d", &i);

    l = list.row(err, i);
    mx_list_iterator iter = mx_list_iterator(*l);

    MX_ERROR_CHECK(err);

    while (iter.more())
    {
        i = (int)iter.data();
        printf("%02d ", i);
    }

    printf("\n");

abort:;
}

void test2(int &err)
{
    int row, item, i;

    printf("row>");
    scanf("%d", &row);

    printf("item>");
    scanf("%d", &item);

    i = (int)list.item(err, row, item);
    MX_ERROR_CHECK(err);

    printf("%02d\n", i);
abort:;
}

void test3(int &err)
{
    int row;

    printf("row number to insert at>");
    scanf("%d", &row);

    mx_list *l = list.insert(err, row);
    MX_ERROR_CHECK(err);

    if (l->get_num_items() != 0)
    {
        printf("ERROR:new list is not empty\n");
        exit(-1);
    }

abort:;
}

void test4(int &err)
{
    int row, item, value;

    printf("row>");
    scanf("%d", &row);

    printf("item>");
    scanf("%d", &item);

    printf("value>");
    scanf("%d", &value);

    list.insert(err, (void *)value, row, item);
    MX_ERROR_CHECK(err);

abort:;
}

void test5()
{
    mx_list *new_row = new mx_list;
    int i;

    for (i = 0; i < 5; i++)
    {
        new_row->append((void *)i + 100);
    }
    list.append(new_row);
}

void test6(int &err)
{
    int row;

    printf("row>");
    scanf("%d", &row);

    list.delete_row(err, row);
    MX_ERROR_CHECK(err);

abort:;
}

void test7(int &err)
{
    int row, item;

    printf("row>");
    scanf("%d", &row);

    printf("item>");
    scanf("%d", &item);

    list.delete_item(err, row, item);
    MX_ERROR_CHECK(err);

abort:;
}

void test8(int &err)
{
    int row, n;

    printf("row>");
    scanf("%d", &row);

    printf("how many>");
    scanf("%d", &n);

    list.move_items_out_end(err, row, n);
    MX_ERROR_CHECK(err);

abort:;
}

void test9(int &err)
{
    int row, n;

    printf("row>");
    scanf("%d", &row);

    printf("how many>");
    scanf("%d", &n);

    list.move_items_out_start(err, row, n);
    MX_ERROR_CHECK(err);

abort:;
}


void test10(int &err)
{
    int row, n;

    printf("row>");
    scanf("%d", &row);

    printf("how many>");
    scanf("%d", &n);

    list.move_items_in_end(err, row, n);
    MX_ERROR_CHECK(err);

abort:;
}

void test11(int &err)
{
    int row, n;

    printf("row>");
    scanf("%d", &row);

    printf("how many>");
    scanf("%d", &n);

    list.move_items_in_start(err, row, n);
    MX_ERROR_CHECK(err);

abort:;
}

void test12(int &err)
{
    int rows;

    printf("rows>");
    scanf("%d", &rows);

    list.move_rows_out_end(err, rows, list2);
    MX_ERROR_CHECK(err);

abort:;
}

void test13(int &err)
{
    int rows;

    printf("rows>");
    scanf("%d", &rows);

    list.move_rows_out_start(err, rows, list2);
    MX_ERROR_CHECK(err);

abort:;
}

void test14(int &err)
{
    int rows;

    printf("rows>");
    scanf("%d", &rows);

    list.move_rows_in_end(err, rows, list2);
    MX_ERROR_CHECK(err);

abort:;
}

void test15(int &err)
{
    int rows;

    printf("rows>");
    scanf("%d", &rows);

    list.move_rows_in_start(err, rows, list2);
    MX_ERROR_CHECK(err);

abort:;
}

void test17()
{
    mx_nlist *fred;

    while (TRUE)
    {
		fred = new mx_nlist;
		fred->append_item(NULL);
		fred->append_item(NULL);
		fred->append_item(NULL);
		delete fred;
    }
}

void test16()
{
    mx_nlist_iterator iter(list);

    printf("forwards--------------------------------\n");

    while (iter.more())
    {
        int i = (int)iter.data();
        printf("%02d ", i);
    }
    printf("\n");

    printf("rewind-----------------------------------\n");
    iter.rewind();

    while (iter.more())
    {
        int i = (int)iter.data();
        printf("%02d ", i);
    }
    printf("\n");

    printf("rewind & backwards-------------------------\n");
    iter.rewind(mx_backwards_e);

    while (iter.more())
    {
        int i = (int)iter.data();
        printf("%02d ", i);
    }
    printf("\n");
}

main()
{
    mx_list *row;
    int i, j;
    int err = MX_ERROR_OK;

    for (i = 0; i < 10; i++)
    {
        row = list.append();

        for (j =0; j < 10; j++)
        {
            row->append((void *)(i * 10 + j));        
        }
    }

    for (i = 0; i < 10; i++)
    {
        row = list2.append();

        for (j =0; j < 10; j++)
        {
            row->append((void *)(100 + i * 10 + j));        
        }
    }

    print_nlist(list);
    print_nlist(list2);

    while (TRUE)
    {
        printf("get row......................1\n");
        printf("get item.....................2\n");
        printf("insert new empty row.........3\n");
        printf("insert new item..............4\n");
        printf("append a new row.............5\n");
        printf("delete row...................6\n");
        printf("delete item..................7\n");
        printf("move items out of end........8\n");
        printf("move items out of start......9\n");
        printf("move items in end............10\n");
        printf("move items in start..........11\n");
        printf("move rows out of end.........12\n");
        printf("move rows out of start.......13\n");
        printf("move rows in end.............14\n");
        printf("move rows in start...........15\n");
        printf("iterate......................16\n");
        printf("thrash.......................17\n");

        printf("which>");
        scanf("%d", &i);

        switch (i)
        {
            case 1 :
                test1(err);
                MX_ERROR_CHECK(err);
                break;
            case 2 :
                test2(err);
                MX_ERROR_CHECK(err);
                break;
            case 3 :
                test3(err);
                MX_ERROR_CHECK(err);
                break;
            case 4 :
                test4(err);
                MX_ERROR_CHECK(err);
                break;
            case 5 :
                test5();
                break;
            case 6 :
                test6(err);
                MX_ERROR_CHECK(err);
                break;
            case 7 :
                test7(err);
                MX_ERROR_CHECK(err);
                break;
            case 8 :
                test8(err);
                MX_ERROR_CHECK(err);
                break;
            case 9 :
                test9(err);
                MX_ERROR_CHECK(err);
                break;
            case 10 :
                test10(err);
                MX_ERROR_CHECK(err);
                break;
            case 11 :
                test11(err);
                MX_ERROR_CHECK(err);
                break;
            case 12 :
                test12(err);
                MX_ERROR_CHECK(err);
                break;
            case 13 :
                test13(err);
                MX_ERROR_CHECK(err);
                break;
            case 14 :
                test14(err);
                MX_ERROR_CHECK(err);
                break;
            case 15 :
                test15(err);
                MX_ERROR_CHECK(err);
                break;
            case 16 :
                test16();
                break;
            case 17 :
                test17();
                break;
        }
        print_nlist(list);
        print_nlist(list2);
    }
    return -1;
abort:
    global_error_trace->print();
}
