/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE : iterator.h
 *
 * AUTHOR : David Miller
 *
 * 
 *
 * DESCRIPTION: Iterator definitions to go with mx_attribute_value
 * collections
 * Module iterator.h 
 * 
 *
 *
 *
 */

#ifndef ITERATOR_H
#define ITERATOR_H

#include "collection.h"

typedef enum
{
   mx_it_head,
   mx_it_tail,
   mx_it_pos,
   mx_it_value
} 
mx_it_start_type ;

typedef enum
{
    mx_forwards_e,
    mx_backwards_e
}
mx_iter_dir_t;


/*-------------------------------------------------
 * CLASS: iterator
 *
 * DESCRIPTION: Iterator for mx_attribute collections
 * 
 *
 */

class iterator
{
friend class collection ;

public:
   // Error code from constructor
   iterator(int &err,collection *collect,bool increment = TRUE) ;

   virtual ~iterator() ;

   void              reset(int &err,collection *collect=NULL,bool increment = TRUE) ;

   void              start(int &err,
               mx_it_start_type   startType   = mx_it_tail,
               mx_attribute_value *startValue = NULL) ;
 
   bool               next(int &err,
               mx_attribute_value  *key = NULL,
               mx_attribute_value  *data =NULL) ;

   bool              isValid() ;
   bool              isIncrement() ;
 
   void              setIncrement(bool increment) ;

   clearCollection() ;

   void              go(int &err) ;
protected:
private:
   bool       increment ; 
   collection *collect ;
   node       *n ;

   virtual void      go_fn(int                &err,
               mx_attribute_value *key, 
               mx_attribute_value *data) ;

} ;

typedef iterator* IND_PTR ;


/*-------------------------------------------------
 * FUNCTION: iterator::setIncrement
 *
 * DESCRIPTION: Set the increment direction
 *
 */

inline void iterator::setIncrement(bool inc)
{
   increment = inc ;
}

/*-------------------------------------------------
 * FUNCTION: iterator::isValid
 *
 * DESCRIPTION: Test if the iterator is valid for 
 * another iteration
 *
 */

inline bool iterator::isValid()
{
   return (collect != NULL) && (n != NULL) ;
}


/*-------------------------------------------------
 * FUNCTION: iterator::isIncrement
 *
 * DESCRIPTION: Test if the iterator is valid for 
 * another iteration
 *
 */

inline bool iterator::isIncrement()
{
   return increment ;
}


#endif
