//	mycmdw.h:	Header for mycmdw class
//=======================================================================

#ifndef myCMDW_H
#define myCMDW_H

#include <v/vcmdwin.h>	// So we can use vCmdWindow
#include <v/vmenu.h>	// For the menu pane
#include <v/vutil.h>	// For V Utilities
#include <v/vcmdpane.h> // command pane
#include <v/vstatusp.h>	// For the status pane
#include <v/vtimer.h>	// Timer

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include "mycnv.h"	// myTextCanvasPane
#include "mydlg.h"	// myDialog
#include "mymdlg.h"	// myModalDialog

    class myCmdWindow;

    class myTimer : public vTimer
      {
      public:		//---------------------------------------- public
	myTimer(myCmdWindow* cw) { cmdw = cw; }
	~myTimer() {}
	virtual void TimerTick();
      private:		//--------------------------------------- private
	myCmdWindow* cmdw;
      };

    class myAuxTimer : public vTimer
      {
      public:		//---------------------------------------- public
	myAuxTimer(myCmdWindow* cw) { cmdw = cw; }
	~myAuxTimer() {}
	virtual void TimerTick();
      private:		//--------------------------------------- private
	myCmdWindow* cmdw;
      };

    class myCmdWindow : public vCmdWindow
      {
	friend int AppMain(int, char**);	// allow AppMain access

      public:		//---------------------------------------- public
	myCmdWindow(char*, int, int);
	virtual ~myCmdWindow();
	virtual void WindowCommand(ItemVal id, ItemVal val, CmdType cType);
	virtual void KeyIn(vKey keysym, unsigned int shift);
	myAuxTimer* GetmyAuxTimer() {return _auxTimer;}// Aux Timer

      protected:	//--------------------------------------- protected

      private:		//--------------------------------------- private

	// Standard elements
	vMenuPane* myMenu;		// For the menu bar
	//myTextCanvasPane* myCanvas;		// For the canvas
	vCanvasPane* myCanvas;
	vCommandPane* myCmdPane;	// for the command pane
	vStatusPane* myStatus;		// For the status bar
	myTimer* _timer;	// Timer for Date/Time
	myAuxTimer* _auxTimer;	// Aux Timer

	// Dialogs associated with CmdWindow

	myDialog* myDlg;
	myModalDialog* myMDlg;

      };
#endif
