.TH rat G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
rat - Floating point rational approximation 
.SH CALLING SEQUENCE
.nf
[N,D]=rat(x [,tol])
y=rat(x [,tol])
.fi
.SH PARAMETERS
.TP 10
x 
: real  vector or matrix
.TP 10
n
: integer vector or matrix 
.TP 10
d
: integer vector or matrix 
.TP 10
y
: real vector or matrix 
.SH DESCRIPTION
\fV[N,D] = rat(x,tol)\fR returns two integer
matrices so that \fVN./D\fR is close to\fVx\fR in the sense that
\fVabs(N./D - X) <= tol*abs(x)\fR. The rational approximations are
generated by truncating continued fraction expansions.   
\fVtol = 1.e-6*norm(X,1)\fR is the default.
\fVy = rat(x,tol)\fR return the quotient \fVN./D\fR

.SH SEE ALSO
int, round
.SH EXAMPLES
.nf
[n,d]=rat(%pi)
[n,d]=rat(%pi,1.d-12)
n/d-%pi
.fi
