.TH isreal G "April 1998" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
isreal -  check if a variable as real or complex entries
.SH CALLING SEQUENCE
.nf
t=isreal(x)
t=isreal(x,eps)
.fi
.SH PARAMETERS
.TP
x 
: vector or matrix with floating point entries or coefficients
.TP
t
: a boolean
.SH DESCRIPTION
\fVisreal(x)\fR returns true if x is stored as a real variable and
false if x stores complex numbers.
.LP
\fVisreal(x,eps)\fR returns true if x is stored as a real variable or
if maximum absolute value of imaginary floating points if less or equal
than eps. 
.SH EXAMPLE
.nf
isreal([1 2])
isreal(1+0*%i)
isreal(1+0*%i,0)
isreal(1+%s)
isreal(sprand(3,3,0.1))
.fi

