.TH balreal 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
balreal - balanced realization
.SH CALLING SEQUENCE
.nf
[slb [,U] ] = balreal(sl)
.fi
.SH PARAMETERS
.TP
sl,slb
: linear systems (\fVsyslin\fR lists)
.SH DESCRIPTION
Balanced realization of linear system \fVsl=[A,B,C,D]\fR. \fVsl\fR
can be a continuous-time or discrete-time state-space system. 
sl is assumed stable.
.nf
slb=[inv(U)*A*U ,inv(U)*B , C*U , D]
.fi
is the balanced realization.
.LP
\fVslb\fR is returned as a \fVsyslin\fR list.
.SH EXAMPLE
.nf
A=diag([-1,-2,-3,-4,-5]);B=rand(5,2);C=rand(1,5);
sl=syslin('c',A,B,C);
[slb,U]=balreal(sl);
Wc=clean(ctr_gram(slb))
W0=clean(obs_gram(slb))
.fi
.SH SEE ALSO
ctr_gram, obs_gram, hankelsv, equil, equil1

