.TH armac 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
armac - Scilab description of an armax process
.SH CALLING SEQUENCE
.nf
[ar]=armac(a,b,d,ny,nu,sig)
.fi
.SH PARAMETERS
.TP 20
a=[Id,a1,..,a_r]
: is a matrix of size (ny,r*ny)
.TP
b=[b0,.....,b_s]
: is a matrix of size (ny,(s+1)*nu)
.TP 
d=[Id,d1,..,d_p]
: is a matrix of size (ny,p*ny);
.TP 
ny 
: dimension of the output  y
.TP 
nu 
: dimension of the output  u 
.TP 
sig 
: a matrix of size (ny,ny)
.SH DESCRIPTION
This function creates a description as a tlist of an  ARMAX process 
.IG
.nf
   A(z^-1)y= B(z^-1)u + D(z^-1)sig*e(t)
.fi
.FI
.LA $$   A(z^{-1})y= B(z^{-1})u + D(z^{-1})sig*e(t)$$
\fVar\fR is defined by 
.nf
ar=tlist(['ar','a','b','d','ny','nu','sig'],a,b,d,ny,nu,sig);
.fi
and thus the coefficients of \fVar\fR can be retrieved by e.g.
\fV ar('a') \fR.
.SH EXAMPLE
.nf 
a=[1,-2.851,2.717,-0.865].*.eye(2,2)
b=[0,1,1,1].*.[1;1];
d=[1,0.7,0.2].*.eye(2,2);
sig=eye(2,2);
ar=armac(a,b,d,2,1,sig)
// extract polynomial matrices from ar representation 
[A,B,D]=arma2p(ar);
.fi
.SH SEE ALSO
arma, armax, armax1, arsimul, arma2p, tlist.






