/* hfill.c: Read in data, fill basins, write out.            */
/* NOTE!! DOES NOT WORK YET!! ------------------------       */
/*           John P. Beale 6/10/95                           */

#include <stdio.h>                      /* fopen() sprintf() etc. */
#include <stdlib.h>                     /* strtod() */
#include <math.h>                       /* math stuff */
#include <string.h>                     /* strcpy() */
#include "hcon.h"

#define U unsigned

int fill(PTYPE **hh, PTYPE **dt, U xsize, U ysize, PTYPE stepsize);
int fill_1(PTYPE **hh, PTYPE **dt, U xsize, U ysize, int x, 
    int y, PTYPE hinc, int *xout, int *yout);  /* one iteration of fill basin */

int read_mfile(PTYPE **hh, U int *x, U int *y, char *f);
int write_mfile(char *f, char *m);      /* write out matlab file */

void hf_print();  /* print out hf array on stdout */

void renorm();                          /* normalize array */

static PTYPE *hf;                            /* height field array */
static PTYPE *dt;                            /* delta_height array */
static U int xsize, ysize;     /* size of hf array (input xsize+2) */

int xo[9] =                      /* 8-dir index offset arrays */
   { 0,-1,0,1,1,1,0,-1,-1 };
int yo[9] =
   { 0,-1,-1,-1,0,1,1,1,0 };

/* ---------------------------------- */

int main(int argc, char **argv)
{ char *usage = 
"hfill: A Heightfield Basin Filler v0.1a (c) <beale@jump.stanford.edu> 1995\n\
 Usage: hfill <infile> <outfile> stepsize\n\
	reads in, write out MAT format files.\n";
  
  char fname_in[160];
  char fname_out[160];
  char *buf;
  int rval;
  size_t mn;
  
  PTYPE stepsize;

  if ((argc < 4) || (argc > 4)) {
	fprintf(stderr,"%s",usage);
	exit(1);
      }
 
  strcpy(fname_in,argv[1]);
  strcpy(fname_out,argv[2]);
  stepsize = (PTYPE) strtod(argv[3], &buf);

  rval = read_mfile(&hf,&xsize,&ysize,fname_in);

   printf("%s: [%d x %d] \n",fname_in,xsize,ysize);
   
   mn = xsize * ysize; /* size of array */
   if ((dt = (PTYPE *) malloc(mn*sizeof(PTYPE)) ) == NULL) {
     perror("Could not allocate memory for delta array.\n");
     exit(1);
   }
  

   printf("filling basins\n");
   
   fill(&hf, &dt, xsize, ysize, stepsize);

   if (xsize < 9) hf_print();  /* print small arrays */

   printf("Writing Matlab file...\n");
   rval = write_mfile(fname_out,"topo");

  return(rval);    /* return a value */

} /* end main() */


void hf_print()  /* print out hf array on stdout */
{
  int ix,iy;

   printf("Heightfield array: %dx%d\n",xsize,ysize);
   for (iy = 0; iy<ysize; iy++) {
    printf("%d:",iy);
    for (ix = 0; ix<xsize; ix++) {
	printf(" %1.2f",El(hf,ix,iy));
    }
     printf("\n");
   }
}

/* -------------------------------------------------------------- */
/* read_mfile --  read in data matrix in Matlab Level 1.0 format  */
/*               and put data in header "x" and data array "hf"   */
/* -------------------------------------------------------------- */

int read_mfile(
PTYPE **hh, 
U int *xs,
U int *ys,
char *fname )
{
  char pname[80]="dat1\x00";           /* data matrix name, null-terminated*/
  int mn;
  Fmatrix hd;                           /* header */

  int a,b,c,i,j;
  int etype;
  int mtype,prec,rem,numtype;
  double tdbl;
  float tflt;
  FILE *fpin;

   /* --------- read in Matlab-format (Level 1.0) file ------- */

   etype = (NUM_FMT*1000) + (PREC*10);    /* expected data type flag */

   if ((fpin = fopen(fname,"rb")) == NULL) {
    perror("could not open file.\n");
    exit(1);
   }

   printf("Opening matlab file %s...\n",fname);

   a = fread(&hd, sizeof(Fmatrix),(size_t)1, fpin);          /* read header */
    if (a != 1) {
      perror("Problem reading matlab file header.\n");
      exit(1);
    }
   numtype = (hd.type % 10000)/1000;
   prec = (hd.type % 100)/10;
   mtype = (hd.type % 10);
   rem = (hd.type - (1000*numtype + 10*prec + mtype));
/*   printf("Data type flag: M%d P%d T%d R%d\n",
       numtype,prec,mtype,rem); */
   if ( (numtype!=NUM_FMT) || ((prec!=0)&&(prec!=1)) || (mtype!=0) )  {
     perror("Unsupported file format type\n");
     exit(1);
   }
   b = fread(pname, sizeof(char), (size_t)hd.namelen, fpin); /* read mx name */
   xs[0] = hd.ncols;
   ys[0] = hd.mrows;
   xsize = xs[0];
   mn = (hd.mrows) * (hd.ncols); /* size of array */
   if ((hh[0] = (PTYPE *) malloc(mn*sizeof(PTYPE)) ) == NULL) {
     perror("Could not allocate memory for input array.\n");
     exit(1);
   }
   if (prec==1) {               /* read in floats 1 by 1 */
     for (i=0;i<xs[0];i++) {
      for (j=0;j<ys[0];j++) {   /* format is columns saved first */
       c = fread(&tflt, sizeof(float), 1, fpin);
       if (c != 1) {
	 perror("Trouble reading data from file.\n");
	 exit(1);
       }
       El(hh[0],i,j) = (PTYPE) tflt;
      } /* end for j */
     } /* end for i */
   } else if (prec==0) {                     /* read doubles 1 by 1 and convert */

     for (i=0;i<xs[0];i++) {
      for (j=0;j<ys[0];j++) {   /* format is columns saved first */
       c = fread(&tdbl, sizeof(double), 1, fpin);
       if (c != 1) {
	 perror("Trouble reading data from file.\n");
	 exit(1);
       }
       El(hh[0],i,j) = (PTYPE) tdbl;
      } /* end for j */
     } /* end for i */

   } else {
	perror("Unsupported floating-point type\n");
	exit(1);
   } /* end else */

   fclose( fpin );

  return(0);

} /* end read_mfile */


/* --------------------------------------------------------------  */
/* write_mfile -- write out data matrix in Matlab Level 1.0 format */
/*               creates data header fhdr from xsize, ysize and    */
/*               writes data array 'hf'                            */
/* --------------------------------------------------------------  */

int write_mfile(char *fname, char *pname)
{
FILE *fpout;
Fmatrix fhdr;
int rv,mn,i,j,c;

   fpout = fopen(fname,"wb");
   if (fpout == NULL)
    { perror("Error opening file.\n");
      exit(1);
    }
   fhdr.type = NUM_FMT*1000 + PREC*10;
   fhdr.ncols = xsize;
   fhdr.mrows = ysize;
   fhdr.imagf = 0;
   fhdr.namelen = strlen(pname) + 1;

   rv = fwrite(&fhdr, sizeof(Fmatrix),(size_t)1, fpout);          /* write header */
   if (rv != 1) {
     perror("Error writing file.\n");
     exit(1);
   }
   rv = fwrite(pname, sizeof(char), (size_t)fhdr.namelen, fpout);   /* write mx name */
   if (rv != fhdr.namelen) {
     perror("Error writing file.\n");
     exit(1);
   }
   mn = fhdr.mrows * fhdr.ncols;

   for (i=0;i<xsize;i++) {
      for (j=0;j<ysize;j++) {   /* format is columns saved first */

       c = fwrite(&El(hf,i,j), sizeof(PTYPE), 1, fpout);
       if (c != 1) {
	 perror("Trouble writing data to file.\n");
	 exit(1);
       }
      } /* end for j */
   } /* end for i */

  if (fclose( fpout ) == EOF) {
	perror("Error closing file.\n");
	exit(1);
  }

  return(0);
} /* end write_mfile */





/* -----------------------------------------------------------
 * A Seed Fill Algorithm
 * from "Graphics Gems", Academic Press, 1990
 * Paul Heckbert        13 Sept 1982, 28 Jan 1987
 * mods for a 3-d heightfield filling routine: JPB 7/16/95
 * 
 * Since each call to fill_1() might encounter several outlet
 * points, we have to treat each outlet point as a wall (ie, stop
 * filling there, otherwise we'd overflow the whole surface), add it to
 * a list, and when we're done this whole round, examine all the outlets
 * and find the lowest one. This is the "real" outlet, so go back
 * and reshape the surface to indicate this fact.
 * ----------------------------------------------------------- */

typedef struct {                /* window: a discrete 2-D rectangle */
    int x0, y0;                 /* xmin and ymin */
    int x1, y1;                 /* xmax and ymax (inclusive) */
} Window;

Window win;                     /* holds limits 0..xsize, 0..ysize */

typedef int Pixel;              /* 1-channel frame buffer assumed */

PTYPE hfread();                 /* read height at this point in hf */

typedef struct {short y, xl, xr, dy;} Segment;
/*
 * Filled horizontal segment of scanline y for xl<=x<=xr.
 * Parent segment was on line y-dy.  dy=1 or -1
 */

#define MAX_DEPTH 10000               /* max depth of stack */

#define PUSH(Y, XL, XR, DY)     /* push new segment on stack */ \
  if ((sp<stack+MAX_DEPTH) && (Y+(DY) >= win.y0) && (Y+(DY) <= win.y1)) \
  {sp->y = Y; sp->xl = XL; sp->xr = XR; sp->dy = DY; sp++;}

#define POP(Y, XL, XR, DY)      /* pop segment off stack */ \
    {sp--; Y = sp->y+(DY = sp->dy); XL = sp->xl; XR = sp->xr;}

/*
 * fill_1() --  fill in the array from (x,y) and all of its 4-neighbors
 * with current elevations less than (hh[x,y] + hinc).  Quit when we find
 * an outlet, that is, a point where the elevation drops away below hh[x,y].
 * A 4-connected neighbor is a pixel above, below, left, or right of a pixel.
 */

int fill_1(PTYPE **hh, PTYPE **dt, U xsize, U ysize, int x, int y, 
	   PTYPE hinc, int *xout, int *yout)

/* hh[0]            heightfield array */
/* dt[0]            delta array */
/* x, y             seed point */
/* Window *win      x,y limits for filling */
/* hinc             height increment to be added */
/* xout, yout       coordinates of outlet point (if found) */
{
 int l, x1, x2, dy;
 Segment stack[MAX_DEPTH], *sp = stack;    /* stack of filled segments */
 PTYPE el_start, tr;    /* tr = initial elevation + hinc */

 win.x0 = 0; win.x1 = xsize;
 win.y0 = 0; win.y1 = ysize;

    el_start = El(hh[0],x,y);       /* elevation at initial point */
    tr = el_start + hinc;           /* waterlevel to fill to this level */
    
    PUSH(y, x, x, 1);                   /* needed in some cases */
    PUSH(y+1, x, x, -1);                /* seed segment (popped 1st) */

    while (sp>stack) {
	/* pop segment off stack and fill a neighboring scan line */
	POP(y, x1, x2, dy);
	/*
	 * segment of scan line y-dy for x1<=x<=x2 was previously filled,
	 * now explore adjacent pixels in line y
	 */
	for (x=x1; ( x>=win.x0) && (El(hh[0],x,y)<tr) ; x--) { /* fill left */
	    if (El(hh[0],x,y) < (el_start-hinc)) /* found an outlet? */
	     { xout[0] = x; yout[0] = y;
	       return(1);       /* signal we found an outlet */
	     }
	    El(hh[0],x,y) = tr;      /* bring hh value up to current limit */
	 }
	if (x>=x1) goto skip;        /* didn't fill any in above "for" */

	l = x+1;                        /* did fill some, [l..x] */
	if (l<x1) PUSH(y, l, x1-1, -dy);      /* (vertical) leak on left? */
	x = x1+1;
	do {
	    for (; x<=win.x1 && (El(hh[0],x,y)<tr); x++) { /* fill right */
	       if (El(hh[0],x,y) < (el_start-hinc)) /* found an outlet? */
		{ xout[0] = x; yout[0] = y;
		  return(1);       /* signal we found an outlet */
		}
		El(hh[0],x,y) = tr;
	    }
	    PUSH(y, l, x-1, dy);
	    if (x>x2+1) PUSH(y, x2+1, x-1, -dy);        /* leak on right? */
 
	   /* feel our way rightwards along this wall (height > tr) 
	      which is vertically offset 1 from a previous filled line */
skip:       for (x++; x<=x2 && (El(hh[0],x,y) > tr); x++);  /* move right */
	    l = x;      /* either x > x2,  or we've hit a dip on this line */
	} while (x<=x2);  /* if (x > x2), we're done with this item */
			  /* otherwise it's a dip, so go back to work */

    }     /* end while (sp > stack */

    return(0);          /* did not find an outlet */
}  /* end fill_1() */


/* fill()       fill depression areas in hh array  */

int fill(PTYPE **hh, PTYPE **dt, U xsize, 
		    U ysize, PTYPE stepsize)
{
int x1, y1;
int x,y;
int xout=0;
int yout=0;
int r, i;
int lowest;
PTYPE mval, tval;

 for (y = 0; y < ysize; y++) {
    for (x = 0; x < xsize; x++)  {
	mval = Ehn(hh[0],x,y);          /* start with current point */
	lowest = TRUE;                   /* assume 0 */
	for (i = 1;i<9;i++) {          /* check -neighbors */
	  x1 = x+xo[i];
	  y1 = y+yo[i];
	  tval = Ehn(hh[0],x1,y1);   /* neighbor to x,y */
	  if (tval <= mval) {       /* neighbor lower? */
	    lowest = FALSE;             /* must not be a minimum then */
	  } /* end if */
	} /* end for i =1..9 */

	if (lowest == TRUE) {
	   printf("Filling at %d,%d with step %1.1e\n",x,y,stepsize);
	   r = fill_1(hh, dt, xsize, ysize, x, y, stepsize, &xout, &yout);
	   printf("Return value %d : (%d,%d)\n",r,xout,yout);
	}

   } /* end for ix */
 } /* end for iy */

 return(0);
}  /* end fill() */
