#include "surface.h"

#ifdef DEBUG
/* Check integrity of an object */
void check(objectdata *object)
{
   int count;
   patch *firstpatch = object->firstpatch,
         *lastpatch = object->lastpatch,
         *patchptr = NULL, *prevpatch = NULL;
   vertex *firstvertex = object->firstvertex,
          *lastvertex = object->lastvertex,
          *vertexptr = NULL, *prevvtx = NULL;

   /* Check patchlist */
   count = 1;
   patchptr = firstpatch;
   while ((patchptr != lastpatch) && (patchptr->next != NULL)) {
      prevpatch = patchptr;
      patchptr = patchptr->next;
      if (patchptr->previous != prevpatch)
        error ("Check: patchptr->previous does not point to preceding patch\n");
      count++;
   } 
   if (patchptr != lastpatch)
     error("Check: patchptr->next==NULL and patchptr!=lastpatch\n");
   if (patchptr->next != NULL)
     error("Check: lastpatch->next != NULL\n");
   if (count != object->numpatches)
     error("Check: object->numpatches does not match number of patches found\n");
   
   /* Check vertexlist */
   count = 1;
   vertexptr = firstvertex;
   while ((vertexptr != lastvertex) && (vertexptr->next != NULL)) {
      prevvtx = vertexptr;
      vertexptr = vertexptr->next;
      if (vertexptr->previous != prevvtx)
        error ("Check: vertexptr->previous does not point to preceding vertex\n");
      count++;
   } 
   if (vertexptr != lastvertex)
     error("Check: vertexptr->next==NULL and vertexptr!=lastvertex\n");
   if (vertexptr->next != NULL)
     error("Check: lastvertex->next != NULL\n");
   if (count != object->numvertices)
     error("Check: object->numvertices does not match number of vertices found\n")
;
}
#endif
