#include "surface.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>

/* Scope of these variables limited to this source file */
static patch *select1 = NULL;

/* These are needed to catch CR in Load/Save boxes */
static String translate_table = "#override\n <Key>Return:            carriagereturn()\n ";
static XtActionsRec acntable[]= {{"carriagereturn", carriagereturn}};


void destroypopup(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget popup = XtParent((Widget) client_data);

   XtDestroyWidget(popup);
}

void popupexitbox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget exitbutton, popupshell;
   Widget popupbox;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(exitbutton, args, n);
   XtTranslateCoords(exitbutton, (Position) (width / 2), 
                     (Position) (height / 2), &x, &y);
   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Exitshell", transientShellWidgetClass, 
                                   exitbutton, args, n);
   popupbox = XtCreateManagedWidget("Exitdialogue", dialogWidgetClass, 
                                     popupshell, NULL, 0);
   XawDialogAddButton(popupbox, "Yes", theend, NULL);
   XawDialogAddButton(popupbox, "No", destroypopup, (XtPointer) popupbox);
   XtPopup(popupshell, XtGrabExclusive);
}


void theend(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern XtAppContext app_context;
   extern objectdata *object;

   wipeobject(object);
   XtDestroyApplicationContext(app_context);
   printf("Goodbye\n");
   exit(0);
}

void popupsetviewbox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget popupshell, viewbutton, xbutton, ybutton, zbutton;

   Widget popupbox, applybutton;
   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(viewbutton, args, n);
   XtTranslateCoords(viewbutton, (Position) (width / 2), 
                     (Position) (height / 2), &x, &y);
   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Setviewshell", transientShellWidgetClass, 
                                   viewbutton, args, n);
   popupbox = XtCreateManagedWidget("Viewbox", boxWidgetClass, popupshell, 
                                    NULL, 0);
   xbutton = XtCreateManagedWidget("View X Axis", commandWidgetClass, popupbox,
                                    NULL, 0);
   ybutton = XtCreateManagedWidget("View Y Axis", commandWidgetClass, popupbox,
                                    NULL, 0);
   zbutton = XtCreateManagedWidget("View Z Axis", commandWidgetClass, popupbox,
                                    NULL, 0);
   applybutton = XtCreateManagedWidget("Done", commandWidgetClass, popupbox, 
                                       NULL, 0);

   /* Add callbacks */
   XtAddCallback(xbutton, XtNcallback, xview, NULL);
   XtAddCallback(ybutton, XtNcallback, yview, NULL);
   XtAddCallback(zbutton, XtNcallback, zview, NULL);
   XtAddCallback(applybutton, XtNcallback, destroypopup, (XtPointer) popupbox);

   XtPopup(popupshell, XtGrabExclusive);
}

void xview(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern FLOATTYPE theta, phi;
   extern objectdata *object;

   theta = 0;
   phi = M_PI / 2;

   calctransform(object);
   calccontrol(object);
   drawcontrol(object);
   displaybezier(object);
}

void yview(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern FLOATTYPE theta, phi;
   extern objectdata *object;

   theta = M_PI / 2;
   phi = M_PI / 2;

   calctransform(object);
   calccontrol(object);
   drawcontrol(object);
   displaybezier(object);
}

void zview(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern FLOATTYPE theta, phi;
   extern objectdata *object;

   theta = M_PI / 2;
   phi = 0;

   calctransform(object);
   calccontrol(object);
   drawcontrol(object);
   displaybezier(object);
}

void defaultvalues(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern FLOATTYPE r, theta, phi, vpdist;
   extern objectdata *object;

   r = DEFAULTR;
   theta = DEFAULTTHETA;
   phi = DEFAULTPHI;
   vpdist = DEFAULTVPDIST;

   calctransform(object);
   calccontrol(object);
   drawcontrol(object);
   displaybezier(object);
}

void increase(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern int numlines;
   extern objectdata *object;

   Widget popup = (Widget) client_data;
   Arg args[1];
   char buf[FLOATLENGTH];
   int f;

   f = numlines;
   if (f < MAXNUMLINES)
      f += 1;
   numlines = f;

   XtSetArg(args[0], XtNlabel, buf);
   sprintf(buf, "%d", f);
   XtSetValues(popup, args, 1);

   /* Update displays */
   calcmatrices(numlines);
   calcbezier(object);
   calccontrol(object);
   drawcontrol(object);
   displaybezier(object);
}

void decrease(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern int numlines;
   extern objectdata *object;

   Widget popup = (Widget) client_data;
   Arg args[1];
   char buf[FLOATLENGTH];
   int f;

   f = numlines;
   if (f > 3)
      f -= 1;
   numlines = f;

   XtSetArg(args[0], XtNlabel, buf);
   sprintf(buf, "%d", f);
   XtSetValues(popup, args, 1);

   /* Update displays */
   calcmatrices(numlines);
   calcbezier(object);
   calccontrol(object);
   drawcontrol(object);
   displaybezier(object);
}

void setvalue(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget popupshell;
   extern int numlines;
   Widget popupbox;
   Arg args[5], args2[1];
   Position x, y;
   Dimension width, height;
   Cardinal n;
   char buf[FLOATLENGTH];
   int f;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(w, args, n);
   XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2), 
                     &x, &y);
   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Setvalueshell", transientShellWidgetClass, 
                                   w, args, n);
   popupbox = XtCreateManagedWidget("Setvaluedialogue", dialogWidgetClass, 
                                    popupshell, NULL, 0);
   XawDialogAddButton(popupbox, "+", increase, (XtPointer) popupbox);
   XawDialogAddButton(popupbox, "-", decrease, (XtPointer) popupbox);
   XawDialogAddButton(popupbox, "Done", destroypopup, (XtPointer) popupbox);

   f = numlines;

   XtPopup(popupshell, XtGrabExclusive);

   XtSetArg(args2[0], XtNlabel, buf);
   sprintf(buf, "%d", f);
   XtSetValues(popupbox, args2, 1);
}

void popupdispitemsbox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget popupshell, dispitemsbutton;
   Widget popupbox, allbutton, currentbutton;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(dispitemsbutton, args, n);
   XtTranslateCoords(dispitemsbutton, (Position) (width / 2), 
                     (Position) (height / 2), &x, &y);
   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Dispitemsshell", transientShellWidgetClass,
                                   dispitemsbutton, args, n);
   popupbox = XtCreateManagedWidget("Dispitemsbox", boxWidgetClass, popupshell,
                                   NULL, 0);
   allbutton = XtCreateManagedWidget("Display All Patches", commandWidgetClass,
                                     popupbox, NULL, 0);
   currentbutton = XtCreateManagedWidget("Display Active Patch", 
                                         commandWidgetClass, popupbox, NULL, 0);

   /* Add callbacks */
   XtAddCallback(allbutton, XtNcallback, allmode, NULL);
   XtAddCallback(allbutton, XtNcallback, destroypopup, (XtPointer) popupbox);
   XtAddCallback(currentbutton, XtNcallback, currentmode, NULL);
   XtAddCallback(currentbutton, XtNcallback, destroypopup, 
                 (XtPointer) popupbox);

   XtPopup(popupshell, XtGrabExclusive);
}

void allmode(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Itemsmode itemsmode;
   extern objectdata *object;

   itemsmode = ALL;
   updatestatus(0, "Displaying all patches");
   drawcontrol(object);
   calcbezier(object);
   displaybezier(object);
}

void currentmode(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Itemsmode itemsmode;
   extern objectdata *object;

   itemsmode = CURRENT;
   updatestatus(0, "Displaying selected patch only");
   displaybezier(object);
   drawcontrol(object);
}

void popupcontinuitybox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget popupshell, continuitybutton;
   Widget popupbox, zerothbutton, firstbutton;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(continuitybutton, args, n);
   XtTranslateCoords(continuitybutton, (Position) (width / 2), 
                     (Position) (height / 2), &x, &y);

   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Continuityshell", transientShellWidgetClass,
                                   continuitybutton, args, n);
   popupbox = XtCreateManagedWidget("Continuitybox", boxWidgetClass, popupshell,
                                    NULL, 0);
   zerothbutton = XtCreateManagedWidget("Positional", commandWidgetClass, 
                                        popupbox, NULL, 0);
   firstbutton = XtCreateManagedWidget("Tangential", commandWidgetClass, 
                                       popupbox, NULL, 0);

   /* Add callbacks */
   XtAddCallback(zerothbutton, XtNcallback, zerothmode, NULL);
   XtAddCallback(zerothbutton, XtNcallback, destroypopup, (XtPointer) popupbox);
   XtAddCallback(firstbutton, XtNcallback, firstmode, NULL);
   XtAddCallback(firstbutton, XtNcallback, destroypopup, (XtPointer) popupbox);

   XtPopup(popupshell, XtGrabExclusive);
}

void zerothmode(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Continuitymode continuitymode;

   updatestatus(1, "Maintaining positional continuity only");
   continuitymode = ZEROTH;
}

void firstmode(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Continuitymode continuitymode;

   updatestatus(1, "Maintaining positional & tangential continuity");
   continuitymode = FIRST;
}

void popupclearbox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget popupshell, clearbutton;
   Widget popupbox;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(clearbutton, args, n);
   XtTranslateCoords(clearbutton, (Position) (width / 2), 
                     (Position) (height / 2), &x, &y);

   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Clearshell", transientShellWidgetClass, 
                                   clearbutton, args, n);
   popupbox = XtCreateManagedWidget("Cleardialogue", dialogWidgetClass, 
                                    popupshell, NULL, 0);
   XawDialogAddButton(popupbox, "Yes", clear, (XtPointer) popupbox);
   XawDialogAddButton(popupbox, "No", destroypopup, (XtPointer) popupbox);
   XtPopup(popupshell, XtGrabExclusive);
}

void clear(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern objectdata *object;
   Widget popup = XtParent((Widget) client_data);

   wipeobject(object);
   object = initobject();

   calctransform(object);
   calccontrol(object);
   drawcontrol(object);
   calcbezier(object);
   displaybezier(object);
   drawconnectivity(object);

   XtDestroyWidget(popup);
}

void popupsavebox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget popupshell, savebutton;
   extern XtActionsRec acntable[];
   extern XtAppContext app_context;
   Widget popupbox, dobutton, cancelbutton, textentry;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(savebutton, args, n);
   XtTranslateCoords(savebutton, (Position) (width / 2), 
                     (Position) (height / 2), &x, &y);

   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Saveshell", transientShellWidgetClass, 
                                   savebutton, args, n);
   popupbox = XtCreateManagedWidget("Savebox", boxWidgetClass, popupshell, 
                                    NULL, 0);
   textentry = XtCreateManagedWidget("Text", asciiTextWidgetClass, popupbox, 
                                     NULL, 0);
   dobutton = XtCreateManagedWidget("OK", commandWidgetClass, popupbox, 
                                    NULL, 0);
   cancelbutton = XtCreateManagedWidget("Cancel", commandWidgetClass, popupbox, 
                                        NULL, 0);

   /* Add callbacks */
   XtAddCallback(dobutton, XtNcallback, save, (XtPointer) textentry);
   XtAddCallback(cancelbutton, XtNcallback, destroypopup, (XtPointer) popupbox);

   XtOverrideTranslations(textentry, XtParseTranslationTable(translate_table));
   XtAppAddActions(app_context, acntable, 1);

   XtPopup(popupshell, XtGrabExclusive);
}

void save(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget text = (Widget) client_data;
   Arg args[1];
   String str;

   XtSetArg(args[0], XtNstring, &str);
   XtGetValues(text, args, (Cardinal) 1);

   if (saveobject(str))
      destroypopup(NULL, XtParent(w), NULL);
}

void popuploadbox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget popupshell, loadbutton;
   extern XtActionsRec acntable[];
   extern XtAppContext app_context;
   Widget popupbox, dobutton, cancelbutton, textentry;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(loadbutton, args, n);
   XtTranslateCoords(loadbutton, (Position) (width / 2), 
                     (Position) (height / 2), &x, &y);

   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Loadshell", transientShellWidgetClass, 
                                   loadbutton, args, n);
   popupbox = XtCreateManagedWidget("Loadbox", boxWidgetClass, popupshell, 
                                    NULL, 0);
   textentry = XtCreateManagedWidget("Text", asciiTextWidgetClass, popupbox, 
                                     NULL, 0);
   dobutton = XtCreateManagedWidget("OK", commandWidgetClass, popupbox, 
                                    NULL, 0);
   cancelbutton = XtCreateManagedWidget("Cancel", commandWidgetClass, popupbox,
                                        NULL, 0);

   /* Add callbacks */
   XtAddCallback(dobutton, XtNcallback, load, (XtPointer) textentry);
   XtAddCallback(cancelbutton, XtNcallback, destroypopup, (XtPointer) popupbox);

   XtOverrideTranslations(textentry, XtParseTranslationTable(translate_table));
   XtAppAddActions(app_context, acntable, 1);

   XtPopup(popupshell, XtGrabExclusive);
}

void load(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget text = (Widget) client_data;
   Arg args[1];
   String str;
   extern objectdata *object;

   XtSetArg(args[0], XtNstring, &str);
   XtGetValues(text, args, (Cardinal) 1);

   if (loadobject(str)) {
      destroypopup(NULL, XtParent(w), NULL);
      calctransform(object);
      calccontrol(object);
      drawcontrol(object);
      calcbezier(object);
      displaybezier(object);
      drawconnectivity(object);
   }
}

void popupdelpatchbox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget connectivity, popupshell;
   Widget popupbox;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(connectivity, args, n);
   XtTranslateCoords(connectivity, (Position) ((width / 2) - 100), 
                     (Position) (height / 2), &x, &y);

   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Delpatchshell", transientShellWidgetClass, 
                                   connectivity, args, n);
   popupbox = XtCreateManagedWidget("DelDialogue", dialogWidgetClass, 
                                    popupshell, NULL, 0);
   XawDialogAddButton(popupbox, "Yes", delete, (XtPointer) popupbox);
   XawDialogAddButton(popupbox, "No", dontdelete, (XtPointer) popupbox);
   XtPopup(popupshell, XtGrabExclusive);
}

void delete(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern objectdata *object;

   bool orphan = FALSE;
   patch *patchptr;

   destroypopup(NULL, client_data, NULL);

   /* Check that deleting patch will not create disconnected object */
   /* Firstly set all the visited flags to FALSE */
   unvisit(object);

   /* Mark all patches reachable without the patch to be deleted */
   if (select1 != object->firstpatch)
      tracevisit(object->firstpatch, select1);
   else
      tracevisit(object->lastpatch, select1);

   /* Check if any patch was left unmarked */
   patchptr = object->firstpatch;
   do {
      if (!patchptr->visited)
         orphan = TRUE;
      patchptr = patchptr->next;
   }
   while (patchptr != NULL);

   /* If orphan is FALSE then go ahead with the deletion */
   if (!orphan) {
      deletepatch(object, select1);

      /* Recalculate bounds and update displays */
      findworldbounds(object);
      getconnectivitybounds(object);
      drawconnectivity(object);
      calctransform(object);
      calccontrol(object);
      drawcontrol(object);
      displaybezier(object);
       
      #ifdef DEBUG
        check(object);
      #endif
   }
   else
      printstatus("Delete: Cannot produce disconnected object.");

}

void dontdelete(Widget w, XtPointer client_data, XtPointer call_data)
{
   destroypopup(NULL, client_data, NULL);
}

void popupaddpatchbox(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget connectivity, popupshell;
   Widget popupbox, yesbutton, nobutton;

   Arg args[5];
   Position x, y;
   Dimension width, height;
   Cardinal n;

   /*
    * This will position the upper left hand corner of the popup at the
    * center of the widget which invoked this callback, which will also
    * become the parent of the popup.  I don't deal with the possibility
    * that the popup will be all or partially off the edge of the
    * screen.
    */

   n = 0;
   XtSetArg(args[0], XtNwidth, &width);
   n++;
   XtSetArg(args[1], XtNheight, &height);
   n++;
   XtGetValues(connectivity, args, n);
   XtTranslateCoords(connectivity, (Position) ((width / 2) - 60), 
                     (Position) (height / 2), &x, &y);

   n = 0;
   XtSetArg(args[n], XtNx, x);
   n++;
   XtSetArg(args[n], XtNy, y);
   n++;

   popupshell = XtCreatePopupShell("Addpatchshell", transientShellWidgetClass, 
                                   connectivity, args, n);
   popupbox = XtCreateManagedWidget("AddDialogue", dialogWidgetClass, 
                                    popupshell, NULL, 0);
   yesbutton =  XtCreateManagedWidget("Yes", commandWidgetClass, 
                                     popupbox, NULL, 0);
   nobutton = XtCreateManagedWidget("No", commandWidgetClass, 
                                     popupbox, NULL, 0);

   XtAddCallback(yesbutton, XtNcallback, add, client_data);
   XtAddCallback(nobutton, XtNcallback, dontadd, NULL);

   XtPopup(popupshell, XtGrabExclusive);
}

void add(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern objectdata *object;
  
   destroypopup(NULL, XtParent(w), NULL);

   if (createpatch(&object, (connectpoint *) client_data)) {
      findworldbounds(object);
      calctransform(object);
      drawconnectivity(object);
      calccontrol(object);
      drawcontrol(object);
      calcbezier(object);
      displaybezier(object);
      #ifdef DEBUG
        check(object);
      #endif
   }
}

void dontadd(Widget w, XtPointer client_data, XtPointer call_data)
{
   destroypopup(NULL, XtParent(w), NULL);
}


/* Deal with events occuring in control window */
void controlclicked(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern objectdata *object;
   extern Continuitymode continuitymode;
   extern FLOATTYPE theta, phi, vpdist;
   extern windowdata cpwindow;
   extern vector R;

   static bool dragging = FALSE;
   static Position lastx, lasty;
   static joindata join;
   static FLOATTYPE vpratio;

   XEvent *event;
   Position x, y, xdrag, ydrag;
   int i, j;
   static int col, row;
   vector change;
   patch *currentpatch = object->currentpatch;
   bool shift;

   /* Get event information */
   event = (XEvent *) call_data;
   /* Get pointer coordinates */
   x = event->xbutton.x;
   y = event->xbutton.y;
   /* Get shift key state */
   shift = event->xbutton.state & ShiftMask;

   switch (event->type) {
        /* Deal with ButtonPress event */
     case ButtonPress:
        if (nearestpoint(x, y, &col, &row)) {
           dragging = TRUE;
           formjoinstruct(currentpatch, col, row, &join);
           lastx = x;
           lasty = y;
           vpratio = (currentpatch->data[col][row]->screen.z / vpdist);
        }
        break;

        /* Deal with Dragging */
     case MotionNotify:
        if (dragging) {          /* Animate control display during dragging */
           xdrag = x - lastx;
           ydrag = y - lasty;
           lastx = x;
           lasty = y;

           /* If shift depressed then move points along line of sight */
           if (shift) {
              for (i = 0; i < 3; i++)
                 change[i] = currentpatch->data[col][row]->world[i] - R[i];
              normalise(change);
              for (i = 0; i < 3; i++)
                 change[i] *= ydrag / ZSENSITIVITY;
           } else {                        

           /* Otherwise, move with pointer */
             change[0] = vpratio * ((xdrag / cpwindow.scale) * (-SIN(theta)) 
                          - (ydrag / cpwindow.scale) * (-COS(phi) * COS(theta)));
                change[1] = vpratio * ((xdrag / cpwindow.scale) * (COS(theta)) 
                          - (ydrag / cpwindow.scale) * (-COS(phi) * SIN(theta)));
                 change[2] = - vpratio * (ydrag / cpwindow.scale) * (SIN(phi));
           }

           /* If tangential continuity required AND corner is  not shared */
           if ((continuitymode == FIRST) && 
                (join.vertexptr[1][1]->occurrences > 1)) {
              /* Move groups of points in order to maintain continuity */
              fixcontinuity(col, row, change, &join);
              for (i = 0; i < 3; i++)
                 for (j = 0; j < 3; j++)
                    if (join.vertexptr[i][j] != NULL) {
                       movepoint(join.vertexptr[i][j], join.move[i][j]);
                       transformpoint(join.vertexptr[i][j], &cpwindow);
                    }
           } else {
              /* Move single points */
              movepoint(currentpatch->data[col][row], change);
              transformpoint(currentpatch->data[col][row], &cpwindow);
           }

           /*
            * Update control display only, and without
            * recalculating
            */
           drawcontrol(object);
        }
        break;

        /* Deal with ButtonRelease event */
     case ButtonRelease:
        if (dragging) {
           /* Update Bounding Box data */
           findworldbounds(object);

           /* Update Display */
           calctransform(object);
           calccontrol(object);
           drawcontrol(object);
           calcbezier(object);
           displaybezier(object);

           /* Reset dragging flag */
           dragging = FALSE;
        }
        break;

     /* Window resize, change scaling */
     case ConfigureNotify:
        cpwindow.width = event->xconfigure.width;
        cpwindow.height = event->xconfigure.height;
        cpwindow.scale = min(cpwindow.width, cpwindow.height) * SCALE;

        calccontrol(object);
        drawcontrol(object);
          
        break;
   }
}

/* Deal with events occuring in connectivity window */
void connectivityclicked(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern objectdata *object;
   extern GC gcclear; 
   extern Display *connectivitydisplay;
   extern Window connectivitywindow;
   extern windowdata cnwindow;
   extern Itemsmode itemsmode;

   static bool dragging = FALSE;
   static Position lastx, lasty, startx, starty;
   static direction edge;
   static connectpoint connect; 

   XEvent *event;
   Position x, y;
   FLOATTYPE posx, posy;
   patch *patchptr, *select2;
   bool shift;

   /* Get event information */
   event = (XEvent *) call_data;
   /* Get pointer coordinates */
   x = event->xbutton.x;
   y = event->xbutton.y;
   /* Get shift key state */
   shift = event->xbutton.state & ShiftMask;

   switch (event->type) {
        /* Deal with ButtonPress event */
     case ButtonPress:
        /*
         * Convert pointer coordinates to connectivity diagram
         * coordinates
         */
        posx = (x - object->connect.xcentre) / object->connect.scale;
        posy = (y - object->connect.ycentre) / object->connect.scale;
        connect.x = (int) floor(0.5 + posx);
        connect.y = (int) floor(0.5 + posy);

        /* Run through patch, find match */
        select1 = NULL;
        patchptr = object->firstpatch;
        do {
           if ((patchptr->connectpos.x == connect.x) && 
                (patchptr->connectpos.y == connect.y))
              select1 = patchptr;
           patchptr = patchptr->next;
        }
        while ((patchptr != NULL) && (select1 == NULL));

        /* If button clicked inside a box... */
        if (select1 != NULL) {
           /*
            * Determine edge closest to pointer position, check
            * that it is not already connected to another patch,
            * and set startx, starty to be coordinates of middle
            * of edge
            */
           if ((posx - connect.x) < (posy - connect.y)) {
              if ((posx - connect.x) < -(posy - connect.y)) {
                 edge = W;
                 if (select1->w == NULL) {
                    startx = (Position) connect.x *object->connect.scale 
                             + object->connect.xcentre 
                             - object->connect.scale / 2 + BOXGAP;
                    starty = (Position) connect.y *object->connect.scale 
                             + object->connect.ycentre;

                    dragging = TRUE;
                 }
              } else {
                 edge = N;
                 if (select1->n == NULL) {
                    startx = (Position) connect.x *object->connect.scale 
                             + object->connect.xcentre;
                    starty = (Position) connect.y *object->connect.scale 
                             + object->connect.ycentre 
                             + object->connect.scale / 2 - BOXGAP;

                    dragging = TRUE;
                 }
              }
           } else {
              if ((posx - connect.x) < -(posy - connect.y)) {
                 edge = S;
                 if (select1->s == NULL) {
                    startx = (Position) connect.x *object->connect.scale 
                             + object->connect.xcentre;
                    starty = (Position) connect.y *object->connect.scale 
                             + object->connect.ycentre 
                             - object->connect.scale / 2 + BOXGAP;

                    dragging = TRUE;
                 }
              } else {
                 edge = E;
                 if (select1->e == NULL) {
                    startx = (Position) connect.x *object->connect.scale 
                             + object->connect.xcentre 
                             + object->connect.scale / 2 - BOXGAP;
                    starty = (Position) connect.y *object->connect.scale 
                             + object->connect.ycentre;

                    dragging = TRUE;
                 }
              }
           }

           /* Make box in which pointer pressed currentpatch */
           object->currentpatch = select1;
           drawconnectivity(object);
        }
        if (dragging) {          /* Draw line from edge to pointer */
           lastx = x;
           lasty = y;
           XDrawLine(connectivitydisplay, connectivitywindow, gcclear, startx, starty, lastx, lasty);
        }
        break;

        /* Deal with MotionNotify event */
     case MotionNotify:
        if (dragging) {
           XDrawLine(connectivitydisplay, connectivitywindow, gcclear, startx, starty, lastx, lasty);
           lastx = x;
           lasty = y;
           XDrawLine(connectivitydisplay, connectivitywindow, gcclear, startx, starty, x, y);
        }
        break;

        /* Deal with ButtonRelease event */
     case ButtonRelease:
        /*
         * Convert pointer coordinates to connectivity diagram
         * coordinates
         */
        posx = (x - object->connect.xcentre) / object->connect.scale;
        posy = (y - object->connect.ycentre) / object->connect.scale;
        connect.x = (int) floor(0.5 + posx);
        connect.y = (int) floor(0.5 + posy);

        /* Run through patch, find match */
        select2 = NULL;
        patchptr = object->firstpatch;
        do {
           if ((patchptr->connectpos.x == connect.x) && 
               (patchptr->connectpos.y == connect.y))
              select2 = patchptr;
           patchptr = patchptr->next;
        }
        while ((patchptr != NULL) && (select2 == NULL));

        /* If shift depressed, then... */
        if (shift) {
           if (select2 != NULL)  /* Pointer was inside a box - 
                                  * delete patch */
              popupdelpatchbox(NULL, NULL, NULL);
           else                  /* Attempt to create patch in that space */
              popupaddpatchbox(NULL, (XtPointer) &connect, NULL);
           dragging = FALSE;
           return;
        }
        /* If user was dragging... */
        if (dragging) {
           /* XOR out the last line and reset the dragging flag */
           XDrawLine(connectivitydisplay, connectivitywindow, gcclear, startx, starty, lastx, lasty);
           dragging = FALSE;

           /*
            * Check that corresponding edge in select2 is not
            * connected to another, and that connection is valid
            */
           if ((select2 != NULL) && (select1 != select2)) {
              switch (edge) {
                case N:
                   if (select2->s == NULL)
                      connectpatches(&object, NS, select2, select1);
                   break;
                case S:
                   if (select2->n == NULL)
                      connectpatches(&object, NS, select1, select2);
                   break;
                case E:
                   if (select2->w == NULL)
                      connectpatches(&object, EW, select2, select1);
                   break;
                case W:
                   if (select2->e == NULL)
                      connectpatches(&object, EW, select1, select2);
                   break;
              }

              #ifdef DEBUG
                check(object);
              #endif

           }
        }
        if (select2 != NULL) {
           object->currentpatch = select2;
           drawconnectivity(object);
           drawcontrol(object);
           if (itemsmode == CURRENT)
              displaybezier(object);
        }
        break;

     /* Window resize, change scaling */
     case ConfigureNotify:
        cnwindow.width = event->xconfigure.width;
        cnwindow.height = event->xconfigure.height;
        cnwindow.scale = min(cnwindow.width, cnwindow.height) * SCALE;

        drawconnectivity(object);
          
        break;
   }
}

/* Deal with events passed to Bezier canvas widget */
void bezierclicked(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern FLOATTYPE theta, phi, r;
   extern objectdata *object;
   extern windowdata bswindow;

   static bool dragging = FALSE;
   static Position lastx, lasty;

   XEvent *event;
   Position x, y, xdrag, ydrag;
   bool shift;

   event = (XEvent *) call_data;
   x = event->xbutton.x;
   y = event->xbutton.y;
   shift = event->xbutton.state & ShiftMask;

   switch (event->type) {
     /* Button pressed */
     case ButtonPress:
        /* Set dragging flag, store old pointer coordinates */
        lastx = x;
        lasty = y;
        dragging = TRUE;
        break;
     /* Dragging */
     case MotionNotify:
        if (dragging) {
           xdrag = x - lastx;
           ydrag = y - lasty;

           if (shift) {
              r -= ydrag / ZSENSITIVITY;
           } else {
              theta -= 2 * M_PI * xdrag / bswindow.width;
              phi -= 2 * M_PI * ydrag / bswindow.height;
           }

           calctransform(object);
           calccontrol(object);
           drawcontrol(object);
#ifdef UPDATEBEZIER
           displaybezier(object);
#endif
           lastx = x;
           lasty = y;
        }
        break;
     /* Button Released */
     case ButtonRelease:
        if (dragging) {
           calctransform(object);
           calccontrol(object);
           drawcontrol(object);
           displaybezier(object);

           dragging = FALSE;
        }
        break;
     /* Window resize, change scaling */
     case ConfigureNotify:
        bswindow.width = event->xconfigure.width;
        bswindow.height = event->xconfigure.height;
        bswindow.scale = min(bswindow.width, bswindow.height) * SCALE;

        displaybezier(object);

        break;
   }
}

