#SPEC -realname ''open a curve''

# no shape
if {[llength [.amapi scene]] == 0} return

# it's not a curve
newshape shape [.amapi current]
if {[shape -curve] == 0} return

# curve has to be closed
set closed [shape -closed]
if {$closed == 0} return

# call tool placepoint
set result [placepoint]
#set orig [.match $result - -point3d]
set orig $result

# user canceled ruler
if {$orig == ""} return

# verify origin belongs to curve
set points [shape -points]
set numpts [llength $points]
for {set i 0} {$i < $numpts} {incr i} {
	if {[vertex dist [lindex $points $i] $orig] == 0} break
}
if {$i == $numpts} return
set index $i

#calculate new shape
newshape result {
	addpoint [lindex $points $index]
	set ind [expr {$index + 1}]
	for {set i 0} {$i < $numpts} {incr i} {
		if {$ind == $numpts} {
			set ind 0
		}
		
		addpoint [lindex $points $ind]
		
		incr ind
	}
}
result -status open
shape -checkout
result -checkin
